using System;
using System.Collections;
	
namespace Evolution {
	public class CalComponent {

		string uid;
		string recurid;
		ArrayList attendees;
		ArrayList comments;
		ArrayList descriptions;
		ArrayList categories;
		ArrayList location;
		ArrayList summaries;
		DateTime dtStart;
		DateTime dtEnd;
		DateTime last_modified;
		DateTime dtstamp;
		DateTime created;
		Cal ecal;
		CalRecurrence[] rrules;
		CalRecurrence[] exrules;

		public CalComponent ()
		{
			uid = null;
			recurid = null;
			attendees = new ArrayList ();
			comments = new ArrayList ();
			descriptions = new ArrayList ();
			categories = new ArrayList ();
			location = new ArrayList ();
			summaries = new ArrayList ();
			ecal = null;
			rrules = null;
			exrules = null;
		}

		public string Uid {
			get {
				return uid;
			}

			set {
				uid = value;
			}
		}

		public string RecurId {
			get {
				return recurid;
			}

			set {
				recurid = value;
			}
		}

		public string[] Attendees {
			get {
				return (string[]) attendees.ToArray (typeof (string));
			}
			
			set {
				attendees.AddRange (value);
			}
		}

		public string[] Comments {
			get {
				return (string [])comments.ToArray (typeof (string));
			}
			
			set {
				comments.AddRange (value);
			}
		}

		public string[] Descriptions {
			get {
				return (string [])descriptions.ToArray (typeof (string));
			}
			
			set {
				descriptions.AddRange (value);
			}
		}

		public string[] Summaries {
			get {
				return (string [])summaries.ToArray (typeof (string));
			}
			
			set {
				summaries.AddRange (value);
			}
		}

		public string[] Categories {
			get {
				return (string [])categories.ToArray (typeof (string));
			}
			
			set {
				categories.AddRange (value);
			}
		}

		public string[] Location {
			get {
				return (string [])location.ToArray (typeof (string));
			}
			
			set {
				location.AddRange (value);
			}
		}

		public System.DateTime Dtstart {
			get {
				return dtStart;
			}
			
			set {
				dtStart = value;
			}
		}

		public System.DateTime Dtend {
			get {
				return dtEnd;
			}
			
			set {
				dtEnd = value;
			}
		}

		public System.DateTime LastModified {
			get {
				return last_modified;
			}
			
			set {
				last_modified = value;
			}
		}

		public System.DateTime Dtstamp {
			get {
				return dtstamp;
			}
			
			set {
				dtstamp = value;
			}
		}

		public System.DateTime Created {
			get {
				return created;
			}
			
			set {
				created = value;
			}
		}

		public Cal ECal {
			get {
				return ecal;
			}
			
			set {
				ecal = value;
			}
		}

		public Evolution.Source Source {
			get {
				if (ecal != null)
					return ecal.Source;
				else
					return null;
			}
		}

		public CalRecurrence[] RecurrenceRules {
			get {
				return rrules;
			}
			
			set {
				rrules = value;
			}
		}

		public CalRecurrence[] ExceptionRules {
			get {
				return exrules;
			}
			
			set {
				exrules = value;
			}
		}
	}
}
