#include <stdio.h>
#include <string.h>

#include <libbonobo.h>

#include "Evolution-DataServer-Mail.h"
#include "e-mail-remote-glue-utils.h"
#include "e-mail-remote-glue-messageinfo.h"
#include "e-mail-remote-glue-msgiter.h"

static void e_mail_remote_glue_msgiterator_class_init (EMailRemoteGlueMsgIteratorClass *klass);
static void e_mail_remote_glue_msgiterator_init (EMailRemoteGlueMsgIterator *comp, EMailRemoteGlueMsgIteratorClass *klass);
static void e_mail_remote_glue_msgiterator_finalize (GObject *object);

/*static guint e_mail_remote_signals[LAST_SIGNAL] = { 0 };*/

static GObjectClass *parent_class;

struct _EMailRemoteGlueMsgIteratorPrivate {
  Bonobo_Unknown iterator; /* Evolution_Mail_MessageIterator */
};

/**
 * e_mail_remote_glue_msgiterator_get_type:
 *
 * Registers the #EMailRemoteGlueMsgIterator class if necessary, and returns the type ID
 * associated to it.
 *
 * Return value: The type ID of the #EMailRemoteGlueMsgIterator class.
 **/
GType
e_mail_remote_glue_msgiterator_get_type (void)
{
  static GType e_mail_remote_glue_msgiterator_type = 0;

  if (!e_mail_remote_glue_msgiterator_type) {
    static GTypeInfo info = {
      sizeof (EMailRemoteGlueMsgIteratorClass),
      (GBaseInitFunc) NULL,
      (GBaseFinalizeFunc) NULL,
      (GClassInitFunc) e_mail_remote_glue_msgiterator_class_init,
      NULL, NULL,
      sizeof (EMailRemoteGlueMsgIterator),
      0,
      (GInstanceInitFunc) e_mail_remote_glue_msgiterator_init
    };
    e_mail_remote_glue_msgiterator_type = g_type_register_static (G_TYPE_OBJECT, "EMailRemoteGlueMsgIterator", &info, 0);
  }

  return e_mail_remote_glue_msgiterator_type;
}

/* Class initialization function for the calendar-glue object */
static void
e_mail_remote_glue_msgiterator_class_init (EMailRemoteGlueMsgIteratorClass *klass)
{
  GObjectClass *object_class;

  object_class = (GObjectClass *) klass;

  parent_class = g_type_class_peek_parent (klass);

  object_class->finalize = e_mail_remote_glue_msgiterator_finalize;
}

/* Object initialization function for the calendar-glue object */
static void
e_mail_remote_glue_msgiterator_init (EMailRemoteGlueMsgIterator *emrg_msgiter, EMailRemoteGlueMsgIteratorClass *klass)
{  
  emrg_msgiter->priv = g_new0 (EMailRemoteGlueMsgIteratorPrivate, 1);
}

/**
 * e_mail_remote_glue_msgiterator_new:
 *
 * Creates a new empty calendar-glue component object.  
 *
 * Return value: A newly-created calendar-glue component object.
 **/
EMailRemoteGlueMsgIterator *
e_mail_remote_glue_msgiterator_new (void)
{
  return E_MAIL_REMOTE_GLUE_MSGITERATOR (g_object_new (E_TYPE_MAIL_REMOTE_GLUE_MSGITERATOR, NULL));
}

/* Finalize handler for the calendar-glue component object */
static void
e_mail_remote_glue_msgiterator_finalize (GObject *object)
{
  EMailRemoteGlueMsgIterator *iter;
  EMailRemoteGlueMsgIteratorPrivate *priv;

  g_return_if_fail (object != NULL);
  g_return_if_fail (E_IS_MAIL_REMOTE_GLUE_MSGITERATOR (object));

  iter = E_MAIL_REMOTE_GLUE_MSGITERATOR (object);
  priv = iter->priv;

  if (priv) {
    bonobo_object_release_unref (priv->iterator, NULL);
    priv->iterator = NULL;

    g_free (priv);
    iter->priv = NULL;
  }
  
  if (G_OBJECT_CLASS (parent_class)->finalize)
    (* G_OBJECT_CLASS (parent_class)->finalize) (object);
}

EMailRemoteGlueMsgIterator*
e_mail_remote_glue_msgiterator_new_clone (EMailRemoteGlueMsgIterator* iter)
{
  CORBA_Environment ev = { 0 };
  EMailRemoteGlueMsgIterator* emrg_msgiter = e_mail_remote_glue_msgiterator_new ();
  EMailRemoteGlueMsgIteratorPrivate* priv = emrg_msgiter->priv;

  priv->iterator = bonobo_object_dup_ref (iter->priv->iterator, &ev);
  /* FIXME: Error handling */
  
  return emrg_msgiter;
}


EMailRemoteGlueMsgIterator*
e_mail_remote_glue_msgiterator_new_from_EMMsgIterator (Evolution_Mail_MessageIterator iter)
{
  EMailRemoteGlueMsgIterator* emrg_msgiter = e_mail_remote_glue_msgiterator_new ();
  EMailRemoteGlueMsgIteratorPrivate* priv = emrg_msgiter->priv;
  CORBA_Environment ev = { 0 };

  priv->iterator = bonobo_object_dup_ref (iter, &ev);
  /* FIXME: Error handling */
  
  return emrg_msgiter;
}

Evolution_Mail_MessageIterator 
e_mail_remote_glue_msgiterator_peek_iterator (EMailRemoteGlueMsgIterator* iter)
{
  g_return_val_if_fail (iter != NULL, NULL);
  g_return_val_if_fail (iter->priv != NULL, NULL);

  return iter->priv->iterator;
}

GSList*
e_mail_remote_glue_msgiterator_get_next (EMailRemoteGlueMsgIterator* emrg_msgiter, 
					 int count)
{
  EMailRemoteGlueMsgIteratorPrivate* priv = emrg_msgiter->priv;
  Evolution_Mail_MessageInfos *msgs;
  Evolution_Mail_MessageIterator iter = NULL;
  CORBA_Environment ev = { 0 };
  GSList* emrg_msginfo_list = NULL;
  int i;
    
  iter = priv->iterator;
  if (count == -1)
    count = 50;

  msgs = Evolution_Mail_MessageIterator_next(iter, count, &ev);
  if (ev._major != CORBA_NO_EXCEPTION) {
    e_mail_exception_dump(&ev, "getting next messages");
    return emrg_msginfo_list;
  }
    
  for (i = 0; i < msgs->_length; i++) {
    EMailRemoteGlueMessageInfo* emrg_msginfo = NULL;
    emrg_msginfo = e_mail_remote_glue_messageinfo_new_from_EMMessageInfo (msgs->_buffer[i]);
    emrg_msginfo_list = g_slist_prepend (emrg_msginfo_list, emrg_msginfo);
  }
    
#if 0
  for (i=0;i<msgs->_length;i++) {
    printf("uid: %s  '%s'\n", msgs->_buffer[i].uid, msgs->_buffer[i].subject);
  }
#endif
  CORBA_free(msgs);

  if (emrg_msginfo_list)
    emrg_msginfo_list = g_slist_reverse (emrg_msginfo_list);

  return emrg_msginfo_list;  
}
