/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 8; tab-width: 8 -*- */
/***************************************************************************
 *            e-kolab-folder-metadata.h
 *
 *  Fri Feb 10 11:16:05 2012
 *  Copyright  2012  Christian Hilberg
 *  <hilberg@kernelconcepts.de>
 *
 ****************************************************************************/

/*
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor Boston, MA 02110-1301,  USA
 */

/*----------------------------------------------------------------------------*/

#ifndef _E_KOLAB_FOLDER_METADATA_H_
#define _E_KOLAB_FOLDER_METADATA_H_

/*----------------------------------------------------------------------------*/

#include <glib.h>
#include <gtk/gtk.h>

#include <shell/e-shell-view.h>
#include <misc/e-alert-bar.h>

#include <libekolab/kolab-data-folder-metadata.h>

/*----------------------------------------------------------------------------*/

typedef struct _KolabFolderMetaUIWidgets KolabFolderMetaUIWidgets;
struct _KolabFolderMetaUIWidgets {
	GtkWidget *container;
	/* sub-widgets of container - folder type */
	GtkWidget *frame_type_select;
	GSList *radio_group;
	GtkWidget *radio_btn_type_mail;
	GtkWidget *radio_btn_type_calendar;
	GtkWidget *radio_btn_type_memos;
	GtkWidget *radio_btn_type_tasks;
	GtkWidget *radio_btn_type_contacts;
	/* sub-widgets of container - folder options */
	GtkWidget *frame_options;
	GtkWidget *chk_btn_show_all;
};

typedef struct _KolabFolderMetaUIData KolabFolderMetaUIData;
struct _KolabFolderMetaUIData {
	EShellView *shell_view;
	EAlertBar *alert_bar;
	KolabFolderMetaUIWidgets *widgets;
	KolabDataFolderMetadata *metadata;
	gchar *foldername;
	gchar *sourcename;
};

/*----------------------------------------------------------------------------*/

KolabFolderMetaUIData*
e_kolab_folder_metadata_ui_new (void);

void
e_kolab_folder_metadata_ui_free (KolabFolderMetaUIData *uidata);

void
e_kolab_folder_metadata_ui_update_from_uidata (KolabFolderMetaUIData *uidata);

gboolean
e_kolab_folder_metadata_ui_query_metadata (KolabFolderMetaUIData *uidata,
                                           GCancellable *cancellable,
                                           GError **err);

/*----------------------------------------------------------------------------*/

#endif /* _E_KOLAB_FOLDER_METADATA_H_ */

/*----------------------------------------------------------------------------*/
