/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 8; tab-width: 8 -*- */
/***************************************************************************
 *            e-kolab-folder-metadata.c
 *
 *  Fri Feb 10 11:25:05 2012
 *  Copyright  2012  Christian Hilberg
 *  <hilberg@kernelconcepts.de>
 *
 ****************************************************************************/

/*
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor Boston, MA 02110-1301,  USA
 */

/*----------------------------------------------------------------------------*/

#include <config.h>

#include <glib/gi18n-lib.h>

#include "e-kolab-folder-metadata.h"

/*----------------------------------------------------------------------------*/
/* internal statics (non-UI) */


/*----------------------------------------------------------------------------*/
/* internal statics (UI) */


/*----------------------------------------------------------------------------*/
/* API functions (non-UI) */


/*----------------------------------------------------------------------------*/
/* API functions (UI) */

KolabFolderMetaUIData*
e_kolab_folder_metadata_ui_new (void)
{
	KolabFolderMetaUIData *uidata = g_new0 (KolabFolderMetaUIData, 1);
	GtkWidget *widget = NULL;
	GtkWidget *grid = NULL;
	GtkWidget *btn_loco = NULL;
	GtkWidget *btn = NULL;

	uidata->shell_view = NULL;
	uidata->alert_bar = NULL;

	uidata->widgets = g_new0 (KolabFolderMetaUIWidgets, 1);

	grid = gtk_grid_new ();
	gtk_orientable_set_orientation (GTK_ORIENTABLE (grid), GTK_ORIENTATION_VERTICAL);
	gtk_container_set_border_width (GTK_CONTAINER (grid), 16);
	uidata->widgets->container = grid;

	/* Folder type radio button group */

	widget = gtk_frame_new (C_("Kolab Folder Metadata",
	                           "Folder Type (Annotation)"));
	gtk_container_set_border_width (GTK_CONTAINER (widget), 6);
	gtk_container_add (GTK_CONTAINER (uidata->widgets->container), widget);
	uidata->widgets->frame_type_select = widget;

	grid = gtk_grid_new ();
	gtk_orientable_set_orientation (GTK_ORIENTABLE (grid), GTK_ORIENTATION_VERTICAL);
	gtk_grid_set_column_spacing (GTK_GRID (grid), 2);
	gtk_container_set_border_width (GTK_CONTAINER (grid), 16);
	gtk_container_add (GTK_CONTAINER (uidata->widgets->frame_type_select), grid);

	btn_loco = gtk_radio_button_new_with_label (NULL, C_("Kolab Folder Type",
	                                                     "Mail"));
	uidata->widgets->radio_btn_type_mail = btn_loco;
	uidata->widgets->radio_group = gtk_radio_button_get_group (GTK_RADIO_BUTTON (btn_loco));
	gtk_container_add (GTK_CONTAINER (grid), btn_loco);

	btn = gtk_radio_button_new_with_label_from_widget (GTK_RADIO_BUTTON (btn_loco),
	                                                   C_("Kolab Folder Type",
	                                                      "Calendar"));
	uidata->widgets->radio_btn_type_calendar = btn;
	gtk_container_add (GTK_CONTAINER (grid), btn);

	btn = gtk_radio_button_new_with_label_from_widget (GTK_RADIO_BUTTON (btn_loco),
	                                                   C_("Kolab Folder Type",
	                                                      "Memos"));
	uidata->widgets->radio_btn_type_memos = btn;
	gtk_container_add (GTK_CONTAINER (grid), btn);

	btn = gtk_radio_button_new_with_label_from_widget (GTK_RADIO_BUTTON (btn_loco),
	                                                   C_("Kolab Folder Type",
	                                                      "Tasks"));
	uidata->widgets->radio_btn_type_tasks = btn;
	gtk_container_add (GTK_CONTAINER (grid), btn);

	btn = gtk_radio_button_new_with_label_from_widget (GTK_RADIO_BUTTON (btn_loco),
	                                                   C_("Kolab Folder Type",
	                                                      "Contacts"));
	uidata->widgets->radio_btn_type_contacts = btn;
	gtk_container_add (GTK_CONTAINER (grid), btn);

	/* "Show all folders" */

	widget = gtk_frame_new (C_("Kolab Folder Metadata",
	                           "Kolab Folder Options"));
	gtk_container_set_border_width (GTK_CONTAINER (widget), 6);
	gtk_container_add (GTK_CONTAINER (uidata->widgets->container), widget);
	uidata->widgets->frame_options = widget;

	widget = gtk_check_button_new ();
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (widget), FALSE);
	gtk_container_set_border_width (GTK_CONTAINER (widget), 6);
	gtk_container_add (GTK_CONTAINER (uidata->widgets->frame_options), widget);
	uidata->widgets->chk_btn_show_all = widget;
	widget = gtk_label_new (C_("Kolab Folder Options",
	                           "Show all PIM folders in this Kolab account"));
	gtk_container_add (GTK_CONTAINER (uidata->widgets->chk_btn_show_all), widget);

	/* FIXME connect signals */
	g_warning ("%s: FIXME connect signals", __func__);

	return uidata;
}

void
e_kolab_folder_metadata_ui_free (KolabFolderMetaUIData *uidata)
{
	if (uidata == NULL)
		return;

	/* the actual widgets will have been deleted already,
	 * so just deleting the struct shell here
	 */
	if (uidata->widgets != NULL)
		g_free (uidata->widgets);

	kolab_data_folder_metadata_free (uidata->metadata);
	if (uidata->foldername != NULL)
		g_free (uidata->foldername);
	if (uidata->sourcename != NULL)
		g_free (uidata->sourcename);

	g_free (uidata);
}

/*----------------------------------------------------------------------------*/
