/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 8; tab-width: 8 -*- */
/***************************************************************************
 *            e-kolab-plugin-util.c
 *
 *  Sat Jun 02 15:28:05 2012
 *  Copyright  2012  Christian Hilberg
 *  <hilberg@kernelconcepts.de>
 *
 ****************************************************************************/

/*
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor Boston, MA 02110-1301,  USA
 */

/*----------------------------------------------------------------------------*/

#include <config.h>

#include <glib/gi18n-lib.h>

#include "e-kolab-plugin-util.h"

/*----------------------------------------------------------------------------*/
/* internal statics (non-UI) */


/*----------------------------------------------------------------------------*/
/* internal statics (UI) */


/*----------------------------------------------------------------------------*/
/* API functions (non-UI) */


/*----------------------------------------------------------------------------*/
/* API functions (UI) */

GtkWidget*
e_kolab_plugin_util_ui_label_new (const gchar *text,
                                  gboolean add_bottom_space)
{
	GtkWidget *label = NULL;

	if (text == NULL)
		return NULL;

	label = gtk_label_new (text);
	gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_LEFT);

	if (add_bottom_space)
		gtk_widget_set_margin_bottom (label, 5);

	gtk_misc_set_alignment (GTK_MISC (label), 0.0, 1.0);

	return label;
}

GtkWidget*
e_kolab_plugin_util_ui_selected_folder_widget (const gchar *foldername,
                                               const gchar *sourcename)
{
	GtkGrid *grid = NULL;
	GtkWidget *label = NULL;
	gchar *labeltext = NULL;
	gint row = 0;

	g_assert (foldername != NULL);
	/* sourcname may be NULL */

	grid = GTK_GRID (gtk_grid_new ());
	gtk_grid_set_row_homogeneous (grid, FALSE);
	gtk_grid_set_row_spacing (grid, 6);
	gtk_grid_set_column_homogeneous (grid, FALSE);
	gtk_grid_set_column_spacing (grid, 16);
	gtk_container_set_border_width (GTK_CONTAINER (grid), 8);

	if (sourcename != NULL) {
		labeltext = g_strconcat ("<b>",
		                         C_("Kolab Folder Properties",
		                            "Selected Resource:"),
		                         "</b>",
		                         NULL);
		label = e_kolab_plugin_util_ui_label_new (labeltext, FALSE);
		g_free (labeltext);
		gtk_label_set_use_markup (GTK_LABEL (label), TRUE);
		gtk_grid_attach (grid, label, 0, row, 1, 1);
		label = e_kolab_plugin_util_ui_label_new (sourcename, FALSE);
		gtk_grid_attach (grid, label, 1, row, 1, 1);
		row++;
	}

	labeltext = g_strconcat ("<b>",
	                         C_("Kolab Folder Properties",
	                            "Selected Folder:"),
	                         "</b>",
	                         NULL);
	label = e_kolab_plugin_util_ui_label_new (labeltext, FALSE);
	g_free (labeltext);
	gtk_label_set_use_markup (GTK_LABEL (label), TRUE);
	gtk_grid_attach (grid, label, 0, row, 1, 1);
	label = e_kolab_plugin_util_ui_label_new (foldername, FALSE);
	gtk_grid_attach (grid, label, 1, row, 1, 1);

	return GTK_WIDGET (grid);
}

/*----------------------------------------------------------------------------*/
