/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 8; tab-width: 8 -*- */
/***************************************************************************
 *            test-camel-kolab-imapx-provider.c
 *
 *  Tue Sep 14 10:32:49 2010
 *  Copyright  2010  Christian Hilberg
 *  <hilberg@kernelconcepts.de>
 ****************************************************************************/

/*
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor Boston, MA 02110-1301,  USA
 */

/*---------------------------------------------------------------------------*/

/* This file has been derived from the original IMAPX implementation
 * of libcamel1.2-14, which is part of the Evolution Data Server.
 */

/*---------------------------------------------------------------------------*/

#include <glib.h>

#include <camel/camel-kolab-imapx-store.h>
#include <camel/camel-kolab-imapx-folder.h>

#include <libekolabutil/camel-system-headers.h>

/* TODO this test needs to be fixed. While the current kolab-imapx
 *      implementation works inside evolution, this test fails the
 *      camel_session_get_service () call (seems kolab-imapx is no
 *      true CAMEL_PROVIDER_STORE, though it should be through sub
 *      classing CamelIMAPXStore, which is one)
 */

gint
main (gint argc, gchar *argv [])
{
	(void)argc;
	(void)argv;
#if 0
	CamelSession *session = NULL;
	CamelException *ex;
	gchar *uri = NULL;
	CamelService *service;
	CamelFolder *folder;

	if (argc != 2) {
		printf ("Pass the account url argument \n");
		return -1;
	}

	uri = argv [1];
	g_type_init ();
	system ("rm -rf /tmp/test-camel-imapx");
	camel_init ("/tmp/test-camel-imapx", TRUE);
	camel_provider_init ();
	ex = camel_exception_new ();

	session = CAMEL_SESSION (camel_object_new (CAMEL_SESSION_TYPE));
	if (session == NULL) {
		g_debug ("could not create new session object");
		return 0;
	}

	camel_session_construct (session, "/tmp/test-camel-imapx");

	service = camel_session_get_service (session,
	                                     uri,
	                                     CAMEL_PROVIDER_STORE,
	                                     ex);
	/* TODO we fail here currently, though in test-imapx.c, it works,
	 *      and so it does in evolution itself
	 */
	if (! CAMEL_IS_SERVICE (service)) {
		if (ex) {
			g_debug ("not a camel service: %s",
			         camel_exception_get_description (ex));
			camel_exception_free (ex);
		}
		return 0;
	}

	camel_service_connect (service, ex);
	if (ex) {
		g_debug ("connect failed: %s",
		         camel_exception_get_description (ex));
		camel_exception_free (ex);
		return 0;
	}

	camel_store_get_folder_info ((CamelStore *)service, "", 3, NULL);
	folder = camel_store_get_folder ((CamelStore *)service, "INBOX", 0, NULL);
	camel_folder_refresh_info (folder, NULL);

	while (1); /* never reached */
#endif
	return -1;
}

/*---------------------------------------------------------------------------*/
