/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 8; tab-width: 8 -*- */
/***************************************************************************
 *            camel-imapx-extd-folder.h
 *
 *  2011-11-25, 21:02:18
 *  Copyright 2011, Christian Hilberg
 *  <hilberg@unix-ag.org>
 ****************************************************************************/

/*
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with main.c; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor Boston, MA 02110-1301,  USA
 */

/*----------------------------------------------------------------------------*/

#ifndef _CAMEL_IMAPX_EXTD_FOLDER_H_
#define _CAMEL_IMAPX_EXTD_FOLDER_H_

/*----------------------------------------------------------------------------*/

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>

#include "camel-imapx-extd-store.h"
#include "camel-imapx-folder.h"

/*----------------------------------------------------------------------------*/
/* Standard GObject macros */

#define CAMEL_TYPE_IMAPX_EXTD_FOLDER	  \
	(camel_imapx_extd_folder_get_type ())
#define CAMEL_IMAPX_EXTD_FOLDER(obj)	  \
	(G_TYPE_CHECK_INSTANCE_CAST \
	 ((obj), CAMEL_TYPE_IMAPX_EXTD_FOLDER, CamelIMAPXExtdFolder))
#define CAMEL_IMAPX_EXTD_FOLDER_CLASS(klass)	  \
	(G_TYPE_CHECK_CLASS_CAST \
	 ((klass), CAMEL_TYPE_IMAPX_EXTD_FOLDER, CamelIMAPXExtdFolderClass))
#define CAMEL_IS_IMAPX_EXTD_FOLDER(obj)	  \
	(G_TYPE_CHECK_INSTANCE_TYPE \
	 ((obj), CAMEL_TYPE_IMAPX_EXTD_FOLDER))
#define CAMEL_IS_IMAPX_EXTD_FOLDER_CLASS(klass)	  \
	(G_TYPE_CHECK_CLASS_TYPE \
	 ((klass), CAMEL_TYPE_IMAPX_EXTD_FOLDER))
#define CAMEL_IMAPX_EXTD_FOLDER_GET_CLASS(obj)	  \
	(G_TYPE_INSTANCE_GET_CLASS \
	 ((obj), CAMEL_TYPE_IMAPX_EXTD_FOLDER, CamelIMAPXExtdFolderClass))

G_BEGIN_DECLS

typedef struct _CamelIMAPXExtdFolder CamelIMAPXExtdFolder;
typedef struct _CamelIMAPXExtdFolderClass CamelIMAPXExtdFolderClass;

struct _CamelIMAPXExtdFolder {
	CamelIMAPXFolder parent;

	gboolean apply_filters; /* persistent property (from parent, redundant here?) */
};

struct _CamelIMAPXExtdFolderClass {
	CamelIMAPXFolderClass parent_class;

	guint64 (*get_uidvalidity) (CamelIMAPXExtdFolder *self,
	                            GError **err);
};

GType
camel_imapx_extd_folder_get_type (void);

CamelIMAPXExtdFolder*
camel_imapx_extd_folder_new (CamelIMAPXExtdStore *store,
                             const gchar *folder_dir,
                             const gchar *folder_name,
                             GError **err);

guint64
camel_imapx_extd_folder_get_uidvalidity (CamelIMAPXExtdFolder *self,
                                         GError **err);

G_END_DECLS

/*----------------------------------------------------------------------------*/

#endif /* _CAMEL_IMAPX_EXTD_FOLDER_H_ */

/*----------------------------------------------------------------------------*/
