/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 8; tab-width: 8 -*- */
/***************************************************************************
 *            camel-kolab-imapx-conn-manager.h
 *
 *  2012-01-10, 17:32:18
 *  Copyright 2012, Christian Hilberg
 *  <hilberg@unix-ag.org>
 ****************************************************************************/

/*
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with main.c; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor Boston, MA 02110-1301,  USA
 */

/*----------------------------------------------------------------------------*/

#ifndef _CAMEL_KOLAB_IMAPX_CONN_MANAGER_H_
#define _CAMEL_KOLAB_IMAPX_CONN_MANAGER_H_

/*----------------------------------------------------------------------------*/

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>

#include <camel/providers/imapx/camel-imapx-extd-conn-manager.h>

#include "camel-kolab-imapx-store.h"

/*----------------------------------------------------------------------------*/
/* Standard GObject macros */

#define CAMEL_TYPE_KOLAB_IMAPX_CONN_MANAGER	  \
	(camel_kolab_imapx_conn_manager_get_type ())
#define CAMEL_KOLAB_IMAPX_CONN_MANAGER(obj)	  \
	(G_TYPE_CHECK_INSTANCE_CAST \
	 ((obj), CAMEL_TYPE_KOLAB_IMAPX_CONN_MANAGER, CamelKolabIMAPXConnManager))
#define CAMEL_KOLAB_IMAPX_CONN_MANAGER_CLASS(klass)	  \
	(G_TYPE_CHECK_CLASS_CAST \
	 ((klass), CAMEL_TYPE_KOLAB_IMAPX_CONN_MANAGER, CamelKolabIMAPXConnManagerClass))
#define CAMEL_IS_KOLAB_IMAPX_CONN_MANAGER(obj)	  \
	(G_TYPE_CHECK_INSTANCE_TYPE \
	 ((obj), CAMEL_TYPE_KOLAB_IMAPX_CONN_MANAGER))
#define CAMEL_IS_KOLAB_IMAPX_CONN_MANAGER_CLASS(klass)	  \
	(G_TYPE_CHECK_CLASS_TYPE \
	 ((klass), CAMEL_TYPE_KOLAB_IMAPX_CONN_MANAGER))
#define CAMEL_KOLAB_IMAPX_CONN_MANAGER_GET_CLASS(obj)	  \
	(G_TYPE_INSTANCE_GET_CLASS \
	 ((obj), CAMEL_TYPE_KOLAB_IMAPX_CONN_MANAGER, CamelKolabIMAPXConnManagerClass))

G_BEGIN_DECLS

typedef struct _CamelKolabIMAPXConnManager CamelKolabIMAPXConnManager;
typedef struct _CamelKolabIMAPXConnManagerClass CamelKolabIMAPXConnManagerClass;

struct _CamelKolabIMAPXConnManager {
	CamelIMAPXExtdConnManager parent;
};

struct _CamelKolabIMAPXConnManagerClass {
	CamelIMAPXExtdConnManagerClass parent_class;
};

GType
camel_kolab_imapx_conn_manager_get_type (void);

CamelKolabIMAPXConnManager*
camel_kolab_imapx_conn_manager_new (CamelKolabIMAPXStore *store);

G_END_DECLS

/*----------------------------------------------------------------------------*/

#endif /* _CAMEL_KOLAB_IMAPX_CONN_MANAGER_H_ */

/*----------------------------------------------------------------------------*/
