/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 8; tab-width: 8 -*- */
/***************************************************************************
 *            e-cal-backend-kolab-factory.c
 *
 *  Thu Jun 10 18:25:26 2010
 *  Copyright  2010  Christian Hilberg
 *  <hilberg@kernelconcepts.de>
 *  and Silvan Marco Fin <silvan@kernelconcepts.de> in 2011
 ****************************************************************************/

/*
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor Boston, MA 02110-1301,  USA
 */

/*----------------------------------------------------------------------------*/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <glib.h>
#include <glib-object.h>

#include <libedata-cal/e-cal-backend-factory.h>
#include <libekolabutil/kolab-util-camel.h>

#include "e-cal-backend-kolab.h"

/*----------------------------------------------------------------------------*/

#define FACTORY_NAME KOLAB_CAMEL_PROVIDER_PROTOCOL

/*----------------------------------------------------------------------------*/

typedef ECalBackendFactory ECalBackendKolabEventsFactory;
typedef ECalBackendFactoryClass ECalBackendKolabEventsFactoryClass;

typedef ECalBackendFactory ECalBackendKolabJournalFactory;
typedef ECalBackendFactoryClass ECalBackendKolabJournalFactoryClass;

typedef ECalBackendFactory ECalBackendKolabTodosFactory;
typedef ECalBackendFactoryClass ECalBackendKolabTodosFactoryClass;

/* Module Entry Points */
void e_module_load (GTypeModule *type_module);
void e_module_unload (GTypeModule *type_module);

/* Forward Declarations */
GType e_cal_backend_kolab_events_factory_get_type (void);
GType e_cal_backend_kolab_journal_factory_get_type (void);
GType e_cal_backend_kolab_todos_factory_get_type (void);

G_DEFINE_DYNAMIC_TYPE (ECalBackendKolabEventsFactory,
                       e_cal_backend_kolab_events_factory,
                       E_TYPE_CAL_BACKEND_FACTORY)

G_DEFINE_DYNAMIC_TYPE (ECalBackendKolabJournalFactory,
                       e_cal_backend_kolab_journal_factory,
                       E_TYPE_CAL_BACKEND_FACTORY)

G_DEFINE_DYNAMIC_TYPE (ECalBackendKolabTodosFactory,
                       e_cal_backend_kolab_todos_factory,
                       E_TYPE_CAL_BACKEND_FACTORY)

static void
e_cal_backend_kolab_events_factory_class_init (ECalBackendFactoryClass *klass)
{
	klass->factory_name = FACTORY_NAME;
	klass->component_kind = ICAL_VEVENT_COMPONENT;
	klass->backend_type = E_TYPE_CAL_BACKEND_KOLAB;
}

static void
e_cal_backend_kolab_events_factory_class_finalize (ECalBackendFactoryClass *klass)
{
	(void)klass;
}

static void
e_cal_backend_kolab_events_factory_init (ECalBackendFactory *factory)
{
	(void)factory;
}

static void
e_cal_backend_kolab_journal_factory_class_init (ECalBackendFactoryClass *klass)
{
	klass->factory_name = FACTORY_NAME;
	klass->component_kind = ICAL_VJOURNAL_COMPONENT;
	klass->backend_type = E_TYPE_CAL_BACKEND_KOLAB;
}

static void
e_cal_backend_kolab_journal_factory_class_finalize (ECalBackendFactoryClass *klass)
{
	(void)klass;
}

static void
e_cal_backend_kolab_journal_factory_init (ECalBackendFactory *factory)
{
	(void)factory;
}

static void
e_cal_backend_kolab_todos_factory_class_init (ECalBackendFactoryClass *klass)
{
	klass->factory_name = FACTORY_NAME;
	klass->component_kind = ICAL_VTODO_COMPONENT;
	klass->backend_type = E_TYPE_CAL_BACKEND_KOLAB;
}

static void
e_cal_backend_kolab_todos_factory_class_finalize (ECalBackendFactoryClass *klass)
{
	(void)klass;
}

static void
e_cal_backend_kolab_todos_factory_init (ECalBackendFactory *factory)
{
	(void)factory;
}

G_MODULE_EXPORT void
e_module_load (GTypeModule *type_module)
{
	e_cal_backend_kolab_events_factory_register_type (type_module);
	e_cal_backend_kolab_journal_factory_register_type (type_module);
	e_cal_backend_kolab_todos_factory_register_type (type_module);
}

G_MODULE_EXPORT void
e_module_unload (GTypeModule *type_module)
{
	(void)type_module;
}

/*----------------------------------------------------------------------------*/

#if 0 /* FIXME old */

static void
e_cal_backend_kolab_factory_instance_init (ECalBackendKolabFactory *factory)
{
	(void) factory;
}

static const gchar *
_get_protocol (ECalBackendFactory *factory)
{
	(void) factory;
	return KOLAB_CAMEL_PROVIDER_PROTOCOL;
}

static icalcomponent_kind
_events_get_kind (ECalBackendFactory *factory)
{
	(void) factory;
	return ICAL_VEVENT_COMPONENT;
}

static icalcomponent_kind
_todos_get_kind (ECalBackendFactory *factory)
{
	(void) factory;
	return ICAL_VTODO_COMPONENT;
}

static icalcomponent_kind
_journal_get_kind (ECalBackendFactory *factory)
{
	(void) factory;
	return ICAL_VJOURNAL_COMPONENT;
}

static ECalBackend *
_events_new_backend (ECalBackendFactory *factory, ESource *source)
{
	ECalBackend *new_backend = NULL;
	(void) factory;

	new_backend = g_object_new (e_cal_backend_kolab_get_type (),
	                            "source", source,
	                            "kind", ICAL_VEVENT_COMPONENT,
	                            NULL);
	if (koma_objects == NULL)
		koma_objects = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, NULL);
	e_cal_backend_kolab_set_koma_table (E_CAL_BACKEND_KOLAB (new_backend), koma_objects);
	return new_backend;
}

static ECalBackend *
_todos_new_backend (ECalBackendFactory *factory, ESource *source)
{
	ECalBackend *new_backend = NULL;
	(void) factory;

	new_backend = g_object_new (e_cal_backend_kolab_get_type (),
	                            "source", source,
	                            "kind", ICAL_VTODO_COMPONENT,
	                            NULL);
	if (koma_objects == NULL)
		koma_objects = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, NULL);
	e_cal_backend_kolab_set_koma_table (E_CAL_BACKEND_KOLAB (new_backend), koma_objects);
	return new_backend;
}

static ECalBackend *
_journal_new_backend (ECalBackendFactory *factory, ESource *source)
{
	ECalBackend *new_backend = NULL;
	(void) factory;

	new_backend = g_object_new (e_cal_backend_kolab_get_type (),
	                            "source", source,
	                            "kind", ICAL_VJOURNAL_COMPONENT,
	                            NULL);
	if (koma_objects == NULL)
		koma_objects = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, NULL);
	e_cal_backend_kolab_set_koma_table (E_CAL_BACKEND_KOLAB (new_backend), koma_objects);
	return new_backend;
}

static void
events_backend_factory_class_init (ECalBackendKolabFactoryClass *klass)
{
	E_CAL_BACKEND_FACTORY_CLASS (klass)->get_protocol = _get_protocol;
	E_CAL_BACKEND_FACTORY_CLASS (klass)->get_kind = _events_get_kind;
	E_CAL_BACKEND_FACTORY_CLASS (klass)->new_backend = _events_new_backend;
}

static void
todos_backend_factory_class_init (ECalBackendKolabFactoryClass *klass)
{
	E_CAL_BACKEND_FACTORY_CLASS (klass)->get_protocol = _get_protocol;
	E_CAL_BACKEND_FACTORY_CLASS (klass)->get_kind = _todos_get_kind;
	E_CAL_BACKEND_FACTORY_CLASS (klass)->new_backend = _todos_new_backend;
}

static void
journal_backend_factory_class_init (ECalBackendKolabFactoryClass *klass)
{
	E_CAL_BACKEND_FACTORY_CLASS (klass)->get_protocol = _get_protocol;
	E_CAL_BACKEND_FACTORY_CLASS (klass)->get_kind = _journal_get_kind;
	E_CAL_BACKEND_FACTORY_CLASS (klass)->new_backend = _journal_new_backend;
}

static GType
events_backend_factory_get_type (GTypeModule *module)
{
	GType type;

	GTypeInfo info = {
		sizeof (ECalBackendKolabFactoryClass),
		NULL, /* base_class_init */
		NULL, /* base_class_finalize */
		(GClassInitFunc) events_backend_factory_class_init,
		NULL, /* class_finalize */
		NULL, /* class_data */
		sizeof (ECalBackend),
		0, /* n_preallocs */
		(GInstanceInitFunc) e_cal_backend_kolab_factory_instance_init,
		NULL /* GTypeValueTable */
	};

	type = g_type_module_register_type (module,
	                                    E_TYPE_CAL_BACKEND_FACTORY,
	                                    "ECalBackendKolabEventsFactory",
	                                    &info, 0);

	return type;
}

static GType
todos_backend_factory_get_type (GTypeModule *module)
{
	GType type;

	GTypeInfo info = {
		sizeof (ECalBackendKolabFactoryClass),
		NULL, /* base_class_init */
		NULL, /* base_class_finalize */
		(GClassInitFunc) todos_backend_factory_class_init,
		NULL, /* class_finalize */
		NULL, /* class_data */
		sizeof (ECalBackend),
		0, /* n_preallocs */
		(GInstanceInitFunc) e_cal_backend_kolab_factory_instance_init,
		NULL /* GTypeValueTable */
	};

	type = g_type_module_register_type (module,
	                                    E_TYPE_CAL_BACKEND_FACTORY,
	                                    "ECalBackendKolabTodosFactory",
	                                    &info, 0);

	return type;
}

static GType
journal_backend_factory_get_type (GTypeModule *module)
{
	GType type;

	GTypeInfo info = {
		sizeof (ECalBackendKolabFactoryClass),
		NULL, /* base_class_init */
		NULL, /* base_class_finalize */
		(GClassInitFunc) journal_backend_factory_class_init,
		NULL, /* class_finalize */
		NULL, /* class_data */
		sizeof (ECalBackend),
		0, /* n_preallocs */
		(GInstanceInitFunc) e_cal_backend_kolab_factory_instance_init,
		NULL /* GTypeValueTable */
	};

	type = g_type_module_register_type (module,
	                                    E_TYPE_CAL_BACKEND_FACTORY,
	                                    "ECalBackendKolabJournalFactory",
	                                    &info, 0);

	return type;
}

static GType kolab_cal_types[1];

void
eds_module_initialize (GTypeModule *module)
{
	kolab_cal_types[0] = events_backend_factory_get_type (module);
	kolab_cal_types[1] = todos_backend_factory_get_type (module);
	kolab_cal_types[2] = journal_backend_factory_get_type (module);
}


void
eds_module_shutdown (void)
{
	/* TODO: implement me */
}


void
eds_module_list_types (const GType **types, gint *num_types)
{
	*types = kolab_cal_types;
	*num_types = 3;
}
#endif

/*----------------------------------------------------------------------------*/
