/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 8; tab-width: 8 -*- */
/***************************************************************************
 *            e-kolab-folder-permissions.c
 *
 *  Fri Feb 10 11:27:05 2012
 *  Copyright  2012  Christian Hilberg
 *  <hilberg@kernelconcepts.de>
 *
 ****************************************************************************/

/*
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor Boston, MA 02110-1301,  USA
 */

/*----------------------------------------------------------------------------*/

#include <config.h>

#include <glib/gi18n-lib.h>

#include <e-util/e-config.h>
#include <e-util/e-plugin.h>

#include "e-kolab-folder-permissions.h"

enum {
	KOLAB_PERM_TREE_VIEW_COL_NAME = 0,
	KOLAB_PERM_TREE_VIEW_COL_LEVEL,
	KOLAB_PERM_TREE_VIEW_LAST_COL
};

/*----------------------------------------------------------------------------*/
/* internal statics (non-UI) */

/*----------------------------------------------------------------------------*/
/* internal statics (UI) */

static void
kolab_folder_permissions_ui_edit_dialog_response_cb (GObject *dialog,
                                                     gint response_id)
{
	g_return_if_fail (dialog != NULL);

	if (response_id != GTK_RESPONSE_OK) {
		gtk_widget_destroy (GTK_WIDGET (dialog));
		return;
	}

	/* FIXME implement me */
	g_warning ("%s: FIXME implement me", __func__);
}

static void
kolab_folder_permissions_ui_edit_dialog_cb (KolabFolderPermUIData *uidata)
{
	GtkWidget *dialog = NULL;
	GtkWidget *content = NULL;
	GtkWidget *hbox = NULL;
	GtkWidget *label = NULL;
	GtkWidget *entry = NULL;
	GtkWidget *frame = NULL;
	GtkWidget *btn = NULL;
	GtkWidget *grid = NULL;
	GtkWidget *widget = NULL;
	gchar *tmp_str = NULL;

	g_assert (uidata != NULL);
	g_assert (uidata->widgets != NULL);

	dialog = gtk_dialog_new_with_buttons (_("Edit Kolab folder permissions..."),
		                             NULL, /* parent */
		                             GTK_DIALOG_DESTROY_WITH_PARENT|GTK_DIALOG_MODAL,
		                             GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
		                             GTK_STOCK_OK, GTK_RESPONSE_OK,
		                             NULL);

	content = gtk_dialog_get_content_area (GTK_DIALOG (dialog));
	gtk_container_set_border_width (GTK_CONTAINER (content), 6);

	hbox = gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 6);
	tmp_str = g_strconcat (_("User Identification"), ":", NULL);
	label = gtk_label_new (tmp_str);
	g_free (tmp_str);
	gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 0);
	entry = gtk_combo_box_new_with_entry ();
	gtk_combo_box_set_popup_fixed_width (GTK_COMBO_BOX (entry), FALSE);
	uidata->widgets->edit_entry_box = entry;
	gtk_box_pack_start (GTK_BOX (hbox), entry, TRUE, TRUE, 0);
	btn = gtk_button_new_with_label (_("Retrieve..."));
	uidata->widgets->edit_btn_retrieve = btn;
	gtk_box_pack_start (GTK_BOX (hbox), btn, FALSE, FALSE, 0);
	gtk_container_add (GTK_CONTAINER (content), hbox);

	frame = gtk_frame_new (_("Access Rights"));
	gtk_container_add (GTK_CONTAINER (content), frame);

	grid = gtk_grid_new ();
	gtk_orientable_set_orientation (GTK_ORIENTABLE (grid), GTK_ORIENTATION_VERTICAL);
	gtk_grid_set_column_spacing (GTK_GRID (grid), 2);
	gtk_container_set_border_width (GTK_CONTAINER (grid), 16);
	gtk_container_add (GTK_CONTAINER (frame), grid);

	widget = gtk_radio_button_new_with_label (NULL, C_("Permissions", "None"));
	uidata->widgets->radio_btn_perm_none = widget;
	uidata->widgets->radio_group = gtk_radio_button_get_group (GTK_RADIO_BUTTON (widget));
	gtk_container_add (GTK_CONTAINER (grid), widget);

	widget = gtk_radio_button_new_with_label (uidata->widgets->radio_group, C_("Permissions", "Read"));
	uidata->widgets->radio_btn_perm_read = widget;
	gtk_container_add (GTK_CONTAINER (grid), widget);

	widget = gtk_radio_button_new_with_label (uidata->widgets->radio_group, C_("Permissions", "Append"));
	uidata->widgets->radio_btn_perm_append = widget;
	gtk_container_add (GTK_CONTAINER (grid), widget);

	widget = gtk_radio_button_new_with_label (uidata->widgets->radio_group, C_("Permissions", "Write"));
	uidata->widgets->radio_btn_perm_write = widget;
	gtk_container_add (GTK_CONTAINER (grid), widget);

	widget = gtk_radio_button_new_with_label (uidata->widgets->radio_group, C_("Permissions", "All"));
	uidata->widgets->radio_btn_perm_all = widget;
	gtk_container_add (GTK_CONTAINER (grid), widget);

	/* FIXME connect signals */
	g_warning ("%s: FIXME connect signals", __func__);

	g_signal_connect (dialog,
	                  "response",
	                  G_CALLBACK (kolab_folder_permissions_ui_edit_dialog_response_cb),
	                  NULL);
	gtk_dialog_set_default_response (GTK_DIALOG (dialog), GTK_RESPONSE_OK);
	gtk_dialog_set_response_sensitive (GTK_DIALOG (dialog),
	                                   GTK_RESPONSE_OK,
	                                   FALSE);

	uidata->widgets->edit_dialog = dialog;

	gtk_widget_show_all (content);
	gtk_widget_show (dialog);
}

static GtkWidget*
kolab_folder_permissions_ui_create_tree_view (KolabFolderPermUIData *uidata)
{
	GtkTreeView *tree_view = NULL;
	GtkTreeModel *tree_model = NULL;
	GtkTreeSelection *selection = NULL;
	GtkCellRenderer *renderer = NULL;
	GtkTreeViewColumn *column = NULL;

	g_assert (uidata != NULL);
	g_assert (uidata->widgets != NULL);

	tree_model = GTK_TREE_MODEL (gtk_list_store_new (2, G_TYPE_STRING, G_TYPE_STRING));
	tree_view = GTK_TREE_VIEW (gtk_tree_view_new_with_model (tree_model));
	gtk_tree_view_set_grid_lines (tree_view, GTK_TREE_VIEW_GRID_LINES_BOTH);
	gtk_tree_view_set_rubber_banding (tree_view, TRUE);
	gtk_tree_view_columns_autosize (tree_view);
	gtk_scrollable_set_vscroll_policy (GTK_SCROLLABLE (tree_view), GTK_SCROLL_NATURAL);
	gtk_scrollable_set_hscroll_policy (GTK_SCROLLABLE (tree_view), GTK_SCROLL_NATURAL);

	renderer = gtk_cell_renderer_text_new ();
	g_object_set (renderer, "editable", FALSE, NULL);
	gtk_tree_view_insert_column_with_attributes (tree_view,
	                                             -1,
	                                             _("Name"),
	                                             renderer,
	                                             "text",
	                                             KOLAB_PERM_TREE_VIEW_COL_NAME,
	                                             NULL);
	column = gtk_tree_view_get_column (tree_view, KOLAB_PERM_TREE_VIEW_COL_NAME);
	gtk_tree_view_column_set_expand (column, TRUE);

	renderer = gtk_cell_renderer_text_new ();
	g_object_set (renderer, "editable", FALSE, NULL);
	gtk_tree_view_insert_column_with_attributes (tree_view,
	                                             -1,
	                                             _("Permission level"),
	                                             renderer,
	                                             "text",
	                                             KOLAB_PERM_TREE_VIEW_COL_LEVEL,
	                                             NULL);

	selection = gtk_tree_view_get_selection (tree_view);
	gtk_tree_selection_set_mode (selection, GTK_SELECTION_SINGLE);
	/* FIXME connect signal to callback
	g_signal_connect (selection, "changed", G_CALLBACK (folder_permissions_tree_selection_changed_cb), widgets);
	*/
	gtk_tree_view_set_headers_visible (tree_view, TRUE);
	gtk_tree_view_set_headers_clickable (tree_view, FALSE);
	gtk_tree_view_set_fixed_height_mode (tree_view, TRUE);

	return GTK_WIDGET (tree_view);
}

/* FIXME testing/debugging only, remove */
static void
add_some_content_to_treeview (GtkTreeView *treeview)
{
	GtkListStore *liststore = NULL;

	g_assert (treeview != NULL);

	liststore = GTK_LIST_STORE (gtk_tree_view_get_model (treeview));

	gtk_list_store_insert_with_values (liststore,
	                                   NULL,
	                                   0,
	                                   0, g_strdup ("this is a lengthy user name entry"),
	                                   1, g_strdup ("and the lengthy permission string, display testing"),
	                                   -1);
	gtk_list_store_insert_with_values (liststore,
	                                   NULL,
	                                   1,
	                                   0, g_strdup ("this is another lengthy user name entry"),
	                                   1, g_strdup ("and another lengthy permission string, display testing"),
	                                   -1);

}

/*----------------------------------------------------------------------------*/
/* API functions (non-UI) */

KolabDataFolderPermissions*
e_kolab_folder_permissions_read_data_from_folder (const KolabDataImapAccount *account,
                                                  const gchar *foldername,
                                                  KolabFolderTypeID foldertype,
                                                  GError **err)
{
	KolabDataFolderPermissions *data = NULL;

	g_assert (account != NULL);
	g_assert (foldername != NULL);
	g_assert (foldertype < KOLAB_FOLDER_LAST_TYPE);
	g_return_val_if_fail (err == NULL || *err == NULL, NULL);

	/* FIXME implement me */
	g_warning ("%s: FIXME implement me", __func__);

	data = kolab_data_folder_permissions_new ();

	return data;
}

gboolean
e_kolab_folder_permissions_write_data_to_folder (const KolabDataImapAccount *account,
                                                 const gchar *foldername,
                                                 KolabFolderTypeID foldertype,
                                                 const KolabDataFolderPermissions *data,
                                                 GError **err)
{
	g_assert (account != NULL);
	g_assert (foldername != NULL);
	g_assert (foldertype < KOLAB_FOLDER_LAST_TYPE);
	g_assert (data != NULL);
	g_return_val_if_fail (err == NULL || *err == NULL, FALSE);

	/* FIXME implement me */
	g_warning ("%s: FIXME implement me", __func__);

	return TRUE;
}

/*----------------------------------------------------------------------------*/
/* API functions (UI) */

KolabFolderPermUIData*
e_kolab_folder_permissions_ui_new (void)
{
	KolabFolderPermUIData *uidata = g_new0 (KolabFolderPermUIData, 1);
	GtkGrid *grid = NULL;
	GtkWidget *vbox = NULL;
	GtkWidget *treeview = NULL;
	gint row = 0;

	uidata->widgets = g_new0 (KolabFolderPermUIWidgets, 1);
	uidata->widgets->container = gtk_frame_new (_("Folder Permissions"));
	gtk_container_set_border_width (GTK_CONTAINER (uidata->widgets->container), 6);
	/* gtk_container_set_resize_mode (uidata->widgets->container, GTK_RESIZE_QUEUE); */

	grid = GTK_GRID (gtk_grid_new ());
	gtk_grid_set_row_homogeneous (grid, FALSE);
	gtk_grid_set_row_spacing (grid, 6);
	gtk_grid_set_column_homogeneous (grid, FALSE);
	gtk_grid_set_column_spacing (grid, 6);
	gtk_container_set_border_width (GTK_CONTAINER (grid), 16);
	/* gtk_container_set_resize_mode (GTK_CONTAINER (grid), GTK_RESIZE_QUEUE); */
	gtk_container_add (GTK_CONTAINER (uidata->widgets->container), GTK_WIDGET (grid));

	row = 0;

	/* permissions tree view */
	treeview = kolab_folder_permissions_ui_create_tree_view (uidata);
	/* gtk_container_set_resize_mode (GTK_CONTAINER (treeview), GTK_RESIZE_QUEUE); */
	uidata->widgets->treeview = treeview;
	gtk_grid_attach (GTK_GRID (grid), treeview, 0, row, 1, 1);

	/* FIXME remove me, display testing */
	/* add_some_content_to_treeview (GTK_TREE_VIEW (treeview)); */

	/* add/edit/delete stock buttons */
	vbox = gtk_box_new (GTK_ORIENTATION_VERTICAL, 12);
	uidata->widgets->btn_add = gtk_button_new_from_stock (GTK_STOCK_ADD);
	gtk_box_pack_start (GTK_BOX (vbox), uidata->widgets->btn_add, FALSE, FALSE, 0);
	uidata->widgets->btn_edit = gtk_button_new_from_stock (GTK_STOCK_EDIT);
	gtk_box_pack_start (GTK_BOX (vbox), uidata->widgets->btn_edit, FALSE, FALSE, 0);
	uidata->widgets->btn_remove = gtk_button_new_from_stock (GTK_STOCK_REMOVE);
	gtk_box_pack_start (GTK_BOX (vbox), uidata->widgets->btn_remove, FALSE, FALSE, 0);
	gtk_grid_attach (GTK_GRID (grid), vbox, 1, row, 1, 1);

	/* FIXME connect signals */
	g_warning ("%s: FIXME connect signals", __func__);

	g_signal_connect_swapped (G_OBJECT (uidata->widgets->btn_add),
	                          "clicked",
	                          G_CALLBACK (kolab_folder_permissions_ui_edit_dialog_cb),
	                          uidata);
	g_signal_connect_swapped (G_OBJECT (uidata->widgets->btn_edit),
	                          "clicked",
	                          G_CALLBACK (kolab_folder_permissions_ui_edit_dialog_cb),
	                          uidata);

	return uidata;
}

void
e_kolab_folder_permissions_ui_free (KolabFolderPermUIData *uidata)
{
	if (uidata == NULL)
		return;

	/* the actual widgets will have been deleted already,
	 * so just deleting the struct shell here
	 */
	if (uidata->widgets != NULL)
		g_free (uidata->widgets);

	kolab_data_folder_permissions_free (uidata->permissions);

	g_free (uidata);
}

/*----------------------------------------------------------------------------*/
