/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 8; tab-width: 8 -*- */
/***************************************************************************
 *            camel-kolab-imapx-server.h
 *
 *  2011-12-02, 17:05:40
 *  Copyright 2011, Christian Hilberg
 *  <hilberg@unix-ag.org>
 ****************************************************************************/

/*
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with main.c; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor Boston, MA 02110-1301,  USA
 */

/*----------------------------------------------------------------------------*/

#ifndef _CAMEL_KOLAB_IMAPX_SERVER_H_
#define _CAMEL_KOLAB_IMAPX_SERVER_H_

/*----------------------------------------------------------------------------*/

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>

#include <camel/providers/imapx/camel-imapx-extd-server.h>

#include "camel-kolab-imapx-metadata.h"

/*----------------------------------------------------------------------------*/
/* Standard GObject macros */

#define CAMEL_TYPE_KOLAB_IMAPX_SERVER	  \
	(camel_kolab_imapx_server_get_type ())
#define CAMEL_KOLAB_IMAPX_SERVER(obj)	  \
	(G_TYPE_CHECK_INSTANCE_CAST \
	 ((obj), CAMEL_TYPE_KOLAB_IMAPX_SERVER, CamelKolabIMAPXServer))
#define CAMEL_KOLAB_IMAPX_SERVER_CLASS(klass)	  \
	(G_TYPE_CHECK_CLASS_CAST \
	 ((klass), CAMEL_TYPE_KOLAB_IMAPX_SERVER, CamelKolabIMAPXServerClass))
#define CAMEL_IS_KOLAB_IMAPX_SERVER(obj)	  \
	(G_TYPE_CHECK_INSTANCE_TYPE \
	 ((obj), CAMEL_TYPE_KOLAB_IMAPX_SERVER))
#define CAMEL_IS_KOLAB_IMAPX_SERVER_CLASS(klass)	  \
	(G_TYPE_CHECK_CLASS_TYPE \
	 ((klass), CAMEL_TYPE_KOLAB_IMAPX_SERVER))
#define CAMEL_KOLAB_IMAPX_SERVER_GET_CLASS(obj)	  \
	(G_TYPE_INSTANCE_GET_CLASS \
	 ((obj), CAMEL_TYPE_KOLAB_IMAPX_SERVER, CamelKolabIMAPXServerClass))

G_BEGIN_DECLS

typedef struct _CamelKolabIMAPXServer CamelKolabIMAPXServer;
typedef struct _CamelKolabIMAPXServerClass CamelKolabIMAPXServerClass;

struct _CamelKolabIMAPXServer {
	CamelIMAPXExtdServer parent;
};

struct _CamelKolabIMAPXServerClass {
	CamelIMAPXExtdServerClass parent_class;

	CamelKolabImapxMetadata* (*get_kolab_metadata) (CamelKolabIMAPXServer *self,
	                                                gboolean do_resect,
	                                                GError **err);

	gboolean (*set_kolab_metadata) (CamelKolabIMAPXServer *self,
	                                CamelKolabImapxMetadata *kmd,
	                                GError **err);

	KolabFolderTypeID (*get_foldertype) (CamelKolabIMAPXServer *self,
	                                     const gchar *foldername,
	                                     gboolean do_updatedb,
	                                     GCancellable *cancellable,
	                                     GError **err);

	gboolean (*set_foldertype) (CamelKolabIMAPXServer *self,
	                            const gchar *foldername,
	                            KolabFolderTypeID foldertype,
	                            GCancellable *cancellable,
	                            GError **err);
};

GType
camel_kolab_imapx_server_get_type (void);

CamelKolabImapxMetadata*
camel_kolab_imapx_server_get_kolab_metadata (CamelKolabIMAPXServer *self,
                                             gboolean do_resect,
                                             GError **err);

gboolean
camel_kolab_imapx_server_set_kolab_metadata (CamelKolabIMAPXServer *self,
                                             CamelKolabImapxMetadata *kmd,
                                             GError **err);

KolabFolderTypeID
camel_kolab_imapx_server_get_foldertype (CamelKolabIMAPXServer *self,
                                         const gchar *foldername,
                                         gboolean do_updatedb,
                                         GCancellable *cancellable,
                                         GError **err);

gboolean
camel_kolab_imapx_server_set_foldertype (CamelKolabIMAPXServer *self,
                                         const gchar *foldername,
                                         KolabFolderTypeID foldertype,
                                         GCancellable *cancellable,
                                         GError **err);

gboolean
camel_kolab_imapx_server_retrieve_all_folder_types (CamelKolabIMAPXServer *self,
                                                    GCancellable *cancellable,
                                                    GError **err);

G_END_DECLS

/*----------------------------------------------------------------------------*/

#endif /* CAMEL_KOLAB_IMAPX_SERVER_H_ */

/*----------------------------------------------------------------------------*/
