/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 8; tab-width: 8 -*- */
/***************************************************************************
 *            camel-kolab-imapx-folder.h
 *
 *  Tue Sep  7 15:03:17 2010
 *  Copyright  2010  Christian Hilberg
 *  <hilberg@kernelconcepts.de>
 ****************************************************************************/

/*
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with main.c; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor Boston, MA 02110-1301,  USA
 */

/*----------------------------------------------------------------------------*/

#ifndef _CAMEL_KOLAB_IMAPX_FOLDER_H_
#define _CAMEL_KOLAB_IMAPX_FOLDER_H_

/*----------------------------------------------------------------------------*/

#include <glib.h>
#include <glib-object.h>

#include <camel/providers/imapx/camel-imapx-extd-folder.h>

#include <libekolabutil/kolab-util-folder.h>

/*----------------------------------------------------------------------------*/

struct _CamelKolabIMAPXStore;

/*----------------------------------------------------------------------------*/
/* Folder metadata */

typedef struct _CamelKolabImapxFolderMetadata CamelKolabImapxFolderMetadata;
struct _CamelKolabImapxFolderMetadata {
	/* folder name kept as key in CamelKolabImapxMetadata kolab_metadata  */
	KolabFolderTypeID folder_type;
};

CamelKolabImapxFolderMetadata*
camel_kolab_imapx_folder_metadata_new (void);

gboolean
camel_kolab_imapx_folder_metadata_free (CamelKolabImapxFolderMetadata *kfmd);

void
camel_kolab_imapx_folder_metadata_gdestroy (gpointer data);

/*----------------------------------------------------------------------------*/
/* Standard GObject macros */

#define CAMEL_TYPE_KOLAB_IMAPX_FOLDER	  \
	(camel_kolab_imapx_folder_get_type ())
#define CAMEL_KOLAB_IMAPX_FOLDER(obj)	  \
	(G_TYPE_CHECK_INSTANCE_CAST \
	 ((obj), CAMEL_TYPE_KOLAB_IMAPX_FOLDER, CamelKolabIMAPXFolder))
#define CAMEL_KOLAB_IMAPX_FOLDER_CLASS(klass)	  \
	(G_TYPE_CHECK_CLASS_CAST \
	 ((klass), CAMEL_TYPE_KOLAB_IMAPX_FOLDER, CamelKolabIMAPXFolderClass))
#define CAMEL_IS_KOLAB_IMAPX_FOLDER(obj)	  \
	(G_TYPE_CHECK_INSTANCE_TYPE \
	 ((obj), CAMEL_TYPE_KOLAB_IMAPX_FOLDER))
#define CAMEL_IS_KOLAB_IMAPX_FOLDER_CLASS(klass)	  \
	(G_TYPE_CHECK_CLASS_TYPE \
	 ((klass), CAMEL_TYPE_KOLAB_IMAPX_FOLDER))
#define CAMEL_KOLAB_IMAPX_FOLDER_GET_CLASS(obj)	  \
	(G_TYPE_INSTANCE_GET_CLASS \
	 ((obj), CAMEL_TYPE_KOLAB_IMAPX_FOLDER, CamelKolabIMAPXFolderClass))

G_BEGIN_DECLS

typedef struct _CamelKolabIMAPXFolder CamelKolabIMAPXFolder;
typedef struct _CamelKolabIMAPXFolderClass CamelKolabIMAPXFolderClass;

struct _CamelKolabIMAPXFolder {
	CamelIMAPXExtdFolder parent;
};

struct _CamelKolabIMAPXFolderClass {
	CamelIMAPXExtdFolderClass parent_class;
};

GType
camel_kolab_imapx_folder_get_type (void);

CamelKolabIMAPXFolder*
camel_kolab_imapx_folder_new (struct _CamelKolabIMAPXStore *store,
                              const gchar *folder_dir,
                              const gchar *folder_name,
                              GError **err);

guint64
camel_kolab_imapx_folder_get_uidvalidity (CamelKolabIMAPXFolder *self,
                                          GError **err);

G_END_DECLS

/*----------------------------------------------------------------------------*/

#endif /* _CAMEL_KOLAB_IMAPX_FOLDER_H_ */

/*----------------------------------------------------------------------------*/
