/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 8; tab-width: 8 -*- */
/***************************************************************************
 *            camel-kolab-imapx-conn-manager.c
 *
 *  2012-01-10, 17:07:28
 *  Copyright 2012, Christian Hilberg
 *  <hilberg@unix-ag.org>
 ****************************************************************************/

/*
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with main.c; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor Boston, MA 02110-1301,  USA
 */

/*----------------------------------------------------------------------------*/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "camel-kolab-imapx-conn-manager.h"

/*----------------------------------------------------------------------------*/

/* dupe of enum in camel/providers/imapx/camel-imapx-conn-manager.c */
enum {
	PROP_0,
	PROP_STORE
};

G_DEFINE_TYPE (CamelKolabIMAPXConnManager, camel_kolab_imapx_conn_manager, CAMEL_TYPE_IMAPX_EXTD_CONN_MANAGER)

/*----------------------------------------------------------------------------*/
/* object init */

static void
camel_kolab_imapx_conn_manager_init (CamelKolabIMAPXConnManager *self)
{
	g_assert (CAMEL_IS_KOLAB_IMAPX_CONN_MANAGER (self));
}

static void
camel_kolab_imapx_conn_manager_dispose (GObject *object)
{
	g_assert (CAMEL_IS_KOLAB_IMAPX_CONN_MANAGER (object));

	G_OBJECT_CLASS (camel_kolab_imapx_conn_manager_parent_class)->dispose (object);
}

static void
camel_kolab_imapx_conn_manager_finalize (GObject *object)
{
	g_assert (CAMEL_IS_KOLAB_IMAPX_CONN_MANAGER (object));

	G_OBJECT_CLASS (camel_kolab_imapx_conn_manager_parent_class)->finalize (object);
}

/*----------------------------------------------------------------------------*/
/* class functions */

static CamelStore*
kolab_imapx_conn_manager_get_store (CamelIMAPXConnManager *self)
{
	CamelStore *store = NULL;

	g_assert (CAMEL_IS_KOLAB_IMAPX_CONN_MANAGER (self));

	store = camel_imapx_extd_conn_manager_get_store (self);
	g_assert (CAMEL_IS_KOLAB_IMAPX_STORE (store));

	return store;
}

static CamelIMAPXServer*
kolab_imapx_conn_manager_get_connection (CamelIMAPXConnManager *self,
                                         const gchar *foldername,
                                         GCancellable *cancellable,
                                         GError **err)
{
	CamelIMAPXServer *server = NULL;
	GError *tmp_err = NULL;

	g_assert (CAMEL_IS_KOLAB_IMAPX_CONN_MANAGER (self));
	g_assert (foldername != NULL);
	/* cancellable may be NULL */
	g_return_val_if_fail (err == NULL || *err == NULL, NULL);

	server = camel_imapx_extd_conn_manager_get_connection (self,
	                                                       foldername,
	                                                       cancellable,
	                                                       &tmp_err);
	if (server == NULL) {
		if (tmp_err != NULL)
			g_propagate_error (err, tmp_err);
		return NULL;
	}

	g_assert (CAMEL_IS_KOLAB_IMAPX_SERVER (server));

	return server;
}

static void
kolab_imapx_conn_manager_close_connections (CamelIMAPXConnManager *self)
{
	g_assert (CAMEL_IS_KOLAB_IMAPX_CONN_MANAGER (self));

	camel_imapx_extd_conn_manager_close_connections (self);
}

static GList*
kolab_imapx_conn_manager_get_connections (CamelIMAPXConnManager *self)
{
	GList *cn = NULL;

	g_assert (CAMEL_IS_KOLAB_IMAPX_CONN_MANAGER (self));

	cn = camel_imapx_extd_conn_manager_get_connections (self);

	/* TODO type-check list elements? */

	return cn;
}

static void
kolab_imapx_conn_manager_update_con_info (CamelIMAPXConnManager *self,
                                          CamelIMAPXServer *server,
                                          const gchar *foldername)
{
	g_assert (CAMEL_IS_KOLAB_IMAPX_CONN_MANAGER (self));
	g_assert (CAMEL_IS_KOLAB_IMAPX_SERVER (server));
	g_assert (foldername != NULL);

	camel_imapx_extd_conn_manager_update_con_info (self,
	                                               server,
	                                               foldername);
}

/*----------------------------------------------------------------------------*/
/* class init */

static void
camel_kolab_imapx_conn_manager_class_init (CamelKolabIMAPXConnManagerClass *klass)
{
	GObjectClass *object_class = G_OBJECT_CLASS (klass);
	GObjectClass *gobj_p_class = NULL;
	CamelIMAPXExtdConnManagerClass *parent_class = CAMEL_IMAPX_EXTD_CONN_MANAGER_CLASS (klass);

	gobj_p_class = G_OBJECT_CLASS (camel_kolab_imapx_conn_manager_parent_class);
	object_class->set_property = gobj_p_class->set_property;
	object_class->get_property = gobj_p_class->get_property;

	object_class->dispose = camel_kolab_imapx_conn_manager_dispose;
	object_class->finalize = camel_kolab_imapx_conn_manager_finalize;

	parent_class->get_store = kolab_imapx_conn_manager_get_store;
	parent_class->get_connection = kolab_imapx_conn_manager_get_connection;
	parent_class->close_connections = kolab_imapx_conn_manager_close_connections;
	parent_class->get_connections = kolab_imapx_conn_manager_get_connections;
	parent_class->update_con_info = kolab_imapx_conn_manager_update_con_info;

	/* duped from parent */
	g_object_class_install_property (object_class,
	                                 PROP_STORE,
	                                 g_param_spec_object ("store",
	                                                      "Store",
	                                                      "The CamelStore to which we belong",
	                                                      CAMEL_TYPE_STORE,
	                                                      G_PARAM_READWRITE |
	                                                      G_PARAM_CONSTRUCT_ONLY |
	                                                      G_PARAM_STATIC_STRINGS));
}

/*----------------------------------------------------------------------------*/
/* API functions */

CamelKolabIMAPXConnManager*
camel_kolab_imapx_conn_manager_new (CamelKolabIMAPXStore *store)
{
	CamelKolabIMAPXConnManager *self = NULL;

	g_return_val_if_fail (CAMEL_IS_KOLAB_IMAPX_STORE (store), NULL);

	self = g_object_new (CAMEL_TYPE_KOLAB_IMAPX_CONN_MANAGER,
	                     "store",
	                     CAMEL_STORE (store),
	                     NULL);
	return self;
}

/*----------------------------------------------------------------------------*/
