/* 
 * Declarations used throughout the djvu classes
 * 
 * Copyright (C) 2006, Michael Hofmann <mh21@piware.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#ifndef __DJVU_DOCUMENT_INTERNAL_H__
#define __DJVU_DOCUMENT_INTERNAL_H__

#include "djvu-document.h"
#include "djvu-text.h"

#include <libdjvu/ddjvuapi.h>

struct _DjvuDocument {
	GObject           parent_instance;

	ddjvu_context_t  *d_context;
	ddjvu_document_t *d_document;
	ddjvu_format_t   *d_format;

	gchar            *uri;

	DjvuText         *search;
};

int  djvu_document_get_n_pages (EvDocument   *document);
void djvu_handle_events        (DjvuDocument *djvu_document, 
			        int           wait);

#endif /* __DJVU_DOCUMENT_INTERNAL_H__ */
