/* ease-slide-button-panel.c generated by valac 0.10.0, the Vala compiler
 * generated from ease-slide-button-panel.vala, do not modify */

/*  Ease, a GTK presentation application
    Copyright (C) 2010 Nate Stedman

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <ease-core.h>
#include <stdlib.h>
#include <string.h>
#include <gdk-pixbuf/gdk-pixdata.h>
#include <float.h>
#include <math.h>
#include <cairo.h>
#include <glib/gi18n-lib.h>
#include <glib/gstdio.h>


#define EASE_TYPE_SLIDE_BUTTON_PANEL (ease_slide_button_panel_get_type ())
#define EASE_SLIDE_BUTTON_PANEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_SLIDE_BUTTON_PANEL, EaseSlideButtonPanel))
#define EASE_SLIDE_BUTTON_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_SLIDE_BUTTON_PANEL, EaseSlideButtonPanelClass))
#define EASE_IS_SLIDE_BUTTON_PANEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_SLIDE_BUTTON_PANEL))
#define EASE_IS_SLIDE_BUTTON_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_SLIDE_BUTTON_PANEL))
#define EASE_SLIDE_BUTTON_PANEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_SLIDE_BUTTON_PANEL, EaseSlideButtonPanelClass))

typedef struct _EaseSlideButtonPanel EaseSlideButtonPanel;
typedef struct _EaseSlideButtonPanelClass EaseSlideButtonPanelClass;
typedef struct _EaseSlideButtonPanelPrivate EaseSlideButtonPanelPrivate;

#define EASE_TYPE_EDITOR_WINDOW (ease_editor_window_get_type ())
#define EASE_EDITOR_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_EDITOR_WINDOW, EaseEditorWindow))
#define EASE_EDITOR_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_EDITOR_WINDOW, EaseEditorWindowClass))
#define EASE_IS_EDITOR_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_EDITOR_WINDOW))
#define EASE_IS_EDITOR_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_EDITOR_WINDOW))
#define EASE_EDITOR_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_EDITOR_WINDOW, EaseEditorWindowClass))

typedef struct _EaseEditorWindow EaseEditorWindow;
typedef struct _EaseEditorWindowClass EaseEditorWindowClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _ease_iterable_tree_model_iterator_unref0(var) ((var == NULL) ? NULL : (var = (ease_iterable_tree_model_iterator_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _EaseSlideButtonPanel {
	GtkScrolledWindow parent_instance;
	EaseSlideButtonPanelPrivate * priv;
};

struct _EaseSlideButtonPanelClass {
	GtkScrolledWindowClass parent_class;
};

struct _EaseSlideButtonPanelPrivate {
	EaseDocument* document;
	EaseEditorWindow* owner;
	GtkTreeView* slides;
	GtkCellRendererPixbuf* renderer;
};


static char* ease_slide_button_panel_m_temp_dir;
static char* ease_slide_button_panel_m_temp_dir = NULL;
static gint ease_slide_button_panel_temp_count;
static gint ease_slide_button_panel_temp_count = 0;
static gpointer ease_slide_button_panel_parent_class = NULL;

GType ease_slide_button_panel_get_type (void) G_GNUC_CONST;
GType ease_editor_window_get_type (void) G_GNUC_CONST;
#define EASE_SLIDE_BUTTON_PANEL_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), EASE_TYPE_SLIDE_BUTTON_PANEL, EaseSlideButtonPanelPrivate))
enum  {
	EASE_SLIDE_BUTTON_PANEL_DUMMY_PROPERTY
};
#define EASE_SLIDE_BUTTON_PANEL_WIDTH_REQUEST 100
#define EASE_SLIDE_BUTTON_PANEL_PREV_WIDTH 76
#define EASE_SLIDE_BUTTON_PANEL_PADDING 4
EaseSlideButtonPanel* ease_slide_button_panel_new (EaseDocument* d, EaseEditorWindow* win);
EaseSlideButtonPanel* ease_slide_button_panel_construct (GType object_type, EaseDocument* d, EaseEditorWindow* win);
static void ease_slide_button_panel_slide_redraw (EaseSlideButtonPanel* self, GtkTreeIter* itr);
static void ease_slide_button_panel_on_slide_changed (EaseSlideButtonPanel* self, EaseSlide* slide);
static void _ease_slide_button_panel_on_slide_changed_ease_slide_changed (EaseSlide* _sender, EaseSlide* _self_, gpointer self);
static void _ease_slide_button_panel_on_slide_changed_ease_slide_background_changed (EaseSlide* _sender, EaseSlide* _self_, gpointer self);
static void _lambda4_ (GtkTreeSelection* sender, EaseSlideButtonPanel* self);
static void _lambda5_ (GtkTreeModel* m, GtkTreePath* p, GtkTreeIter* itr, EaseSlideButtonPanel* self);
void ease_editor_window_set_slide (EaseEditorWindow* self, gint index);
static void __lambda5__gtk_tree_selection_foreach_func (GtkTreeModel* model, GtkTreePath* path, GtkTreeIter* iter, gpointer self);
static void __lambda4__gtk_tree_selection_changed (GtkTreeSelection* _sender, gpointer self);
static void _lambda47_ (EaseSlide* slide, gint index, EaseSlideButtonPanel* self);
static void __lambda47__ease_document_slide_added (EaseDocument* _sender, EaseSlide* slide, gint index, gpointer self);
static void _lambda48_ (EaseSlide* slide, gint index, EaseSlideButtonPanel* self);
static void __lambda48__ease_document_slide_deleted (EaseDocument* _sender, EaseSlide* slide, gint index, gpointer self);
void ease_slide_button_panel_select_slide (EaseSlideButtonPanel* self, EaseSlide* slide);
GdkPixbuf* ease_slide_button_panel_pixbuf (EaseSlide* slide, gint width);
static const char* ease_slide_button_panel_get_temp_dir (void);
static void ease_slide_button_panel_finalize (GObject* obj);
static void ease_slide_button_panel_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);



/**
 * Creates a SlideButtonPanel
 * 
 * A SlideButtonPanel forms the left edge of an {@link EditorWindow}.
 *
 * @param d The Document that the {@link EditorWindow} displays.
 * @param win The {@link EditorWindow} that this SlideButtonPanel is
 * part of.
 */
static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


#line 222 "ease-slide-button-panel.vala"
static void _ease_slide_button_panel_on_slide_changed_ease_slide_changed (EaseSlide* _sender, EaseSlide* _self_, gpointer self) {
#line 134 "ease-slide-button-panel.c"
	ease_slide_button_panel_on_slide_changed (self, _self_);
}


#line 222 "ease-slide-button-panel.vala"
static void _ease_slide_button_panel_on_slide_changed_ease_slide_background_changed (EaseSlide* _sender, EaseSlide* _self_, gpointer self) {
#line 141 "ease-slide-button-panel.c"
	ease_slide_button_panel_on_slide_changed (self, _self_);
}


#line 103 "ease-slide-button-panel.vala"
static void _lambda5_ (GtkTreeModel* m, GtkTreePath* p, GtkTreeIter* itr, EaseSlideButtonPanel* self) {
#line 148 "ease-slide-button-panel.c"
	EaseSlide* sl;
#line 103 "ease-slide-button-panel.vala"
	g_return_if_fail (m != NULL);
#line 103 "ease-slide-button-panel.vala"
	g_return_if_fail (p != NULL);
#line 154 "ease-slide-button-panel.c"
	sl = NULL;
#line 105 "ease-slide-button-panel.vala"
	gtk_tree_model_get (m, itr, EASE_DOCUMENT_COL_SLIDE, &sl, -1);
#line 106 "ease-slide-button-panel.vala"
	ease_editor_window_set_slide (self->priv->owner, ease_document_index_of (self->priv->document, sl));
#line 160 "ease-slide-button-panel.c"
	_g_object_unref0 (sl);
}


#line 103 "ease-slide-button-panel.vala"
static void __lambda5__gtk_tree_selection_foreach_func (GtkTreeModel* model, GtkTreePath* path, GtkTreeIter* iter, gpointer self) {
#line 167 "ease-slide-button-panel.c"
	_lambda5_ (model, path, iter, self);
}


#line 102 "ease-slide-button-panel.vala"
static void _lambda4_ (GtkTreeSelection* sender, EaseSlideButtonPanel* self) {
#line 102 "ease-slide-button-panel.vala"
	g_return_if_fail (sender != NULL);
#line 103 "ease-slide-button-panel.vala"
	gtk_tree_selection_selected_foreach (gtk_tree_view_get_selection (self->priv->slides), __lambda5__gtk_tree_selection_foreach_func, self);
#line 178 "ease-slide-button-panel.c"
}


#line 102 "ease-slide-button-panel.vala"
static void __lambda4__gtk_tree_selection_changed (GtkTreeSelection* _sender, gpointer self) {
#line 184 "ease-slide-button-panel.c"
	_lambda4_ (_sender, self);
}


#line 110 "ease-slide-button-panel.vala"
static void _lambda47_ (EaseSlide* slide, gint index, EaseSlideButtonPanel* self) {
#line 110 "ease-slide-button-panel.vala"
	g_return_if_fail (slide != NULL);
#line 111 "ease-slide-button-panel.vala"
	ease_slide_button_panel_on_slide_changed (self, slide);
#line 112 "ease-slide-button-panel.vala"
	g_signal_connect_object (slide, "changed", (GCallback) _ease_slide_button_panel_on_slide_changed_ease_slide_changed, self, 0);
#line 113 "ease-slide-button-panel.vala"
	g_signal_connect_object (slide, "background-changed", (GCallback) _ease_slide_button_panel_on_slide_changed_ease_slide_background_changed, self, 0);
#line 199 "ease-slide-button-panel.c"
}


#line 110 "ease-slide-button-panel.vala"
static void __lambda47__ease_document_slide_added (EaseDocument* _sender, EaseSlide* slide, gint index, gpointer self) {
#line 205 "ease-slide-button-panel.c"
	_lambda47_ (slide, index, self);
}


#line 116 "ease-slide-button-panel.vala"
static void _lambda48_ (EaseSlide* slide, gint index, EaseSlideButtonPanel* self) {
#line 212 "ease-slide-button-panel.c"
	guint _tmp0_;
	guint _tmp1_;
#line 116 "ease-slide-button-panel.vala"
	g_return_if_fail (slide != NULL);
#line 117 "ease-slide-button-panel.vala"
	g_signal_parse_name ("changed", EASE_TYPE_SLIDE, &_tmp0_, NULL, FALSE);
#line 117 "ease-slide-button-panel.vala"
	g_signal_handlers_disconnect_matched (slide, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp0_, 0, NULL, (GCallback) _ease_slide_button_panel_on_slide_changed_ease_slide_changed, self);
#line 118 "ease-slide-button-panel.vala"
	g_signal_parse_name ("background-changed", EASE_TYPE_SLIDE, &_tmp1_, NULL, FALSE);
#line 118 "ease-slide-button-panel.vala"
	g_signal_handlers_disconnect_matched (slide, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _ease_slide_button_panel_on_slide_changed_ease_slide_background_changed, self);
#line 225 "ease-slide-button-panel.c"
}


#line 116 "ease-slide-button-panel.vala"
static void __lambda48__ease_document_slide_deleted (EaseDocument* _sender, EaseSlide* slide, gint index, gpointer self) {
#line 231 "ease-slide-button-panel.c"
	_lambda48_ (slide, index, self);
}


#line 63 "ease-slide-button-panel.vala"
EaseSlideButtonPanel* ease_slide_button_panel_construct (GType object_type, EaseDocument* d, EaseEditorWindow* win) {
#line 238 "ease-slide-button-panel.c"
	EaseSlideButtonPanel * self;
	EaseDocument* _tmp0_;
	EaseEditorWindow* _tmp1_;
	GtkTreeView* _tmp2_;
	GtkCellRendererPixbuf* _tmp3_;
	GtkViewport* viewport;
	EaseSlide* s;
#line 63 "ease-slide-button-panel.vala"
	g_return_val_if_fail (d != NULL, NULL);
#line 63 "ease-slide-button-panel.vala"
	g_return_val_if_fail (win != NULL, NULL);
#line 250 "ease-slide-button-panel.c"
	self = g_object_newv (object_type, 0, NULL);
#line 65 "ease-slide-button-panel.vala"
	self->priv->document = (_tmp0_ = _g_object_ref0 (d), _g_object_unref0 (self->priv->document), _tmp0_);
#line 66 "ease-slide-button-panel.vala"
	self->priv->owner = (_tmp1_ = _g_object_ref0 (win), _g_object_unref0 (self->priv->owner), _tmp1_);
#line 67 "ease-slide-button-panel.vala"
	g_object_set ((GtkWidget*) self, "width-request", EASE_SLIDE_BUTTON_PANEL_WIDTH_REQUEST, NULL);
#line 70 "ease-slide-button-panel.vala"
	g_object_set ((GtkScrolledWindow*) self, "vscrollbar-policy", GTK_POLICY_AUTOMATIC, NULL);
#line 71 "ease-slide-button-panel.vala"
	g_object_set ((GtkScrolledWindow*) self, "hscrollbar-policy", GTK_POLICY_NEVER, NULL);
#line 72 "ease-slide-button-panel.vala"
	gtk_scrolled_window_set_shadow_type ((GtkScrolledWindow*) self, GTK_SHADOW_IN);
#line 75 "ease-slide-button-panel.vala"
	self->priv->slides = (_tmp2_ = g_object_ref_sink ((GtkTreeView*) gtk_tree_view_new ()), _g_object_unref0 (self->priv->slides), _tmp2_);
#line 76 "ease-slide-button-panel.vala"
	gtk_tree_view_set_reorderable (self->priv->slides, TRUE);
#line 77 "ease-slide-button-panel.vala"
	gtk_tree_view_set_headers_visible (self->priv->slides, FALSE);
#line 78 "ease-slide-button-panel.vala"
	self->priv->renderer = (_tmp3_ = g_object_ref_sink ((GtkCellRendererPixbuf*) gtk_cell_renderer_pixbuf_new ()), _g_object_unref0 (self->priv->renderer), _tmp3_);
#line 79 "ease-slide-button-panel.vala"
	gtk_cell_renderer_set_padding ((GtkCellRenderer*) self->priv->renderer, EASE_SLIDE_BUTTON_PANEL_PADDING, EASE_SLIDE_BUTTON_PANEL_PADDING);
#line 80 "ease-slide-button-panel.vala"
	gtk_tree_view_insert_column_with_attributes (self->priv->slides, -1, "Slides", (GtkCellRenderer*) self->priv->renderer, "pixbuf", EASE_DOCUMENT_COL_PIXBUF, NULL);
#line 82 "ease-slide-button-panel.vala"
	gtk_tree_view_set_model (self->priv->slides, (GtkTreeModel*) ease_document_get_slides (self->priv->document));
#line 86 "ease-slide-button-panel.vala"
	viewport = g_object_ref_sink ((GtkViewport*) gtk_viewport_new (NULL, NULL));
#line 87 "ease-slide-button-panel.vala"
	gtk_viewport_set_shadow_type (viewport, GTK_SHADOW_NONE);
#line 88 "ease-slide-button-panel.vala"
	gtk_container_add ((GtkContainer*) viewport, (GtkWidget*) self->priv->slides);
#line 89 "ease-slide-button-panel.vala"
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) viewport);
#line 286 "ease-slide-button-panel.c"
	s = NULL;
	{
		EaseIterableTreeModelIterator* _itr_it;
#line 93 "ease-slide-button-panel.vala"
		_itr_it = ease_iterable_tree_model_iterator ((EaseIterableTreeModel*) ease_document_get_slides (self->priv->document));
#line 93 "ease-slide-button-panel.vala"
		while (TRUE) {
#line 294 "ease-slide-button-panel.c"
			GtkTreeIter _tmp4_ = {0};
			GtkTreeIter itr;
#line 93 "ease-slide-button-panel.vala"
			if (!ease_iterable_tree_model_iterator_next (_itr_it)) {
#line 93 "ease-slide-button-panel.vala"
				break;
#line 301 "ease-slide-button-panel.c"
			}
#line 93 "ease-slide-button-panel.vala"
			itr = (ease_iterable_tree_model_iterator_get (_itr_it, &_tmp4_), _tmp4_);
#line 95 "ease-slide-button-panel.vala"
			ease_slide_button_panel_slide_redraw (self, &itr);
#line 96 "ease-slide-button-panel.vala"
			gtk_tree_model_get ((GtkTreeModel*) ease_document_get_slides (self->priv->document), &itr, EASE_DOCUMENT_COL_SLIDE, &s, -1);
#line 97 "ease-slide-button-panel.vala"
			g_signal_connect_object (s, "changed", (GCallback) _ease_slide_button_panel_on_slide_changed_ease_slide_changed, self, 0);
#line 98 "ease-slide-button-panel.vala"
			g_signal_connect_object (s, "background-changed", (GCallback) _ease_slide_button_panel_on_slide_changed_ease_slide_background_changed, self, 0);
#line 313 "ease-slide-button-panel.c"
		}
		_ease_iterable_tree_model_iterator_unref0 (_itr_it);
	}
#line 102 "ease-slide-button-panel.vala"
	g_signal_connect_object (gtk_tree_view_get_selection (self->priv->slides), "changed", (GCallback) __lambda4__gtk_tree_selection_changed, self, 0);
#line 110 "ease-slide-button-panel.vala"
	g_signal_connect_object (self->priv->document, "slide-added", (GCallback) __lambda47__ease_document_slide_added, self, 0);
#line 116 "ease-slide-button-panel.vala"
	g_signal_connect_object (self->priv->document, "slide-deleted", (GCallback) __lambda48__ease_document_slide_deleted, self, 0);
#line 323 "ease-slide-button-panel.c"
	_g_object_unref0 (s);
	_g_object_unref0 (viewport);
	return self;
}


#line 63 "ease-slide-button-panel.vala"
EaseSlideButtonPanel* ease_slide_button_panel_new (EaseDocument* d, EaseEditorWindow* win) {
#line 63 "ease-slide-button-panel.vala"
	return ease_slide_button_panel_construct (EASE_TYPE_SLIDE_BUTTON_PANEL, d, win);
#line 334 "ease-slide-button-panel.c"
}


/**
 * Selects a specified {@link Slide}.
 *
 * @param s The slide to select.
 */
#line 141 "ease-slide-button-panel.vala"
void ease_slide_button_panel_select_slide (EaseSlideButtonPanel* self, EaseSlide* slide) {
#line 345 "ease-slide-button-panel.c"
	GtkTreeIter itr = {0};
	EaseSlide* s;
#line 141 "ease-slide-button-panel.vala"
	g_return_if_fail (self != NULL);
#line 141 "ease-slide-button-panel.vala"
	g_return_if_fail (slide != NULL);
#line 144 "ease-slide-button-panel.vala"
	s = ease_slide_new ();
#line 145 "ease-slide-button-panel.vala"
	if (!gtk_tree_model_get_iter_first ((GtkTreeModel*) ease_document_get_slides (self->priv->document), &itr)) {
#line 356 "ease-slide-button-panel.c"
		_g_object_unref0 (s);
#line 145 "ease-slide-button-panel.vala"
		return;
#line 360 "ease-slide-button-panel.c"
	}
	{
		gboolean _tmp0_;
#line 146 "ease-slide-button-panel.vala"
		_tmp0_ = TRUE;
#line 146 "ease-slide-button-panel.vala"
		while (TRUE) {
#line 146 "ease-slide-button-panel.vala"
			if (!_tmp0_) {
#line 154 "ease-slide-button-panel.vala"
				if (!gtk_tree_model_iter_next ((GtkTreeModel*) ease_document_get_slides (self->priv->document), &itr)) {
#line 154 "ease-slide-button-panel.vala"
					break;
#line 374 "ease-slide-button-panel.c"
				}
			}
#line 146 "ease-slide-button-panel.vala"
			_tmp0_ = FALSE;
#line 148 "ease-slide-button-panel.vala"
			gtk_tree_model_get ((GtkTreeModel*) ease_document_get_slides (self->priv->document), &itr, EASE_DOCUMENT_COL_SLIDE, &s, -1);
#line 149 "ease-slide-button-panel.vala"
			if (s == slide) {
#line 151 "ease-slide-button-panel.vala"
				gtk_tree_selection_select_iter (gtk_tree_view_get_selection (self->priv->slides), &itr);
#line 152 "ease-slide-button-panel.vala"
				break;
#line 387 "ease-slide-button-panel.c"
			}
		}
	}
	_g_object_unref0 (s);
}


/**
 * Redraws a {@link Slide} when it is changed.
 *
 * @param itr An iterator pointing to the slide's row.
 */
#line 162 "ease-slide-button-panel.vala"
static void ease_slide_button_panel_slide_redraw (EaseSlideButtonPanel* self, GtkTreeIter* itr) {
#line 402 "ease-slide-button-panel.c"
	EaseSlide* slide;
	GdkPixbuf* pb;
#line 162 "ease-slide-button-panel.vala"
	g_return_if_fail (self != NULL);
#line 407 "ease-slide-button-panel.c"
	slide = NULL;
#line 166 "ease-slide-button-panel.vala"
	gtk_tree_model_get ((GtkTreeModel*) ease_document_get_slides (self->priv->document), itr, EASE_DOCUMENT_COL_SLIDE, &slide, -1);
#line 169 "ease-slide-button-panel.vala"
	pb = ease_slide_button_panel_pixbuf (slide, EASE_SLIDE_BUTTON_PANEL_PREV_WIDTH);
#line 170 "ease-slide-button-panel.vala"
	gtk_list_store_set ((GtkListStore*) ease_document_get_slides (self->priv->document), itr, EASE_DOCUMENT_COL_PIXBUF, pb, -1);
#line 415 "ease-slide-button-panel.c"
	_g_object_unref0 (pb);
	_g_object_unref0 (slide);
}


/**
 * Creates a Gdk.Pixbuf for a given slide.
 *
 * @param slide The slide to create a pixbuf of.
 */
#line 178 "ease-slide-button-panel.vala"
GdkPixbuf* ease_slide_button_panel_pixbuf (EaseSlide* slide, gint width) {
#line 428 "ease-slide-button-panel.c"
	GdkPixbuf* result = NULL;
	gint height;
	cairo_surface_t* surface;
	cairo_t* context;
	char* _tmp0_;
	char* _tmp1_;
	char* _tmp2_;
	char* path;
	GError * _inner_error_ = NULL;
#line 178 "ease-slide-button-panel.vala"
	g_return_val_if_fail (slide != NULL, NULL);
#line 180 "ease-slide-button-panel.vala"
	height = (gint) ((((float) width) * ease_slide_get_height (slide)) / ease_slide_get_width (slide));
#line 182 "ease-slide-button-panel.vala"
	surface = cairo_image_surface_create (CAIRO_FORMAT_RGB24, width, height);
#line 184 "ease-slide-button-panel.vala"
	context = cairo_create (surface);
#line 185 "ease-slide-button-panel.vala"
	cairo_save (context);
#line 186 "ease-slide-button-panel.vala"
	cairo_scale (context, (double) (((float) width) / ease_slide_get_width (slide)), (double) (((float) height) / ease_slide_get_height (slide)));
#line 450 "ease-slide-button-panel.c"
	{
#line 191 "ease-slide-button-panel.vala"
		ease_slide_cairo_render_small (slide, context);
#line 454 "ease-slide-button-panel.c"
	}
	goto __finally17;
	__catch17_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
#line 195 "ease-slide-button-panel.vala"
			g_critical (_ ("Error drawing slide preview: %s"), e->message);
#line 465 "ease-slide-button-panel.c"
			_g_error_free0 (e);
		}
	}
	__finally17:
	if (_inner_error_ != NULL) {
		_cairo_destroy0 (context);
		_cairo_surface_destroy0 (surface);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
#line 199 "ease-slide-button-panel.vala"
	cairo_restore (context);
#line 201 "ease-slide-button-panel.vala"
	cairo_rectangle (context, (double) 0, (double) 0, (double) width, (double) height);
#line 202 "ease-slide-button-panel.vala"
	cairo_set_source_rgb (context, (double) 0, (double) 0, (double) 0);
#line 203 "ease-slide-button-panel.vala"
	cairo_stroke (context);
#line 206 "ease-slide-button-panel.vala"
	path = (_tmp2_ = g_build_filename (ease_slide_button_panel_get_temp_dir (), _tmp1_ = g_strconcat (_tmp0_ = g_strdup_printf ("%i", ease_slide_button_panel_temp_count++), ".png", NULL), NULL), _g_free0 (_tmp1_), _g_free0 (_tmp0_), _tmp2_);
#line 208 "ease-slide-button-panel.vala"
	cairo_surface_write_to_png (surface, path);
#line 489 "ease-slide-button-panel.c"
	{
		GdkPixbuf* pb;
#line 212 "ease-slide-button-panel.vala"
		pb = gdk_pixbuf_new_from_file (path, &_inner_error_);
#line 494 "ease-slide-button-panel.c"
		if (_inner_error_ != NULL) {
			goto __catch18_g_error;
		}
#line 213 "ease-slide-button-panel.vala"
		g_remove (path);
#line 500 "ease-slide-button-panel.c"
		result = pb;
		_g_free0 (path);
		_cairo_destroy0 (context);
		_cairo_surface_destroy0 (surface);
#line 214 "ease-slide-button-panel.vala"
		return result;
#line 507 "ease-slide-button-panel.c"
	}
	goto __finally18;
	__catch18_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
#line 216 "ease-slide-button-panel.vala"
			g_error ("ease-slide-button-panel.vala:216: %s", e->message);
#line 518 "ease-slide-button-panel.c"
			_g_error_free0 (e);
		}
	}
	__finally18:
	{
		_g_free0 (path);
		_cairo_destroy0 (context);
		_cairo_surface_destroy0 (surface);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_g_free0 (path);
	_cairo_destroy0 (context);
	_cairo_surface_destroy0 (surface);
}


/**
 * Handles {@link Slide.changed}
 */
#line 222 "ease-slide-button-panel.vala"
static void ease_slide_button_panel_on_slide_changed (EaseSlideButtonPanel* self, EaseSlide* slide) {
#line 542 "ease-slide-button-panel.c"
	EaseSlide* s;
#line 222 "ease-slide-button-panel.vala"
	g_return_if_fail (self != NULL);
#line 222 "ease-slide-button-panel.vala"
	g_return_if_fail (slide != NULL);
#line 548 "ease-slide-button-panel.c"
	s = NULL;
	{
		EaseIterableTreeModelIterator* _itr_it;
#line 225 "ease-slide-button-panel.vala"
		_itr_it = ease_iterable_tree_model_iterator ((EaseIterableTreeModel*) ease_document_get_slides (self->priv->document));
#line 225 "ease-slide-button-panel.vala"
		while (TRUE) {
#line 556 "ease-slide-button-panel.c"
			GtkTreeIter _tmp0_ = {0};
			GtkTreeIter itr;
#line 225 "ease-slide-button-panel.vala"
			if (!ease_iterable_tree_model_iterator_next (_itr_it)) {
#line 225 "ease-slide-button-panel.vala"
				break;
#line 563 "ease-slide-button-panel.c"
			}
#line 225 "ease-slide-button-panel.vala"
			itr = (ease_iterable_tree_model_iterator_get (_itr_it, &_tmp0_), _tmp0_);
#line 227 "ease-slide-button-panel.vala"
			gtk_tree_model_get ((GtkTreeModel*) ease_document_get_slides (self->priv->document), &itr, EASE_DOCUMENT_COL_SLIDE, &s, -1);
#line 228 "ease-slide-button-panel.vala"
			if (s == slide) {
#line 230 "ease-slide-button-panel.vala"
				ease_slide_button_panel_slide_redraw (self, &itr);
#line 573 "ease-slide-button-panel.c"
				_ease_iterable_tree_model_iterator_unref0 (_itr_it);
				_g_object_unref0 (s);
#line 231 "ease-slide-button-panel.vala"
				return;
#line 578 "ease-slide-button-panel.c"
			}
		}
		_ease_iterable_tree_model_iterator_unref0 (_itr_it);
	}
	_g_object_unref0 (s);
}


static const char* ease_slide_button_panel_get_temp_dir (void) {
	const char* result;
	GError * _inner_error_ = NULL;
#line 39 "ease-slide-button-panel.vala"
	if (ease_slide_button_panel_m_temp_dir != NULL) {
#line 592 "ease-slide-button-panel.c"
		result = ease_slide_button_panel_m_temp_dir;
#line 39 "ease-slide-button-panel.vala"
		return result;
#line 596 "ease-slide-button-panel.c"
	}
	{
		char* _tmp0_;
		char* _tmp1_;
#line 40 "ease-slide-button-panel.vala"
		_tmp0_ = ease_temp_request_str ("thumbnails", &_inner_error_);
#line 603 "ease-slide-button-panel.c"
		if (_inner_error_ != NULL) {
			goto __catch19_g_error;
		}
		result = ease_slide_button_panel_m_temp_dir = (_tmp1_ = _tmp0_, _g_free0 (ease_slide_button_panel_m_temp_dir), _tmp1_);
#line 40 "ease-slide-button-panel.vala"
		return result;
#line 610 "ease-slide-button-panel.c"
	}
	goto __finally19;
	__catch19_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
#line 43 "ease-slide-button-panel.vala"
			g_critical ("ease-slide-button-panel.vala:43: Could not create temporary directory " \
"for thumbnails");
#line 621 "ease-slide-button-panel.c"
			_g_error_free0 (e);
		}
	}
	__finally19:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = NULL;
#line 45 "ease-slide-button-panel.vala"
	return result;
#line 634 "ease-slide-button-panel.c"
}


static void ease_slide_button_panel_class_init (EaseSlideButtonPanelClass * klass) {
	ease_slide_button_panel_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (EaseSlideButtonPanelPrivate));
	G_OBJECT_CLASS (klass)->get_property = ease_slide_button_panel_get_property;
	G_OBJECT_CLASS (klass)->finalize = ease_slide_button_panel_finalize;
}


static void ease_slide_button_panel_instance_init (EaseSlideButtonPanel * self) {
	self->priv = EASE_SLIDE_BUTTON_PANEL_GET_PRIVATE (self);
}


static void ease_slide_button_panel_finalize (GObject* obj) {
	EaseSlideButtonPanel * self;
	self = EASE_SLIDE_BUTTON_PANEL (obj);
	_g_object_unref0 (self->priv->document);
	_g_object_unref0 (self->priv->owner);
	_g_object_unref0 (self->priv->slides);
	_g_object_unref0 (self->priv->renderer);
	G_OBJECT_CLASS (ease_slide_button_panel_parent_class)->finalize (obj);
}


/**
 * Panel on the left side of an {@link EditorWindow}
 * 
 * SlideButtonPanel contains a Gtk.TreeView with displays slides as pixbufs,
 * rendered with Cairo.
 */
GType ease_slide_button_panel_get_type (void) {
	static volatile gsize ease_slide_button_panel_type_id__volatile = 0;
	if (g_once_init_enter (&ease_slide_button_panel_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (EaseSlideButtonPanelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ease_slide_button_panel_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (EaseSlideButtonPanel), 0, (GInstanceInitFunc) ease_slide_button_panel_instance_init, NULL };
		GType ease_slide_button_panel_type_id;
		ease_slide_button_panel_type_id = g_type_register_static (GTK_TYPE_SCROLLED_WINDOW, "EaseSlideButtonPanel", &g_define_type_info, 0);
		g_once_init_leave (&ease_slide_button_panel_type_id__volatile, ease_slide_button_panel_type_id);
	}
	return ease_slide_button_panel_type_id__volatile;
}


static void ease_slide_button_panel_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	EaseSlideButtonPanel * self;
	self = EASE_SLIDE_BUTTON_PANEL (object);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}




