/* ease-slide-actor.c generated by valac 0.10.0, the Vala compiler
 * generated from ease-slide-actor.vala, do not modify */

/*  Ease, a GTK presentation application
    Copyright (C) 2010 Nate Stedman

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>
#include <clutter/clutter.h>
#include <flutter.h>
#include <ease-core.h>
#include <float.h>
#include <math.h>
#include <cairo.h>
#include <cogl/cogl.h>
#include <stdlib.h>
#include <string.h>


#define EASE_TYPE_SLIDE_ACTOR (ease_slide_actor_get_type ())
#define EASE_SLIDE_ACTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_TYPE_SLIDE_ACTOR, EaseSlideActor))
#define EASE_SLIDE_ACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_TYPE_SLIDE_ACTOR, EaseSlideActorClass))
#define EASE_IS_SLIDE_ACTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_TYPE_SLIDE_ACTOR))
#define EASE_IS_SLIDE_ACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_TYPE_SLIDE_ACTOR))
#define EASE_SLIDE_ACTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_TYPE_SLIDE_ACTOR, EaseSlideActorClass))

typedef struct _EaseSlideActor EaseSlideActor;
typedef struct _EaseSlideActorClass EaseSlideActorClass;
typedef struct _EaseSlideActorPrivate EaseSlideActorPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _ease_slide_iterator_unref0(var) ((var == NULL) ? NULL : (var = (ease_slide_iterator_unref (var), NULL)))
#define _flutter_container_iterator_unref0(var) ((var == NULL) ? NULL : (var = (flutter_container_iterator_unref (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block6Data Block6Data;
typedef struct _Block7Data Block7Data;
typedef struct _Block8Data Block8Data;
typedef struct _Block9Data Block9Data;
typedef struct _Block10Data Block10Data;
typedef struct _Block11Data Block11Data;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block12Data Block12Data;
typedef struct _Block13Data Block13Data;
typedef struct _Block14Data Block14Data;
typedef struct _Block15Data Block15Data;
typedef struct _Block16Data Block16Data;
typedef struct _Block17Data Block17Data;

struct _EaseSlideActor {
	ClutterGroup parent_instance;
	EaseSlideActorPrivate * priv;
	ClutterCairoTexture* background;
	FlutterGroup* contents;
	EaseActorContext context;
};

struct _EaseSlideActorClass {
	ClutterGroupClass parent_class;
};

struct _EaseSlideActorPrivate {
	EaseSlide* _slide;
	float width_px;
	float height_px;
	ClutterTimeline* _animation_time;
	ClutterAlpha* _animation_alpha;
	ClutterTimeline* time1;
	ClutterTimeline* time2;
	ClutterAlpha* alpha1;
	ClutterAlpha* alpha2;
};

struct _Block6Data {
	int _ref_count_;
	EaseSlideActor * self;
	float xpos;
	float ypos;
	float angle;
	EaseSlideActor* new_slide;
};

struct _Block7Data {
	int _ref_count_;
	EaseSlideActor * self;
	ClutterRotateAxis axis;
	float positive;
	float x_point;
	float y_point;
	EaseSlideActor* new_slide;
};

struct _Block8Data {
	int _ref_count_;
	EaseSlideActor * self;
	ClutterRotateAxis axis;
	float positive;
	float x_point;
	float y_point;
	EaseSlideActor* new_slide;
};

struct _Block9Data {
	int _ref_count_;
	EaseSlideActor * self;
	ClutterGroup** groups;
	gint groups_length1;
	gint _groups_size_;
	float width;
	EaseSlideActor* new_slide;
	ClutterGroup* container;
};

struct _Block10Data {
	int _ref_count_;
	EaseSlideActor * self;
	float width;
	ClutterGroup* left_group;
	ClutterGroup* right_group;
	ClutterGroup* container;
};

struct _Block11Data {
	int _ref_count_;
	EaseSlideActor * self;
	EaseSlideActor* new_slide;
};

struct _Block12Data {
	int _ref_count_;
	EaseSlideActor * self;
	float pos;
	char* property;
	EaseSlideActor* new_slide;
	guint length;
};

struct _Block13Data {
	int _ref_count_;
	EaseSlideActor * self;
	float angle;
	EaseSlideActor* new_slide;
};

struct _Block14Data {
	int _ref_count_;
	EaseSlideActor * self;
	EaseSlideActor* new_slide;
};

struct _Block15Data {
	int _ref_count_;
	EaseSlideActor * self;
	EaseSlideActor* new_slide;
};

struct _Block16Data {
	int _ref_count_;
	EaseSlideActor * self;
	gint count;
	ClutterClone** particles;
	gint particles_length1;
	gint _particles_size_;
	ClutterGroup* container;
};

struct _Block17Data {
	int _ref_count_;
	EaseSlideActor * self;
	gint count;
	ClutterClone** particles;
	gint particles_length1;
	gint _particles_size_;
	EaseSlideActor* new_slide;
	ClutterGroup* container;
};


static gpointer ease_slide_actor_parent_class = NULL;

GType ease_slide_actor_get_type (void) G_GNUC_CONST;
#define EASE_SLIDE_ACTOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), EASE_TYPE_SLIDE_ACTOR, EaseSlideActorPrivate))
enum  {
	EASE_SLIDE_ACTOR_DUMMY_PROPERTY,
	EASE_SLIDE_ACTOR_SLIDE,
	EASE_SLIDE_ACTOR_ANIMATION_TIME
};
#define EASE_SLIDE_ACTOR_EASE_SLIDE ((gint) CLUTTER_EASE_IN_OUT_SINE)
#define EASE_SLIDE_ACTOR_EASE_DROP ((gint) CLUTTER_EASE_OUT_BOUNCE)
#define EASE_SLIDE_ACTOR_EASE_PIVOT ((gint) CLUTTER_EASE_OUT_SINE)
#define EASE_SLIDE_ACTOR_FLIP_DEPTH ((float) (-400))
#define EASE_SLIDE_ACTOR_PANEL_SCALE 0.75f
#define EASE_SLIDE_ACTOR_OPEN_DEPTH ((float) (-3000))
#define EASE_SLIDE_ACTOR_OPEN_MOVE 0.15f
#define EASE_SLIDE_ACTOR_OPEN_TIME 0.8f
#define EASE_SLIDE_ACTOR_SLAT_COUNT 8
#define EASE_SLIDE_ACTOR_REFLECTION_OPACITY 70
#define EASE_SLIDE_ACTOR_EXPLODE_PARTICLES 10
#define EASE_SLIDE_ACTOR_ASSEMBLE_TILES 12
EaseSlideActor* ease_slide_actor_new_from_slide (EaseDocument* document, EaseSlide* s, gboolean clip, EaseActorContext ctx);
EaseSlideActor* ease_slide_actor_construct_from_slide (GType object_type, EaseDocument* document, EaseSlide* s, gboolean clip, EaseActorContext ctx);
EaseSlideActor* ease_slide_actor_new_with_dimensions (float w, float h, EaseSlide* s, gboolean clip, EaseActorContext ctx);
EaseSlideActor* ease_slide_actor_construct_with_dimensions (GType object_type, float w, float h, EaseSlide* s, gboolean clip, EaseActorContext ctx);
void ease_slide_actor_set_slide (EaseSlideActor* self, EaseSlide* value);
static void ease_slide_actor_set_background (EaseSlideActor* self);
EaseSlide* ease_slide_actor_get_slide (EaseSlideActor* self);
static void _lambda7_ (EaseSlide* s, EaseSlideActor* self);
static void __lambda7__ease_slide_background_changed (EaseSlide* _sender, EaseSlide* _self_, gpointer self);
void ease_slide_actor_on_element_added (EaseSlideActor* self, EaseSlide* slide, EaseElement* element, gint index);
static void _ease_slide_actor_on_element_added_ease_slide_element_added (EaseSlide* _sender, EaseSlide* _self_, EaseElement* element, gint index, gpointer self);
void ease_slide_actor_on_element_removed (EaseSlideActor* self, EaseSlide* slide, EaseElement* element, gint index);
static void _ease_slide_actor_on_element_removed_ease_slide_element_removed (EaseSlide* _sender, EaseSlide* _self_, EaseElement* element, gint index, gpointer self);
static void _lambda8_ (EaseSlide* s, EaseElement* e, EaseSlideActor* self);
static void ease_slide_actor_reorder (EaseSlideActor* self);
static void __lambda8__ease_slide_element_reordered (EaseSlide* _sender, EaseSlide* _self_, EaseElement* element, gpointer self);
EaseSlideActor* ease_slide_actor_new_blank (EaseDocument* document, ClutterColor* color);
EaseSlideActor* ease_slide_actor_construct_blank (GType object_type, EaseDocument* document, ClutterColor* color);
void ease_slide_actor_reset (EaseSlideActor* self, ClutterGroup* container);
static void ease_slide_actor_reset_actor (EaseSlideActor* self, ClutterActor* actor);
void ease_slide_actor_stack (EaseSlideActor* self, ClutterActor* container);
void ease_slide_actor_relayout (EaseSlideActor* self);
void ease_slide_actor_unstack (EaseSlideActor* self, EaseSlideActor* other, ClutterActor* container);
static void ease_slide_actor_prepare_slide_transition (EaseSlideActor* self, EaseSlideActor* new_slide, ClutterGroup* container);
static void ease_slide_actor_prepare_stack_transition (EaseSlideActor* self, gboolean current_on_top, EaseSlideActor* new_slide, ClutterGroup* container);
void ease_slide_actor_transition (EaseSlideActor* self, EaseSlideActor* new_slide, ClutterGroup* container);
void ease_slide_actor_set_animation_time (EaseSlideActor* self, ClutterTimeline* value);
static void ease_slide_actor_slide_transition (EaseSlideActor* self, EaseSlideActor* new_slide, ClutterGroup* container, guint length);
static void ease_slide_actor_drop_transition (EaseSlideActor* self, EaseSlideActor* new_slide, ClutterGroup* container, guint length);
static void ease_slide_actor_pivot_transition (EaseSlideActor* self, EaseSlideActor* new_slide, ClutterGroup* container, guint length);
static void ease_slide_actor_open_door_transition (EaseSlideActor* self, EaseSlideActor* new_slide, ClutterGroup* container, guint length);
static void ease_slide_actor_reveal_transition (EaseSlideActor* self, EaseSlideActor* new_slide, ClutterGroup* container, guint length);
static void ease_slide_actor_slats_transition (EaseSlideActor* self, EaseSlideActor* new_slide, ClutterGroup* container, guint length);
static void ease_slide_actor_flip_transition (EaseSlideActor* self, EaseSlideActor* new_slide, ClutterGroup* container, guint length);
static void ease_slide_actor_revolving_door_transition (EaseSlideActor* self, EaseSlideActor* new_slide, ClutterGroup* container, guint length);
static void ease_slide_actor_fall_transition (EaseSlideActor* self, EaseSlideActor* new_slide, ClutterGroup* container, guint length);
static void ease_slide_actor_spin_contents_transition (EaseSlideActor* self, EaseSlideActor* new_slide, ClutterGroup* container, guint length);
static void ease_slide_actor_swing_contents_transition (EaseSlideActor* self, EaseSlideActor* new_slide, ClutterGroup* container, guint length);
static void ease_slide_actor_zoom_transition (EaseSlideActor* self, EaseSlideActor* new_slide, ClutterGroup* container, guint length);
static void ease_slide_actor_intersperse_contents_transition (EaseSlideActor* self, EaseSlideActor* new_slide, ClutterGroup* container, guint length);
static void ease_slide_actor_slide_contents_transition (EaseSlideActor* self, EaseSlideActor* new_slide, ClutterGroup* container, guint length);
static void ease_slide_actor_spring_contents_transition (EaseSlideActor* self, EaseSlideActor* new_slide, ClutterGroup* container, guint length);
static void ease_slide_actor_zoom_contents_transition (EaseSlideActor* self, EaseSlideActor* new_slide, ClutterGroup* container, guint length);
static void ease_slide_actor_panel_transition (EaseSlideActor* self, EaseSlideActor* new_slide, ClutterGroup* container, guint length);
static void ease_slide_actor_explode_transition (EaseSlideActor* self, EaseSlideActor* new_slide, ClutterGroup* container, guint length);
static void ease_slide_actor_assemble_transition (EaseSlideActor* self, EaseSlideActor* new_slide, ClutterGroup* container, guint length);
static void ease_slide_actor_fade_transition (EaseSlideActor* self, EaseSlideActor* new_slide, ClutterGroup* container, guint length);
ClutterTimeline* ease_slide_actor_get_animation_time (EaseSlideActor* self);
static void ease_slide_actor_set_animation_alpha (EaseSlideActor* self, ClutterAlpha* value);
static void _lambda9_ (gint m, Block6Data* _data6_);
static ClutterAlpha* ease_slide_actor_get_animation_alpha (EaseSlideActor* self);
static void __lambda9__clutter_timeline_new_frame (ClutterTimeline* _sender, gint frame_num, gpointer self);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (Block6Data* _data6_);
static void _lambda14_ (gint m, Block7Data* _data7_);
static void __lambda14__clutter_timeline_new_frame (ClutterTimeline* _sender, gint frame_num, gpointer self);
static void _lambda15_ (gint m, Block7Data* _data7_);
static void __lambda15__clutter_timeline_new_frame (ClutterTimeline* _sender, gint frame_num, gpointer self);
static void _lambda16_ (Block7Data* _data7_);
static void __lambda16__clutter_timeline_completed (ClutterTimeline* _sender, gpointer self);
static Block7Data* block7_data_ref (Block7Data* _data7_);
static void block7_data_unref (Block7Data* _data7_);
static void _lambda17_ (gint m, Block8Data* _data8_);
static void __lambda17__clutter_timeline_new_frame (ClutterTimeline* _sender, gint frame_num, gpointer self);
static Block8Data* block8_data_ref (Block8Data* _data8_);
static void block8_data_unref (Block8Data* _data8_);
static void _lambda18_ (gint m, EaseSlideActor* self);
static void __lambda18__clutter_timeline_new_frame (ClutterTimeline* _sender, gint frame_num, gpointer self);
static void _lambda12_ (gint m, Block9Data* _data9_);
static void __lambda12__clutter_timeline_new_frame (ClutterTimeline* _sender, gint frame_num, gpointer self);
static void _lambda13_ (Block9Data* _data9_);
static void __lambda13__clutter_timeline_completed (ClutterTimeline* _sender, gpointer self);
static Block9Data* block9_data_ref (Block9Data* _data9_);
static void block9_data_unref (Block9Data* _data9_);
static void _lambda10_ (gint m, Block10Data* _data10_);
static void __lambda10__clutter_timeline_new_frame (ClutterTimeline* _sender, gint frame_num, gpointer self);
static void _lambda11_ (Block10Data* _data10_);
static void __lambda11__clutter_timeline_completed (ClutterTimeline* _sender, gpointer self);
static Block10Data* block10_data_ref (Block10Data* _data10_);
static void block10_data_unref (Block10Data* _data10_);
static void _lambda26_ (gint m, Block11Data* _data11_);
static void __lambda26__clutter_timeline_new_frame (ClutterTimeline* _sender, gint frame_num, gpointer self);
static Block11Data* block11_data_ref (Block11Data* _data11_);
static void block11_data_unref (Block11Data* _data11_);
static void _lambda29_ (gint m, EaseSlideActor* self);
static void __lambda29__clutter_timeline_new_frame (ClutterTimeline* _sender, gint frame_num, gpointer self);
static void _lambda30_ (Block12Data* _data12_);
static void __lambda30__clutter_timeline_completed (ClutterTimeline* _sender, gpointer self);
static void _lambda31_ (Block12Data* _data12_);
static void _lambda32_ (gint m, Block12Data* _data12_);
static void __lambda32__clutter_timeline_new_frame (ClutterTimeline* _sender, gint frame_num, gpointer self);
static void __lambda31__clutter_timeline_completed (ClutterTimeline* _sender, gpointer self);
static Block12Data* block12_data_ref (Block12Data* _data12_);
static void block12_data_unref (Block12Data* _data12_);
static void _lambda19_ (EaseSlideActor* self);
static void __lambda19__clutter_timeline_completed (ClutterTimeline* _sender, gpointer self);
static void _lambda20_ (gint m, Block13Data* _data13_);
static void __lambda20__clutter_timeline_new_frame (ClutterTimeline* _sender, gint frame_num, gpointer self);
static void _lambda21_ (gint m, Block13Data* _data13_);
static void __lambda21__clutter_timeline_new_frame (ClutterTimeline* _sender, gint frame_num, gpointer self);
static Block13Data* block13_data_ref (Block13Data* _data13_);
static void block13_data_unref (Block13Data* _data13_);
static void _lambda22_ (gint m, EaseSlideActor* self);
static void __lambda22__clutter_timeline_new_frame (ClutterTimeline* _sender, gint frame_num, gpointer self);
static void _lambda23_ (gint m, Block14Data* _data14_);
static void __lambda23__clutter_timeline_new_frame (ClutterTimeline* _sender, gint frame_num, gpointer self);
static void _lambda24_ (Block14Data* _data14_);
static void __lambda24__clutter_timeline_completed (ClutterTimeline* _sender, gpointer self);
static void _lambda25_ (Block14Data* _data14_);
static void __lambda25__clutter_timeline_completed (ClutterTimeline* _sender, gpointer self);
static Block14Data* block14_data_ref (Block14Data* _data14_);
static void block14_data_unref (Block14Data* _data14_);
static void ease_slide_actor_get_intersperse_coords (EaseSlideActor* self, ClutterActor* actor, float* target_x, float* target_y);
static void _lambda27_ (gint m, Block15Data* _data15_);
static void __lambda27__clutter_timeline_new_frame (ClutterTimeline* _sender, gint frame_num, gpointer self);
static void _lambda28_ (gint m, Block15Data* _data15_);
static void __lambda28__clutter_timeline_new_frame (ClutterTimeline* _sender, gint frame_num, gpointer self);
static Block15Data* block15_data_ref (Block15Data* _data15_);
static void block15_data_unref (Block15Data* _data15_);
static guint ease_slide_actor_explode_time (EaseSlideActor* self, guint time);
static float ease_slide_actor_explode_dist (EaseSlideActor* self);
static float ease_slide_actor_explode_depth (EaseSlideActor* self);
static void _lambda33_ (Block16Data* _data16_);
static void __lambda33__clutter_timeline_completed (ClutterTimeline* _sender, gpointer self);
static Block16Data* block16_data_ref (Block16Data* _data16_);
static void block16_data_unref (Block16Data* _data16_);
static float ease_slide_actor_assemble_extra (EaseSlideActor* self);
static void _lambda34_ (Block17Data* _data17_);
static void __lambda34__clutter_timeline_completed (ClutterTimeline* _sender, gpointer self);
static Block17Data* block17_data_ref (Block17Data* _data17_);
static void block17_data_unref (Block17Data* _data17_);
static guint8 ease_slide_actor_clamp_opacity (double o);
EaseSlideActor* ease_slide_actor_new (void);
EaseSlideActor* ease_slide_actor_construct (GType object_type);
static void ease_slide_actor_finalize (GObject* obj);
static void ease_slide_actor_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void ease_slide_actor_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);



/**
 * Creates a SlideActor from a {@link Slide} and a {@link Document}.
 * This calls the with_dimensions() constructor with the Document's
 * dimensions.
 *
 * @param document The document.
 * @param s The slide.
 * @param clip If the edges of the SlideActor should be clipped to its
 * dimensions.
 * @param ctx The {@link ActorContext} for this SlideActor.
 */
#line 153 "ease-slide-actor.vala"
EaseSlideActor* ease_slide_actor_construct_from_slide (GType object_type, EaseDocument* document, EaseSlide* s, gboolean clip, EaseActorContext ctx) {
#line 369 "ease-slide-actor.c"
	EaseSlideActor * self;
#line 153 "ease-slide-actor.vala"
	g_return_val_if_fail (document != NULL, NULL);
#line 153 "ease-slide-actor.vala"
	g_return_val_if_fail (s != NULL, NULL);
#line 156 "ease-slide-actor.vala"
	self = (EaseSlideActor*) ease_slide_actor_construct_with_dimensions (object_type, (float) ease_document_get_width (document), (float) ease_document_get_height (document), s, clip, ctx);
#line 377 "ease-slide-actor.c"
	return self;
}


#line 153 "ease-slide-actor.vala"
EaseSlideActor* ease_slide_actor_new_from_slide (EaseDocument* document, EaseSlide* s, gboolean clip, EaseActorContext ctx) {
#line 153 "ease-slide-actor.vala"
	return ease_slide_actor_construct_from_slide (EASE_TYPE_SLIDE_ACTOR, document, s, clip, ctx);
#line 386 "ease-slide-actor.c"
}


/**
 * Creates a SlideActor from a {@link Slide} with the given dimensions.
 *
 * @param w The width of the actor.
 * @param h The height of the actor.
 * @param s The slide.
 * @param clip If the edges of the SlideActor should be clipped to its
 * dimensions.
 * @param ctx The {@link ActorContext} for this SlideActor.
 */
#line 196 "ease-slide-actor.vala"
static void _lambda7_ (EaseSlide* s, EaseSlideActor* self) {
#line 196 "ease-slide-actor.vala"
	g_return_if_fail (s != NULL);
#line 196 "ease-slide-actor.vala"
	ease_slide_actor_set_background (self);
#line 406 "ease-slide-actor.c"
}


#line 196 "ease-slide-actor.vala"
static void __lambda7__ease_slide_background_changed (EaseSlide* _sender, EaseSlide* _self_, gpointer self) {
#line 412 "ease-slide-actor.c"
	_lambda7_ (_self_, self);
}


#line 228 "ease-slide-actor.vala"
static void _ease_slide_actor_on_element_added_ease_slide_element_added (EaseSlide* _sender, EaseSlide* _self_, EaseElement* element, gint index, gpointer self) {
#line 419 "ease-slide-actor.c"
	ease_slide_actor_on_element_added (self, _self_, element, index);
}


#line 243 "ease-slide-actor.vala"
static void _ease_slide_actor_on_element_removed_ease_slide_element_removed (EaseSlide* _sender, EaseSlide* _self_, EaseElement* element, gint index, gpointer self) {
#line 426 "ease-slide-actor.c"
	ease_slide_actor_on_element_removed (self, _self_, element, index);
}


#line 201 "ease-slide-actor.vala"
static void _lambda8_ (EaseSlide* s, EaseElement* e, EaseSlideActor* self) {
#line 201 "ease-slide-actor.vala"
	g_return_if_fail (s != NULL);
#line 201 "ease-slide-actor.vala"
	g_return_if_fail (e != NULL);
#line 201 "ease-slide-actor.vala"
	ease_slide_actor_reorder (self);
#line 439 "ease-slide-actor.c"
}


#line 201 "ease-slide-actor.vala"
static void __lambda8__ease_slide_element_reordered (EaseSlide* _sender, EaseSlide* _self_, EaseElement* element, gpointer self) {
#line 445 "ease-slide-actor.c"
	_lambda8_ (_self_, element, self);
}


#line 169 "ease-slide-actor.vala"
EaseSlideActor* ease_slide_actor_construct_with_dimensions (GType object_type, float w, float h, EaseSlide* s, gboolean clip, EaseActorContext ctx) {
#line 452 "ease-slide-actor.c"
	EaseSlideActor * self;
	FlutterGroup* _tmp0_;
#line 169 "ease-slide-actor.vala"
	g_return_val_if_fail (s != NULL, NULL);
#line 457 "ease-slide-actor.c"
	self = g_object_newv (object_type, 0, NULL);
#line 172 "ease-slide-actor.vala"
	ease_slide_actor_set_slide (self, s);
#line 173 "ease-slide-actor.vala"
	self->context = ctx;
#line 174 "ease-slide-actor.vala"
	self->priv->width_px = w;
#line 175 "ease-slide-actor.vala"
	self->priv->height_px = h;
#line 178 "ease-slide-actor.vala"
	if (clip) {
#line 180 "ease-slide-actor.vala"
		clutter_actor_set_clip ((ClutterActor*) self, (float) 0, (float) 0, w, h);
#line 471 "ease-slide-actor.c"
	}
#line 184 "ease-slide-actor.vala"
	ease_slide_actor_set_background (self);
#line 185 "ease-slide-actor.vala"
	clutter_container_add_actor ((ClutterContainer*) self, (ClutterActor*) self->background);
#line 187 "ease-slide-actor.vala"
	self->contents = (_tmp0_ = g_object_ref_sink (flutter_group_new ()), _g_object_unref0 (self->contents), _tmp0_);
#line 479 "ease-slide-actor.c"
	{
		EaseSlideIterator* _e_it;
#line 189 "ease-slide-actor.vala"
		_e_it = ease_slide_iterator (self->priv->_slide);
#line 189 "ease-slide-actor.vala"
		while (TRUE) {
#line 486 "ease-slide-actor.c"
			EaseElement* e;
			EaseActor* _tmp1_;
#line 189 "ease-slide-actor.vala"
			if (!ease_slide_iterator_next (_e_it)) {
#line 189 "ease-slide-actor.vala"
				break;
#line 493 "ease-slide-actor.c"
			}
#line 189 "ease-slide-actor.vala"
			e = ease_slide_iterator_get (_e_it);
#line 191 "ease-slide-actor.vala"
			clutter_container_add_actor ((ClutterContainer*) self->contents, (ClutterActor*) (_tmp1_ = ease_element_actor (e, self->context)));
#line 499 "ease-slide-actor.c"
			_g_object_unref0 (_tmp1_);
			_g_object_unref0 (e);
		}
		_ease_slide_iterator_unref0 (_e_it);
	}
#line 194 "ease-slide-actor.vala"
	clutter_container_add_actor ((ClutterContainer*) self, (ClutterActor*) self->contents);
#line 196 "ease-slide-actor.vala"
	g_signal_connect_object (self->priv->_slide, "background-changed", (GCallback) __lambda7__ease_slide_background_changed, self, 0);
#line 198 "ease-slide-actor.vala"
	g_signal_connect_object (self->priv->_slide, "element-added", (GCallback) _ease_slide_actor_on_element_added_ease_slide_element_added, self, 0);
#line 199 "ease-slide-actor.vala"
	g_signal_connect_object (self->priv->_slide, "element-removed", (GCallback) _ease_slide_actor_on_element_removed_ease_slide_element_removed, self, 0);
#line 201 "ease-slide-actor.vala"
	g_signal_connect_object (self->priv->_slide, "element-reordered", (GCallback) __lambda8__ease_slide_element_reordered, self, 0);
#line 515 "ease-slide-actor.c"
	return self;
}


#line 169 "ease-slide-actor.vala"
EaseSlideActor* ease_slide_actor_new_with_dimensions (float w, float h, EaseSlide* s, gboolean clip, EaseActorContext ctx) {
#line 169 "ease-slide-actor.vala"
	return ease_slide_actor_construct_with_dimensions (EASE_TYPE_SLIDE_ACTOR, w, h, s, clip, ctx);
#line 524 "ease-slide-actor.c"
}


/**
 * Instantiates a SlideActor of a single color. Used for transition previews
 * with no "next" slide.
 *
 * @param document The {@link Document} this slide is "part of", to make it
 * the proper size.
 * @param color The background color.
 */
#line 212 "ease-slide-actor.vala"
EaseSlideActor* ease_slide_actor_construct_blank (GType object_type, EaseDocument* document, ClutterColor* color) {
#line 538 "ease-slide-actor.c"
	EaseSlideActor * self;
	ClutterCairoTexture* _tmp0_;
	FlutterGroup* _tmp1_;
#line 212 "ease-slide-actor.vala"
	g_return_val_if_fail (document != NULL, NULL);
#line 544 "ease-slide-actor.c"
	self = g_object_newv (object_type, 0, NULL);
#line 215 "ease-slide-actor.vala"
	self->background = (_tmp0_ = g_object_ref_sink ((ClutterCairoTexture*) clutter_cairo_texture_new ((guint) ease_document_get_width (document), (guint) ease_document_get_height (document))), _g_object_unref0 (self->background), _tmp0_);
#line 218 "ease-slide-actor.vala"
	self->contents = (_tmp1_ = g_object_ref_sink (flutter_group_new ()), _g_object_unref0 (self->contents), _tmp1_);
#line 221 "ease-slide-actor.vala"
	clutter_actor_set_width ((ClutterActor*) self->background, self->priv->width_px);
#line 222 "ease-slide-actor.vala"
	clutter_actor_set_height ((ClutterActor*) self->background, self->priv->height_px);
#line 554 "ease-slide-actor.c"
	return self;
}


#line 212 "ease-slide-actor.vala"
EaseSlideActor* ease_slide_actor_new_blank (EaseDocument* document, ClutterColor* color) {
#line 212 "ease-slide-actor.vala"
	return ease_slide_actor_construct_blank (EASE_TYPE_SLIDE_ACTOR, document, color);
#line 563 "ease-slide-actor.c"
}


/**
 * Handles {@link Slide.element_added}.
 */
#line 228 "ease-slide-actor.vala"
void ease_slide_actor_on_element_added (EaseSlideActor* self, EaseSlide* slide, EaseElement* element, gint index) {
#line 572 "ease-slide-actor.c"
	EaseActor* actor;
	EaseActor* _tmp0_;
#line 228 "ease-slide-actor.vala"
	g_return_if_fail (self != NULL);
#line 228 "ease-slide-actor.vala"
	g_return_if_fail (slide != NULL);
#line 228 "ease-slide-actor.vala"
	g_return_if_fail (element != NULL);
#line 230 "ease-slide-actor.vala"
	actor = ease_element_actor (element, self->context);
#line 231 "ease-slide-actor.vala"
	clutter_container_add_actor ((ClutterContainer*) self->contents, (ClutterActor*) actor);
#line 232 "ease-slide-actor.vala"
	clutter_container_lower_child ((ClutterContainer*) self->contents, (ClutterActor*) actor, NULL);
#line 235 "ease-slide-actor.vala"
	ease_slide_actor_reorder (self);
#line 237 "ease-slide-actor.vala"
	g_signal_emit_by_name (self, "ease-actor-added", (_tmp0_ = actor, EASE_IS_ACTOR (_tmp0_) ? ((EaseActor*) _tmp0_) : NULL));
#line 591 "ease-slide-actor.c"
	_g_object_unref0 (actor);
}


/**
 * Handles {@link Slide.element_removed}.
 */
#line 243 "ease-slide-actor.vala"
void ease_slide_actor_on_element_removed (EaseSlideActor* self, EaseSlide* slide, EaseElement* element, gint index) {
#line 243 "ease-slide-actor.vala"
	g_return_if_fail (self != NULL);
#line 243 "ease-slide-actor.vala"
	g_return_if_fail (slide != NULL);
#line 243 "ease-slide-actor.vala"
	g_return_if_fail (element != NULL);
#line 607 "ease-slide-actor.c"
	{
		FlutterContainerIterator* _a_it;
#line 245 "ease-slide-actor.vala"
		_a_it = flutter_container_iterator ((FlutterContainer*) self->contents);
#line 245 "ease-slide-actor.vala"
		while (TRUE) {
#line 614 "ease-slide-actor.c"
			ClutterActor* a;
			ClutterActor* _tmp0_;
#line 245 "ease-slide-actor.vala"
			if (!flutter_container_iterator_next (_a_it)) {
#line 245 "ease-slide-actor.vala"
				break;
#line 621 "ease-slide-actor.c"
			}
#line 245 "ease-slide-actor.vala"
			a = flutter_container_iterator_get (_a_it);
#line 247 "ease-slide-actor.vala"
			if ((_tmp0_ = a, EASE_IS_ACTOR (_tmp0_) ? ((EaseActor*) _tmp0_) : NULL)->element == element) {
#line 627 "ease-slide-actor.c"
				ClutterActor* _tmp1_;
#line 249 "ease-slide-actor.vala"
				clutter_container_remove_actor ((ClutterContainer*) self->contents, a);
#line 250 "ease-slide-actor.vala"
				g_signal_emit_by_name (self, "ease-actor-removed", (_tmp1_ = a, EASE_IS_ACTOR (_tmp1_) ? ((EaseActor*) _tmp1_) : NULL));
#line 633 "ease-slide-actor.c"
				_g_object_unref0 (a);
#line 251 "ease-slide-actor.vala"
				break;
#line 637 "ease-slide-actor.c"
			}
			_g_object_unref0 (a);
		}
		_flutter_container_iterator_unref0 (_a_it);
	}
}


/**
 * Resets all transformations on this SlideActor.
 */
#line 259 "ease-slide-actor.vala"
void ease_slide_actor_reset (EaseSlideActor* self, ClutterGroup* container) {
#line 259 "ease-slide-actor.vala"
	g_return_if_fail (self != NULL);
#line 259 "ease-slide-actor.vala"
	g_return_if_fail (container != NULL);
#line 261 "ease-slide-actor.vala"
	ease_slide_actor_reset_actor (self, (ClutterActor*) self);
#line 262 "ease-slide-actor.vala"
	ease_slide_actor_reset_actor (self, (ClutterActor*) self->background);
#line 263 "ease-slide-actor.vala"
	ease_slide_actor_reset_actor (self, (ClutterActor*) self->contents);
#line 264 "ease-slide-actor.vala"
	ease_slide_actor_stack (self, (ClutterActor*) container);
#line 663 "ease-slide-actor.c"
}


/**
 * Resets transformations of a Clutter.Actor.
 *
 * @param actor The actor to reset.
 */
#line 272 "ease-slide-actor.vala"
static void ease_slide_actor_reset_actor (EaseSlideActor* self, ClutterActor* actor) {
#line 272 "ease-slide-actor.vala"
	g_return_if_fail (self != NULL);
#line 272 "ease-slide-actor.vala"
	g_return_if_fail (actor != NULL);
#line 274 "ease-slide-actor.vala"
	clutter_actor_set_depth (actor, (float) 0);
#line 275 "ease-slide-actor.vala"
	clutter_actor_set_opacity (actor, (guint) 255);
#line 276 "ease-slide-actor.vala"
	g_object_set (actor, "rotation-angle-x", (double) 0, NULL);
#line 277 "ease-slide-actor.vala"
	g_object_set (actor, "rotation-angle-y", (double) 0, NULL);
#line 278 "ease-slide-actor.vala"
	g_object_set (actor, "rotation-angle-z", (double) 0, NULL);
#line 279 "ease-slide-actor.vala"
	g_object_set (actor, "scale-x", (double) 1, NULL);
#line 280 "ease-slide-actor.vala"
	g_object_set (actor, "scale-y", (double) 1, NULL);
#line 281 "ease-slide-actor.vala"
	clutter_actor_set_x (actor, (float) 0);
#line 282 "ease-slide-actor.vala"
	clutter_actor_set_y (actor, (float) 0);
#line 696 "ease-slide-actor.c"
}


/**
 * Lays out this SlideActor, replacing the background and rearranging
 * child actors if necessary.
 */
#line 289 "ease-slide-actor.vala"
void ease_slide_actor_relayout (EaseSlideActor* self) {
#line 289 "ease-slide-actor.vala"
	g_return_if_fail (self != NULL);
#line 291 "ease-slide-actor.vala"
	ease_slide_actor_set_background (self);
#line 710 "ease-slide-actor.c"
	{
		GList* itr;
#line 293 "ease-slide-actor.vala"
		itr = clutter_container_get_children ((ClutterContainer*) self->contents);
#line 715 "ease-slide-actor.c"
		{
			gboolean _tmp0_;
#line 293 "ease-slide-actor.vala"
			_tmp0_ = TRUE;
#line 293 "ease-slide-actor.vala"
			while (TRUE) {
#line 293 "ease-slide-actor.vala"
				if (!_tmp0_) {
#line 295 "ease-slide-actor.vala"
					itr = itr->next;
#line 726 "ease-slide-actor.c"
				}
#line 293 "ease-slide-actor.vala"
				_tmp0_ = FALSE;
#line 294 "ease-slide-actor.vala"
				if (!(itr != NULL)) {
#line 294 "ease-slide-actor.vala"
					break;
#line 734 "ease-slide-actor.c"
				}
#line 297 "ease-slide-actor.vala"
				ease_actor_reposition (EASE_ACTOR ((ClutterActor*) itr->data));
#line 738 "ease-slide-actor.c"
			}
		}
	}
}


/**
 * Builds the background actor for this SlideActor.
 */
#line 304 "ease-slide-actor.vala"
static void ease_slide_actor_set_background (EaseSlideActor* self) {
#line 750 "ease-slide-actor.c"
	GError * _inner_error_ = NULL;
#line 304 "ease-slide-actor.vala"
	g_return_if_fail (self != NULL);
#line 306 "ease-slide-actor.vala"
	if (self->background == NULL) {
#line 756 "ease-slide-actor.c"
		ClutterCairoTexture* _tmp0_;
#line 308 "ease-slide-actor.vala"
		self->background = (_tmp0_ = g_object_ref_sink ((ClutterCairoTexture*) clutter_cairo_texture_new ((guint) self->priv->width_px, (guint) self->priv->height_px)), _g_object_unref0 (self->background), _tmp0_);
#line 760 "ease-slide-actor.c"
	}
	{
		cairo_t* cr;
#line 315 "ease-slide-actor.vala"
		cr = clutter_cairo_texture_create (self->background);
#line 316 "ease-slide-actor.vala"
		ease_slide_cairo_render_background (self->priv->_slide, cr, (gint) self->priv->width_px, (gint) self->priv->height_px, &_inner_error_);
#line 768 "ease-slide-actor.c"
		if (_inner_error_ != NULL) {
			_cairo_destroy0 (cr);
			goto __catch16_g_error;
		}
		_cairo_destroy0 (cr);
	}
	goto __finally16;
	__catch16_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
#line 320 "ease-slide-actor.vala"
			g_critical ("ease-slide-actor.vala:320: Error rendering slide actor background: %s", e->message);
#line 784 "ease-slide-actor.c"
			_g_error_free0 (e);
		}
	}
	__finally16:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
#line 323 "ease-slide-actor.vala"
	clutter_actor_set_width ((ClutterActor*) self->background, self->priv->width_px);
#line 324 "ease-slide-actor.vala"
	clutter_actor_set_height ((ClutterActor*) self->background, self->priv->height_px);
#line 798 "ease-slide-actor.c"
}


/**
 * Places all {@link Element}s of this SlideActor in the proper order.
 */
#line 330 "ease-slide-actor.vala"
static void ease_slide_actor_reorder (EaseSlideActor* self) {
#line 330 "ease-slide-actor.vala"
	g_return_if_fail (self != NULL);
#line 809 "ease-slide-actor.c"
	{
		EaseSlideIterator* _e_it;
#line 333 "ease-slide-actor.vala"
		_e_it = ease_slide_iterator (self->priv->_slide);
#line 333 "ease-slide-actor.vala"
		while (TRUE) {
#line 816 "ease-slide-actor.c"
			EaseElement* e;
#line 333 "ease-slide-actor.vala"
			if (!ease_slide_iterator_next (_e_it)) {
#line 333 "ease-slide-actor.vala"
				break;
#line 822 "ease-slide-actor.c"
			}
#line 333 "ease-slide-actor.vala"
			e = ease_slide_iterator_get (_e_it);
#line 826 "ease-slide-actor.c"
			{
				FlutterContainerIterator* _a_it;
#line 335 "ease-slide-actor.vala"
				_a_it = flutter_container_iterator ((FlutterContainer*) self->contents);
#line 335 "ease-slide-actor.vala"
				while (TRUE) {
#line 833 "ease-slide-actor.c"
					ClutterActor* a;
					ClutterActor* _tmp0_;
#line 335 "ease-slide-actor.vala"
					if (!flutter_container_iterator_next (_a_it)) {
#line 335 "ease-slide-actor.vala"
						break;
#line 840 "ease-slide-actor.c"
					}
#line 335 "ease-slide-actor.vala"
					a = flutter_container_iterator_get (_a_it);
#line 337 "ease-slide-actor.vala"
					if ((_tmp0_ = a, EASE_IS_ACTOR (_tmp0_) ? ((EaseActor*) _tmp0_) : NULL)->element == e) {
#line 339 "ease-slide-actor.vala"
						clutter_actor_raise_top (a);
#line 848 "ease-slide-actor.c"
						_g_object_unref0 (a);
#line 340 "ease-slide-actor.vala"
						break;
#line 852 "ease-slide-actor.c"
					}
					_g_object_unref0 (a);
				}
				_flutter_container_iterator_unref0 (_a_it);
			}
			_g_object_unref0 (e);
		}
		_ease_slide_iterator_unref0 (_e_it);
	}
}


/**
 * Places all child elements of this slide back into the SlideActor.
 *
 * Ease has two types of transitions. The first manipulates entire slides.
 * For this type of transition, the background and contents of the slide
 * should be stacked into the SlideActor. stack() is used to prepare for
 * this.
 *
 * The second type of transition manipulates the content and backgrounds
 * separately, typically fading between the backgrounds while moving the
 * contents around. The contents need to be above both backgrounds in this
 * case, so they are stacked inside of the container that typically holds
 * the full SlideActors. unstack() performs this.
 *
 * @param container The container that holds the SlideActor and unstacked
 * elements.
 */
#line 363 "ease-slide-actor.vala"
void ease_slide_actor_stack (EaseSlideActor* self, ClutterActor* container) {
#line 363 "ease-slide-actor.vala"
	g_return_if_fail (self != NULL);
#line 363 "ease-slide-actor.vala"
	g_return_if_fail (container != NULL);
#line 365 "ease-slide-actor.vala"
	if (clutter_actor_get_parent ((ClutterActor*) self->background) != CLUTTER_ACTOR (self)) {
#line 367 "ease-slide-actor.vala"
		clutter_actor_reparent ((ClutterActor*) self->background, (ClutterActor*) self);
#line 892 "ease-slide-actor.c"
	}
#line 369 "ease-slide-actor.vala"
	if (clutter_actor_get_parent ((ClutterActor*) self->contents) != CLUTTER_ACTOR (self)) {
#line 371 "ease-slide-actor.vala"
		clutter_actor_reparent ((ClutterActor*) self->contents, (ClutterActor*) self);
#line 898 "ease-slide-actor.c"
	}
#line 373 "ease-slide-actor.vala"
	if (clutter_actor_get_parent ((ClutterActor*) self) != container) {
#line 375 "ease-slide-actor.vala"
		clutter_actor_reparent ((ClutterActor*) self, container);
#line 904 "ease-slide-actor.c"
	}
}


/**
 * Places all child elements of this slide back into the SlideActor.
 *
 * Ease has two types of transitions. The first manipulates entire slides.
 * For this type of transition, the background and contents of the slide
 * should be stacked into the SlideActor. stack() is used to prepare for
 * this.
 *
 * The second type of transition manipulates the content and backgrounds
 * separately, typically fading between the backgrounds while moving the
 * contents around. The contents need to be above both backgrounds in this
 * case, so they are stacked inside of the container that typically holds
 * the full SlideActors. unstack() performs this.
 *
 * @param other The other SlideActor to be unstacked.
 * @param container The container that holds the SlideActor and unstacked
 * elements.
 */
#line 397 "ease-slide-actor.vala"
void ease_slide_actor_unstack (EaseSlideActor* self, EaseSlideActor* other, ClutterActor* container) {
#line 397 "ease-slide-actor.vala"
	g_return_if_fail (self != NULL);
#line 397 "ease-slide-actor.vala"
	g_return_if_fail (other != NULL);
#line 397 "ease-slide-actor.vala"
	g_return_if_fail (container != NULL);
#line 399 "ease-slide-actor.vala"
	if (clutter_actor_get_parent ((ClutterActor*) other->background) != container) {
#line 401 "ease-slide-actor.vala"
		clutter_actor_reparent ((ClutterActor*) other->background, container);
#line 939 "ease-slide-actor.c"
	}
#line 403 "ease-slide-actor.vala"
	if (clutter_actor_get_parent ((ClutterActor*) self->background) != container) {
#line 405 "ease-slide-actor.vala"
		clutter_actor_reparent ((ClutterActor*) self->background, container);
#line 945 "ease-slide-actor.c"
	}
#line 407 "ease-slide-actor.vala"
	if (clutter_actor_get_parent ((ClutterActor*) self->contents) != container) {
#line 409 "ease-slide-actor.vala"
		clutter_actor_reparent ((ClutterActor*) self->contents, container);
#line 951 "ease-slide-actor.c"
	}
#line 411 "ease-slide-actor.vala"
	if (clutter_actor_get_parent ((ClutterActor*) other->contents) != container) {
#line 413 "ease-slide-actor.vala"
		clutter_actor_reparent ((ClutterActor*) other->contents, container);
#line 957 "ease-slide-actor.c"
	}
}


/**
 * Prepares for a "slide" transition (manipulation of entire slides).
 *
 * This method simply calls stack() for both SlideActors, but could change
 * in the future.
 *
 * @param new_slide The SlideActor that will replace this one.
 * @param container The container that holds the SlideActors and unstacked
 * elements.
 */
#line 427 "ease-slide-actor.vala"
static void ease_slide_actor_prepare_slide_transition (EaseSlideActor* self, EaseSlideActor* new_slide, ClutterGroup* container) {
#line 427 "ease-slide-actor.vala"
	g_return_if_fail (self != NULL);
#line 427 "ease-slide-actor.vala"
	g_return_if_fail (new_slide != NULL);
#line 427 "ease-slide-actor.vala"
	g_return_if_fail (container != NULL);
#line 430 "ease-slide-actor.vala"
	ease_slide_actor_stack (new_slide, (ClutterActor*) container);
#line 431 "ease-slide-actor.vala"
	ease_slide_actor_stack (self, (ClutterActor*) container);
#line 984 "ease-slide-actor.c"
}


/**
 * Prepares for a "stack" transition (manipulation of entire slides).
 *
 * This method simply calls unstack() for both SlideActors, but could
 * change in the future.
 */
#line 440 "ease-slide-actor.vala"
static void ease_slide_actor_prepare_stack_transition (EaseSlideActor* self, gboolean current_on_top, EaseSlideActor* new_slide, ClutterGroup* container) {
#line 440 "ease-slide-actor.vala"
	g_return_if_fail (self != NULL);
#line 440 "ease-slide-actor.vala"
	g_return_if_fail (new_slide != NULL);
#line 440 "ease-slide-actor.vala"
	g_return_if_fail (container != NULL);
#line 444 "ease-slide-actor.vala"
	ease_slide_actor_unstack (self, new_slide, (ClutterActor*) container);
#line 1004 "ease-slide-actor.c"
}


/**
 * Starts a transition to a new SlideActor.
 *
 * This method calls the appropriate method for the current {@link Slide}'s
 * {@link Transition}.
 *
 * @param new_slide The new SlideActor.
 * @param container The container that holds the displayed SlideActors.
 */
#line 456 "ease-slide-actor.vala"
void ease_slide_actor_transition (EaseSlideActor* self, EaseSlideActor* new_slide, ClutterGroup* container) {
#line 1019 "ease-slide-actor.c"
	guint length;
	ClutterTimeline* _tmp0_;
#line 456 "ease-slide-actor.vala"
	g_return_if_fail (self != NULL);
#line 456 "ease-slide-actor.vala"
	g_return_if_fail (new_slide != NULL);
#line 456 "ease-slide-actor.vala"
	g_return_if_fail (container != NULL);
#line 459 "ease-slide-actor.vala"
	length = (guint) fmax ((double) 1, ease_slide_get_transition_time (self->priv->_slide) * 1000);
#line 461 "ease-slide-actor.vala"
	ease_slide_actor_set_animation_time (self, _tmp0_ = clutter_timeline_new (length));
#line 1032 "ease-slide-actor.c"
	_g_object_unref0 (_tmp0_);
#line 463 "ease-slide-actor.vala"
	switch (ease_slide_get_transition (self->priv->_slide)) {
#line 1036 "ease-slide-actor.c"
		case EASE_TRANSITION_SLIDE:
		{
#line 466 "ease-slide-actor.vala"
			ease_slide_actor_slide_transition (self, new_slide, container, length);
#line 467 "ease-slide-actor.vala"
			break;
#line 1043 "ease-slide-actor.c"
		}
		case EASE_TRANSITION_DROP:
		{
#line 470 "ease-slide-actor.vala"
			ease_slide_actor_drop_transition (self, new_slide, container, length);
#line 471 "ease-slide-actor.vala"
			break;
#line 1051 "ease-slide-actor.c"
		}
		case EASE_TRANSITION_PIVOT:
		{
#line 474 "ease-slide-actor.vala"
			ease_slide_actor_pivot_transition (self, new_slide, container, length);
#line 475 "ease-slide-actor.vala"
			break;
#line 1059 "ease-slide-actor.c"
		}
		case EASE_TRANSITION_OPEN_DOOR:
		{
#line 478 "ease-slide-actor.vala"
			ease_slide_actor_open_door_transition (self, new_slide, container, length);
#line 479 "ease-slide-actor.vala"
			break;
#line 1067 "ease-slide-actor.c"
		}
		case EASE_TRANSITION_REVEAL:
		{
#line 482 "ease-slide-actor.vala"
			ease_slide_actor_reveal_transition (self, new_slide, container, length);
#line 483 "ease-slide-actor.vala"
			break;
#line 1075 "ease-slide-actor.c"
		}
		case EASE_TRANSITION_SLATS:
		{
#line 486 "ease-slide-actor.vala"
			ease_slide_actor_slats_transition (self, new_slide, container, length);
#line 487 "ease-slide-actor.vala"
			break;
#line 1083 "ease-slide-actor.c"
		}
		case EASE_TRANSITION_FLIP:
		{
#line 490 "ease-slide-actor.vala"
			ease_slide_actor_flip_transition (self, new_slide, container, length);
#line 491 "ease-slide-actor.vala"
			break;
#line 1091 "ease-slide-actor.c"
		}
		case EASE_TRANSITION_REVOLVING_DOOR:
		{
#line 494 "ease-slide-actor.vala"
			ease_slide_actor_revolving_door_transition (self, new_slide, container, length);
#line 495 "ease-slide-actor.vala"
			break;
#line 1099 "ease-slide-actor.c"
		}
		case EASE_TRANSITION_FALL:
		{
#line 498 "ease-slide-actor.vala"
			ease_slide_actor_fall_transition (self, new_slide, container, length);
#line 499 "ease-slide-actor.vala"
			break;
#line 1107 "ease-slide-actor.c"
		}
		case EASE_TRANSITION_SPIN_CONTENTS:
		{
#line 502 "ease-slide-actor.vala"
			ease_slide_actor_spin_contents_transition (self, new_slide, container, length);
#line 503 "ease-slide-actor.vala"
			break;
#line 1115 "ease-slide-actor.c"
		}
		case EASE_TRANSITION_SWING_CONTENTS:
		{
#line 506 "ease-slide-actor.vala"
			ease_slide_actor_swing_contents_transition (self, new_slide, container, length);
#line 507 "ease-slide-actor.vala"
			break;
#line 1123 "ease-slide-actor.c"
		}
		case EASE_TRANSITION_ZOOM:
		{
#line 510 "ease-slide-actor.vala"
			ease_slide_actor_zoom_transition (self, new_slide, container, length);
#line 511 "ease-slide-actor.vala"
			break;
#line 1131 "ease-slide-actor.c"
		}
		case EASE_TRANSITION_INTERSPERSE_CONTENTS:
		{
#line 514 "ease-slide-actor.vala"
			ease_slide_actor_intersperse_contents_transition (self, new_slide, container, length);
#line 515 "ease-slide-actor.vala"
			break;
#line 1139 "ease-slide-actor.c"
		}
		case EASE_TRANSITION_SLIDE_CONTENTS:
		{
#line 518 "ease-slide-actor.vala"
			ease_slide_actor_slide_contents_transition (self, new_slide, container, length);
#line 519 "ease-slide-actor.vala"
			break;
#line 1147 "ease-slide-actor.c"
		}
		case EASE_TRANSITION_SPRING_CONTENTS:
		{
#line 522 "ease-slide-actor.vala"
			ease_slide_actor_spring_contents_transition (self, new_slide, container, length);
#line 523 "ease-slide-actor.vala"
			break;
#line 1155 "ease-slide-actor.c"
		}
		case EASE_TRANSITION_ZOOM_CONTENTS:
		{
#line 526 "ease-slide-actor.vala"
			ease_slide_actor_zoom_contents_transition (self, new_slide, container, length);
#line 527 "ease-slide-actor.vala"
			break;
#line 1163 "ease-slide-actor.c"
		}
		case EASE_TRANSITION_PANEL:
		{
#line 530 "ease-slide-actor.vala"
			ease_slide_actor_panel_transition (self, new_slide, container, length);
#line 531 "ease-slide-actor.vala"
			break;
#line 1171 "ease-slide-actor.c"
		}
		case EASE_TRANSITION_EXPLODE:
		{
#line 534 "ease-slide-actor.vala"
			ease_slide_actor_explode_transition (self, new_slide, container, length);
#line 535 "ease-slide-actor.vala"
			break;
#line 1179 "ease-slide-actor.c"
		}
		case EASE_TRANSITION_ASSEMBLE:
		{
#line 538 "ease-slide-actor.vala"
			ease_slide_actor_assemble_transition (self, new_slide, container, length);
#line 539 "ease-slide-actor.vala"
			break;
#line 1187 "ease-slide-actor.c"
		}
		default:
		{
#line 542 "ease-slide-actor.vala"
			ease_slide_actor_fade_transition (self, new_slide, container, length);
#line 543 "ease-slide-actor.vala"
			break;
#line 1195 "ease-slide-actor.c"
		}
	}
#line 546 "ease-slide-actor.vala"
	clutter_timeline_start (self->priv->_animation_time);
#line 1200 "ease-slide-actor.c"
}


/**
 * Starts a "fade" transition.
 *
 * @param new_slide The new SlideActor.
 * @param container The container that holds the displayed SlideActors.
 * @param length The length of the transition, in milliseconds.
 */
#line 556 "ease-slide-actor.vala"
static void ease_slide_actor_fade_transition (EaseSlideActor* self, EaseSlideActor* new_slide, ClutterGroup* container, guint length) {
#line 556 "ease-slide-actor.vala"
	g_return_if_fail (self != NULL);
#line 556 "ease-slide-actor.vala"
	g_return_if_fail (new_slide != NULL);
#line 556 "ease-slide-actor.vala"
	g_return_if_fail (container != NULL);
#line 559 "ease-slide-actor.vala"
	ease_slide_actor_prepare_slide_transition (self, new_slide, container);
#line 560 "ease-slide-actor.vala"
	clutter_actor_set_opacity ((ClutterActor*) new_slide, (guint) 0);
#line 561 "ease-slide-actor.vala"
	clutter_actor_animate ((ClutterActor*) new_slide, (gulong) CLUTTER_LINEAR, length, "opacity", 255, NULL);
#line 1225 "ease-slide-actor.c"
}


/**
 * Starts a "slide" transition.
 *
 * @param new_slide The new SlideActor.
 * @param container The container that holds the displayed SlideActors.
 * @param length The length of the transition, in milliseconds.
 */
#line 572 "ease-slide-actor.vala"
static void ease_slide_actor_slide_transition (EaseSlideActor* self, EaseSlideActor* new_slide, ClutterGroup* container, guint length) {
#line 572 "ease-slide-actor.vala"
	g_return_if_fail (self != NULL);
#line 572 "ease-slide-actor.vala"
	g_return_if_fail (new_slide != NULL);
#line 572 "ease-slide-actor.vala"
	g_return_if_fail (container != NULL);
#line 575 "ease-slide-actor.vala"
	switch (ease_slide_get_variant (self->priv->_slide)) {
#line 1246 "ease-slide-actor.c"
		case EASE_TRANSITION_VARIANT_UP:
		{
#line 578 "ease-slide-actor.vala"
			clutter_actor_set_y ((ClutterActor*) new_slide, (float) ease_slide_get_height (self->priv->_slide));
#line 579 "ease-slide-actor.vala"
			clutter_actor_animate ((ClutterActor*) new_slide, (gulong) EASE_SLIDE_ACTOR_EASE_SLIDE, length, "y", 0, NULL);
#line 580 "ease-slide-actor.vala"
			clutter_actor_animate ((ClutterActor*) self, (gulong) EASE_SLIDE_ACTOR_EASE_SLIDE, length, "y", -clutter_actor_get_y ((ClutterActor*) new_slide), NULL);
#line 581 "ease-slide-actor.vala"
			break;
#line 1257 "ease-slide-actor.c"
		}
		case EASE_TRANSITION_VARIANT_DOWN:
		{
#line 584 "ease-slide-actor.vala"
			clutter_actor_set_y ((ClutterActor*) new_slide, (float) (-ease_slide_get_height (self->priv->_slide)));
#line 585 "ease-slide-actor.vala"
			clutter_actor_animate ((ClutterActor*) new_slide, (gulong) EASE_SLIDE_ACTOR_EASE_SLIDE, length, "y", 0, NULL);
#line 586 "ease-slide-actor.vala"
			clutter_actor_animate ((ClutterActor*) self, (gulong) EASE_SLIDE_ACTOR_EASE_SLIDE, length, "y", -clutter_actor_get_y ((ClutterActor*) new_slide), NULL);
#line 587 "ease-slide-actor.vala"
			break;
#line 1269 "ease-slide-actor.c"
		}
		case EASE_TRANSITION_VARIANT_LEFT:
		{
#line 590 "ease-slide-actor.vala"
			clutter_actor_set_x ((ClutterActor*) new_slide, (float) ease_slide_get_width (self->priv->_slide));
#line 591 "ease-slide-actor.vala"
			clutter_actor_animate ((ClutterActor*) new_slide, (gulong) EASE_SLIDE_ACTOR_EASE_SLIDE, length, "x", 0, NULL);
#line 592 "ease-slide-actor.vala"
			clutter_actor_animate ((ClutterActor*) self, (gulong) EASE_SLIDE_ACTOR_EASE_SLIDE, length, "x", -clutter_actor_get_x ((ClutterActor*) new_slide), NULL);
#line 593 "ease-slide-actor.vala"
			break;
#line 1281 "ease-slide-actor.c"
		}
		case EASE_TRANSITION_VARIANT_RIGHT:
		{
#line 596 "ease-slide-actor.vala"
			clutter_actor_set_x ((ClutterActor*) new_slide, (float) (-ease_slide_get_width (self->priv->_slide)));
#line 597 "ease-slide-actor.vala"
			clutter_actor_animate ((ClutterActor*) new_slide, (gulong) EASE_SLIDE_ACTOR_EASE_SLIDE, length, "x", 0, NULL);
#line 598 "ease-slide-actor.vala"
			clutter_actor_animate ((ClutterActor*) self, (gulong) EASE_SLIDE_ACTOR_EASE_SLIDE, length, "x", -clutter_actor_get_x ((ClutterActor*) new_slide), NULL);
#line 599 "ease-slide-actor.vala"
			break;
#line 1293 "ease-slide-actor.c"
		}
	}
}


/**
 * Starts a "drop" transition.
 *
 * @param new_slide The new SlideActor.
 * @param container The container that holds the displayed SlideActors.
 * @param length The length of the transition, in milliseconds.
 */
#line 610 "ease-slide-actor.vala"
static void ease_slide_actor_drop_transition (EaseSlideActor* self, EaseSlideActor* new_slide, ClutterGroup* container, guint length) {
#line 610 "ease-slide-actor.vala"
	g_return_if_fail (self != NULL);
#line 610 "ease-slide-actor.vala"
	g_return_if_fail (new_slide != NULL);
#line 610 "ease-slide-actor.vala"
	g_return_if_fail (container != NULL);
#line 613 "ease-slide-actor.vala"
	clutter_actor_set_y ((ClutterActor*) new_slide, (float) (-ease_slide_get_height (self->priv->_slide)));
#line 614 "ease-slide-actor.vala"
	clutter_actor_animate ((ClutterActor*) new_slide, (gulong) EASE_SLIDE_ACTOR_EASE_DROP, length, "y", 0, NULL);
#line 1318 "ease-slide-actor.c"
}


/**
 * Starts a "pivot" transition.
 *
 * @param new_slide The new SlideActor.
 * @param container The container that holds the displayed SlideActors.
 * @param length The length of the transition, in milliseconds.
 */
#line 651 "ease-slide-actor.vala"
static void _lambda9_ (gint m, Block6Data* _data6_) {
#line 1331 "ease-slide-actor.c"
	EaseSlideActor * self;
	self = _data6_->self;
#line 652 "ease-slide-actor.vala"
	clutter_actor_set_rotation ((ClutterActor*) _data6_->new_slide, CLUTTER_Z_AXIS, _data6_->angle * (1 - clutter_alpha_get_alpha (self->priv->_animation_alpha)), _data6_->xpos, _data6_->ypos, (float) 0);
#line 1336 "ease-slide-actor.c"
}


#line 651 "ease-slide-actor.vala"
static void __lambda9__clutter_timeline_new_frame (ClutterTimeline* _sender, gint frame_num, gpointer self) {
#line 1342 "ease-slide-actor.c"
	_lambda9_ (frame_num, self);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static Block6Data* block6_data_ref (Block6Data* _data6_) {
	g_atomic_int_inc (&_data6_->_ref_count_);
	return _data6_;
}


static void block6_data_unref (Block6Data* _data6_) {
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
		_g_object_unref0 (_data6_->self);
		_g_object_unref0 (_data6_->new_slide);
		g_slice_free (Block6Data, _data6_);
	}
}


#line 624 "ease-slide-actor.vala"
static void ease_slide_actor_pivot_transition (EaseSlideActor* self, EaseSlideActor* new_slide, ClutterGroup* container, guint length) {
#line 1369 "ease-slide-actor.c"
	Block6Data* _data6_;
	ClutterAlpha* _tmp0_;
#line 624 "ease-slide-actor.vala"
	g_return_if_fail (self != NULL);
#line 624 "ease-slide-actor.vala"
	g_return_if_fail (new_slide != NULL);
#line 624 "ease-slide-actor.vala"
	g_return_if_fail (container != NULL);
#line 1378 "ease-slide-actor.c"
	_data6_ = g_slice_new0 (Block6Data);
	_data6_->_ref_count_ = 1;
	_data6_->self = g_object_ref (self);
	_data6_->new_slide = _g_object_ref0 (new_slide);
	_data6_->xpos = (float) 0;
	_data6_->ypos = (float) 0;
	_data6_->angle = (float) 90;
#line 628 "ease-slide-actor.vala"
	switch (ease_slide_get_variant (self->priv->_slide)) {
#line 1388 "ease-slide-actor.c"
		case EASE_TRANSITION_VARIANT_TOP_RIGHT:
		{
#line 631 "ease-slide-actor.vala"
			_data6_->xpos = (float) ease_slide_get_width (self->priv->_slide);
#line 632 "ease-slide-actor.vala"
			_data6_->angle = (float) (-90);
#line 633 "ease-slide-actor.vala"
			break;
#line 1397 "ease-slide-actor.c"
		}
		case EASE_TRANSITION_VARIANT_BOTTOM_LEFT:
		{
#line 635 "ease-slide-actor.vala"
			_data6_->ypos = (float) ease_slide_get_height (self->priv->_slide);
#line 636 "ease-slide-actor.vala"
			_data6_->angle = (float) (-90);
#line 637 "ease-slide-actor.vala"
			break;
#line 1407 "ease-slide-actor.c"
		}
		case EASE_TRANSITION_VARIANT_BOTTOM_RIGHT:
		{
#line 639 "ease-slide-actor.vala"
			_data6_->xpos = (float) ease_slide_get_width (self->priv->_slide);
#line 640 "ease-slide-actor.vala"
			_data6_->ypos = (float) ease_slide_get_height (self->priv->_slide);
#line 641 "ease-slide-actor.vala"
			break;
#line 1417 "ease-slide-actor.c"
		}
	}
#line 645 "ease-slide-actor.vala"
	clutter_actor_set_rotation ((ClutterActor*) _data6_->new_slide, CLUTTER_Z_AXIS, (double) _data6_->angle, _data6_->xpos, _data6_->ypos, (float) 0);
#line 647 "ease-slide-actor.vala"
	ease_slide_actor_set_animation_alpha (self, _tmp0_ = g_object_ref_sink (clutter_alpha_new_full (self->priv->_animation_time, (gulong) EASE_SLIDE_ACTOR_EASE_PIVOT)));
#line 1424 "ease-slide-actor.c"
	_g_object_unref0 (_tmp0_);
#line 651 "ease-slide-actor.vala"
	g_signal_connect_data (self->priv->_animation_time, "new-frame", (GCallback) __lambda9__clutter_timeline_new_frame, block6_data_ref (_data6_), (GClosureNotify) block6_data_unref, 0);
#line 1428 "ease-slide-actor.c"
	block6_data_unref (_data6_);
}


/**
 * Starts a "flip" transition.
 *
 * @param new_slide The new SlideActor.
 * @param container The container that holds the displayed SlideActors.
 * @param length The length of the transition, in milliseconds.
 */
#line 715 "ease-slide-actor.vala"
static void _lambda14_ (gint m, Block7Data* _data7_) {
#line 1442 "ease-slide-actor.c"
	EaseSlideActor * self;
	self = _data7_->self;
#line 717 "ease-slide-actor.vala"
	clutter_actor_set_rotation ((ClutterActor*) self, _data7_->axis, (_data7_->positive * 90) * clutter_alpha_get_alpha (self->priv->alpha1), _data7_->x_point, _data7_->y_point, (float) 0);
#line 721 "ease-slide-actor.vala"
	clutter_actor_set_depth ((ClutterActor*) self, (float) (EASE_SLIDE_ACTOR_FLIP_DEPTH * clutter_alpha_get_alpha (self->priv->alpha1)));
#line 1449 "ease-slide-actor.c"
}


#line 715 "ease-slide-actor.vala"
static void __lambda14__clutter_timeline_new_frame (ClutterTimeline* _sender, gint frame_num, gpointer self) {
#line 1455 "ease-slide-actor.c"
	_lambda14_ (frame_num, self);
}


#line 725 "ease-slide-actor.vala"
static void _lambda15_ (gint m, Block7Data* _data7_) {
#line 1462 "ease-slide-actor.c"
	EaseSlideActor * self;
	self = _data7_->self;
#line 727 "ease-slide-actor.vala"
	clutter_actor_set_rotation ((ClutterActor*) _data7_->new_slide, _data7_->axis, (_data7_->positive * (-90)) * (1 - clutter_alpha_get_alpha (self->priv->alpha2)), _data7_->x_point, _data7_->y_point, (float) 0);
#line 731 "ease-slide-actor.vala"
	clutter_actor_set_depth ((ClutterActor*) _data7_->new_slide, EASE_SLIDE_ACTOR_FLIP_DEPTH * ((float) (1 - clutter_alpha_get_alpha (self->priv->alpha2))));
#line 734 "ease-slide-actor.vala"
	clutter_actor_set_opacity ((ClutterActor*) _data7_->new_slide, (guint) 255);
#line 1471 "ease-slide-actor.c"
}


#line 725 "ease-slide-actor.vala"
static void __lambda15__clutter_timeline_new_frame (ClutterTimeline* _sender, gint frame_num, gpointer self) {
#line 1477 "ease-slide-actor.c"
	_lambda15_ (frame_num, self);
}


#line 737 "ease-slide-actor.vala"
static void _lambda16_ (Block7Data* _data7_) {
#line 1484 "ease-slide-actor.c"
	EaseSlideActor * self;
	self = _data7_->self;
#line 739 "ease-slide-actor.vala"
	clutter_actor_set_opacity ((ClutterActor*) self, (guint) 0);
#line 742 "ease-slide-actor.vala"
	clutter_actor_set_depth ((ClutterActor*) _data7_->new_slide, EASE_SLIDE_ACTOR_FLIP_DEPTH);
#line 745 "ease-slide-actor.vala"
	clutter_timeline_start (self->priv->time2);
#line 1493 "ease-slide-actor.c"
}


#line 737 "ease-slide-actor.vala"
static void __lambda16__clutter_timeline_completed (ClutterTimeline* _sender, gpointer self) {
#line 1499 "ease-slide-actor.c"
	_lambda16_ (self);
}


static Block7Data* block7_data_ref (Block7Data* _data7_) {
	g_atomic_int_inc (&_data7_->_ref_count_);
	return _data7_;
}


static void block7_data_unref (Block7Data* _data7_) {
	if (g_atomic_int_dec_and_test (&_data7_->_ref_count_)) {
		_g_object_unref0 (_data7_->self);
		_g_object_unref0 (_data7_->new_slide);
		g_slice_free (Block7Data, _data7_);
	}
}


#line 665 "ease-slide-actor.vala"
static void ease_slide_actor_flip_transition (EaseSlideActor* self, EaseSlideActor* new_slide, ClutterGroup* container, guint length) {
#line 1521 "ease-slide-actor.c"
	Block7Data* _data7_;
	ClutterTimeline* _tmp0_;
	ClutterTimeline* _tmp1_;
	ClutterAlpha* _tmp2_;
	ClutterAlpha* _tmp3_;
#line 665 "ease-slide-actor.vala"
	g_return_if_fail (self != NULL);
#line 665 "ease-slide-actor.vala"
	g_return_if_fail (new_slide != NULL);
#line 665 "ease-slide-actor.vala"
	g_return_if_fail (container != NULL);
#line 1533 "ease-slide-actor.c"
	_data7_ = g_slice_new0 (Block7Data);
	_data7_->_ref_count_ = 1;
	_data7_->self = g_object_ref (self);
	_data7_->new_slide = _g_object_ref0 (new_slide);
#line 669 "ease-slide-actor.vala"
	clutter_actor_set_opacity ((ClutterActor*) _data7_->new_slide, (guint) 0);
#line 672 "ease-slide-actor.vala"
	self->priv->time1 = (_tmp0_ = clutter_timeline_new (length / 2), _g_object_unref0 (self->priv->time1), _tmp0_);
#line 673 "ease-slide-actor.vala"
	self->priv->time2 = (_tmp1_ = clutter_timeline_new (length / 2), _g_object_unref0 (self->priv->time2), _tmp1_);
#line 674 "ease-slide-actor.vala"
	self->priv->alpha1 = (_tmp2_ = g_object_ref_sink (clutter_alpha_new_full (self->priv->time1, (gulong) CLUTTER_EASE_IN_SINE)), _g_object_unref0 (self->priv->alpha1), _tmp2_);
#line 676 "ease-slide-actor.vala"
	self->priv->alpha2 = (_tmp3_ = g_object_ref_sink (clutter_alpha_new_full (self->priv->time2, (gulong) CLUTTER_EASE_OUT_SINE)), _g_object_unref0 (self->priv->alpha2), _tmp3_);
#line 1548 "ease-slide-actor.c"
	_data7_->x_point = (float) 0;
	_data7_->y_point = (float) 0;
#line 688 "ease-slide-actor.vala"
	switch (ease_slide_get_variant (self->priv->_slide)) {
#line 1553 "ease-slide-actor.c"
		case EASE_TRANSITION_VARIANT_BOTTOM_TO_TOP:
		{
#line 691 "ease-slide-actor.vala"
			_data7_->axis = CLUTTER_X_AXIS;
#line 692 "ease-slide-actor.vala"
			_data7_->positive = (float) 1;
#line 693 "ease-slide-actor.vala"
			_data7_->y_point = (float) (ease_slide_get_height (self->priv->_slide) / 2);
#line 694 "ease-slide-actor.vala"
			break;
#line 1564 "ease-slide-actor.c"
		}
		case EASE_TRANSITION_VARIANT_TOP_TO_BOTTOM:
		{
#line 697 "ease-slide-actor.vala"
			_data7_->axis = CLUTTER_X_AXIS;
#line 698 "ease-slide-actor.vala"
			_data7_->positive = (float) (-1);
#line 699 "ease-slide-actor.vala"
			break;
#line 1574 "ease-slide-actor.c"
		}
		case EASE_TRANSITION_VARIANT_LEFT_TO_RIGHT:
		{
#line 702 "ease-slide-actor.vala"
			_data7_->axis = CLUTTER_Y_AXIS;
#line 703 "ease-slide-actor.vala"
			_data7_->positive = (float) 1;
#line 704 "ease-slide-actor.vala"
			_data7_->x_point = (float) (ease_slide_get_width (self->priv->_slide) / 2);
#line 705 "ease-slide-actor.vala"
			break;
#line 1586 "ease-slide-actor.c"
		}
		default:
		{
#line 708 "ease-slide-actor.vala"
			_data7_->axis = CLUTTER_Y_AXIS;
#line 709 "ease-slide-actor.vala"
			_data7_->positive = (float) (-1);
#line 710 "ease-slide-actor.vala"
			_data7_->x_point = (float) (ease_slide_get_width (self->priv->_slide) / 2);
#line 711 "ease-slide-actor.vala"
			break;
#line 1598 "ease-slide-actor.c"
		}
	}
#line 715 "ease-slide-actor.vala"
	g_signal_connect_data (self->priv->time1, "new-frame", (GCallback) __lambda14__clutter_timeline_new_frame, block7_data_ref (_data7_), (GClosureNotify) block7_data_unref, 0);
#line 725 "ease-slide-actor.vala"
	g_signal_connect_data (self->priv->time2, "new-frame", (GCallback) __lambda15__clutter_timeline_new_frame, block7_data_ref (_data7_), (GClosureNotify) block7_data_unref, 0);
#line 737 "ease-slide-actor.vala"
	g_signal_connect_data (self->priv->time1, "completed", (GCallback) __lambda16__clutter_timeline_completed, block7_data_ref (_data7_), (GClosureNotify) block7_data_unref, 0);
#line 749 "ease-slide-actor.vala"
	clutter_timeline_start (self->priv->time1);
#line 1609 "ease-slide-actor.c"
	block7_data_unref (_data7_);
}


/**
 * Starts a "revolving door" transition.
 *
 * @param new_slide The new SlideActor.
 * @param container The container that holds the displayed SlideActors.
 * @param length The length of the transition, in milliseconds.
 */
#line 805 "ease-slide-actor.vala"
static void _lambda17_ (gint m, Block8Data* _data8_) {
#line 1623 "ease-slide-actor.c"
	EaseSlideActor * self;
	self = _data8_->self;
#line 807 "ease-slide-actor.vala"
	clutter_actor_set_rotation ((ClutterActor*) _data8_->new_slide, _data8_->axis, (_data8_->positive * 90) * (1 - clutter_alpha_get_alpha (self->priv->_animation_alpha)), _data8_->x_point, _data8_->y_point, (float) 0);
#line 812 "ease-slide-actor.vala"
	clutter_actor_set_rotation ((ClutterActor*) self, _data8_->axis, (_data8_->positive * (-110)) * clutter_alpha_get_alpha (self->priv->_animation_alpha), _data8_->x_point, _data8_->y_point, (float) 0);
#line 1630 "ease-slide-actor.c"
}


#line 805 "ease-slide-actor.vala"
static void __lambda17__clutter_timeline_new_frame (ClutterTimeline* _sender, gint frame_num, gpointer self) {
#line 1636 "ease-slide-actor.c"
	_lambda17_ (frame_num, self);
}


static Block8Data* block8_data_ref (Block8Data* _data8_) {
	g_atomic_int_inc (&_data8_->_ref_count_);
	return _data8_;
}


static void block8_data_unref (Block8Data* _data8_) {
	if (g_atomic_int_dec_and_test (&_data8_->_ref_count_)) {
		_g_object_unref0 (_data8_->self);
		_g_object_unref0 (_data8_->new_slide);
		g_slice_free (Block8Data, _data8_);
	}
}


#line 759 "ease-slide-actor.vala"
static void ease_slide_actor_revolving_door_transition (EaseSlideActor* self, EaseSlideActor* new_slide, ClutterGroup* container, guint length) {
#line 1658 "ease-slide-actor.c"
	Block8Data* _data8_;
	ClutterAlpha* _tmp0_;
#line 759 "ease-slide-actor.vala"
	g_return_if_fail (self != NULL);
#line 759 "ease-slide-actor.vala"
	g_return_if_fail (new_slide != NULL);
#line 759 "ease-slide-actor.vala"
	g_return_if_fail (container != NULL);
#line 1667 "ease-slide-actor.c"
	_data8_ = g_slice_new0 (Block8Data);
	_data8_->_ref_count_ = 1;
	_data8_->self = g_object_ref (self);
	_data8_->new_slide = _g_object_ref0 (new_slide);
#line 764 "ease-slide-actor.vala"
	clutter_actor_set_depth ((ClutterActor*) self, (float) 1);
#line 766 "ease-slide-actor.vala"
	ease_slide_actor_set_animation_alpha (self, _tmp0_ = g_object_ref_sink (clutter_alpha_new_full (self->priv->_animation_time, (gulong) EASE_SLIDE_ACTOR_EASE_SLIDE)));
#line 1676 "ease-slide-actor.c"
	_g_object_unref0 (_tmp0_);
	_data8_->x_point = (float) 0;
	_data8_->y_point = (float) 0;
#line 777 "ease-slide-actor.vala"
	switch (ease_slide_get_variant (self->priv->_slide)) {
#line 1682 "ease-slide-actor.c"
		case EASE_TRANSITION_VARIANT_LEFT:
		{
#line 780 "ease-slide-actor.vala"
			_data8_->axis = CLUTTER_Y_AXIS;
#line 781 "ease-slide-actor.vala"
			_data8_->positive = (float) 1;
#line 782 "ease-slide-actor.vala"
			break;
#line 1691 "ease-slide-actor.c"
		}
		case EASE_TRANSITION_VARIANT_RIGHT:
		{
#line 785 "ease-slide-actor.vala"
			_data8_->axis = CLUTTER_Y_AXIS;
#line 786 "ease-slide-actor.vala"
			_data8_->positive = (float) (-1);
#line 787 "ease-slide-actor.vala"
			_data8_->x_point = (float) ease_slide_get_width (self->priv->_slide);
#line 788 "ease-slide-actor.vala"
			break;
#line 1703 "ease-slide-actor.c"
		}
		case EASE_TRANSITION_VARIANT_TOP:
		{
#line 791 "ease-slide-actor.vala"
			_data8_->axis = CLUTTER_X_AXIS;
#line 792 "ease-slide-actor.vala"
			_data8_->positive = (float) (-1);
#line 793 "ease-slide-actor.vala"
			break;
#line 1713 "ease-slide-actor.c"
		}
		default:
		{
#line 796 "ease-slide-actor.vala"
			_data8_->axis = CLUTTER_X_AXIS;
#line 797 "ease-slide-actor.vala"
			_data8_->positive = (float) 1;
#line 798 "ease-slide-actor.vala"
			_data8_->y_point = (float) ease_slide_get_height (self->priv->_slide);
#line 799 "ease-slide-actor.vala"
			break;
#line 1725 "ease-slide-actor.c"
		}
	}
#line 803 "ease-slide-actor.vala"
	clutter_actor_set_rotation ((ClutterActor*) _data8_->new_slide, _data8_->axis, (double) (90 * _data8_->positive), _data8_->x_point, _data8_->y_point, (float) 0);
#line 805 "ease-slide-actor.vala"
	g_signal_connect_data (self->priv->_animation_time, "new-frame", (GCallback) __lambda17__clutter_timeline_new_frame, block8_data_ref (_data8_), (GClosureNotify) block8_data_unref, 0);
#line 1732 "ease-slide-actor.c"
	block8_data_unref (_data8_);
}


/**
 * Starts a "reveal" transition.
 *
 * @param new_slide The new SlideActor.
 * @param container The container that holds the displayed SlideActors.
 * @param length The length of the transition, in milliseconds.
 */
#line 825 "ease-slide-actor.vala"
static void ease_slide_actor_reveal_transition (EaseSlideActor* self, EaseSlideActor* new_slide, ClutterGroup* container, guint length) {
#line 1746 "ease-slide-actor.c"
	ClutterActor* _tmp0_;
#line 825 "ease-slide-actor.vala"
	g_return_if_fail (self != NULL);
#line 825 "ease-slide-actor.vala"
	g_return_if_fail (new_slide != NULL);
#line 825 "ease-slide-actor.vala"
	g_return_if_fail (container != NULL);
#line 828 "ease-slide-actor.vala"
	clutter_container_raise_child ((_tmp0_ = clutter_actor_get_parent ((ClutterActor*) self), CLUTTER_IS_CONTAINER (_tmp0_) ? ((ClutterContainer*) _tmp0_) : NULL), (ClutterActor*) self, (ClutterActor*) new_slide);
#line 830 "ease-slide-actor.vala"
	switch (ease_slide_get_variant (self->priv->_slide)) {
#line 1758 "ease-slide-actor.c"
		case EASE_TRANSITION_VARIANT_UP:
		{
#line 833 "ease-slide-actor.vala"
			clutter_actor_animate ((ClutterActor*) self, (gulong) EASE_SLIDE_ACTOR_EASE_SLIDE, length, "y", -((float) ease_slide_get_height (self->priv->_slide)), NULL);
#line 834 "ease-slide-actor.vala"
			break;
#line 1765 "ease-slide-actor.c"
		}
		case EASE_TRANSITION_VARIANT_DOWN:
		{
#line 836 "ease-slide-actor.vala"
			clutter_actor_animate ((ClutterActor*) self, (gulong) EASE_SLIDE_ACTOR_EASE_SLIDE, length, "y", (float) ease_slide_get_height (self->priv->_slide), NULL);
#line 837 "ease-slide-actor.vala"
			break;
#line 1773 "ease-slide-actor.c"
		}
		case EASE_TRANSITION_VARIANT_LEFT:
		{
#line 839 "ease-slide-actor.vala"
			clutter_actor_animate ((ClutterActor*) self, (gulong) EASE_SLIDE_ACTOR_EASE_SLIDE, length, "x", -((float) ease_slide_get_width (self->priv->_slide)), NULL);
#line 840 "ease-slide-actor.vala"
			break;
#line 1781 "ease-slide-actor.c"
		}
		case EASE_TRANSITION_VARIANT_RIGHT:
		{
#line 842 "ease-slide-actor.vala"
			clutter_actor_animate ((ClutterActor*) self, (gulong) EASE_SLIDE_ACTOR_EASE_SLIDE, length, "x", (float) ease_slide_get_width (self->priv->_slide), NULL);
#line 843 "ease-slide-actor.vala"
			break;
#line 1789 "ease-slide-actor.c"
		}
	}
}


/**
 * Starts a "fall" transition.
 *
 * @param new_slide The new SlideActor.
 * @param container The container that holds the displayed SlideActors.
 * @param length The length of the transition, in milliseconds.
 */
#line 861 "ease-slide-actor.vala"
static void _lambda18_ (gint m, EaseSlideActor* self) {
#line 862 "ease-slide-actor.vala"
	clutter_actor_set_rotation ((ClutterActor*) self, CLUTTER_X_AXIS, (-90) * clutter_alpha_get_alpha (self->priv->_animation_alpha), (float) 0, (float) ease_slide_get_height (self->priv->_slide), (float) 0);
#line 1806 "ease-slide-actor.c"
}


#line 861 "ease-slide-actor.vala"
static void __lambda18__clutter_timeline_new_frame (ClutterTimeline* _sender, gint frame_num, gpointer self) {
#line 1812 "ease-slide-actor.c"
	_lambda18_ (frame_num, self);
}


#line 854 "ease-slide-actor.vala"
static void ease_slide_actor_fall_transition (EaseSlideActor* self, EaseSlideActor* new_slide, ClutterGroup* container, guint length) {
#line 1819 "ease-slide-actor.c"
	ClutterAlpha* _tmp0_;
#line 854 "ease-slide-actor.vala"
	g_return_if_fail (self != NULL);
#line 854 "ease-slide-actor.vala"
	g_return_if_fail (new_slide != NULL);
#line 854 "ease-slide-actor.vala"
	g_return_if_fail (container != NULL);
#line 857 "ease-slide-actor.vala"
	clutter_actor_set_depth ((ClutterActor*) self, (float) 1);
#line 859 "ease-slide-actor.vala"
	ease_slide_actor_set_animation_alpha (self, _tmp0_ = g_object_ref_sink (clutter_alpha_new_full (self->priv->_animation_time, (gulong) CLUTTER_EASE_IN_QUART)));
#line 1831 "ease-slide-actor.c"
	_g_object_unref0 (_tmp0_);
#line 861 "ease-slide-actor.vala"
	g_signal_connect_object (self->priv->_animation_time, "new-frame", (GCallback) __lambda18__clutter_timeline_new_frame, self, 0);
#line 1835 "ease-slide-actor.c"
}


/**
 * Starts a "slats" transition.
 *
 * @param new_slide The new SlideActor.
 * @param container The container that holds the displayed SlideActors.
 * @param length The length of the transition, in milliseconds.
 */
#line 927 "ease-slide-actor.vala"
static void _lambda12_ (gint m, Block9Data* _data9_) {
#line 1848 "ease-slide-actor.c"
	EaseSlideActor * self;
	self = _data9_->self;
	{
		gint i;
#line 928 "ease-slide-actor.vala"
		i = 0;
#line 1855 "ease-slide-actor.c"
		{
			gboolean _tmp0_;
#line 928 "ease-slide-actor.vala"
			_tmp0_ = TRUE;
#line 928 "ease-slide-actor.vala"
			while (TRUE) {
#line 928 "ease-slide-actor.vala"
				if (!_tmp0_) {
#line 928 "ease-slide-actor.vala"
					i++;
#line 1866 "ease-slide-actor.c"
				}
#line 928 "ease-slide-actor.vala"
				_tmp0_ = FALSE;
#line 928 "ease-slide-actor.vala"
				if (!(i < EASE_SLIDE_ACTOR_SLAT_COUNT)) {
#line 928 "ease-slide-actor.vala"
					break;
#line 1874 "ease-slide-actor.c"
				}
#line 930 "ease-slide-actor.vala"
				clutter_actor_set_rotation ((ClutterActor*) _data9_->groups[i], CLUTTER_Y_AXIS, 180 * clutter_alpha_get_alpha (self->priv->_animation_alpha), (i + 0.5f) * _data9_->width, (float) 0, (float) 0);
#line 1878 "ease-slide-actor.c"
			}
		}
	}
}


#line 927 "ease-slide-actor.vala"
static void __lambda12__clutter_timeline_new_frame (ClutterTimeline* _sender, gint frame_num, gpointer self) {
#line 1887 "ease-slide-actor.c"
	_lambda12_ (frame_num, self);
}


#line 937 "ease-slide-actor.vala"
static void _lambda13_ (Block9Data* _data9_) {
#line 1894 "ease-slide-actor.c"
	EaseSlideActor * self;
	self = _data9_->self;
	{
		gint i;
#line 939 "ease-slide-actor.vala"
		i = 0;
#line 1901 "ease-slide-actor.c"
		{
			gboolean _tmp0_;
#line 939 "ease-slide-actor.vala"
			_tmp0_ = TRUE;
#line 939 "ease-slide-actor.vala"
			while (TRUE) {
#line 939 "ease-slide-actor.vala"
				if (!_tmp0_) {
#line 939 "ease-slide-actor.vala"
					i++;
#line 1912 "ease-slide-actor.c"
				}
#line 939 "ease-slide-actor.vala"
				_tmp0_ = FALSE;
#line 939 "ease-slide-actor.vala"
				if (!(i < EASE_SLIDE_ACTOR_SLAT_COUNT)) {
#line 939 "ease-slide-actor.vala"
					break;
#line 1920 "ease-slide-actor.c"
				}
#line 941 "ease-slide-actor.vala"
				clutter_container_remove_actor ((ClutterContainer*) _data9_->container, (ClutterActor*) _data9_->groups[i]);
#line 1924 "ease-slide-actor.c"
			}
		}
	}
#line 945 "ease-slide-actor.vala"
	clutter_actor_set_x ((ClutterActor*) _data9_->new_slide, (float) 0);
#line 948 "ease-slide-actor.vala"
	cogl_set_depth_test_enabled (FALSE);
#line 1932 "ease-slide-actor.c"
}


#line 937 "ease-slide-actor.vala"
static void __lambda13__clutter_timeline_completed (ClutterTimeline* _sender, gpointer self) {
#line 1938 "ease-slide-actor.c"
	_lambda13_ (self);
}


static Block9Data* block9_data_ref (Block9Data* _data9_) {
	g_atomic_int_inc (&_data9_->_ref_count_);
	return _data9_;
}


static void block9_data_unref (Block9Data* _data9_) {
	if (g_atomic_int_dec_and_test (&_data9_->_ref_count_)) {
		_g_object_unref0 (_data9_->self);
		_data9_->groups = (_vala_array_free (_data9_->groups, _data9_->groups_length1, (GDestroyNotify) g_object_unref), NULL);
		_g_object_unref0 (_data9_->new_slide);
		_g_object_unref0 (_data9_->container);
		g_slice_free (Block9Data, _data9_);
	}
}


#line 875 "ease-slide-actor.vala"
static void ease_slide_actor_slats_transition (EaseSlideActor* self, EaseSlideActor* new_slide, ClutterGroup* container, guint length) {
#line 1962 "ease-slide-actor.c"
	Block9Data* _data9_;
	gint this_slats_length1;
	gint _this_slats_size_;
	ClutterClone** _tmp0_;
	ClutterClone** this_slats;
	gint new_slats_length1;
	gint _new_slats_size_;
	ClutterClone** _tmp1_;
	ClutterClone** new_slats;
	ClutterGroup** _tmp2_;
	ClutterAlpha* _tmp7_;
#line 875 "ease-slide-actor.vala"
	g_return_if_fail (self != NULL);
#line 875 "ease-slide-actor.vala"
	g_return_if_fail (new_slide != NULL);
#line 875 "ease-slide-actor.vala"
	g_return_if_fail (container != NULL);
#line 1980 "ease-slide-actor.c"
	_data9_ = g_slice_new0 (Block9Data);
	_data9_->_ref_count_ = 1;
	_data9_->self = g_object_ref (self);
	_data9_->new_slide = _g_object_ref0 (new_slide);
	_data9_->container = _g_object_ref0 (container);
#line 879 "ease-slide-actor.vala"
	cogl_set_depth_test_enabled (TRUE);
#line 882 "ease-slide-actor.vala"
	clutter_actor_reparent ((ClutterActor*) self, (ClutterActor*) _data9_->container);
#line 883 "ease-slide-actor.vala"
	clutter_actor_reparent ((ClutterActor*) _data9_->new_slide, (ClutterActor*) _data9_->container);
#line 884 "ease-slide-actor.vala"
	clutter_actor_set_x ((ClutterActor*) self, (float) ease_slide_get_width (self->priv->_slide));
#line 885 "ease-slide-actor.vala"
	clutter_actor_set_x ((ClutterActor*) _data9_->new_slide, (float) ease_slide_get_width (self->priv->_slide));
#line 1996 "ease-slide-actor.c"
	this_slats = (_tmp0_ = g_new0 (ClutterClone*, EASE_SLIDE_ACTOR_SLAT_COUNT + 1), this_slats_length1 = EASE_SLIDE_ACTOR_SLAT_COUNT, _this_slats_size_ = this_slats_length1, _tmp0_);
	new_slats = (_tmp1_ = g_new0 (ClutterClone*, EASE_SLIDE_ACTOR_SLAT_COUNT + 1), new_slats_length1 = EASE_SLIDE_ACTOR_SLAT_COUNT, _new_slats_size_ = new_slats_length1, _tmp1_);
	_data9_->groups = (_tmp2_ = g_new0 (ClutterGroup*, EASE_SLIDE_ACTOR_SLAT_COUNT + 1), _data9_->groups_length1 = EASE_SLIDE_ACTOR_SLAT_COUNT, _tmp2_);
	_data9_->width = ((float) ease_slide_get_width (self->priv->_slide)) / EASE_SLIDE_ACTOR_SLAT_COUNT;
	{
		gint i;
#line 896 "ease-slide-actor.vala"
		i = 0;
#line 2005 "ease-slide-actor.c"
		{
			gboolean _tmp3_;
#line 896 "ease-slide-actor.vala"
			_tmp3_ = TRUE;
#line 896 "ease-slide-actor.vala"
			while (TRUE) {
#line 2012 "ease-slide-actor.c"
				ClutterGroup* _tmp4_;
				ClutterClone* _tmp5_;
				ClutterClone* _tmp6_;
#line 896 "ease-slide-actor.vala"
				if (!_tmp3_) {
#line 896 "ease-slide-actor.vala"
					i++;
#line 2020 "ease-slide-actor.c"
				}
#line 896 "ease-slide-actor.vala"
				_tmp3_ = FALSE;
#line 896 "ease-slide-actor.vala"
				if (!(i < EASE_SLIDE_ACTOR_SLAT_COUNT)) {
#line 896 "ease-slide-actor.vala"
					break;
#line 2028 "ease-slide-actor.c"
				}
#line 899 "ease-slide-actor.vala"
				_data9_->groups[i] = (_tmp4_ = g_object_ref_sink ((ClutterGroup*) clutter_group_new ()), _g_object_unref0 (_data9_->groups[i]), _tmp4_);
#line 900 "ease-slide-actor.vala"
				clutter_container_add_actor ((ClutterContainer*) _data9_->container, (ClutterActor*) _data9_->groups[i]);
#line 903 "ease-slide-actor.vala"
				this_slats[i] = (_tmp5_ = g_object_ref_sink ((ClutterClone*) clutter_clone_new ((ClutterActor*) self)), _g_object_unref0 (this_slats[i]), _tmp5_);
#line 904 "ease-slide-actor.vala"
				clutter_container_add_actor ((ClutterContainer*) _data9_->groups[i], (ClutterActor*) this_slats[i]);
#line 905 "ease-slide-actor.vala"
				new_slats[i] = (_tmp6_ = g_object_ref_sink ((ClutterClone*) clutter_clone_new ((ClutterActor*) _data9_->new_slide)), _g_object_unref0 (new_slats[i]), _tmp6_);
#line 906 "ease-slide-actor.vala"
				clutter_container_add_actor ((ClutterContainer*) _data9_->groups[i], (ClutterActor*) new_slats[i]);
#line 909 "ease-slide-actor.vala"
				clutter_actor_set_clip ((ClutterActor*) this_slats[i], _data9_->width * i, (float) 0, _data9_->width, (float) ease_slide_get_height (self->priv->_slide));
#line 911 "ease-slide-actor.vala"
				clutter_actor_set_clip ((ClutterActor*) new_slats[i], _data9_->width * i, (float) 0, _data9_->width, (float) ease_slide_get_height (self->priv->_slide));
#line 915 "ease-slide-actor.vala"
				clutter_actor_set_rotation ((ClutterActor*) new_slats[i], CLUTTER_Y_AXIS, (double) 180, (_data9_->width / 2) + (i * _data9_->width), (float) 0, (float) 0);
#line 919 "ease-slide-actor.vala"
				clutter_actor_set_depth ((ClutterActor*) new_slats[i], (float) (-2));
#line 2050 "ease-slide-actor.c"
			}
		}
	}
#line 923 "ease-slide-actor.vala"
	ease_slide_actor_set_animation_alpha (self, _tmp7_ = g_object_ref_sink (clutter_alpha_new_full (self->priv->_animation_time, (gulong) CLUTTER_EASE_IN_OUT_BACK)));
#line 2056 "ease-slide-actor.c"
	_g_object_unref0 (_tmp7_);
#line 927 "ease-slide-actor.vala"
	g_signal_connect_data (self->priv->_animation_time, "new-frame", (GCallback) __lambda12__clutter_timeline_new_frame, block9_data_ref (_data9_), (GClosureNotify) block9_data_unref, 0);
#line 937 "ease-slide-actor.vala"
	g_signal_connect_data (self->priv->_animation_time, "completed", (GCallback) __lambda13__clutter_timeline_completed, block9_data_ref (_data9_), (GClosureNotify) block9_data_unref, 0);
#line 2062 "ease-slide-actor.c"
	new_slats = (_vala_array_free (new_slats, new_slats_length1, (GDestroyNotify) g_object_unref), NULL);
	this_slats = (_vala_array_free (this_slats, this_slats_length1, (GDestroyNotify) g_object_unref), NULL);
	block9_data_unref (_data9_);
}


/**
 * Starts an "open door" transition.
 *
 * @param new_slide The new SlideActor.
 * @param container The container that holds the displayed SlideActors.
 * @param length The length of the transition, in milliseconds.
 */
#line 1033 "ease-slide-actor.vala"
static void _lambda10_ (gint m, Block10Data* _data10_) {
#line 2078 "ease-slide-actor.c"
	EaseSlideActor * self;
	self = _data10_->self;
#line 1034 "ease-slide-actor.vala"
	clutter_actor_set_rotation ((ClutterActor*) _data10_->left_group, CLUTTER_Y_AXIS, 180 * clutter_alpha_get_alpha (self->priv->_animation_alpha), (float) 0, (float) 0, (float) 0);
#line 1038 "ease-slide-actor.vala"
	clutter_actor_set_rotation ((ClutterActor*) _data10_->right_group, CLUTTER_Y_AXIS, (-180) * clutter_alpha_get_alpha (self->priv->_animation_alpha), _data10_->width * 2, (float) 0, (float) 0);
#line 2085 "ease-slide-actor.c"
}


#line 1033 "ease-slide-actor.vala"
static void __lambda10__clutter_timeline_new_frame (ClutterTimeline* _sender, gint frame_num, gpointer self) {
#line 2091 "ease-slide-actor.c"
	_lambda10_ (frame_num, self);
}


#line 1044 "ease-slide-actor.vala"
static void _lambda11_ (Block10Data* _data10_) {
#line 2098 "ease-slide-actor.c"
	EaseSlideActor * self;
	self = _data10_->self;
#line 1045 "ease-slide-actor.vala"
	clutter_container_remove_actor ((ClutterContainer*) _data10_->container, (ClutterActor*) _data10_->left_group);
#line 1046 "ease-slide-actor.vala"
	clutter_container_remove_actor ((ClutterContainer*) _data10_->container, (ClutterActor*) _data10_->right_group);
#line 2105 "ease-slide-actor.c"
}


#line 1044 "ease-slide-actor.vala"
static void __lambda11__clutter_timeline_completed (ClutterTimeline* _sender, gpointer self) {
#line 2111 "ease-slide-actor.c"
	_lambda11_ (self);
}


static Block10Data* block10_data_ref (Block10Data* _data10_) {
	g_atomic_int_inc (&_data10_->_ref_count_);
	return _data10_;
}


static void block10_data_unref (Block10Data* _data10_) {
	if (g_atomic_int_dec_and_test (&_data10_->_ref_count_)) {
		_g_object_unref0 (_data10_->self);
		_g_object_unref0 (_data10_->right_group);
		_g_object_unref0 (_data10_->left_group);
		_g_object_unref0 (_data10_->container);
		g_slice_free (Block10Data, _data10_);
	}
}


#line 959 "ease-slide-actor.vala"
static void ease_slide_actor_open_door_transition (EaseSlideActor* self, EaseSlideActor* new_slide, ClutterGroup* container, guint length) {
#line 2135 "ease-slide-actor.c"
	Block10Data* _data10_;
	ClutterClone* reflection;
	ClutterClone* left;
	ClutterClone* right;
	ClutterClone* left_ref;
	ClutterClone* right_ref;
	ClutterTimeline* _tmp0_;
	ClutterTimeline* _tmp1_;
	ClutterAlpha* _tmp2_;
#line 959 "ease-slide-actor.vala"
	g_return_if_fail (self != NULL);
#line 959 "ease-slide-actor.vala"
	g_return_if_fail (new_slide != NULL);
#line 959 "ease-slide-actor.vala"
	g_return_if_fail (container != NULL);
#line 2151 "ease-slide-actor.c"
	_data10_ = g_slice_new0 (Block10Data);
	_data10_->_ref_count_ = 1;
	_data10_->self = g_object_ref (self);
	_data10_->container = _g_object_ref0 (container);
#line 964 "ease-slide-actor.vala"
	reflection = g_object_ref_sink ((ClutterClone*) clutter_clone_new ((ClutterActor*) new_slide));
#line 965 "ease-slide-actor.vala"
	g_object_set ((ClutterActor*) reflection, "rotation-angle-z", (double) 180, NULL);
#line 966 "ease-slide-actor.vala"
	g_object_set ((ClutterActor*) reflection, "rotation-angle-y", (double) 180, NULL);
#line 967 "ease-slide-actor.vala"
	clutter_actor_set_y ((ClutterActor*) reflection, (float) (2 * ease_slide_get_height (self->priv->_slide)));
#line 968 "ease-slide-actor.vala"
	clutter_actor_set_opacity ((ClutterActor*) reflection, (guint) EASE_SLIDE_ACTOR_REFLECTION_OPACITY);
#line 971 "ease-slide-actor.vala"
	clutter_actor_set_depth ((ClutterActor*) new_slide, EASE_SLIDE_ACTOR_OPEN_DEPTH);
#line 972 "ease-slide-actor.vala"
	clutter_actor_animate ((ClutterActor*) new_slide, (gulong) CLUTTER_EASE_OUT_SINE, length, "depth", 0, NULL);
#line 975 "ease-slide-actor.vala"
	clutter_actor_set_depth ((ClutterActor*) reflection, EASE_SLIDE_ACTOR_OPEN_DEPTH);
#line 976 "ease-slide-actor.vala"
	clutter_actor_animate ((ClutterActor*) reflection, (gulong) CLUTTER_EASE_OUT_SINE, length, "depth", 0, NULL);
#line 978 "ease-slide-actor.vala"
	clutter_container_add_actor ((ClutterContainer*) _data10_->container, (ClutterActor*) reflection);
#line 980 "ease-slide-actor.vala"
	clutter_actor_animate ((ClutterActor*) self, (gulong) CLUTTER_LINEAR, length, "opacity", 0, NULL);
#line 981 "ease-slide-actor.vala"
	clutter_actor_reparent ((ClutterActor*) self, (ClutterActor*) _data10_->container);
#line 982 "ease-slide-actor.vala"
	clutter_actor_set_x ((ClutterActor*) self, (float) ease_slide_get_width (self->priv->_slide));
#line 2182 "ease-slide-actor.c"
	_data10_->width = ease_slide_get_width (self->priv->_slide) / 2.f;
#line 986 "ease-slide-actor.vala"
	left = g_object_ref_sink ((ClutterClone*) clutter_clone_new ((ClutterActor*) self));
#line 987 "ease-slide-actor.vala"
	right = g_object_ref_sink ((ClutterClone*) clutter_clone_new ((ClutterActor*) self));
#line 989 "ease-slide-actor.vala"
	clutter_actor_set_clip ((ClutterActor*) left, (float) 0, (float) 0, _data10_->width, (float) ease_slide_get_height (self->priv->_slide));
#line 990 "ease-slide-actor.vala"
	clutter_actor_set_clip ((ClutterActor*) right, _data10_->width, (float) 0, _data10_->width, (float) ease_slide_get_height (self->priv->_slide));
#line 993 "ease-slide-actor.vala"
	left_ref = g_object_ref_sink ((ClutterClone*) clutter_clone_new ((ClutterActor*) left));
#line 994 "ease-slide-actor.vala"
	right_ref = g_object_ref_sink ((ClutterClone*) clutter_clone_new ((ClutterActor*) right));
#line 996 "ease-slide-actor.vala"
	g_object_set ((ClutterActor*) left_ref, "rotation-angle-z", (double) 180, NULL);
#line 997 "ease-slide-actor.vala"
	g_object_set ((ClutterActor*) left_ref, "rotation-angle-y", (double) 180, NULL);
#line 998 "ease-slide-actor.vala"
	clutter_actor_set_y ((ClutterActor*) left_ref, (float) (2 * ease_slide_get_height (self->priv->_slide)));
#line 999 "ease-slide-actor.vala"
	clutter_actor_set_opacity ((ClutterActor*) left_ref, (guint) EASE_SLIDE_ACTOR_REFLECTION_OPACITY);
#line 1001 "ease-slide-actor.vala"
	g_object_set ((ClutterActor*) right_ref, "rotation-angle-z", (double) 180, NULL);
#line 1002 "ease-slide-actor.vala"
	g_object_set ((ClutterActor*) right_ref, "rotation-angle-y", (double) 180, NULL);
#line 1003 "ease-slide-actor.vala"
	clutter_actor_set_y ((ClutterActor*) right_ref, (float) (2 * ease_slide_get_height (self->priv->_slide)));
#line 1004 "ease-slide-actor.vala"
	clutter_actor_set_opacity ((ClutterActor*) right_ref, (guint) EASE_SLIDE_ACTOR_REFLECTION_OPACITY);
#line 2212 "ease-slide-actor.c"
	_data10_->left_group = g_object_ref_sink ((ClutterGroup*) clutter_group_new ());
	_data10_->right_group = g_object_ref_sink ((ClutterGroup*) clutter_group_new ());
#line 1011 "ease-slide-actor.vala"
	clutter_container_add_actor ((ClutterContainer*) _data10_->left_group, (ClutterActor*) left_ref);
#line 1012 "ease-slide-actor.vala"
	clutter_container_add_actor ((ClutterContainer*) _data10_->left_group, (ClutterActor*) left);
#line 1013 "ease-slide-actor.vala"
	clutter_container_add_actor ((ClutterContainer*) _data10_->right_group, (ClutterActor*) right_ref);
#line 1014 "ease-slide-actor.vala"
	clutter_container_add_actor ((ClutterContainer*) _data10_->right_group, (ClutterActor*) right);
#line 1017 "ease-slide-actor.vala"
	clutter_container_add_actor ((ClutterContainer*) _data10_->container, (ClutterActor*) _data10_->left_group);
#line 1018 "ease-slide-actor.vala"
	clutter_container_add_actor ((ClutterContainer*) _data10_->container, (ClutterActor*) _data10_->right_group);
#line 1021 "ease-slide-actor.vala"
	clutter_actor_animate ((ClutterActor*) _data10_->left_group, (gulong) CLUTTER_EASE_IN_OUT_SINE, length / 2, "x", clutter_actor_get_x ((ClutterActor*) left) - (_data10_->width * EASE_SLIDE_ACTOR_OPEN_MOVE), NULL);
#line 1024 "ease-slide-actor.vala"
	clutter_actor_animate ((ClutterActor*) _data10_->right_group, (gulong) CLUTTER_EASE_IN_OUT_SINE, length / 2, "x", clutter_actor_get_x ((ClutterActor*) right) + (_data10_->width * EASE_SLIDE_ACTOR_OPEN_MOVE), NULL);
#line 1028 "ease-slide-actor.vala"
	self->priv->time1 = (_tmp0_ = clutter_timeline_new ((guint) ((gint) (EASE_SLIDE_ACTOR_OPEN_TIME * length))), _g_object_unref0 (self->priv->time1), _tmp0_);
#line 1029 "ease-slide-actor.vala"
	self->priv->time2 = (_tmp1_ = clutter_timeline_new (length), _g_object_unref0 (self->priv->time2), _tmp1_);
#line 1030 "ease-slide-actor.vala"
	ease_slide_actor_set_animation_alpha (self, _tmp2_ = g_object_ref_sink (clutter_alpha_new_full (self->priv->time1, (gulong) CLUTTER_EASE_IN_SINE)));
#line 2237 "ease-slide-actor.c"
	_g_object_unref0 (_tmp2_);
#line 1033 "ease-slide-actor.vala"
	g_signal_connect_data (self->priv->time1, "new-frame", (GCallback) __lambda10__clutter_timeline_new_frame, block10_data_ref (_data10_), (GClosureNotify) block10_data_unref, 0);
#line 1044 "ease-slide-actor.vala"
	g_signal_connect_data (self->priv->time1, "completed", (GCallback) __lambda11__clutter_timeline_completed, block10_data_ref (_data10_), (GClosureNotify) block10_data_unref, 0);
#line 1049 "ease-slide-actor.vala"
	clutter_timeline_start (self->priv->time1);
#line 1050 "ease-slide-actor.vala"
	clutter_timeline_start (self->priv->time2);
#line 2247 "ease-slide-actor.c"
	_g_object_unref0 (right_ref);
	_g_object_unref0 (left_ref);
	_g_object_unref0 (right);
	_g_object_unref0 (left);
	_g_object_unref0 (reflection);
	block10_data_unref (_data10_);
}


/**
 * Starts a "zoom" transition.
 *
 * @param new_slide The new SlideActor.
 * @param container The container that holds the displayed SlideActors.
 * @param length The length of the transition, in milliseconds.
 */
#line 1100 "ease-slide-actor.vala"
static void _lambda26_ (gint m, Block11Data* _data11_) {
#line 2266 "ease-slide-actor.c"
	EaseSlideActor * self;
	self = _data11_->self;
#line 1101 "ease-slide-actor.vala"
	clutter_actor_set_scale ((ClutterActor*) _data11_->new_slide, clutter_alpha_get_alpha (self->priv->_animation_alpha), clutter_alpha_get_alpha (self->priv->_animation_alpha));
#line 2271 "ease-slide-actor.c"
}


#line 1100 "ease-slide-actor.vala"
static void __lambda26__clutter_timeline_new_frame (ClutterTimeline* _sender, gint frame_num, gpointer self) {
#line 2277 "ease-slide-actor.c"
	_lambda26_ (frame_num, self);
}


static Block11Data* block11_data_ref (Block11Data* _data11_) {
	g_atomic_int_inc (&_data11_->_ref_count_);
	return _data11_;
}


static void block11_data_unref (Block11Data* _data11_) {
	if (g_atomic_int_dec_and_test (&_data11_->_ref_count_)) {
		_g_object_unref0 (_data11_->self);
		_g_object_unref0 (_data11_->new_slide);
		g_slice_free (Block11Data, _data11_);
	}
}


#line 1060 "ease-slide-actor.vala"
static void ease_slide_actor_zoom_transition (EaseSlideActor* self, EaseSlideActor* new_slide, ClutterGroup* container, guint length) {
#line 2299 "ease-slide-actor.c"
	Block11Data* _data11_;
	ClutterAlpha* _tmp0_;
#line 1060 "ease-slide-actor.vala"
	g_return_if_fail (self != NULL);
#line 1060 "ease-slide-actor.vala"
	g_return_if_fail (new_slide != NULL);
#line 1060 "ease-slide-actor.vala"
	g_return_if_fail (container != NULL);
#line 2308 "ease-slide-actor.c"
	_data11_ = g_slice_new0 (Block11Data);
	_data11_->_ref_count_ = 1;
	_data11_->self = g_object_ref (self);
	_data11_->new_slide = _g_object_ref0 (new_slide);
#line 1063 "ease-slide-actor.vala"
	switch (ease_slide_get_variant (self->priv->_slide)) {
#line 2315 "ease-slide-actor.c"
		case EASE_TRANSITION_VARIANT_CENTER:
		{
#line 1066 "ease-slide-actor.vala"
			clutter_actor_set_scale_full ((ClutterActor*) _data11_->new_slide, (double) 0, (double) 0, (float) (ease_slide_get_width (self->priv->_slide) / 2), (float) (ease_slide_get_height (self->priv->_slide) / 2));
#line 1069 "ease-slide-actor.vala"
			break;
#line 2322 "ease-slide-actor.c"
		}
		case EASE_TRANSITION_VARIANT_TOP_LEFT:
		{
#line 1071 "ease-slide-actor.vala"
			clutter_actor_set_scale_full ((ClutterActor*) _data11_->new_slide, (double) 0, (double) 0, (float) 0, (float) 0);
#line 1072 "ease-slide-actor.vala"
			break;
#line 2330 "ease-slide-actor.c"
		}
		case EASE_TRANSITION_VARIANT_TOP_RIGHT:
		{
#line 1074 "ease-slide-actor.vala"
			clutter_actor_set_scale_full ((ClutterActor*) _data11_->new_slide, (double) 0, (double) 0, (float) ease_slide_get_width (self->priv->_slide), (float) 0);
#line 1075 "ease-slide-actor.vala"
			break;
#line 2338 "ease-slide-actor.c"
		}
		case EASE_TRANSITION_VARIANT_BOTTOM_LEFT:
		{
#line 1077 "ease-slide-actor.vala"
			clutter_actor_set_scale_full ((ClutterActor*) _data11_->new_slide, (double) 0, (double) 0, (float) 0, (float) ease_slide_get_height (self->priv->_slide));
#line 1078 "ease-slide-actor.vala"
			break;
#line 2346 "ease-slide-actor.c"
		}
		case EASE_TRANSITION_VARIANT_BOTTOM_RIGHT:
		{
#line 1080 "ease-slide-actor.vala"
			clutter_actor_set_scale_full ((ClutterActor*) _data11_->new_slide, (double) 0, (double) 0, (float) ease_slide_get_width (self->priv->_slide), (float) ease_slide_get_height (self->priv->_slide));
#line 1083 "ease-slide-actor.vala"
			break;
#line 2354 "ease-slide-actor.c"
		}
		case EASE_TRANSITION_VARIANT_LEFT:
		{
#line 1085 "ease-slide-actor.vala"
			clutter_actor_set_scale_full ((ClutterActor*) _data11_->new_slide, (double) 0, (double) 0, (float) 0, (float) (ease_slide_get_height (self->priv->_slide) / 2));
#line 1086 "ease-slide-actor.vala"
			break;
#line 2362 "ease-slide-actor.c"
		}
		case EASE_TRANSITION_VARIANT_RIGHT:
		{
#line 1088 "ease-slide-actor.vala"
			clutter_actor_set_scale_full ((ClutterActor*) _data11_->new_slide, (double) 0, (double) 0, (float) ease_slide_get_width (self->priv->_slide), (float) (ease_slide_get_height (self->priv->_slide) / 2));
#line 1089 "ease-slide-actor.vala"
			break;
#line 2370 "ease-slide-actor.c"
		}
		case EASE_TRANSITION_VARIANT_TOP:
		{
#line 1091 "ease-slide-actor.vala"
			clutter_actor_set_scale_full ((ClutterActor*) _data11_->new_slide, (double) 0, (double) 0, (float) (ease_slide_get_width (self->priv->_slide) / 2), (float) 0);
#line 1092 "ease-slide-actor.vala"
			break;
#line 2378 "ease-slide-actor.c"
		}
		case EASE_TRANSITION_VARIANT_BOTTOM:
		{
#line 1094 "ease-slide-actor.vala"
			clutter_actor_set_scale_full ((ClutterActor*) _data11_->new_slide, (double) 0, (double) 0, (float) (ease_slide_get_width (self->priv->_slide) / 2), (float) ease_slide_get_height (self->priv->_slide));
#line 1095 "ease-slide-actor.vala"
			break;
#line 2386 "ease-slide-actor.c"
		}
	}
#line 1097 "ease-slide-actor.vala"
	ease_slide_actor_set_animation_alpha (self, _tmp0_ = g_object_ref_sink (clutter_alpha_new_full (self->priv->_animation_time, (gulong) CLUTTER_EASE_OUT_SINE)));
#line 2391 "ease-slide-actor.c"
	_g_object_unref0 (_tmp0_);
#line 1100 "ease-slide-actor.vala"
	g_signal_connect_data (self->priv->_animation_time, "new-frame", (GCallback) __lambda26__clutter_timeline_new_frame, block11_data_ref (_data11_), (GClosureNotify) block11_data_unref, 0);
#line 2395 "ease-slide-actor.c"
	block11_data_unref (_data11_);
}


/**
 * Starts a "panel" transition.
 *
 * @param new_slide The new SlideActor.
 * @param container The container that holds the displayed SlideActors.
 * @param length The length of the transition, in milliseconds.
 */
#line 1148 "ease-slide-actor.vala"
static void _lambda29_ (gint m, EaseSlideActor* self) {
#line 1149 "ease-slide-actor.vala"
	clutter_actor_set_scale_full ((ClutterActor*) self, EASE_SLIDE_ACTOR_PANEL_SCALE + ((1 - EASE_SLIDE_ACTOR_PANEL_SCALE) * (1 - clutter_alpha_get_alpha (self->priv->alpha1))), EASE_SLIDE_ACTOR_PANEL_SCALE + ((1 - EASE_SLIDE_ACTOR_PANEL_SCALE) * (1 - clutter_alpha_get_alpha (self->priv->alpha1))), (float) (ease_slide_get_width (self->priv->_slide) / 2), (float) (ease_slide_get_height (self->priv->_slide) / 2));
#line 2411 "ease-slide-actor.c"
}


#line 1148 "ease-slide-actor.vala"
static void __lambda29__clutter_timeline_new_frame (ClutterTimeline* _sender, gint frame_num, gpointer self) {
#line 2417 "ease-slide-actor.c"
	_lambda29_ (frame_num, self);
}


#line 1155 "ease-slide-actor.vala"
static void _lambda30_ (Block12Data* _data12_) {
#line 2424 "ease-slide-actor.c"
	EaseSlideActor * self;
	self = _data12_->self;
#line 1156 "ease-slide-actor.vala"
	clutter_actor_animate ((ClutterActor*) self, (gulong) CLUTTER_EASE_IN_OUT_SINE, _data12_->length / 2, _data12_->property, -_data12_->pos, NULL);
#line 1159 "ease-slide-actor.vala"
	clutter_actor_animate ((ClutterActor*) _data12_->new_slide, (gulong) CLUTTER_EASE_IN_OUT_SINE, _data12_->length / 2, _data12_->property, 0.0f, NULL);
#line 2431 "ease-slide-actor.c"
}


#line 1155 "ease-slide-actor.vala"
static void __lambda30__clutter_timeline_completed (ClutterTimeline* _sender, gpointer self) {
#line 2437 "ease-slide-actor.c"
	_lambda30_ (self);
}


#line 1163 "ease-slide-actor.vala"
static void _lambda32_ (gint m, Block12Data* _data12_) {
#line 2444 "ease-slide-actor.c"
	EaseSlideActor * self;
	self = _data12_->self;
#line 1164 "ease-slide-actor.vala"
	clutter_actor_set_scale_full ((ClutterActor*) _data12_->new_slide, EASE_SLIDE_ACTOR_PANEL_SCALE + ((1 - EASE_SLIDE_ACTOR_PANEL_SCALE) * clutter_alpha_get_alpha (self->priv->alpha1)), EASE_SLIDE_ACTOR_PANEL_SCALE + ((1 - EASE_SLIDE_ACTOR_PANEL_SCALE) * clutter_alpha_get_alpha (self->priv->alpha1)), (float) (ease_slide_get_width (self->priv->_slide) / 2), (float) (ease_slide_get_height (self->priv->_slide) / 2));
#line 2449 "ease-slide-actor.c"
}


#line 1163 "ease-slide-actor.vala"
static void __lambda32__clutter_timeline_new_frame (ClutterTimeline* _sender, gint frame_num, gpointer self) {
#line 2455 "ease-slide-actor.c"
	_lambda32_ (frame_num, self);
}


#line 1162 "ease-slide-actor.vala"
static void _lambda31_ (Block12Data* _data12_) {
#line 2462 "ease-slide-actor.c"
	EaseSlideActor * self;
	self = _data12_->self;
#line 1163 "ease-slide-actor.vala"
	g_signal_connect_data (self->priv->time1, "new-frame", (GCallback) __lambda32__clutter_timeline_new_frame, block12_data_ref (_data12_), (GClosureNotify) block12_data_unref, 0);
#line 1171 "ease-slide-actor.vala"
	clutter_timeline_start (self->priv->time1);
#line 2469 "ease-slide-actor.c"
}


#line 1162 "ease-slide-actor.vala"
static void __lambda31__clutter_timeline_completed (ClutterTimeline* _sender, gpointer self) {
#line 2475 "ease-slide-actor.c"
	_lambda31_ (self);
}


static Block12Data* block12_data_ref (Block12Data* _data12_) {
	g_atomic_int_inc (&_data12_->_ref_count_);
	return _data12_;
}


static void block12_data_unref (Block12Data* _data12_) {
	if (g_atomic_int_dec_and_test (&_data12_->_ref_count_)) {
		_g_object_unref0 (_data12_->self);
		_g_free0 (_data12_->property);
		_g_object_unref0 (_data12_->new_slide);
		g_slice_free (Block12Data, _data12_);
	}
}


#line 1112 "ease-slide-actor.vala"
static void ease_slide_actor_panel_transition (EaseSlideActor* self, EaseSlideActor* new_slide, ClutterGroup* container, guint length) {
#line 2498 "ease-slide-actor.c"
	Block12Data* _data12_;
	ClutterTimeline* _tmp4_;
	ClutterTimeline* _tmp5_;
	GValue _tmp6_ = {0};
	GValue _tmp7_;
	ClutterAlpha* _tmp8_;
#line 1112 "ease-slide-actor.vala"
	g_return_if_fail (self != NULL);
#line 1112 "ease-slide-actor.vala"
	g_return_if_fail (new_slide != NULL);
#line 1112 "ease-slide-actor.vala"
	g_return_if_fail (container != NULL);
#line 2511 "ease-slide-actor.c"
	_data12_ = g_slice_new0 (Block12Data);
	_data12_->_ref_count_ = 1;
	_data12_->self = g_object_ref (self);
	_data12_->new_slide = _g_object_ref0 (new_slide);
	_data12_->length = length;
	_data12_->pos = (float) 0;
	_data12_->property = g_strdup ("");
#line 1118 "ease-slide-actor.vala"
	switch (ease_slide_get_variant (self->priv->_slide)) {
#line 2521 "ease-slide-actor.c"
		case EASE_TRANSITION_VARIANT_UP:
		{
			char* _tmp0_;
#line 1121 "ease-slide-actor.vala"
			_data12_->pos = (float) ease_slide_get_height (self->priv->_slide);
#line 1122 "ease-slide-actor.vala"
			_data12_->property = (_tmp0_ = g_strdup ("y"), _g_free0 (_data12_->property), _tmp0_);
#line 1123 "ease-slide-actor.vala"
			break;
#line 2531 "ease-slide-actor.c"
		}
		case EASE_TRANSITION_VARIANT_DOWN:
		{
			char* _tmp1_;
#line 1125 "ease-slide-actor.vala"
			_data12_->pos = (float) (-ease_slide_get_height (self->priv->_slide));
#line 1126 "ease-slide-actor.vala"
			_data12_->property = (_tmp1_ = g_strdup ("y"), _g_free0 (_data12_->property), _tmp1_);
#line 1127 "ease-slide-actor.vala"
			break;
#line 2542 "ease-slide-actor.c"
		}
		case EASE_TRANSITION_VARIANT_LEFT:
		{
			char* _tmp2_;
#line 1129 "ease-slide-actor.vala"
			_data12_->pos = (float) ease_slide_get_width (self->priv->_slide);
#line 1130 "ease-slide-actor.vala"
			_data12_->property = (_tmp2_ = g_strdup ("x"), _g_free0 (_data12_->property), _tmp2_);
#line 1131 "ease-slide-actor.vala"
			break;
#line 2553 "ease-slide-actor.c"
		}
		default:
		{
			char* _tmp3_;
#line 1133 "ease-slide-actor.vala"
			_data12_->pos = (float) (-ease_slide_get_width (self->priv->_slide));
#line 1134 "ease-slide-actor.vala"
			_data12_->property = (_tmp3_ = g_strdup ("x"), _g_free0 (_data12_->property), _tmp3_);
#line 1135 "ease-slide-actor.vala"
			break;
#line 2564 "ease-slide-actor.c"
		}
	}
#line 1138 "ease-slide-actor.vala"
	self->priv->time1 = (_tmp4_ = clutter_timeline_new (_data12_->length / 4), _g_object_unref0 (self->priv->time1), _tmp4_);
#line 1139 "ease-slide-actor.vala"
	self->priv->time2 = (_tmp5_ = clutter_timeline_new ((3 * _data12_->length) / 4), _g_object_unref0 (self->priv->time2), _tmp5_);
#line 1140 "ease-slide-actor.vala"
	clutter_actor_set_scale_full ((ClutterActor*) _data12_->new_slide, (double) EASE_SLIDE_ACTOR_PANEL_SCALE, (double) EASE_SLIDE_ACTOR_PANEL_SCALE, (float) (ease_slide_get_width (self->priv->_slide) / 2), (float) (ease_slide_get_height (self->priv->_slide) / 2));
#line 1144 "ease-slide-actor.vala"
	g_object_set_property ((GObject*) _data12_->new_slide, _data12_->property, (_tmp7_ = (g_value_init (&_tmp6_, G_TYPE_FLOAT), g_value_set_float (&_tmp6_, _data12_->pos), _tmp6_), &_tmp7_));
#line 2575 "ease-slide-actor.c"
	G_IS_VALUE (&_tmp6_) ? (g_value_unset (&_tmp6_), NULL) : NULL;
#line 1145 "ease-slide-actor.vala"
	self->priv->alpha1 = (_tmp8_ = g_object_ref_sink (clutter_alpha_new_full (self->priv->time1, (gulong) CLUTTER_EASE_IN_OUT_SINE)), _g_object_unref0 (self->priv->alpha1), _tmp8_);
#line 1148 "ease-slide-actor.vala"
	g_signal_connect_object (self->priv->time1, "new-frame", (GCallback) __lambda29__clutter_timeline_new_frame, self, 0);
#line 1155 "ease-slide-actor.vala"
	g_signal_connect_data (self->priv->time1, "completed", (GCallback) __lambda30__clutter_timeline_completed, block12_data_ref (_data12_), (GClosureNotify) block12_data_unref, 0);
#line 1162 "ease-slide-actor.vala"
	g_signal_connect_data (self->priv->time2, "completed", (GCallback) __lambda31__clutter_timeline_completed, block12_data_ref (_data12_), (GClosureNotify) block12_data_unref, 0);
#line 1173 "ease-slide-actor.vala"
	clutter_timeline_start (self->priv->time1);
#line 1174 "ease-slide-actor.vala"
	clutter_timeline_start (self->priv->time2);
#line 2589 "ease-slide-actor.c"
	block12_data_unref (_data12_);
}


/**
 * Starts a "spin contents" transition. This transition unstacks the
 * SlideActors.
 *
 * @param new_slide The new SlideActor.
 * @param container The container that holds the displayed SlideActors.
 * @param length The length of the transition, in milliseconds.
 */
#line 1203 "ease-slide-actor.vala"
static void _lambda19_ (EaseSlideActor* self) {
#line 1204 "ease-slide-actor.vala"
	clutter_actor_set_opacity ((ClutterActor*) self->contents, (guint) 0);
#line 1205 "ease-slide-actor.vala"
	clutter_timeline_start (self->priv->time2);
#line 2608 "ease-slide-actor.c"
}


#line 1203 "ease-slide-actor.vala"
static void __lambda19__clutter_timeline_completed (ClutterTimeline* _sender, gpointer self) {
#line 2614 "ease-slide-actor.c"
	_lambda19_ (self);
}


#line 1207 "ease-slide-actor.vala"
static void _lambda20_ (gint m, Block13Data* _data13_) {
#line 2621 "ease-slide-actor.c"
	EaseSlideActor * self;
	self = _data13_->self;
#line 1208 "ease-slide-actor.vala"
	clutter_actor_set_rotation ((ClutterActor*) self->contents, CLUTTER_Y_AXIS, _data13_->angle * clutter_alpha_get_alpha (self->priv->alpha1), (float) (ease_slide_get_width (self->priv->_slide) / 2), (float) 0, (float) 0);
#line 2626 "ease-slide-actor.c"
}


#line 1207 "ease-slide-actor.vala"
static void __lambda20__clutter_timeline_new_frame (ClutterTimeline* _sender, gint frame_num, gpointer self) {
#line 2632 "ease-slide-actor.c"
	_lambda20_ (frame_num, self);
}


#line 1212 "ease-slide-actor.vala"
static void _lambda21_ (gint m, Block13Data* _data13_) {
#line 2639 "ease-slide-actor.c"
	EaseSlideActor * self;
	self = _data13_->self;
#line 1213 "ease-slide-actor.vala"
	clutter_actor_set_opacity ((ClutterActor*) _data13_->new_slide->contents, (guint) 255);
#line 1214 "ease-slide-actor.vala"
	clutter_actor_set_rotation ((ClutterActor*) _data13_->new_slide->contents, CLUTTER_Y_AXIS, (-_data13_->angle) * (1 - clutter_alpha_get_alpha (self->priv->alpha2)), (float) (ease_slide_get_width (self->priv->_slide) / 2), (float) 0, (float) 0);
#line 2646 "ease-slide-actor.c"
}


#line 1212 "ease-slide-actor.vala"
static void __lambda21__clutter_timeline_new_frame (ClutterTimeline* _sender, gint frame_num, gpointer self) {
#line 2652 "ease-slide-actor.c"
	_lambda21_ (frame_num, self);
}


static Block13Data* block13_data_ref (Block13Data* _data13_) {
	g_atomic_int_inc (&_data13_->_ref_count_);
	return _data13_;
}


static void block13_data_unref (Block13Data* _data13_) {
	if (g_atomic_int_dec_and_test (&_data13_->_ref_count_)) {
		_g_object_unref0 (_data13_->self);
		_g_object_unref0 (_data13_->new_slide);
		g_slice_free (Block13Data, _data13_);
	}
}


#line 1185 "ease-slide-actor.vala"
static void ease_slide_actor_spin_contents_transition (EaseSlideActor* self, EaseSlideActor* new_slide, ClutterGroup* container, guint length) {
#line 2674 "ease-slide-actor.c"
	Block13Data* _data13_;
	ClutterTimeline* _tmp0_;
	ClutterTimeline* _tmp1_;
	ClutterAlpha* _tmp2_;
	ClutterAlpha* _tmp3_;
	gint _tmp4_ = 0;
#line 1185 "ease-slide-actor.vala"
	g_return_if_fail (self != NULL);
#line 1185 "ease-slide-actor.vala"
	g_return_if_fail (new_slide != NULL);
#line 1185 "ease-slide-actor.vala"
	g_return_if_fail (container != NULL);
#line 2687 "ease-slide-actor.c"
	_data13_ = g_slice_new0 (Block13Data);
	_data13_->_ref_count_ = 1;
	_data13_->self = g_object_ref (self);
	_data13_->new_slide = _g_object_ref0 (new_slide);
#line 1189 "ease-slide-actor.vala"
	ease_slide_actor_prepare_stack_transition (self, FALSE, _data13_->new_slide, container);
#line 1191 "ease-slide-actor.vala"
	clutter_actor_set_opacity ((ClutterActor*) _data13_->new_slide->contents, (guint) 0);
#line 1192 "ease-slide-actor.vala"
	clutter_actor_animate ((ClutterActor*) self->background, (gulong) CLUTTER_EASE_IN_OUT_SINE, length, "opacity", 0, NULL);
#line 1194 "ease-slide-actor.vala"
	self->priv->time1 = (_tmp0_ = clutter_timeline_new (length / 2), _g_object_unref0 (self->priv->time1), _tmp0_);
#line 1195 "ease-slide-actor.vala"
	self->priv->time2 = (_tmp1_ = clutter_timeline_new (length / 2), _g_object_unref0 (self->priv->time2), _tmp1_);
#line 1196 "ease-slide-actor.vala"
	self->priv->alpha1 = (_tmp2_ = g_object_ref_sink (clutter_alpha_new_full (self->priv->time1, (gulong) CLUTTER_EASE_IN_SINE)), _g_object_unref0 (self->priv->alpha1), _tmp2_);
#line 1199 "ease-slide-actor.vala"
	self->priv->alpha2 = (_tmp3_ = g_object_ref_sink (clutter_alpha_new_full (self->priv->time2, (gulong) CLUTTER_EASE_OUT_SINE)), _g_object_unref0 (self->priv->alpha2), _tmp3_);
#line 1202 "ease-slide-actor.vala"
	if (ease_slide_get_variant (self->priv->_slide) == EASE_TRANSITION_VARIANT_LEFT) {
#line 1202 "ease-slide-actor.vala"
		_tmp4_ = -90;
#line 2710 "ease-slide-actor.c"
	} else {
#line 1202 "ease-slide-actor.vala"
		_tmp4_ = 90;
#line 2714 "ease-slide-actor.c"
	}
	_data13_->angle = (float) _tmp4_;
#line 1203 "ease-slide-actor.vala"
	g_signal_connect_object (self->priv->time1, "completed", (GCallback) __lambda19__clutter_timeline_completed, self, 0);
#line 1207 "ease-slide-actor.vala"
	g_signal_connect_data (self->priv->time1, "new-frame", (GCallback) __lambda20__clutter_timeline_new_frame, block13_data_ref (_data13_), (GClosureNotify) block13_data_unref, 0);
#line 1212 "ease-slide-actor.vala"
	g_signal_connect_data (self->priv->time2, "new-frame", (GCallback) __lambda21__clutter_timeline_new_frame, block13_data_ref (_data13_), (GClosureNotify) block13_data_unref, 0);
#line 1218 "ease-slide-actor.vala"
	clutter_timeline_start (self->priv->time1);
#line 2725 "ease-slide-actor.c"
	block13_data_unref (_data13_);
}


/**
 * Starts a "swing contents" transition. This transition unstacks the
 * SlideActors.
 *
 * @param new_slide The new SlideActor.
 * @param container The container that holds the displayed SlideActors.
 * @param length The length of the transition, in milliseconds.
 */
#line 1248 "ease-slide-actor.vala"
static void _lambda22_ (gint m, EaseSlideActor* self) {
#line 2740 "ease-slide-actor.c"
	{
		FlutterContainerIterator* _actor_it;
#line 1249 "ease-slide-actor.vala"
		_actor_it = flutter_container_iterator ((FlutterContainer*) self->contents);
#line 1249 "ease-slide-actor.vala"
		while (TRUE) {
#line 2747 "ease-slide-actor.c"
			ClutterActor* actor;
#line 1249 "ease-slide-actor.vala"
			if (!flutter_container_iterator_next (_actor_it)) {
#line 1249 "ease-slide-actor.vala"
				break;
#line 2753 "ease-slide-actor.c"
			}
#line 1249 "ease-slide-actor.vala"
			actor = flutter_container_iterator_get (_actor_it);
#line 1251 "ease-slide-actor.vala"
			clutter_actor_set_rotation (actor, CLUTTER_X_AXIS, 270 * clutter_alpha_get_alpha (self->priv->alpha1), (float) 0, (float) 0, (float) 0);
#line 2759 "ease-slide-actor.c"
			_g_object_unref0 (actor);
		}
		_flutter_container_iterator_unref0 (_actor_it);
	}
}


#line 1248 "ease-slide-actor.vala"
static void __lambda22__clutter_timeline_new_frame (ClutterTimeline* _sender, gint frame_num, gpointer self) {
#line 2769 "ease-slide-actor.c"
	_lambda22_ (frame_num, self);
}


#line 1256 "ease-slide-actor.vala"
static void _lambda23_ (gint m, Block14Data* _data14_) {
#line 2776 "ease-slide-actor.c"
	EaseSlideActor * self;
	self = _data14_->self;
	{
		FlutterContainerIterator* _actor_it;
#line 1257 "ease-slide-actor.vala"
		_actor_it = flutter_container_iterator ((FlutterContainer*) _data14_->new_slide->contents);
#line 1257 "ease-slide-actor.vala"
		while (TRUE) {
#line 2785 "ease-slide-actor.c"
			ClutterActor* actor;
#line 1257 "ease-slide-actor.vala"
			if (!flutter_container_iterator_next (_actor_it)) {
#line 1257 "ease-slide-actor.vala"
				break;
#line 2791 "ease-slide-actor.c"
			}
#line 1257 "ease-slide-actor.vala"
			actor = flutter_container_iterator_get (_actor_it);
#line 1259 "ease-slide-actor.vala"
			clutter_actor_set_rotation (actor, CLUTTER_X_AXIS, 270 + (90 * clutter_alpha_get_alpha (self->priv->alpha2)), (float) 0, (float) 0, (float) 0);
#line 2797 "ease-slide-actor.c"
			_g_object_unref0 (actor);
		}
		_flutter_container_iterator_unref0 (_actor_it);
	}
}


#line 1256 "ease-slide-actor.vala"
static void __lambda23__clutter_timeline_new_frame (ClutterTimeline* _sender, gint frame_num, gpointer self) {
#line 2807 "ease-slide-actor.c"
	_lambda23_ (frame_num, self);
}


#line 1264 "ease-slide-actor.vala"
static void _lambda24_ (Block14Data* _data14_) {
#line 2814 "ease-slide-actor.c"
	EaseSlideActor * self;
	self = _data14_->self;
#line 1265 "ease-slide-actor.vala"
	clutter_timeline_start (self->priv->time2);
#line 1266 "ease-slide-actor.vala"
	clutter_actor_set_opacity ((ClutterActor*) _data14_->new_slide->contents, (guint) 255);
#line 1267 "ease-slide-actor.vala"
	clutter_actor_set_opacity ((ClutterActor*) self->contents, (guint) 0);
#line 2823 "ease-slide-actor.c"
	{
		FlutterContainerIterator* _actor_it;
#line 1268 "ease-slide-actor.vala"
		_actor_it = flutter_container_iterator ((FlutterContainer*) _data14_->new_slide->contents);
#line 1268 "ease-slide-actor.vala"
		while (TRUE) {
#line 2830 "ease-slide-actor.c"
			ClutterActor* actor;
#line 1268 "ease-slide-actor.vala"
			if (!flutter_container_iterator_next (_actor_it)) {
#line 1268 "ease-slide-actor.vala"
				break;
#line 2836 "ease-slide-actor.c"
			}
#line 1268 "ease-slide-actor.vala"
			actor = flutter_container_iterator_get (_actor_it);
#line 1270 "ease-slide-actor.vala"
			clutter_actor_set_rotation (actor, CLUTTER_X_AXIS, (double) 270, (float) 0, (float) 0, (float) 0);
#line 2842 "ease-slide-actor.c"
			_g_object_unref0 (actor);
		}
		_flutter_container_iterator_unref0 (_actor_it);
	}
}


#line 1264 "ease-slide-actor.vala"
static void __lambda24__clutter_timeline_completed (ClutterTimeline* _sender, gpointer self) {
#line 2852 "ease-slide-actor.c"
	_lambda24_ (self);
}


#line 1274 "ease-slide-actor.vala"
static void _lambda25_ (Block14Data* _data14_) {
#line 2859 "ease-slide-actor.c"
	EaseSlideActor * self;
	self = _data14_->self;
	{
		FlutterContainerIterator* _actor_it;
#line 1275 "ease-slide-actor.vala"
		_actor_it = flutter_container_iterator ((FlutterContainer*) _data14_->new_slide->contents);
#line 1275 "ease-slide-actor.vala"
		while (TRUE) {
#line 2868 "ease-slide-actor.c"
			ClutterActor* actor;
#line 1275 "ease-slide-actor.vala"
			if (!flutter_container_iterator_next (_actor_it)) {
#line 1275 "ease-slide-actor.vala"
				break;
#line 2874 "ease-slide-actor.c"
			}
#line 1275 "ease-slide-actor.vala"
			actor = flutter_container_iterator_get (_actor_it);
#line 1277 "ease-slide-actor.vala"
			clutter_actor_set_rotation (actor, CLUTTER_X_AXIS, (double) 0, (float) 0, (float) 0, (float) 0);
#line 2880 "ease-slide-actor.c"
			_g_object_unref0 (actor);
		}
		_flutter_container_iterator_unref0 (_actor_it);
	}
}


#line 1274 "ease-slide-actor.vala"
static void __lambda25__clutter_timeline_completed (ClutterTimeline* _sender, gpointer self) {
#line 2890 "ease-slide-actor.c"
	_lambda25_ (self);
}


static Block14Data* block14_data_ref (Block14Data* _data14_) {
	g_atomic_int_inc (&_data14_->_ref_count_);
	return _data14_;
}


static void block14_data_unref (Block14Data* _data14_) {
	if (g_atomic_int_dec_and_test (&_data14_->_ref_count_)) {
		_g_object_unref0 (_data14_->self);
		_g_object_unref0 (_data14_->new_slide);
		g_slice_free (Block14Data, _data14_);
	}
}


#line 1229 "ease-slide-actor.vala"
static void ease_slide_actor_swing_contents_transition (EaseSlideActor* self, EaseSlideActor* new_slide, ClutterGroup* container, guint length) {
#line 2912 "ease-slide-actor.c"
	Block14Data* _data14_;
	ClutterTimeline* _tmp0_;
	ClutterTimeline* _tmp1_;
	ClutterAlpha* _tmp2_;
	ClutterAlpha* _tmp3_;
#line 1229 "ease-slide-actor.vala"
	g_return_if_fail (self != NULL);
#line 1229 "ease-slide-actor.vala"
	g_return_if_fail (new_slide != NULL);
#line 1229 "ease-slide-actor.vala"
	g_return_if_fail (container != NULL);
#line 2924 "ease-slide-actor.c"
	_data14_ = g_slice_new0 (Block14Data);
	_data14_->_ref_count_ = 1;
	_data14_->self = g_object_ref (self);
	_data14_->new_slide = _g_object_ref0 (new_slide);
#line 1233 "ease-slide-actor.vala"
	ease_slide_actor_prepare_stack_transition (self, FALSE, _data14_->new_slide, container);
#line 1235 "ease-slide-actor.vala"
	clutter_actor_set_opacity ((ClutterActor*) _data14_->new_slide->contents, (guint) 0);
#line 1236 "ease-slide-actor.vala"
	clutter_actor_animate ((ClutterActor*) self->background, (gulong) CLUTTER_EASE_IN_OUT_SINE, length, "opacity", 0, NULL);
#line 1239 "ease-slide-actor.vala"
	self->priv->time1 = (_tmp0_ = clutter_timeline_new ((3 * length) / 5), _g_object_unref0 (self->priv->time1), _tmp0_);
#line 1240 "ease-slide-actor.vala"
	self->priv->time2 = (_tmp1_ = clutter_timeline_new ((2 * length) / 5), _g_object_unref0 (self->priv->time2), _tmp1_);
#line 1242 "ease-slide-actor.vala"
	self->priv->alpha1 = (_tmp2_ = g_object_ref_sink (clutter_alpha_new_full (self->priv->time1, (gulong) CLUTTER_EASE_IN_SINE)), _g_object_unref0 (self->priv->alpha1), _tmp2_);
#line 1245 "ease-slide-actor.vala"
	self->priv->alpha2 = (_tmp3_ = g_object_ref_sink (clutter_alpha_new_full (self->priv->time2, (gulong) CLUTTER_EASE_OUT_BACK)), _g_object_unref0 (self->priv->alpha2), _tmp3_);
#line 1248 "ease-slide-actor.vala"
	g_signal_connect_object (self->priv->time1, "new-frame", (GCallback) __lambda22__clutter_timeline_new_frame, self, 0);
#line 1256 "ease-slide-actor.vala"
	g_signal_connect_data (self->priv->time2, "new-frame", (GCallback) __lambda23__clutter_timeline_new_frame, block14_data_ref (_data14_), (GClosureNotify) block14_data_unref, 0);
#line 1264 "ease-slide-actor.vala"
	g_signal_connect_data (self->priv->time1, "completed", (GCallback) __lambda24__clutter_timeline_completed, block14_data_ref (_data14_), (GClosureNotify) block14_data_unref, 0);
#line 1274 "ease-slide-actor.vala"
	g_signal_connect_data (self->priv->time2, "completed", (GCallback) __lambda25__clutter_timeline_completed, block14_data_ref (_data14_), (GClosureNotify) block14_data_unref, 0);
#line 1281 "ease-slide-actor.vala"
	clutter_timeline_start (self->priv->time1);
#line 2953 "ease-slide-actor.c"
	block14_data_unref (_data14_);
}


/**
 * Starts a "slide contents" transition. This transition unstacks the
 * SlideActors.
 *
 * @param new_slide The new SlideActor.
 * @param container The container that holds the displayed SlideActors.
 * @param length The length of the transition, in milliseconds.
 */
#line 1292 "ease-slide-actor.vala"
static void ease_slide_actor_slide_contents_transition (EaseSlideActor* self, EaseSlideActor* new_slide, ClutterGroup* container, guint length) {
#line 1292 "ease-slide-actor.vala"
	g_return_if_fail (self != NULL);
#line 1292 "ease-slide-actor.vala"
	g_return_if_fail (new_slide != NULL);
#line 1292 "ease-slide-actor.vala"
	g_return_if_fail (container != NULL);
#line 1296 "ease-slide-actor.vala"
	ease_slide_actor_prepare_stack_transition (self, FALSE, new_slide, container);
#line 1298 "ease-slide-actor.vala"
	clutter_actor_animate ((ClutterActor*) self->background, (gulong) EASE_SLIDE_ACTOR_EASE_SLIDE, length, "opacity", 0, NULL);
#line 1300 "ease-slide-actor.vala"
	switch (ease_slide_get_variant (self->priv->_slide)) {
#line 2980 "ease-slide-actor.c"
		case EASE_TRANSITION_VARIANT_RIGHT:
		{
#line 1303 "ease-slide-actor.vala"
			clutter_actor_set_x ((ClutterActor*) new_slide->contents, (float) (-ease_slide_get_width (self->priv->_slide)));
#line 1304 "ease-slide-actor.vala"
			clutter_actor_animate ((ClutterActor*) new_slide->contents, (gulong) EASE_SLIDE_ACTOR_EASE_SLIDE, length, "x", 0, NULL);
#line 1306 "ease-slide-actor.vala"
			clutter_actor_animate ((ClutterActor*) self->contents, (gulong) EASE_SLIDE_ACTOR_EASE_SLIDE, length, "x", -clutter_actor_get_x ((ClutterActor*) new_slide->contents), NULL);
#line 1308 "ease-slide-actor.vala"
			break;
#line 2991 "ease-slide-actor.c"
		}
		case EASE_TRANSITION_VARIANT_LEFT:
		{
#line 1310 "ease-slide-actor.vala"
			clutter_actor_set_x ((ClutterActor*) new_slide->contents, (float) ease_slide_get_width (self->priv->_slide));
#line 1311 "ease-slide-actor.vala"
			clutter_actor_animate ((ClutterActor*) new_slide->contents, (gulong) EASE_SLIDE_ACTOR_EASE_SLIDE, length, "x", 0, NULL);
#line 1313 "ease-slide-actor.vala"
			clutter_actor_animate ((ClutterActor*) self->contents, (gulong) EASE_SLIDE_ACTOR_EASE_SLIDE, length, "x", -clutter_actor_get_x ((ClutterActor*) new_slide->contents), NULL);
#line 1315 "ease-slide-actor.vala"
			break;
#line 3003 "ease-slide-actor.c"
		}
		case EASE_TRANSITION_VARIANT_UP:
		{
#line 1317 "ease-slide-actor.vala"
			clutter_actor_set_y ((ClutterActor*) new_slide->contents, (float) ease_slide_get_height (self->priv->_slide));
#line 1318 "ease-slide-actor.vala"
			clutter_actor_animate ((ClutterActor*) new_slide->contents, (gulong) EASE_SLIDE_ACTOR_EASE_SLIDE, length, "y", 0, NULL);
#line 1320 "ease-slide-actor.vala"
			clutter_actor_animate ((ClutterActor*) self->contents, (gulong) EASE_SLIDE_ACTOR_EASE_SLIDE, length, "y", -clutter_actor_get_y ((ClutterActor*) new_slide->contents), NULL);
#line 1322 "ease-slide-actor.vala"
			break;
#line 3015 "ease-slide-actor.c"
		}
		case EASE_TRANSITION_VARIANT_DOWN:
		{
#line 1324 "ease-slide-actor.vala"
			clutter_actor_set_y ((ClutterActor*) new_slide->contents, (float) (-ease_slide_get_height (self->priv->_slide)));
#line 1325 "ease-slide-actor.vala"
			clutter_actor_animate ((ClutterActor*) new_slide->contents, (gulong) EASE_SLIDE_ACTOR_EASE_SLIDE, length, "y", 0, NULL);
#line 1327 "ease-slide-actor.vala"
			clutter_actor_animate ((ClutterActor*) self->contents, (gulong) EASE_SLIDE_ACTOR_EASE_SLIDE, length, "y", -clutter_actor_get_y ((ClutterActor*) new_slide->contents), NULL);
#line 1329 "ease-slide-actor.vala"
			break;
#line 3027 "ease-slide-actor.c"
		}
	}
}


/**
 * Starts a "spring contents" transition. This transition unstacks the
 * SlideActors.
 *
 * @param new_slide The new SlideActor.
 * @param container The container that holds the displayed SlideActors.
 * @param length The length of the transition, in milliseconds.
 */
#line 1341 "ease-slide-actor.vala"
static void ease_slide_actor_spring_contents_transition (EaseSlideActor* self, EaseSlideActor* new_slide, ClutterGroup* container, guint length) {
#line 1341 "ease-slide-actor.vala"
	g_return_if_fail (self != NULL);
#line 1341 "ease-slide-actor.vala"
	g_return_if_fail (new_slide != NULL);
#line 1341 "ease-slide-actor.vala"
	g_return_if_fail (container != NULL);
#line 1345 "ease-slide-actor.vala"
	ease_slide_actor_prepare_stack_transition (self, FALSE, new_slide, container);
#line 1347 "ease-slide-actor.vala"
	clutter_actor_animate ((ClutterActor*) self->background, (gulong) CLUTTER_EASE_IN_OUT_SINE, length, "opacity", 0, NULL);
#line 1350 "ease-slide-actor.vala"
	switch (ease_slide_get_variant (self->priv->_slide)) {
#line 3055 "ease-slide-actor.c"
		case EASE_TRANSITION_VARIANT_UP:
		{
#line 1353 "ease-slide-actor.vala"
			clutter_actor_set_y ((ClutterActor*) new_slide->contents, ease_slide_get_height (self->priv->_slide) * 1.2f);
#line 1354 "ease-slide-actor.vala"
			clutter_actor_animate ((ClutterActor*) new_slide->contents, (gulong) CLUTTER_EASE_IN_OUT_ELASTIC, length, "y", 0, NULL);
#line 1356 "ease-slide-actor.vala"
			clutter_actor_animate ((ClutterActor*) self->contents, (gulong) CLUTTER_EASE_IN_OUT_ELASTIC, length, "y", (-ease_slide_get_height (self->priv->_slide)) * 1.2, NULL);
#line 1358 "ease-slide-actor.vala"
			break;
#line 3066 "ease-slide-actor.c"
		}
		case EASE_TRANSITION_VARIANT_DOWN:
		{
#line 1360 "ease-slide-actor.vala"
			clutter_actor_set_y ((ClutterActor*) new_slide->contents, (-ease_slide_get_height (self->priv->_slide)) * 1.2f);
#line 1361 "ease-slide-actor.vala"
			clutter_actor_animate ((ClutterActor*) new_slide->contents, (gulong) CLUTTER_EASE_IN_OUT_ELASTIC, length, "y", 0, NULL);
#line 1363 "ease-slide-actor.vala"
			clutter_actor_animate ((ClutterActor*) self->contents, (gulong) CLUTTER_EASE_IN_OUT_ELASTIC, length, "y", ease_slide_get_height (self->priv->_slide) * 1.2, NULL);
#line 1365 "ease-slide-actor.vala"
			break;
#line 3078 "ease-slide-actor.c"
		}
	}
}


/**
 * Starts a "intersperse contents" transition. This transition unstacks the
 * SlideActors.
 *
 * @param new_slide The new SlideActor.
 * @param container The container that holds the displayed SlideActors.
 * @param length The length of the transition, in milliseconds.
 */
#line 1377 "ease-slide-actor.vala"
static void ease_slide_actor_intersperse_contents_transition (EaseSlideActor* self, EaseSlideActor* new_slide, ClutterGroup* container, guint length) {
#line 3094 "ease-slide-actor.c"
	ClutterAlpha* _tmp0_;
	ClutterAlpha* _tmp1_;
	ClutterAlpha* _tmp2_;
	float target_x;
	float target_y;
	float orig_x = 0.0F;
	float orig_y = 0.0F;
#line 1377 "ease-slide-actor.vala"
	g_return_if_fail (self != NULL);
#line 1377 "ease-slide-actor.vala"
	g_return_if_fail (new_slide != NULL);
#line 1377 "ease-slide-actor.vala"
	g_return_if_fail (container != NULL);
#line 1381 "ease-slide-actor.vala"
	ease_slide_actor_prepare_stack_transition (self, FALSE, new_slide, container);
#line 1382 "ease-slide-actor.vala"
	clutter_actor_animate ((ClutterActor*) self->background, (gulong) CLUTTER_EASE_IN_OUT_SINE, length, "opacity", 0, NULL);
#line 1384 "ease-slide-actor.vala"
	self->priv->alpha1 = (_tmp0_ = g_object_ref_sink (clutter_alpha_new_full (self->priv->_animation_time, (gulong) CLUTTER_EASE_IN_SINE)), _g_object_unref0 (self->priv->alpha1), _tmp0_);
#line 1387 "ease-slide-actor.vala"
	self->priv->alpha2 = (_tmp1_ = g_object_ref_sink (clutter_alpha_new_full (self->priv->_animation_time, (gulong) CLUTTER_EASE_OUT_SINE)), _g_object_unref0 (self->priv->alpha2), _tmp1_);
#line 1390 "ease-slide-actor.vala"
	ease_slide_actor_set_animation_alpha (self, _tmp2_ = g_object_ref_sink (clutter_alpha_new_full (self->priv->_animation_time, (gulong) CLUTTER_LINEAR)));
#line 3118 "ease-slide-actor.c"
	_g_object_unref0 (_tmp2_);
#line 1393 "ease-slide-actor.vala"
	target_x = (float) 0;
#line 1393 "ease-slide-actor.vala"
	target_y = (float) 0;
#line 3124 "ease-slide-actor.c"
	{
		FlutterContainerIterator* _actor_it;
#line 1395 "ease-slide-actor.vala"
		_actor_it = flutter_container_iterator ((FlutterContainer*) self->contents);
#line 1395 "ease-slide-actor.vala"
		while (TRUE) {
#line 3131 "ease-slide-actor.c"
			ClutterActor* actor;
#line 1395 "ease-slide-actor.vala"
			if (!flutter_container_iterator_next (_actor_it)) {
#line 1395 "ease-slide-actor.vala"
				break;
#line 3137 "ease-slide-actor.c"
			}
#line 1395 "ease-slide-actor.vala"
			actor = flutter_container_iterator_get (_actor_it);
#line 1397 "ease-slide-actor.vala"
			ease_slide_actor_get_intersperse_coords (self, actor, &target_x, &target_y);
#line 1399 "ease-slide-actor.vala"
			clutter_actor_animate (actor, (gulong) CLUTTER_EASE_IN_SINE, length, "y", target_y, "x", target_x, NULL);
#line 3145 "ease-slide-actor.c"
			_g_object_unref0 (actor);
		}
		_flutter_container_iterator_unref0 (_actor_it);
	}
	{
		FlutterContainerIterator* _actor_it;
#line 1404 "ease-slide-actor.vala"
		_actor_it = flutter_container_iterator ((FlutterContainer*) new_slide->contents);
#line 1404 "ease-slide-actor.vala"
		while (TRUE) {
#line 3156 "ease-slide-actor.c"
			ClutterActor* actor;
#line 1404 "ease-slide-actor.vala"
			if (!flutter_container_iterator_next (_actor_it)) {
#line 1404 "ease-slide-actor.vala"
				break;
#line 3162 "ease-slide-actor.c"
			}
#line 1404 "ease-slide-actor.vala"
			actor = flutter_container_iterator_get (_actor_it);
#line 1407 "ease-slide-actor.vala"
			orig_x = clutter_actor_get_x (actor);
#line 1408 "ease-slide-actor.vala"
			orig_y = clutter_actor_get_y (actor);
#line 1411 "ease-slide-actor.vala"
			ease_slide_actor_get_intersperse_coords (self, actor, &target_x, &target_y);
#line 1414 "ease-slide-actor.vala"
			clutter_actor_set_x (actor, target_x);
#line 1415 "ease-slide-actor.vala"
			clutter_actor_set_y (actor, target_y);
#line 1418 "ease-slide-actor.vala"
			clutter_actor_animate (actor, (gulong) CLUTTER_EASE_OUT_SINE, length, "y", orig_y, "x", orig_x, NULL);
#line 3178 "ease-slide-actor.c"
			_g_object_unref0 (actor);
		}
		_flutter_container_iterator_unref0 (_actor_it);
	}
}


#line 1424 "ease-slide-actor.vala"
static void ease_slide_actor_get_intersperse_coords (EaseSlideActor* self, ClutterActor* actor, float* target_x, float* target_y) {
#line 3188 "ease-slide-actor.c"
	gint center_x;
	gint center_y;
	float m;
	double angle;
#line 1424 "ease-slide-actor.vala"
	g_return_if_fail (self != NULL);
#line 1424 "ease-slide-actor.vala"
	g_return_if_fail (actor != NULL);
#line 1427 "ease-slide-actor.vala"
	center_x = ease_slide_get_width (self->priv->_slide) / 2;
#line 1428 "ease-slide-actor.vala"
	center_y = ease_slide_get_height (self->priv->_slide) / 2;
#line 1430 "ease-slide-actor.vala"
	if (((clutter_actor_get_x (actor) + (clutter_actor_get_width (actor) / 2)) - center_x) == 0) {
#line 3203 "ease-slide-actor.c"
		float _tmp0_ = 0.0F;
#line 1432 "ease-slide-actor.vala"
		*target_x = clutter_actor_get_x (actor);
#line 1433 "ease-slide-actor.vala"
		if ((clutter_actor_get_y (actor) + (clutter_actor_get_height (actor) / 2)) > center_y) {
#line 1434 "ease-slide-actor.vala"
			_tmp0_ = (float) ease_slide_get_height (self->priv->_slide);
#line 3211 "ease-slide-actor.c"
		} else {
#line 1434 "ease-slide-actor.vala"
			_tmp0_ = -clutter_actor_get_height (actor);
#line 3215 "ease-slide-actor.c"
		}
#line 1433 "ease-slide-actor.vala"
		*target_y = _tmp0_;
#line 1435 "ease-slide-actor.vala"
		return;
#line 3221 "ease-slide-actor.c"
	}
#line 1438 "ease-slide-actor.vala"
	m = ((clutter_actor_get_y (actor) + (clutter_actor_get_height (actor) / 2)) - center_y) / ((clutter_actor_get_x (actor) + (clutter_actor_get_width (actor) / 2)) - center_x);
#line 1441 "ease-slide-actor.vala"
	angle = fmod (atan2 ((double) m, (double) 1), G_PI * 2);
#line 1443 "ease-slide-actor.vala"
	if (m == 0) {
#line 3229 "ease-slide-actor.c"
		float _tmp1_ = 0.0F;
#line 1445 "ease-slide-actor.vala"
		if ((clutter_actor_get_x (actor) + (clutter_actor_get_width (actor) / 2)) > center_x) {
#line 1446 "ease-slide-actor.vala"
			_tmp1_ = (float) ease_slide_get_width (self->priv->_slide);
#line 3235 "ease-slide-actor.c"
		} else {
#line 1446 "ease-slide-actor.vala"
			_tmp1_ = -clutter_actor_get_width (actor);
#line 3239 "ease-slide-actor.c"
		}
#line 1445 "ease-slide-actor.vala"
		*target_x = _tmp1_;
#line 1447 "ease-slide-actor.vala"
		*target_y = clutter_actor_get_y (actor);
#line 3245 "ease-slide-actor.c"
	} else {
		gboolean _tmp2_ = FALSE;
#line 1449 "ease-slide-actor.vala"
		if (angle > (G_PI * 1.75)) {
#line 1449 "ease-slide-actor.vala"
			_tmp2_ = TRUE;
#line 3252 "ease-slide-actor.c"
		} else {
#line 1449 "ease-slide-actor.vala"
			_tmp2_ = angle <= (G_PI * 0.25);
#line 3256 "ease-slide-actor.c"
		}
#line 1449 "ease-slide-actor.vala"
		if (_tmp2_) {
#line 1451 "ease-slide-actor.vala"
			*target_x = (float) ease_slide_get_width (self->priv->_slide);
#line 1452 "ease-slide-actor.vala"
			*target_y = (m * (*target_x)) + center_y;
#line 3264 "ease-slide-actor.c"
		} else {
			gboolean _tmp3_ = FALSE;
#line 1454 "ease-slide-actor.vala"
			if (angle > (G_PI * 0.25)) {
#line 1454 "ease-slide-actor.vala"
				_tmp3_ = TRUE;
#line 3271 "ease-slide-actor.c"
			} else {
#line 1454 "ease-slide-actor.vala"
				_tmp3_ = angle <= (G_PI * 0.75);
#line 3275 "ease-slide-actor.c"
			}
#line 1454 "ease-slide-actor.vala"
			if (_tmp3_) {
#line 1456 "ease-slide-actor.vala"
				*target_y = -clutter_actor_get_height (actor);
#line 1457 "ease-slide-actor.vala"
				*target_x = ((*target_y) - center_y) / m;
#line 3283 "ease-slide-actor.c"
			} else {
				gboolean _tmp4_ = FALSE;
#line 1459 "ease-slide-actor.vala"
				if (angle > (G_PI * 0.75)) {
#line 1459 "ease-slide-actor.vala"
					_tmp4_ = TRUE;
#line 3290 "ease-slide-actor.c"
				} else {
#line 1459 "ease-slide-actor.vala"
					_tmp4_ = angle <= (G_PI * 1.25);
#line 3294 "ease-slide-actor.c"
				}
#line 1459 "ease-slide-actor.vala"
				if (_tmp4_) {
#line 1461 "ease-slide-actor.vala"
					*target_x = -clutter_actor_get_width (actor);
#line 1462 "ease-slide-actor.vala"
					*target_y = (m * (*target_x)) + center_y;
#line 3302 "ease-slide-actor.c"
				} else {
#line 1466 "ease-slide-actor.vala"
					*target_y = (float) ease_slide_get_height (self->priv->_slide);
#line 1467 "ease-slide-actor.vala"
					*target_x = ((*target_y) - center_y) / m;
#line 3308 "ease-slide-actor.c"
				}
			}
		}
	}
}


/**
 * Starts a "zoom contents" transition. This transition unstacks the
 * SlideActors.
 *
 * @param new_slide The new SlideActor.
 * @param container The container that holds the displayed SlideActors.
 * @param length The length of the transition, in milliseconds.
 */
#line 1502 "ease-slide-actor.vala"
static void _lambda27_ (gint m, Block15Data* _data15_) {
#line 3326 "ease-slide-actor.c"
	EaseSlideActor * self;
	self = _data15_->self;
#line 1503 "ease-slide-actor.vala"
	clutter_actor_set_scale ((ClutterActor*) _data15_->new_slide->contents, clutter_alpha_get_alpha (self->priv->_animation_alpha), clutter_alpha_get_alpha (self->priv->_animation_alpha));
#line 1506 "ease-slide-actor.vala"
	clutter_actor_set_scale ((ClutterActor*) self->contents, 1.0 + (2 * clutter_alpha_get_alpha (self->priv->_animation_alpha)), 1.0 + (2 * clutter_alpha_get_alpha (self->priv->_animation_alpha)));
#line 3333 "ease-slide-actor.c"
}


#line 1502 "ease-slide-actor.vala"
static void __lambda27__clutter_timeline_new_frame (ClutterTimeline* _sender, gint frame_num, gpointer self) {
#line 3339 "ease-slide-actor.c"
	_lambda27_ (frame_num, self);
}


#line 1522 "ease-slide-actor.vala"
static void _lambda28_ (gint m, Block15Data* _data15_) {
#line 3346 "ease-slide-actor.c"
	EaseSlideActor * self;
	self = _data15_->self;
#line 1523 "ease-slide-actor.vala"
	clutter_actor_set_scale ((ClutterActor*) _data15_->new_slide->contents, 1.0 + (2 * (1 - clutter_alpha_get_alpha (self->priv->_animation_alpha))), 1.0 + (2 * (1 - clutter_alpha_get_alpha (self->priv->_animation_alpha))));
#line 1525 "ease-slide-actor.vala"
	clutter_actor_set_scale ((ClutterActor*) self->contents, 1 - clutter_alpha_get_alpha (self->priv->_animation_alpha), 1 - clutter_alpha_get_alpha (self->priv->_animation_alpha));
#line 3353 "ease-slide-actor.c"
}


#line 1522 "ease-slide-actor.vala"
static void __lambda28__clutter_timeline_new_frame (ClutterTimeline* _sender, gint frame_num, gpointer self) {
#line 3359 "ease-slide-actor.c"
	_lambda28_ (frame_num, self);
}


static Block15Data* block15_data_ref (Block15Data* _data15_) {
	g_atomic_int_inc (&_data15_->_ref_count_);
	return _data15_;
}


static void block15_data_unref (Block15Data* _data15_) {
	if (g_atomic_int_dec_and_test (&_data15_->_ref_count_)) {
		_g_object_unref0 (_data15_->self);
		_g_object_unref0 (_data15_->new_slide);
		g_slice_free (Block15Data, _data15_);
	}
}


#line 1479 "ease-slide-actor.vala"
static void ease_slide_actor_zoom_contents_transition (EaseSlideActor* self, EaseSlideActor* new_slide, ClutterGroup* container, guint length) {
#line 3381 "ease-slide-actor.c"
	Block15Data* _data15_;
	ClutterAlpha* _tmp0_;
#line 1479 "ease-slide-actor.vala"
	g_return_if_fail (self != NULL);
#line 1479 "ease-slide-actor.vala"
	g_return_if_fail (new_slide != NULL);
#line 1479 "ease-slide-actor.vala"
	g_return_if_fail (container != NULL);
#line 3390 "ease-slide-actor.c"
	_data15_ = g_slice_new0 (Block15Data);
	_data15_->_ref_count_ = 1;
	_data15_->self = g_object_ref (self);
	_data15_->new_slide = _g_object_ref0 (new_slide);
#line 1483 "ease-slide-actor.vala"
	ease_slide_actor_prepare_stack_transition (self, ease_slide_get_variant (self->priv->_slide) == EASE_TRANSITION_VARIANT_OUT, _data15_->new_slide, container);
#line 1486 "ease-slide-actor.vala"
	ease_slide_actor_set_animation_alpha (self, _tmp0_ = g_object_ref_sink (clutter_alpha_new_full (self->priv->_animation_time, (gulong) CLUTTER_EASE_IN_OUT_SINE)));
#line 3399 "ease-slide-actor.c"
	_g_object_unref0 (_tmp0_);
#line 1489 "ease-slide-actor.vala"
	clutter_actor_animate ((ClutterActor*) self->background, (gulong) CLUTTER_LINEAR, length, "opacity", 0, NULL);
#line 1490 "ease-slide-actor.vala"
	switch (ease_slide_get_variant (self->priv->_slide)) {
#line 3405 "ease-slide-actor.c"
		case EASE_TRANSITION_VARIANT_IN:
		{
#line 1493 "ease-slide-actor.vala"
			clutter_actor_set_scale_full ((ClutterActor*) _data15_->new_slide->contents, (double) 0, (double) 0, (float) (ease_slide_get_width (self->priv->_slide) / 2), (float) (ease_slide_get_height (self->priv->_slide) / 2));
#line 1497 "ease-slide-actor.vala"
			clutter_actor_set_scale_full ((ClutterActor*) self->contents, (double) 1, (double) 1, (float) (ease_slide_get_width (self->priv->_slide) / 2), (float) (ease_slide_get_height (self->priv->_slide) / 2));
#line 1501 "ease-slide-actor.vala"
			clutter_actor_animate ((ClutterActor*) self->contents, (gulong) CLUTTER_LINEAR, length / 2, "opacity", 0, NULL);
#line 1502 "ease-slide-actor.vala"
			g_signal_connect_data (self->priv->_animation_time, "new-frame", (GCallback) __lambda27__clutter_timeline_new_frame, block15_data_ref (_data15_), (GClosureNotify) block15_data_unref, 0);
#line 1509 "ease-slide-actor.vala"
			break;
#line 3418 "ease-slide-actor.c"
		}
		case EASE_TRANSITION_VARIANT_OUT:
		{
#line 1511 "ease-slide-actor.vala"
			clutter_actor_set_scale_full ((ClutterActor*) _data15_->new_slide->contents, (double) 0, (double) 0, (float) (ease_slide_get_width (self->priv->_slide) / 2), (float) (ease_slide_get_height (self->priv->_slide) / 2));
#line 1515 "ease-slide-actor.vala"
			clutter_actor_set_scale_full ((ClutterActor*) self->contents, (double) 1, (double) 1, (float) (ease_slide_get_width (self->priv->_slide) / 2), (float) (ease_slide_get_height (self->priv->_slide) / 2));
#line 1519 "ease-slide-actor.vala"
			clutter_actor_set_opacity ((ClutterActor*) _data15_->new_slide->contents, (guint) 0);
#line 1520 "ease-slide-actor.vala"
			clutter_actor_animate ((ClutterActor*) _data15_->new_slide->contents, (gulong) CLUTTER_EASE_IN_SINE, length / 2, "opacity", 255, NULL);
#line 1522 "ease-slide-actor.vala"
			g_signal_connect_data (self->priv->_animation_time, "new-frame", (GCallback) __lambda28__clutter_timeline_new_frame, block15_data_ref (_data15_), (GClosureNotify) block15_data_unref, 0);
#line 1528 "ease-slide-actor.vala"
			break;
#line 3434 "ease-slide-actor.c"
		}
	}
	block15_data_unref (_data15_);
}


/**
 * Starts an "Explode" transition
 *
 * @param new_slide The new SlideActor.
 * @param container The container that holds the displayed SlideActors.
 * @param length The length of the transition, in milliseconds.
 */
#line 1588 "ease-slide-actor.vala"
static void _lambda33_ (Block16Data* _data16_) {
#line 3450 "ease-slide-actor.c"
	EaseSlideActor * self;
	self = _data16_->self;
	{
		gint j;
#line 1589 "ease-slide-actor.vala"
		j = 0;
#line 3457 "ease-slide-actor.c"
		{
			gboolean _tmp0_;
#line 1589 "ease-slide-actor.vala"
			_tmp0_ = TRUE;
#line 1589 "ease-slide-actor.vala"
			while (TRUE) {
#line 1589 "ease-slide-actor.vala"
				if (!_tmp0_) {
#line 1589 "ease-slide-actor.vala"
					j++;
#line 3468 "ease-slide-actor.c"
				}
#line 1589 "ease-slide-actor.vala"
				_tmp0_ = FALSE;
#line 1589 "ease-slide-actor.vala"
				if (!(j < _data16_->count)) {
#line 1589 "ease-slide-actor.vala"
					break;
#line 3476 "ease-slide-actor.c"
				}
#line 1591 "ease-slide-actor.vala"
				clutter_container_remove_actor ((ClutterContainer*) _data16_->container, (ClutterActor*) _data16_->particles[j]);
#line 3480 "ease-slide-actor.c"
			}
		}
	}
}


#line 1588 "ease-slide-actor.vala"
static void __lambda33__clutter_timeline_completed (ClutterTimeline* _sender, gpointer self) {
#line 3489 "ease-slide-actor.c"
	_lambda33_ (self);
}


static Block16Data* block16_data_ref (Block16Data* _data16_) {
	g_atomic_int_inc (&_data16_->_ref_count_);
	return _data16_;
}


static void block16_data_unref (Block16Data* _data16_) {
	if (g_atomic_int_dec_and_test (&_data16_->_ref_count_)) {
		_g_object_unref0 (_data16_->self);
		_data16_->particles = (_vala_array_free (_data16_->particles, _data16_->particles_length1, (GDestroyNotify) g_object_unref), NULL);
		_g_object_unref0 (_data16_->container);
		g_slice_free (Block16Data, _data16_);
	}
}


#line 1539 "ease-slide-actor.vala"
static void ease_slide_actor_explode_transition (EaseSlideActor* self, EaseSlideActor* new_slide, ClutterGroup* container, guint length) {
#line 3512 "ease-slide-actor.c"
	Block16Data* _data16_;
	gint v_count;
	ClutterClone** _tmp0_;
	float size;
	float center_x;
	float center_y;
	gint i = 0;
#line 1539 "ease-slide-actor.vala"
	g_return_if_fail (self != NULL);
#line 1539 "ease-slide-actor.vala"
	g_return_if_fail (new_slide != NULL);
#line 1539 "ease-slide-actor.vala"
	g_return_if_fail (container != NULL);
#line 3526 "ease-slide-actor.c"
	_data16_ = g_slice_new0 (Block16Data);
	_data16_->_ref_count_ = 1;
	_data16_->self = g_object_ref (self);
	_data16_->container = _g_object_ref0 (container);
#line 1544 "ease-slide-actor.vala"
	clutter_actor_reparent ((ClutterActor*) self, (ClutterActor*) _data16_->container);
#line 1545 "ease-slide-actor.vala"
	clutter_actor_reparent ((ClutterActor*) new_slide, (ClutterActor*) _data16_->container);
#line 1546 "ease-slide-actor.vala"
	clutter_actor_set_x ((ClutterActor*) self, (float) ease_slide_get_width (self->priv->_slide));
#line 1549 "ease-slide-actor.vala"
	v_count = (gint) ceil ((double) ((1 / ease_slide_get_aspect (self->priv->_slide)) * EASE_SLIDE_ACTOR_EXPLODE_PARTICLES));
#line 3539 "ease-slide-actor.c"
	_data16_->count = EASE_SLIDE_ACTOR_EXPLODE_PARTICLES * v_count;
	_data16_->particles = (_tmp0_ = g_new0 (ClutterClone*, _data16_->count + 1), _data16_->particles_length1 = _data16_->count, _tmp0_);
#line 1554 "ease-slide-actor.vala"
	size = ((float) ease_slide_get_width (self->priv->_slide)) / EASE_SLIDE_ACTOR_EXPLODE_PARTICLES;
#line 1555 "ease-slide-actor.vala"
	center_x = (float) (ease_slide_get_width (self->priv->_slide) / 2);
#line 1556 "ease-slide-actor.vala"
	center_y = (float) (ease_slide_get_height (self->priv->_slide) / 2);
#line 3548 "ease-slide-actor.c"
	{
		gint vpos;
#line 1560 "ease-slide-actor.vala"
		vpos = 0;
#line 3553 "ease-slide-actor.c"
		{
			gboolean _tmp1_;
#line 1560 "ease-slide-actor.vala"
			_tmp1_ = TRUE;
#line 1560 "ease-slide-actor.vala"
			while (TRUE) {
#line 1560 "ease-slide-actor.vala"
				if (!_tmp1_) {
#line 1560 "ease-slide-actor.vala"
					vpos++;
#line 3564 "ease-slide-actor.c"
				}
#line 1560 "ease-slide-actor.vala"
				_tmp1_ = FALSE;
#line 1560 "ease-slide-actor.vala"
				if (!(vpos < v_count)) {
#line 1560 "ease-slide-actor.vala"
					break;
#line 3572 "ease-slide-actor.c"
				}
				{
					gint hpos;
#line 1562 "ease-slide-actor.vala"
					hpos = 0;
#line 3578 "ease-slide-actor.c"
					{
						gboolean _tmp2_;
#line 1562 "ease-slide-actor.vala"
						_tmp2_ = TRUE;
#line 1562 "ease-slide-actor.vala"
						while (TRUE) {
#line 3585 "ease-slide-actor.c"
							ClutterClone* _tmp3_;
							float atan;
#line 1562 "ease-slide-actor.vala"
							if (!_tmp2_) {
#line 1562 "ease-slide-actor.vala"
								hpos++;
#line 3592 "ease-slide-actor.c"
							}
#line 1562 "ease-slide-actor.vala"
							_tmp2_ = FALSE;
#line 1562 "ease-slide-actor.vala"
							if (!(hpos < EASE_SLIDE_ACTOR_EXPLODE_PARTICLES)) {
#line 1562 "ease-slide-actor.vala"
								break;
#line 3600 "ease-slide-actor.c"
							}
#line 1565 "ease-slide-actor.vala"
							i = (vpos * EASE_SLIDE_ACTOR_EXPLODE_PARTICLES) + hpos;
#line 1566 "ease-slide-actor.vala"
							_data16_->particles[i] = (_tmp3_ = g_object_ref_sink ((ClutterClone*) clutter_clone_new ((ClutterActor*) self)), _g_object_unref0 (_data16_->particles[i]), _tmp3_);
#line 1569 "ease-slide-actor.vala"
							clutter_actor_set_clip ((ClutterActor*) _data16_->particles[i], hpos * size, vpos * size, size, size);
#line 1571 "ease-slide-actor.vala"
							atan = atan2f (center_y - (vpos * size), center_x - (hpos * size));
#line 1575 "ease-slide-actor.vala"
							clutter_actor_animate ((ClutterActor*) _data16_->particles[i], (gulong) CLUTTER_EASE_IN_SINE, ease_slide_actor_explode_time (self, length), "x", (-cosf (atan)) * ease_slide_actor_explode_dist (self), "y", (-sinf (atan)) * ease_slide_actor_explode_dist (self), "depth", ease_slide_actor_explode_depth (self), "opacity", 0, NULL);
#line 1582 "ease-slide-actor.vala"
							clutter_container_add_actor ((ClutterContainer*) _data16_->container, (ClutterActor*) _data16_->particles[i]);
#line 1583 "ease-slide-actor.vala"
							clutter_actor_show ((ClutterActor*) _data16_->particles[i]);
#line 3616 "ease-slide-actor.c"
						}
					}
				}
			}
		}
	}
#line 1588 "ease-slide-actor.vala"
	g_signal_connect_data (self->priv->_animation_time, "completed", (GCallback) __lambda33__clutter_timeline_completed, block16_data_ref (_data16_), (GClosureNotify) block16_data_unref, 0);
#line 3625 "ease-slide-actor.c"
	block16_data_unref (_data16_);
}


/**
 * Starts an "Assemble" transition
 *
 * @param new_slide The new SlideActor.
 * @param container The container that holds the displayed SlideActors.
 * @param length The length of the transition, in milliseconds.
 */
#line 1663 "ease-slide-actor.vala"
static void _lambda34_ (Block17Data* _data17_) {
#line 3639 "ease-slide-actor.c"
	EaseSlideActor * self;
	self = _data17_->self;
#line 1664 "ease-slide-actor.vala"
	clutter_actor_set_x ((ClutterActor*) _data17_->new_slide, (float) 0);
#line 3644 "ease-slide-actor.c"
	{
		gint j;
#line 1665 "ease-slide-actor.vala"
		j = 0;
#line 3649 "ease-slide-actor.c"
		{
			gboolean _tmp0_;
#line 1665 "ease-slide-actor.vala"
			_tmp0_ = TRUE;
#line 1665 "ease-slide-actor.vala"
			while (TRUE) {
#line 1665 "ease-slide-actor.vala"
				if (!_tmp0_) {
#line 1665 "ease-slide-actor.vala"
					j++;
#line 3660 "ease-slide-actor.c"
				}
#line 1665 "ease-slide-actor.vala"
				_tmp0_ = FALSE;
#line 1665 "ease-slide-actor.vala"
				if (!(j < _data17_->count)) {
#line 1665 "ease-slide-actor.vala"
					break;
#line 3668 "ease-slide-actor.c"
				}
#line 1667 "ease-slide-actor.vala"
				if (clutter_actor_get_parent ((ClutterActor*) _data17_->particles[j]) == CLUTTER_ACTOR (_data17_->container)) {
#line 1669 "ease-slide-actor.vala"
					clutter_container_remove_actor ((ClutterContainer*) _data17_->container, (ClutterActor*) _data17_->particles[j]);
#line 3674 "ease-slide-actor.c"
				}
			}
		}
	}
}


#line 1663 "ease-slide-actor.vala"
static void __lambda34__clutter_timeline_completed (ClutterTimeline* _sender, gpointer self) {
#line 3684 "ease-slide-actor.c"
	_lambda34_ (self);
}


static Block17Data* block17_data_ref (Block17Data* _data17_) {
	g_atomic_int_inc (&_data17_->_ref_count_);
	return _data17_;
}


static void block17_data_unref (Block17Data* _data17_) {
	if (g_atomic_int_dec_and_test (&_data17_->_ref_count_)) {
		_g_object_unref0 (_data17_->self);
		_data17_->particles = (_vala_array_free (_data17_->particles, _data17_->particles_length1, (GDestroyNotify) g_object_unref), NULL);
		_g_object_unref0 (_data17_->new_slide);
		_g_object_unref0 (_data17_->container);
		g_slice_free (Block17Data, _data17_);
	}
}


#line 1603 "ease-slide-actor.vala"
static void ease_slide_actor_assemble_transition (EaseSlideActor* self, EaseSlideActor* new_slide, ClutterGroup* container, guint length) {
#line 3708 "ease-slide-actor.c"
	Block17Data* _data17_;
	gint v_count;
	ClutterClone** _tmp0_;
	float size;
	gint i = 0;
#line 1603 "ease-slide-actor.vala"
	g_return_if_fail (self != NULL);
#line 1603 "ease-slide-actor.vala"
	g_return_if_fail (new_slide != NULL);
#line 1603 "ease-slide-actor.vala"
	g_return_if_fail (container != NULL);
#line 3720 "ease-slide-actor.c"
	_data17_ = g_slice_new0 (Block17Data);
	_data17_->_ref_count_ = 1;
	_data17_->self = g_object_ref (self);
	_data17_->new_slide = _g_object_ref0 (new_slide);
	_data17_->container = _g_object_ref0 (container);
#line 1608 "ease-slide-actor.vala"
	clutter_actor_reparent ((ClutterActor*) _data17_->new_slide, (ClutterActor*) _data17_->container);
#line 1609 "ease-slide-actor.vala"
	clutter_actor_set_x ((ClutterActor*) _data17_->new_slide, (float) ease_slide_get_width (self->priv->_slide));
#line 1612 "ease-slide-actor.vala"
	v_count = (gint) ceil ((double) ((1 / ease_slide_get_aspect (self->priv->_slide)) * EASE_SLIDE_ACTOR_ASSEMBLE_TILES));
#line 3732 "ease-slide-actor.c"
	_data17_->count = EASE_SLIDE_ACTOR_ASSEMBLE_TILES * v_count;
	_data17_->particles = (_tmp0_ = g_new0 (ClutterClone*, _data17_->count + 1), _data17_->particles_length1 = _data17_->count, _tmp0_);
#line 1617 "ease-slide-actor.vala"
	size = ((float) ease_slide_get_width (self->priv->_slide)) / EASE_SLIDE_ACTOR_ASSEMBLE_TILES;
#line 3737 "ease-slide-actor.c"
	{
		gint vpos;
#line 1621 "ease-slide-actor.vala"
		vpos = 0;
#line 3742 "ease-slide-actor.c"
		{
			gboolean _tmp1_;
#line 1621 "ease-slide-actor.vala"
			_tmp1_ = TRUE;
#line 1621 "ease-slide-actor.vala"
			while (TRUE) {
#line 1621 "ease-slide-actor.vala"
				if (!_tmp1_) {
#line 1621 "ease-slide-actor.vala"
					vpos++;
#line 3753 "ease-slide-actor.c"
				}
#line 1621 "ease-slide-actor.vala"
				_tmp1_ = FALSE;
#line 1621 "ease-slide-actor.vala"
				if (!(vpos < v_count)) {
#line 1621 "ease-slide-actor.vala"
					break;
#line 3761 "ease-slide-actor.c"
				}
				{
					gint hpos;
#line 1623 "ease-slide-actor.vala"
					hpos = 0;
#line 3767 "ease-slide-actor.c"
					{
						gboolean _tmp2_;
#line 1623 "ease-slide-actor.vala"
						_tmp2_ = TRUE;
#line 1623 "ease-slide-actor.vala"
						while (TRUE) {
#line 3774 "ease-slide-actor.c"
							ClutterClone* _tmp3_;
							gboolean anim_x;
							const char* _tmp4_;
#line 1623 "ease-slide-actor.vala"
							if (!_tmp2_) {
#line 1623 "ease-slide-actor.vala"
								hpos++;
#line 3782 "ease-slide-actor.c"
							}
#line 1623 "ease-slide-actor.vala"
							_tmp2_ = FALSE;
#line 1623 "ease-slide-actor.vala"
							if (!(hpos < EASE_SLIDE_ACTOR_ASSEMBLE_TILES)) {
#line 1623 "ease-slide-actor.vala"
								break;
#line 3790 "ease-slide-actor.c"
							}
#line 1626 "ease-slide-actor.vala"
							i = (vpos * EASE_SLIDE_ACTOR_ASSEMBLE_TILES) + hpos;
#line 1627 "ease-slide-actor.vala"
							_data17_->particles[i] = (_tmp3_ = g_object_ref_sink ((ClutterClone*) clutter_clone_new ((ClutterActor*) _data17_->new_slide)), _g_object_unref0 (_data17_->particles[i]), _tmp3_);
#line 1630 "ease-slide-actor.vala"
							clutter_actor_set_clip ((ClutterActor*) _data17_->particles[i], hpos * size, vpos * size, size + 1, size + 1);
#line 1634 "ease-slide-actor.vala"
							anim_x = FALSE;
#line 1635 "ease-slide-actor.vala"
							switch (g_random_int_range ((gint32) 0, (gint32) 4)) {
#line 3802 "ease-slide-actor.c"
								case 0:
								{
#line 1638 "ease-slide-actor.vala"
									clutter_actor_set_x ((ClutterActor*) _data17_->particles[i], ((-(hpos + 1)) * size) - ease_slide_actor_assemble_extra (self));
#line 1639 "ease-slide-actor.vala"
									anim_x = TRUE;
#line 1640 "ease-slide-actor.vala"
									break;
#line 3811 "ease-slide-actor.c"
								}
								case 1:
								{
#line 1642 "ease-slide-actor.vala"
									clutter_actor_set_y ((ClutterActor*) _data17_->particles[i], ((-(vpos + 1)) * size) - ease_slide_actor_assemble_extra (self));
#line 1643 "ease-slide-actor.vala"
									break;
#line 3819 "ease-slide-actor.c"
								}
								case 2:
								{
#line 1645 "ease-slide-actor.vala"
									clutter_actor_set_x ((ClutterActor*) _data17_->particles[i], (((EASE_SLIDE_ACTOR_ASSEMBLE_TILES - hpos) + 1) * size) + ease_slide_actor_assemble_extra (self));
#line 1647 "ease-slide-actor.vala"
									anim_x = TRUE;
#line 1648 "ease-slide-actor.vala"
									break;
#line 3829 "ease-slide-actor.c"
								}
								case 3:
								{
#line 1650 "ease-slide-actor.vala"
									clutter_actor_set_y ((ClutterActor*) _data17_->particles[i], (((v_count - vpos) + 1) * size) + ease_slide_actor_assemble_extra (self));
#line 1652 "ease-slide-actor.vala"
									break;
#line 3837 "ease-slide-actor.c"
								}
							}
							_tmp4_ = NULL;
#line 1656 "ease-slide-actor.vala"
							if (anim_x) {
#line 1656 "ease-slide-actor.vala"
								_tmp4_ = "x";
#line 3845 "ease-slide-actor.c"
							} else {
#line 1656 "ease-slide-actor.vala"
								_tmp4_ = "y";
#line 3849 "ease-slide-actor.c"
							}
#line 1655 "ease-slide-actor.vala"
							clutter_actor_animate ((ClutterActor*) _data17_->particles[i], (gulong) CLUTTER_EASE_IN_OUT_SINE, length, _tmp4_, 0, NULL);
#line 1657 "ease-slide-actor.vala"
							clutter_container_add_actor ((ClutterContainer*) _data17_->container, (ClutterActor*) _data17_->particles[i]);
#line 1658 "ease-slide-actor.vala"
							clutter_actor_show ((ClutterActor*) _data17_->particles[i]);
#line 3857 "ease-slide-actor.c"
						}
					}
				}
			}
		}
	}
#line 1663 "ease-slide-actor.vala"
	g_signal_connect_data (self->priv->_animation_time, "completed", (GCallback) __lambda34__clutter_timeline_completed, block17_data_ref (_data17_), (GClosureNotify) block17_data_unref, 0);
#line 3866 "ease-slide-actor.c"
	block17_data_unref (_data17_);
}


#line 1675 "ease-slide-actor.vala"
static float ease_slide_actor_assemble_extra (EaseSlideActor* self) {
#line 3873 "ease-slide-actor.c"
	float result = 0.0F;
#line 1675 "ease-slide-actor.vala"
	g_return_val_if_fail (self != NULL, 0.0F);
#line 3877 "ease-slide-actor.c"
	result = (float) g_random_int_range ((gint32) 0, (gint32) 1000);
#line 1677 "ease-slide-actor.vala"
	return result;
#line 3881 "ease-slide-actor.c"
}


#line 1680 "ease-slide-actor.vala"
static float ease_slide_actor_explode_dist (EaseSlideActor* self) {
#line 3887 "ease-slide-actor.c"
	float result = 0.0F;
#line 1680 "ease-slide-actor.vala"
	g_return_val_if_fail (self != NULL, 0.0F);
#line 3891 "ease-slide-actor.c"
	result = (float) g_random_int_range ((gint32) 10, (gint32) 200);
#line 1682 "ease-slide-actor.vala"
	return result;
#line 3895 "ease-slide-actor.c"
}


#line 1685 "ease-slide-actor.vala"
static float ease_slide_actor_explode_depth (EaseSlideActor* self) {
#line 3901 "ease-slide-actor.c"
	float result = 0.0F;
#line 1685 "ease-slide-actor.vala"
	g_return_val_if_fail (self != NULL, 0.0F);
#line 3905 "ease-slide-actor.c"
	result = (float) g_random_int_range ((gint32) (-5), (gint32) 50);
#line 1687 "ease-slide-actor.vala"
	return result;
#line 3909 "ease-slide-actor.c"
}


#line 1690 "ease-slide-actor.vala"
static guint ease_slide_actor_explode_time (EaseSlideActor* self, guint time) {
#line 3915 "ease-slide-actor.c"
	guint result = 0U;
#line 1690 "ease-slide-actor.vala"
	g_return_val_if_fail (self != NULL, 0U);
#line 3919 "ease-slide-actor.c"
	result = (guint) ((0.25 * time) + ((g_random_double () * 0.75) * time));
#line 1692 "ease-slide-actor.vala"
	return result;
#line 3923 "ease-slide-actor.c"
}


/**
 * Clamps a double to an opacity value, an unsigned 8-bit integer.
 */
#line 1698 "ease-slide-actor.vala"
static guint8 ease_slide_actor_clamp_opacity (double o) {
#line 3932 "ease-slide-actor.c"
	guint8 result = 0U;
	result = (guint8) fmax ((double) 0, fmin ((double) 255, o));
#line 1700 "ease-slide-actor.vala"
	return result;
#line 3937 "ease-slide-actor.c"
}


#line 25 "ease-slide-actor.vala"
EaseSlideActor* ease_slide_actor_construct (GType object_type) {
#line 3943 "ease-slide-actor.c"
	EaseSlideActor * self;
	self = g_object_newv (object_type, 0, NULL);
	return self;
}


#line 25 "ease-slide-actor.vala"
EaseSlideActor* ease_slide_actor_new (void) {
#line 25 "ease-slide-actor.vala"
	return ease_slide_actor_construct (EASE_TYPE_SLIDE_ACTOR);
#line 3954 "ease-slide-actor.c"
}


EaseSlide* ease_slide_actor_get_slide (EaseSlideActor* self) {
	EaseSlide* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_slide;
#line 30 "ease-slide-actor.vala"
	return result;
#line 3964 "ease-slide-actor.c"
}


void ease_slide_actor_set_slide (EaseSlideActor* self, EaseSlide* value) {
	g_return_if_fail (self != NULL);
	self->priv->_slide = value;
	g_object_notify ((GObject *) self, "slide");
}


ClutterTimeline* ease_slide_actor_get_animation_time (EaseSlideActor* self) {
	ClutterTimeline* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_animation_time;
#line 62 "ease-slide-actor.vala"
	return result;
#line 3981 "ease-slide-actor.c"
}


void ease_slide_actor_set_animation_time (EaseSlideActor* self, ClutterTimeline* value) {
	ClutterTimeline* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_animation_time = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->_animation_time), _tmp0_);
	g_object_notify ((GObject *) self, "animation-time");
}


static ClutterAlpha* ease_slide_actor_get_animation_alpha (EaseSlideActor* self) {
	ClutterAlpha* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_animation_alpha;
#line 63 "ease-slide-actor.vala"
	return result;
#line 3999 "ease-slide-actor.c"
}


static void ease_slide_actor_set_animation_alpha (EaseSlideActor* self, ClutterAlpha* value) {
	ClutterAlpha* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_animation_alpha = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->_animation_alpha), _tmp0_);
}


static void ease_slide_actor_class_init (EaseSlideActorClass * klass) {
	ease_slide_actor_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (EaseSlideActorPrivate));
	G_OBJECT_CLASS (klass)->get_property = ease_slide_actor_get_property;
	G_OBJECT_CLASS (klass)->set_property = ease_slide_actor_set_property;
	G_OBJECT_CLASS (klass)->finalize = ease_slide_actor_finalize;
	/**
	 * The {@link Slide} represented by this SlideActor.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), EASE_SLIDE_ACTOR_SLIDE, g_param_spec_object ("slide", "slide", "slide", EASE_TYPE_SLIDE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	 * The ClutterTimeline for a transition animation.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), EASE_SLIDE_ACTOR_ANIMATION_TIME, g_param_spec_object ("animation-time", "animation-time", "animation-time", CLUTTER_TYPE_TIMELINE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	 * Emitted when a subactor of this SlideActor is removed.
	 */
	g_signal_new ("ease_actor_removed", EASE_TYPE_SLIDE_ACTOR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, EASE_TYPE_ACTOR);
	/**
	 * Emitted when a subactor is added to this SlideActor.
	 */
	g_signal_new ("ease_actor_added", EASE_TYPE_SLIDE_ACTOR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, EASE_TYPE_ACTOR);
}


static void ease_slide_actor_instance_init (EaseSlideActor * self) {
	self->priv = EASE_SLIDE_ACTOR_GET_PRIVATE (self);
}


static void ease_slide_actor_finalize (GObject* obj) {
	EaseSlideActor * self;
	self = EASE_SLIDE_ACTOR (obj);
	_g_object_unref0 (self->background);
	_g_object_unref0 (self->contents);
	_g_object_unref0 (self->priv->_animation_time);
	_g_object_unref0 (self->priv->_animation_alpha);
	_g_object_unref0 (self->priv->time1);
	_g_object_unref0 (self->priv->time2);
	_g_object_unref0 (self->priv->alpha1);
	_g_object_unref0 (self->priv->alpha2);
	G_OBJECT_CLASS (ease_slide_actor_parent_class)->finalize (obj);
}


/**
 * A Clutter actor for a Slide
 *
 * SlideActor is a subclass of Clutter.Group. It is used in both the
 * editor and player, as well as assorted other preview screens.
 */
GType ease_slide_actor_get_type (void) {
	static volatile gsize ease_slide_actor_type_id__volatile = 0;
	if (g_once_init_enter (&ease_slide_actor_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (EaseSlideActorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ease_slide_actor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (EaseSlideActor), 0, (GInstanceInitFunc) ease_slide_actor_instance_init, NULL };
		GType ease_slide_actor_type_id;
		ease_slide_actor_type_id = g_type_register_static (CLUTTER_TYPE_GROUP, "EaseSlideActor", &g_define_type_info, 0);
		g_once_init_leave (&ease_slide_actor_type_id__volatile, ease_slide_actor_type_id);
	}
	return ease_slide_actor_type_id__volatile;
}


static void ease_slide_actor_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	EaseSlideActor * self;
	self = EASE_SLIDE_ACTOR (object);
	switch (property_id) {
		case EASE_SLIDE_ACTOR_SLIDE:
		g_value_set_object (value, ease_slide_actor_get_slide (self));
		break;
		case EASE_SLIDE_ACTOR_ANIMATION_TIME:
		g_value_set_object (value, ease_slide_actor_get_animation_time (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void ease_slide_actor_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	EaseSlideActor * self;
	self = EASE_SLIDE_ACTOR (object);
	switch (property_id) {
		case EASE_SLIDE_ACTOR_SLIDE:
		ease_slide_actor_set_slide (self, g_value_get_object (value));
		break;
		case EASE_SLIDE_ACTOR_ANIMATION_TIME:
		ease_slide_actor_set_animation_time (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}




