/* source-number-item.c generated by valac 0.10.0, the Vala compiler
 * generated from source-number-item.vala, do not modify */

/*
 * Copyright (c) 2010, Nate Stedman <natesm@gmail.com>
 * 
 * Permission to use, copy, modify, and/or distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>


#define SOURCE_TYPE_ITEM (source_item_get_type ())
#define SOURCE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SOURCE_TYPE_ITEM, SourceItem))
#define SOURCE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SOURCE_TYPE_ITEM, SourceItemClass))
#define SOURCE_IS_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SOURCE_TYPE_ITEM))
#define SOURCE_IS_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SOURCE_TYPE_ITEM))
#define SOURCE_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SOURCE_TYPE_ITEM, SourceItemClass))

typedef struct _SourceItem SourceItem;
typedef struct _SourceItemClass SourceItemClass;
typedef struct _SourceItemPrivate SourceItemPrivate;

#define SOURCE_TYPE_NUMBER_ITEM (source_number_item_get_type ())
#define SOURCE_NUMBER_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SOURCE_TYPE_NUMBER_ITEM, SourceNumberItem))
#define SOURCE_NUMBER_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SOURCE_TYPE_NUMBER_ITEM, SourceNumberItemClass))
#define SOURCE_IS_NUMBER_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SOURCE_TYPE_NUMBER_ITEM))
#define SOURCE_IS_NUMBER_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SOURCE_TYPE_NUMBER_ITEM))
#define SOURCE_NUMBER_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SOURCE_TYPE_NUMBER_ITEM, SourceNumberItemClass))

typedef struct _SourceNumberItem SourceNumberItem;
typedef struct _SourceNumberItemClass SourceNumberItemClass;
typedef struct _SourceNumberItemPrivate SourceNumberItemPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _SourceItem {
	GtkHBox parent_instance;
	SourceItemPrivate * priv;
	GtkAlignment* right_align;
	GtkWidget* widget;
};

struct _SourceItemClass {
	GtkHBoxClass parent_class;
};

struct _SourceNumberItem {
	SourceItem parent_instance;
	SourceNumberItemPrivate * priv;
};

struct _SourceNumberItemClass {
	SourceItemClass parent_class;
};

struct _SourceNumberItemPrivate {
	GtkLabel* right_label;
	gint notification_priv;
};


static gpointer source_number_item_parent_class = NULL;

GType source_item_get_type (void) G_GNUC_CONST;
GType source_number_item_get_type (void) G_GNUC_CONST;
#define SOURCE_NUMBER_ITEM_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SOURCE_TYPE_NUMBER_ITEM, SourceNumberItemPrivate))
enum  {
	SOURCE_NUMBER_ITEM_DUMMY_PROPERTY,
	SOURCE_NUMBER_ITEM_NOTIFICATION
};
SourceNumberItem* source_number_item_new (const char* text, GtkImage* img, GtkWidget* widg);
SourceNumberItem* source_number_item_construct (GType object_type, const char* text, GtkImage* img, GtkWidget* widg);
SourceItem* source_item_new (const char* text, GtkImage* img, GtkWidget* widg);
SourceItem* source_item_construct (GType object_type, const char* text, GtkImage* img, GtkWidget* widg);
static void _lambda80_ (SourceItem* _self_, SourceNumberItem* self);
#define SOURCE_ITEM_FORMAT_RIGHT_OLD "<small><b>%i</b></small>"
gint source_number_item_get_notification (SourceNumberItem* self);
static void __lambda80__source_item_clicked (SourceItem* _sender, SourceItem* sender, gpointer self);
SourceNumberItem* source_number_item_new_from_stock_icon (const char* text, const char* item, GtkWidget* widg);
SourceNumberItem* source_number_item_construct_from_stock_icon (GType object_type, const char* text, const char* item, GtkWidget* widg);
#define SOURCE_ITEM_ICON_SIZE GTK_ICON_SIZE_MENU
SourceNumberItem* source_number_item_new_from_stock_text (const char* item, GtkImage* img, GtkWidget* widg);
SourceNumberItem* source_number_item_construct_from_stock_text (GType object_type, const char* item, GtkImage* img, GtkWidget* widg);
SourceNumberItem* source_number_item_new_from_stock (const char* item, GtkWidget* widg);
SourceNumberItem* source_number_item_construct_from_stock (GType object_type, const char* item, GtkWidget* widg);
void source_number_item_set_notification (SourceNumberItem* self, gint value);
gboolean source_item_get_selected (SourceItem* self);
#define SOURCE_ITEM_FORMAT_RIGHT_NEW "<small><b>%i</b></small>"
static void source_number_item_finalize (GObject* obj);
static void source_number_item_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void source_number_item_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);



/**
 * Creates a Source.NumberItem with a customizable icon and text.
 *
 * @param text The text to display in the source item.
 * @param img The image widget to use (note that this icon should use
 * the Gtk.IconSize constant ICON_SIZE to fit in with other items).
 * @param widg The widget that this Source.Item should be linked with.
 * If null, this Source.Item will only emit the clicked signal when 
 * clicked, without any automatic UI changes.
 */
#line 83 "source-number-item.vala"
static void _lambda80_ (SourceItem* _self_, SourceNumberItem* self) {
#line 125 "source-number-item.c"
	char* _tmp0_;
#line 83 "source-number-item.vala"
	g_return_if_fail (_self_ != NULL);
#line 85 "source-number-item.vala"
	gtk_label_set_label (self->priv->right_label, _tmp0_ = g_strdup_printf (SOURCE_ITEM_FORMAT_RIGHT_OLD, source_number_item_get_notification (self)));
#line 131 "source-number-item.c"
	_g_free0 (_tmp0_);
}


#line 83 "source-number-item.vala"
static void __lambda80__source_item_clicked (SourceItem* _sender, SourceItem* sender, gpointer self) {
#line 138 "source-number-item.c"
	_lambda80_ (sender, self);
}


#line 76 "source-number-item.vala"
SourceNumberItem* source_number_item_construct (GType object_type, const char* text, GtkImage* img, GtkWidget* widg) {
#line 145 "source-number-item.c"
	SourceNumberItem * self;
	GtkLabel* _tmp0_;
#line 76 "source-number-item.vala"
	g_return_val_if_fail (text != NULL, NULL);
#line 76 "source-number-item.vala"
	g_return_val_if_fail (img != NULL, NULL);
#line 78 "source-number-item.vala"
	self = (SourceNumberItem*) source_item_construct (object_type, text, img, widg);
#line 80 "source-number-item.vala"
	self->priv->right_label = (_tmp0_ = g_object_ref_sink ((GtkLabel*) gtk_label_new ("")), _g_object_unref0 (self->priv->right_label), _tmp0_);
#line 81 "source-number-item.vala"
	gtk_label_set_use_markup (self->priv->right_label, TRUE);
#line 83 "source-number-item.vala"
	g_signal_connect_object ((SourceItem*) self, "clicked", (GCallback) __lambda80__source_item_clicked, self, 0);
#line 160 "source-number-item.c"
	return self;
}


#line 76 "source-number-item.vala"
SourceNumberItem* source_number_item_new (const char* text, GtkImage* img, GtkWidget* widg) {
#line 76 "source-number-item.vala"
	return source_number_item_construct (SOURCE_TYPE_NUMBER_ITEM, text, img, widg);
#line 169 "source-number-item.c"
}


/**
 * Creates a Source.NumberItem with a stock icon and customizable text.
 *
 * @param text The text to display in the source item.
 * @param item The stock item to take the icon from.
 * @param widg The widget that this Source.Item should be linked with.
 * If null, this Source.Item will only emit the clicked signal when 
 * clicked, without any automatic UI changes.
 */
#line 98 "source-number-item.vala"
SourceNumberItem* source_number_item_construct_from_stock_icon (GType object_type, const char* text, const char* item, GtkWidget* widg) {
#line 184 "source-number-item.c"
	SourceNumberItem * self;
	GtkImage* _tmp0_;
#line 98 "source-number-item.vala"
	g_return_val_if_fail (text != NULL, NULL);
#line 98 "source-number-item.vala"
	g_return_val_if_fail (item != NULL, NULL);
#line 101 "source-number-item.vala"
	self = (SourceNumberItem*) source_number_item_construct (object_type, text, _tmp0_ = g_object_ref_sink ((GtkImage*) gtk_image_new_from_stock (item, SOURCE_ITEM_ICON_SIZE)), widg);
#line 193 "source-number-item.c"
	_g_object_unref0 (_tmp0_);
	return self;
}


#line 98 "source-number-item.vala"
SourceNumberItem* source_number_item_new_from_stock_icon (const char* text, const char* item, GtkWidget* widg) {
#line 98 "source-number-item.vala"
	return source_number_item_construct_from_stock_icon (SOURCE_TYPE_NUMBER_ITEM, text, item, widg);
#line 203 "source-number-item.c"
}


/**
 * Creates a Source.NumberItem with a stock icon and customizable text.
 *
 * @param text The text to display in the source item.
 * @param item The stock item to take the label from.
 * @param img The image widget to use (note that this icon should use
 * the Gtk.IconSize constant ICON_SIZE to fit in with other items).
 * @param widg The widget that this Source.Item should be linked with.
 * If null, this Source.Item will only emit the clicked signal when 
 * clicked, without any automatic UI changes.
 */
#line 1157 "glib-2.0.vapi"
static char* string_replace (const char* self, const char* old, const char* replacement) {
#line 220 "source-number-item.c"
	char* result = NULL;
	GError * _inner_error_ = NULL;
#line 1157 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1157 "glib-2.0.vapi"
	g_return_val_if_fail (old != NULL, NULL);
#line 1157 "glib-2.0.vapi"
	g_return_val_if_fail (replacement != NULL, NULL);
#line 229 "source-number-item.c"
	{
		char* _tmp0_;
		GRegex* _tmp1_;
		GRegex* regex;
		char* _tmp2_;
#line 1159 "glib-2.0.vapi"
		regex = (_tmp1_ = g_regex_new (_tmp0_ = g_regex_escape_string (old, -1), 0, 0, &_inner_error_), _g_free0 (_tmp0_), _tmp1_);
#line 237 "source-number-item.c"
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch40_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
#line 1160 "glib-2.0.vapi"
		_tmp2_ = g_regex_replace_literal (regex, self, (gssize) (-1), 0, replacement, 0, &_inner_error_);
#line 248 "source-number-item.c"
		if (_inner_error_ != NULL) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch40_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		result = _tmp2_;
		_g_regex_unref0 (regex);
#line 1160 "glib-2.0.vapi"
		return result;
#line 263 "source-number-item.c"
	}
	goto __finally40;
	__catch40_g_regex_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
#line 1162 "glib-2.0.vapi"
			g_assert_not_reached ();
#line 274 "source-number-item.c"
			_g_error_free0 (e);
		}
	}
	__finally40:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


#line 115 "source-number-item.vala"
SourceNumberItem* source_number_item_construct_from_stock_text (GType object_type, const char* item, GtkImage* img, GtkWidget* widg) {
#line 289 "source-number-item.c"
	SourceNumberItem * self;
	GtkStockItem stock = {0};
#line 115 "source-number-item.vala"
	g_return_val_if_fail (item != NULL, NULL);
#line 115 "source-number-item.vala"
	g_return_val_if_fail (img != NULL, NULL);
#line 296 "source-number-item.c"
	memset (&stock, 0, sizeof (GtkStockItem));
#line 119 "source-number-item.vala"
	if (gtk_stock_lookup (item, &stock)) {
#line 300 "source-number-item.c"
		char* _tmp0_;
#line 121 "source-number-item.vala"
		self = (SourceNumberItem*) source_number_item_construct (object_type, _tmp0_ = string_replace (stock.label, "_", ""), img, widg);
#line 304 "source-number-item.c"
		_g_free0 (_tmp0_);
	}
	return self;
}


#line 115 "source-number-item.vala"
SourceNumberItem* source_number_item_new_from_stock_text (const char* item, GtkImage* img, GtkWidget* widg) {
#line 115 "source-number-item.vala"
	return source_number_item_construct_from_stock_text (SOURCE_TYPE_NUMBER_ITEM, item, img, widg);
#line 315 "source-number-item.c"
}


/**
 * Creates a Source.NumberItem with a stock icon and text.
 *
 * @param item The stock item to take the icon and text from.
 * @param widg The widget that this Source.Item should be linked with.
 * If null, this Source.Item will only emit the clicked signal when 
 * clicked, without any automatic UI changes.
 */
#line 133 "source-number-item.vala"
SourceNumberItem* source_number_item_construct_from_stock (GType object_type, const char* item, GtkWidget* widg) {
#line 329 "source-number-item.c"
	SourceNumberItem * self;
	GtkStockItem stock = {0};
#line 133 "source-number-item.vala"
	g_return_val_if_fail (item != NULL, NULL);
#line 334 "source-number-item.c"
	memset (&stock, 0, sizeof (GtkStockItem));
#line 136 "source-number-item.vala"
	if (gtk_stock_lookup (item, &stock)) {
#line 338 "source-number-item.c"
		char* _tmp0_;
		GtkImage* _tmp1_;
#line 138 "source-number-item.vala"
		self = (SourceNumberItem*) source_number_item_construct (object_type, _tmp0_ = string_replace (stock.label, "_", ""), _tmp1_ = g_object_ref_sink ((GtkImage*) gtk_image_new_from_stock (item, SOURCE_ITEM_ICON_SIZE)), widg);
#line 343 "source-number-item.c"
		_g_object_unref0 (_tmp1_);
		_g_free0 (_tmp0_);
	}
	return self;
}


#line 133 "source-number-item.vala"
SourceNumberItem* source_number_item_new_from_stock (const char* item, GtkWidget* widg) {
#line 133 "source-number-item.vala"
	return source_number_item_construct_from_stock (SOURCE_TYPE_NUMBER_ITEM, item, widg);
#line 355 "source-number-item.c"
}


gint source_number_item_get_notification (SourceNumberItem* self) {
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->notification_priv;
#line 33 "source-number-item.vala"
	return result;
#line 365 "source-number-item.c"
}


void source_number_item_set_notification (SourceNumberItem* self, gint value) {
	const char* _tmp0_;
	char* _tmp1_;
	g_return_if_fail (self != NULL);
#line 36 "source-number-item.vala"
	if (value == self->priv->notification_priv) {
#line 36 "source-number-item.vala"
		return;
#line 377 "source-number-item.c"
	}
#line 39 "source-number-item.vala"
	if (value == 0) {
#line 42 "source-number-item.vala"
		gtk_container_remove ((GtkContainer*) ((SourceItem*) self)->right_align, (GtkWidget*) self->priv->right_label);
#line 383 "source-number-item.c"
	}
	_tmp0_ = NULL;
#line 46 "source-number-item.vala"
	if (source_item_get_selected ((SourceItem*) self)) {
#line 47 "source-number-item.vala"
		_tmp0_ = SOURCE_ITEM_FORMAT_RIGHT_OLD;
#line 390 "source-number-item.c"
	} else {
#line 48 "source-number-item.vala"
		_tmp0_ = SOURCE_ITEM_FORMAT_RIGHT_NEW;
#line 394 "source-number-item.c"
	}
#line 46 "source-number-item.vala"
	gtk_label_set_label (self->priv->right_label, _tmp1_ = g_strdup_printf (_tmp0_, value));
#line 398 "source-number-item.c"
	_g_free0 (_tmp1_);
#line 51 "source-number-item.vala"
	if (self->priv->notification_priv == 0) {
#line 53 "source-number-item.vala"
		gtk_container_add ((GtkContainer*) ((SourceItem*) self)->right_align, (GtkWidget*) self->priv->right_label);
#line 404 "source-number-item.c"
	}
#line 57 "source-number-item.vala"
	self->priv->notification_priv = value;
#line 408 "source-number-item.c"
	g_object_notify ((GObject *) self, "notification");
}


static void source_number_item_class_init (SourceNumberItemClass * klass) {
	source_number_item_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SourceNumberItemPrivate));
	G_OBJECT_CLASS (klass)->get_property = source_number_item_get_property;
	G_OBJECT_CLASS (klass)->set_property = source_number_item_set_property;
	G_OBJECT_CLASS (klass)->finalize = source_number_item_finalize;
	/**
	 * A number, displayed on the righthand side of the Source.Item. If
	 * notification is 0, the label is not displayed.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SOURCE_NUMBER_ITEM_NOTIFICATION, g_param_spec_int ("notification", "notification", "notification", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void source_number_item_instance_init (SourceNumberItem * self) {
	self->priv = SOURCE_NUMBER_ITEM_GET_PRIVATE (self);
	self->priv->notification_priv = 0;
}


static void source_number_item_finalize (GObject* obj) {
	SourceNumberItem * self;
	self = SOURCE_NUMBER_ITEM (obj);
	_g_object_unref0 (self->priv->right_label);
	G_OBJECT_CLASS (source_number_item_parent_class)->finalize (obj);
}


/**
 * A {@link Item} that can display a number on the right side.
 */
GType source_number_item_get_type (void) {
	static volatile gsize source_number_item_type_id__volatile = 0;
	if (g_once_init_enter (&source_number_item_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SourceNumberItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) source_number_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SourceNumberItem), 0, (GInstanceInitFunc) source_number_item_instance_init, NULL };
		GType source_number_item_type_id;
		source_number_item_type_id = g_type_register_static (SOURCE_TYPE_ITEM, "SourceNumberItem", &g_define_type_info, 0);
		g_once_init_leave (&source_number_item_type_id__volatile, source_number_item_type_id);
	}
	return source_number_item_type_id__volatile;
}


static void source_number_item_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SourceNumberItem * self;
	self = SOURCE_NUMBER_ITEM (object);
	switch (property_id) {
		case SOURCE_NUMBER_ITEM_NOTIFICATION:
		g_value_set_int (value, source_number_item_get_notification (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void source_number_item_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	SourceNumberItem * self;
	self = SOURCE_NUMBER_ITEM (object);
	switch (property_id) {
		case SOURCE_NUMBER_ITEM_NOTIFICATION:
		source_number_item_set_notification (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}




