/* ease-archiver.c generated by valac 0.10.0, the Vala compiler
 * generated from ease-archiver.vala, do not modify */

/*  Ease, a GTK presentation application
    Copyright (C) 2010 Nate Stedman

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <glib/gi18n-lib.h>
#include <sys/stat.h>
#include <archive.h>
#include <archive_entry.h>
#include <sys/types.h>
#include <float.h>
#include <math.h>
#include <fcntl.h>
#include <unistd.h>
#include <gtk/gtk.h>
#include <gio/gio.h>


#define EASE_ARCHIVER_TYPE_ARCHIVER (ease_archiver_archiver_get_type ())
#define EASE_ARCHIVER_ARCHIVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_ARCHIVER_TYPE_ARCHIVER, EaseArchiverArchiver))
#define EASE_ARCHIVER_ARCHIVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_ARCHIVER_TYPE_ARCHIVER, EaseArchiverArchiverClass))
#define EASE_ARCHIVER_IS_ARCHIVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_ARCHIVER_TYPE_ARCHIVER))
#define EASE_ARCHIVER_IS_ARCHIVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_ARCHIVER_TYPE_ARCHIVER))
#define EASE_ARCHIVER_ARCHIVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_ARCHIVER_TYPE_ARCHIVER, EaseArchiverArchiverClass))

typedef struct _EaseArchiverArchiver EaseArchiverArchiver;
typedef struct _EaseArchiverArchiverClass EaseArchiverArchiverClass;
typedef struct _EaseArchiverArchiverPrivate EaseArchiverArchiverPrivate;

#define EASE_DIALOG_TYPE_PROGRESS (ease_dialog_progress_get_type ())
#define EASE_DIALOG_PROGRESS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EASE_DIALOG_TYPE_PROGRESS, EaseDialogProgress))
#define EASE_DIALOG_PROGRESS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EASE_DIALOG_TYPE_PROGRESS, EaseDialogProgressClass))
#define EASE_DIALOG_IS_PROGRESS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EASE_DIALOG_TYPE_PROGRESS))
#define EASE_DIALOG_IS_PROGRESS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EASE_DIALOG_TYPE_PROGRESS))
#define EASE_DIALOG_PROGRESS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EASE_DIALOG_TYPE_PROGRESS, EaseDialogProgressClass))

typedef struct _EaseDialogProgress EaseDialogProgress;
typedef struct _EaseDialogProgressClass EaseDialogProgressClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block2Data Block2Data;
#define _g_dir_close0(var) ((var == NULL) ? NULL : (var = (g_dir_close (var), NULL)))
#define _archive_entry_free0(var) ((var == NULL) ? NULL : (var = (archive_entry_free (var), NULL)))
#define _archive_write_finish0(var) ((var == NULL) ? NULL : (var = (archive_write_finish (var), NULL)))
typedef struct _Block3Data Block3Data;
#define _archive_read_finish0(var) ((var == NULL) ? NULL : (var = (archive_read_finish (var), NULL)))

struct _EaseArchiverArchiver {
	GObject parent_instance;
	EaseArchiverArchiverPrivate * priv;
};

struct _EaseArchiverArchiverClass {
	GObjectClass parent_class;
};

struct _EaseArchiverArchiverPrivate {
	char* temp_path;
	char* filename;
	EaseDialogProgress* dialog;
	GStaticRecMutex __lock_dialog;
	GThread* thread;
	gboolean async;
	gint total_size;
	GeeLinkedList* include_files;
};

typedef void (*EaseRecursiveDirAction) (const char* path, const char* full_path, void* user_data, GError** error);
struct _Block2Data {
	int _ref_count_;
	EaseArchiverArchiver * self;
	GeeLinkedList* files;
};

struct _Block3Data {
	int _ref_count_;
	EaseArchiverArchiver * self;
	struct archive* archive;
	gchar* buffer;
	gint buffer_length1;
	gint _buffer_size_;
};


static GList* ease_archiver_archiver_archivers;
static GStaticRecMutex __lock_ease_archiver_archiver_archivers = {0};
static GList* ease_archiver_archiver_archivers = NULL;
static gpointer ease_archiver_archiver_parent_class = NULL;

GType ease_archiver_archiver_get_type (void) G_GNUC_CONST;
GType ease_dialog_progress_get_type (void) G_GNUC_CONST;
#define EASE_ARCHIVER_ARCHIVER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), EASE_ARCHIVER_TYPE_ARCHIVER, EaseArchiverArchiverPrivate))
enum  {
	EASE_ARCHIVER_ARCHIVER_DUMMY_PROPERTY
};
#define EASE_ARCHIVER_ARCHIVER_LABEL_TEXT _ ("Saving \"%s\"")
#define EASE_ARCHIVER_ARCHIVER_ASYNC_SIZE ((1024 * 1024) * 5)
EaseArchiverArchiver* ease_archiver_archiver_new (const char* temp, const char* fname, GeeLinkedList* files, EaseDialogProgress* dlog);
EaseArchiverArchiver* ease_archiver_archiver_construct (GType object_type, const char* temp, const char* fname, GeeLinkedList* files, EaseDialogProgress* dlog);
void ease_recursive_directory (const char* directory, EaseRecursiveDirAction directory_action, void* directory_action_target, EaseRecursiveDirAction file_action, void* file_action_target, GError** error);
static void _lambda62_ (const char* path, const char* full_path, Block2Data* _data2_, GError** error);
static void __lambda62__ease_recursive_dir_action (const char* path, const char* full_path, gpointer self, GError** error);
static void* ease_archiver_archiver_archive_real (EaseArchiverArchiver* self);
void ease_dialog_progress_set_label (EaseDialogProgress* self, const char* str);
void ease_dialog_progress_show (EaseDialogProgress* self);
static void* _ease_archiver_archiver_archive_real_gthread_func (gpointer self);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (Block2Data* _data2_);
#define EASE_ARCHIVER_ARCHIVE_BUFFER 4096
static void _lambda63_ (const char* path, const char* full_path, Block3Data* _data3_, GError** error);
static void ease_archiver_archiver_arc_fail (int _result_, struct archive* archive);
void ease_dialog_progress_add_fraction (EaseDialogProgress* self, double val);
static void __lambda63__ease_recursive_dir_action (const char* path, const char* full_path, gpointer self, GError** error);
void ease_dialog_progress_destroy (EaseDialogProgress* self);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (Block3Data* _data3_);
static void ease_archiver_archiver_finalize (GObject* obj);
void ease_archiver_create (const char* temp_path, const char* filename, const char* title, GeeLinkedList* files, GtkWindow* win, GError** error);
EaseDialogProgress* ease_dialog_progress_new_with_image (const char* title, gboolean cancellable, double max, GtkWindow* modal, GtkImage* image);
EaseDialogProgress* ease_dialog_progress_construct_with_image (GType object_type, const char* title, gboolean cancellable, double max, GtkWindow* modal, GtkImage* image);
char* ease_archiver_extract (const char* filename, GError** error);
char* ease_temp_request (GError** error);



static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


#line 46 "ease-archiver.vala"
static void _lambda62_ (const char* path, const char* full_path, Block2Data* _data2_, GError** error) {
#line 154 "ease-archiver.c"
	EaseArchiverArchiver * self;
	struct stat st = {0};
	self = _data2_->self;
#line 46 "ease-archiver.vala"
	g_return_if_fail (path != NULL);
#line 46 "ease-archiver.vala"
	g_return_if_fail (full_path != NULL);
#line 48 "ease-archiver.vala"
	if (!gee_abstract_collection_contains ((GeeAbstractCollection*) _data2_->files, path)) {
#line 48 "ease-archiver.vala"
		return;
#line 166 "ease-archiver.c"
	}
#line 52 "ease-archiver.vala"
	stat (full_path, &st);
#line 53 "ease-archiver.vala"
	self->priv->total_size = self->priv->total_size + ((gint) st.st_size);
#line 172 "ease-archiver.c"
}


#line 46 "ease-archiver.vala"
static void __lambda62__ease_recursive_dir_action (const char* path, const char* full_path, gpointer self, GError** error) {
#line 178 "ease-archiver.c"
	_lambda62_ (path, full_path, self, error);
}


#line 75 "ease-archiver.vala"
static void* _ease_archiver_archiver_archive_real_gthread_func (gpointer self) {
#line 185 "ease-archiver.c"
	void* result;
	result = ease_archiver_archiver_archive_real (self);
	return result;
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}


static void block2_data_unref (Block2Data* _data2_) {
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		_g_object_unref0 (_data2_->self);
		_g_object_unref0 (_data2_->files);
		g_slice_free (Block2Data, _data2_);
	}
}


#line 36 "ease-archiver.vala"
EaseArchiverArchiver* ease_archiver_archiver_construct (GType object_type, const char* temp, const char* fname, GeeLinkedList* files, EaseDialogProgress* dlog) {
#line 209 "ease-archiver.c"
	EaseArchiverArchiver * self;
	Block2Data* _data2_;
	char* _tmp0_;
	char* _tmp1_;
	EaseDialogProgress* _tmp2_;
	GeeLinkedList* _tmp3_;
	gboolean _tmp4_ = FALSE;
	char* _tmp5_;
	GThread* _tmp6_;
	GError * _inner_error_ = NULL;
#line 36 "ease-archiver.vala"
	g_return_val_if_fail (temp != NULL, NULL);
#line 36 "ease-archiver.vala"
	g_return_val_if_fail (fname != NULL, NULL);
#line 36 "ease-archiver.vala"
	g_return_val_if_fail (files != NULL, NULL);
#line 36 "ease-archiver.vala"
	g_return_val_if_fail (dlog != NULL, NULL);
#line 228 "ease-archiver.c"
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->files = _g_object_ref0 (files);
#line 36 "ease-archiver.vala"
	_data2_->self = g_object_ref (self = (EaseArchiverArchiver*) g_object_new (object_type, NULL));
#line 39 "ease-archiver.vala"
	self->priv->temp_path = (_tmp0_ = g_strdup (temp), _g_free0 (self->priv->temp_path), _tmp0_);
#line 40 "ease-archiver.vala"
	self->priv->filename = (_tmp1_ = g_strdup (fname), _g_free0 (self->priv->filename), _tmp1_);
#line 41 "ease-archiver.vala"
	self->priv->dialog = (_tmp2_ = _g_object_ref0 (dlog), _g_object_unref0 (self->priv->dialog), _tmp2_);
#line 42 "ease-archiver.vala"
	self->priv->include_files = (_tmp3_ = _g_object_ref0 (_data2_->files), _g_object_unref0 (self->priv->include_files), _tmp3_);
#line 43 "ease-archiver.vala"
	ease_archiver_archiver_archivers = g_list_append (ease_archiver_archiver_archivers, _g_object_ref0 (self));
#line 46 "ease-archiver.vala"
	ease_recursive_directory (self->priv->temp_path, NULL, NULL, __lambda62__ease_recursive_dir_action, _data2_, &_inner_error_);
#line 246 "ease-archiver.c"
	if (_inner_error_ != NULL) {
		block2_data_unref (_data2_);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
#line 56 "ease-archiver.vala"
	if (!g_thread_supported ()) {
#line 56 "ease-archiver.vala"
		_tmp4_ = TRUE;
#line 257 "ease-archiver.c"
	} else {
#line 56 "ease-archiver.vala"
		_tmp4_ = self->priv->total_size < EASE_ARCHIVER_ARCHIVER_ASYNC_SIZE;
#line 261 "ease-archiver.c"
	}
#line 56 "ease-archiver.vala"
	if (_tmp4_) {
#line 59 "ease-archiver.vala"
		self->priv->async = FALSE;
#line 60 "ease-archiver.vala"
		ease_archiver_archiver_archive_real (self);
#line 269 "ease-archiver.c"
		block2_data_unref (_data2_);
#line 61 "ease-archiver.vala"
		return self;
#line 273 "ease-archiver.c"
	}
#line 65 "ease-archiver.vala"
	ease_dialog_progress_set_label (self->priv->dialog, _tmp5_ = g_strdup_printf (EASE_ARCHIVER_ARCHIVER_LABEL_TEXT, self->priv->filename));
#line 277 "ease-archiver.c"
	_g_free0 (_tmp5_);
#line 66 "ease-archiver.vala"
	ease_dialog_progress_show (self->priv->dialog);
#line 69 "ease-archiver.vala"
	_tmp6_ = g_thread_create (_ease_archiver_archiver_archive_real_gthread_func, self, TRUE, &_inner_error_);
#line 283 "ease-archiver.c"
	if (_inner_error_ != NULL) {
		block2_data_unref (_data2_);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
#line 69 "ease-archiver.vala"
	self->priv->thread = _tmp6_;
#line 292 "ease-archiver.c"
	block2_data_unref (_data2_);
	return self;
}


#line 36 "ease-archiver.vala"
EaseArchiverArchiver* ease_archiver_archiver_new (const char* temp, const char* fname, GeeLinkedList* files, EaseDialogProgress* dlog) {
#line 36 "ease-archiver.vala"
	return ease_archiver_archiver_construct (EASE_ARCHIVER_TYPE_ARCHIVER, temp, fname, files, dlog);
#line 302 "ease-archiver.c"
}


/**
 * Does the actual archiving of a directory.
 */
#line 102 "ease-archiver.vala"
static void _lambda63_ (const char* path, const char* full_path, Block3Data* _data3_, GError** error) {
#line 311 "ease-archiver.c"
	EaseArchiverArchiver * self;
	struct archive_entry* entry;
	struct stat st = {0};
	double size;
	double size_frac;
	gint fd;
	gssize len;
	GError * _inner_error_ = NULL;
	self = _data3_->self;
#line 102 "ease-archiver.vala"
	g_return_if_fail (path != NULL);
#line 102 "ease-archiver.vala"
	g_return_if_fail (full_path != NULL);
#line 104 "ease-archiver.vala"
	if (!gee_abstract_collection_contains ((GeeAbstractCollection*) self->priv->include_files, path)) {
#line 104 "ease-archiver.vala"
		return;
#line 329 "ease-archiver.c"
	}
#line 107 "ease-archiver.vala"
	entry = archive_entry_new ();
#line 108 "ease-archiver.vala"
	archive_entry_set_pathname (entry, path);
#line 109 "ease-archiver.vala"
	archive_entry_set_perm (entry, (mode_t) 0644);
#line 111 "ease-archiver.vala"
	stat (full_path, &st);
#line 112 "ease-archiver.vala"
	archive_entry_copy_stat (entry, &st);
#line 113 "ease-archiver.vala"
	ease_archiver_archiver_arc_fail (archive_write_header (_data3_->archive, entry), _data3_->archive);
#line 115 "ease-archiver.vala"
	size = (double) st.st_size;
#line 116 "ease-archiver.vala"
	size_frac = size / self->priv->total_size;
#line 119 "ease-archiver.vala"
	fd = open (full_path, O_RDONLY, 0);
#line 120 "ease-archiver.vala"
	len = read (fd, _data3_->buffer, (gsize) (sizeof (gchar) * EASE_ARCHIVER_ARCHIVE_BUFFER));
#line 121 "ease-archiver.vala"
	while (TRUE) {
#line 121 "ease-archiver.vala"
		if (!(len > 0)) {
#line 121 "ease-archiver.vala"
			break;
#line 357 "ease-archiver.c"
		}
#line 123 "ease-archiver.vala"
		archive_write_data (_data3_->archive, _data3_->buffer, (gsize) len);
#line 124 "ease-archiver.vala"
		len = read (fd, _data3_->buffer, (gsize) (sizeof (gchar) * EASE_ARCHIVER_ARCHIVE_BUFFER));
#line 363 "ease-archiver.c"
		{
			g_static_rec_mutex_lock (&self->priv->__lock_dialog);
			{
#line 125 "ease-archiver.vala"
				ease_dialog_progress_add_fraction (self->priv->dialog, size_frac * (len / size));
#line 369 "ease-archiver.c"
			}
			__finally0:
			{
				g_static_rec_mutex_unlock (&self->priv->__lock_dialog);
			}
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				_archive_entry_free0 (entry);
				return;
			}
		}
	}
#line 127 "ease-archiver.vala"
	close (fd);
#line 128 "ease-archiver.vala"
	ease_archiver_archiver_arc_fail (archive_write_finish_entry (_data3_->archive), _data3_->archive);
#line 386 "ease-archiver.c"
	_archive_entry_free0 (entry);
}


#line 102 "ease-archiver.vala"
static void __lambda63__ease_recursive_dir_action (const char* path, const char* full_path, gpointer self, GError** error) {
#line 393 "ease-archiver.c"
	_lambda63_ (path, full_path, self, error);
}


static Block3Data* block3_data_ref (Block3Data* _data3_) {
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}


static void block3_data_unref (Block3Data* _data3_) {
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		_g_object_unref0 (_data3_->self);
		_data3_->buffer = (g_free (_data3_->buffer), NULL);
		_archive_write_finish0 (_data3_->archive);
		g_slice_free (Block3Data, _data3_);
	}
}


#line 75 "ease-archiver.vala"
static void* ease_archiver_archiver_archive_real (EaseArchiverArchiver* self) {
#line 416 "ease-archiver.c"
	void* result = NULL;
	Block3Data* _data3_;
	gchar* _tmp0_;
	GDir* dir;
	GError * _inner_error_ = NULL;
#line 75 "ease-archiver.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 424 "ease-archiver.c"
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	_data3_->self = g_object_ref (self);
	_data3_->archive = archive_write_new ();
	_data3_->buffer = (_tmp0_ = g_new0 (gchar, EASE_ARCHIVER_ARCHIVE_BUFFER), _data3_->buffer_length1 = EASE_ARCHIVER_ARCHIVE_BUFFER, _tmp0_);
#line 82 "ease-archiver.vala"
	archive_write_set_format_pax_restricted (_data3_->archive);
#line 83 "ease-archiver.vala"
	archive_write_set_compression_none (_data3_->archive);
#line 86 "ease-archiver.vala"
	if (archive_write_open_filename (_data3_->archive, self->priv->filename) == ARCHIVE_FAILED) {
#line 436 "ease-archiver.c"
		_inner_error_ = g_error_new ((GQuark) 0, 0, "Error opening %s", self->priv->filename);
		{
			block3_data_unref (_data3_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
#line 92 "ease-archiver.vala"
	dir = g_dir_open (self->priv->temp_path, (guint) 0, &_inner_error_);
#line 447 "ease-archiver.c"
	if (_inner_error_ != NULL) {
		block3_data_unref (_data3_);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
#line 95 "ease-archiver.vala"
	if (dir == NULL) {
#line 456 "ease-archiver.c"
		_inner_error_ = g_error_new (G_FILE_ERROR, G_FILE_ERROR_NOENT, _ ("Temporary directory doesn't exist: %s"), self->priv->temp_path);
		{
			_g_dir_close0 (dir);
			block3_data_unref (_data3_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
#line 102 "ease-archiver.vala"
	ease_recursive_directory (self->priv->temp_path, NULL, NULL, __lambda63__ease_recursive_dir_action, _data3_, &_inner_error_);
#line 468 "ease-archiver.c"
	if (_inner_error_ != NULL) {
		_g_dir_close0 (dir);
		block3_data_unref (_data3_);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
#line 132 "ease-archiver.vala"
	ease_archiver_archiver_arc_fail (archive_write_close (_data3_->archive), _data3_->archive);
#line 478 "ease-archiver.c"
	{
		g_static_rec_mutex_lock (&self->priv->__lock_dialog);
		{
#line 135 "ease-archiver.vala"
			if (self->priv->async) {
#line 135 "ease-archiver.vala"
				ease_dialog_progress_destroy (self->priv->dialog);
#line 486 "ease-archiver.c"
			}
		}
		__finally1:
		{
			g_static_rec_mutex_unlock (&self->priv->__lock_dialog);
		}
		if (_inner_error_ != NULL) {
			_g_dir_close0 (dir);
			block3_data_unref (_data3_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	{
		g_static_rec_mutex_lock (&__lock_ease_archiver_archiver_archivers);
		{
#line 138 "ease-archiver.vala"
			ease_archiver_archiver_archivers = g_list_remove (ease_archiver_archiver_archivers, self);
#line 506 "ease-archiver.c"
		}
		__finally2:
		{
			g_static_rec_mutex_unlock (&__lock_ease_archiver_archiver_archivers);
		}
		if (_inner_error_ != NULL) {
			_g_dir_close0 (dir);
			block3_data_unref (_data3_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = NULL;
	_g_dir_close0 (dir);
	block3_data_unref (_data3_);
#line 140 "ease-archiver.vala"
	return result;
#line 525 "ease-archiver.c"
}


/**
 * Produces an error if a libarchive error occurs.
 */
#line 146 "ease-archiver.vala"
static void ease_archiver_archiver_arc_fail (int _result_, struct archive* archive) {
#line 146 "ease-archiver.vala"
	g_return_if_fail (archive != NULL);
#line 148 "ease-archiver.vala"
	if (_result_ != ARCHIVE_OK) {
#line 148 "ease-archiver.vala"
		g_critical ("ease-archiver.vala:148: %s", archive_error_string (archive));
#line 540 "ease-archiver.c"
	}
}


static void ease_archiver_archiver_class_init (EaseArchiverArchiverClass * klass) {
	ease_archiver_archiver_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (EaseArchiverArchiverPrivate));
	G_OBJECT_CLASS (klass)->finalize = ease_archiver_archiver_finalize;
	g_static_rec_mutex_init (&__lock_ease_archiver_archiver_archivers);
}


static void ease_archiver_archiver_instance_init (EaseArchiverArchiver * self) {
	self->priv = EASE_ARCHIVER_ARCHIVER_GET_PRIVATE (self);
	g_static_rec_mutex_init (&self->priv->__lock_dialog);
	self->priv->async = TRUE;
	self->priv->total_size = 0;
}


static void ease_archiver_archiver_finalize (GObject* obj) {
	EaseArchiverArchiver * self;
	self = EASE_ARCHIVER_ARCHIVER (obj);
	_g_free0 (self->priv->temp_path);
	_g_free0 (self->priv->filename);
	g_static_rec_mutex_free (&self->priv->__lock_dialog);
	_g_object_unref0 (self->priv->dialog);
	_g_object_unref0 (self->priv->include_files);
	G_OBJECT_CLASS (ease_archiver_archiver_parent_class)->finalize (obj);
}


GType ease_archiver_archiver_get_type (void) {
	static volatile gsize ease_archiver_archiver_type_id__volatile = 0;
	if (g_once_init_enter (&ease_archiver_archiver_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (EaseArchiverArchiverClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ease_archiver_archiver_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (EaseArchiverArchiver), 0, (GInstanceInitFunc) ease_archiver_archiver_instance_init, NULL };
		GType ease_archiver_archiver_type_id;
		ease_archiver_archiver_type_id = g_type_register_static (G_TYPE_OBJECT, "EaseArchiverArchiver", &g_define_type_info, 0);
		g_once_init_leave (&ease_archiver_archiver_type_id__volatile, ease_archiver_archiver_type_id);
	}
	return ease_archiver_archiver_type_id__volatile;
}


/**
 * Asynchronously (if supported) creates an archive from a temporary
 * directory. Otherwise, falls back on synchronous archiving.
 *
 * archive() uses libarchive to create a tarball of the temporary directory.
 *
 * @param temp_path The path of the temporary directory.
 * @param filename The filename of the archive to save to.
 * @param title The title of the progress dialog.
 * @param files The files to include in the archive.
 * @param win The window to display a progress dialog modal for.
 */
#line 168 "ease-archiver.vala"
void ease_archiver_create (const char* temp_path, const char* filename, const char* title, GeeLinkedList* files, GtkWindow* win, GError** error) {
#line 599 "ease-archiver.c"
	GtkImage* img;
	EaseDialogProgress* dialog;
	EaseArchiverArchiver* arc;
#line 168 "ease-archiver.vala"
	g_return_if_fail (temp_path != NULL);
#line 168 "ease-archiver.vala"
	g_return_if_fail (filename != NULL);
#line 168 "ease-archiver.vala"
	g_return_if_fail (title != NULL);
#line 168 "ease-archiver.vala"
	g_return_if_fail (files != NULL);
#line 175 "ease-archiver.vala"
	img = g_object_ref_sink ((GtkImage*) gtk_image_new_from_stock ("gtk-save", GTK_ICON_SIZE_LARGE_TOOLBAR));
#line 177 "ease-archiver.vala"
	dialog = ease_dialog_progress_new_with_image (title, FALSE, (double) 1, win, img);
#line 180 "ease-archiver.vala"
	arc = ease_archiver_archiver_new (temp_path, filename, files, dialog);
#line 617 "ease-archiver.c"
	_g_object_unref0 (arc);
	_g_object_unref0 (dialog);
	_g_object_unref0 (img);
}


/**
 * Creates a temporary directory and extracts an archive to it.
 *
 * extract() uses libarchive for extraction. It will automatically request
 * a new temporary directory, extract the archive, and return the path
 * to the extracted files.
 *
 * @param filename The path of the archive to extract.
 */
#line 192 "ease-archiver.vala"
char* ease_archiver_extract (const char* filename, GError** error) {
#line 635 "ease-archiver.c"
	char* result = NULL;
	struct archive* archive;
	char* path;
	struct archive_entry* entry;
	GError * _inner_error_ = NULL;
#line 192 "ease-archiver.vala"
	g_return_val_if_fail (filename != NULL, NULL);
#line 195 "ease-archiver.vala"
	archive = archive_read_new ();
#line 198 "ease-archiver.vala"
	archive_read_support_compression_all (archive);
#line 199 "ease-archiver.vala"
	archive_read_support_format_all (archive);
#line 202 "ease-archiver.vala"
	archive_read_open_filename (archive, filename, (gsize) EASE_ARCHIVER_ARCHIVE_BUFFER);
#line 205 "ease-archiver.vala"
	path = ease_temp_request (&_inner_error_);
#line 653 "ease-archiver.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_archive_read_finish0 (archive);
		return NULL;
	}
	entry = NULL;
#line 209 "ease-archiver.vala"
	while (TRUE) {
#line 662 "ease-archiver.c"
		char* fpath;
		GFile* file;
#line 209 "ease-archiver.vala"
		if (!(archive_read_next_header (archive, &entry) == ARCHIVE_OK)) {
#line 209 "ease-archiver.vala"
			break;
#line 669 "ease-archiver.c"
		}
#line 211 "ease-archiver.vala"
		fpath = g_build_filename (path, archive_entry_pathname (entry), NULL);
#line 212 "ease-archiver.vala"
		file = g_file_new_for_path (fpath);
#line 214 "ease-archiver.vala"
		if (S_ISDIR (archive_entry_mode (entry))) {
#line 216 "ease-archiver.vala"
			g_file_make_directory_with_parents (file, NULL, &_inner_error_);
#line 679 "ease-archiver.c"
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (file);
				_g_free0 (fpath);
				_g_free0 (path);
				_archive_read_finish0 (archive);
				return NULL;
			}
		} else {
			GFile* parent;
			GFileOutputStream* _tmp0_;
			gint fd;
#line 220 "ease-archiver.vala"
			parent = g_file_get_parent (file);
#line 221 "ease-archiver.vala"
			if (!g_file_query_exists (parent, NULL)) {
#line 223 "ease-archiver.vala"
				g_file_make_directory_with_parents (parent, NULL, &_inner_error_);
#line 698 "ease-archiver.c"
				if (_inner_error_ != NULL) {
					g_propagate_error (error, _inner_error_);
					_g_object_unref0 (parent);
					_g_object_unref0 (file);
					_g_free0 (fpath);
					_g_free0 (path);
					_archive_read_finish0 (archive);
					return NULL;
				}
			}
#line 226 "ease-archiver.vala"
			_tmp0_ = g_file_create (file, G_FILE_CREATE_REPLACE_DESTINATION, NULL, &_inner_error_);
#line 711 "ease-archiver.c"
			_g_object_unref0 (_tmp0_);
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (parent);
				_g_object_unref0 (file);
				_g_free0 (fpath);
				_g_free0 (path);
				_archive_read_finish0 (archive);
				return NULL;
			}
#line 227 "ease-archiver.vala"
			fd = open (fpath, O_WRONLY, (mode_t) 0644);
#line 228 "ease-archiver.vala"
			archive_read_data_into_fd (archive, fd);
#line 229 "ease-archiver.vala"
			close (fd);
#line 728 "ease-archiver.c"
			_g_object_unref0 (parent);
		}
		_g_object_unref0 (file);
		_g_free0 (fpath);
	}
	result = path;
	_archive_read_finish0 (archive);
#line 233 "ease-archiver.vala"
	return result;
#line 738 "ease-archiver.c"
}




