/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * Copyright (C) 2010 Canonical Services Ltd (www.canonical.com)
 *
 * Authors: Rodrigo Moya <rodrigo.moya@canonical.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of version 2 of the GNU Lesser General Public
 * License as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef __DESKTOPCOUCH_DOCUMENT_H__
#define __DESKTOPCOUCH_DOCUMENT_H__

#include <couchdb-glib.h>

G_BEGIN_DECLS

#define DESKTOPCOUCH_TYPE_DOCUMENT                (desktopcouch_document_get_type ())
#define DESKTOPCOUCH_DOCUMENT(obj)                (G_TYPE_CHECK_INSTANCE_CAST ((obj), DESKTOPCOUCH_TYPE_DOCUMENT, DesktopcouchDocument))
#define DESKTOPCOUCH_IS_DOCUMENT(obj)             (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DESKTOPCOUCH_TYPE_DOCUMENT))
#define DESKTOPCOUCH_DOCUMENT_CLASS(klass)        (G_TYPE_CHECK_CLASS_CAST ((klass), DESKTOPCOUCH_TYPE_DOCUMENT, DesktopcouchDocumentClass))
#define DESKTOPCOUCH_IS_DOCUMENT_CLASS(klass)     (G_TYPE_CHECK_CLASS_TYPE ((klass), DESKTOPCOUCH_TYPE_DOCUMENT))
#define DESKTOPCOUCH_DOCUMENT_GET_CLASS(obj)      (G_TYPE_INSTANCE_GET_CLASS ((obj), DESKTOPCOUCH_TYPE_DOCUMENT, DesktopouchDocumentClass))

typedef struct {
	CouchdbDocument parent;
} DesktopcouchDocument;

typedef struct {
	CouchdbDocumentClass parent_class;
} DesktopcouchDocumentClass;

GType                 desktopcouch_document_get_type (void);
DesktopcouchDocument *desktopcouch_document_new (void);

const char           *desktopcouch_document_get_record_type (DesktopcouchDocument *document);
void                  desktopcouch_document_set_record_type (DesktopcouchDocument *document,
							     const char *record_type);

CouchdbStructField   *desktopcouch_document_get_application_annotations (DesktopcouchDocument *document);
void                  desktopcouch_document_set_application_annotations (DesktopcouchDocument *document,
									 CouchdbStructField *annotations);

#define DESKTOPCOUCH_RECORD_TYPE_CONTACT "http://www.freedesktop.org/wiki/Specifications/desktopcouch/contact"

gboolean              desktopcouch_document_is_contact (DesktopcouchDocument *document);

G_END_DECLS

#endif
