/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * Copyright (C) 2009 Canonical Services Ltd (www.canonical.com)
 *
 * Authors: Rodrigo Moya <rodrigo.moya@canonical.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of version 2 of the GNU Lesser General Public
 * License as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef __COUCHDB_DOCUMENT_CONTACT_H__
#define __COUCHDB_DOCUMENT_CONTACT_H__

#include <couchdb-glib.h>

/*
 * Top level functions to manipulate documents representing a contact
 */

const char *couchdb_document_contact_get_first_name (CouchDBDocument *document);
void        couchdb_document_contact_set_first_name (CouchDBDocument *document, const char *first_name);
const char *couchdb_document_contact_get_last_name (CouchDBDocument *document);
void        couchdb_document_contact_set_last_name (CouchDBDocument *document, const char *last_name);
const char *couchdb_document_contact_get_birth_date (CouchDBDocument *document);
void        couchdb_document_contact_set_birth_date (CouchDBDocument *document, const char *birth_date);

GSList     *couchdb_document_contact_get_email_addresses (CouchDBDocument *document);
void        couchdb_document_contact_set_email_addresses (CouchDBDocument *document, GSList *list);

/*
 * Utility functions to manipulate email addresses fields
 */

const char *couchdb_document_contact_email_get_address (CouchDBStructField *sf);
void        couchdb_document_contact_email_set_address (CouchDBStructField *sf, const char *email);
const char *couchdb_document_contact_email_get_description (CouchDBStructField *sf);
void        couchdb_document_contact_email_set_description (CouchDBStructField *sf, const char *description);

#endif
