#include <gdk/gdk.h>
#include <gtk/gtk.h>
#include <gdk/gdkx.h>
#include <X11/Xlib.h>
#include <config.h>
#include <assert.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <fcntl.h>
#include <unistd.h>
#include "e-conf_filesel.h"
#include "capplet-widget.h"
#include <gnome.h>

#include "screen.xpm"
#include "move_box.xpm"
#include "move_lined.xpm"
#include "move_opaque.xpm"
#include "move_semi-solid.xpm"
#include "move_shaded.xpm"
#include "move_translucent.xpm"
#include "resize_box.xpm"
#include "resize_lined.xpm"
#include "resize_opaque.xpm"
#include "resize_semi-solid.xpm"
#include "resize_shaded.xpm"
#include "focus_click.xpm"
#include "focus_sloppy.xpm"
#include "focus_pointer.xpm"
#include "focus_and_display.xpm"
#include "special_effects.xpm"
#include "behavior.xpm"
#include "desktops.xpm"
#include "backgrounds.xpm"
#include "audio.xpm"
#include "fonts.xpm"
#include "colours.xpm"
#include "cursors.xpm"
#include "borders.xpm"
#include "menus.xpm"
#include "e_logo.xpm"

typedef struct _background
  {
    gchar              *name;
    GtkWidget          *pmap;
    GtkWidget          *gpmap;
    GtkWidget          *box;
    GtkWidget          *gbox;
    GtkWidget          *button;
    GtkWidget          *table;
    struct _bg
      {
	GdkImlibColor       solid;
	gchar               *file;
	gint                 tile;
	gint                 keep_aspect;
	gint                 xjust, yjust;
	gint                 xperc, yperc;
      }
    bg;
    struct _top
      {
	gchar               *file;
	gint                 keep_aspect;
	gint                 xjust, yjust;
	gint                 xperc, yperc;
      }
    top;
    gchar changed;
  }
Background;

typedef struct _iconoption
  {
    gchar              *name;
    gchar             **icon_data;
    gchar              *tip;
  }
IconOption;

GtkWidget          *current_capplet;
gchar               e_opt_sound = 1;
gchar               e_opt_slide_cleanup = 1;
gchar               e_opt_slide_map = 1;
gchar               e_opt_slide_desk = 1;
gchar               e_opt_hq_background = 1;
gchar               e_opt_saveunders = 1;
gint                e_opt_focus = 1;
gint                e_opt_move = 0;
gint                e_opt_resize = 2;
gint                e_opt_slide_mode = 0;
gchar               e_opt_tooltips = 1;
gchar               e_opt_menuslide = 0;
gfloat              e_opt_tooltiptime = 1.5;
gfloat              e_opt_shade_speed = 4000.0;
gfloat              e_opt_map_speed = 4000.0;
gfloat              e_opt_cleanup_speed = 4000.0;
gfloat              e_opt_desk_speed = 4000.0;
gfloat              e_opt_desktop_bg_timeout = 60.0;
gfloat              e_opt_number_of_desks = 32;
gfloat              e_opt_area_width = 3;
gfloat              e_opt_area_height = 3;
gchar               e_opt_autorase = 0;
gfloat              e_opt_autoraisetime = 0.5;
gint                e_opt_dragdir = 2;
gchar               e_opt_show_icons = 1;
gchar               e_opt_transients_follow_leader = 1;
gchar               e_opt_switch_for_transient_map = 1;
gchar               e_opt_all_new_windows_get_focus = 0;
gchar               e_opt_new_transients_get_focus = 0;
gchar               e_opt_e_opt_new_transients_get_focus_if_group_focused = 1;

GList              *backgrounds = NULL;
Background         *deskbg[32];
gchar               deskbgchanged[32];
gint                curdesk = 0;
gchar               got_e_ipc_msg = 0;
gchar              *e_ipc_msg = NULL;

static GtkWidget *progress_win = NULL;
static GtkWidget *progress = NULL;
static GtkWidget *desk_option_menu = NULL;
static GtkWidget *desk_mini_display_area = NULL;
static GtkWidget *desk_select_menu = NULL;
static GtkWidget *bg_name_entry = NULL;
static GtkWidget *bg_color_area = NULL;
static GtkWidget *bg_range_area = NULL;
static GtkWidget *bg_bg_file_entry = NULL;
static GtkWidget *bg_fg_file_entry = NULL;
static GtkWidget *bg_bg_tile = NULL;
static GtkWidget *bg_bg_maxv = NULL;
static GtkWidget *bg_bg_maxh = NULL;
static GtkWidget *bg_bg_aspect = NULL;
static GtkWidget *bg_fg_pos = NULL;
static GtkWidget *bg_fg_maxv = NULL;
static GtkWidget *bg_fg_maxh = NULL;
static GtkWidget *bg_fg_aspect = NULL;
static GtkWidget *note_solid1 = NULL;
static GtkWidget *note_solid2 = NULL;
static GtkWidget *note_grad1 = NULL;
static GtkWidget *note_grad2 = NULL;
static GtkWidget *note_bg1 = NULL;
static GtkWidget *note_bg2 = NULL;
static GtkWidget *radio_image = NULL;
static GtkWidget *radio_gradient = NULL;
static GtkWidget *radio_color = NULL;
static GtkWidget *color_selector = NULL;
static GtkWidget *edit_win = NULL;
static GtkWidget *image_table_list = NULL;
static gint       h1, h2, h3, h4, h5, h6, h7, h8, h9, h10;
static gint       table_size = 80;
void                CommsInit(void (*msg_recieve_func) (gchar * msg));
void                CommsSend(gchar * s);

static void         recieve_ipc_msg(gchar * msg);
static gchar       *wait_for_ipc_msg(void);
static gchar       *get_line(gchar * str, int num);
static void         e_try(void);
static void         e_revert(void);
static void         e_ok(void);
static void         e_cancel(void);
static void         e_read(void);
static void         e_set_bg_to_e(Background *bg);
static void         e_render_bg_onto(GdkWindow * win, Background * bg);
static void         e_init_capplet(GtkWidget * c, GtkSignalFunc try, GtkSignalFunc revert, GtkSignalFunc ok, GtkSignalFunc cancel);
static void         e_cb_icon_option(GtkWidget * widget, gpointer data);
static GtkWidget   *e_create_icon_option(gchar * title, gint * option, gint width, gint num_options, IconOption * options);
static void         e_cb_onoff(GtkWidget * widget, gpointer data);
static GtkWidget   *e_create_onoff(gchar * text, gchar * value);
static void         e_cb_range(GtkWidget * widget, gpointer data);
static void         e_cb_rangeonoff_toggle(GtkWidget * widget, gpointer data);
static GtkWidget   *e_create_rangeonoff(gchar * text, gfloat * value, gfloat lower, gfloat upper, gchar * lower_text, gchar * upper_text, gchar * onoff, gfloat offvalue);
static void         e_cb_area_redraw(GtkWidget * widget, gpointer data);
static void         e_cb_desk_redraw(GtkWidget * widget, gpointer data);
static void         e_cb_area_range(GtkWidget * widget, gpointer data);
static GtkWidget   *e_areas_config(void);
static void         e_cb_desk_range(GtkWidget * widget, gpointer data);
static void         e_rebuild_desk_menu(void);
static void         redo_bg(Background *bg);
static GtkWidget   *e_desktops_config(void);
static GtkWidget   *__setup_pane_1(void);
static GtkWidget   *__setup_pane_2(void);
static GtkWidget   *__setup_pane_3(void);
static GtkWidget   *__setup_pane_4(void);
static GtkWidget   *__setup_pane_5(void);
static GtkWidget   *__setup_pane_6(void);
static GtkWidget   *__setup_pane_7(void);
static GtkWidget   *__setup_pane_8(void);
static GtkWidget   *__setup_pane_9(void);
static GtkWidget   *__setup_pane_10(void);
static GtkWidget   *__setup_pane_11(void);
static void         e_cb_list_click(GtkWidget * widget, gint num);
static void         e_setup(GtkWidget * c);
static void         e_setup_multi(GtkWidget * old, GtkWidget * c);
int                 main(int argc, char **argv);

static void
recieve_ipc_msg(gchar * msg)
{
  gdk_flush();
  e_ipc_msg = g_strdup(msg);
/*  gtk_main_quit(); */
  got_e_ipc_msg = 1;
}

static gchar       *
wait_for_ipc_msg(void)
{
  while (!got_e_ipc_msg)
    {
      while (gtk_events_pending())
	gtk_main_iteration();
      gdk_flush();
    }
/*  gtk_main(); */
  got_e_ipc_msg = 0;
  return e_ipc_msg;
}

static gchar       *
get_line(gchar * str, int num)
{
  gchar              *s1, *s2, *s;
  gint                i, count, l;

  i = 0;
  count = 0;
  s1 = str;
  if (*str == '\n')
    i = 1;
  s2 = NULL;
  for (i = 0;; i++)
    {
      if ((str[i] == '\n') || (str[i] == 0))
	{
	  s2 = &(str[i]);
	  if ((count == num) && (s2 > s1))
	    {
	      l = s2 - s1;
	      s = g_malloc(l + 1);
	      strncpy(s, s1, l);
	      s[l] = 0;
	      return s;
	    }
	  count++;
	  if (str[i] == 0)
	    return NULL;
	  s1 = s2 + 1;
	}
    }
}

static void
e_try(void)
{
  gchar               cmd[4096];

  g_snprintf(cmd, sizeof(cmd), "set_controls"
	     " SOUND: %i"
	     " CLEANUPSLIDE: %i"
	     " MAPSLIDE: %i"
	     " DESKSLIDEIN: %i"
	     " HIQUALITYBG: %i"
	     " FOCUSMODE: %i"
	     " MOVEMODE: %i"
	     " RESIZEMODE: %i"
	     " SLIDEMODE: %i"
	     " TOOLTIPS: %i"
	     " TIPTIME: %f"
	     " SHADESPEED: %i"
	     " SLIDESPEEDMAP: %i"
	     " SLIDESPEEDCLEANUP: %i"
	     " DESKSLIDESPEED: %i"
	     " DESKTOPBGTIMEOUT: %i"
	     " SAVEUNDER: %i"
	     " NUMDESKTOPS: %i"
	     " MENUSLIDE: %i"
	     " AREA_SIZE: %i %i"
	     " AUTORAISE: %i"
	     " AUTORAISETIME: %f"
	     " DRAGDIR: %i"
	     " SHOWICONS: %i"
	     " TRANSIENTSFOLLOWLEADER: %i"
	     " SWITCHFORTRANSIENTMAP: %i"
	     " ALL_NEW_WINDOWS_GET_FOCUS: %i"
	     " NEW_TRANSIENTS_GET_FOCUS: %i"
	     " NEW_TRANSIENTS_GET_FOCUS_IF_GROUP_FOCUSED: %i"
	     ,
	     (gint)e_opt_sound,
	     (gint)e_opt_slide_cleanup, 
	     (gint)e_opt_slide_map,
	     (gint)e_opt_slide_desk, 
	     (gint)e_opt_hq_background,
	     (gint)e_opt_focus, 
	     (gint)e_opt_move, 
	     (gint)e_opt_resize, 
	     (gint)e_opt_slide_mode,
	     (gint)e_opt_tooltips, 
	     (gfloat)e_opt_tooltiptime,
	     (gint)e_opt_shade_speed,
	     (gint)e_opt_map_speed,
	     (gint)e_opt_cleanup_speed,
	     (gint)e_opt_desk_speed,
	     ((gint)e_opt_desktop_bg_timeout) * 60,
	     (gint)e_opt_saveunders,
	     (gint)e_opt_number_of_desks,
	     (gint)e_opt_menuslide,
	     (gint)e_opt_area_width,
	     (gint)e_opt_area_height,
	     (gint)e_opt_autorase,
	     (gfloat)e_opt_autoraisetime,
	     (gint)e_opt_dragdir,
	     (gint)e_opt_show_icons,
	     (gint)e_opt_transients_follow_leader,
	     (gint)e_opt_switch_for_transient_map,
	     (gint)e_opt_all_new_windows_get_focus,
	     (gint)e_opt_new_transients_get_focus,
	     (gint)e_opt_e_opt_new_transients_get_focus_if_group_focused
	     );
  CommsSend(cmd);
  {
    gint                i, d, l;
    Background         *bg;
    gchar               buf[256];
    gchar               changed;
    GList              *ptr;

    l = g_list_length(backgrounds);
    ptr = backgrounds;
    for (i = 0; ((i < l) && (ptr)); i++)
      {
	bg = ptr->data;
	ptr = ptr->next;
	changed = 0;
	if (bg)
	  {
	    gint                j;
	    
	    if (bg->changed)
	      {
		e_set_bg_to_e(bg);
		bg->changed = 0;
	      }
	    g_snprintf(cmd, sizeof(cmd), "use_bg %s",
		       bg->name);
	    for (j = 0; j < 32; j++)
	      {
		if (deskbg[j] == bg)
		  {
		    g_snprintf(buf, sizeof(buf), " %i", j);
		    strcat(cmd, buf);
		  }
		if (deskbgchanged[j])
		  changed = 1;
	      }
	    if (changed)
	      CommsSend(cmd);
	  }
      }
    changed = 0;
    g_snprintf(cmd, sizeof(cmd), "use_no_bg ");
    for (i = 0; i < 32; i++)
      {
	if ((deskbgchanged[i]) && (!deskbg[i]))
	  {
	    g_snprintf(buf, sizeof(buf), " %i", i);
	    strcat(cmd, buf);
	    changed = 1;
	  }
      }
    if (changed)
      CommsSend(cmd);
    for (i = 0; i < 32; i++)
      deskbgchanged[i] = 0;
  }
}

static void
e_revert(void)
{
}

static void
e_ok(void)
{
  e_try();
}

static void
e_cancel(void)
{
}

static void
e_read(void)
{
  gchar               cmd[4096];
  gchar              *buf;
  gchar              *msg;
  gint                i;

  CommsSend("get_controls");
  msg = wait_for_ipc_msg();
  i = 0;
  while ((buf = get_line(msg, i++)))
    {
      sscanf(buf, "%4000s", cmd);
      if (!strcmp(cmd, "SOUND:"))
	{
	  sscanf(buf, "%*s %4000s", cmd);
	  e_opt_sound = atoi(cmd);
	}
      else if (!strcmp(cmd, "CLEANUPSLIDE:"))
	{
	  sscanf(buf, "%*s %4000s", cmd);
	  e_opt_slide_cleanup = atoi(cmd);
	}
      else if (!strcmp(cmd, "MAPSLIDE:"))
	{
	  sscanf(buf, "%*s %4000s", cmd);
	  e_opt_slide_map = atoi(cmd);
	}
      else if (!strcmp(cmd, "DESKSLIDEIN:"))
	{
	  sscanf(buf, "%*s %4000s", cmd);
	  e_opt_slide_desk = atoi(cmd);
	}
      else if (!strcmp(cmd, "HIQUALITYBG:"))
	{
	  sscanf(buf, "%*s %4000s", cmd);
	  e_opt_hq_background = atoi(cmd);
	}
      else if (!strcmp(cmd, "FOCUSMODE:"))
	{
	  sscanf(buf, "%*s %4000s", cmd);
	  e_opt_focus = atoi(cmd);
	}
      else if (!strcmp(cmd, "MOVEMODE:"))
	{
	  sscanf(buf, "%*s %4000s", cmd);
	  e_opt_move = atoi(cmd);
	}
      else if (!strcmp(cmd, "RESIZEMODE:"))
	{
	  sscanf(buf, "%*s %4000s", cmd);
	  e_opt_resize = atoi(cmd);
	}
      else if (!strcmp(cmd, "SLIDEMODE:"))
	{
	  sscanf(buf, "%*s %4000s", cmd);
	  e_opt_slide_mode = atoi(cmd);
	}
      else if (!strcmp(cmd, "TOOLTIPS:"))
	{
	  sscanf(buf, "%*s %4000s", cmd);
	  e_opt_tooltips = atoi(cmd);
	}
      else if (!strcmp(cmd, "TIPTIME:"))
	{
	  sscanf(buf, "%*s %4000s", cmd);
	  e_opt_tooltiptime = atof(cmd);
	}
      else if (!strcmp(cmd, "SHADESPEED:"))
	{
	  sscanf(buf, "%*s %4000s", cmd);
	  e_opt_shade_speed = atof(cmd);
	}
      else if (!strcmp(cmd, "SLIDESPEEDMAP:"))
	{
	  sscanf(buf, "%*s %4000s", cmd);
	  e_opt_map_speed = atof(cmd);
	}
      else if (!strcmp(cmd, "SLIDESPEEDCLEANUP:"))
	{
	  sscanf(buf, "%*s %4000s", cmd);
	  e_opt_cleanup_speed = atof(cmd);
	}
      else if (!strcmp(cmd, "DESKSLIDESPEED:"))
	{
	  sscanf(buf, "%*s %4000s", cmd);
	  e_opt_desk_speed = atof(cmd);
	}
      else if (!strcmp(cmd, "DESKTOPBGTIMEOUT:"))
	{
	  sscanf(buf, "%*s %4000s", cmd);
	  e_opt_desktop_bg_timeout = atof(cmd) / 60;
	}
      else if (!strcmp(cmd, "SAVEUNDER:"))
	{
	  sscanf(buf, "%*s %4000s", cmd);
	  e_opt_saveunders = atoi(cmd);
	}
      else if (!strcmp(cmd, "NUMDESKTOPS:"))
	{
	  sscanf(buf, "%*s %4000s", cmd);
	  e_opt_number_of_desks = atof(cmd);
	}
      else if (!strcmp(cmd, "MENUSLIDE:"))
	{
	  sscanf(buf, "%*s %4000s", cmd);
	  e_opt_menuslide = atof(cmd);
	}
      else if (!strcmp(cmd, "AREA_SIZE:"))
	{
	  sscanf(buf, "%*s %4000s", cmd);
	  e_opt_area_width = atof(cmd);
	  sscanf(buf, "%*s %*s %4000s", cmd);
	  e_opt_area_height = atof(cmd);
	}
      
      else if (!strcmp(cmd, "AUTORAISE:"))
	{
	  sscanf(buf, "%*s %4000s", cmd);
	  e_opt_autorase = atoi(cmd);
	}
      else if (!strcmp(cmd, "AUTORAISETIME:"))
	{
	  sscanf(buf, "%*s %4000s", cmd);
	  e_opt_autoraisetime = atof(cmd);
	}
      else if (!strcmp(cmd, "DRAGDIR:"))
	{
	  sscanf(buf, "%*s %4000s", cmd);
	  e_opt_dragdir = atoi(cmd);
	}
      else if (!strcmp(cmd, "SHOWICONS:"))
	{
	  sscanf(buf, "%*s %4000s", cmd);
	  e_opt_show_icons = atoi(cmd);
	}
      else if (!strcmp(cmd, "TRANSIENTSFOLLOWLEADER:"))
	{
	  sscanf(buf, "%*s %4000s", cmd);
	  e_opt_transients_follow_leader = atoi(cmd);
	}
      else if (!strcmp(cmd, "SWITCHFORTRANSIENTMAP:"))
	{
	  sscanf(buf, "%*s %4000s", cmd);
	  e_opt_switch_for_transient_map = atoi(cmd);
	}
      else if (!strcmp(cmd, "ALL_NEW_WINDOWS_GET_FOCUS:"))
	{
	  sscanf(buf, "%*s %4000s", cmd);
	  e_opt_all_new_windows_get_focus = atoi(cmd);
	}
      else if (!strcmp(cmd, "NEW_TRANSIENTS_GET_FOCUS:"))
	{
	  sscanf(buf, "%*s %4000s", cmd);
	  e_opt_new_transients_get_focus = atoi(cmd);
	}
      else if (!strcmp(cmd, "NEW_TRANSIENTS_GET_FOCUS_IF_GROUP_FOCUSED:"))
	{
	  sscanf(buf, "%*s %4000s", cmd);
	  e_opt_e_opt_new_transients_get_focus_if_group_focused = atoi(cmd);
	}
      g_free(buf);
    }
  g_free(msg);

  CommsSend("list_bg");
  msg = wait_for_ipc_msg();
  i = 0;
  while ((buf = get_line(msg, i++)))
    {
      Background         *bg;
      gchar              *msg2;
      gchar               b1[4096], b2[4096];

      if (strlen(buf) > 0)
	{
	  bg = g_malloc(sizeof(Background));
	  bg->name = g_strdup(buf);
	  bg->pmap = NULL;
	  backgrounds = g_list_append(backgrounds, bg);
	  g_snprintf(cmd, sizeof(cmd), "get_bg %s", bg->name);
	  CommsSend(cmd);
	  msg2 = wait_for_ipc_msg();
	  if (msg2)
	    {
	      sscanf(msg2, "%*s %i %i %i %s %i %i %i %i %i %i %s %i %i %i %i %i",
		     &bg->bg.solid.r, &bg->bg.solid.g, &bg->bg.solid.b,
		     b1, &bg->bg.tile, &bg->bg.keep_aspect,
		     &bg->bg.xjust, &bg->bg.yjust, &bg->bg.xperc, &bg->bg.yperc,
		     b2, &bg->top.keep_aspect, &bg->top.xjust,
		     &bg->top.yjust, &bg->top.xperc, &bg->top.yperc);
	      if (!strcmp(b1, "(null)"))
		bg->bg.file = NULL;
	      else
		bg->bg.file = g_strdup(b1);
	      if (!strcmp(b2, "(null)"))
		bg->top.file = NULL;
	      else
		bg->top.file = g_strdup(b2);
	      g_free(msg2);
	    }
	}
      g_free(buf);
    }
  g_free(msg);
    {
      gint                ii, j, d;
      Background         *bg;
      GList              *ptr;
      
      j = g_list_length(backgrounds);
      ptr = backgrounds;
      for (i = 0; ((i < j) && (ptr)); i++)
	{
	  if (progress)
	    gtk_progress_bar_update(GTK_PROGRESS_BAR(progress),
				    (gfloat) i / (gfloat) j);
	  bg = ptr->data;
	  ptr = ptr->next;
	  if (bg)
	    {
	      g_snprintf(cmd, sizeof(cmd), "uses_bg %s", bg->name);
	      CommsSend(cmd);
	      msg = wait_for_ipc_msg();
	      ii = 0;
	      while ((buf = get_line(msg, ii++)))
		{
		  if (sscanf(buf, "%i", &d) > 0)
		    {
		      if (d < 0)
			d = 0;
		      if (d > 31)
			d = 31;
		      deskbg[d] = bg;
		    }
		  g_free(buf);
		}
	      g_free(msg);
	    }
	}
    }
}

static void
e_render_bg_onto(GdkWindow * win, Background * bg)
{
  gchar               cmd[4096];
  gchar              *msg;
  Window              last_rend = 0;
  gchar              *last_bg_name = NULL;

  if ((last_bg_name) && 
      (!strcmp(last_bg_name, bg->name)) && 
      (last_rend == GDK_WINDOW_XWINDOW(win)) &&
      (!bg->changed))
    {
      printf("repeat render of %s!\n", bg->name);
      return;
    }
  g_snprintf(cmd, sizeof(cmd), "draw_bg_to %x %s",
	     (gint) GDK_WINDOW_XWINDOW(win), bg->name);
  CommsSend(cmd);
  msg = wait_for_ipc_msg();
  g_free(msg);
  printf("RENDER %s onto %p (0x%x)\n",bg->name, win, GDK_WINDOW_XWINDOW(win));
  if (last_bg_name)
    g_free(last_bg_name);
  last_bg_name = g_strdup(bg->name);
  last_rend = GDK_WINDOW_XWINDOW(win);
}

/* May be needed later */
/*
 * static void
 * e_cb_multi(GtkWidget *widget, gpointer data)
 * {
 * GtkWidget *c;
 * gint *value;
 * gint val;
 * 
 * c = (GtkWidget *)gtk_object_get_data(GTK_OBJECT(widget), "capplet");
 * capplet_widget_state_changed(CAPPLET_WIDGET(c), FALSE);
 * val = (gint)gtk_object_get_data(GTK_OBJECT(widget), "value");
 * value = (gint *)data;
 * *value = val;
 * }
 * 
 * static void
 * e_add_multi_to_frame(GtkWidget *w, gchar *text, gchar *opts, gint *value)
 * {
 * GtkWidget *table, *label, *om, *m, *mi, *align;
 * gint i, j, rows;
 * gchar s[1024], tmpbuf[2];
 * 
 * if (!w)
 * return;
 * if (!text)
 * return;
 * table = (GtkWidget *)gtk_object_get_data(GTK_OBJECT(w), "table");
 * if (!table)
 * return;
 * rows = (gint)gtk_object_get_data(GTK_OBJECT(w), "rows");
 * 
 * label = gtk_label_new(text);
 * gtk_widget_show(label);
 * align = gtk_alignment_new(0.0, 0.5, 0.0, 0.0);
 * gtk_widget_show(align);
 * gtk_container_add(GTK_CONTAINER(align), label);
 * gtk_table_attach_defaults(GTK_TABLE(table), align, 0, 1, rows, rows + 1);
 * 
 * om = gtk_option_menu_new();
 * align = gtk_alignment_new(1.0, 0.5, 0.0, 0.0);
 * gtk_widget_show(align);
 * gtk_container_add(GTK_CONTAINER(align), om);
 * gtk_table_attach(GTK_TABLE(table), align, 9, 10, rows, rows + 1,
 * GTK_EXPAND | GTK_FILL,
 * GTK_EXPAND | GTK_FILL, 0, 0);
 * 
 * m = gtk_menu_new();
 * gtk_widget_show(m);
 * 
 * i = 0;
 * j = 0;
 * tmpbuf[1] = 0;
 * while (opts[j])
 * {
 * s[0] = 0;
 * if (opts[j] == '\n')
 * j++;
 * while ((opts[j]) && (opts[j] != '\n'))
 * {
 * tmpbuf[0] = opts[j];
 * strcat(s, tmpbuf);
 * j++;
 * }
 * mi = gtk_menu_item_new_with_label(s);
 * gtk_object_set_data(GTK_OBJECT(mi), "value", (gpointer)i);
 * gtk_object_set_data(GTK_OBJECT(mi), "capplet", (gpointer)current_capplet);  
 * gtk_signal_connect(GTK_OBJECT(mi),
 * "activate", GTK_SIGNAL_FUNC(e_cb_multi),
 * (gpointer)value);
 * gtk_menu_append(GTK_MENU(m), mi);
 * gtk_widget_show(mi);
 * i++;
 * }
 * 
 * gtk_option_menu_set_menu(GTK_OPTION_MENU(om), m);
 * 
 * gtk_option_menu_set_history(GTK_OPTION_MENU(om), *value);
 * gtk_widget_show (om);
 * 
 * gtk_object_set_data(GTK_OBJECT(w), "rows", (gpointer)(rows + 1));
 * }
 */

static void
e_init_capplet(GtkWidget * c, GtkSignalFunc try, GtkSignalFunc revert,
	       GtkSignalFunc ok, GtkSignalFunc cancel)
{
  gtk_widget_show(c);
  
  gtk_signal_connect(GTK_OBJECT(c), "try",
		     GTK_SIGNAL_FUNC(try), NULL);
  gtk_signal_connect(GTK_OBJECT(c), "revert",
		     GTK_SIGNAL_FUNC(revert), NULL);
  gtk_signal_connect(GTK_OBJECT(c), "ok",
		     GTK_SIGNAL_FUNC(ok), NULL);
  gtk_signal_connect(GTK_OBJECT(c), "cancel",
		     GTK_SIGNAL_FUNC(cancel), NULL);
}

static void
e_cb_icon_option(GtkWidget * widget, gpointer data)
{
  GtkWidget          *c;
  gint               *value;
  gint                val;

  c = (GtkWidget *) gtk_object_get_data(GTK_OBJECT(widget), "capplet");
  capplet_widget_state_changed(CAPPLET_WIDGET(c), FALSE);
  val = (gint) gtk_object_get_data(GTK_OBJECT(widget), "value");
  value = (gint *) data;
  *value = val;
}

static GtkWidget   *
e_create_icon_option(gchar * title, gint * option, gint width,
		     gint num_options, IconOption * options)
{
  GSList             *items = NULL;
  GtkWidget          *frame, *align, *table, *pixmap, *radio, *label, *vbox;
  GtkWidget          *tip;
  GdkPixmap          *pmap, *mask;
  gint                i, j, k;

  frame = gtk_frame_new(title);
  gtk_widget_show(frame);

  align = gtk_alignment_new(0.0, 0.0, 0.0, 0.0);
  gtk_widget_show(align);
  gtk_container_add(GTK_CONTAINER(frame), align);

  table = gtk_table_new(1, 1, TRUE);
  gtk_widget_show(table);
  gtk_container_set_border_width(GTK_CONTAINER(table), 1);
  gtk_container_add(GTK_CONTAINER(align), table);

  j = 0;
  k = 0;
  for (i = 0; i < num_options; i++)
    {
      pmap = NULL;
      mask = NULL;
      gdk_imlib_data_to_pixmap(options[i].icon_data, &pmap, &mask);
      radio = gtk_radio_button_new(items);
      gtk_object_set_data(GTK_OBJECT(radio), "value", (gpointer) i);
      gtk_object_set_data(GTK_OBJECT(radio), "capplet", (gpointer) current_capplet);
      gtk_signal_connect(GTK_OBJECT(radio),
			 "clicked", GTK_SIGNAL_FUNC(e_cb_icon_option),
			 (gpointer) option);
      if (i == *option)
	gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(radio), 1);
      GTK_TOGGLE_BUTTON(radio)->draw_indicator = 0;
      gtk_widget_show(radio);
      label = gtk_label_new(options[i].name);
      gtk_widget_show(label);
      pixmap = gtk_pixmap_new(pmap, mask);
      gtk_widget_show(pixmap);
      vbox = gtk_vbox_new(FALSE, 0);
      gtk_widget_show(vbox);
      gtk_container_add(GTK_CONTAINER(radio), vbox);
      gtk_box_pack_start(GTK_BOX(vbox), pixmap, FALSE, FALSE, 1);
      gtk_box_pack_start(GTK_BOX(vbox), label, FALSE, FALSE, 1);
      gtk_table_attach(GTK_TABLE(table), radio, j, j + 1, k, k + 1,
		       GTK_EXPAND | GTK_FILL,
		       GTK_EXPAND | GTK_FILL, 1, 1);
      tip = (GtkWidget *) gtk_tooltips_new();
      gtk_tooltips_set_tip(GTK_TOOLTIPS(tip), radio, options[i].tip, NULL);
      gtk_tooltips_enable(GTK_TOOLTIPS(tip));
      items = g_slist_append(items, radio);
      j++;
      if (j >= width)
	{
	  j = 0;
	  k++;
	}
    }
  return frame;
}

/* on off widget */
static void
e_cb_onoff(GtkWidget * widget, gpointer data)
{
  GtkWidget          *c;
  gchar              *value;
  
  c = (GtkWidget *) gtk_object_get_data(GTK_OBJECT(widget), "capplet");
  capplet_widget_state_changed(CAPPLET_WIDGET(c), FALSE);
  value = (gchar *) data;
  if (GTK_TOGGLE_BUTTON(widget)->active)
    *value = 1;
  else
    *value = 0;
}

static GtkWidget   *
e_create_onoff(gchar * text, gchar * value)
{
  GtkWidget          *check, *align;
  gint                rows;
  
  if (!text)
    return NULL;
  
  check = gtk_check_button_new_with_label(text);
  gtk_widget_show(check);
  align = gtk_alignment_new(0.0, 0.5, 0.0, 0.0);
  gtk_widget_show(align);
  gtk_container_add(GTK_CONTAINER(align), check);
  
  gtk_object_set_data(GTK_OBJECT(check), "capplet", (gpointer) current_capplet);
  if (*value)
    gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(check), 1);
  else
    gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(check), 0);
  
  gtk_signal_connect(GTK_OBJECT(check), "toggled",
		     GTK_SIGNAL_FUNC(e_cb_onoff), (gpointer) value);
  return align;
}

/* range + on/off widget */
static void
e_cb_range(GtkWidget * widget, gpointer data)
{
  GtkWidget          *c;
  GtkWidget          *w;
  GtkAdjustment      *adj;
  gfloat             *value, current_val;
  static gint         just_changed = 0;
  GtkFunction         func;

  w = GTK_WIDGET(data);
  c = (GtkWidget *) gtk_object_get_data(GTK_OBJECT(w), "capplet");
  func = (GtkFunction) gtk_object_get_data(GTK_OBJECT(w), "function");
  capplet_widget_state_changed(CAPPLET_WIDGET(c), FALSE);
  adj = gtk_object_get_data(GTK_OBJECT(w), "adj");
  value = (gfloat *) gtk_object_get_data(GTK_OBJECT(w), "value");
  if (adj->step_increment > 0.5)
    {
      current_val = adj->value;
      adj->value = (gfloat) ((gint) (adj->value / adj->step_increment)) *
	adj->step_increment;
      if (just_changed == 0)
	{
	  just_changed++;
	  gtk_adjustment_value_changed(adj);
	}
      else if (just_changed > 0)
	just_changed--;
    }
  *value = adj->value;

  if (func)
    (*func) ((gpointer) ((gint)adj->value));

  widget = NULL;
}

static void
e_cb_rangeonoff_toggle(GtkWidget * widget, gpointer data)
{
  GtkWidget          *c;
  GtkWidget          *w, *ww;
  GtkAdjustment      *adj;
  gfloat             *value, offvalue;
  gchar              *onoff;

  w = GTK_WIDGET(data);
  c = (GtkWidget *) gtk_object_get_data(GTK_OBJECT(w), "capplet");
  capplet_widget_state_changed(CAPPLET_WIDGET(c), FALSE);
  adj = gtk_object_get_data(GTK_OBJECT(w), "adj");
  value = (gfloat *) gtk_object_get_data(GTK_OBJECT(w), "value");
  onoff = (gchar *) gtk_object_get_data(GTK_OBJECT(w), "onoff");
  offvalue = *((gfloat *) gtk_object_get_data(GTK_OBJECT(w), "offvalue"));
  *value = adj->value;

  if (onoff)
    {
      if (GTK_TOGGLE_BUTTON(widget)->active)
	{
	  ww = (GtkWidget *) gtk_object_get_data(GTK_OBJECT(w), "l1");
	  gtk_widget_set_sensitive(ww, TRUE);
	  ww = (GtkWidget *) gtk_object_get_data(GTK_OBJECT(w), "l2");
	  gtk_widget_set_sensitive(ww, TRUE);
	  gtk_widget_set_sensitive(w, TRUE);
	  *onoff = 1;
	}
      else
	{
	  ww = (GtkWidget *) gtk_object_get_data(GTK_OBJECT(w), "l1");
	  gtk_widget_set_sensitive(ww, FALSE);
	  ww = (GtkWidget *) gtk_object_get_data(GTK_OBJECT(w), "l2");
	  gtk_widget_set_sensitive(ww, FALSE);
	  gtk_widget_set_sensitive(w, FALSE);
	  *onoff = 0;
	}
    }
  else
    {
      if (GTK_TOGGLE_BUTTON(widget)->active)
	{
	  ww = (GtkWidget *) gtk_object_get_data(GTK_OBJECT(w), "l1");
	  gtk_widget_set_sensitive(ww, TRUE);
	  ww = (GtkWidget *) gtk_object_get_data(GTK_OBJECT(w), "l2");
	  gtk_widget_set_sensitive(ww, TRUE);
	  gtk_widget_set_sensitive(w, TRUE);
	  *value = 0.0;
	}
      else
	{
	  ww = (GtkWidget *) gtk_object_get_data(GTK_OBJECT(w), "l1");
	  gtk_widget_set_sensitive(ww, FALSE);
	  ww = (GtkWidget *) gtk_object_get_data(GTK_OBJECT(w), "l2");
	  gtk_widget_set_sensitive(ww, FALSE);
	  gtk_widget_set_sensitive(w, FALSE);
	  *value = offvalue;
	}
    }
  widget = NULL;
}

static GtkWidget   *
e_create_rangeonoff(gchar * text, gfloat * value,
		    gfloat lower, gfloat upper, gchar * lower_text,
		    gchar * upper_text, gchar * onoff, gfloat offvalue)
{
  GtkObject          *adj;
  GtkWidget          *frame, *hscale, *hbox, *label, *align, *align2, *check;
  GtkWidget          *label2, *w;
  gfloat             *offval;

  if (!text)
    return NULL;

  frame = gtk_frame_new(text);
  gtk_widget_show(frame);
  align = gtk_alignment_new(0.5, 0.5, 1.0, 0.0);
  gtk_widget_show(align);
  gtk_container_add(GTK_CONTAINER(align), frame);

  w = align;

  align = gtk_alignment_new(0.5, 0.5, 1.0, 0.0);
  gtk_widget_show(align);
  gtk_container_add(GTK_CONTAINER(frame), align);
  hbox = gtk_hbox_new(FALSE, 2);
  gtk_widget_show(hbox);
  gtk_container_add(GTK_CONTAINER(align), hbox);

  check = gtk_check_button_new();
  gtk_widget_show(check);
  align2 = gtk_alignment_new(1.0, 1.0, 0.0, 0.0);
  gtk_widget_show(align2);
  gtk_container_add(GTK_CONTAINER(align2), check);
  gtk_box_pack_start(GTK_BOX(hbox), align2, FALSE, FALSE, 0);

  if (onoff)
    {
      if (*onoff)
	gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(check), 1);
      else
	gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(check), 0);
    }
  else
    {
      if (*value == offvalue)
	gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(check), 0);
      else
	gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(check), 1);
    }

  adj = gtk_adjustment_new(*value, lower, upper, 0.1, .1, 0.1);
  hscale = gtk_hscale_new(GTK_ADJUSTMENT(adj));
  gtk_widget_show(hscale);

  gtk_signal_connect(GTK_OBJECT(check), "toggled",
		  GTK_SIGNAL_FUNC(e_cb_rangeonoff_toggle), (gpointer) hscale);

  label = gtk_label_new(lower_text);
  gtk_widget_show(label);
  align2 = gtk_alignment_new(0.5, 1.0, 0.0, 0.0);
  gtk_widget_show(align2);
  gtk_container_add(GTK_CONTAINER(align2), label);
  gtk_box_pack_start(GTK_BOX(hbox), align2, FALSE, FALSE, 0);
  gtk_signal_connect(GTK_OBJECT(adj), "value_changed",
		     GTK_SIGNAL_FUNC(e_cb_range), (gpointer) hscale);
  gtk_object_set_data(GTK_OBJECT(hscale), "adj", (gpointer) adj);
  gtk_object_set_data(GTK_OBJECT(hscale), "value", (gpointer) value);
  gtk_object_set_data(GTK_OBJECT(hscale), "capplet", (gpointer) current_capplet);
  gtk_object_set_data(GTK_OBJECT(hscale), "onoff", (gpointer) onoff);
  gtk_object_set_data(GTK_OBJECT(hscale), "l1", (gpointer) label);
  offval = g_malloc(sizeof(gfloat));
  *offval = offvalue;
  gtk_object_set_data(GTK_OBJECT(hscale), "offvalue", (gpointer) offval);

  gtk_box_pack_start(GTK_BOX(hbox), hscale, TRUE, TRUE, 0);
  label2 = label = gtk_label_new(upper_text);
  gtk_object_set_data(GTK_OBJECT(hscale), "l2", (gpointer) label);
  gtk_widget_show(label);
  align2 = gtk_alignment_new(0.5, 1.0, 0.0, 0.0);
  gtk_widget_show(align2);
  gtk_container_add(GTK_CONTAINER(align2), label);
  gtk_box_pack_start(GTK_BOX(hbox), align2, FALSE, FALSE, 0);
  if (GTK_TOGGLE_BUTTON(check)->active)
    {
      gtk_widget_set_sensitive(label, TRUE);
      gtk_widget_set_sensitive(hscale, TRUE);
      gtk_widget_set_sensitive(label2, TRUE);
    }
  else
    {
      gtk_widget_set_sensitive(label, FALSE);
      gtk_widget_set_sensitive(hscale, FALSE);
      gtk_widget_set_sensitive(label2, FALSE);
    }
  return w;
}

static void
e_cb_area_redraw(GtkWidget * widget, gpointer data)
{
  GdkWindow          *win;
  GtkStyle           *s;
  gint                i, j, x, y, w, h, ww, hh;
  GdkImlibImage      *im = NULL;
  GdkImlibBorder      border =
  {4, 4, 4, 13};

  win = widget->window;
  s = widget->style;
  gdk_window_get_size(win, &ww, &hh);

  ww -= 40;
  hh -= 30;

  if (!im)
    {
      im = gdk_imlib_create_image_from_xpm_data(screen_xpm);
      gdk_imlib_set_image_border(im, &border);
    }
  gdk_window_clear(win);
  w = 20;
  h = 15;
  if (e_opt_area_height > e_opt_area_width)
    {
      w = ww / (gint) e_opt_area_height;
      h = hh / (gint) e_opt_area_height;
    }
  else
    {
      w = ww / (gint) e_opt_area_width;
      h = hh / (gint) e_opt_area_width;
    }
  for (j = 0; j < (gint) e_opt_area_height; j++)
    {
      for (i = 0; i < (gint) e_opt_area_width; i++)
	{
	  x = 20 + (i * w);
	  y = 15 + (j * h);
	  gtk_draw_box(s, win, GTK_STATE_ACTIVE, GTK_SHADOW_OUT, x, y, w, h);
	}
    }
  x = 20;
  y = 15;
  gdk_imlib_paste_image(im, win, x - 4, y - 4, w + 8, h + 17);

}

static void
e_cb_desk_redraw(GtkWidget * widget, gpointer data)
{
  GdkWindow          *win;
  GtkStyle           *s;
  gint                i, x, y, w, h, ww, hh, tw, th, dummy, ascent, descent;
  gchar               str[1024];

  win = widget->window;
  s = widget->style;
  gdk_window_get_size(win, &ww, &hh);

  ww -= 4;
  hh -= 4;

  gdk_window_clear(win);
  w = ww - ((e_opt_number_of_desks - 1) * 3);
  h = hh - ((e_opt_number_of_desks - 1) * 3);
  for (i = (gint) e_opt_number_of_desks - 1; i >= 0; i--)
    {
      x = 2 + (i * 3);
      y = 2 + (i * 3);
      gtk_draw_box(s, win, GTK_STATE_ACTIVE, GTK_SHADOW_OUT, x, y, w, h);
    }
  if (e_opt_number_of_desks < 2.0)
    g_snprintf(str, sizeof(str), "%1.0f Desktop", e_opt_number_of_desks);
  else
    g_snprintf(str, sizeof(str), "%1.0f Desktops", e_opt_number_of_desks);
  gdk_text_extents(s->font, str, strlen(str), &dummy, &dummy, &tw,
		   &ascent, &descent);
  x = 2 + ((ww - tw) / 2);
  y = 2 + ((hh - (ascent + descent)) / 2) + ascent;
  gtk_draw_box(s, win, GTK_STATE_NORMAL, GTK_SHADOW_IN,
	       x - 3, y - 3 - ascent, tw + 6, ascent + descent + 6);
  gtk_draw_string(s, win, GTK_STATE_NORMAL, x, y, str);
}

static void
e_cb_area_range(GtkWidget * widget, gpointer data)
{
  GtkWidget          *c, *w, *label;
  GtkAdjustment      *adj;
  gfloat             *value;
  gchar               str[1024];

  w = GTK_WIDGET(data);
  adj = GTK_ADJUSTMENT(widget);
  c = (GtkWidget *) gtk_object_get_data(GTK_OBJECT(adj), "capplet");
  capplet_widget_state_changed(CAPPLET_WIDGET(c), FALSE);
  value = (gfloat *) gtk_object_get_data(GTK_OBJECT(adj), "value");
  *value = adj->value;
  label = (GtkWidget *) gtk_object_get_data(GTK_OBJECT(w), "label");
  g_snprintf(str, sizeof(str),
	     "The virutal desktop size will be\n"
	     "%1.0f x %1.0f\n"
	     "screens in size",
	     e_opt_area_width, e_opt_area_height);
  gtk_label_set_text(GTK_LABEL(label), str);
  e_cb_area_redraw(w, NULL);
}

static GtkWidget   *
e_areas_config(void)
{
  GtkWidget          *table, *range, *frame, *area, *label;
  GtkObject          *adj;
  gchar               str[1024];

  table = gtk_table_new(1, 1, FALSE);
  gtk_widget_show(table);

  frame = gtk_frame_new(NULL);
  gtk_frame_set_shadow_type(GTK_FRAME(frame), GTK_SHADOW_IN);
  gtk_widget_show(frame);
  gtk_table_attach_defaults(GTK_TABLE(table), frame, 1, 10, 1, 10);

  area = gtk_drawing_area_new();
  gtk_widget_show(area);
  gtk_drawing_area_size(GTK_DRAWING_AREA(area), 200, 160);
  gtk_widget_set_usize(area, 200, 160);
  gtk_container_add(GTK_CONTAINER(frame), area);
  gtk_signal_connect(GTK_OBJECT(area), "expose_event",
		     GTK_SIGNAL_FUNC(e_cb_area_redraw), NULL);

  adj = gtk_adjustment_new(e_opt_area_width, 1.0, 9.0, 1.0, 1.0, 1.0);
  range = gtk_hscale_new(GTK_ADJUSTMENT(adj));
  gtk_widget_set_usize(range, 200, -1);
  gtk_object_set_data(GTK_OBJECT(adj), "capplet", current_capplet);
  gtk_object_set_data(GTK_OBJECT(adj), "value", &e_opt_area_width);
  gtk_scale_set_digits(GTK_SCALE(range), 0);
  gtk_widget_show(range);
  gtk_table_attach_defaults(GTK_TABLE(table), range, 1, 10, 0, 1);
  gtk_signal_connect(GTK_OBJECT(adj), "value_changed",
		     GTK_SIGNAL_FUNC(e_cb_area_range), (gpointer) area);

  adj = gtk_adjustment_new(e_opt_area_height, 1.0, 9.0, 1.0, 1.0, 1.0);
  range = gtk_vscale_new(GTK_ADJUSTMENT(adj));
  gtk_widget_set_usize(range, -1, 150);
  gtk_object_set_data(GTK_OBJECT(adj), "capplet", current_capplet);
  gtk_object_set_data(GTK_OBJECT(adj), "value", &e_opt_area_height);
  gtk_scale_set_digits(GTK_SCALE(range), 0);
  gtk_widget_show(range);
  gtk_table_attach_defaults(GTK_TABLE(table), range, 0, 1, 1, 10);
  gtk_signal_connect(GTK_OBJECT(adj), "value_changed",
		     GTK_SIGNAL_FUNC(e_cb_area_range), (gpointer) area);
  g_snprintf(str, sizeof(str),
	     "The virutal desktop size will be\n"
	     "%1.0f x %1.0f\n"
	     "screens in size",
	     e_opt_area_width, e_opt_area_height);
  label = gtk_label_new(str);
  gtk_widget_show(label);
  gtk_table_attach_defaults(GTK_TABLE(table), label, 1, 10, 10, 11);

  gtk_object_set_data(GTK_OBJECT(area), "label", label);
  gtk_object_set_data(GTK_OBJECT(area), "table", table);
  return table;
}

static void
e_cb_desk_range(GtkWidget * widget, gpointer data)
{
  GtkWidget          *c, *w;
  GtkAdjustment      *adj;
  gfloat             *value;

  w = GTK_WIDGET(data);
  adj = GTK_ADJUSTMENT(widget);
  c = (GtkWidget *) gtk_object_get_data(GTK_OBJECT(adj), "capplet");
  capplet_widget_state_changed(CAPPLET_WIDGET(c), FALSE);
  value = (gfloat *) gtk_object_get_data(GTK_OBJECT(adj), "value");
  *value = adj->value;
  e_cb_desk_redraw(w, NULL);
  e_rebuild_desk_menu();
}

static GtkWidget   *
e_desktops_config(void)
{
  GtkWidget          *table, *range, *frame, *area, *label, *window;
  GtkObject          *adj;

  table = gtk_table_new(1, 1, FALSE);
  gtk_widget_show(table);

  frame = gtk_frame_new(NULL);
  gtk_frame_set_shadow_type(GTK_FRAME(frame), GTK_SHADOW_IN);
  gtk_widget_show(frame);
  gtk_table_attach_defaults(GTK_TABLE(table), frame, 1, 10, 1, 10);

  area = gtk_drawing_area_new();
  gtk_widget_show(area);
  gtk_drawing_area_size(GTK_DRAWING_AREA(area), 153, 138);
  gtk_widget_set_usize(area, 153, 138);
  gtk_container_add(GTK_CONTAINER(frame), area);
  gtk_signal_connect(GTK_OBJECT(area), "expose_event",
		     GTK_SIGNAL_FUNC(e_cb_desk_redraw), NULL);

  adj = gtk_adjustment_new(e_opt_number_of_desks, 1.0, 33.0, 1.0, 1.0, 1.0);
  range = gtk_vscale_new(GTK_ADJUSTMENT(adj));
  gtk_widget_set_usize(range, -1, 138);
  gtk_object_set_data(GTK_OBJECT(adj), "capplet", current_capplet);
  gtk_object_set_data(GTK_OBJECT(adj), "value", &e_opt_number_of_desks);
  gtk_scale_set_digits(GTK_SCALE(range), 0);
  gtk_widget_show(range);
  gtk_table_attach_defaults(GTK_TABLE(table), range, 0, 1, 1, 10);
  gtk_signal_connect(GTK_OBJECT(adj), "value_changed",
		     GTK_SIGNAL_FUNC(e_cb_desk_range), (gpointer) area);
  label = gtk_label_new("The number of separate desktops\n"
			"layered on top of eachother");
  gtk_widget_show(label);
  gtk_table_attach_defaults(GTK_TABLE(table), label, 0, 10, 10, 11);

  return table;
}

/* Pane for focus & display */
static GtkWidget   *
__setup_pane_1(void)
{
  GtkWidget          *frame, *frame2, *hbox, *vbox, *w;
  IconOption          move_options[] =
  {
    {"Opaque", move_opaque_xpm,
     "Windows are moved in a solid fashion"},
    {"Lined", move_lined_xpm,
     "Windows are moved by drawing construction lines around them"},
    {"Box", move_box_xpm,
     "Windows are moved by drawing a box as their outline"},
    {"Shaded", move_shaded_xpm,
     "Windows are moved by drawing a stippled outline of them"},
    {"Semi-Solid", move_semi_solid_xpm,
     "Windows are moved by drawing a chequered outline of them"},
    {"Translucent", move_translucent_xpm,
     "Windows are moved by drawing a translucent copy of the window"}
  };
  IconOption          resize_options[] =
  {
    {"Opaque", resize_opaque_xpm,
     "Windows are resized as you drag"},
    {"Lined", resize_lined_xpm,
     "Windows get resized by displaying construction lines around them"},
    {"Box", resize_box_xpm,
     "Windows are resized by drawing a box as their outline"},
    {"Shaded", resize_shaded_xpm,
     "windows are resized by drawing a stippled outline of them"},
    {"Semi-Solid", resize_semi_solid_xpm,
     "Windows are resized by drawing a chequered outline of them"}
  };
  IconOption          focus_options[] =
  {
    {"Mouse Pointer", focus_pointer_xpm,
     "Your keypresses are sent to whatever window your mouse is over at the time"},
    {"Sloppy Pointer", focus_sloppy_xpm,
   "Your keypresses are sent to the window your mouse was over last, if any"},
    {"Pointer Clicks", focus_click_xpm,
     "You keypresses are sent to the window you last clicked on"},
  };

  vbox = gtk_vbox_new(FALSE, 1);

  w = e_create_icon_option(_("Move Methods"), &e_opt_move,
			   6, 6, move_options);
  gtk_box_pack_start(GTK_BOX(vbox), w, FALSE, FALSE, 1);
  w = e_create_icon_option(_("Resize Methods"), &e_opt_resize,
			   6, 5, resize_options);
  gtk_box_pack_start(GTK_BOX(vbox), w, FALSE, FALSE, 1);
  w = e_create_icon_option(_("Keyboard focus follows"), &e_opt_focus,
			   6, 3, focus_options);
  gtk_box_pack_start(GTK_BOX(vbox), w, FALSE, FALSE, 1);
  gtk_widget_show(vbox);
  return vbox;
}

/* Pane for special effects */
static GtkWidget   *
__setup_pane_2(void)
{
  GtkWidget          *frame, *frame2, *hbox, *vbox, *w;
  IconOption          slide_options[] =
  {
    {"Opaque", move_opaque_xpm,
     "Windows are slid in a solid fashion"},
    {"Lined", move_lined_xpm,
     "Windows are slid by drawing construction lines around them"},
    {"Box", move_box_xpm,
     "Windows are slid by drawing a box as their outline"},
    {"Shaded", move_shaded_xpm,
     "Windows are slid by drawing a stippled outline of them"},
    {"Semi-Solid", move_semi_solid_xpm,
     "Windows are slid by drawing a chequered outline of them"},
  };

  vbox = gtk_vbox_new(FALSE, 1);
  w = e_create_icon_option(_("Window Sliding Methods"), &e_opt_slide_mode,
			   6, 5, slide_options);
  gtk_box_pack_start(GTK_BOX(vbox), w, FALSE, FALSE, 1);
  w = e_create_rangeonoff(_("Windows slide in when they appear"),
			  &e_opt_map_speed,
			  16.0, 20000.0,
			  _("-"), _("+"),
			  &e_opt_slide_map, 0.0);
  gtk_box_pack_start(GTK_BOX(vbox), w, FALSE, FALSE, 1);
  w = e_create_rangeonoff(_("Windows slide about when cleanup in progress"),
			  &e_opt_cleanup_speed,
			  16.0, 20000.0,
			  _("-"), _("+"),
			  &e_opt_slide_cleanup, 0.0);
  gtk_box_pack_start(GTK_BOX(vbox), w, FALSE, FALSE, 1);
  w = e_create_rangeonoff(_("Desktops slide in when changed"),
			  &e_opt_desk_speed,
			  16.0, 20000.0,
			  _("-"), _("+"),
			  &e_opt_slide_desk, 0.0);
  gtk_box_pack_start(GTK_BOX(vbox), w, FALSE, FALSE, 1);
  w = e_create_onoff(_("Animate menus"), &e_opt_menuslide);
  gtk_box_pack_start(GTK_BOX(vbox), w, FALSE, FALSE, 1);

  gtk_widget_show(vbox);
  return vbox;
}

/* Pane for behavior */
static GtkWidget   *
__setup_pane_3(void)
{
  GtkWidget          *vbox, *w;

  vbox = gtk_vbox_new(FALSE, 1);
  w = e_create_rangeonoff(_("Use tooltips & timeout (sec)"),
			  &e_opt_tooltiptime,
			  0.0, 10.0,
			  _("-"), _("+"),
			  &e_opt_tooltips, 0.0);
  gtk_box_pack_start(GTK_BOX(vbox), w, FALSE, FALSE, 1);
  w = e_create_rangeonoff(_("Window shading speed (pixels / sec)"),
			  &e_opt_shade_speed,
			  16.0, 20000.0,
			  _("-"), _("+"),
			  NULL, 99999.0);
  gtk_box_pack_start(GTK_BOX(vbox), w, FALSE, FALSE, 1);
  w = e_create_rangeonoff(_("Automatic raising of windows after X seconds"),
			  &e_opt_autoraisetime,
			  0.0, 10.0,
			  _("-"), _("+"),
			  &e_opt_autorase, 0.0);
  gtk_box_pack_start(GTK_BOX(vbox), w, FALSE, FALSE, 1);
  w = e_create_onoff(_("Reduce refresh by using memory (use saveunders)"),
		     &e_opt_saveunders);
  gtk_box_pack_start(GTK_BOX(vbox), w, FALSE, FALSE, 1);
  w = e_create_onoff(_("Display icons when windows are iconified"),
		     &e_opt_show_icons);
  gtk_box_pack_start(GTK_BOX(vbox), w, FALSE, FALSE, 1);
  w = e_create_onoff(_("Transient popup windows appear together with leader"),
		     &e_opt_transients_follow_leader);
  gtk_box_pack_start(GTK_BOX(vbox), w, FALSE, FALSE, 1);
  w = e_create_onoff(_("Switch to where popup window appears"),
		     &e_opt_switch_for_transient_map);
  gtk_box_pack_start(GTK_BOX(vbox), w, FALSE, FALSE, 1);
  w = e_create_onoff(_("All new windows that appear get the keyboard focus"),
		     &e_opt_all_new_windows_get_focus);
  gtk_box_pack_start(GTK_BOX(vbox), w, FALSE, FALSE, 1);
  w = e_create_onoff(_("All new popup windows get the keyboard focus"),
		     &e_opt_new_transients_get_focus);
  gtk_box_pack_start(GTK_BOX(vbox), w, FALSE, FALSE, 1);
  w = e_create_onoff(_("Only new popup windows whose owner is focused get the keyboard focus"),
		     &e_opt_e_opt_new_transients_get_focus_if_group_focused);
  gtk_box_pack_start(GTK_BOX(vbox), w, FALSE, FALSE, 1);

  gtk_widget_show(vbox);
  return vbox;
}

/* Pane for desktops */
static GtkWidget   *
__setup_pane_4(void)
{
  GtkWidget          *hbox, *vbox, *w, *frame, *align;

  hbox = gtk_hbox_new(FALSE, 1);

  frame = gtk_frame_new(_("Size of Virtual Screen"));
  gtk_widget_show(frame);
  align = gtk_alignment_new(0.5, 0.0, 0.0, 0.0);
  gtk_widget_show(align);
  gtk_container_add(GTK_CONTAINER(frame), align);
  gtk_box_pack_start(GTK_BOX(hbox), frame, TRUE, TRUE, 1);
  vbox = gtk_vbox_new(FALSE, 1);
  gtk_widget_show(vbox);
  gtk_container_add(GTK_CONTAINER(align), vbox);

  w = e_areas_config();
  gtk_box_pack_start(GTK_BOX(vbox), w, FALSE, FALSE, 1);

  frame = gtk_frame_new(_("Separate Desktops"));
  gtk_widget_show(frame);
  align = gtk_alignment_new(0.5, 0.0, 0.0, 0.0);
  gtk_widget_show(align);
  gtk_container_add(GTK_CONTAINER(frame), align);
  gtk_box_pack_start(GTK_BOX(hbox), frame, TRUE, TRUE, 1);
  vbox = gtk_vbox_new(FALSE, 1);
  gtk_widget_show(vbox);
  gtk_container_add(GTK_CONTAINER(align), vbox);

  w = e_desktops_config();
  gtk_box_pack_start(GTK_BOX(vbox), w, FALSE, FALSE, 1);

  gtk_widget_show(hbox);
  return hbox;
}

/* Pane for backgrounds */

static void
e_set_bg_to_e(Background *bg)
{
  gchar               buf[4096];

  if (!bg)
    return;
  if ((bg->bg.file) && (bg->top.file))
    g_snprintf(buf, sizeof(buf),
	       "set_bg %s %i %i %i %s %i %i %i %i %i %i %s %i %i %i %i %i",
	       bg->name,
	       bg->bg.solid.r, bg->bg.solid.g, bg->bg.solid.b,
	       bg->bg.file, bg->bg.tile, bg->bg.keep_aspect,
	       bg->bg.xjust, bg->bg.yjust, bg->bg.xperc, bg->bg.yperc,
	       bg->top.file, bg->top.keep_aspect, bg->top.xjust,
	       bg->top.yjust, bg->top.xperc, bg->top.yperc);
  else if ((!(bg->bg.file)) && (bg->top.file))
    g_snprintf(buf, sizeof(buf),
	       "set_bg %s %i %i %i %s %i %i %i %i %i %i %s %i %i %i %i %i",
	       bg->name,
	       bg->bg.solid.r, bg->bg.solid.g, bg->bg.solid.b,
	       "(null)", bg->bg.tile, bg->bg.keep_aspect,
	       bg->bg.xjust, bg->bg.yjust, bg->bg.xperc, bg->bg.yperc,
	       bg->top.file, bg->top.keep_aspect, bg->top.xjust,
	       bg->top.yjust, bg->top.xperc, bg->top.yperc);
  else if ((bg->bg.file) && (!(bg->top.file)))
    g_snprintf(buf, sizeof(buf),
	       "set_bg %s %i %i %i %s %i %i %i %i %i %i %s %i %i %i %i %i",
	       bg->name,
	       bg->bg.solid.r, bg->bg.solid.g, bg->bg.solid.b,
	       bg->bg.file, bg->bg.tile, bg->bg.keep_aspect,
	       bg->bg.xjust, bg->bg.yjust, bg->bg.xperc, bg->bg.yperc,
	       "(null)", bg->top.keep_aspect, bg->top.xjust,
	       bg->top.yjust, bg->top.xperc, bg->top.yperc);
  else if ((!(bg->bg.file)) && (!(bg->top.file)))
    g_snprintf(buf, sizeof(buf),
	       "set_bg %s %i %i %i %s %i %i %i %i %i %i %s %i %i %i %i %i",
	       bg->name,
	       bg->bg.solid.r, bg->bg.solid.g, bg->bg.solid.b,
	       "(null)", bg->bg.tile, bg->bg.keep_aspect,
	       bg->bg.xjust, bg->bg.yjust, bg->bg.xperc, bg->bg.yperc,
	       "(null)", bg->top.keep_aspect, bg->top.xjust,
	       bg->top.yjust, bg->top.xperc, bg->top.yperc);
  printf("%s\n", buf);
  CommsSend(buf);
}

static void 
e_set_bg_setting_widgets(void)
{
  gint a, r, g, b;
  gdouble             col[4];
  
  gtk_signal_handler_block(GTK_OBJECT(bg_bg_tile), h1);
  gtk_signal_handler_block(GTK_OBJECT(bg_bg_aspect), h2);
  gtk_signal_handler_block(GTK_OBJECT(bg_bg_maxv), h3);
  gtk_signal_handler_block(GTK_OBJECT(bg_bg_maxh), h4);
  gtk_signal_handler_block(GTK_OBJECT(bg_fg_aspect), h5);
  gtk_signal_handler_block(GTK_OBJECT(bg_fg_maxv), h6);
  gtk_signal_handler_block(GTK_OBJECT(bg_fg_maxh), h7);
/*  gtk_signal_handler_block(GTK_OBJECT(color_selector), h8);*/
/*  gtk_signal_handler_block(GTK_OBJECT(bg_fg_pos), h9);
  gtk_signal_handler_block(GTK_OBJECT(bg_bg_file_entry), h10);
 */
  if (deskbg[curdesk])
    {
      if (deskbg[curdesk]->bg.file)
	gtk_entry_set_text(GTK_ENTRY(bg_bg_file_entry), 
			   deskbg[curdesk]->bg.file);
      else
	gtk_entry_set_text(GTK_ENTRY(bg_bg_file_entry), "");
      if (deskbg[curdesk]->top.file)
	gtk_entry_set_text(GTK_ENTRY(bg_fg_file_entry), 
			   deskbg[curdesk]->top.file);
      else
	gtk_entry_set_text(GTK_ENTRY(bg_fg_file_entry), "");
      
      gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(bg_bg_tile), 
				  deskbg[curdesk]->bg.tile);

      gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(bg_bg_aspect), 
				  deskbg[curdesk]->bg.keep_aspect);
      
      if (deskbg[curdesk]->bg.yperc > 512)
	gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(bg_bg_maxv), 1);
      else
	gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(bg_bg_maxv), 0);
      
      if (deskbg[curdesk]->bg.xperc > 512)
	gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(bg_bg_maxh), 1);
      else
	gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(bg_bg_maxh), 0);
      
      gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(bg_fg_aspect), 
				  deskbg[curdesk]->top.keep_aspect);
      
      if (deskbg[curdesk]->top.yperc > 512)
	gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(bg_fg_maxv), 1);
      else
	gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(bg_fg_maxv), 0);
      
      if (deskbg[curdesk]->top.xperc > 512)
	gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(bg_fg_maxh), 1);
      else
	gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(bg_fg_maxh), 0);

      a = deskbg[curdesk]->top.xjust / 341;
      b = deskbg[curdesk]->top.yjust / 341;
      if (a < 0) 
	a = 0;
      else if (a > 2)
	a = 2;
      if (b < 0) 
	b = 0;
      else if (b > 2)
	b = 2;
      switch((b * 3) + a)
	{
	 case 0:
	  gtk_option_menu_set_history(GTK_OPTION_MENU(bg_fg_pos), 0);
	  break;
	 case 1:
	  gtk_option_menu_set_history(GTK_OPTION_MENU(bg_fg_pos), 1);
	  break;
	 case 2:
	  gtk_option_menu_set_history(GTK_OPTION_MENU(bg_fg_pos), 2);
	  break;
	 case 3:
	  gtk_option_menu_set_history(GTK_OPTION_MENU(bg_fg_pos), 7);
	  break;
	 case 4:
	  gtk_option_menu_set_history(GTK_OPTION_MENU(bg_fg_pos), 8);
	  break;
	 case 5:
	  gtk_option_menu_set_history(GTK_OPTION_MENU(bg_fg_pos), 3);
	  break;
	 case 6:
	  gtk_option_menu_set_history(GTK_OPTION_MENU(bg_fg_pos), 6);
	  break;
	 case 7:
	  gtk_option_menu_set_history(GTK_OPTION_MENU(bg_fg_pos), 5);
	  break;
	 case 8:
	  gtk_option_menu_set_history(GTK_OPTION_MENU(bg_fg_pos), 4);
	  break;
	 default:
	  break;
	}
      
      if (color_selector)
	{      
	  r = deskbg[curdesk]->bg.solid.r;
	  g = deskbg[curdesk]->bg.solid.g;
	  b = deskbg[curdesk]->bg.solid.b;
	  col[0] = ((gdouble) r) / 255;
	  col[1] = ((gdouble) g) / 255;
	  col[2] = ((gdouble) b) / 255;
	  col[3] = 0;
	  gtk_color_selection_set_color(GTK_COLOR_SELECTION(color_selector), 
					col);
	}
    }
  else
    {
      gtk_entry_set_text(GTK_ENTRY(bg_bg_file_entry), "");
      gtk_entry_set_text(GTK_ENTRY(bg_fg_file_entry), "");
      
      gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(bg_bg_tile), 0);
      gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(bg_bg_aspect), 0);
      gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(bg_bg_maxv), 0);
      gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(bg_bg_maxh), 0);
      gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(bg_fg_aspect), 0);
      gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(bg_fg_maxv), 0);
      gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(bg_fg_maxh), 0);
      gtk_option_menu_set_history(GTK_OPTION_MENU(bg_fg_pos), 0);
      
      if (color_selector)
	{      
	  r = 0;
	  g = 0;
	  b = 0;
	  col[0] = ((gdouble) r) / 255;
	  col[1] = ((gdouble) g) / 255;
	  col[2] = ((gdouble) b) / 255;
	  col[3] = 0;
	  gtk_color_selection_set_color(GTK_COLOR_SELECTION(color_selector), 
					col);
	}
    }
  gtk_signal_handler_unblock(GTK_OBJECT(bg_bg_tile), h1);
  gtk_signal_handler_unblock(GTK_OBJECT(bg_bg_aspect), h2);
  gtk_signal_handler_unblock(GTK_OBJECT(bg_bg_maxv), h3);
  gtk_signal_handler_unblock(GTK_OBJECT(bg_bg_maxh), h4);
  gtk_signal_handler_unblock(GTK_OBJECT(bg_fg_aspect), h5);
  gtk_signal_handler_unblock(GTK_OBJECT(bg_fg_maxv), h6);
  gtk_signal_handler_unblock(GTK_OBJECT(bg_fg_maxh), h7);
/*  gtk_signal_handler_unblock(GTK_OBJECT(color_selector), h8);*/
/*  gtk_signal_handler_unblock(GTK_OBJECT(bg_fg_pos), h9);
  gtk_signal_handler_unblock(GTK_OBJECT(bg_bg_file_entry), h10);
 */
}

static void
e_display_desktop_bg(void)
{
  static GdkPixmap *pmap = NULL;
  Background *bg = NULL;
  GtkWidget *area;
  GdkColor col;
  
  area = desk_mini_display_area;
  if (!area)
    return;
  if (!GTK_WIDGET_REALIZED(area))
    return;
  if (deskbg[curdesk])
    {
      if (deskbg[curdesk]->gpmap)
	e_gradmode(1);
      else
	e_gradmode(0);
      
      if (!pmap)
	pmap = gdk_pixmap_new(area->window, 128, 96, -1);
      gdk_window_set_back_pixmap(area->window, pmap, FALSE);
      gdk_flush();
      e_render_bg_onto(pmap, deskbg[curdesk]);
      gdk_flush();
      gdk_window_clear(area->window);
    }
  else
    {
      gdk_color_black(gdk_colormap_get_system(), &col);
      gdk_window_set_background(area->window, &col);
      gdk_window_clear(area->window);
    }
}

static void
e_cb_expose_mini_desk(GtkWidget *widget, gpointer data)
{
  static gchar did_first_draw = 0;
  
  if (!did_first_draw)
    {
      did_first_draw = 1;
      e_display_desktop_bg();
    }
}

static void
e_cb_expose_crange(GtkWidget *widget, gpointer data)
{
  static gchar did_first_draw = 0;
  
  if (!did_first_draw)
    {
      e_set_bg_setting_widgets();
      did_first_draw = 1;
    }
}

static void
e_cb_set_current_desk(GtkWidget *widget, gpointer data)
{
  curdesk = (gint) data;
  e_display_desktop_bg();
  e_set_bg_setting_widgets();
}

static void
e_rebuild_desk_menu(void)
{
  gint i;
  GtkWidget *mi;
  gchar               s[256];

  if (desk_select_menu)
    gtk_widget_destroy(desk_select_menu);
  desk_select_menu = gtk_menu_new();
  gtk_widget_show(desk_select_menu);
  for (i = 0; i < (gint) e_opt_number_of_desks; i++)
    {
      g_snprintf(s, sizeof(s), "Desktop %i", i);
      mi = gtk_menu_item_new_with_label(s);
      gtk_widget_show(mi);
      gtk_signal_connect(GTK_OBJECT(mi), "activate", 
			 GTK_SIGNAL_FUNC(e_cb_set_current_desk), (gpointer)i);
      gtk_menu_append(GTK_MENU(desk_select_menu), mi);
    }
  if (desk_option_menu)
    {
      gtk_option_menu_set_menu(GTK_OPTION_MENU(desk_option_menu), desk_select_menu);
      gtk_option_menu_set_history(GTK_OPTION_MENU(desk_option_menu), 0);
      if (curdesk != 0)
	{
	  curdesk = 0;      
	  e_display_desktop_bg();
	  e_set_bg_setting_widgets();
	}
    }
}

static void
e_cb_bg_sel(GtkWidget *widget, gpointer data)
{
  Background *bg;
  GtkWidget *c;
  
  bg = (Background *)gtk_object_get_data(GTK_OBJECT(widget), "bg");  
  if (!bg)
    return;
  if (bg != deskbg[curdesk])
    {
      deskbgchanged[curdesk] = 1;
      c = (GtkWidget *)gtk_object_get_data(GTK_OBJECT(widget), "capplet");
      capplet_widget_state_changed(CAPPLET_WIDGET(c), FALSE);
      deskbg[curdesk] = bg;
      e_display_desktop_bg();
      e_set_bg_setting_widgets();
    }
 }

static void
e_cb_grad_sel(GtkWidget *widget, gpointer data)
{
  Background *bg;
  GtkWidget *c;
  
  bg = (Background *)data;  
  if (!bg)
    return;
  if (bg != deskbg[curdesk])
    {
      deskbgchanged[curdesk] = 1;
      c = (GtkWidget *)gtk_object_get_data(GTK_OBJECT(widget), "capplet");
      capplet_widget_state_changed(CAPPLET_WIDGET(c), FALSE);
      deskbg[curdesk] = bg;
      e_display_desktop_bg();
      e_set_bg_setting_widgets();
    }
 }

static void
e_cb_bg_none(GtkWidget *widget, gpointer data)
{
  deskbgchanged[curdesk] = 1;
  deskbg[curdesk] = NULL;
  
  e_set_bg_setting_widgets();
  e_display_desktop_bg();
  capplet_widget_state_changed(CAPPLET_WIDGET(current_capplet), FALSE);
}

static void
e_cb_bg_new(GtkWidget *widget, gpointer data)
{
  GdkPixmap *pmap;
  GdkImlibImage *im;
  Background *bg;
  gint j, la, ra, ta, ba;
  gchar s[4096];
  
  j = g_list_length(backgrounds);
  
  bg = g_malloc(sizeof(Background));
  
  backgrounds = g_list_append(backgrounds, bg);
  
  g_snprintf(s, sizeof(s), "ECONF_GEN_%x_%x", time(NULL), rand());
  bg->name = g_strdup(s);
  bg->bg.file = NULL;
  bg->top.file = NULL;
  bg->gpmap = NULL;
  bg->bg.solid.r = 0;
  bg->bg.solid.g = 0;
  bg->bg.solid.b = 0;
  bg->bg.tile = 1;
  bg->bg.keep_aspect = 0;
  bg->bg.xjust = 512;
  bg->bg.yjust = 512;
  bg->bg.xperc = 0;
  bg->bg.yperc = 0;
  bg->top.keep_aspect = 0;
  bg->top.xjust = 512;
  bg->top.yjust = 512;
  bg->top.xperc = 0;
  bg->top.yperc = 0;
  bg->changed = 0;
  e_set_bg_to_e(bg);
  
  deskbg[curdesk] = bg;
  g_snprintf(s, sizeof(s), "%s/.e-conf/%s", getenv("HOME"), bg->name);

  pmap = gdk_pixmap_new(current_capplet->window, 64, 48, -1);
  e_render_bg_onto(pmap, bg);
  im = gdk_imlib_create_image_from_drawable(pmap, NULL, 0, 0, 64, 48);
  if (im)
    {
      gdk_imlib_save_image_to_ppm(im, s);
      gdk_imlib_kill_image(im);
    }

  bg->pmap = gtk_pixmap_new(pmap, NULL);
  bg->gpmap = NULL;
  bg->table = image_table_list;
  gdk_pixmap_unref(pmap);

  bg->button = gtk_button_new();
  gtk_object_set_data(GTK_OBJECT(bg->button), "bg", bg);
  gtk_object_set_data(GTK_OBJECT(bg->button), "capplet", 
		      (gpointer) current_capplet);
  gtk_widget_show(bg->button);
  bg->box = gtk_hbox_new(FALSE, 1);
  gtk_container_set_border_width(GTK_CONTAINER(bg->box), 1);
  gtk_widget_show(bg->box);
  gtk_container_add(GTK_CONTAINER(bg->button), bg->box);
  gtk_widget_show(bg->pmap);
  gtk_box_pack_start(GTK_BOX(bg->box), bg->pmap, FALSE, FALSE, 0);
  gtk_signal_connect(GTK_OBJECT(bg->button), "clicked",
		     GTK_SIGNAL_FUNC(e_cb_bg_sel), NULL);
  ta = j / table_size;
  ba = ta + 1;
  la = j % table_size;
  ra = la + 1;
  gtk_table_attach_defaults(GTK_TABLE(image_table_list), bg->button, 
			    la, ra, ta, ba);
  
  deskbgchanged[curdesk] = 1;
  deskbg[curdesk] = bg;  
  e_set_bg_setting_widgets();
  e_display_desktop_bg();
  capplet_widget_state_changed(CAPPLET_WIDGET(current_capplet), FALSE);
  
  gtk_widget_show(edit_win);
}

static void
e_del_bg_from_e(Background *bg)
{
  gchar buf[256], cmd[4096];
  gchar changed = 0;
  gint i;
  
  g_snprintf(cmd, sizeof(cmd), "use_no_bg ");
  for (i = 0; i < 32; i++)
    {
      if (deskbg[i] == bg)
	{
	  g_snprintf(buf, sizeof(buf), " %i", i);
	  strcat(cmd, buf);
	  changed = 1;
	  deskbg[i] = NULL;
	}
    }
  if (changed)
    CommsSend(cmd);
  g_snprintf(cmd, sizeof(cmd), "del_bg %s", bg->name);
  CommsSend(cmd);
}

static void
e_cb_bg_delete(GtkWidget *widget, gpointer data)
{
  deskbgchanged[curdesk] = 1;

  return;
  if ((deskbg[curdesk]) && (deskbg[curdesk]->gpmap))
    return;
  if (backgrounds)
    {
      gchar               s[4096], have_deleted = 0;
      int                 i, j, la, ra, ta, ba;
      GList              *ptr;

      j = g_list_length(backgrounds);

      ptr = backgrounds;
      i = 0;
      while(ptr)
	{
	  Background         *bg = NULL;
	  GtkWidget          *l_hb, *l_label, *l_pixmap, *l_item;

	  if (progress)
	    {
	      gtk_progress_bar_update(GTK_PROGRESS_BAR(progress),
				      (gfloat) i / (gfloat) j);
	      gtk_widget_draw(progress, NULL);
	    }
	  bg = ptr->data;
	  ptr = ptr->next;
	  if (bg)
	    {
	      if (bg == deskbg[curdesk])
		{
		  e_del_bg_from_e(bg);
		  backgrounds = g_list_remove(backgrounds, bg);
		  gtk_widget_destroy(bg->button);
		  if (bg->name)
		    g_free(bg->name);
		  if (bg->bg.file)
		    g_free(bg->bg.file);
		  if (bg->top.file)
		    g_free(bg->top.file);
		  g_free(bg);
		  have_deleted = 1;
		  i--;
		}
	      else if (have_deleted)
		{
		  ta = i / table_size;
		  ba = ta + 1;
		  la = i % table_size;
		  ra = la + 1;
		  gtk_widget_ref(bg->button);
		  gtk_container_remove(GTK_CONTAINER(bg->table), bg->button);
		  gtk_table_attach_defaults(GTK_TABLE(bg->table), bg->button, 
					    la, ra, ta, ba);
		  gtk_widget_unref(bg->button);
		}
	    }
	  i++;
	}
    }
  
  deskbg[curdesk] = NULL;
  e_set_bg_setting_widgets();
  e_display_desktop_bg();
  capplet_widget_state_changed(CAPPLET_WIDGET(current_capplet), FALSE);
}

static void
e_cb_bg_apply(GtkWidget *widget, gpointer data)
{
  deskbgchanged[curdesk] = 1;
  if (deskbg[curdesk])
    {
      deskbg[curdesk]->changed = 1;
      e_set_bg_to_e(deskbg[curdesk]);
      redo_bg(deskbg[curdesk]);
    }
  e_set_bg_setting_widgets();
  e_display_desktop_bg();
  capplet_widget_state_changed(CAPPLET_WIDGET(current_capplet), FALSE);
}

static void
redo_bg(Background *bg)
{
  GtkWidget          *l_pixmap;
  GdkPixmap          *pmap;
  GdkImlibImage      *im;
  gchar               s[4096];
  
  if (!bg)
    return;
  
  pmap = gdk_pixmap_new(current_capplet->window, 64, 48, -1);
  g_snprintf(s, sizeof(s), "%s/.e-conf/%s", getenv("HOME"), bg->name);
  im = gdk_imlib_load_image(s);
  e_render_bg_onto(pmap, bg);
  im = gdk_imlib_create_image_from_drawable(pmap, NULL, 0, 0,
					    64, 48);
  if (im)
    {
      gdk_imlib_save_image_to_ppm(im, s);
      gdk_imlib_kill_image(im);
    }
  l_pixmap = gtk_pixmap_new(pmap, NULL);
  gdk_pixmap_unref(pmap);
  gtk_widget_destroy(bg->pmap);
  bg->pmap = l_pixmap;
  gtk_widget_show(l_pixmap);
  gtk_box_pack_start(GTK_BOX(bg->box), l_pixmap, FALSE, FALSE, 0);
}

static void
e_cb_img_onoff(GtkWidget * widget, gpointer data)
{
  GtkWidget          *c;
  Background         *bg;
  gint                value;
  
  bg = deskbg[curdesk];
  if (!bg)
    return;
  c = (GtkWidget *) gtk_object_get_data(GTK_OBJECT(widget), "capplet");
  capplet_widget_state_changed(CAPPLET_WIDGET(c), FALSE);
  value = (gint) data;
  
  if (GTK_TOGGLE_BUTTON(widget)->active)
    {
      switch(value)
	{
	 case 0:
	  if (bg->bg.tile != 1)
	    {
	      bg->bg.tile = 1;
	      e_cb_bg_apply(NULL, NULL);
	    }
	  break;
	 case 1:
	  if (bg->bg.yperc != 1024)
	    {
	      bg->bg.yperc = 1024;
	      e_cb_bg_apply(NULL, NULL);
	    }
	  break;
	 case 2:
	  if (bg->bg.xperc != 1024)
	    {
	      bg->bg.xperc = 1024;
	      e_cb_bg_apply(NULL, NULL);
	    }
	  break;
	 case 3:
	  if (bg->bg.keep_aspect != 1)
	    {
	      bg->bg.keep_aspect = 1;
	      e_cb_bg_apply(NULL, NULL);
	    }
	  break;
	 case 4:
	  if (bg->top.yperc != 1024)
	    {
	      bg->top.yperc = 1024;
	      e_cb_bg_apply(NULL, NULL);
	    }
	  break;
	 case 5:
	  if (bg->top.xperc != 1024)
	    {
	      bg->top.xperc = 1024;
	      e_cb_bg_apply(NULL, NULL);
	    }
	  break;
	 case 6:
	  if (bg->top.keep_aspect != 1)
	    {
	      bg->top.keep_aspect = 1;
	      e_cb_bg_apply(NULL, NULL);
	    }
	  break;
	 default:
	  break;
	}
    }
  else
    {
      switch(value)
	{
	 case 0:
	  if (bg->bg.tile != 0)
	    {
	      bg->bg.tile = 0;
	      e_cb_bg_apply(NULL, NULL);
	    }
	  break;
	 case 1:
	  if (bg->bg.yperc != 0)
	    {
	      bg->bg.yperc = 0;
	      e_cb_bg_apply(NULL, NULL);
	    }
	  break;
	 case 2:
	  if (bg->bg.xperc != 0)
	    {
	      bg->bg.xperc = 0;
	      e_cb_bg_apply(NULL, NULL);
	    }
	  break;
	 case 3:
	  if (bg->bg.keep_aspect != 0)
	    {
	      bg->bg.keep_aspect = 0;
	      e_cb_bg_apply(NULL, NULL);
	    }
	  break;
	 case 4:
	  if (bg->top.yperc != 0)
	    {
	      bg->top.yperc = 0;
	      e_cb_bg_apply(NULL, NULL);
	    }
	  break;
	 case 5:
	  if (bg->top.xperc != 0)
	    {
	      bg->top.xperc = 0;
	      e_cb_bg_apply(NULL, NULL);
	    }
	  break;
	 case 6:
	  if (bg->top.keep_aspect != 0)
	    {
	      bg->top.keep_aspect = 0;
	      e_cb_bg_apply(NULL, NULL);
	    }
	  break;
	 default:
	  break;
	}
    }
}

static void
e_cb_img_position(GtkWidget * widget, gpointer data)
{
  GtkWidget          *c;
  Background         *bg;
  gint                value;
  
  bg = deskbg[curdesk];
  if (!bg)
    return;
  c = (GtkWidget *) gtk_object_get_data(GTK_OBJECT(widget), "capplet");
  capplet_widget_state_changed(CAPPLET_WIDGET(c), FALSE);
  value = (gint) data;
  
  switch(value)
    {
     case 0:
      if ((bg->top.xjust != 0) || (bg->top.yjust != 0))
	{
	  bg->top.xjust = 0;
	  bg->top.yjust = 0;
	  e_cb_bg_apply(NULL, NULL);
	}
      break;
     case 1:
      if ((bg->top.xjust != 512) || (bg->top.yjust != 0))
	{
	  bg->top.xjust = 512;
	  bg->top.yjust = 0;
	  e_cb_bg_apply(NULL, NULL);
	}
      break;
     case 2:
      if ((bg->top.xjust != 1024) || (bg->top.yjust != 0))
	{
	  bg->top.xjust = 1024;
	  bg->top.yjust = 0;
	  e_cb_bg_apply(NULL, NULL);
	}
      break;
     case 3:
      if ((bg->top.xjust != 1024) || (bg->top.yjust != 512))
	{
	  bg->top.xjust = 1024;
	  bg->top.yjust = 512;
	  e_cb_bg_apply(NULL, NULL);
	}
      break;
     case 4:
      if ((bg->top.xjust != 1024) || (bg->top.yjust != 1024))
	{
	  bg->top.xjust = 1024;
	  bg->top.yjust = 1024;
	  e_cb_bg_apply(NULL, NULL);
	}
      break;
     case 5:
      if ((bg->top.xjust != 512) || (bg->top.yjust != 1024))
	{
	  bg->top.xjust = 512;
	  bg->top.yjust = 1024;
	  e_cb_bg_apply(NULL, NULL);
	}
      break;
     case 6:
      if ((bg->top.xjust != 1024) || (bg->top.yjust != 1024))
	{
	  bg->top.xjust = 0;
	  bg->top.yjust = 1024;
	  e_cb_bg_apply(NULL, NULL);
	}
      break;
     case 7:
      if ((bg->top.xjust != 0) || (bg->top.yjust != 512))
	{
	  bg->top.xjust = 0;
	  bg->top.yjust = 512;
	  e_cb_bg_apply(NULL, NULL);
	}
      break;
     case 8:
      if ((bg->top.xjust != 512) || (bg->top.yjust != 512))
	{
	  bg->top.xjust = 512;
	  bg->top.yjust = 512;
	  e_cb_bg_apply(NULL, NULL);
	}
      break;
     default:
      break;
    }
}

static void
e_cb_change_col(GtkWidget * widget, GtkWidget * w)
{
  gdouble             col[4];
  int                 r, g, b;
  static int          pr = -1, pg = -1, pb = -1;

  gtk_color_selection_get_color(GTK_COLOR_SELECTION(w), col);
  r = (int)(col[0] * (gdouble) 255);
  g = (int)(col[1] * (gdouble) 255);
  b = (int)(col[2] * (gdouble) 255);
  
  printf("col change %i %i %i\n", r, g, b);
  
  if ((deskbg[curdesk]) &&
      (deskbg[curdesk]->bg.solid.r == r) &&
      (deskbg[curdesk]->bg.solid.g == g) &&
      (deskbg[curdesk]->bg.solid.b == b))
    {
      printf("same colors\n");
      return;
    }
  
  if (deskbg[curdesk])
    {
	
      deskbg[curdesk]->changed = 1;
      deskbg[curdesk]->bg.solid.r = r;
      deskbg[curdesk]->bg.solid.g = g;
      deskbg[curdesk]->bg.solid.b = b;
      if ((r == pr) && (g == pg) && (g = pg))
	return;
      e_cb_bg_apply(NULL, NULL);
    }
}

static GtkWidget *
e_create_solid_selector(void)
{
  GtkWidget *vbox, *colsel;
  
  vbox = gtk_vbox_new(FALSE, 1);
  gtk_widget_show(vbox);
  
  colsel = gtk_color_selection_new();
  gtk_color_selection_set_update_policy(GTK_COLOR_SELECTION(colsel),
					GTK_UPDATE_DISCONTINUOUS);
  gtk_widget_show(colsel);
  
  gtk_box_pack_start(GTK_BOX(vbox), colsel, FALSE, FALSE, 1);
  
  color_selector = colsel;
  h8 = gtk_signal_connect(GTK_OBJECT(colsel), "color_changed", 
			  GTK_SIGNAL_FUNC(e_cb_change_col), colsel);
  return vbox;
}

static void
e_gradmode(int mode)
{
/*  
  if(mode)
    {
      gtk_widget_set_sensitive(note_solid1, FALSE);
      gtk_widget_set_sensitive(note_solid2, FALSE);
      gtk_widget_set_sensitive(note_grad1, TRUE);
      gtk_widget_set_sensitive(note_grad2, TRUE);
      gtk_widget_set_sensitive(note_bg1, FALSE);
      gtk_widget_set_sensitive(note_bg2, FALSE);
    }
  else
    {
      gtk_widget_set_sensitive(note_solid1, TRUE);
      gtk_widget_set_sensitive(note_solid2, TRUE);
      gtk_widget_set_sensitive(note_grad1, FALSE);
      gtk_widget_set_sensitive(note_grad2, FALSE);
      gtk_widget_set_sensitive(note_bg1, TRUE);
      gtk_widget_set_sensitive(note_bg2, TRUE);
    }
 */
}

static GtkWidget *
e_create_gradient_selector(void)
{
  GtkWidget          *hbox, *w, *scrolled_win, *list, *frame, *area, *table,
                     *label, *button, *om, *arrow, *vbox, *entry, *check,
                     *align, *line, *bbox, *carea, *m, *mi, *note, *table2,
                     *vbox2, *win;
  gint                i;
  
  table2 = gtk_table_new(1, 1, FALSE);
  gtk_widget_show(table2);
  gtk_notebook_append_page(GTK_NOTEBOOK(note), table2, label);
  note_grad1 = table2;
  note_grad2 = label;
 
  align = gtk_alignment_new(0.5, 0.5, 0.0, 0.0);
  gtk_widget_show(align);
  gtk_table_attach_defaults(GTK_TABLE(table2), align, 1, 2, 0, 1);
  button = gtk_button_new_with_label(_("Edit gradient colours..."));
  gtk_widget_show(button);
  gtk_container_add(GTK_CONTAINER(align), button);

  m = gtk_menu_new();
  gtk_widget_show(m);
  if (backgrounds)
    {
      GList              *ptr;

      ptr = backgrounds;
      while (ptr)
	{
	  Background         *bg;

	  bg = ptr->data;
	  ptr = ptr->next;
	  if ((bg) && (bg->gpmap))
	    {
	      mi = gtk_menu_item_new();
	      gtk_menu_append(GTK_MENU(m), mi);
	      gtk_widget_show(mi);
	      frame = gtk_frame_new(NULL);
	      gtk_widget_show(frame);
	      gtk_frame_set_shadow_type(GTK_FRAME(frame), GTK_SHADOW_IN);
	      gtk_container_add(GTK_CONTAINER(mi), frame);
	      gtk_container_add(GTK_CONTAINER(frame), bg->gpmap);
	      gtk_widget_show(bg->gpmap);
	      gtk_object_set_data(GTK_OBJECT(mi), "capplet", 
				  (gpointer) current_capplet);
	      bg->gbox = frame;
	      gtk_signal_connect(GTK_OBJECT(mi), "activate", 
				 GTK_SIGNAL_FUNC(e_cb_grad_sel), 
				 (gpointer)bg);
	    }
	}
    }
  om = gtk_option_menu_new();
  gtk_widget_show(om);
  gtk_option_menu_set_menu(GTK_OPTION_MENU(om), m);
  gtk_option_menu_set_history(GTK_OPTION_MENU(om), 0);

  align = gtk_alignment_new(0.5, 0.5, 0.0, 0.0);
  gtk_widget_show(align);
  gtk_container_add(GTK_CONTAINER(align), om);
  gtk_table_attach_defaults(GTK_TABLE(table2), align, 0, 1, 0, 1);
  
  return table2;
}

static void
func_img_filesel_ok(GtkWidget *widget, gpointer * data)
{
  Background *bg;
  
  if (!data)
    return;
  bg = deskbg[curdesk];
  if (!bg)
    return;
  
  if (bg->bg.file)
    g_free(bg->bg.file);
  if (isfile((gchar *)data))
    {
      gtk_entry_set_text(GTK_ENTRY(bg_bg_file_entry), (gchar *)data);
      bg->bg.file = g_strdup((gchar *)data);
    }
  else
    bg->bg.file = NULL;
  e_cb_bg_apply(NULL, NULL);
}

static void
e_cb_img_browse(GtkWidget * widget, gpointer data)
{
  static GtkWidget *filesel = NULL;
  gchar *file;

  if (!filesel)
    {
      filesel = ee_filesel_new();
      ee_filesel_hide_savedialog(filesel);
      ee_filesel_unset_printout(filesel);
      gtk_signal_connect(GTK_OBJECT(filesel), "ok_clicked",
			 GTK_SIGNAL_FUNC(func_img_filesel_ok), NULL);
    }
  file = gtk_entry_get_text(GTK_ENTRY(bg_bg_file_entry));
  ee_filesel_set_filename(filesel, file);
  gtk_widget_show(filesel);
}

static void
func_overlay_filesel_ok(GtkWidget *widget, gpointer * data)
{
  Background *bg;
  
  printf("ok %s\n", data);
  if (!data)
    return;
  bg = deskbg[curdesk];
  if (!bg)
    return;
  
  if (bg->top.file)
    g_free(bg->top.file);
  if (isfile((gchar *)data))
    {
      gtk_entry_set_text(GTK_ENTRY(bg_fg_file_entry), (gchar *)data);
      bg->top.file = g_strdup((gchar *)data);
    }
  else
    bg->top.file = NULL;
  printf("- %s\n", bg->top.file);
  e_cb_bg_apply(NULL, NULL);
}

static void
e_cb_overlay_browse(GtkWidget * widget, gpointer data)
{
  static GtkWidget *filesel = NULL;
  gchar *file;

  if (!filesel)
    {
      filesel = ee_filesel_new();
      ee_filesel_hide_savedialog(filesel);
      ee_filesel_unset_printout(filesel);
      gtk_signal_connect(GTK_OBJECT(filesel), "ok_clicked",
			 GTK_SIGNAL_FUNC(func_overlay_filesel_ok), NULL);
    }
  file = gtk_entry_get_text(GTK_ENTRY(bg_fg_file_entry));
  ee_filesel_set_filename(filesel, file);
  gtk_widget_show(filesel);
}

static void
e_cb_img_none(GtkWidget * widget, gpointer data)
{
  gchar *file;
  Background *bg;
  
  bg = deskbg[curdesk];
  if (!bg)
    return;

  if (!bg->bg.file)
    return;
  g_free(bg->bg.file);
  bg->bg.file = NULL;
  gtk_entry_set_text(GTK_ENTRY(bg_bg_file_entry), "");

  e_cb_bg_apply(NULL, NULL);
}

static void
e_cb_overlay_none(GtkWidget * widget, gpointer data)
{
  gchar *file;
  Background *bg;
  
  bg = deskbg[curdesk];
  if (!bg)
    return;

  if (!bg->top.file)
    return;
  g_free(bg->top.file);
  bg->top.file = NULL;
  gtk_entry_set_text(GTK_ENTRY(bg_fg_file_entry), "");

  e_cb_bg_apply(NULL, NULL);
}

static GtkWidget *
e_create_image_selector(void)
{
  GtkWidget          *hbox, *w, *scrolled_win, *list, *frame, *area, *table,
                     *label, *button, *om, *arrow, *vbox, *entry, *check,
                     *align, *line, *bbox, *carea, *m, *mi, *note, *table2,
                     *vbox2, *win;
  gint                i;
  
  vbox = gtk_vbox_new(FALSE, 1);
  gtk_widget_show(vbox);
  
  frame = gtk_frame_new(_("Image file"));
  gtk_widget_show(frame);
  gtk_box_pack_start(GTK_BOX(vbox), frame, FALSE, FALSE, 1);
  
  hbox = gtk_hbox_new(FALSE, 1);
  gtk_widget_show(hbox);
  gtk_container_add(GTK_CONTAINER(frame), hbox);
  
  entry = gtk_entry_new_with_max_length(4096);
  bg_bg_file_entry = entry;
  gtk_widget_show(entry);
  gtk_box_pack_start(GTK_BOX(hbox), entry, TRUE, TRUE, 1);
  gtk_widget_set_sensitive(entry, FALSE);
  
  button = gtk_button_new_with_label(_("Browse"));
  gtk_widget_show(button);
  gtk_box_pack_start(GTK_BOX(hbox), button, FALSE, FALSE, 1);
  gtk_signal_connect(GTK_OBJECT(button), "clicked", 
		     GTK_SIGNAL_FUNC(e_cb_img_browse), NULL);

  button = gtk_button_new_with_label(_("None"));
  gtk_widget_show(button);
  gtk_box_pack_start(GTK_BOX(hbox), button, FALSE, FALSE, 1);
  gtk_signal_connect(GTK_OBJECT(button), "clicked", 
		     GTK_SIGNAL_FUNC(e_cb_img_none), NULL);

  frame = gtk_frame_new(_("Image display options"));
  gtk_widget_show(frame);
  gtk_box_pack_start(GTK_BOX(vbox), frame, TRUE, TRUE, 1);
  
  table = gtk_table_new(2, 2, TRUE);
  gtk_widget_show(table);
  gtk_container_add(GTK_CONTAINER(frame), table);
  
  check = gtk_check_button_new_with_label(_("Repeat tiles across screen"));
  bg_bg_tile = check;
  gtk_widget_show(check);
  gtk_object_set_data(GTK_OBJECT(check), "capplet", (gpointer) current_capplet);
  h1 = gtk_signal_connect(GTK_OBJECT(check), "toggled", GTK_SIGNAL_FUNC(e_cb_img_onoff), 
			  (gpointer) 0);
  gtk_table_attach_defaults(GTK_TABLE(table), check, 0, 1, 0, 1);
  
  check = gtk_check_button_new_with_label(_("Retain image aspect ratio"));
  bg_bg_aspect = check;
  gtk_widget_show(check);
  gtk_object_set_data(GTK_OBJECT(check), "capplet", (gpointer) current_capplet);
  h2 = gtk_signal_connect(GTK_OBJECT(check), "toggled", GTK_SIGNAL_FUNC(e_cb_img_onoff), 
			  (gpointer) 3);
  gtk_table_attach_defaults(GTK_TABLE(table), check, 1, 2, 0, 1);
  
  check = gtk_check_button_new_with_label(_("Maximise height to fit screen"));
  bg_bg_maxv = check;
  gtk_widget_show(check);
  gtk_object_set_data(GTK_OBJECT(check), "capplet", (gpointer) current_capplet);
  h3 = gtk_signal_connect(GTK_OBJECT(check), "toggled", GTK_SIGNAL_FUNC(e_cb_img_onoff), 
		     (gpointer) 1);
  gtk_table_attach_defaults(GTK_TABLE(table), check, 0, 1, 1, 2);
  
  check = gtk_check_button_new_with_label(_("Maximise width to fit screen"));
  bg_bg_maxh = check;
  gtk_widget_show(check);
  gtk_object_set_data(GTK_OBJECT(check), "capplet", (gpointer) current_capplet);
  h4 = gtk_signal_connect(GTK_OBJECT(check), "toggled", GTK_SIGNAL_FUNC(e_cb_img_onoff), 
			  (gpointer) 2);
  gtk_table_attach_defaults(GTK_TABLE(table), check, 1, 2, 1, 2);
   
  return vbox;
}

static GtkWidget *
e_create_overlay_selector(void)
{
  GtkWidget          *hbox, *w, *scrolled_win, *list, *frame, *area, *table,
                     *label, *button, *om, *arrow, *vbox, *entry, *check,
                     *align, *line, *bbox, *carea, *m, *mi, *note, *table2,
                     *vbox2, *win;
  gint                i;

  
  vbox = gtk_vbox_new(FALSE, 1);
  gtk_widget_show(vbox);
  
  frame = gtk_frame_new(_("Image file"));
  gtk_widget_show(frame);
  gtk_box_pack_start(GTK_BOX(vbox), frame, FALSE, FALSE, 1);
  
  hbox = gtk_hbox_new(FALSE, 1);
  gtk_widget_show(hbox);
  gtk_container_add(GTK_CONTAINER(frame), hbox);
  
  entry = gtk_entry_new_with_max_length(4096);
  bg_fg_file_entry = entry;
  gtk_widget_show(entry);
  gtk_box_pack_start(GTK_BOX(hbox), entry, TRUE, TRUE, 1);
  gtk_widget_set_sensitive(entry, FALSE);
  
  button = gtk_button_new_with_label(_("Browse"));
  gtk_widget_show(button);
  gtk_box_pack_start(GTK_BOX(hbox), button, FALSE, FALSE, 1);
  gtk_signal_connect(GTK_OBJECT(button), "clicked", 
		     GTK_SIGNAL_FUNC(e_cb_overlay_browse), NULL);

  button = gtk_button_new_with_label(_("None"));
  gtk_widget_show(button);
  gtk_box_pack_start(GTK_BOX(hbox), button, FALSE, FALSE, 1);
  gtk_signal_connect(GTK_OBJECT(button), "clicked", 
		     GTK_SIGNAL_FUNC(e_cb_overlay_none), NULL);
  
  frame = gtk_frame_new(_("Image display options"));
  gtk_widget_show(frame);
  gtk_box_pack_start(GTK_BOX(vbox), frame, TRUE, TRUE, 1);
  
  table = gtk_table_new(2, 2, TRUE);
  gtk_widget_show(table);
  gtk_container_add(GTK_CONTAINER(frame), table);

  m = gtk_menu_new();
  gtk_widget_show(m);
  mi = gtk_menu_item_new_with_label("Top left");
  gtk_widget_show(mi);
  gtk_object_set_data(GTK_OBJECT(mi), "capplet", (gpointer) current_capplet);
  gtk_signal_connect(GTK_OBJECT(mi), "activate", 
		     GTK_SIGNAL_FUNC(e_cb_img_position), (gpointer)0);
  gtk_menu_append(GTK_MENU(m), mi);
  mi = gtk_menu_item_new_with_label("Top middle");
  gtk_widget_show(mi);
  gtk_object_set_data(GTK_OBJECT(mi), "capplet", (gpointer) current_capplet);
  gtk_signal_connect(GTK_OBJECT(mi), "activate", 
		     GTK_SIGNAL_FUNC(e_cb_img_position), (gpointer)1);
  gtk_menu_append(GTK_MENU(m), mi);
  mi = gtk_menu_item_new_with_label("Top right");
  gtk_widget_show(mi);
  gtk_object_set_data(GTK_OBJECT(mi), "capplet", (gpointer) current_capplet);
  gtk_signal_connect(GTK_OBJECT(mi), "activate", 
		     GTK_SIGNAL_FUNC(e_cb_img_position), (gpointer)2);
  gtk_menu_append(GTK_MENU(m), mi);
  mi = gtk_menu_item_new_with_label("Right middle");
  gtk_widget_show(mi);
  gtk_object_set_data(GTK_OBJECT(mi), "capplet", (gpointer) current_capplet);
  gtk_signal_connect(GTK_OBJECT(mi), "activate", 
		     GTK_SIGNAL_FUNC(e_cb_img_position), (gpointer)3);
  gtk_menu_append(GTK_MENU(m), mi);
  mi = gtk_menu_item_new_with_label("Bottom right");
  gtk_widget_show(mi);
  gtk_object_set_data(GTK_OBJECT(mi), "capplet", (gpointer) current_capplet);
  gtk_signal_connect(GTK_OBJECT(mi), "activate", 
		     GTK_SIGNAL_FUNC(e_cb_img_position), (gpointer)4);
  gtk_menu_append(GTK_MENU(m), mi);
  mi = gtk_menu_item_new_with_label("Bottom middle");
  gtk_widget_show(mi);
  gtk_object_set_data(GTK_OBJECT(mi), "capplet", (gpointer) current_capplet);
  gtk_signal_connect(GTK_OBJECT(mi), "activate", 
		     GTK_SIGNAL_FUNC(e_cb_img_position), (gpointer)5);
  gtk_menu_append(GTK_MENU(m), mi);
  mi = gtk_menu_item_new_with_label("Bottom left");
  gtk_widget_show(mi);
  gtk_object_set_data(GTK_OBJECT(mi), "capplet", (gpointer) current_capplet);
  gtk_signal_connect(GTK_OBJECT(mi), "activate", 
		     GTK_SIGNAL_FUNC(e_cb_img_position), (gpointer)6);
  gtk_menu_append(GTK_MENU(m), mi);
  mi = gtk_menu_item_new_with_label("Left middle");
  gtk_widget_show(mi);
  gtk_object_set_data(GTK_OBJECT(mi), "capplet", (gpointer) current_capplet);
  gtk_signal_connect(GTK_OBJECT(mi), "activate", 
		     GTK_SIGNAL_FUNC(e_cb_img_position), (gpointer)7);
  gtk_menu_append(GTK_MENU(m), mi);
  mi = gtk_menu_item_new_with_label("Centered");
  gtk_widget_show(mi);
  gtk_object_set_data(GTK_OBJECT(mi), "capplet", (gpointer) current_capplet);
  gtk_signal_connect(GTK_OBJECT(mi), "activate", 
		     GTK_SIGNAL_FUNC(e_cb_img_position), (gpointer)8);
  gtk_menu_append(GTK_MENU(m), mi);

  om = gtk_option_menu_new();
  bg_fg_pos = om;
  gtk_widget_show(om);
  gtk_option_menu_set_menu(GTK_OPTION_MENU(om), m);
  gtk_option_menu_set_history(GTK_OPTION_MENU(om), 0);
  gtk_table_attach_defaults(GTK_TABLE(table), om, 0, 1, 0, 1);

  check = gtk_check_button_new_with_label(_("Retain image aspect ratio"));
  bg_fg_aspect = check;
  gtk_widget_show(check);
  gtk_object_set_data(GTK_OBJECT(check), "capplet", (gpointer) current_capplet);
  h5 = gtk_signal_connect(GTK_OBJECT(check), "toggled", GTK_SIGNAL_FUNC(e_cb_img_onoff), 
		     (gpointer) 6);
  gtk_table_attach_defaults(GTK_TABLE(table), check, 1, 2, 0, 1);
  
  check = gtk_check_button_new_with_label(_("Maximise height to fit screen"));
  bg_fg_maxv = check;
  gtk_widget_show(check);
  gtk_object_set_data(GTK_OBJECT(check), "capplet", (gpointer) current_capplet);
  h6 = gtk_signal_connect(GTK_OBJECT(check), "toggled", GTK_SIGNAL_FUNC(e_cb_img_onoff), 
		     (gpointer) 4);
  gtk_table_attach_defaults(GTK_TABLE(table), check, 0, 1, 1, 2);
  
  check = gtk_check_button_new_with_label(_("Maximise width to fit screen"));
  bg_fg_maxh = check;
  gtk_widget_show(check);
  gtk_object_set_data(GTK_OBJECT(check), "capplet", (gpointer) current_capplet);
  h7 = gtk_signal_connect(GTK_OBJECT(check), "toggled", GTK_SIGNAL_FUNC(e_cb_img_onoff), 
		     (gpointer) 5);
  gtk_table_attach_defaults(GTK_TABLE(table), check, 1, 2, 1, 2);

  return vbox;
}

static void
e_cb_show_edit_win(GtkWidget *widget, gpointer data)
{
  gtk_widget_show(edit_win);
}

static void
e_cb_hide_edit_win(GtkWidget *widget, gpointer data)
{
  gtk_widget_hide(edit_win);
}

static void
e_cb_close_edit_win(GtkWidget *widget, gpointer data)
{
  gtk_widget_hide(widget);
}

static void
e_create_edit_win(void)
{
  GtkWidget          *hbox, *w, *scrolled_win, *list, *frame, *area, *table,
                     *label, *button, *om, *arrow, *vbox, *entry, *check,
                     *align, *line, *bbox, *carea, *m, *mi, *note, *table2,
                     *vbox2, *win;
  gint                i;

  win = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  edit_win = win;
  gtk_signal_connect(GTK_OBJECT(win), "delete_event",
		     GTK_SIGNAL_FUNC(e_cb_close_edit_win), NULL);
  gtk_window_set_title(GTK_WINDOW(win), "Enlightenment: Edit Background");
  gtk_window_set_policy(GTK_WINDOW(win), 0, 0, 1);
  gtk_window_set_position(GTK_WINDOW(win), GTK_WIN_POS_MOUSE);
  
  table = gtk_table_new(1, 1, FALSE);
  gtk_widget_show(table);
  gtk_container_add(GTK_CONTAINER(win), table);
  
  note = gtk_notebook_new();
  gtk_widget_show(note);
  gtk_table_attach(GTK_TABLE(table), note, 0, 1, 1, 2,
		   GTK_FILL, GTK_FILL, 2, 2);  

  /* solid background selector pane */
  label = gtk_label_new(_("Solid Colour"));
  gtk_widget_show(label);
  align = gtk_alignment_new(0.5, 0.5, 0.0, 0.0);
  gtk_widget_show(align);
  gtk_notebook_append_page(GTK_NOTEBOOK(note), align, label);
  note_solid1 = align;
  note_solid2 = label;
  
  w = e_create_solid_selector();
  gtk_container_add(GTK_CONTAINER(align), w);  

  /* gradient background selector pane */
  label = gtk_label_new(_("Gradient"));
  gtk_widget_show(label);
  w = e_create_gradient_selector();
  gtk_notebook_append_page(GTK_NOTEBOOK(note), w, label);
  note_grad1 = w;
  note_grad2 = label;

  /* Backgrouund Image tile selector */
  label = gtk_label_new(_("Background Image"));
  gtk_widget_show(label);
  w = e_create_image_selector();
  gtk_notebook_append_page(GTK_NOTEBOOK(note), w, label);
  note_bg1 = w;
  note_bg2 = label;

  /* Overlay Image selector */
  label = gtk_label_new(_("Overlayed Logo"));
  gtk_widget_show(label);
  w = e_create_overlay_selector();
  gtk_notebook_append_page(GTK_NOTEBOOK(note), w, label);
  
  label = gtk_label_new(_("Please select the attribute of this background\n"
			  "you wish to change below"));
  gtk_widget_show(label);
  gtk_table_attach_defaults(GTK_TABLE(table), label, 0, 1, 0, 1);  

  button = gtk_button_new_with_label(_("Done"));
  gtk_container_set_border_width(GTK_CONTAINER(button), 4);
  gtk_widget_show(button);
  gtk_table_attach(GTK_TABLE(table), button, 0, 1, 2, 3,
		   0, 0, 2, 2);
  gtk_signal_connect(GTK_OBJECT(button), "clicked",
		     GTK_SIGNAL_FUNC(e_cb_hide_edit_win), NULL);
}

static GtkWidget   *
__setup_pane_5(void)
{
  GtkWidget          *hbox, *w, *scrolled_win, *list, *frame, *area, *table,
                     *label, *button, *om, *arrow, *vbox, *entry, *check,
                     *align, *line, *bbox, *carea, *m, *mi, *note, *table2,
                     *vbox2, *tip, *viewport;
  gint                i;

  vbox = gtk_vbox_new(FALSE, 1);
  hbox = gtk_hbox_new(FALSE, 1);
  gtk_widget_show(hbox);
  gtk_box_pack_start(GTK_BOX(vbox), hbox, TRUE, TRUE, 1);
  vbox2 = gtk_vbox_new(FALSE, 1);
  gtk_widget_show(vbox2);
  gtk_box_pack_start(GTK_BOX(hbox), vbox2, FALSE, TRUE, 1);
  
  w = e_create_onoff(_("High quality rendering for background"), 
		     &e_opt_hq_background);
  gtk_box_pack_start(GTK_BOX(vbox), w, FALSE, TRUE, 1);
  w = e_create_rangeonoff(_("Minutes after which to expunge unviewed backgrounds from memory"),
			  &e_opt_desktop_bg_timeout,
			  0.0, 60.0,
			  _("-"), _("+"),
			  NULL, 0.0);
  gtk_box_pack_start(GTK_BOX(vbox), w, FALSE, TRUE, 1);
  
  e_create_edit_win();
  
  om = gtk_option_menu_new();
  gtk_widget_show(om);
  desk_option_menu = om;
  gtk_option_menu_set_menu(GTK_OPTION_MENU(om), desk_select_menu);
  gtk_option_menu_set_history(GTK_OPTION_MENU(om), 0);
  gtk_box_pack_start(GTK_BOX(vbox2), om, FALSE, FALSE, 1);
  tip = (GtkWidget *) gtk_tooltips_new();
  gtk_tooltips_set_tip(GTK_TOOLTIPS(tip), om, 
		       _("Select the desktop you wish to change the "
			 "background of here"), NULL);
  gtk_tooltips_enable(GTK_TOOLTIPS(tip));
  
  e_rebuild_desk_menu();  

  align = gtk_alignment_new(0.5, 0.5, 0.0, 0.0);
  gtk_widget_show(align);
  gtk_box_pack_start(GTK_BOX(vbox2), align, FALSE, FALSE, 1);
  
  button = gtk_button_new_with_label(_("No background"));
  gtk_widget_show(button);
  gtk_box_pack_start(GTK_BOX(vbox2), button, FALSE, FALSE, 1);
  gtk_signal_connect(GTK_OBJECT(button), "clicked", 
		     GTK_SIGNAL_FUNC(e_cb_bg_none), NULL);
  tip = (GtkWidget *) gtk_tooltips_new();
  gtk_tooltips_set_tip(GTK_TOOLTIPS(tip), button, 
		       _("Select no background for this desktop "
			 "(Enlightenment will not attempt to set any "
			 "background for this desktop then)"), NULL);
  gtk_tooltips_enable(GTK_TOOLTIPS(tip));
  
  button = gtk_button_new_with_label(_("Add new..."));
  gtk_widget_show(button);
  gtk_box_pack_start(GTK_BOX(vbox2), button, FALSE, FALSE, 1);
  gtk_signal_connect(GTK_OBJECT(button), "clicked", 
		     GTK_SIGNAL_FUNC(e_cb_bg_new), NULL);
  tip = (GtkWidget *) gtk_tooltips_new();
  gtk_tooltips_set_tip(GTK_TOOLTIPS(tip), button, 
		       _("Add a new background bookmark to your list"), NULL);
  gtk_tooltips_enable(GTK_TOOLTIPS(tip));

  button = gtk_button_new_with_label(_("Delete"));
  gtk_widget_show(button);
  gtk_box_pack_start(GTK_BOX(vbox2), button, FALSE, FALSE, 1);
  gtk_signal_connect(GTK_OBJECT(button), "clicked", 
		     GTK_SIGNAL_FUNC(e_cb_bg_delete), NULL);
  tip = (GtkWidget *) gtk_tooltips_new();
  gtk_tooltips_set_tip(GTK_TOOLTIPS(tip), button, 
		       _("Remove this background bookmark from the list"), NULL);
  gtk_tooltips_enable(GTK_TOOLTIPS(tip));

  button = gtk_button_new_with_label(_("Edit..."));
  gtk_widget_show(button);
  gtk_box_pack_start(GTK_BOX(vbox2), button, FALSE, FALSE, 1);
  gtk_signal_connect(GTK_OBJECT(button), "clicked",
		     GTK_SIGNAL_FUNC(e_cb_show_edit_win), NULL);
  tip = (GtkWidget *) gtk_tooltips_new();
  gtk_tooltips_set_tip(GTK_TOOLTIPS(tip), button, 
		       _("Edit the settings for this background bookmark"), NULL);
  gtk_tooltips_enable(GTK_TOOLTIPS(tip));

  frame = gtk_frame_new(NULL);
  gtk_widget_show(frame);
  gtk_frame_set_shadow_type(GTK_FRAME(frame), GTK_SHADOW_IN);
  gtk_container_add(GTK_CONTAINER(align), frame);

  area = gtk_drawing_area_new();
  gtk_widget_show(area);
  desk_mini_display_area = area;
  gtk_drawing_area_size(GTK_DRAWING_AREA(area), 128, 96);
  gtk_widget_set_usize(area, 128, 96);
  gtk_container_add(GTK_CONTAINER(frame), area);
  gtk_signal_connect(GTK_OBJECT(area), "expose_event",
		     GTK_SIGNAL_FUNC(e_cb_expose_mini_desk), NULL);

  scrolled_win = gtk_scrolled_window_new(NULL, NULL);
  gtk_widget_show(scrolled_win);
  gtk_box_pack_start(GTK_BOX(hbox), scrolled_win, TRUE, TRUE, 1);
  gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrolled_win),
				 GTK_POLICY_AUTOMATIC,
				 GTK_POLICY_AUTOMATIC);
  list = gtk_table_new(0, 0, FALSE);
  gtk_widget_show(list);
  image_table_list = list;

  viewport = gtk_viewport_new(NULL, NULL);
  gtk_widget_show(viewport);
  gtk_viewport_set_shadow_type(GTK_VIEWPORT(viewport), GTK_SHADOW_IN);
  gtk_widget_set_usize(viewport, (72 * 4) + 4, -1);
  
  gtk_container_add(GTK_CONTAINER(scrolled_win), viewport);
  gtk_container_add(GTK_CONTAINER(viewport), list);
  if (backgrounds)
    {
      gchar               s[4096];
      int                 i, j, la, ra, ta, ba;
      GList              *ptr;

      j = g_list_length(backgrounds);

      g_snprintf(s, sizeof(s), "%s/.e-conf", getenv("HOME"));
      mkdir(s, S_IRWXU);
      ptr = backgrounds;
      table_size = 4;
      if (j > 2320)
	table_size = (j / 580) + 1;
      for (i = 0; ((i < j) && (ptr)); i++)
	{
	  Background         *bg = NULL;
	  GtkWidget          *l_hb, *l_label, *l_pixmap, *l_item;

	  if (progress)
	    {
	      gtk_progress_bar_update(GTK_PROGRESS_BAR(progress),
				      (gfloat) i / (gfloat) j);
	      gtk_widget_draw(progress, NULL);
	    }
	  bg = ptr->data;
	  ptr = ptr->next;
	  if (bg)
	    {
	      l_item = gtk_button_new();
	      gtk_object_set_data(GTK_OBJECT(l_item), "bg", bg);
	      gtk_object_set_data(GTK_OBJECT(l_item), "capplet", (gpointer) current_capplet);
	      gtk_widget_show(l_item);
	      l_hb = gtk_hbox_new(FALSE, 1);
	      bg->box = l_hb;
	      gtk_container_set_border_width(GTK_CONTAINER(l_hb), 1);
	      gtk_widget_show(l_hb);
	      gtk_container_add(GTK_CONTAINER(l_item), l_hb);
	      l_pixmap = bg->pmap;
	      gtk_widget_show(l_pixmap);
	      gtk_box_pack_start(GTK_BOX(l_hb), l_pixmap, FALSE, FALSE, 0);
	      gtk_signal_connect(GTK_OBJECT(l_item), "clicked",
				 GTK_SIGNAL_FUNC(e_cb_bg_sel), NULL);
	      bg->button = l_item;
	      bg->table = list;
	      ta = i / table_size;
	      ba = ta + 1;
	      la = i % table_size;
	      ra = la + 1;
	      gtk_table_attach_defaults(GTK_TABLE(list), l_item, la, ra, ta, ba);
	    }
	}
    }
  gtk_widget_show(vbox);

  return vbox;
}

/* Pane for audio */
static GtkWidget   *
__setup_pane_6(void)
{
  GtkWidget          *vbox, *w;

  vbox = gtk_vbox_new(FALSE, 1);
  w = e_create_onoff(_("Enable sounds in Enlightenment"),
		     &e_opt_sound);
  gtk_box_pack_start(GTK_BOX(vbox), w, FALSE, FALSE, 1);

  gtk_widget_show(vbox);
  return vbox;
}

/* Pane for fonts */
static GtkWidget   *
__setup_pane_7(void)
{
  GtkWidget          *vbox, *w;

  vbox = gtk_vbox_new(FALSE, 1);
  w = gtk_label_new("This page is intentionally blank.\n"
		    "\n"
		    "Widgets will be filled in here shortly");
  gtk_widget_show(w);
  gtk_box_pack_start(GTK_BOX(vbox), w, FALSE, FALSE, 1);

  gtk_widget_show(vbox);
  return vbox;
}

/* Pane for colours */
static GtkWidget   *
__setup_pane_8(void)
{
  GtkWidget          *vbox, *w;

  vbox = gtk_vbox_new(FALSE, 1);
  w = gtk_label_new("This page is intentionally blank.\n"
		    "\n"
		    "Widgets will be filled in here shortly");
  gtk_widget_show(w);
  gtk_box_pack_start(GTK_BOX(vbox), w, FALSE, FALSE, 1);

  gtk_widget_show(vbox);
  return vbox;
}

/* Pane for cursors */
static GtkWidget   *
__setup_pane_9(void)
{
  GtkWidget          *vbox, *w;

  vbox = gtk_vbox_new(FALSE, 1);
  w = gtk_label_new("This page is intentionally blank.\n"
		    "\n"
		    "Widgets will be filled in here shortly");
  gtk_widget_show(w);
  gtk_box_pack_start(GTK_BOX(vbox), w, FALSE, FALSE, 1);

  gtk_widget_show(vbox);
  return vbox;
}

/* Pane for window matches */
static GtkWidget   *
__setup_pane_10(void)
{
  GtkWidget          *vbox, *w;

  vbox = gtk_vbox_new(FALSE, 1);
  w = gtk_label_new("This page is intentionally blank.\n"
		    "\n"
		    "Widgets will be filled in here shortly");
  gtk_widget_show(w);
  gtk_box_pack_start(GTK_BOX(vbox), w, FALSE, FALSE, 1);

  gtk_widget_show(vbox);
  return vbox;
}

/* Pane for menus */
static GtkWidget   *
__setup_pane_11(void)
{
  GtkWidget          *vbox, *w;

  vbox = gtk_vbox_new(FALSE, 1);
  w = gtk_label_new("This page is intentionally blank.\n"
		    "\n"
		    "Widgets will be filled in here shortly");
  gtk_widget_show(w);
  gtk_box_pack_start(GTK_BOX(vbox), w, FALSE, FALSE, 1);

  gtk_widget_show(vbox);
  return vbox;
}

static void
e_cb_list_click(GtkWidget * widget, gint num)
{
  GtkWidget          *note;

  note = (GtkWidget *) gtk_object_get_data(GTK_OBJECT(widget), "note");
  gtk_notebook_set_page(GTK_NOTEBOOK(note), num);
}

static void
e_setup(GtkWidget * c)
{
  GtkWidget          *frame, *frame2, *hbox, *vbox, *note, *w, *label, *list;
  GtkWidget          *scrolled_win, *pixmap, *tip;
  GdkPixmap          *pmap, *mask;
  gchar              *line[1] =
  {""};

  current_capplet = c;

  hbox = gtk_hbox_new(FALSE, 1);
  gtk_widget_show(hbox);
  gtk_container_add(GTK_CONTAINER(c), hbox);

  note = gtk_notebook_new();
  gtk_widget_show(note);
  gtk_notebook_set_show_border(GTK_NOTEBOOK(note), FALSE);
  gtk_notebook_set_show_tabs(GTK_NOTEBOOK(note), FALSE);

  w = __setup_pane_1();
  gtk_notebook_append_page(GTK_NOTEBOOK(note), w, NULL);
  w = __setup_pane_2();
  gtk_notebook_append_page(GTK_NOTEBOOK(note), w, NULL);
  w = __setup_pane_3();
  gtk_notebook_append_page(GTK_NOTEBOOK(note), w, NULL);
  w = __setup_pane_4();
  gtk_notebook_append_page(GTK_NOTEBOOK(note), w, NULL);
  w = __setup_pane_5();
  gtk_notebook_append_page(GTK_NOTEBOOK(note), w, NULL);
  w = __setup_pane_6();
  gtk_notebook_append_page(GTK_NOTEBOOK(note), w, NULL);
  w = __setup_pane_7();
  gtk_notebook_append_page(GTK_NOTEBOOK(note), w, NULL);
  w = __setup_pane_8();
  gtk_notebook_append_page(GTK_NOTEBOOK(note), w, NULL);
  w = __setup_pane_9();
  gtk_notebook_append_page(GTK_NOTEBOOK(note), w, NULL);
  w = __setup_pane_10();
  gtk_notebook_append_page(GTK_NOTEBOOK(note), w, NULL);
  w = __setup_pane_11();
  gtk_notebook_append_page(GTK_NOTEBOOK(note), w, NULL);

  vbox = gtk_vbox_new(FALSE, 1);
  gtk_widget_show(vbox);
  gtk_box_pack_start(GTK_BOX(hbox), vbox, FALSE, FALSE, 0);

  scrolled_win = gtk_scrolled_window_new(NULL, NULL);
  gtk_widget_show(scrolled_win);
  gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrolled_win),
				 GTK_POLICY_AUTOMATIC,
				 GTK_POLICY_AUTOMATIC);
  gtk_widget_set_usize(scrolled_win, 140, 141);
  gtk_box_pack_start(GTK_BOX(vbox), scrolled_win, FALSE, FALSE, 0);

  gdk_imlib_data_to_pixmap(e_logo_xpm, &pmap, &mask);
  pixmap = gtk_pixmap_new(pmap, mask);
  gtk_widget_show(pixmap);
  gtk_box_pack_start(GTK_BOX(vbox), pixmap, TRUE, TRUE, 0);
  list = gtk_clist_new(1);
  gtk_clist_set_row_height(GTK_CLIST(list), 16);
  gtk_clist_set_selection_mode(GTK_CLIST(list), GTK_SELECTION_BROWSE);

  gtk_object_set_data(GTK_OBJECT(list), "note", note);

  gtk_clist_append(GTK_CLIST(list), line);
  gdk_imlib_data_to_pixmap(focus_and_display_xpm, &pmap, &mask);
  gtk_clist_set_pixtext(GTK_CLIST(list), 0, 0,
			"Focus & Display", 1, pmap, mask);
  gtk_clist_append(GTK_CLIST(list), line);
  gdk_imlib_data_to_pixmap(special_effects_xpm, &pmap, &mask);
  gtk_clist_set_pixtext(GTK_CLIST(list), 1, 0,
			"Special FX", 1, pmap, mask);
  gtk_clist_append(GTK_CLIST(list), line);
  gdk_imlib_data_to_pixmap(behavior_xpm, &pmap, &mask);
  gtk_clist_set_pixtext(GTK_CLIST(list), 2, 0,
			"Behavior", 1, pmap, mask);
  gtk_clist_append(GTK_CLIST(list), line);
  gdk_imlib_data_to_pixmap(desktops_xpm, &pmap, &mask);
  gtk_clist_set_pixtext(GTK_CLIST(list), 3, 0,
			"Desktops", 1, pmap, mask);
  gtk_clist_append(GTK_CLIST(list), line);
  gdk_imlib_data_to_pixmap(backgrounds_xpm, &pmap, &mask);
  gtk_clist_set_pixtext(GTK_CLIST(list), 4, 0,
			"Backgrounds", 1, pmap, mask);
  gtk_clist_append(GTK_CLIST(list), line);
  gdk_imlib_data_to_pixmap(audio_xpm, &pmap, &mask);
  gtk_clist_set_pixtext(GTK_CLIST(list), 5, 0,
			"Audio", 1, pmap, mask);
  gtk_clist_append(GTK_CLIST(list), line);
  gdk_imlib_data_to_pixmap(fonts_xpm, &pmap, &mask);
  gtk_clist_set_pixtext(GTK_CLIST(list), 6, 0,
			"Fonts", 1, pmap, mask);
  gtk_clist_append(GTK_CLIST(list), line);
  gdk_imlib_data_to_pixmap(colours_xpm, &pmap, &mask);
  gtk_clist_set_pixtext(GTK_CLIST(list), 7, 0,
			"Colours", 1, pmap, mask);
  gtk_clist_append(GTK_CLIST(list), line);
  gdk_imlib_data_to_pixmap(cursors_xpm, &pmap, &mask);
  gtk_clist_set_pixtext(GTK_CLIST(list), 8, 0,
			"Mouse Cursors", 1, pmap, mask);
  gtk_clist_append(GTK_CLIST(list), line);
  gdk_imlib_data_to_pixmap(borders_xpm, &pmap, &mask);
  gtk_clist_set_pixtext(GTK_CLIST(list), 9, 0,
			"Borders", 1, pmap, mask);
  gtk_clist_append(GTK_CLIST(list), line);
  gdk_imlib_data_to_pixmap(menus_xpm, &pmap, &mask);
  gtk_clist_set_pixtext(GTK_CLIST(list), 10, 0,
			"Menus", 1, pmap, mask);

  gtk_clist_columns_autosize(GTK_CLIST(list));
  gtk_clist_select_row(GTK_CLIST(list), 0, 0);
  gtk_widget_show(list);
  gtk_container_add(GTK_CONTAINER(scrolled_win), list);

  gtk_signal_connect(GTK_OBJECT(list), "select_row",
		     GTK_SIGNAL_FUNC(e_cb_list_click), note);

  gtk_box_pack_start(GTK_BOX(hbox), note, FALSE, FALSE, 0);
}

static void
e_setup_multi(GtkWidget * old, GtkWidget * c)
{
  gtk_signal_connect(GTK_OBJECT(c), "new_multi_capplet",
		     GTK_SIGNAL_FUNC(e_setup_multi), NULL);
  switch (CAPPLET_WIDGET(c)->capid)
    {
    default:
    case -1:
    case 0:
      e_setup(c);
      e_init_capplet(c, e_try, e_revert, e_ok, e_cancel);
      break;
    }
}

int
main(int argc, char **argv)
{
  GtkWidget          *capplet;
  gint                i;

  for (i = 0; i < 32; i++)
    {
      deskbg[i] = NULL;
      deskbgchanged[i] = 0;
    }

  gnome_capplet_init("e-conf", VERSION, argc,
		     argv, NULL, 0, NULL);

  capplet = capplet_widget_new();
  gtk_widget_show(capplet);

  progress_win = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title(GTK_WINDOW(progress_win), "Talking to Enlightenment");
  gtk_window_set_policy(GTK_WINDOW(progress_win), 0, 0, 1);
  gtk_window_set_position(GTK_WINDOW(progress_win), GTK_WIN_POS_CENTER);
  gtk_widget_show(progress_win);
  progress = gtk_progress_bar_new();
  gtk_widget_set_usize(progress, 320, 16);
  gtk_widget_show(progress);
  gtk_container_add(GTK_CONTAINER(progress_win), progress);

  CommsInit(recieve_ipc_msg);
  CommsSend("set clientname Enlightenment Configuration Utility");
  CommsSend("set version 0.2.0");
  CommsSend("set author The Rasterman (Carsten Haitzler)");
  CommsSend("set email raster@rasterman.com");
  CommsSend("set web http://www.rasterman.com/");
  CommsSend("set address C/O Red Hat Software, USA");
  CommsSend("set info "
	    "This is the Enlightenemnt Configuration Utility\n"
	    "that uses Enlightenment's IPC mechanism to configure\n"
	    "it remotely.");
  e_read();
  if (backgrounds)
    {
      gchar               s[4096];
      int                 i, j, la, ra, ta, ba;
      GList              *ptr;

      j = g_list_length(backgrounds);

      g_snprintf(s, sizeof(s), "%s/.e-conf", getenv("HOME"));
      mkdir(s, S_IRWXU);
      ptr = backgrounds;
      for (i = 0; ((i < j) && (ptr)); i++)
	{
	  Background         *bg = NULL;
	  GdkPixmap          *pmap;
	  GtkWidget          *l_hb, *l_label, *l_pixmap, *l_item;
	  GdkImlibImage      *im;

	  if (progress)
	    {
	      gtk_progress_bar_update(GTK_PROGRESS_BAR(progress),
				      (gfloat) i / (gfloat) j);
	      gtk_widget_draw(progress, NULL);
	    }
	  pmap = gdk_pixmap_new(capplet->window, 64, 48, -1);
	  bg = ptr->data;
	  ptr = ptr->next;
	  if (bg)
	    {
	      g_snprintf(s, sizeof(s), "%s/.e-conf/%s", getenv("HOME"), bg->name);
	      im = gdk_imlib_load_image(s);
	      if (!im)
		{
		  e_render_bg_onto(pmap, bg);
		  im = gdk_imlib_create_image_from_drawable(pmap, NULL, 0, 0,
							    64, 48);
		  if (im)
		    {
		      gdk_imlib_save_image_to_ppm(im, s);
		      gdk_imlib_kill_image(im);
		    }
		}
	      else
		{
		  gdk_imlib_paste_image(im, pmap, 0, 0, 64, 48);
		  gdk_imlib_destroy_image(im);
		}
	    }
	  l_pixmap = gtk_pixmap_new(pmap, NULL);
	  bg->pmap = l_pixmap;
	  bg->gpmap = NULL;
	  if (!strncmp(bg->name, "GRADIENT.", 9))
	    {
	      l_pixmap = gtk_pixmap_new(pmap, NULL);
	      bg->gpmap = l_pixmap;
	    }
	  gdk_pixmap_unref(pmap);
	}
    }
  e_setup_multi(NULL, capplet);
  gtk_widget_destroy(progress_win);
  progress_win = NULL;
  progress = NULL;
/*  while (gtk_events_pending())
    gtk_main_iteration();*/
/*  e_cb_set_current_desk(NULL, 0);*/
  capplet_gtk_main();
  return 0;
}
