// -*- c++ -*-
// Generated by gmmproc 2.40.0 -- DO NOT MODIFY!
#ifndef _CLUTTERMM_ANIMATOR_H
#define _CLUTTERMM_ANIMATOR_H


#ifndef CLUTTERMM_DISABLE_DEPRECATED


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* Copyright (C) 2011 The cluttermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <glibmm/object.h>
#include <cluttermm/scriptable.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _ClutterAnimator ClutterAnimator;
typedef struct _ClutterAnimatorClass ClutterAnimatorClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Clutter
{ class Animator_Class; } // namespace Clutter
namespace Clutter
{

/** @addtogroup cluttermmEnums cluttermm Enums and Flags */

/** 
 *  @var Interpolation INTERPOLATION_LINEAR
 *  Linear interpolation.
 * 
 *  @var Interpolation INTERPOLATION_CUBIC
 *  Cubic interpolation.
 * 
 *  @enum Interpolation
 * 
 * The mode of interpolation between key frames
 * 
 * @newin{1,2}
 * @ingroup cluttermmEnums
 */
enum Interpolation
{
  INTERPOLATION_LINEAR,
  INTERPOLATION_CUBIC
};

} // namespace Clutter


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Clutter::Interpolation> : public Glib::Value_Enum<Clutter::Interpolation>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Clutter
{


class Timeline;

/**
 * @deprecated Use KeyframeTransition instead.
 */

class Animator : public Glib::Object
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef Animator CppObjectType;
  typedef Animator_Class CppClassType;
  typedef ClutterAnimator BaseObjectType;
  typedef ClutterAnimatorClass BaseClassType;

private:  friend class Animator_Class;
  static CppClassType animator_class_;

private:
  // noncopyable
  Animator(const Animator&);
  Animator& operator=(const Animator&);

protected:
  explicit Animator(const Glib::ConstructParams& construct_params);
  explicit Animator(ClutterAnimator* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~Animator();

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  ClutterAnimator*       gobj()       { return reinterpret_cast<ClutterAnimator*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const ClutterAnimator* gobj() const { return reinterpret_cast<ClutterAnimator*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  ClutterAnimator* gobj_copy();

private:

  
protected:
  Animator();

public:
  
  static Glib::RefPtr<Animator> create();


  /** Sets a single key in the Clutter::Animator for the @a property_name of
   *  @a object at @a progress.
   * 
   * See also: set()
   * 
   * @newin{1,2}
   * Deprecated: 1.12: Use Clutter::KeyframeTransition instead
   * @param object A Object.
   * @param property_name The property to specify a key for.
   * @param mode The id of the alpha function to use.
   * @param progress The normalized range at which stage of the animation this
   * value applies.
   * @param value The value property_name should have at progress.
   * @return The animator instance.
   */
  Glib::RefPtr<Animator> set_key(const Glib::RefPtr<Glib::Object>& object, const Glib::ustring& property_name, guint mode, double progress, const Glib::ValueBase& value);
  
  /** Sets a single key in the Clutter::Animator for the @a property_name of
   *  @a object at @a progress.
   * 
   * See also: set()
   * 
   * @newin{1,2}
   * Deprecated: 1.12: Use Clutter::KeyframeTransition instead
   * @param object A Object.
   * @param property_name The property to specify a key for.
   * @param mode The id of the alpha function to use.
   * @param progress The normalized range at which stage of the animation this
   * value applies.
   * @param value The value property_name should have at progress.
   * @return The animator instance.
   */
  Glib::RefPtr<const Animator> set_key(const Glib::RefPtr<Glib::Object>& object, const Glib::ustring& property_name, guint mode, double progress, const Glib::ValueBase& value) const;
  
  /** Removes all keys matching the conditions specificed in the arguments.
   * 
   * @newin{1,2}
   * Deprecated: 1.12: Use Clutter::KeyframeTransition instead
   * @param object A Object to search for, or <tt>0</tt> for all.
   * @param property_name A specific property name to query for,
   * or <tt>0</tt> for all.
   * @param progress A specific progress to search for or a negative value
   * for all.
   */
  void remove_key(const Glib::RefPtr<Glib::Object>& object, const Glib::ustring& property_name, double progress);
  // TODO: _WRAP_METHOD(std::vector<Glib::RefPtr<Animator> > get_keys(const Glib::RefPtr<Glib::Object>& object, const std::string &property_name, double progress), clutter_animator_get_keys)
  
  
  /** Start the ClutterAnimator, this is a thin wrapper that rewinds
   * and starts the animators current timeline.
   * 
   * @newin{1,2}
   * Deprecated: 1.12: Use Clutter::KeyframeTransition instead
   * @return The Clutter::Timeline that drives
   * the animator. The returned timeline is owned by the Clutter::Animator
   * and it should not be unreferenced.
   */
  Glib::RefPtr<Timeline> start();
  
  /** Start the ClutterAnimator, this is a thin wrapper that rewinds
   * and starts the animators current timeline.
   * 
   * @newin{1,2}
   * Deprecated: 1.12: Use Clutter::KeyframeTransition instead
   * @return The Clutter::Timeline that drives
   * the animator. The returned timeline is owned by the Clutter::Animator
   * and it should not be unreferenced.
   */
  Glib::RefPtr<const Timeline> start() const;
  
  /** Compute the value for a managed property at a given progress.
   * 
   * If the property is an ease-in property, the current value of the property
   * on the object will be used as the starting point for computation.
   * 
   * @newin{1,2}
   * Deprecated: 1.12: Use Clutter::KeyframeTransition instead
   * @param object A Object.
   * @param property_name The name of the property on object to check.
   * @param progress A value between 0.0 and 1.0.
   * @param value An initialized value to store the computed result.
   * @return <tt>true</tt> if the computation yields has a value, otherwise (when
   * an error occurs or the progress is before any of the keys) <tt>false</tt> is
   * returned and the Value is left untouched.
   */
  bool compute_value(const Glib::RefPtr<Glib::Object>& object, const Glib::ustring& property_name, double progress, Glib::ValueBase& value);

  
  /** Sets an external timeline that will be used for driving the animation
   * 
   * @newin{1,2}
   * Deprecated: 1.12: Use Clutter::KeyframeTransition instead
   * @param timeline A Clutter::Timeline.
   */
  void set_timeline(const Glib::RefPtr<Timeline>& timeline);
  
  /** Get the timeline hooked up for driving the Clutter::Animator
   * 
   * @newin{1,2}
   * Deprecated: 1.12: Use Clutter::KeyframeTransition instead
   * @return The Clutter::Timeline that drives the animator.
   */
  Glib::RefPtr<Timeline> get_timeline();
  
  /** Get the timeline hooked up for driving the Clutter::Animator
   * 
   * @newin{1,2}
   * Deprecated: 1.12: Use Clutter::KeyframeTransition instead
   * @return The Clutter::Timeline that drives the animator.
   */
  Glib::RefPtr<const Timeline> get_timeline() const;
  
  /** Runs the timeline of the Clutter::Animator with a duration in msecs
   * as specified.
   * 
   * @newin{1,2}
   * Deprecated: 1.12: Use Clutter::KeyframeTransition instead
   * @param duration Milliseconds a run of the animator should last.
   */
  void set_duration(guint duration);
  
  /** Retrieves the current duration of an animator
   * 
   * @newin{1,2}
   * Deprecated: 1.12: Use Clutter::KeyframeTransition instead
   * @return The duration of the animation, in milliseconds.
   */
  guint get_duration() const;

  
  /** Sets whether a property value is to be eased into the animation.
   * 
   * @newin{1,2}
   * Deprecated: 1.12: Use Clutter::KeyframeTransition instead
   * @param object A Object.
   * @param property_name The name of a property on object.
   * @param ease_in We are going to be easing in this property.
   */
  void property_set_ease_in(const Glib::RefPtr<Glib::Object>& object, const Glib::ustring& property_name, bool ease_in);
  
  /** Checks if a property value is to be eased into the animation.
   * 
   * @newin{1,2}
   * Deprecated: 1.12: Use Clutter::KeyframeTransition instead
   * @param object A Object.
   * @param property_name The name of a property on object.
   * @return <tt>true</tt> if the property is eased in.
   */
  bool property_get_ease_in(const Glib::RefPtr<Glib::Object>& object, const Glib::ustring& property_name);

  
  /** Set the interpolation method to use, Clutter::INTERPOLATION_LINEAR causes
   * the values to linearly change between the values, and
   * Clutter::INTERPOLATION_CUBIC causes the values to smoothly change between
   * the values.
   * 
   * @newin{1,2}
   * Deprecated: 1.12: Use Clutter::KeyframeTransition instead
   * @param object A Object.
   * @param property_name The name of a property on object.
   * @param interpolation The Clutter::Interpolation to use.
   */
  void property_set_interpolation(const Glib::RefPtr<Glib::Object>& object, const Glib::ustring& property_name, Interpolation interpolation);
  
  /** Get the interpolation used by animator for a property on a particular
   * object.
   * 
   * @newin{1,2}
   * Deprecated: 1.12: Use Clutter::KeyframeTransition instead
   * @param object A Object.
   * @param property_name The name of a property on object.
   * @return A ClutterInterpolation value.
   */
  Interpolation property_get_interpolation(const Glib::RefPtr<Glib::Object>& object, const Glib::ustring& property_name);

  // TODO: Decide if these are needed.
  // _WRAP_METHOD(Glib::RefPtr<Glib::Object> get_object() const, clutter_animator_key_get_objec)
  // _WRAP_METHOD(Glib::ustring get_property_name() const, clutter_animator_key_get_property_name)
  // _WRAP_METHOD(GType get_property_type() const, clutter_animator_key_get_property_type)
  // _WRAP_METHOD(gulong get_mode() const, clutter_animator_key_get_mod)
  // _WRAP_METHOD(double get_progress() const , clutter_animator_key_get_progres)
  // _WRAP_METHOD(bool get_value(GValue *value) const, clutter_animator_key_get_value)

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The duration of the animation.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< guint > property_duration() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The duration of the animation.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< guint > property_duration() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The timeline of the animation.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::RefPtr<Timeline> > property_timeline() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The timeline of the animation.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Timeline> > property_timeline() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

} // namespace Clutter


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Clutter::Animator
   */
  Glib::RefPtr<Clutter::Animator> wrap(ClutterAnimator* object, bool take_copy = false);
}


#endif // CLUTTERMM_DISABLE_DEPRECATED


#endif /* _CLUTTERMM_ANIMATOR_H */

