// -*- c++ -*-
// Generated by gmmproc 2.39.93 -- DO NOT MODIFY!
#ifndef _CLUTTERMM_LAYOUT_MANAGER_H
#define _CLUTTERMM_LAYOUT_MANAGER_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* Copyright (C) 2011 The cluttermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <glibmm/object.h>
#include <cluttermm/actor.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _ClutterLayoutManager ClutterLayoutManager;
typedef struct _ClutterLayoutManagerClass ClutterLayoutManagerClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Clutter
{ class LayoutManager_Class; } // namespace Clutter
namespace Clutter
{

class Container;
class LayoutMeta;
class Alpha;


class LayoutManager : public Glib::Object
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef LayoutManager CppObjectType;
  typedef LayoutManager_Class CppClassType;
  typedef ClutterLayoutManager BaseObjectType;
  typedef ClutterLayoutManagerClass BaseClassType;

private:  friend class LayoutManager_Class;
  static CppClassType layoutmanager_class_;

private:
  // noncopyable
  LayoutManager(const LayoutManager&);
  LayoutManager& operator=(const LayoutManager&);

protected:
  explicit LayoutManager(const Glib::ConstructParams& construct_params);
  explicit LayoutManager(ClutterLayoutManager* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~LayoutManager();

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  ClutterLayoutManager*       gobj()       { return reinterpret_cast<ClutterLayoutManager*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const ClutterLayoutManager* gobj() const { return reinterpret_cast<ClutterLayoutManager*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  ClutterLayoutManager* gobj_copy();

private:

  
protected:
  LayoutManager();

public:

  // not sure the valist stuff is good to wrap in C++
  

  // not sure the valist stuff is good to wrap in C++
  

  template <class PropertyType> inline
  void set_child_property(const Glib::RefPtr<Container>& container, const Glib::RefPtr<Actor>& child, const Glib::ustring& property_name, const PropertyType& value);

  
  /** Sets a property on the Clutter::LayoutMeta created by @a manager and
   * attached to a child of @a container
   * 
   * @newin{1,2}
   * @param container A Clutter::Container using @a manager.
   * @param actor A Clutter::Actor child of @a container.
   * @param property_name The name of the property to set.
   * @param value A Value with the value of the property to set.
   */
  void set_child_property_value(const Glib::RefPtr<Container>& container, const Glib::RefPtr<Actor>& child, const Glib::ustring& property_name, const Glib::ValueBase& value);

  template <class PropertyType> inline
  void get_child_property(const Glib::RefPtr<Container>& container, const Glib::RefPtr<const Actor>& actor, const Glib::ustring& property_name, PropertyType& value) const;

  void get_child_property_value(const Glib::RefPtr<Container>& container, const Glib::RefPtr<const Actor>& actor, const Glib::ustring& property_name, Glib::ValueBase& value) const;
  

  /** Computes the minimum and natural widths of the @a container according
   * to @a manager.
   * 
   * See also Clutter::Actor::get_preferred_width()
   * 
   * @newin{1,2}
   * @param container The Clutter::Container using @a manager.
   * @param for_height The height for which the width should be computed, or -1.
   * @param min_width_p Return location for the minimum width
   * of the layout, or <tt>0</tt>.
   * @param nat_width_p Return location for the natural width
   * of the layout, or <tt>0</tt>.
   */
  void get_preferred_width(const Glib::RefPtr<Container>& container, float for_height, float& min_width_p, float& natural_width_p) const;
  
  /** Computes the minimum and natural heights of the @a container according
   * to @a manager.
   * 
   * See also Clutter::Actor::get_preferred_height()
   * 
   * @newin{1,2}
   * @param container The Clutter::Container using @a manager.
   * @param for_width The width for which the height should be computed, or -1.
   * @param min_height_p Return location for the minimum height
   * of the layout, or <tt>0</tt>.
   * @param nat_height_p Return location for the natural height
   * of the layout, or <tt>0</tt>.
   */
  void get_preferred_height(const Glib::RefPtr<Container>& container, float for_width, float& min_height_p, float& natural_height_p) const;

 
  /** Allocates the children of @a container given an area
   * 
   * See also Clutter::Actor::allocate()
   * 
   * @newin{1,2}
   * @param container The Clutter::Container using @a manager.
   * @param allocation The Clutter::ActorBox containing the allocated area
   * of @a container.
   * @param flags The allocation flags.
   */
  void allocate(const Glib::RefPtr<Container>& container, const ActorBox& box, AllocationFlags absolute_origin_changed);

  
  /** If the Clutter::LayoutManager sub-class allows it, allow
   * adding a weak reference of the @a container using @a manager
   * from within the layout manager
   * 
   * The layout manager should not increase the reference
   * count of the @a container
   * 
   * @newin{1,2}
   * @param container A Clutter::Container using @a manager.
   */
  void set_container(const Glib::RefPtr<Container>& container);
  //gtkmmproc error: clutter_layout_manager_get_child_meta_type : method defs lookup failed (1)

 
  //gtkmmproc error: clutter_layout_manager_create_child_meta : method defs lookup failed (1)
  //gtkmmproc error: clutter_layout_manager_create_child_meta : method defs lookup failed (1)

 
#ifndef CLUTTERMM_DISABLE_DEPRECATED

  /** Begins an animation of @a duration milliseconds, using the provided
   * easing @a mode
   * 
   * The easing mode can be specified either as a Clutter::AnimationMode
   * or as a logical id returned by Clutter::Alpha::register_func()
   * 
   * The result of this function depends on the @a manager implementation
   * 
   * @newin{1,2}
   * 
   * Deprecated: 1.12
   * @param duration The duration of the animation, in milliseconds.
   * @param mode The easing mode of the animation.
   * @return The Clutter::Alpha created by the
   * layout manager; the returned instance is owned by the layout
   * manager and should not be unreferenced.
   */
  Glib::RefPtr<Alpha> begin_animation(guint duration, gulong mode);
#endif // CLUTTERMM_DISABLE_DEPRECATED


#ifndef CLUTTERMM_DISABLE_DEPRECATED

  /** Begins an animation of @a duration milliseconds, using the provided
   * easing @a mode
   * 
   * The easing mode can be specified either as a Clutter::AnimationMode
   * or as a logical id returned by Clutter::Alpha::register_func()
   * 
   * The result of this function depends on the @a manager implementation
   * 
   * @newin{1,2}
   * 
   * Deprecated: 1.12
   * @param duration The duration of the animation, in milliseconds.
   * @param mode The easing mode of the animation.
   * @return The Clutter::Alpha created by the
   * layout manager; the returned instance is owned by the layout
   * manager and should not be unreferenced.
   */
  Glib::RefPtr<const Alpha> begin_animation(guint duration, gulong mode) const;
#endif // CLUTTERMM_DISABLE_DEPRECATED


#ifndef CLUTTERMM_DISABLE_DEPRECATED

  /** Retrieves the progress of the animation, if one has been started by
   * begin_animation()
   * 
   * The returned value has the same semantics of the Clutter::Alpha::property_alpha()
   * value
   * 
   * @newin{1,2}
   * 
   * Deprecated: 1.12
   * @return The progress of the animation.
   */
  double get_animation_progress();
#endif // CLUTTERMM_DISABLE_DEPRECATED


#ifndef CLUTTERMM_DISABLE_DEPRECATED

  /** Ends an animation started by begin_animation()
   * 
   * The result of this call depends on the @a manager implementation
   * 
   * @newin{1,2}
   * 
   * Deprecated: 1.12
   */
  void end_animation();
#endif // CLUTTERMM_DISABLE_DEPRECATED


    virtual void get_preferred_width_vfunc(const Glib::RefPtr<Container>& container, float for_height, float& min_width_p, float& natural_width_p) const;


    virtual void get_preferred_height_vfunc(const Glib::RefPtr<Container>& container, float for_width, float& min_height_p, float& natural_height_p) const;


    virtual void allocate_vfunc(const Glib::RefPtr<Container>& container, const ActorBox& box, AllocationFlags absolute_origin_changed);


    virtual void set_container_vfunc(const Glib::RefPtr<Container>& container);

    virtual GType get_child_meta_type_vfunc() const;


    virtual Glib::RefPtr<LayoutMeta> create_child_meta_vfunc(const Glib::RefPtr<Container>& container, const Glib::RefPtr<Actor>& actor);


    virtual Glib::RefPtr<Alpha> begin_animation_vfunc(guint duration, gulong mode);


    virtual double get_animation_progress_vfunc();

    virtual void end_animation_vfunc();


  /**
   * @par Slot Prototype:
   * <tt>void on_my_%layout_changed()</tt>
   *
   * The signal_layout_changed() signal is emitted each time a layout manager
   * has been changed. Every Clutter::Actor using the @a manager instance
   * as a layout manager should connect a handler to the signal_layout_changed()
   * signal and queue a relayout on themselves:
   * 
   * 
   * [C example ellipted]
   * 
   * Sub-classes of Clutter::LayoutManager that implement a layout that
   * can be controlled or changed using parameters should emit the
   * signal_layout_changed() signal whenever one of the parameters changes,
   * by using Clutter::LayoutManager::layout_changed().
   * 
   * @newin{1,2}
   */

  Glib::SignalProxy0< void > signal_layout_changed();


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::
  /// This is a default handler for the signal signal_layout_changed().
  virtual void on_layout_changed();


};

template <class PropertyType> inline
void LayoutManager::set_child_property(const Glib::RefPtr<Container>& container, const Glib::RefPtr<Actor>& actor, const Glib::ustring& property_name, const PropertyType& value)
{
  Glib::Value<PropertyType> property_value;
  property_value.init(Glib::Value<PropertyType>::value_type());

  property_value.set(value);
  this->set_child_property_value(container, actor, property_name, property_value);
}

template <class PropertyType> inline
void LayoutManager::get_child_property(const Glib::RefPtr<Container>& container, const Glib::RefPtr<const Actor>& actor, const Glib::ustring& property_name, PropertyType& value) const
{
  Glib::Value<PropertyType> property_value;
  property_value.init(Glib::Value<PropertyType>::value_type());

  this->get_child_property_value(container, actor, property_name, property_value);

  value = property_value.get();
}

} // namespace Clutter


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Clutter::LayoutManager
   */
  Glib::RefPtr<Clutter::LayoutManager> wrap(ClutterLayoutManager* object, bool take_copy = false);
}


#endif /* _CLUTTERMM_LAYOUT_MANAGER_H */

