// -*- c++ -*-
// Generated by gmmproc 2.39.93 -- DO NOT MODIFY!
#ifndef _CLUTTERMM_KEYFRAME_TRANSITION_H
#define _CLUTTERMM_KEYFRAME_TRANSITION_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* Copyright (C) 2013 The cluttermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <vector>
#include <glibmm/ustring.h>
#include <cluttermm/property-transition.h>
#include <cluttermm/actor.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _ClutterKeyframeTransition ClutterKeyframeTransition;
typedef struct _ClutterKeyframeTransitionClass ClutterKeyframeTransitionClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Clutter
{ class KeyFrameTransition_Class; } // namespace Clutter
namespace Clutter
{


class KeyFrameTransition :
    public PropertyTransition
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef KeyFrameTransition CppObjectType;
  typedef KeyFrameTransition_Class CppClassType;
  typedef ClutterKeyframeTransition BaseObjectType;
  typedef ClutterKeyframeTransitionClass BaseClassType;

private:  friend class KeyFrameTransition_Class;
  static CppClassType keyframetransition_class_;

private:
  // noncopyable
  KeyFrameTransition(const KeyFrameTransition&);
  KeyFrameTransition& operator=(const KeyFrameTransition&);

protected:
  explicit KeyFrameTransition(const Glib::ConstructParams& construct_params);
  explicit KeyFrameTransition(ClutterKeyframeTransition* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~KeyFrameTransition();

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  ClutterKeyframeTransition*       gobj()       { return reinterpret_cast<ClutterKeyframeTransition*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const ClutterKeyframeTransition* gobj() const { return reinterpret_cast<ClutterKeyframeTransition*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  ClutterKeyframeTransition* gobj_copy();

private:


protected:

    explicit KeyFrameTransition(const Glib::ustring& property_name);


  //TODO: This class is a problem.  C uses a variadic template.
  //There is no way of adding keyframes to a Transition, unless you wipe all the existing ones and start over.

public:
  
  static Glib::RefPtr<KeyFrameTransition> create(const Glib::ustring& property_name);


  /** Sets the keys for each key frame inside @a transition.
   * 
   * If @a transition does not hold any key frame, @a n_key_frames key frames
   * will be created; if @a transition already has key frames, @a key_frames must
   * have at least as many elements as the number of key frames.
   * 
   * @newin{1,12}
   * @param n_key_frames The number of values.
   * @param key_frames An array of keys between 0.0
   * and 1.0, one for each key frame.
   */
  void set_key_frames(guint index, const double* key_points);

  
  /** Sets the easing modes for each key frame inside @a transition.
   * 
   * If @a transition does not hold any key frame, @a n_modes key frames will
   * be created; if @a transition already has key frames, @a modes must have
   * at least as many elements as the number of key frames.
   * 
   * @newin{1,12}
   * @param n_modes The number of easing modes.
   * @param modes An array of easing modes, one for
   * each key frame.
   */

  void set_modes(const std::vector<AnimationMode>& modes);
  

  //Because the keyframe transition is only for one parameter of the object,
  //we only need to know the GType once. All the values will be of the same
  //type.
  
  /** Sets the values for each key frame inside @a transition.
   * 
   * If @a transition does not hold any key frame, @a n_values key frames will
   * be created; if @a transition already has key frames, @a values must have
   * at least as many elements as the number of key frames.
   * 
   * @newin{1,12}
   * @param n_values The number of values.
   * @param values An array of values, one for each
   * key frame.
   */

  template <typename ValueType>
  void set_values(const std::vector<ValueType>& values);
  

  /** Retrieves the number of key frames inside @a transition.
   * 
   * @newin{1,12}
   * @return The number of key frames.
   */
  guint get_n_key_frames() const;

  
  /** Sets the details of the key frame at @a index inside @a transition.
   * 
   * The @a transition must already have a key frame at @a index, and @a index
   * must be smaller than the number of key frames inside @a transition.
   * 
   * @newin{1,12}
   * @param index The index of the key frame.
   * @param key The key of the key frame.
   * @param mode The easing mode of the key frame.
   * @param value A Value containing the value of the key frame.
   */
  void set_key_frame(guint index_, double key, AnimationMode mode, const Glib::ValueBase& value);

  //TODO: clutter_keyframe_transition_get_key_frame

  
  /** Removes all key frames from @a transition.
   * 
   * @newin{1,12}
   */
  void clear();


  //gtkmmproc error: max-row-height : property defs lookup failed.
  //gtkmmproc error: snap-to-grid : property defs lookup failed.


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

#ifndef DOXYGEN_SHOULD_SKIP_THIS
template <typename ValueType>
void KeyFrameTransition::set_values(const std::vector<ValueType>& values)
{
  double valuearray[values.size()];

  for(int i = 0; i != values.size(); i++)
  {
    Glib::Value<ValueType> val;
    val.init( Glib::Value<ValueType>::value_type() );

    val.set(values.at(i));
    valuearray[i] = val;
  }

  clutter_keyframe_transition_set_values(gobj(), valuearray.size(), valuearray);
}

/* TODO:
template <class PropertyType>
void Container::set_child_property(const Glib::RefPtr<Actor>& child, const Glib::ustring& property_name, const PropertyType& value)
{
  Glib::Value<PropertyType> property_value;
  property_value.init(Glib::Value<PropertyType>::value_type());

  property_value.set(value);
  this->set_child_property_value(child, property_name.c_str(), property_value);
}
*/

#endif //DOXYGEN_SHOULD_SKIP_THIS

} // namespace Clutter


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Clutter::KeyFrameTransition
   */
  Glib::RefPtr<Clutter::KeyFrameTransition> wrap(ClutterKeyframeTransition* object, bool take_copy = false);
}


#endif /* _CLUTTERMM_KEYFRAME_TRANSITION_H */

