// -*- c++ -*-
// Generated by gmmproc 2.39.93 -- DO NOT MODIFY!
#ifndef _CLUTTERMM_BRIGHTNESS_CONTRAST_EFFECT_H
#define _CLUTTERMM_BRIGHTNESS_CONTRAST_EFFECT_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* Copyright (C) 2013 The cluttermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <cluttermm/offscreen-effect.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _ClutterBrightnessContrastEffect ClutterBrightnessContrastEffect;
typedef struct _ClutterBrightnessContrastEffectClass ClutterBrightnessContrastEffectClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Clutter
{ class BrightnessContrastEffect_Class; } // namespace Clutter
namespace Clutter
{

class Color;


class BrightnessContrastEffect :
  public OffscreenEffect
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef BrightnessContrastEffect CppObjectType;
  typedef BrightnessContrastEffect_Class CppClassType;
  typedef ClutterBrightnessContrastEffect BaseObjectType;
  typedef ClutterBrightnessContrastEffectClass BaseClassType;

private:  friend class BrightnessContrastEffect_Class;
  static CppClassType brightnesscontrasteffect_class_;

private:
  // noncopyable
  BrightnessContrastEffect(const BrightnessContrastEffect&);
  BrightnessContrastEffect& operator=(const BrightnessContrastEffect&);

protected:
  explicit BrightnessContrastEffect(const Glib::ConstructParams& construct_params);
  explicit BrightnessContrastEffect(ClutterBrightnessContrastEffect* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~BrightnessContrastEffect();

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  ClutterBrightnessContrastEffect*       gobj()       { return reinterpret_cast<ClutterBrightnessContrastEffect*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const ClutterBrightnessContrastEffect* gobj() const { return reinterpret_cast<ClutterBrightnessContrastEffect*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  ClutterBrightnessContrastEffect* gobj_copy();

private:

protected:
  BrightnessContrastEffect();

public:
  
  static Glib::RefPtr<BrightnessContrastEffect> create();


  /** The range of @a brightness is [-1.0, 1.0], where 0.0 designates no change;
   * a value below 0.0 indicates a decrease in brightness; and a value
   * above 0.0 indicates an increase of brightness.
   * 
   * @newin{1,10}
   * @param brightness The brightness change for all three components (r, g, b).
   */
  void set_brightness(float brightness);
  
  /** The range for each component is [-1.0, 1.0] where 0.0 designates no change,
   * values below 0.0 mean a decrease in brightness, and values above indicate
   * an increase.
   * 
   * @newin{1,10}
   * @param red Red component of the change in brightness.
   * @param green Green component of the change in brightness.
   * @param blue Blue component of the change in brightness.
   */
  void set_brightness(float red, float green, float blue);
  
  /** Retrieves the change in brightness used by @a effect.
   * 
   * @newin{1,10}
   * @param red Return location for red component of the
   * change in brightness.
   * @param green Return location for green component of the
   * change in brightness.
   * @param blue Return location for blue component of the
   * change in brightness.
   */
  void get_brightness(float& red, float& green, float& blue) const;

  
  /** The range for @a contrast is [-1.0, 1.0], where 0.0 designates no change;
   * a value below 0.0 indicates a decrease in contrast; and a value above
   * 0.0 indicates an increase.
   * 
   * @newin{1,10}
   * @param contrast Contrast change for all three channels.
   */
  void set_contrast(float contrast);
  
  /** The range for each component is [-1.0, 1.0] where 0.0 designates no change,
   * values below 0.0 mean a decrease in contrast, and values above indicate
   * an increase.
   * 
   * @newin{1,10}
   * @param red Red component of the change in contrast.
   * @param green Green component of the change in contrast.
   * @param blue Blue component of the change in contrast.
   */
  void set_contrast(float red, float green, float blue);
  
  /** Retrieves the contrast value used by @a effect.
   * 
   * @newin{1,10}
   * @param red Return location for red component of the
   * change in contrast.
   * @param green Return location for green component of the
   * change in contrast.
   * @param blue Return location for blue component of the
   * change in contrast.
   */
  void get_contrast(float& red, float& green, float& blue) const;

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The brightness change to apply.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Color > property_brightness() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The brightness change to apply.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Color > property_brightness() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The contrast change to apply.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Color > property_contrast() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The contrast change to apply.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Color > property_contrast() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

}//namespace Clutter


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Clutter::BrightnessContrastEffect
   */
  Glib::RefPtr<Clutter::BrightnessContrastEffect> wrap(ClutterBrightnessContrastEffect* object, bool take_copy = false);
}


#endif /* _CLUTTERMM_BRIGHTNESS_CONTRAST_EFFECT_H */

