// -*- c++ -*-
// Generated by gmmproc 2.39.93 -- DO NOT MODIFY!
#ifndef _CLUTTERMM_ACTOR_H
#define _CLUTTERMM_ACTOR_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* Copyright (C) 2007 The cluttermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <glibmm/object.h>
#include <pangomm/context.h>
#include <pangomm/layout.h>
#include <atkmm/object.h>
#include <cluttermm/action.h>
#include <cluttermm/actor-box.h>
#include <cluttermm/animation.h>
#include <cluttermm/animatable.h>
#include <cluttermm/color.h>
//#include <cluttermm/content.h>
#include <cluttermm/effect.h>
//#include <cluttermm/layout-manager.h>
#include <cluttermm/scriptable.h>
#include <cluttermm/shader.h>
#include <cluttermm/transition.h>
#include <cluttermm/types.h> // For Event*


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _ClutterActor ClutterActor;
typedef struct _ClutterActorClass ClutterActorClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Clutter
{ class Actor_Class; } // namespace Clutter
namespace Clutter
{

typedef ClutterMatrix Matrix;
typedef ClutterPaintVolume PaintVolume;

class Animation;
class Constraint;
class Content;
class LayoutManager;

/** @addtogroup cluttermmEnums cluttermm Enums and Flags */

/** 
 *  @var ActorAlign ACTOR_ALIGN_FILL
 *  Stretch to cover the whole allocated space.
 * 
 *  @var ActorAlign ACTOR_ALIGN_START
 *  Snap to left or top side, leaving space to the right or bottom. For horizontal layouts, in right-to-left locales this should be reversed.
 * 
 *  @var ActorAlign ACTOR_ALIGN_CENTER
 *  Center the actor inside the allocation.
 * 
 *  @var ActorAlign ACTOR_ALIGN_END
 *  Snap to right or bottom side, leaving space to the left or top. For horizontal layouts, in right-to-left locales this should be reversed.
 * 
 *  @enum ActorAlign
 * 
 * Controls how a Clutter::Actor should align itself inside the extra space
 * assigned to it during the allocation.
 * 
 * Alignment only matters if the allocated space given to an actor is
 * bigger than its natural size; for example, when the Clutter::Actor::property_x_expand()
 * or the Clutter::Actor::property_y_expand() properties of Clutter::Actor are set to <tt>true</tt>.
 * 
 * @newin{1,10}
 * @ingroup cluttermmEnums
 */
enum ActorAlign
{
  ACTOR_ALIGN_FILL,
  ACTOR_ALIGN_START,
  ACTOR_ALIGN_CENTER,
  ACTOR_ALIGN_END
};

} // namespace Clutter


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Clutter::ActorAlign> : public Glib::Value_Enum<Clutter::ActorAlign>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Clutter
{

/** 
 *  @var ActorFlags ACTOR_MAPPED
 *  The actor will be painted (is visible, and inside a toplevel, and all parents visible).
 * 
 *  @var ActorFlags ACTOR_REALIZED
 *  The resources associated to the actor have been allocated.
 * 
 *  @var ActorFlags ACTOR_REACTIVE
 *  The actor 'reacts' to mouse events emmitting event signals.
 * 
 *  @var ActorFlags ACTOR_VISIBLE
 *  The actor has been shown by the application program.
 * 
 *  @var ActorFlags ACTOR_NO_LAYOUT
 *  The actor provides an explicit layout management policy for its children; this flag will prevent Clutter from automatic queueing of relayout and will defer all layouting to the actor itself.
 * 
 *  @enum ActorFlags
 * 
 * Flags used to signal the state of an actor.
 * @ingroup cluttermmEnums
 * @par Bitwise operators:
 * <tt>%ActorFlags operator|(ActorFlags, ActorFlags)</tt><br>
 * <tt>%ActorFlags operator&(ActorFlags, ActorFlags)</tt><br>
 * <tt>%ActorFlags operator^(ActorFlags, ActorFlags)</tt><br>
 * <tt>%ActorFlags operator~(ActorFlags)</tt><br>
 * <tt>%ActorFlags& operator|=(ActorFlags&, ActorFlags)</tt><br>
 * <tt>%ActorFlags& operator&=(ActorFlags&, ActorFlags)</tt><br>
 * <tt>%ActorFlags& operator^=(ActorFlags&, ActorFlags)</tt><br>
 */
enum ActorFlags
{
  ACTOR_MAPPED = 1 << 1,
  ACTOR_REALIZED = 1 << 2,
  ACTOR_REACTIVE = 1 << 3,
  ACTOR_VISIBLE = 1 << 4,
  ACTOR_NO_LAYOUT = 1 << 5
};

/** @ingroup cluttermmEnums */
inline ActorFlags operator|(ActorFlags lhs, ActorFlags rhs)
  { return static_cast<ActorFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup cluttermmEnums */
inline ActorFlags operator&(ActorFlags lhs, ActorFlags rhs)
  { return static_cast<ActorFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup cluttermmEnums */
inline ActorFlags operator^(ActorFlags lhs, ActorFlags rhs)
  { return static_cast<ActorFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup cluttermmEnums */
inline ActorFlags operator~(ActorFlags flags)
  { return static_cast<ActorFlags>(~static_cast<unsigned>(flags)); }

/** @ingroup cluttermmEnums */
inline ActorFlags& operator|=(ActorFlags& lhs, ActorFlags rhs)
  { return (lhs = static_cast<ActorFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup cluttermmEnums */
inline ActorFlags& operator&=(ActorFlags& lhs, ActorFlags rhs)
  { return (lhs = static_cast<ActorFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup cluttermmEnums */
inline ActorFlags& operator^=(ActorFlags& lhs, ActorFlags rhs)
  { return (lhs = static_cast<ActorFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }

} // namespace Clutter


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Clutter::ActorFlags> : public Glib::Value_Flags<Clutter::ActorFlags>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Clutter
{

/** 
 *  @var AllocationFlags ALLOCATION_NONE
 *  No flag set.
 * 
 *  @var AllocationFlags ABSOLUTE_ORIGIN_CHANGED
 *  Whether the absolute origin of the actor has changed; this implies that any ancestor of the actor has been moved.
 * 
 *  @var AllocationFlags DELEGATE_LAYOUT
 *  Whether the allocation should be delegated to the Clutter::LayoutManager instance stored inside the Clutter::Actor::property_layout_manager() property of Clutter::Actor. This flag should only be used if you are subclassing Clutter::Actor and overriding the Clutter::ActorClass.allocate() virtual function, but you wish to use the default implementation of the virtual function inside Clutter::Actor. Added in Clutter 1.10.
 * 
 *  @enum AllocationFlags
 * 
 * Flags passed to the Clutter::ActorClass.allocate() virtual function
 * and to the Clutter::Actor::allocate() function.
 * 
 * @newin{1,0}
 * @ingroup cluttermmEnums
 * @par Bitwise operators:
 * <tt>%AllocationFlags operator|(AllocationFlags, AllocationFlags)</tt><br>
 * <tt>%AllocationFlags operator&(AllocationFlags, AllocationFlags)</tt><br>
 * <tt>%AllocationFlags operator^(AllocationFlags, AllocationFlags)</tt><br>
 * <tt>%AllocationFlags operator~(AllocationFlags)</tt><br>
 * <tt>%AllocationFlags& operator|=(AllocationFlags&, AllocationFlags)</tt><br>
 * <tt>%AllocationFlags& operator&=(AllocationFlags&, AllocationFlags)</tt><br>
 * <tt>%AllocationFlags& operator^=(AllocationFlags&, AllocationFlags)</tt><br>
 */
enum AllocationFlags
{
  ALLOCATION_NONE = 0x0,
  ABSOLUTE_ORIGIN_CHANGED = 1 << 1,
  DELEGATE_LAYOUT = 1 << 2
};

/** @ingroup cluttermmEnums */
inline AllocationFlags operator|(AllocationFlags lhs, AllocationFlags rhs)
  { return static_cast<AllocationFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup cluttermmEnums */
inline AllocationFlags operator&(AllocationFlags lhs, AllocationFlags rhs)
  { return static_cast<AllocationFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup cluttermmEnums */
inline AllocationFlags operator^(AllocationFlags lhs, AllocationFlags rhs)
  { return static_cast<AllocationFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup cluttermmEnums */
inline AllocationFlags operator~(AllocationFlags flags)
  { return static_cast<AllocationFlags>(~static_cast<unsigned>(flags)); }

/** @ingroup cluttermmEnums */
inline AllocationFlags& operator|=(AllocationFlags& lhs, AllocationFlags rhs)
  { return (lhs = static_cast<AllocationFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup cluttermmEnums */
inline AllocationFlags& operator&=(AllocationFlags& lhs, AllocationFlags rhs)
  { return (lhs = static_cast<AllocationFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup cluttermmEnums */
inline AllocationFlags& operator^=(AllocationFlags& lhs, AllocationFlags rhs)
  { return (lhs = static_cast<AllocationFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }

} // namespace Clutter


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Clutter::AllocationFlags> : public Glib::Value_Flags<Clutter::AllocationFlags>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Clutter
{

/** 
 *  @var ContentRepeat REPEAT_NONE
 *  No repeat.
 * 
 *  @var ContentRepeat REPEAT_X_AXIS
 *  Repeat the content on the X axis.
 * 
 *  @var ContentRepeat REPEAT_Y_AXIS
 *  Repeat the content on the Y axis.
 * 
 *  @var ContentRepeat REPEAT_BOTH
 *  Repeat the content on both axis.
 * 
 *  @enum ContentRepeat
 * 
 * Content repeat modes.
 * 
 * @newin{1,12}
 * @ingroup cluttermmEnums
 * @par Bitwise operators:
 * <tt>%ContentRepeat operator|(ContentRepeat, ContentRepeat)</tt><br>
 * <tt>%ContentRepeat operator&(ContentRepeat, ContentRepeat)</tt><br>
 * <tt>%ContentRepeat operator^(ContentRepeat, ContentRepeat)</tt><br>
 * <tt>%ContentRepeat operator~(ContentRepeat)</tt><br>
 * <tt>%ContentRepeat& operator|=(ContentRepeat&, ContentRepeat)</tt><br>
 * <tt>%ContentRepeat& operator&=(ContentRepeat&, ContentRepeat)</tt><br>
 * <tt>%ContentRepeat& operator^=(ContentRepeat&, ContentRepeat)</tt><br>
 */
enum ContentRepeat
{
  REPEAT_NONE = 0x0,
  REPEAT_X_AXIS = 1 << 0,
  REPEAT_Y_AXIS = 1 << 1,
  REPEAT_BOTH = 0x3
};

/** @ingroup cluttermmEnums */
inline ContentRepeat operator|(ContentRepeat lhs, ContentRepeat rhs)
  { return static_cast<ContentRepeat>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup cluttermmEnums */
inline ContentRepeat operator&(ContentRepeat lhs, ContentRepeat rhs)
  { return static_cast<ContentRepeat>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup cluttermmEnums */
inline ContentRepeat operator^(ContentRepeat lhs, ContentRepeat rhs)
  { return static_cast<ContentRepeat>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup cluttermmEnums */
inline ContentRepeat operator~(ContentRepeat flags)
  { return static_cast<ContentRepeat>(~static_cast<unsigned>(flags)); }

/** @ingroup cluttermmEnums */
inline ContentRepeat& operator|=(ContentRepeat& lhs, ContentRepeat rhs)
  { return (lhs = static_cast<ContentRepeat>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup cluttermmEnums */
inline ContentRepeat& operator&=(ContentRepeat& lhs, ContentRepeat rhs)
  { return (lhs = static_cast<ContentRepeat>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup cluttermmEnums */
inline ContentRepeat& operator^=(ContentRepeat& lhs, ContentRepeat rhs)
  { return (lhs = static_cast<ContentRepeat>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }

} // namespace Clutter


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Clutter::ContentRepeat> : public Glib::Value_Flags<Clutter::ContentRepeat>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Clutter
{

/** 
 *  @var ContentGravity CONTENT_GRAVITY_TOP_LEFT
 *  Align the content to the top left corner.
 * 
 *  @var ContentGravity CONTENT_GRAVITY_TOP
 *  Align the content to the top edge.
 * 
 *  @var ContentGravity CONTENT_GRAVITY_TOP_RIGHT
 *  Align the content to the top right corner.
 * 
 *  @var ContentGravity CONTENT_GRAVITY_LEFT
 *  Align the content to the left edge.
 * 
 *  @var ContentGravity CONTENT_GRAVITY_CENTER
 *  Align the content to the center.
 * 
 *  @var ContentGravity CONTENT_GRAVITY_RIGHT
 *  Align the content to the right edge.
 * 
 *  @var ContentGravity CONTENT_GRAVITY_BOTTOM_LEFT
 *  Align the content to the bottom left corner.
 * 
 *  @var ContentGravity CONTENT_GRAVITY_BOTTOM
 *  Align the content to the bottom edge.
 * 
 *  @var ContentGravity CONTENT_GRAVITY_BOTTOM_RIGHT
 *  Align the content to the bottom right corner.
 * 
 *  @var ContentGravity CONTENT_GRAVITY_RESIZE_FILL
 *  Resize the content to fill the allocation.
 * 
 *  @var ContentGravity CONTENT_GRAVITY_RESIZE_ASPECT
 *  Resize the content to remain within the allocation, while maintaining the aspect ratio.
 * 
 *  @enum ContentGravity
 * 
 * Controls the alignment of the Clutter::Content inside a Clutter::Actor.
 * 
 * @newin{1,10}
 * @ingroup cluttermmEnums
 */
enum ContentGravity
{
  CONTENT_GRAVITY_TOP_LEFT,
  CONTENT_GRAVITY_TOP,
  CONTENT_GRAVITY_TOP_RIGHT,
  CONTENT_GRAVITY_LEFT,
  CONTENT_GRAVITY_CENTER,
  CONTENT_GRAVITY_RIGHT,
  CONTENT_GRAVITY_BOTTOM_LEFT,
  CONTENT_GRAVITY_BOTTOM,
  CONTENT_GRAVITY_BOTTOM_RIGHT,
  CONTENT_GRAVITY_RESIZE_FILL,
  CONTENT_GRAVITY_RESIZE_ASPECT
};

} // namespace Clutter


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Clutter::ContentGravity> : public Glib::Value_Enum<Clutter::ContentGravity>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Clutter
{

/** 
 *  @var OffscreenRedirect OFFSCREEN_REDIRECT_AUTOMATIC_FOR_OPACITY
 *  Only redirect the actor if it is semi-transparent and its has_overlaps() virtual returns <tt>true</tt>. This is the default.
 * 
 *  @var OffscreenRedirect OFFSCREEN_REDIRECT_ALWAYS
 *  Always redirect the actor to an offscreen buffer even if it is fully opaque.
 * 
 *  @enum OffscreenRedirect
 * 
 * Possible flags to pass to Clutter::Actor::set_offscreen_redirect().
 * 
 * @newin{1,8}
 * @ingroup cluttermmEnums
 * @par Bitwise operators:
 * <tt>%OffscreenRedirect operator|(OffscreenRedirect, OffscreenRedirect)</tt><br>
 * <tt>%OffscreenRedirect operator&(OffscreenRedirect, OffscreenRedirect)</tt><br>
 * <tt>%OffscreenRedirect operator^(OffscreenRedirect, OffscreenRedirect)</tt><br>
 * <tt>%OffscreenRedirect operator~(OffscreenRedirect)</tt><br>
 * <tt>%OffscreenRedirect& operator|=(OffscreenRedirect&, OffscreenRedirect)</tt><br>
 * <tt>%OffscreenRedirect& operator&=(OffscreenRedirect&, OffscreenRedirect)</tt><br>
 * <tt>%OffscreenRedirect& operator^=(OffscreenRedirect&, OffscreenRedirect)</tt><br>
 */
enum OffscreenRedirect
{
  OFFSCREEN_REDIRECT_AUTOMATIC_FOR_OPACITY = 1<<0,
  OFFSCREEN_REDIRECT_ALWAYS = 1<<1
};

/** @ingroup cluttermmEnums */
inline OffscreenRedirect operator|(OffscreenRedirect lhs, OffscreenRedirect rhs)
  { return static_cast<OffscreenRedirect>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup cluttermmEnums */
inline OffscreenRedirect operator&(OffscreenRedirect lhs, OffscreenRedirect rhs)
  { return static_cast<OffscreenRedirect>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup cluttermmEnums */
inline OffscreenRedirect operator^(OffscreenRedirect lhs, OffscreenRedirect rhs)
  { return static_cast<OffscreenRedirect>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup cluttermmEnums */
inline OffscreenRedirect operator~(OffscreenRedirect flags)
  { return static_cast<OffscreenRedirect>(~static_cast<unsigned>(flags)); }

/** @ingroup cluttermmEnums */
inline OffscreenRedirect& operator|=(OffscreenRedirect& lhs, OffscreenRedirect rhs)
  { return (lhs = static_cast<OffscreenRedirect>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup cluttermmEnums */
inline OffscreenRedirect& operator&=(OffscreenRedirect& lhs, OffscreenRedirect rhs)
  { return (lhs = static_cast<OffscreenRedirect>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup cluttermmEnums */
inline OffscreenRedirect& operator^=(OffscreenRedirect& lhs, OffscreenRedirect rhs)
  { return (lhs = static_cast<OffscreenRedirect>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }

} // namespace Clutter


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Clutter::OffscreenRedirect> : public Glib::Value_Flags<Clutter::OffscreenRedirect>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Clutter
{

/** 
 *  @var Orientation ORIENTATION_HORIZONTAL
 *  An horizontal orientation.
 * 
 *  @var Orientation ORIENTATION_VERTICAL
 *  A vertical orientation.
 * 
 *  @enum Orientation
 * 
 * Represents the orientation of actors or layout managers.
 * 
 * @newin{1,12}
 * @ingroup cluttermmEnums
 */
enum Orientation
{
  ORIENTATION_HORIZONTAL,
  ORIENTATION_VERTICAL
};

} // namespace Clutter


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Clutter::Orientation> : public Glib::Value_Enum<Clutter::Orientation>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Clutter
{


//TODO: Write a version of the large description from here: http://clutter-project.org/docs/clutter/stable/ClutterActor.html#ClutterActor.description

class Actor : public Glib::Object, public Scriptable, public Animatable
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef Actor CppObjectType;
  typedef Actor_Class CppClassType;
  typedef ClutterActor BaseObjectType;
  typedef ClutterActorClass BaseClassType;

private:  friend class Actor_Class;
  static CppClassType actor_class_;

private:
  // noncopyable
  Actor(const Actor&);
  Actor& operator=(const Actor&);

protected:
  explicit Actor(const Glib::ConstructParams& construct_params);
  explicit Actor(ClutterActor* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~Actor();

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  ClutterActor*       gobj()       { return reinterpret_cast<ClutterActor*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const ClutterActor* gobj() const { return reinterpret_cast<ClutterActor*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  ClutterActor* gobj_copy();

private:

  
protected:
  Actor();

public:

  
  static Glib::RefPtr<Actor> create();


  /** Sets @a flags on @a self
   * 
   * This function will emit notifications for the changed properties
   * 
   * @newin{1,0}
   * @param flags The flags to set.
   */
  void set_flags(ActorFlags flags);
  
  /** Unsets @a flags on @a self
   * 
   * This function will emit notifications for the changed properties
   * 
   * @newin{1,0}
   * @param flags The flags to unset.
   */
  void unset_flags(ActorFlags flags);
  
  /** Retrieves the flags set on @a self
   * 
   * @newin{1,0}
   * @return A bitwise or of Clutter::ActorFlags or 0.
   */
  ActorFlags get_flags() const;

  //TODO: Remove these now that there are properties instead?
  // Not at present; there are no accessors available.
  bool is_mapped() const;
  bool is_realized() const;
  bool is_visible() const;
  bool is_reactive() const;

  
  /** Flags an actor to be displayed. An actor that isn't shown will not
   * be rendered on the stage.
   * 
   * Actors are visible by default.
   * 
   * If this function is called on an actor without a parent, the
   * Clutter::Actor::property_show_on_set_parent() will be set to <tt>true</tt> as a side
   * effect.
   */
  void show();
  
#ifndef CLUTTERMM_DISABLE_DEPRECATED

  /** Calls show() on all children of an actor (if any).
   * 
   * @newin{0,2}
   * 
   * Deprecated: 1.10: Actors are visible by default
   * @deprecated Actors are visible by default.
   */
  void show_all();
#endif // CLUTTERMM_DISABLE_DEPRECATED


  /** Flags an actor to be hidden. A hidden actor will not be
   * rendered on the stage.
   * 
   * Actors are visible by default.
   * 
   * If this function is called on an actor without a parent, the
   * Clutter::Actor::property_show_on_set_parent() property will be set to <tt>false</tt>
   * as a side-effect.
   */
  void hide();
  
#ifndef CLUTTERMM_DISABLE_DEPRECATED

  /** Calls hide() on all child actors (if any).
   * 
   * @newin{0,2}
   * 
   * Deprecated: 1.10: Using hide() on the actor will
   * prevent its children from being painted as well.
   * @deprecated Using hide() on the actor will now prevent its children from being painted as well.
   */
  void hide_all();
#endif // CLUTTERMM_DISABLE_DEPRECATED


  /** Realization informs the actor that it is attached to a stage. It
   * can use this to allocate resources if it wanted to delay allocation
   * until it would be rendered. However it is perfectly acceptable for
   * an actor to create resources before being realized because Clutter
   * only ever has a single rendering context so that actor is free to
   * be moved from one stage to another.
   * 
   * This function does nothing if the actor is already realized.
   * 
   * Because a realized actor must have realized parent actors, calling
   * realize() will also realize all parents of the actor.
   * 
   * This function does not realize child actors, except in the special
   * case that realizing the stage, when the stage is visible, will
   * suddenly map (and thus realize) the children of the stage.
   * 
   * Deprecated: 1.16: Actors are automatically realized, and nothing
   * requires explicit realization.
   */
  void realize();
  
  /** Unrealization informs the actor that it may be being destroyed or
   * moved to another stage. The actor may want to destroy any
   * underlying graphics resources at this point. However it is
   * perfectly acceptable for it to retain the resources until the actor
   * is destroyed because Clutter only ever uses a single rendering
   * context and all of the graphics resources are valid on any stage.
   * 
   * Because mapped actors must be realized, actors may not be
   * unrealized if they are mapped. This function hides the actor to be
   * sure it isn't mapped, an application-visible side effect that you
   * may not be expecting.
   * 
   * This function should not be called by application code.
   * 
   * This function should not really be in the public API, because
   * there isn't a good reason to call it. ClutterActor will already
   * unrealize things for you when it's important to do so.
   * 
   * If you were using unrealize() in a dispose
   * implementation, then don't, just chain up to ClutterActor's
   * dispose.
   * 
   * If you were using unrealize() to implement
   * unrealizing children of your container, then don't, ClutterActor
   * will already take care of that.
   * 
   * Deprecated: 1.16: Actors are automatically unrealized, and nothing
   * requires explicit realization.
   */
  void unrealize();
  
  /** Sets the Clutter::ACTOR_MAPPED flag on the actor and possibly maps
   * and realizes its children if they are visible. Does nothing if the
   * actor is not visible.
   * 
   * Calling this function is strongly disencouraged: the default
   * implementation of Clutter::ActorClass.map() will map all the children
   * of an actor when mapping its parent.
   * 
   * When overriding map, it is mandatory to chain up to the parent
   * implementation.
   * 
   * @newin{1,0}
   */
  void map();
  
  /** Unsets the Clutter::ACTOR_MAPPED flag on the actor and possibly
   * unmaps its children if they were mapped.
   * 
   * Calling this function is not encouraged: the default Clutter::Actor
   * implementation of Clutter::ActorClass.unmap() will also unmap any
   * eventual children by default when their parent is unmapped.
   * 
   * When overriding Clutter::ActorClass.unmap(), it is mandatory to
   * chain up to the parent implementation.
   * 
   * <note>It is important to note that the implementation of the
   * Clutter::ActorClass.unmap() virtual function may be called after
   * the Clutter::ActorClass.destroy() or the ObjectClass.dispose()
   * implementation, but it is guaranteed to be called before the
   * ObjectClass.finalize() implementation.</note>
   * 
   * @newin{1,0}
   */
  void unmap();
  
  /** Renders the actor to display.
   * 
   * This function should not be called directly by applications.
   * Call queue_redraw() to queue paints, instead.
   * 
   * This function is context-aware, and will either cause a
   * regular paint or a pick paint.
   * 
   * This function will emit the Clutter::Actor::signal_paint() signal or
   * the Clutter::Actor::signal_pick() signal, depending on the context.
   * 
   * This function does not paint the actor if the actor is set to 0,
   * unless it is performing a pick paint.
   */
  void paint();
  
  /** Run the next stage of the paint sequence. This function should only
   * be called within the implementation of the ‘run’ virtual of a
   * Clutter::Effect. It will cause the run method of the next effect to
   * be applied, or it will paint the actual actor if the current effect
   * is the last effect in the chain.
   * 
   * @newin{1,8}
   */
  void continue_paint();
  
  /** Queues up a redraw of an actor and any children. The redraw occurs
   * once the main loop becomes idle (after the current batch of events
   * has been processed, roughly).
   * 
   * Applications rarely need to call this, as redraws are handled
   * automatically by modification functions.
   * 
   * This function will not do anything if @a self is not visible, or
   * if the actor is inside an invisible part of the scenegraph.
   * 
   * Also be aware that painting is a NOP for actors with an opacity of
   * 0
   * 
   * When you are implementing a custom actor you must queue a redraw
   * whenever some private state changes that will affect painting or
   * picking of your actor.
   */
  void queue_redraw();
  
  /** Indicates that the actor's size request or other layout-affecting
   * properties may have changed. This function is used inside Clutter::Actor
   * subclass implementations, not by applications directly.
   * 
   * Queueing a new layout automatically queues a redraw as well.
   * 
   * @newin{0,8}
   */
  void queue_relayout();
   //internal.
   //not for application code.
   //not for application code.

  
  /** Asks the actor's implementation whether it may contain overlapping
   * primitives.
   * 
   * For example; Clutter may use this to determine whether the painting
   * should be redirected to an offscreen buffer to correctly implement
   * the opacity property.
   * 
   * Custom actors can override the default response by implementing the
   * Clutter::Actor <tt>has_overlaps</tt> virtual function. See
   * set_offscreen_redirect() for more information.
   * 
   * @newin{1,8}
   * @return <tt>true</tt> if the actor may have overlapping primitives, and
   * <tt>false</tt> otherwise.
   */
  bool has_overlaps();

  
  /** Sets the contents of a Clutter::Actor.
   * 
   * @newin{1,10}
   * @param content A Clutter::Content, or <tt>0</tt>.
   */
  void set_content(const Glib::RefPtr<Content>& content);

  
  /** Retrieves the contents of @a self.
   * 
   * @newin{1,10}
   * @return A pointer to the Clutter::Content instance,
   * or <tt>0</tt> if none was set.
   */
  Glib::RefPtr<Content> get_content();
  
  /** Retrieves the contents of @a self.
   * 
   * @newin{1,10}
   * @return A pointer to the Clutter::Content instance,
   * or <tt>0</tt> if none was set.
   */
  Glib::RefPtr<const Content> get_content() const;

  
  /** Sets the gravity of the Clutter::Content used by @a self.
   * 
   * See the description of the Clutter::Actor::property_content_gravity() property for
   * more information.
   * 
   * The Clutter::Actor::property_content_gravity() property is animatable.
   * 
   * @newin{1,10}
   * @param gravity The Clutter::ContentGravity.
   */
  void set_content_gravity(ContentGravity gravity);

  
  /** Retrieves the content gravity as set using
   * set_content_gravity().
   * 
   * @newin{1,10}
   * @return The content gravity.
   */
  ContentGravity get_content_gravity() const;

  
  /** Sets the minification and magnification filter to be applied when
   * scaling the Clutter::Actor::property_content() of a Clutter::Actor.
   * 
   * The Clutter::Actor::property_minification_filter() will be used when reducing
   * the size of the content; the Clutter::Actor::property_magnification_filter()
   * will be used when increasing the size of the content.
   * 
   * @newin{1,10}
   * @param min_filter The minification filter for the content.
   * @param mag_filter The magnification filter for the content.
   */
  void set_content_scaling_filters(ScalingFilter min_filter, ScalingFilter mag_filter);

 
  /** Retrieves the values set using set_content_scaling_filters().
   * 
   * @newin{1,10}
   * @param min_filter Return location for the minification
   * filter, or <tt>0</tt>.
   * @param mag_filter Return location for the magnification
   * filter, or <tt>0</tt>.
   */
  void get_content_scaling_filters(ScalingFilter& min_filter, ScalingFilter& mag_filter);

  
  /** Sets the policy for repeating the Clutter::Actor::property_content() of a
   * Clutter::Actor. The behaviour is deferred to the Clutter::Content
   * implementation.
   * 
   * @newin{1,12}
   * @param repeat The repeat policy.
   */
  void set_content_repeat(ContentRepeat repeat);
  
  /** Retrieves the repeat policy for a Clutter::Actor set by
   * set_content_repeat().
   * 
   * @newin{1,12}
   * @return The content repeat policy.
   */
  ContentRepeat get_content_repeat() const;

  ActorBox get_content_box() const;
  

  //TODO: Check that we don't want to wrap this: _WRAP_METHOD(void destroy(), clutter_actor_destroy)
  //__IGNORE(clutter_actor_destroy)
  
  /** Destroys an actor.  When an actor is destroyed, it will break any
   * references it holds to other objects.  If the actor is inside a
   * container, the actor will be removed.
   * 
   * When you destroy a container, its children will be destroyed as well.
   * 
   * @note you cannot destroy the Clutter::Stage returned by
   * Clutter::Stage::get_default().
   */
  void destroy();

  
  /** Retrieves the Pango::Context for @a self. The actor's Pango::Context
   * is already configured using the appropriate font map, resolution
   * and font options.
   * 
   * Unlike create_pango_context(), this context is owend
   * by the Clutter::Actor and it will be updated each time the options
   * stored by the Clutter::Backend change.
   * 
   * You can use the returned Pango::Context to create a Pango::Layout
   * and render text using cogl_pango_render_layout() to reuse the
   * glyphs cache also used by Clutter.
   * 
   * @newin{1,0}
   * @return The Pango::Context for a Clutter::Actor.
   * The returned Pango::Context is owned by the actor and should not be
   * unreferenced by the application code.
   */
  Glib::RefPtr<Pango::Context> get_pango_context();
  
  /** Retrieves the Pango::Context for @a self. The actor's Pango::Context
   * is already configured using the appropriate font map, resolution
   * and font options.
   * 
   * Unlike create_pango_context(), this context is owend
   * by the Clutter::Actor and it will be updated each time the options
   * stored by the Clutter::Backend change.
   * 
   * You can use the returned Pango::Context to create a Pango::Layout
   * and render text using cogl_pango_render_layout() to reuse the
   * glyphs cache also used by Clutter.
   * 
   * @newin{1,0}
   * @return The Pango::Context for a Clutter::Actor.
   * The returned Pango::Context is owned by the actor and should not be
   * unreferenced by the application code.
   */
  Glib::RefPtr<const Pango::Context> get_pango_context() const;
  
  /** Creates a Pango::Context for the given actor. The Pango::Context
   * is already configured using the appropriate font map, resolution
   * and font options.
   * 
   * See also get_pango_context().
   * 
   * @newin{1,0}
   * @return The newly created Pango::Context.
   * Use Glib::object_unref() on the returned value to deallocate its
   * resources.
   */
  Glib::RefPtr<Pango::Context> create_pango_context();

  
  /** Creates a new Pango::Layout from the same Pango::Context used
   * by the Clutter::Actor. The Pango::Layout is already configured
   * with the font map, resolution and font options, and the
   * given @a text.
   * 
   * If you want to keep around a Pango::Layout created by this
   * function you will have to connect to the Clutter::Backend::signal_font_changed()
   * and Clutter::Backend::signal_resolution_changed() signals, and call
   * pango_layout_context_changed() in response to them.
   * 
   * @newin{1,0}
   * @param text The text to set on the Pango::Layout, or <tt>0</tt>.
   * @return The newly created Pango::Layout.
   * Use Glib::object_unref() when done.
   */
  Glib::RefPtr<Pango::Layout> create_pango_layout(const Glib::ustring& text);

   //handcoded to allow returning the Matrix.

  /**
   * Returns the transformation matrix being used by the actor.
   * */
  Matrix get_transform() const;

  
#ifndef CLUTTERMM_DISABLE_DEPRECATED

  /** Retrieves the transformations applied to @a self relative to its
   * parent.
   * 
   * @newin{1,0}
   * 
   * Deprecated: 1.12: Use get_transform() instead
   * @deprecated Use get_transform() instead
   * @param matrix The return location for a Clutter::Matrix.
   */
  void get_transformation_matrix(ClutterMatrix* matrix);
#endif // CLUTTERMM_DISABLE_DEPRECATED


  /** Overrides the transformations of a Clutter::Actor with a custom
   * matrix, which will be applied relative to the origin of the
   * actor's allocation and to the actor's pivot point.
   * 
   * The Clutter::Actor::property_transform() property is animatable.
   * 
   * @newin{1,12}
   * @param transform A Clutter::Matrix, or <tt>0</tt> to
   * unset a custom transformation.
   */
  void set_transform(const Matrix& transform);
  
  /** Sets the transformation matrix to be applied to all the children
   * of @a self prior to their own transformations. The default child
   * transformation is the identity matrix.
   * 
   * If @a transform is <tt>0</tt>, the child transform will be unset.
   * 
   * The Clutter::Actor::property_child_transform() property is animatable.
   * 
   * @newin{1,12}
   * @param transform A Clutter::Matrix, or <tt>0</tt>.
   */
  void set_child_transform(const Matrix& transform);

  
  /** Checks whether @a self is being currently painted by a Clutter::Clone
   * 
   * This function is useful only inside the signal_paint() virtual function
   * implementations or within handlers for the Clutter::Actor::signal_paint()
   * signal
   * 
   * This function should not be used by applications
   * 
   * @newin{1,0}
   * @return <tt>true</tt> if the Clutter::Actor is currently being painted
   * by a Clutter::Clone, and <tt>false</tt> otherwise.
   */
  bool is_in_clone_paint() const;

 
  /** Retrieves the paint volume of the passed Clutter::Actor, and
   * transforms it into a 2D bounding box in stage coordinates.
   * 
   * This function is useful to determine the on screen area occupied by
   * the actor. The box is only an approximation and may often be
   * considerably larger due to the optimizations used to calculate the
   * box. The box is never smaller though, so it can reliably be used
   * for culling.
   * 
   * There are times when a 2D paint box can't be determined, e.g.
   * because the actor isn't yet parented under a stage or because
   * the actor is unable to determine a paint volume.
   * 
   * @newin{1,6}
   * @param box Return location for a Clutter::ActorBox.
   * @return <tt>true</tt> if a 2D paint box could be determined, else
   * <tt>false</tt>.
   */
  bool get_paint_box(ActorBox& box);

  
  /** Checks whether an actor contains the pointer of a
   * Clutter::InputDevice
   * 
   * @newin{1,2}
   * @return <tt>true</tt> if the actor contains the pointer, and
   * <tt>false</tt> otherwise.
   */
  bool has_pointer() const;
  
  /** Sets the Clutter::TextDirection for an actor
   * 
   * The passed text direction must not be Clutter::TEXT_DIRECTION_DEFAULT
   * 
   * If @a self implements Clutter::Container then this function will recurse
   * inside all the children of @a self (including the internal ones).
   * 
   * Composite actors not implementing Clutter::Container, or actors requiring
   * special handling when the text direction changes, should connect to
   * the Object::signal_notify() signal for the Clutter::Actor::property_text_direction() property
   * 
   * @newin{1,2}
   * @param text_dir The text direction for @a self.
   */
  void set_text_direction(TextDirection text_dir);
  
  /** Retrieves the value set using set_text_direction()
   * 
   * If no text direction has been previously set, the default text
   * direction, as returned by clutter_get_default_text_direction(), will
   * be returned instead
   * 
   * @newin{1,2}
   * @return The Clutter::TextDirection for the actor.
   */
  TextDirection get_text_direction() const;


  /** Retrieves the Clutter::Stage where @a actor is contained.
   * 
   * @newin{0,8}
   * @return The stage
   * containing the actor, or <tt>0</tt>.
   */
  Glib::RefPtr<Actor> get_stage();
  
  /** Retrieves the Clutter::Stage where @a actor is contained.
   * 
   * @newin{0,8}
   * @return The stage
   * containing the actor, or <tt>0</tt>.
   */
  Glib::RefPtr<const Actor> get_stage() const;

  
  /** Sets @a child to be below @a sibling in the list of children of @a self.
   * 
   * If @a sibling is <tt>0</tt>, @a child will be the new first child of @a self.
   * 
   * This function is logically equivalent to removing @a self and using
   * insert_child_below(), but it will not emit signals
   * or change state on @a child.
   * 
   * @newin{1,10}
   * @param child A Clutter::Actor child of @a self.
   * @param sibling A Clutter::Actor child of @a self, or <tt>0</tt>.
   */
  void set_child_below_sibling(const Glib::RefPtr<Actor>& child, const Glib::RefPtr<Actor>& sibling);
  
  /** Sets @a child to be above @a sibling in the list of children of @a self.
   * 
   * If @a sibling is <tt>0</tt>, @a child will be the new last child of @a self.
   * 
   * This function is logically equivalent to removing @a child and using
   * insert_child_above(), but it will not emit signals
   * or change state on @a child.
   * 
   * @newin{1,10}
   * @param child A Clutter::Actor child of @a self.
   * @param sibling A Clutter::Actor child of @a self, or <tt>0</tt>.
   */
  void set_child_above_sibling(const Glib::RefPtr<Actor>& child, const Glib::RefPtr<Actor>& sibling);
  
  /** Changes the index of @a child in the list of children of @a self.
   * 
   * This function is logically equivalent to removing @a child and
   * calling insert_child_at_index(), but it will not
   * emit signals or change state on @a child.
   * 
   * @newin{1,10}
   * @param child A Clutter::Actor child of @a self.
   * @param index The new index for @a child.
   */
  void set_child_at_index(const Glib::RefPtr<Actor>& child, int index);

 
#ifndef CLUTTERMM_DISABLE_DEPRECATED

  /** Sets the actor's fixed position and forces its minimum and natural
   * size, in pixels. This means the untransformed actor will have the
   * given geometry. This is the same as calling set_position()
   * and set_size().
   * 
   * Deprecated: 1.10: Use set_position() and
   * set_size() instead.
   * @deprecated Use set_position() and set_size() instead.
   * @param geometry A Clutter::Geometry.
   */
  void set_geometry(const Geometry& geometry);
#endif // CLUTTERMM_DISABLE_DEPRECATED


#ifndef CLUTTERMM_DISABLE_DEPRECATED

  
  /** Gets the size and position of an actor relative to its parent
   * actor. This is the same as calling get_position() and
   * get_size(). It tries to "do what you mean" and get the
   * requested size and position if the actor's allocation is invalid.
   * 
   * Deprecated: 1.10: Use get_position() and
   * get_size(), or get_allocation_geometry()
   * instead.
   * @param geometry A location to store actors Clutter::Geometry.
   */

  /**
   * @deprecated Use get_position() and get_size(), or get_allocation_geometry() instead.
   */
  Geometry get_geometry() const;
#endif // CLUTTERMM_DISABLE_DEPRECATED


  //_WRAP_METHOD(void get_coords(float *x_1, float *y_1, float *x_2, float *y_2) const, clutter_actor_get_coords)
  
  /** Sets the actor's size request in pixels. This overrides any
   * "normal" size request the actor would have. For example
   * a text actor might normally request the size of the text;
   * this function would force a specific size instead.
   * 
   * If @a width and/or @a height are -1 the actor will use its
   * "normal" size request instead of overriding it, i.e.
   * you can "unset" the size with -1.
   * 
   * This function sets or unsets both the minimum and natural size.
   * @param width New width of actor in pixels, or -1.
   * @param height New height of actor in pixels, or -1.
   */
  void set_size(float width, float height);
  
  /** This function tries to "do what you mean" and tell you where the
   * actor is, prior to any transformations. Retrieves the fixed
   * position of an actor in pixels, if one has been set; otherwise, if
   * the allocation is valid, returns the actor's allocated position;
   * otherwise, returns 0,0.
   * 
   * The returned position is in pixels.
   * 
   * @newin{0,6}
   * @param x Return location for the X coordinate, or <tt>0</tt>.
   * @param y Return location for the Y coordinate, or <tt>0</tt>.
   */
  void get_position(float& x, float& y);
  
  /** Sets the actor's fixed position in pixels relative to any parent
   * actor.
   * 
   * If a layout manager is in use, this position will override the
   * layout manager and force a fixed position.
   * @param x New left position of actor in pixels.
   * @param y New top position of actor in pixels.
   */
  void set_position(float x, float y);
  //_WRAP_METHOD(void get_abs_position(float& x, float& y) const, clutter_actor_get_abs_position)
  
  /** Retrieves the width of a Clutter::Actor.
   * 
   * If the actor has a valid allocation, this function will return the
   * width of the allocated area given to the actor.
   * 
   * If the actor does not have a valid allocation, this function will
   * return the actor's natural width, that is the preferred width of
   * the actor.
   * 
   * If you care whether you get the preferred width or the width that
   * has been assigned to the actor, you should probably call a different
   * function like get_allocation_box() to retrieve the
   * allocated size or get_preferred_width() to retrieve the
   * preferred width.
   * 
   * If an actor has a fixed width, for instance a width that has been
   * assigned using set_width(), the width returned will
   * be the same value.
   * @return The width of the actor, in pixels.
   */
  float get_width() const;
  
  /** Retrieves the height of a Clutter::Actor.
   * 
   * If the actor has a valid allocation, this function will return the
   * height of the allocated area given to the actor.
   * 
   * If the actor does not have a valid allocation, this function will
   * return the actor's natural height, that is the preferred height of
   * the actor.
   * 
   * If you care whether you get the preferred height or the height that
   * has been assigned to the actor, you should probably call a different
   * function like get_allocation_box() to retrieve the
   * allocated size or get_preferred_height() to retrieve the
   * preferred height.
   * 
   * If an actor has a fixed height, for instance a height that has been
   * assigned using set_height(), the height returned will
   * be the same value.
   * @return The height of the actor, in pixels.
   */
  float get_height() const;
  
  /** Forces a width on an actor, causing the actor's preferred width
   * and height (if any) to be ignored.
   * 
   * If @a width is -1 the actor will use its preferred width request
   * instead of overriding it, i.e. you can "unset" the width with -1.
   * 
   * This function sets both the minimum and natural size of the actor.
   * 
   * since: 0.2
   * @param width Requested new width for the actor, in pixels, or -1.
   */
  void set_width(float width);
  
  /** Forces a height on an actor, causing the actor's preferred width
   * and height (if any) to be ignored.
   * 
   * If @a height is -1 the actor will use its preferred height instead of
   * overriding it, i.e. you can "unset" the height with -1.
   * 
   * This function sets both the minimum and natural size of the actor.
   * 
   * since: 0.2
   * @param height Requested new height for the actor, in pixels, or -1.
   */
  void set_height(float height);

  
  /** Sets the actor's X coordinate, relative to its parent, in pixels.
   * 
   * Overrides any layout manager and forces a fixed position for
   * the actor.
   * 
   * The Clutter::Actor::property_x() property is animatable.
   * 
   * @newin{0,6}
   * @param x The actor's position on the X axis.
   */
  void set_x(float x);
  
  /** Retrieves the X coordinate of a Clutter::Actor.
   * 
   * This function tries to "do what you mean", by returning the
   * correct value depending on the actor's state.
   * 
   * If the actor has a valid allocation, this function will return
   * the X coordinate of the origin of the allocation box.
   * 
   * If the actor has any fixed coordinate set using set_x(),
   * set_position() or set_geometry(), this
   * function will return that coordinate.
   * 
   * If both the allocation and a fixed position are missing, this function
   * will return 0.
   * @return The X coordinate, in pixels, ignoring any
   * transformation (i.e. scaling, rotation).
   */
  float get_x() const;
  
  /** Sets the actor's Y coordinate, relative to its parent, in pixels.#
   * 
   * Overrides any layout manager and forces a fixed position for
   * the actor.
   * 
   * The Clutter::Actor::property_y() property is animatable.
   * 
   * @newin{0,6}
   * @param y The actor's position on the Y axis.
   */
  void set_y(float y);
  
  /** Retrieves the Y coordinate of a Clutter::Actor.
   * 
   * This function tries to "do what you mean", by returning the
   * correct value depending on the actor's state.
   * 
   * If the actor has a valid allocation, this function will return
   * the Y coordinate of the origin of the allocation box.
   * 
   * If the actor has any fixed coordinate set using set_y(),
   * set_position() or set_geometry(), this
   * function will return that coordinate.
   * 
   * If both the allocation and a fixed position are missing, this function
   * will return 0.
   * @return The Y coordinate, in pixels, ignoring any
   * transformation (i.e. scaling, rotation).
   */
  float get_y() const;
  
  /** Sets the actor's position on the Z axis.
   * 
   * See Clutter::Actor::property_z_position().
   * 
   * @newin{1,12}
   * @param z_position The position on the Z axis.
   */
  void set_z_position(float z_position);
  
  /** Retrieves the actor's position on the Z axis.
   * 
   * @newin{1,12}
   * @return The position on the Z axis.
   */
  float get_z_position() const;

 
  /** Sets the horizontal alignment policy of a Clutter::Actor, in case the
   * actor received extra horizontal space.
   * 
   * See also the Clutter::Actor::property_x_align() property.
   * 
   * @newin{1,10}
   * @param x_align The horizontal alignment policy.
   */
  void set_x_align(ActorAlign x_align);
 
  /** Retrieves the horizontal alignment policy set using
   * set_x_align().
   * 
   * @newin{1,10}
   * @return The horizontal alignment policy.
   */
  ActorAlign get_x_align() const;
 
  /** Sets the vertical alignment policy of a Clutter::Actor, in case the
   * actor received extra vertical space.
   * 
   * See also the Clutter::Actor::property_y_align() property.
   * 
   * @newin{1,10}
   * @param y_align The vertical alignment policy.
   */
  void set_y_align(ActorAlign y_align);
 
  /** Retrieves the vertical alignment policy set using
   * set_y_align().
   * 
   * @newin{1,10}
   * @return The vertical alignment policy.
   */
  ActorAlign get_y_align() const;

  
  /** Retrieves the value set with set_x_expand().
   * 
   * See also: needs_expand()
   * 
   * @newin{1,12}
   * @return <tt>true</tt> if the actor has been set to expand.
   */
  bool get_x_expand() const;
  
  /** Sets whether a Clutter::Actor should expand horizontally; this means
   * that layout manager should allocate extra space for the actor, if
   * possible.
   * 
   * Setting an actor to expand will also make all its parent expand, so
   * that it's possible to build an actor tree and only set this flag on
   * its leaves and not on every single actor.
   * 
   * @newin{1,12}
   * @param expand Whether the actor should expand horizontally.
   */
  void set_x_expand(bool expand =  true);
  
  /** Retrieves the value set with set_y_expand().
   * 
   * See also: needs_expand()
   * 
   * @newin{1,12}
   * @return <tt>true</tt> if the actor has been set to expand.
   */
  bool get_y_expand() const;
  
  /** Sets whether a Clutter::Actor should expand horizontally; this means
   * that layout manager should allocate extra space for the actor, if
   * possible.
   * 
   * Setting an actor to expand will also make all its parent expand, so
   * that it's possible to build an actor tree and only set this flag on
   * its leaves and not on every single actor.
   * 
   * @newin{1,12}
   * @param expand Whether the actor should expand vertically.
   */
  void set_y_expand(bool expand =  true);
  
  /** Checks whether an actor, or any of its children, is set to expand
   * horizontally or vertically.
   * 
   * This function should only be called by layout managers that can
   * assign extra space to their children.
   * 
   * If you want to know whether the actor was explicitly set to expand,
   * use get_x_expand() or get_y_expand().
   * 
   * @newin{1,12}
   * @param orientation The direction of expansion.
   * @return <tt>true</tt> if the actor should expand.
   */
  bool needs_expand(Orientation orientation) const;

  
  /** Sets the Clutter::LayoutManager delegate object that will be used to
   * lay out the children of @a self.
   * 
   * The Clutter::Actor will take a reference on the passed @a manager which
   * will be released either when the layout manager is removed, or when
   * the actor is destroyed.
   * 
   * @newin{1,10}
   * @param manager A Clutter::LayoutManager, or <tt>0</tt> to unset it.
   */
  void set_layout_manager(const Glib::RefPtr<LayoutManager>& manager);

  /** Unset the layout manager.
   */
  void unset_layout_manager();

  
  /** Retrieves the Clutter::LayoutManager used by @a self.
   * 
   * @newin{1,10}
   * @return A pointer to the Clutter::LayoutManager,
   * or <tt>0</tt>.
   */
  Glib::RefPtr<LayoutManager> get_layout_manager();
  
  /** Retrieves the Clutter::LayoutManager used by @a self.
   * 
   * @newin{1,10}
   * @return A pointer to the Clutter::LayoutManager,
   * or <tt>0</tt>.
   */
  Glib::RefPtr<const LayoutManager> get_layout_manager() const;

  
  /** Sets @a actor as reactive. Reactive actors will receive events.
   * 
   * @newin{0,6}
   * @param reactive Whether the actor should be reactive to events.
   */
  void set_reactive(bool reactive =  true);
  
  /** Checks whether @a actor is marked as reactive.
   * 
   * @newin{0,6}
   * @return <tt>true</tt> if the actor is reactive.
   */
  bool get_reactive() const;
  
  /** Checks whether @a self is the Clutter::Actor that has key focus
   * 
   * @newin{1,4}
   * @return <tt>true</tt> if the actor has key focus, and <tt>false</tt> otherwise.
   */
  bool has_key_focus() const;


#ifndef CLUTTERMM_DISABLE_DEPRECATED

  /** Sets the rotation angle of @a self around the given axis.
   * 
   * The rotation center coordinates used depend on the value of @a axis:
   * - Clutter::X_AXIS requires @a y and @a z
   * - Clutter::Y_AXIS requires @a x and @a z
   * - Clutter::Z_AXIS requires @a x and @a y
   * 
   * The rotation coordinates are relative to the anchor point of the
   * actor, set using set_anchor_point(). If no anchor
   * point is set, the upper left corner is assumed as the origin.
   * 
   * @newin{0,8}
   * 
   * Deprecated: 1.12: Use set_rotation_angle() and
   * set_pivot_point() instead.
   * @deprecated Use set_rotation_angle() and set_pivot_point() instead.
   * @param axis The axis of rotation.
   * @param angle The angle of rotation.
   * @param x X coordinate of the rotation center.
   * @param y Y coordinate of the rotation center.
   * @param z Z coordinate of the rotation center.
   */
  void set_rotation(RotateAxis axis, double angle, float x, float y, float z);
#endif // CLUTTERMM_DISABLE_DEPRECATED


#ifndef CLUTTERMM_DISABLE_DEPRECATED

  /** Sets the rotation angle of @a self around the Z axis using the center
   * point specified as a compass point. For example to rotate such that
   * the center of the actor remains static you can use
   * Clutter::GRAVITY_CENTER. If the actor changes size the center point
   * will move accordingly.
   * 
   * @newin{1,0}
   * 
   * Deprecated: 1.12: Use set_rotation_angle() and
   * set_pivot_point() instead.
   * @deprecated Use set_rotation_angle() and set_pivot_point() instead.
   * @param angle The angle of rotation.
   * @param gravity The center point of the rotation.
   */
  void set_z_rotation_from_gravity(double angle, Gravity gravity);
#endif // CLUTTERMM_DISABLE_DEPRECATED


#ifndef CLUTTERMM_DISABLE_DEPRECATED

  /** Retrieves the angle and center of rotation on the given axis,
   * set using set_rotation().
   * 
   * @newin{0,8}
   * 
   * Deprecated: 1.12: Use get_rotation_angle() and
   * get_pivot_point() instead.
   * @deprecated Use get_rotation_angle() and get_pivot_point() instead.
   * @param axis The axis of rotation.
   * @param x Return value for the X coordinate of the center of rotation.
   * @param y Return value for the Y coordinate of the center of rotation.
   * @param z Return value for the Z coordinate of the center of rotation.
   * @return The angle of rotation.
   */
  double get_rotation(RotateAxis axis, float& x, float& y, float& z) const;
#endif // CLUTTERMM_DISABLE_DEPRECATED


#ifndef CLUTTERMM_DISABLE_DEPRECATED

  /** Retrieves the center for the rotation around the Z axis as a
   * compass direction. If the center was specified in pixels or units
   * this will return Clutter::GRAVITY_NONE.
   * 
   * @newin{1,0}
   * 
   * Deprecated: 1.12: Use the Clutter::Actor::property_pivot_point() instead of
   * a Clutter::Gravity
   * @deprecated Use the “pivot-point” instead of a Gravity.
   * @return The Z rotation center.
   */
  Gravity get_z_rotation_gravity() const;
#endif // CLUTTERMM_DISABLE_DEPRECATED


  /** Sets the actor's opacity, with zero being completely transparent and
   * 255 (0xff) being fully opaque.
   * 
   * The Clutter::Actor::property_opacity() property is animatable.
   * @param opacity New opacity value for the actor.
   */
  void set_opacity(guint8 opacity);
  
  /** Retrieves the opacity value of an actor, as set by
   * set_opacity().
   * 
   * For retrieving the absolute opacity of the actor inside a paint
   * virtual function, see get_paint_opacity().
   * @return The opacity of the actor.
   */
  guint8 get_opacity() const;

  
  /** Defines the circumstances where the actor should be redirected into
   * an offscreen image. The offscreen image is used to flatten the
   * actor into a single image while painting for two main reasons.
   * Firstly, when the actor is painted a second time without any of its
   * contents changing it can simply repaint the cached image without
   * descending further down the actor hierarchy. Secondly, it will make
   * the opacity look correct even if there are overlapping primitives
   * in the actor.
   * 
   * Caching the actor could in some cases be a performance win and in
   * some cases be a performance lose so it is important to determine
   * which value is right for an actor before modifying this value. For
   * example, there is never any reason to flatten an actor that is just
   * a single texture (such as a Clutter::Texture) because it is
   * effectively already cached in an image so the offscreen would be
   * redundant. Also if the actor contains primitives that are far apart
   * with a large transparent area in the middle (such as a large
   * CluterGroup with a small actor in the top left and a small actor in
   * the bottom right) then the cached image will contain the entire
   * image of the large area and the paint will waste time blending all
   * of the transparent pixels in the middle.
   * 
   * The default method of implementing opacity on a container simply
   * forwards on the opacity to all of the children. If the children are
   * overlapping then it will appear as if they are two separate glassy
   * objects and there will be a break in the color where they
   * overlap. By redirecting to an offscreen buffer it will be as if the
   * two opaque objects are combined into one and then made transparent
   * which is usually what is expected.
   * 
   * The image below demonstrates the difference between redirecting and
   * not. The image shows two Clutter groups, each containing a red and
   * a green rectangle which overlap. The opacity on the group is set to
   * 128 (which is 50%). When the offscreen redirect is not used, the
   * red rectangle can be seen through the blue rectangle as if the two
   * rectangles were separately transparent. When the redirect is used
   * the group as a whole is transparent instead so the red rectangle is
   * not visible where they overlap.
   * 
   * <figure id="offscreen-redirect">
   * <title>Sample of using an offscreen redirect for transparency</title>
   * <graphic fileref="offscreen-redirect.png" format="PNG"/>
   * </figure>
   * 
   * The default value for this property is 0, so we effectively will
   * never redirect an actor offscreen by default. This means that there
   * are times that transparent actors may look glassy as described
   * above. The reason this is the default is because there is a
   * performance trade off between quality and performance here. In many
   * cases the default form of glassy opacity looks good enough, but if
   * it's not you will need to set the
   * Clutter::OFFSCREEN_REDIRECT_AUTOMATIC_FOR_OPACITY flag to enable
   * redirection for opacity.
   * 
   * Custom actors that don't contain any overlapping primitives are
   * recommended to override the has_overlaps() virtual to return <tt>false</tt>
   * for maximum efficiency.
   * 
   * @newin{1,8}
   * @param redirect New offscreen redirect flags for the actor.
   */
  void set_offscreen_redirect(OffscreenRedirect redirect) const;
  
  /** Retrieves whether to redirect the actor to an offscreen buffer, as
   * set by set_offscreen_redirect().
   * 
   * @newin{1,8}
   * @return The value of the offscreen-redirect property of the actor.
   */
  OffscreenRedirect get_offscreen_redirect();

  
  /** Sets the background color of a Clutter::Actor.
   * 
   * The background color will be used to cover the whole allocation of the
   * actor. The default background color of an actor is transparent.
   * 
   * To check whether an actor has a background color, you can use the
   * Clutter::Actor::property_background_color_set() actor property.
   * 
   * The Clutter::Actor::property_background_color() property is animatable.
   * 
   * @newin{1,10}
   * @param color A Clutter::Color, or <tt>0</tt> to unset a previously
   * set color.
   */
  void set_background_color(const Color& color);

  /** Retrieves the color set using set_background_color().
   */
  Color get_background_color() const;
  

  /** Retrieves the paint volume of the passed Clutter::Actor, or <tt>0</tt>
   * when a paint volume can't be determined.
   * 
   * The paint volume is defined as the 3D space occupied by an actor
   * when being painted.
   * 
   * This function will call the <tt>get_paint_volume()</tt>
   * virtual function of the Clutter::Actor class. Sub-classes of Clutter::Actor
   * should not usually care about overriding the default implementation,
   * unless they are, for instance: painting outside their allocation, or
   * actors with a depth factor (not in terms of Clutter::Actor::property_depth() but real
   * 3D depth).
   * 
   * <note>2D actors overriding <tt>get_paint_volume()</tt>
   * ensure their volume has a depth of 0. (This will be true so long as
   * you don't call clutter_paint_volume_set_depth().)</note>
   * 
   * @newin{1,6}
   * @return A pointer to a Clutter::PaintVolume,
   * or <tt>0</tt> if no volume could be determined. The returned pointer
   * is not guaranteed to be valid across multiple frames; if you want
   * to keep it, you will need to copy it using clutter_paint_volume_copy().
   */
  const PaintVolume* get_paint_volume() const;
  
  /** Retrieves the 3D paint volume of an actor like
   * get_paint_volume() does (Please refer to the
   * documentation of get_paint_volume() for more
   * details.) and it additionally transforms the paint volume into the
   * coordinate space of @a relative_to_ancestor. (Or the stage if <tt>0</tt>
   * is passed for @a relative_to_ancestor)
   * 
   * This can be used by containers that base their paint volume on
   * the volume of their children. Such containers can query the
   * transformed paint volume of all of its children and union them
   * together using clutter_paint_volume_union().
   * 
   * @newin{1,6}
   * @param relative_to_ancestor A Clutter::Actor that is an ancestor of @a self
   * (or <tt>0</tt> for the stage).
   * @return A pointer to a Clutter::PaintVolume,
   * or <tt>0</tt> if no volume could be determined. The returned pointer is
   * not guaranteed to be valid across multiple frames; if you wish to
   * keep it, you will have to copy it using clutter_paint_volume_copy().
   */
  const PaintVolume* get_transformed_paint_volume(const Glib::RefPtr<Actor>& relative_to_ancestor) const;

  /// A get_transformed_paint_volume() convenience overload.
  const PaintVolume* get_transformed_paint_volume() const;
  
  /** Retrieves the default paint volume for @a self.
   * 
   * This function provides the same Clutter::PaintVolume that would be
   * computed by the default implementation inside Clutter::Actor of the
   * Clutter::ActorClass.get_paint_volume() virtual function.
   * 
   * This function should only be used by Clutter::Actor subclasses that
   * cannot chain up to the parent implementation when computing their
   * paint volume.
   * 
   * @newin{1,10}
   * @return A pointer to the default
   * Clutter::PaintVolume, relative to the Clutter::Actor, or <tt>0</tt> if
   * the actor could not compute a valid paint volume. The returned value
   * is not guaranteed to be stable across multiple frames, so if you
   * want to retain it, you will need to copy it using
   * clutter_paint_volume_copy().
   */
  const PaintVolume* get_default_paint_volume() const;


  /** Sets the given name to @a self. The name can be used to identify
   * a Clutter::Actor.
   * @param name Textual tag to apply to actor.
   */
  void set_name(const gchar * name);
  
  /** Retrieves the name of @a self.
   * @return The name of the actor, or <tt>0</tt>. The returned string is
   * owned by the actor and should not be modified or freed.
   */
  Glib::ustring get_name() const;
  
  /** Retrieves the unique id for @a self.
   * 
   * @newin{0,6}
   * 
   * Deprecated: 1.8: The id is not used any longer.
   * @return Globally unique value for this object instance.
   */
  guint32 get_gid() const;
  
  /** Sets clip area for @a self. The clip area is always computed from the
   * upper left corner of the actor, even if the anchor point is set
   * otherwise.
   * 
   * @newin{0,6}
   * @param xoff X offset of the clip rectangle.
   * @param yoff Y offset of the clip rectangle.
   * @param width Width of the clip rectangle.
   * @param height Height of the clip rectangle.
   */
  void set_clip(float xoff, float yoff, float width, float height);
  
  /** Gets the clip area for @a self, if any is set.
   * 
   * @newin{0,6}
   * @param xoff Return location for the X offset of
   * the clip rectangle, or <tt>0</tt>.
   * @param yoff Return location for the Y offset of
   * the clip rectangle, or <tt>0</tt>.
   * @param width Return location for the width of
   * the clip rectangle, or <tt>0</tt>.
   * @param height Return location for the height of
   * the clip rectangle, or <tt>0</tt>.
   */
  void get_clip(float& xoff, float& yoff, float& width, float& height);
  
  /** Sets whether @a self should be clipped to the same size as its
   * allocation
   * 
   * @newin{1,4}
   * @param clip_set <tt>true</tt> to apply a clip tracking the allocation.
   */
  void set_clip_to_allocation(bool clip_set =  true);
  
  /** Retrieves the value set using set_clip_to_allocation()
   * 
   * @newin{1,4}
   * @return <tt>true</tt> if the Clutter::Actor is clipped to its allocation.
   */
  bool get_clip_to_allocation() const;
  
  /** Removes clip area from @a self.
   */
  void remove_clip();
  
  /** Determines whether the actor has a clip area set or not.
   * 
   * @newin{0,1,1}
   * @return <tt>true</tt> if the actor has a clip area set.
   */
  bool has_clip() const;

   
  /** Retrieves the list of children of @a self.
   * 
   * @newin{1,10}
   * @return A newly
   * allocated List of Clutter::Actor<!-- -->s. Use Glib::list_free() when
   * done.
   */
  std::vector< Glib::RefPtr<Effect> > get_children();

   
  /** Retrieves the list of children of @a self.
   * 
   * @newin{1,10}
   * @return A newly
   * allocated List of Clutter::Actor<!-- -->s. Use Glib::list_free() when
   * done.
   */
  std::vector< Glib::RefPtr<const Effect> > get_children() const;

  
  /** Retrieves the number of children of @a self.
   * 
   * @newin{1,10}
   * @return The number of children of an actor.
   */
  int get_n_children() const;

  
  /** Retrieves the actor at the given @a index inside the list of
   * children of @a self.
   * 
   * @newin{1,10}
   * @param index The position in the list of children.
   * @return A pointer to a Clutter::Actor, or <tt>0</tt>.
   */
  Glib::RefPtr<Actor> get_child_at_index(int index);
  
  /** Retrieves the actor at the given @a index inside the list of
   * children of @a self.
   * 
   * @newin{1,10}
   * @param index The position in the list of children.
   * @return A pointer to a Clutter::Actor, or <tt>0</tt>.
   */
  Glib::RefPtr<const Actor> get_child_at_index(int index) const;

  
  /** Retrieves the sibling of @a self that comes before it in the list
   * of children of @a self's parent.
   * 
   * The returned pointer is only valid until the scene graph changes; it
   * is not safe to modify the list of children of @a self while iterating
   * it.
   * 
   * @newin{1,10}
   * @return A pointer to a Clutter::Actor, or <tt>0</tt>.
   */
  Glib::RefPtr<Actor> get_previous_sibling();
  
  /** Retrieves the sibling of @a self that comes before it in the list
   * of children of @a self's parent.
   * 
   * The returned pointer is only valid until the scene graph changes; it
   * is not safe to modify the list of children of @a self while iterating
   * it.
   * 
   * @newin{1,10}
   * @return A pointer to a Clutter::Actor, or <tt>0</tt>.
   */
  Glib::RefPtr<const Actor> get_previous_sibling() const;

  
  /** Retrieves the sibling of @a self that comes after it in the list
   * of children of @a self's parent.
   * 
   * The returned pointer is only valid until the scene graph changes; it
   * is not safe to modify the list of children of @a self while iterating
   * it.
   * 
   * @newin{1,10}
   * @return A pointer to a Clutter::Actor, or <tt>0</tt>.
   */
  Glib::RefPtr<Actor> get_next_sibling();
  
  /** Retrieves the sibling of @a self that comes after it in the list
   * of children of @a self's parent.
   * 
   * The returned pointer is only valid until the scene graph changes; it
   * is not safe to modify the list of children of @a self while iterating
   * it.
   * 
   * @newin{1,10}
   * @return A pointer to a Clutter::Actor, or <tt>0</tt>.
   */
  Glib::RefPtr<const Actor> get_next_sibling() const;

  
  /** Retrieves the first child of @a self.
   * 
   * The returned pointer is only valid until the scene graph changes; it
   * is not safe to modify the list of children of @a self while iterating
   * it.
   * 
   * @newin{1,10}
   * @return A pointer to a Clutter::Actor, or <tt>0</tt>.
   */
  Glib::RefPtr<Actor> get_first_child();
  
  /** Retrieves the first child of @a self.
   * 
   * The returned pointer is only valid until the scene graph changes; it
   * is not safe to modify the list of children of @a self while iterating
   * it.
   * 
   * @newin{1,10}
   * @return A pointer to a Clutter::Actor, or <tt>0</tt>.
   */
  Glib::RefPtr<const Actor> get_first_child() const;

  
  /** Retrieves the last child of @a self.
   * 
   * The returned pointer is only valid until the scene graph changes; it
   * is not safe to modify the list of children of @a self while iterating
   * it.
   * 
   * @newin{1,10}
   * @return A pointer to a Clutter::Actor, or <tt>0</tt>.
   */
  Glib::RefPtr<Actor> get_last_child();
  
  /** Retrieves the last child of @a self.
   * 
   * The returned pointer is only valid until the scene graph changes; it
   * is not safe to modify the list of children of @a self while iterating
   * it.
   * 
   * @newin{1,10}
   * @return A pointer to a Clutter::Actor, or <tt>0</tt>.
   */
  Glib::RefPtr<const Actor> get_last_child() const;

  
#ifndef CLUTTERMM_DISABLE_DEPRECATED

  /** Sets the parent of @a self to @a parent.
   * 
   * This function will result in @a parent acquiring a reference on @a self,
   * eventually by sinking its floating reference first. The reference
   * will be released by unparent().
   * 
   * This function should only be called by legacy Clutter::Actor<!-- -->s
   * implementing the Clutter::Container interface.
   * 
   * Deprecated: 1.10: Use add_child() instead.
   * @deprecated Use clutter_actor_add_child() instead.
   * @param parent A new Clutter::Actor parent.
   */
  void set_parent(const Glib::RefPtr<Actor>& parent);
#endif // CLUTTERMM_DISABLE_DEPRECATED


  /** Retrieves the parent of @a self.
   * @return The Clutter::Actor parent, or <tt>0</tt>
   * if no parent is set.
   */
  Glib::RefPtr<Actor> get_parent();
  
  /** Retrieves the parent of @a self.
   * @return The Clutter::Actor parent, or <tt>0</tt>
   * if no parent is set.
   */
  Glib::RefPtr<const Actor> get_parent() const;
  
#ifndef CLUTTERMM_DISABLE_DEPRECATED

  /** Resets the parent actor of @a self.
   * 
   * This function is logically equivalent to calling unparent()
   * and set_parent(), but more efficiently implemented, as it
   * ensures the child is not finalized when unparented, and emits the
   * Clutter::Actor::signal_parent_set() signal only once.
   * 
   * In reality, calling this function is less useful than it sounds, as some
   * application code may rely on changes in the intermediate state between
   * removal and addition of the actor from its old parent to the @a new_parent.
   * Thus, it is strongly encouraged to avoid using this function in application
   * code.
   * 
   * @newin{0,2}
   * 
   * Deprecated: 1.10: Use remove_child() and
   * add_child() instead; remember to take a reference on
   * the actor being removed before calling remove_child()
   * to avoid the reference count dropping to zero and the actor being
   * destroyed.
   * @deprecated Use remove_child() and add_child() instead.
   * @param new_parent The new Clutter::Actor parent.
   */
  void reparent(const Glib::RefPtr<Actor>& new_parent);
#endif // CLUTTERMM_DISABLE_DEPRECATED


#ifndef CLUTTERMM_DISABLE_DEPRECATED

  /** Removes the parent of @a self.
   * 
   * This will cause the parent of @a self to release the reference
   * acquired when calling set_parent(), so if you
   * want to keep @a self you will have to acquire a reference of
   * your own, through Glib::object_ref().
   * 
   * This function should only be called by legacy Clutter::Actor<!-- -->s
   * implementing the Clutter::Container interface.
   * 
   * @newin{0,1,1}
   * 
   * Deprecated: 1.10: Use remove_child() instead.
   * @deprecated Use clutter_actor_remove_child() instead.
   */
  void unparent();
#endif // CLUTTERMM_DISABLE_DEPRECATED


  /** Determines if @a descendant is contained inside @a self (either as an
   * immediate child, or as a deeper descendant). If @a self and
   *  @a descendant point to the same actor then it will also return <tt>true</tt>.
   * 
   * @newin{1,4}
   * @param descendant A Clutter::Actor, possibly contained in @a self.
   * @return Whether @a descendent is contained within @a self.
   */
  bool contains(const Glib::RefPtr<const Actor>& descendant) const;
  
#ifndef CLUTTERMM_DISABLE_DEPRECATED

  /** Puts @a self above @a below.
   * 
   * Both actors must have the same parent, and the parent must implement
   * the Clutter::Container interface
   * 
   * This function calls Clutter::Container::raise_child() internally.
   * 
   * Deprecated: 1.10: Use set_child_above_sibling() instead.
   * @deprecated Use set_child_above_sibling() instead.
   * @param below A Clutter::Actor to raise above.
   */
  void raise(const Glib::RefPtr<Actor>& below);
#endif // CLUTTERMM_DISABLE_DEPRECATED


#ifndef CLUTTERMM_DISABLE_DEPRECATED

  /** Puts @a self below @a above.
   * 
   * Both actors must have the same parent, and the parent must implement
   * the Clutter::Container interface.
   * 
   * This function calls Clutter::Container::lower_child() internally.
   * 
   * Deprecated: 1.10: Use set_child_below_sibling() instead.
   * @deprecated Use set_child_below_sibling() instead
   * @param above A Clutter::Actor to lower below.
   */
  void lower(const Glib::RefPtr<Actor>& above);
#endif // CLUTTERMM_DISABLE_DEPRECATED


  /** Raises @a self to the top.
   * 
   * This function calls raise() internally.
   * 
   * Deprecated: 1.10: Use set_child_above_sibling() with
   * a <tt>0</tt> sibling, instead.
   */
  void raise_top();
  
  /** Lowers @a self to the bottom.
   * 
   * This function calls lower() internally.
   * 
   * Deprecated: 1.10: Use set_child_below_sibling() with
   * a <tt>0</tt> sibling, instead.
   */
  void lower_bottom();

  
#ifndef CLUTTERMM_DISABLE_DEPRECATED

  /** Queries the currently set Clutter::Shader on @a self.
   * 
   * @newin{0,6}
   * 
   * Deprecated: 1.8: Use get_effect() instead.
   * @deprecated Use get_effect() instead.
   * @return The currently set Clutter::Shader
   * or <tt>0</tt> if no shader is set.
   */
  Glib::RefPtr<Shader> get_shader();
#endif // CLUTTERMM_DISABLE_DEPRECATED


#ifndef CLUTTERMM_DISABLE_DEPRECATED

  /** Queries the currently set Clutter::Shader on @a self.
   * 
   * @newin{0,6}
   * 
   * Deprecated: 1.8: Use get_effect() instead.
   * @deprecated Use get_effect() instead.
   * @return The currently set Clutter::Shader
   * or <tt>0</tt> if no shader is set.
   */
  Glib::RefPtr<const Shader> get_shader() const;
#endif // CLUTTERMM_DISABLE_DEPRECATED


#ifndef CLUTTERMM_DISABLE_DEPRECATED

  /** Sets the Clutter::Shader to be used when rendering @a self.
   * 
   * If @a shader is <tt>0</tt> this function will unset any currently set shader
   * for the actor.
   * 
   * <note>Any Clutter::Effect applied to @a self will take the precedence
   * over the Clutter::Shader set using this function.</note>
   * 
   * @newin{0,6}
   * 
   * Deprecated: 1.8: Use Clutter::ShaderEffect and
   * add_effect() instead.
   * @deprecated Use add_effect() instead.
   * @param shader A Clutter::Shader or <tt>0</tt> to unset the shader.
   * @return <tt>true</tt> if the shader was successfully applied
   * or removed.
   */
  void set_shader(const Glib::RefPtr<Shader>& shader);
#endif // CLUTTERMM_DISABLE_DEPRECATED


#ifndef CLUTTERMM_DISABLE_DEPRECATED

  
  /** Sets the value for a named parameter of the shader applied
   * to @a actor.
   * 
   * @newin{1,0}
   * 
   * Deprecated: 1.8: Use Clutter::ShaderEffect::set_uniform_value() instead
   * @param param The name of the parameter.
   * @param value The value of the parameter.
   */

  /**
   * @deprecated Use ShaderEffect::set_uniform_value() instead."
   */
  template <class ParamType> void set_shader_param(const Glib::ustring& param, const ParamType& value);
#endif // CLUTTERMM_DISABLE_DEPRECATED

  
  //_WRAP_METHOD_DOCS_ONLY(clutter_actor_get_paint_area)
  //ActorBox get_paint_area() const;
  
  /** Checks whether any rotation is applied to the actor.
   * 
   * @newin{0,6}
   * @return <tt>true</tt> if the actor is rotated.
   */
  bool is_rotated() const;
  
  /** Checks whether the actor is scaled in either dimension.
   * 
   * @newin{0,6}
   * @return <tt>true</tt> if the actor is scaled.
   */
  bool is_scaled() const;

  
  /** Sets the position of the Clutter::Actor::property_pivot_point() around which the
   * scaling and rotation transformations occur.
   * 
   * The pivot point's coordinates are in normalized space, with the (0, 0)
   * point being the top left corner of the actor, and the (1, 1) point being
   * the bottom right corner.
   * 
   * @newin{1,12}
   * @param pivot_x The normalized X coordinate of the pivot point.
   * @param pivot_y The normalized Y coordinate of the pivot point.
   */
  void set_pivot_point(float x, float y);
  
  /** Retrieves the coordinates of the Clutter::Actor::property_pivot_point().
   * 
   * @newin{1,12}
   * @param pivot_x Return location for the normalized X
   * coordinate of the pivot point, or <tt>0</tt>.
   * @param pivot_y Return location for the normalized Y
   * coordinate of the pivot point, or <tt>0</tt>.
   */
  void get_pivot_point(float& pivot_x, float& pivot_y) const;
  
  /** Sets the component on the Z axis of the Clutter::Actor::property_pivot_point() around
   * which the scaling and rotation transformations occur.
   * 
   * The @a pivot_z value is expressed as a distance along the Z axis.
   * 
   * @newin{1,12}
   * @param pivot_z The Z coordinate of the actor's pivot point.
   */
  void set_pivot_point_z(float pivot_z);
  
  /** Retrieves the Z component of the Clutter::Actor::property_pivot_point().
   * 
   * @newin{1,12}
   */
  float get_pivot_point_z() const;
  
  /** Sets the @a angle of rotation of a Clutter::Actor on the given @a axis.
   * 
   * This function is a convenience for setting the rotation properties
   * Clutter::Actor::property_rotation_angle_x(), Clutter::Actor::property_rotation_angle_y(),
   * and Clutter::Actor::property_rotation_angle_z().
   * 
   * The center of rotation is established by the Clutter::Actor::property_pivot_point()
   * property.
   * 
   * @newin{1,12}
   * @param axis The axis to set the angle one.
   * @param angle The angle of rotation, in degrees.
   */
  void set_rotation_angle(RotateAxis axis, double angle);
  
  /** Retrieves the angle of rotation set by set_rotation_angle().
   * 
   * @newin{1,12}
   * @param axis The axis of the rotation.
   * @return The angle of rotation, in degrees.
   */
  double get_rotation_angle(RotateAxis axis) const;

  
  /** Sets an additional translation transformation on a Clutter::Actor,
   * relative to the Clutter::Actor::property_pivot_point().
   * 
   * @newin{1,12}
   * @param translate_x The translation along the X axis.
   * @param translate_y The translation along the Y axis.
   * @param translate_z The translation along the Z axis.
   */
  void set_translation(float translate_x, float translate_y, float translate_z);
  
  /** Retrieves the translation set using set_translation().
   * 
   * @newin{1,12}
   * @param translate_x Return location for the X component
   * of the translation, or <tt>0</tt>.
   * @param translate_y Return location for the Y component
   * of the translation, or <tt>0</tt>.
   * @param translate_z Return location for the Z component
   * of the translation, or <tt>0</tt>.
   */
  void get_translation(float& translate_x, float& translate_y, float& translate_z) const;

  
  /** Should be called inside the implementation of the
   * Clutter::Actor::signal_pick() virtual function in order to check whether
   * the actor should paint itself in pick mode or not.
   * 
   * This function should never be called directly by applications.
   * @return <tt>true</tt> if the actor should paint its silhouette,
   * <tt>false</tt> otherwise.
   */
  bool should_pick_paint() const;

  
  /** Calculates the transformed coordinates of the four corners of the
   * actor in the plane of @a ancestor. The returned vertices relate to
   * the Clutter::ActorBox coordinates as follows:
   * -  @a verts[0] contains (x1, y1)
   * -  @a verts[1] contains (x2, y1)
   * -  @a verts[2] contains (x1, y2)
   * -  @a verts[3] contains (x2, y2)
   * 
   * If @a ancestor is <tt>0</tt> the ancestor will be the Clutter::Stage. In
   * this case, the coordinates returned will be the coordinates on
   * the stage before the projection is applied. This is different from
   * the behaviour of get_abs_allocation_vertices().
   * 
   * @newin{0,6}
   * @param ancestor A Clutter::Actor to calculate the vertices
   * against, or <tt>0</tt> to use the Clutter::Stage.
   * @param verts Return
   * location for an array of 4 Clutter::Vertex in which to store the result.
   */

  void get_allocation_vertices(Vertex vertices[4]) const;

  
  /** Calculates the transformed coordinates of the four corners of the
   * actor in the plane of @a ancestor. The returned vertices relate to
   * the Clutter::ActorBox coordinates as follows:
   * -  @a verts[0] contains (x1, y1)
   * -  @a verts[1] contains (x2, y1)
   * -  @a verts[2] contains (x1, y2)
   * -  @a verts[3] contains (x2, y2)
   * 
   * If @a ancestor is <tt>0</tt> the ancestor will be the Clutter::Stage. In
   * this case, the coordinates returned will be the coordinates on
   * the stage before the projection is applied. This is different from
   * the behaviour of get_abs_allocation_vertices().
   * 
   * @newin{0,6}
   * @param ancestor A Clutter::Actor to calculate the vertices
   * against, or <tt>0</tt> to use the Clutter::Stage.
   * @param verts Return
   * location for an array of 4 Clutter::Vertex in which to store the result.
   */

  void get_allocation_vertices(const Glib::RefPtr<Actor>& ancestor, Vertex vertices[4]) const;

  
  /** Calculates the transformed screen coordinates of the four corners of
   * the actor; the returned vertices relate to the Clutter::ActorBox
   * coordinates  as follows:
   * - v[0] contains (x1, y1)
   * - v[1] contains (x2, y1)
   * - v[2] contains (x1, y2)
   * - v[3] contains (x2, y2)
   * 
   * @newin{0,4}
   * @param verts Pointer to a location of an array
   * of 4 Clutter::Vertex where to store the result.
   */

  void get_abs_allocation_vertices(Vertex vertices[4]) const;

  
  /** Allocates @a self by taking into consideration the available allocation
   * area; an alignment factor on either axis; and whether the actor should
   * fill the allocation on either axis.
   * 
   * The @a box should contain the available allocation width and height;
   * if the x1 and y1 members of Clutter::ActorBox are not set to 0, the
   * allocation will be offset by their value.
   * 
   * This function takes into consideration the geometry request specified by
   * the Clutter::Actor::property_request_mode() property, and the text direction.
   * 
   * This function is useful for fluid layout managers using legacy alignment
   * flags. Newly written layout managers should use the Clutter::Actor::property_x_align()
   * and Clutter::Actor::property_y_align() properties, instead, and just call
   * allocate() inside their Clutter::ActorClass.allocate()
   * implementation.
   * 
   * @newin{1,4}
   * @param box A Clutter::ActorBox, containing the available width and height.
   * @param x_align The horizontal alignment, between 0 and 1.
   * @param y_align The vertical alignment, between 0 and 1.
   * @param x_fill Whether the actor should fill horizontally.
   * @param y_fill Whether the actor should fill vertically.
   * @param flags Allocation flags to be passed to allocate().
   */
  void allocate_align_fill(const ActorBox& box, gdouble x_align, double y_align, bool x_fill, bool y_fill, AllocationFlags flags);

  
  /** Stores the allocation of @a self as defined by @a box.
   * 
   * This function can only be called from within the implementation of
   * the Clutter::ActorClass.allocate() virtual function.
   * 
   * The allocation should have been adjusted to take into account constraints,
   * alignment, and margin properties. If you are implementing a Clutter::Actor
   * subclass that provides its own layout management policy for its children
   * instead of using a Clutter::LayoutManager delegate, you should not call
   * this function on the children of @a self; instead, you should call
   * allocate(), which will adjust the allocation box for
   * you.
   * 
   * This function should only be used by subclasses of Clutter::Actor
   * that wish to store their allocation but cannot chain up to the
   * parent's implementation; the default implementation of the
   * Clutter::ActorClass.allocate() virtual function will call this
   * function.
   * 
   * It is important to note that, while chaining up was the recommended
   * behaviour for Clutter::Actor subclasses prior to the introduction of
   * this function, it is recommended to call set_allocation()
   * instead.
   * 
   * If the Clutter::Actor is using a Clutter::LayoutManager delegate object
   * to handle the allocation of its children, this function will call
   * the Clutter::LayoutManager::allocate() function only if the
   * Clutter::DELEGATE_LAYOUT flag is set on @a flags, otherwise it is
   * expected that the subclass will call Clutter::LayoutManager::allocate()
   * by itself. For instance, the following code:
   * 
   * 
   * [C example ellipted]
   * 
   * is equivalent to this:
   * 
   * 
   * [C example ellipted]
   * 
   * @newin{1,10}
   * @param box A Clutter::ActorBox.
   * @param flags Allocation flags.
   */
  void set_allocation(const ActorBox& box, AllocationFlags flags);

  
  /** Gets the layout box an actor has been assigned. The allocation can
   * only be assumed valid inside a paint() method; anywhere else, it
   * may be out-of-date.
   * 
   * An allocation does not incorporate the actor's scale or anchor point;
   * those transformations do not affect layout, only rendering.
   * 
   * <note>Do not call any of the clutter_actor_get_allocation_*() family
   * of functions inside the implementation of the get_preferred_width()
   * or get_preferred_height() virtual functions.</note>
   * 
   * @newin{0,8}
   * @param box The function fills this in with the actor's allocation.
   */

  ActorBox get_allocation_box() const;

  
  /** Assigns the size of a Clutter::Actor from the given @a box.
   * 
   * This function should only be called on the children of an actor when
   * overriding the Clutter::ActorClass.allocate() virtual function.
   * 
   * This function will adjust the stored allocation to take into account
   * the alignment flags set in the Clutter::Actor::property_x_align() and
   * Clutter::Actor::property_y_align() properties, as well as the margin values set in
   * the Clutter::Actor::property_margin_top(), Clutter::Actor::property_margin_right(),
   * Clutter::Actor::property_margin_bottom(), and Clutter::Actor::property_margin_left() properties.
   * 
   * This function will respect the easing state of the Clutter::Actor and
   * interpolate between the current allocation and the new one if the
   * easing state duration is a positive value.
   * 
   * Actors can know from their allocation box whether they have moved
   * with respect to their parent actor. The @a flags parameter describes
   * additional information about the allocation, for instance whether
   * the parent has moved with respect to the stage, for example because
   * a grandparent's origin has moved.
   * 
   * @newin{0,8}
   * @param box New allocation of the actor, in parent-relative coordinates.
   * @param flags Flags that control the allocation.
   */
  void allocate(const ActorBox& box, AllocationFlags absolute_origin_changed =  ALLOCATION_NONE);

  //TODO: Make this protected?
  
  /** Allocates the natural size of @a self.
   * 
   * This function is a utility call for Clutter::Actor implementations
   * that allocates the actor's preferred natural size. It can be used
   * by fixed layout managers (like Clutter::Group or so called
   * 'composite actors') inside the ClutterActor::allocate
   * implementation to give each child exactly how much space it
   * requires, regardless of the size of the parent.
   * 
   * This function is not meant to be used by applications. It is also
   * not meant to be used outside the implementation of the
   * Clutter::ActorClass.allocate virtual function.
   * 
   * @newin{0,8}
   * @param flags Flags controlling the allocation.
   */
  void allocate_preferred_size(AllocationFlags absolute_origin_changed =  ALLOCATION_NONE);

  
  /** Allocates @a self taking into account the Clutter::Actor<!-- -->'s
   * preferred size, but limiting it to the maximum available width
   * and height provided.
   * 
   * This function will do the right thing when dealing with the
   * actor's request mode.
   * 
   * The implementation of this function is equivalent to:
   * 
   * 
   * [C example ellipted]
   * 
   * This function can be used by fluid layout managers to allocate
   * an actor's preferred size without making it bigger than the area
   * available for the container.
   * 
   * @newin{1,0}
   * @param x The actor's X coordinate.
   * @param y The actor's Y coordinate.
   * @param available_width The maximum available width, or -1 to use the
   * actor's natural width.
   * @param available_height The maximum available height, or -1 to use the
   * actor's natural height.
   * @param flags Flags controlling the allocation.
   */
  void allocate_available_size(float x, float y, float available_width, float available_height, AllocationFlags flags =  ALLOCATION_NONE);

  
  /** Transforms @a point in coordinates relative to the actor
   * into screen-relative coordinates with the current actor
   * transformation (i.e.\ scale, rotation, etc)
   * 
   * @newin{0,4}
   * @param point A point as Clutter::Vertex.
   * @param vertex The translated Clutter::Vertex.
   */
  void apply_transform_to_point(const Vertex& point, Vertex& vertex) const;
  
  /** This function translates screen coordinates ( @a x, @a y) to
   * coordinates relative to the actor. For example, it can be used to translate
   * screen events from global screen coordinates into actor-local coordinates.
   * 
   * The conversion can fail, notably if the transform stack results in the
   * actor being projected on the screen as a mere line.
   * 
   * The conversion should not be expected to be pixel-perfect due to the
   * nature of the operation. In general the error grows when the skewing
   * of the actor rectangle on screen increases.
   * 
   * <note>This function can be computationally intensive.</note>
   * 
   * <note>This function only works when the allocation is up-to-date,
   * i.e. inside of paint().</note>
   * 
   * @newin{0,6}
   * @param x X screen coordinate of the point to unproject.
   * @param y Y screen coordinate of the point to unproject.
   * @param x_out Return location for the unprojected x coordinance.
   * @param y_out Return location for the unprojected y coordinance.
   * @return <tt>true</tt> if conversion was successful.
   */
  void transform_stage_point(float x, float y, float& x_out, float& y_out) const;
 

  /** Transforms @a point in coordinates relative to the actor into
   * ancestor-relative coordinates using the relevant transform
   * stack (i.e.\ scale, rotation, etc).
   * 
   * If @a ancestor is <tt>0</tt> the ancestor will be the Clutter::Stage. In
   * this case, the coordinates returned will be the coordinates on
   * the stage before the projection is applied. This is different from
   * the behaviour of apply_transform_to_point().
   * 
   * @newin{0,6}
   * @param ancestor A Clutter::Actor ancestor, or <tt>0</tt> to use the
   * default Clutter::Stage.
   * @param point A point as Clutter::Vertex.
   * @param vertex The translated Clutter::Vertex.
   */
  void apply_relative_transform_to_point(const Glib::RefPtr<Actor>& ancestor, const Vertex& point, Vertex& vertex) const;
  
  /** Calculates the transformed coordinates of the four corners of the
   * actor in the plane of @a ancestor. The returned vertices relate to
   * the Clutter::ActorBox coordinates as follows:
   * -  @a verts[0] contains (x1, y1)
   * -  @a verts[1] contains (x2, y1)
   * -  @a verts[2] contains (x1, y2)
   * -  @a verts[3] contains (x2, y2)
   * 
   * If @a ancestor is <tt>0</tt> the ancestor will be the Clutter::Stage. In
   * this case, the coordinates returned will be the coordinates on
   * the stage before the projection is applied. This is different from
   * the behaviour of get_abs_allocation_vertices().
   * 
   * @newin{0,6}
   * @param ancestor A Clutter::Actor to calculate the vertices
   * against, or <tt>0</tt> to use the Clutter::Stage.
   * @param verts Return
   * location for an array of 4 Clutter::Vertex in which to store the result.
   */

  void apply_relative_transform_to_point(const Vertex& point, Vertex& vertex) const;
  
  /** Gets the absolute position of an actor, in pixels relative to the stage.
   * 
   * @newin{0,8}
   * @param x Return location for the X coordinate, or <tt>0</tt>.
   * @param y Return location for the Y coordinate, or <tt>0</tt>.
   */
  void get_transformed_position(float& x, float& y) const;

  Matrix get_child_transform() const;
  

  /** Gets the absolute size of an actor in pixels, taking into account the
   * scaling factors.
   * 
   * If the actor has a valid allocation, the allocated size will be used.
   * If the actor has not a valid allocation then the preferred size will
   * be transformed and returned.
   * 
   * If you want the transformed allocation, see
   * get_abs_allocation_vertices() instead.
   * 
   * <note>When the actor (or one of its ancestors) is rotated around the
   * X or Y axis, it no longer appears as on the stage as a rectangle, but
   * as a generic quadrangle; in that case this function returns the size
   * of the smallest rectangle that encapsulates the entire quad. Please
   * note that in this case no assumptions can be made about the relative
   * position of this envelope to the absolute position of the actor, as
   * returned by get_transformed_position(); if you need this
   * information, you need to use get_abs_allocation_vertices()
   * to get the coords of the actual quadrangle.</note>
   * 
   * @newin{0,8}
   * @param width Return location for the width, or <tt>0</tt>.
   * @param height Return location for the height, or <tt>0</tt>.
   */
  void get_transformed_size(float& width, float& height) const;

  
  /** Sets the geometry request mode of @a self.
   * 
   * The @a mode determines the order for invoking
   * get_preferred_width() and
   * get_preferred_height()
   * 
   * @newin{1,2}
   * @param mode The request mode.
   */
  void set_request_mode(RequestMode mode);
  
  /** Retrieves the geometry request mode of @a self
   * 
   * @newin{1,2}
   * @return The request mode for the actor.
   */
  RequestMode get_request_mode() const;

  
  /** Computes the preferred minimum and natural size of an actor, taking into
   * account the actor's geometry management (either height-for-width
   * or width-for-height).
   * 
   * The width and height used to compute the preferred height and preferred
   * width are the actor's natural ones.
   * 
   * If you need to control the height for the preferred width, or the width for
   * the preferred height, you should use get_preferred_width()
   * and get_preferred_height(), and check the actor's preferred
   * geometry management using the Clutter::Actor::property_request_mode() property.
   * 
   * @newin{0,8}
   * @param min_width_p Return location for the minimum
   * width, or <tt>0</tt>.
   * @param min_height_p Return location for the minimum
   * height, or <tt>0</tt>.
   * @param natural_width_p Return location for the natural
   * width, or <tt>0</tt>.
   * @param natural_height_p Return location for the natural
   * height, or <tt>0</tt>.
   */
  void get_preferred_size(float& min_width_p, float& min_height_p, float& natural_width_p, float& natural_height_p) const;
  
  /** Computes the requested minimum and natural widths for an actor,
   * optionally depending on the specified height, or if they are
   * already computed, returns the cached values.
   * 
   * An actor may not get its request - depending on the layout
   * manager that's in effect.
   * 
   * A request should not incorporate the actor's scale or anchor point;
   * those transformations do not affect layout, only rendering.
   * 
   * @newin{0,8}
   * @param for_height Available height when computing the preferred width,
   * or a negative value to indicate that no height is defined.
   * @param min_width_p Return location for minimum width,
   * or <tt>0</tt>.
   * @param natural_width_p Return location for the natural
   * width, or <tt>0</tt>.
   */
  void get_preferred_width(float for_height, float& min_width_p, float& natural_width_p) const;
  
  /** Computes the requested minimum and natural heights for an actor,
   * or if they are already computed, returns the cached values.
   * 
   * An actor may not get its request - depending on the layout
   * manager that's in effect.
   * 
   * A request should not incorporate the actor's scale or anchor point;
   * those transformations do not affect layout, only rendering.
   * 
   * @newin{0,8}
   * @param for_width Available width to assume in computing desired height,
   * or a negative value to indicate that no width is defined.
   * @param min_height_p Return location for minimum height,
   * or <tt>0</tt>.
   * @param natural_height_p Return location for natural
   * height, or <tt>0</tt>.
   */
  void get_preferred_height(float for_width, float& min_height_p, float& natural_height_p) const;
  
  /** Retrieves the absolute opacity of the actor, as it appears on the stage.
   * 
   * This function traverses the hierarchy chain and composites the opacity of
   * the actor with that of its parents.
   * 
   * This function is intended for subclasses to use in the paint virtual
   * function, to paint themselves with the correct opacity.
   * 
   * @newin{0,8}
   * @return The actor opacity value.
   */
  guint8 get_paint_opacity() const;
  
  /** Retrieves the 'paint' visibility of an actor recursively checking for non
   * visible parents.
   * 
   * This is by definition the same as Clutter::ACTOR_IS_MAPPED.
   * 
   * @newin{0,8,4}
   * @return <tt>true</tt> if the actor is visibile and will be painted.
   */
  bool get_paint_visibility() const;
  
#ifndef CLUTTERMM_DISABLE_DEPRECATED

  /** Sets an anchor point on the actor based on the given gravity, adjusting the
   * actor postion so that its relative position within its parent remains
   * unchanged.
   * 
   * Since version 1.0 the anchor point will be stored as a gravity so
   * that if the actor changes size then the anchor point will move. For
   * example, if you set the anchor point to Clutter::GRAVITY_SOUTH_EAST
   * and later double the size of the actor, the anchor point will move
   * to the bottom right.
   * 
   * @newin{0,6}
   * 
   * Deprecated: 1.12: Use Clutter::Actor::property_pivot_point() instead.
   * @deprecated Use “pivot-point” instead.
   * @param gravity Clutter::Gravity.
   */
  void move_anchor_point_from_gravity(Gravity gravity);
#endif // CLUTTERMM_DISABLE_DEPRECATED


#ifndef CLUTTERMM_DISABLE_DEPRECATED

  /** Sets an anchor point for the actor, and adjusts the actor postion so that
   * the relative position of the actor toward its parent remains the same.
   * 
   * @newin{0,6}
   * 
   * Deprecated: 1.12: Use Clutter::Actor::property_pivot_point() instead.
   * @deprecated Use “pivot-point” instead.
   * @param anchor_x X coordinate of the anchor point.
   * @param anchor_y Y coordinate of the anchor point.
   */
  void move_anchor_point(float anchor_x, float anchor_y);
#endif // CLUTTERMM_DISABLE_DEPRECATED


// IM: ClutterMargin.
  
  
  /** Sets the margin from the top of a Clutter::Actor.
   * 
   * The Clutter::Actor::property_margin_top() property is animatable.
   * 
   * @newin{1,10}
   * @param margin The top margin.
   */
  void set_margin_top(float margin);
  
  /** Retrieves the top margin of a Clutter::Actor.
   * 
   * @newin{1,10}
   * @return The top margin.
   */
  float get_margin_top() const;
  
  /** Sets the margin from the bottom of a Clutter::Actor.
   * 
   * The Clutter::Actor::property_margin_bottom() property is animatable.
   * 
   * @newin{1,10}
   * @param margin The bottom margin.
   */
  void set_margin_bottom(float margin);
  
  /** Retrieves the bottom margin of a Clutter::Actor.
   * 
   * @newin{1,10}
   * @return The bottom margin.
   */
  float get_margin_bottom() const;
  
  /** Sets the margin from the left of a Clutter::Actor.
   * 
   * The Clutter::Actor::property_margin_left() property is animatable.
   * 
   * @newin{1,10}
   * @param margin The left margin.
   */
  void set_margin_left(float margin);
  
  /** Retrieves the left margin of a Clutter::Actor.
   * 
   * @newin{1,10}
   * @return The left margin.
   */
  float get_margin_left() const;
  
  /** Sets the margin from the right of a Clutter::Actor.
   * 
   * The Clutter::Actor::property_margin_right() property is animatable.
   * 
   * @newin{1,10}
   * @param margin The right margin.
   */
  void set_margin_right(float margin);
  
  /** Retrieves the right margin of a Clutter::Actor.
   * 
   * @newin{1,10}
   * @return The right margin.
   */
  float get_margin_right() const;
  /**
  * Convenience method for setting all margins at once.
  *
  * @param top The top margin
  * @param left the left margin
  * @param bottom The bottom margin
  * @param right The right margin.
  * */
  void set_margins(float top, float left, float bottom, float right);

  
  /** Checks whether an actor has a fixed position set (and will thus be
   * unaffected by any layout manager).
   * 
   * @newin{0,8}
   * @return <tt>true</tt> if the fixed position is set on the actor.
   */
  bool get_fixed_position_set() const;
  
  /** Sets whether an actor has a fixed position set (and will thus be
   * unaffected by any layout manager).
   * 
   * @newin{0,8}
   * @param is_set Whether to use fixed position.
   */
  void set_fixed_position_set(bool is_set);

#ifndef CLUTTERMM_DISABLE_DEPRECATED

  
  /** Gets the layout box an actor has been assigned.  The allocation can
   * only be assumed valid inside a paint() method; anywhere else, it
   * may be out-of-date.
   * 
   * An allocation does not incorporate the actor's scale or anchor point;
   * those transformations do not affect layout, only rendering.
   * 
   * The returned rectangle is in pixels.
   * 
   * @newin{0,8}
   * 
   * Deprecated: 1.12: Use get_allocation_box() instead.
   * @param geom Allocation geometry in pixels.
   */

  /**
   * @deprecated Use get_allocation_box() instead.
   */
  Geometry get_allocation_geometry() const;
#endif // CLUTTERMM_DISABLE_DEPRECATED


#ifndef CLUTTERMM_DISABLE_DEPRECATED

  /** Sets the Z coordinate of @a self to @a depth.
   * 
   * The unit used by @a depth is dependant on the perspective setup. See
   * also Clutter::Stage::set_perspective().
   * 
   * Deprecated: 1.12: Use set_z_position() instead.
   * @deprecated Use set_z_position() instead.
   * @param depth Z co-ord.
   */
  void set_depth(float depth);
#endif // CLUTTERMM_DISABLE_DEPRECATED


#ifndef CLUTTERMM_DISABLE_DEPRECATED

  /** Retrieves the depth of @a self.
   * 
   * Deprecated: 1.12: Use get_z_position() instead.
   * @deprecated Use get_z_position() instead.
   * @return The depth of the actor.
   */
  float get_depth() const;
#endif // CLUTTERMM_DISABLE_DEPRECATED


  /** Scales an actor with the given factors.
   * 
   * The scale transformation is relative the the Clutter::Actor::property_pivot_point().
   * 
   * The Clutter::Actor::property_scale_x() and Clutter::Actor::property_scale_y() properties are
   * animatable.
   * 
   * @newin{0,2}
   * @param scale_x Double factor to scale actor by horizontally.
   * @param scale_y Double factor to scale actor by vertically.
   */
  void set_scale(double scale_x, double scale_y);
  
  /** Scales an actor on the Z axis by the given @a scale_z factor.
   * 
   * The scale transformation is relative the the Clutter::Actor::property_pivot_point().
   * 
   * The Clutter::Actor::property_scale_z() property is animatable.
   * 
   * @newin{1,12}
   * @param scale_z The scaling factor along the Z axis.
   */
  void set_scale_z(double scale_z);
  
#ifndef CLUTTERMM_DISABLE_DEPRECATED

  /** Scales an actor with the given factors around the given center
   * point. The center point is specified in pixels relative to the
   * anchor point (usually the top left corner of the actor).
   * 
   * The Clutter::Actor::property_scale_x() and Clutter::Actor::property_scale_y() properties
   * are animatable.
   * 
   * @newin{1,0}
   * 
   * Deprecated: 1.12: Use set_pivot_point() to control
   * the scale center
   * @deprecated Use set_pivot_point() to control the scale center.
   * @param scale_x Double factor to scale actor by horizontally.
   * @param scale_y Double factor to scale actor by vertically.
   * @param center_x X coordinate of the center of the scaling.
   * @param center_y Y coordinate of the center of the scaling.
   */
  void set_scale_full(double scale_x, double scale_y, float center_x, float center_y);
#endif // CLUTTERMM_DISABLE_DEPRECATED


#ifndef CLUTTERMM_DISABLE_DEPRECATED

  /** Scales an actor with the given factors around the given
   * center point. The center point is specified as one of the compass
   * directions in Clutter::Gravity. For example, setting it to north
   * will cause the top of the actor to remain unchanged and the rest of
   * the actor to expand left, right and downwards.
   * 
   * The Clutter::Actor::property_scale_x() and Clutter::Actor::property_scale_y() properties are
   * animatable.
   * 
   * @newin{1,0}
   * 
   * Deprecated: 1.12: Use set_pivot_point() to set the
   * scale center using normalized coordinates instead.
   * @deprecated Use clutter_actor_set_pivot_point() to set the scale center using normalized coordinates instead.
   * @param scale_x Double factor to scale actor by horizontally.
   * @param scale_y Double factor to scale actor by vertically.
   * @param gravity The location of the scale center expressed as a compass
   * direction.
   */
  void set_scale_with_gravity(double scale_x, double scale_y, Gravity gravity);
#endif // CLUTTERMM_DISABLE_DEPRECATED


  /** Retrieves an actors scale factors.
   * 
   * @newin{0,2}
   * @param scale_x Location to store horizonal
   * scale factor, or <tt>0</tt>.
   * @param scale_y Location to store vertical
   * scale factor, or <tt>0</tt>.
   */
  void get_scale(double& scale_x, double& scale_y) const;
  
  /** Retrieves the scaling factor along the Z axis, as set using
   * set_scale_z().
   * 
   * @newin{1,12}
   * @return The scaling factor along the Z axis.
   */
  double get_scale_z() const;
  
#ifndef CLUTTERMM_DISABLE_DEPRECATED

  /** Retrieves the scale center coordinate in pixels relative to the top
   * left corner of the actor. If the scale center was specified using a
   * Clutter::Gravity this will calculate the pixel offset using the
   * current size of the actor.
   * 
   * @newin{1,0}
   * 
   * Deprecated: 1.12: Use get_pivot_point() instead.
   * @deprecated Use get_pivot_point() instead.
   * @param center_x Location to store the X position
   * of the scale center, or <tt>0</tt>.
   * @param center_y Location to store the Y position
   * of the scale center, or <tt>0</tt>.
   */
  void get_scale_center(float& center_x, float& center_y) const;
#endif // CLUTTERMM_DISABLE_DEPRECATED


#ifndef CLUTTERMM_DISABLE_DEPRECATED

  /** Retrieves the scale center as a compass direction. If the scale
   * center was specified in pixels or units this will return
   * Clutter::GRAVITY_NONE.
   * 
   * @newin{1,0}
   * 
   * Deprecated: 1.12: Use get_pivot_point() instead.
   * @deprecated Use get_pivot_point() instead.
   * @return The scale gravity.
   */
  Gravity get_scale_gravity() const;
#endif // CLUTTERMM_DISABLE_DEPRECATED


  //_WRAP_METHOD(void get_abs_size(float& width, float& height) const, clutter_actor_get_abs_size)
  
  /** This function tries to "do what you mean" and return
   * the size an actor will have. If the actor has a valid
   * allocation, the allocation will be returned; otherwise,
   * the actors natural size request will be returned.
   * 
   * If you care whether you get the request vs. the allocation, you
   * should probably call a different function like
   * get_allocation_box() or
   * get_preferred_width().
   * 
   * @newin{0,2}
   * @param width Return location for the width, or <tt>0</tt>.
   * @param height Return location for the height, or <tt>0</tt>.
   */
  void get_size(float& width, float& height) const;
  
  /** Moves an actor by the specified distance relative to its current
   * position in pixels.
   * 
   * This function modifies the fixed position of an actor and thus removes
   * it from any layout management. Another way to move an actor is with an
   * anchor point, see set_anchor_point(), or with an additional
   * translation, using set_translation().
   * 
   * @newin{0,2}
   * @param dx Distance to move Actor on X axis.
   * @param dy Distance to move Actor on Y axis.
   */
  void move_by(float dx, float dy);

  
  /** This function is used to emit an event on the main stage.
   * You should rarely need to use this function, except for
   * synthetising events.
   * 
   * @newin{0,6}
   * @param event A Clutter::Event.
   * @param capture <tt>true</tt> if event in in capture phase, <tt>false</tt> otherwise.
   * @return The return value from the signal emission: <tt>true</tt>
   * if the actor handled the event, or <tt>false</tt> if the event was
   * not handled.
   */
  bool event(const ClutterEvent* event, bool capture);
  
#ifndef CLUTTERMM_DISABLE_DEPRECATED

  /** Retrieves the Clutter::Actor with @a id.
   * 
   * @newin{0,6}
   * 
   * Deprecated: 1.8: The id is not used any longer.
   * @deprecated The ID is no longer used.
   * @param id A Clutter::Actor unique id.
   * @return The actor with the passed id or <tt>0</tt>.
   * The returned actor does not have its reference count increased.
   */
  static Glib::RefPtr<Actor> get_actor_by_gid(guint32 id);
#endif // CLUTTERMM_DISABLE_DEPRECATED


#ifndef CLUTTERMM_DISABLE_DEPRECATED

  /** Sets an anchor point for @a self. The anchor point is a point in the
   * coordinate space of an actor to which the actor position within its
   * parent is relative; the default is (0, 0), i.e. the top-left corner
   * of the actor.
   * 
   * @newin{0,6}
   * 
   * Deprecated: 1.12: Use Clutter::Actor::property_pivot_point() instead.
   * @deprecated Use “pivot-point” instead.
   * @param anchor_x X coordinate of the anchor point.
   * @param anchor_y Y coordinate of the anchor point.
   */
  void set_anchor_point(float anchor_x, float anchor_y);
#endif // CLUTTERMM_DISABLE_DEPRECATED


#ifndef CLUTTERMM_DISABLE_DEPRECATED

  /** Gets the current anchor point of the @a actor in pixels.
   * 
   * @newin{0,6}
   * 
   * Deprecated: 1.12: Use Clutter::Actor::property_pivot_point() instead
   * @deprecated Use “pivot-point” instead.
   * @param anchor_x Return location for the X coordinate of the anchor point.
   * @param anchor_y Return location for the Y coordinate of the anchor point.
   */
  void get_anchor_point(float& anchor_x, float& anchor_y) const;
#endif // CLUTTERMM_DISABLE_DEPRECATED


#ifndef CLUTTERMM_DISABLE_DEPRECATED

  /** Sets an anchor point on the actor, based on the given gravity (this is a
   * convenience function wrapping set_anchor_point()).
   * 
   * Since version 1.0 the anchor point will be stored as a gravity so
   * that if the actor changes size then the anchor point will move. For
   * example, if you set the anchor point to Clutter::GRAVITY_SOUTH_EAST
   * and later double the size of the actor, the anchor point will move
   * to the bottom right.
   * 
   * @newin{0,6}
   * 
   * Deprecated: 1.12: Use Clutter::Actor::property_pivot_point() instead.
   * @deprecated Use “pivot-point” instead.
   * @param gravity Clutter::Gravity.
   */
  void set_anchor_point_from_gravity(ClutterGravity gravity);
#endif // CLUTTERMM_DISABLE_DEPRECATED


#ifndef CLUTTERMM_DISABLE_DEPRECATED

  /** Retrieves the anchor position expressed as a Clutter::Gravity. If
   * the anchor point was specified using pixels or units this will
   * return Clutter::GRAVITY_NONE.
   * 
   * @newin{1,0}
   * 
   * Deprecated: 1.12: Use Clutter::Actor::property_pivot_point() instead.
   * @deprecated Use “pivot-point” instead.
   * @return The Clutter::Gravity used by the anchor point.
   */
  Gravity get_anchor_point_gravity();
#endif // CLUTTERMM_DISABLE_DEPRECATED


  /** Sets the key focus of the Clutter::Stage including @a self
   * to this Clutter::Actor.
   * 
   * @newin{1,0}
   */
  void grab_key_focus();

  
  /** Adds @a child to the children of @a self.
   * 
   * This function will acquire a reference on @a child that will only
   * be released when calling remove_child().
   * 
   * This function will take into consideration the Clutter::Actor::property_depth()
   * of @a child, and will keep the list of children sorted.
   * 
   * This function will emit the Clutter::Container::signal_actor_added() signal
   * on @a self.
   * 
   * @newin{1,10}
   * @param child A Clutter::Actor.
   */
  void add_child(const Glib::RefPtr<Actor>& child);
  
  /** Inserts @a child into the list of children of @a self, above another
   * child of @a self or, if @a sibling is <tt>0</tt>, above all the children
   * of @a self.
   * 
   * This function will acquire a reference on @a child that will only
   * be released when calling remove_child().
   * 
   * This function will not take into consideration the Clutter::Actor::property_depth()
   * of @a child.
   * 
   * This function will emit the Clutter::Container::signal_actor_added() signal
   * on @a self.
   * 
   * @newin{1,10}
   * @param child A Clutter::Actor.
   * @param sibling A child of @a self, or <tt>0</tt>.
   */
  void insert_child_above(const Glib::RefPtr<Actor>& child, const Glib::RefPtr<Actor>& sibling);
  
  /** Inserts @a child into the list of children of @a self, using the
   * given @a index. If @a index is greater than the number of children
   * in @a self, or is less than 0, then the new child is added at the end.
   * 
   * This function will acquire a reference on @a child that will only
   * be released when calling remove_child().
   * 
   * This function will not take into consideration the Clutter::Actor::property_depth()
   * of @a child.
   * 
   * This function will emit the Clutter::Container::signal_actor_added() signal
   * on @a self.
   * 
   * @newin{1,10}
   * @param child A Clutter::Actor.
   * @param index The index.
   */
  void insert_child_at_index(const Glib::RefPtr<Actor>& child, int index);

  /// A insert_child_at_index() convenience overload.
  void insert_child_at_index(const Glib::RefPtr<Actor>& child);
  
  /** Inserts @a child into the list of children of @a self, below another
   * child of @a self or, if @a sibling is <tt>0</tt>, below all the children
   * of @a self.
   * 
   * This function will acquire a reference on @a child that will only
   * be released when calling remove_child().
   * 
   * This function will not take into consideration the Clutter::Actor::property_depth()
   * of @a child.
   * 
   * This function will emit the Clutter::Container::signal_actor_added() signal
   * on @a self.
   * 
   * @newin{1,10}
   * @param child A Clutter::Actor.
   * @param sibling A child of @a self, or <tt>0</tt>.
   */
  void insert_child_below(const Glib::RefPtr<Actor>& child, const Glib::RefPtr<Actor>& sibling);
  
  /** Replaces @a old_child with @a new_child in the list of children of @a self.
   * 
   * @newin{1,10}
   * @param old_child The child of @a self to replace.
   * @param new_child The Clutter::Actor to replace @a old_child.
   */
  void replace_child(const Glib::RefPtr<Actor>& old_child, const Glib::RefPtr<Actor>& new_child);

  
  /** Removes @a child from the children of @a self.
   * 
   * This function will release the reference added by
   * add_child(), so if you want to keep using @a child
   * you will have to acquire a referenced on it before calling this
   * function.
   * 
   * This function will emit the Clutter::Container::signal_actor_removed()
   * signal on @a self.
   * 
   * @newin{1,10}
   * @param child A Clutter::Actor.
   */
  void remove_child(const Glib::RefPtr<Actor>& child);
  
  /** Removes all children of @a self.
   * 
   * This function releases the reference added by inserting a child actor
   * in the list of children of @a self.
   * 
   * If the reference count of a child drops to zero, the child will be
   * destroyed. If you want to ensure the destruction of all the children
   * of @a self, use destroy_all_children().
   * 
   * @newin{1,10}
   */
  void remove_all_children();

   //deprecated
  

#ifndef CLUTTERMM_DISABLE_DEPRECATED

  /** Retrieves the Clutter::Animation used by @a actor, if animate()
   * has been called on @a actor.
   * 
   * @newin{1,0}
   * Deprecated: 1.12: Use the implicit transition for animatable properties
   * in Clutter::Actor instead, and get_transition() to retrieve
   * the transition.
   * @deprecated Use the implicit transition for animatable properties in ClutterActor instead
   * @return A Clutter::Animation, or <tt>0</tt>.
   */
  Glib::RefPtr<Animation> get_animation();
#endif // CLUTTERMM_DISABLE_DEPRECATED


#ifndef CLUTTERMM_DISABLE_DEPRECATED

  /** Retrieves the Clutter::Animation used by @a actor, if animate()
   * has been called on @a actor.
   * 
   * @newin{1,0}
   * Deprecated: 1.12: Use the implicit transition for animatable properties
   * in Clutter::Actor instead, and get_transition() to retrieve
   * the transition.
   * @deprecated Use the implicit transition for animatable properties in ClutterActor instead
   * @return A Clutter::Animation, or <tt>0</tt>.
   */
  Glib::RefPtr<const Animation> get_animation() const;
#endif // CLUTTERMM_DISABLE_DEPRECATED


  /** Detaches the Clutter::Animation used by @a actor, if animate()
   * has been called on @a actor.
   * 
   * Once the animation has been detached, it loses a reference. If it was
   * the only reference then the Clutter::Animation becomes invalid.
   * 
   * The Clutter::Animation::signal_completed() signal will not be emitted.
   * 
   * @newin{1,4}
   * Deprecated: 1.12: Use the implicit transition for animatable properties
   * in Clutter::Actor instead, and remove_transition() to
   * remove the transition.
   */
  void detach_animation();


#ifndef CLUTTERMM_DISABLE_DEPRECATED

  /** Should be used by actors implementing the Clutter::Container and with
   * internal children added through set_parent(), for instance:
   * 
   * 
   * [C example ellipted]
   * 
   * This function will be used by Clutter to toggle an "internal child"
   * flag whenever set_parent() is called; internal children
   * are handled differently by Clutter, specifically when destroying their
   * parent.
   * 
   * Call pop_internal() when you finished adding internal
   * children.
   * 
   * Nested calls to push_internal() are allowed, but each
   * one must by followed by a pop_internal() call.
   * 
   * @newin{1,2}
   * 
   * Deprecated: 1.10: All children of an actor are accessible through
   * the Clutter::Actor API, and Clutter::Actor implements the
   * Clutter::Container interface, so this function is only useful
   * for legacy containers overriding the default implementation.
   * @deprecated All children of an actor are accessible through the ClutterActor API
   */
  void push_internal();
#endif // CLUTTERMM_DISABLE_DEPRECATED


#ifndef CLUTTERMM_DISABLE_DEPRECATED

  /** Disables the effects of push_internal().
   * 
   * @newin{1,2}
   * 
   * Deprecated: 1.10: All children of an actor are accessible through
   * the Clutter::Actor API. This function is only useful for legacy
   * containers overriding the default implementation of the
   * Clutter::Container interface.
   * @deprecated All children of an actor are accessible through the ClutterActor API. This function is only useful for legacy containers overriding the default implementation of the ClutterContainer interface.
   */
  void pop_internal();
#endif // CLUTTERMM_DISABLE_DEPRECATED


  /** Checks if the actor has an up-to-date allocation assigned to
   * it. This means that the actor should have an allocation: it's
   * visible and has a parent. It also means that there is no
   * outstanding relayout request in progress for the actor or its
   * children (There might be other outstanding layout requests in
   * progress that will cause the actor to get a new allocation
   * when the stage is laid out, however).
   * 
   * If this function returns <tt>false</tt>, then the actor will normally
   * be allocated before it is next drawn on the screen.
   * 
   * @newin{1,4}
   * @return <tt>true</tt> if the actor has an up-to-date allocation.
   */
  bool has_allocation() const;

  
  /** Returns the accessible object that describes the actor to an
   * assistive technology.
   * 
   * If no class-specific Atk::Object implementation is available for the
   * actor instance in question, it will inherit an Atk::Object
   * implementation from the first ancestor class for which such an
   * implementation is defined.
   * 
   * The documentation of the ATK
   * library contains more information about accessible objects and
   * their uses.
   * @return The Atk::Object associated with @a actor.
   */
  Glib::RefPtr<Atk::Object> get_accessible();
  
  /** Returns the accessible object that describes the actor to an
   * assistive technology.
   * 
   * If no class-specific Atk::Object implementation is available for the
   * actor instance in question, it will inherit an Atk::Object
   * implementation from the first ancestor class for which such an
   * implementation is defined.
   * 
   * The documentation of the ATK
   * library contains more information about accessible objects and
   * their uses.
   * @return The Atk::Object associated with @a actor.
   */
  Glib::RefPtr<const Atk::Object> get_accessible() const;

  
  /** Adds @a action to the list of actions applied to @a self
   * 
   * A Clutter::Action can only belong to one actor at a time
   * 
   * The Clutter::Actor will hold a reference on @a action until either
   * remove_action() or clear_actions()
   * is called
   * 
   * @newin{1,4}
   * @param action A Clutter::Action.
   */
  void add_action(const Glib::RefPtr<Action>& action);
  
  /** A convenience function for setting the name of a Clutter::Action
   * while adding it to the list of actions applied to @a self
   * 
   * This function is the logical equivalent of:
   * 
   * 
   * [C example ellipted]
   * 
   * @newin{1,4}
   * @param name The name to set on the action.
   * @param action A Clutter::Action.
   */
  void add_action(const Glib::ustring& name, const Glib::RefPtr<Action>& action);
  
  /** Removes @a action from the list of actions applied to @a self
   * 
   * The reference held by @a self on the Clutter::Action will be released
   * 
   * @newin{1,4}
   * @param action A Clutter::Action.
   */
  void remove_action(const Glib::RefPtr<Action>& action);
  
  /** Removes the Clutter::Action with the given name from the list
   * of actions applied to @a self
   * 
   * @newin{1,4}
   * @param name The name of the action to remove.
   */
  void remove_action(const Glib::ustring& name);

  
  /** Retrieves the Clutter::Action with the given name in the list
   * of actions applied to @a self
   * 
   * @newin{1,4}
   * @param name The name of the action to retrieve.
   * @return A Clutter::Action for the given
   * name, or <tt>0</tt>. The returned Clutter::Action is owned by the
   * actor and it should not be unreferenced directly.
   */
  Glib::RefPtr<Action> get_action(const Glib::ustring& name);
  
  /** Retrieves the Clutter::Action with the given name in the list
   * of actions applied to @a self
   * 
   * @newin{1,4}
   * @param name The name of the action to retrieve.
   * @return A Clutter::Action for the given
   * name, or <tt>0</tt>. The returned Clutter::Action is owned by the
   * actor and it should not be unreferenced directly.
   */
  Glib::RefPtr<const Action> get_action(const Glib::ustring& name) const;

  
  /** Clears the list of actions applied to @a self
   * 
   * @newin{1,4}
   */
  void clear_actions();

   
  /** Retrieves the list of actions applied to @a self
   * 
   * @newin{1,4}
   * @return A copy
   * of the list of Clutter::Action<!-- -->s. The contents of the list are
   * owned by the Clutter::Actor. Use Glib::list_free() to free the resources
   * allocated by the returned List.
   */
  std::vector< Glib::RefPtr<Action> > get_actions();

   
  /** Retrieves the list of actions applied to @a self
   * 
   * @newin{1,4}
   * @return A copy
   * of the list of Clutter::Action<!-- -->s. The contents of the list are
   * owned by the Clutter::Actor. Use Glib::list_free() to free the resources
   * allocated by the returned List.
   */
  std::vector< Glib::RefPtr<const Action> > get_actions() const;

  
  /** Returns whether the actor has any actions applied.
   * 
   * @newin{1,10}
   * @return <tt>true</tt> if the actor has any actions,
   * <tt>false</tt> otherwise.
   */
  bool has_actions() const;

  
  /** Adds @a effect to the list of Clutter::Effect<!-- -->s applied to @a self
   * 
   * The Clutter::Actor will hold a reference on the @a effect until either
   * remove_effect() or clear_effects() is
   * called.
   * 
   * @newin{1,4}
   * @param effect A Clutter::Effect.
   */
  void add_effect(const Glib::RefPtr<Effect>& effect);
  
  /** A convenience function for setting the name of a Clutter::Effect
   * while adding it to the list of effectss applied to @a self
   * 
   * This function is the logical equivalent of:
   * 
   * 
   * [C example ellipted]
   * 
   * @newin{1,4}
   * @param name The name to set on the effect.
   * @param effect A Clutter::Effect.
   */
  void add_effect_with_name(const Glib::ustring& name, const Glib::RefPtr<Effect>& effect);
  
  /** Removes @a effect from the list of effects applied to @a self
   * 
   * The reference held by @a self on the Clutter::Effect will be released
   * 
   * @newin{1,4}
   * @param effect A Clutter::Effect.
   */
  void remove_effect(const Glib::RefPtr<Effect>& effect);
  
  /** Removes the Clutter::Effect with the given name from the list
   * of effects applied to @a self
   * 
   * @newin{1,4}
   * @param name The name of the effect to remove.
   */
  void remove_effect(const Glib::ustring& name);

   
  /** Retrieves the Clutter::Effect<!-- -->s applied on @a self, if any
   * 
   * @newin{1,4}
   * @return A list
   * of Clutter::Effect<!-- -->s, or <tt>0</tt>. The elements of the returned
   * list are owned by Clutter and they should not be freed. You should
   * free the returned list using Glib::list_free() when done.
   */
  std::vector< Glib::RefPtr<Effect> > get_effects();

   
  /** Retrieves the Clutter::Effect<!-- -->s applied on @a self, if any
   * 
   * @newin{1,4}
   * @return A list
   * of Clutter::Effect<!-- -->s, or <tt>0</tt>. The elements of the returned
   * list are owned by Clutter and they should not be freed. You should
   * free the returned list using Glib::list_free() when done.
   */
  std::vector< Glib::RefPtr<const Effect> > get_effects() const;

  
  /** Retrieves the Clutter::Effect with the given name in the list
   * of effects applied to @a self
   * 
   * @newin{1,4}
   * @param name The name of the effect to retrieve.
   * @return A Clutter::Effect for the given
   * name, or <tt>0</tt>. The returned Clutter::Effect is owned by the
   * actor and it should not be unreferenced directly.
   */
  Glib::RefPtr<Effect> get_effect(const Glib::ustring& name);
  
  /** Retrieves the Clutter::Effect with the given name in the list
   * of effects applied to @a self
   * 
   * @newin{1,4}
   * @param name The name of the effect to retrieve.
   * @return A Clutter::Effect for the given
   * name, or <tt>0</tt>. The returned Clutter::Effect is owned by the
   * actor and it should not be unreferenced directly.
   */
  Glib::RefPtr<const Effect> get_effect(const Glib::ustring& name) const;
  
  /** Clears the list of effects applied to @a self
   * 
   * @newin{1,4}
   */
  void clear_effects();
  
  /** Returns whether the actor has any effects applied.
   * 
   * @newin{1,10}
   * @return <tt>true</tt> if the actor has any effects,
   * <tt>false</tt> otherwise.
   */
  bool has_effects() const;


  //Animation Framework.  The Easing state is used for basic animations.

  
  /** Saves the current easing state for animatable properties, and creates
   * a new state with the default values for easing mode and duration.
   * 
   * New transitions created after calling this function will inherit the
   * duration, easing mode, and delay of the new easing state; this also
   * applies to transitions modified in flight.
   * 
   * @newin{1,10}
   */
  void save_easing_state();
  
  /** Restores the easing state as it was prior to a call to
   * save_easing_state().
   * 
   * @newin{1,10}
   */
  void restore_easing_state();
  
  /** Sets the duration of the tweening for animatable properties
   * of @a self for the current easing state.
   * 
   * @newin{1,10}
   * @param msecs The duration of the easing, or <tt>0</tt>.
   */
  void set_easing_duration(guint msecs);
  
  /** Retrieves the duration of the tweening for animatable
   * properties of @a self for the current easing state.
   * 
   * @newin{1,10}
   * @return The duration of the tweening, in milliseconds.
   */
  guint get_easing_duration() const;
  
  /** Retrieves the easing mode for the tweening of animatable properties
   * of @a self for the current easing state.
   * 
   * @newin{1,10}
   * @return An easing mode.
   */
  AnimationMode get_easing_mode() const;
  
  /** Sets the easing mode for the tweening of animatable properties
   * of @a self.
   * 
   * @newin{1,10}
   * @param mode An easing mode, excluding Clutter::CUSTOM_MODE.
   */
  void set_easing_mode(AnimationMode mode);
  
  /** Retrieves the delay that should be applied when tweening animatable
   * properties.
   * 
   * @newin{1,10}
   * @return A delay, in milliseconds.
   */
  guint get_easing_delay() const;
  
  /** Sets the delay that should be applied before tweening animatable
   * properties.
   * 
   * @newin{1,10}
   * @param msecs The delay before the start of the tweening, in milliseconds.
   */
  void set_easing_delay(guint msecs);

  // Transitions.  Used for more complex animation handling.
  
  /** Retrieves the Clutter::Transition of a Clutter::Actor by using the
   * transition @a name.
   * 
   * Transitions created for animatable properties use the name of the
   * property itself, for instance the code below:
   * 
   * 
   * [C example ellipted]
   * 
   * will call the <tt>on_transition_stopped</tt> callback when
   * the transition is finished.
   * 
   * If you just want to get notifications of the completion of a transition,
   * you should use the Clutter::Actor::signal_transition_stopped() signal, using the
   * transition name as the signal detail.
   * 
   * @newin{1,10}
   * @param name The name of the transition.
   * @return A Clutter::Transition, or <tt>0</tt> is none
   * was found to match the passed name; the returned instance is owned
   * by Clutter and it should not be freed.
   */
  Glib::RefPtr<Transition> get_transition(const Glib::ustring& name);
  
  /** Retrieves the Clutter::Transition of a Clutter::Actor by using the
   * transition @a name.
   * 
   * Transitions created for animatable properties use the name of the
   * property itself, for instance the code below:
   * 
   * 
   * [C example ellipted]
   * 
   * will call the <tt>on_transition_stopped</tt> callback when
   * the transition is finished.
   * 
   * If you just want to get notifications of the completion of a transition,
   * you should use the Clutter::Actor::signal_transition_stopped() signal, using the
   * transition name as the signal detail.
   * 
   * @newin{1,10}
   * @param name The name of the transition.
   * @return A Clutter::Transition, or <tt>0</tt> is none
   * was found to match the passed name; the returned instance is owned
   * by Clutter and it should not be freed.
   */
  Glib::RefPtr<const Transition> get_transition(const Glib::ustring& name) const;

  
  /** Adds a @a transition to the Clutter::Actor's list of animations.
   * 
   * The @a name string is a per-actor unique identifier of the @a transition: only
   * one Clutter::Transition can be associated to the specified @a name.
   * 
   * The @a transition will be started once added.
   * 
   * This function will take a reference on the @a transition.
   * 
   * This function is usually called implicitly when modifying an animatable
   * property.
   * 
   * @newin{1,10}
   * @param name The name of the transition to add.
   * @param transition The Clutter::Transition to add.
   */
  void add_transition(const Glib::ustring& name, const Glib::RefPtr<Transition>& transition);
  
  /** Removes the transition stored inside a Clutter::Actor using @a name
   * identifier.
   * 
   * If the transition is currently in progress, it will be stopped.
   * 
   * This function releases the reference acquired when the transition
   * was added to the Clutter::Actor.
   * 
   * @newin{1,10}
   * @param name The name of the transition to remove.
   */
  void remove_transition(const Glib::ustring& name);
  
  /** Removes all transitions associated to @a self.
   * 
   * @newin{1,10}
   */
  void remove_all_transitions();

  //Constraints.
  
  /** Adds @a constraint to the list of Clutter::Constraint<!-- -->s applied
   * to @a self
   * 
   * The Clutter::Actor will hold a reference on the @a constraint until
   * either remove_constraint() or
   * clear_constraints() is called.
   * 
   * @newin{1,4}
   * @param constraint A Clutter::Constraint.
   */
  void add_constraint(const Glib::RefPtr<Constraint>& constraint);
  
  /** A convenience function for setting the name of a Clutter::Constraint
   * while adding it to the list of constraints applied to @a self
   * 
   * This function is the logical equivalent of:
   * 
   * 
   * [C example ellipted]
   * 
   * @newin{1,4}
   * @param name The name to set on the constraint.
   * @param constraint A Clutter::Constraint.
   */
  void add_constraint(const Glib::ustring& name, const Glib::RefPtr<Constraint>& constraint);
  
  /** Removes @a constraint from the list of constraints applied to @a self
   * 
   * The reference held by @a self on the Clutter::Constraint will be released
   * 
   * @newin{1,4}
   * @param constraint A Clutter::Constraint.
   */
  void remove_constraint(const Glib::RefPtr<Constraint>& constraint);
  
  /** Removes the Clutter::Constraint with the given name from the list
   * of constraints applied to @a self
   * 
   * @newin{1,4}
   * @param name The name of the constraint to remove.
   */
  void remove_constraint(const Glib::ustring& name);
  
  /** Returns whether the actor has any constraints applied.
   * 
   * @newin{1,10}
   * @return <tt>true</tt> if the actor has any constraints,
   * <tt>false</tt> otherwise.
   */
  bool has_constraints() const;

  // Clutter docs: Use g_list_free() when done.
   

  /** Retrieves the list of constraints applied to @a self
   * 
   * @newin{1,4}
   * @return A copy
   * of the list of Clutter::Constraint<!-- -->s. The contents of the list are
   * owned by the Clutter::Actor. Use Glib::list_free() to free the resources
   * allocated by the returned List.
   */
  std::vector< Glib::RefPtr<Clutter::Constraint> > get_constraints();
   

  /** Retrieves the list of constraints applied to @a self
   * 
   * @newin{1,4}
   * @return A copy
   * of the list of Clutter::Constraint<!-- -->s. The contents of the list are
   * owned by the Clutter::Actor. Use Glib::list_free() to free the resources
   * allocated by the returned List.
   */
  std::vector< Glib::RefPtr<const Clutter::Constraint> > get_constraints() const;

  
  /** Retrieves the Clutter::Constraint with the given name in the list
   * of constraints applied to @a self
   * 
   * @newin{1,4}
   * @param name The name of the constraint to retrieve.
   * @return A Clutter::Constraint for the given
   * name, or <tt>0</tt>. The returned Clutter::Constraint is owned by the
   * actor and it should not be unreferenced directly.
   */
  Glib::RefPtr<const Constraint> get_constraint(const Glib::ustring& name) const;
  
  /** Retrieves the Clutter::Constraint with the given name in the list
   * of constraints applied to @a self
   * 
   * @newin{1,4}
   * @param name The name of the constraint to retrieve.
   * @return A Clutter::Constraint for the given
   * name, or <tt>0</tt>. The returned Clutter::Constraint is owned by the
   * actor and it should not be unreferenced directly.
   */
  Glib::RefPtr<Constraint> get_constraint(const Glib::ustring& name);
  
  /** Clears the list of constraints applied to @a self
   * 
   * @newin{1,4}
   */
  void clear_constraints();


// signals
  
  /**
   * @par Slot Prototype:
   * <tt>bool on_my_%button_press_event(ButtonEvent* event)</tt>
   *
   * The signal_button_press_event() signal is emitted each time a mouse button
   * is pressed on @a actor.
   * 
   * @newin{0,6}
   * @param event A Clutter::ButtonEvent.
   * @return <tt>true</tt> if the event has been handled by the actor,
   * or <tt>false</tt> to continue the emission.
   */

  Glib::SignalProxy1< bool,ButtonEvent* > signal_button_press_event();

  
  /**
   * @par Slot Prototype:
   * <tt>bool on_my_%button_release_event(ButtonEvent* event)</tt>
   *
   * The signal_button_release_event() signal is emitted each time a mouse button
   * is released on @a actor.
   * 
   * @newin{0,6}
   * @param event A Clutter::ButtonEvent.
   * @return <tt>true</tt> if the event has been handled by the actor,
   * or <tt>false</tt> to continue the emission.
   */

  Glib::SignalProxy1< bool,ButtonEvent* > signal_button_release_event();

  
  /**
   * @par Slot Prototype:
   * <tt>bool on_my_%motion_event(MotionEvent* event)</tt>
   *
   * The signal_motion_event() signal is emitted each time the mouse pointer is
   * moved over @a actor.
   * 
   * @newin{0,6}
   * @param event A Clutter::MotionEvent.
   * @return <tt>true</tt> if the event has been handled by the actor,
   * or <tt>false</tt> to continue the emission.
   */

  Glib::SignalProxy1< bool,MotionEvent* > signal_motion_event();

  
  /**
   * @par Slot Prototype:
   * <tt>bool on_my_%leave_event(CrossingEvent* event)</tt>
   *
   * The signal_leave_event() signal is emitted when the pointer leaves the @a actor.
   * 
   * @newin{0,6}
   * @param event A Clutter::CrossingEvent.
   * @return <tt>true</tt> if the event has been handled by the actor,
   * or <tt>false</tt> to continue the emission.
   */

  Glib::SignalProxy1< bool,CrossingEvent* > signal_leave_event();

  
  /**
   * @par Slot Prototype:
   * <tt>void on_my_%show()</tt>
   *
   * The signal_show() signal is emitted when an actor is visible and
   * rendered on the stage.
   * 
   * @newin{0,2}
   */

  Glib::SignalProxy0< void > signal_show();

  
  /**
   * @par Slot Prototype:
   * <tt>void on_my_%hide()</tt>
   *
   * The signal_hide() signal is emitted when an actor is no longer rendered
   * on the stage.
   * 
   * @newin{0,2}
   */

  Glib::SignalProxy0< void > signal_hide();

  
  /**
   * @par Slot Prototype:
   * <tt>void on_my_%destroy()</tt>
   *
   * The signal_destroy() signal notifies that all references held on the
   * actor which emitted it should be released.
   * 
   * The signal_destroy() signal should be used by all holders of a reference
   * on @a actor.
   * 
   * This signal might result in the finalization of the Clutter::Actor
   * if all references are released.
   * 
   * Composite actors and actors implementing the Clutter::Container
   * interface should override the default implementation of the
   * class handler of this signal and call Clutter::Actor::destroy() on
   * their children. When overriding the default class handler, it is
   * required to chain up to the parent's implementation.
   * 
   * @newin{0,2}
   */

  Glib::SignalProxy0< void > signal_destroy();

  
  /**
   * @par Slot Prototype:
   * <tt>bool on_my_%key_release_event(KeyEvent* event)</tt>
   *
   * The signal_key_release_event() signal is emitted each time a keyboard button
   * is released while @a actor has key focus (see
   * Clutter::Stage::set_key_focus()).
   * 
   * @newin{0,6}
   * @param event A Clutter::KeyEvent.
   * @return <tt>true</tt> if the event has been handled by the actor,
   * or <tt>false</tt> to continue the emission.
   */

  Glib::SignalProxy1< bool,KeyEvent* > signal_key_release_event();

  
  /**
   * @par Slot Prototype:
   * <tt>bool on_my_%enter_event(CrossingEvent* event)</tt>
   *
   * The signal_enter_event() signal is emitted when the pointer enters the @a actor
   * 
   * @newin{0,6}
   * @param event A Clutter::CrossingEvent.
   * @return <tt>true</tt> if the event has been handled by the actor,
   * or <tt>false</tt> to continue the emission.
   */

  Glib::SignalProxy1< bool,CrossingEvent* > signal_enter_event();

  
  /**
   * @par Slot Prototype:
   * <tt>bool on_my_%event(Event* event)</tt>
   *
   * The signal_event() signal is emitted each time an event is received
   * by the @a actor. This signal will be emitted on every actor,
   * following the hierarchy chain, until it reaches the top-level
   * container (the Clutter::Stage).
   * 
   * @newin{0,6}
   * @param event A Clutter::Event.
   * @return <tt>true</tt> if the event has been handled by the actor,
   * or <tt>false</tt> to continue the emission.
   */

  Glib::SignalProxy1< bool,Event* > signal_event();

  
  /**
   * @par Slot Prototype:
   * <tt>void on_my_%key_focus_out()</tt>
   *
   * The signal_key_focus_out() signal is emitted when @a actor loses key focus.
   * 
   * @newin{0,6}
   */

  Glib::SignalProxy0< void > signal_key_focus_out();

  
  /**
   * @par Slot Prototype:
   * <tt>void on_my_%key_focus_in()</tt>
   *
   * The signal_key_focus_in() signal is emitted when @a actor receives key focus.
   * 
   * @newin{0,6}
   */

  Glib::SignalProxy0< void > signal_key_focus_in();

 
  /**
   * @par Slot Prototype:
   * <tt>void on_my_%parent_set(const Glib::RefPtr<Actor>& old_parent)</tt>
   *
   * This signal is emitted when the parent of the actor changes.
   * 
   * @newin{0,2}
   * @param old_parent The previous parent of the actor, or <tt>0</tt>.
   */

  Glib::SignalProxy1< void,const Glib::RefPtr<Actor>& > signal_parent_set();

  
  /**
   * @par Slot Prototype:
   * <tt>bool on_my_%scroll_event(ScrollEvent* event)</tt>
   *
   * The signal_scroll_event() signal is emitted each time the mouse is
   * scrolled on @a actor
   * 
   * @newin{0,6}
   * @param event A Clutter::ScrollEvent.
   * @return <tt>true</tt> if the event has been handled by the actor,
   * or <tt>false</tt> to continue the emission.
   */

  Glib::SignalProxy1< bool,ScrollEvent* > signal_scroll_event();

  
  /**
   * @par Slot Prototype:
   * <tt>bool on_my_%key_press_event(KeyEvent* event)</tt>
   *
   * The signal_key_press_event() signal is emitted each time a keyboard button
   * is pressed while @a actor has key focus (see Clutter::Stage::set_key_focus()).
   * 
   * @newin{0,6}
   * @param event A Clutter::KeyEvent.
   * @return <tt>true</tt> if the event has been handled by the actor,
   * or <tt>false</tt> to continue the emission.
   */

  Glib::SignalProxy1< bool,KeyEvent* > signal_key_press_event();

  
  /**
   * @par Slot Prototype:
   * <tt>bool on_my_%captured_event(Event* event)</tt>
   *
   * The signal_captured_event() signal is emitted when an event is captured
   * by Clutter. This signal will be emitted starting from the top-level
   * container (the Clutter::Stage) to the actor which received the event
   * going down the hierarchy. This signal can be used to intercept every
   * event before the specialized events (like
   * ClutterActor::button-press-event or signal_key_released_event()) are
   * emitted.
   * 
   * @newin{0,6}
   * @param event A Clutter::Event.
   * @return <tt>true</tt> if the event has been handled by the actor,
   * or <tt>false</tt> to continue the emission.
   */

  Glib::SignalProxy1< bool,Event* > signal_captured_event();

  
  /**
   * @par Slot Prototype:
   * <tt>void on_my_%paint()</tt>
   *
   * The signal_paint() signal is emitted each time an actor is being painted.
   * 
   * Subclasses of Clutter::Actor should override the Clutter::ActorClass.paint
   * virtual function paint themselves in that function.
   * 
   * <warning>It is strongly discouraged to connect a signal handler to
   * the Clutter::Actor::signal_paint() signal; if you want to change the paint
   * sequence of an existing Clutter::Actor instance, either create a new
   * Clutter::Actor class and override the Clutter::ActorClass.paint virtual
   * function, or use a Clutter::Effect. The Clutter::Actor::signal_paint() signal
   * will be removed in a future version of Clutter.</warning>
   * 
   * @newin{0,8}
   * 
   * Deprecated: 1.12: Override the Clutter::ActorClass.paint virtual
   * function, use a Clutter::Content implementation, or a Clutter::Effect
   * instead of connecting to this signal.
   */

  Glib::SignalProxy0< void > signal_paint();

  
  /**
   * @par Slot Prototype:
   * <tt>void on_my_%queue_redaw(const Glib::RefPtr<Actor>& origin)</tt>
   *
   * The ::queue_redraw signal is emitted when Clutter::Actor::queue_redraw()
   * is called on @a origin.
   * 
   * The default implementation for Clutter::Actor chains up to the
   * parent actor and queues a redraw on the parent, thus "bubbling"
   * the redraw queue up through the actor graph. The default
   * implementation for Clutter::Stage queues a Clutter::Stage::ensure_redraw()
   * in a main loop idle handler.
   * 
   * Note that the @a origin actor may be the stage, or a container; it
   * does not have to be a leaf node in the actor graph.
   * 
   * Toolkits embedding a Clutter::Stage which require a redraw and
   * relayout cycle can stop the emission of this signal using the
   * GSignal API, redraw the UI and then call Clutter::Stage::ensure_redraw()
   * themselves, like:
   * 
   * 
   * [C example ellipted]
   * 
   * <note>This signal is emitted before the Clutter paint
   * pipeline is executed. If you want to know when the pipeline has
   * been completed you should connect to the signal_paint() signal on the
   * Stage with Glib::signal_connect_after().</note>
   * 
   * @newin{1,0}
   * @param origin The actor which initiated the redraw request.
   */

  Glib::SignalProxy1< void,const Glib::RefPtr<Actor>& > signal_queue_redaw();

  
  /**
   * @par Slot Prototype:
   * <tt>void on_my_%queue_relayout()</tt>
   *
   * The ::queue_layout signal is emitted when Clutter::Actor::queue_relayout()
   * is called on an actor.
   * 
   * The default implementation for Clutter::Actor chains up to the
   * parent actor and queues a relayout on the parent, thus "bubbling"
   * the relayout queue up through the actor graph.
   * 
   * The main purpose of this signal is to allow relayout to be propagated
   * properly in the procense of Clutter::Clone actors. Applications will
   * not normally need to connect to this signal.
   * 
   * @newin{1,2}
   */

  Glib::SignalProxy0< void > signal_queue_relayout();

  
  /**
   * @par Slot Prototype:
   * <tt>void on_my_%realize()</tt>
   *
   * The signal_realize() signal is emitted each time an actor is being
   * realized.
   * 
   * @newin{0,8}
   * 
   * Deprecated: 1.16: The signal should not be used in newly
   * written code
   */

  Glib::SignalProxy0< void > signal_realize();

  
  /**
   * @par Slot Prototype:
   * <tt>void on_my_%unrealize()</tt>
   *
   * The signal_unrealize() signal is emitted each time an actor is being
   * unrealized.
   * 
   * @newin{0,8}
   * 
   * Deprecated: 1.16: The signal should not be used in newly
   * written code
   */

  Glib::SignalProxy0< void > signal_unrealize();


  /**
   * @par Slot Prototype:
   * <tt>void on_my_%pick(const Color& color)</tt>
   *
   * The signal_pick() signal is emitted each time an actor is being painted
   * in "pick mode". The pick mode is used to identify the actor during
   * the event handling phase, or by Clutter::Stage::get_actor_at_pos().
   * The actor should paint its shape using the passed @a pick_color.
   * 
   * Subclasses of Clutter::Actor should override the class signal handler
   * and paint themselves in that function.
   * 
   * It is possible to connect a handler to the signal_pick() signal in order
   * to set up some custom aspect of a paint in pick mode.
   * 
   * @newin{1,0}
   * Deprecated: 1.12: Override the Clutter::ActorClass.pick virtual function
   * instead.
   * @param color The Clutter::Color to be used when picking.
   */

  Glib::SignalProxy1< void,const Color& > signal_pick();


  /**
   * @par Slot Prototype:
   * <tt>void on_my_%allocation_changed(const ActorBox& box, AllocationFlags flags)</tt>
   *
   * The signal_allocation_changed() signal is emitted when the
   * Clutter::Actor::property_allocation() property changes. Usually, application
   * code should just use the notifications for the :allocation property
   * but if you want to track the allocation flags as well, for instance
   * to know whether the absolute origin of @a actor changed, then you might
   * want use this signal instead.
   * 
   * @newin{1,0}
   * @param box A Clutter::ActorBox with the new allocation.
   * @param flags Clutter::AllocationFlags for the allocation.
   */

  Glib::SignalProxy2< void,const ActorBox&,AllocationFlags > signal_allocation_changed();


  //TODO: Wrap ClutterTouchEvent?
  
  /**
   * @par Slot Prototype:
   * <tt>bool on_my_%touch_event(ClutterTouchEvent* event)</tt>
   *
   * The signal_touch_event() signal is emitted each time a touch
   * begin/end/update/cancel event.
   * 
   * @newin{1,12}
   * @param event A Clutter::Event.
   * @return Clutter::EVENT_STOP if the event has been handled by
   * the actor, or Clutter::EVENT_PROPAGATE to continue the emission.
   */

  Glib::SignalProxy1< bool,ClutterTouchEvent* > signal_touch_event();


  //TODO: There might be a default handler when clutter breaks ABI:
  
  /**
   * @par Slot Prototype:
   * <tt>void on_my_%transitions_completed()</tt>
   *
   * The signal_transitions_completed() signal is emitted once all transitions
   * involving @a actor are complete.
   * 
   * @newin{1,10}
   */

  Glib::SignalProxy0< void > signal_transitions_completed();

  
  /**
   * @par Slot Prototype:
   * <tt>void on_my_%transition_stopped(const Glib::ustring& name, bool is_finished)</tt>
   *
   * The signal_transition_stopped() signal is emitted once a transition
   * is stopped; a transition is stopped once it reached its total
   * duration (including eventual repeats), it has been stopped
   * using Clutter::Timeline::stop(), or it has been removed from the
   * transitions applied on @a actor, using Clutter::Actor::remove_transition().
   * 
   * @newin{1,12}
   * @param name The name of the transition.
   * @param is_finished Whether the transition was finished, or stopped.
   */

  Glib::SignalProxy2< void,const Glib::ustring&,bool > signal_transition_stopped();


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The actor's allocation.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< ActorBox > property_allocation() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** X coordinate of the anchor point.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< float > property_anchor_x() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** X coordinate of the anchor point.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< float > property_anchor_x() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Y coordinate of the anchor point.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< float > property_anchor_y() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Y coordinate of the anchor point.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< float > property_anchor_y() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The anchor point as a ClutterGravity.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Gravity > property_anchor_gravity() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The anchor point as a ClutterGravity.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Gravity > property_anchor_gravity() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The clip region for the actor.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Geometry > property_clip() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The clip region for the actor.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Geometry > property_clip() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Sets the clip region to track the actor's allocation.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_clip_to_allocation() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Sets the clip region to track the actor's allocation.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_clip_to_allocation() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  // This property is not wrapped because it is documented in Clutter as adding, instead of just setting, a Constraint.
  //_WRAP_PROPERTY("constraints", Glib::RefPtr<Constraint>)

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Position on the Z axis.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< float > property_depth() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Position on the Z axis.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< float > property_depth() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether to use fixed positioning for the actor.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_fixed_position_set() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether to use fixed positioning for the actor.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_fixed_position_set() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Forced X position of the actor.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< float > property_fixed_x() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Forced X position of the actor.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< float > property_fixed_x() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Forced Y position of the actor.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< float > property_fixed_y() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Forced Y position of the actor.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< float > property_fixed_y() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the actor has a clip set.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_has_clip() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the actor contains the pointer of an input device.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_has_pointer() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Height of the actor.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< float > property_height() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Height of the actor.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< float > property_height() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Forced minimum height request for the actor.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< float > property_min_height() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Forced minimum height request for the actor.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< float > property_min_height() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether to use the min-height property.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_min_height_set() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether to use the min-height property.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_min_height_set() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Forced minimum width request for the actor.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< float > property_min_width() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Forced minimum width request for the actor.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< float > property_min_width() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether to use the min-width property.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_min_width_set() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether to use the min-width property.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_min_width_set() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Name of the actor.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::ustring > property_name() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Name of the actor.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::ustring > property_name() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Opacity of an actor.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< guint8 > property_opacity() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Opacity of an actor.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< guint8 > property_opacity() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the actor is reactive to events.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_reactive() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the actor is reactive to events.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_reactive() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The actor's request mode.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< RequestMode > property_request_mode() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The actor's request mode.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< RequestMode > property_request_mode() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The rotation angle on the X axis.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< double > property_rotation_angle_x() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The rotation angle on the X axis.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< double > property_rotation_angle_x() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The rotation angle on the Y axis.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< double > property_rotation_angle_y() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The rotation angle on the Y axis.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< double > property_rotation_angle_y() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The rotation angle on the Z axis.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< double > property_rotation_angle_z() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The rotation angle on the Z axis.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< double > property_rotation_angle_z() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The rotation center on the X axis.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Vertex > property_rotation_center_x() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The rotation center on the X axis.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Vertex > property_rotation_center_x() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The rotation center on the Y axis.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Vertex > property_rotation_center_y() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The rotation center on the Y axis.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Vertex > property_rotation_center_y() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The rotation center on the Z axis.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Vertex > property_rotation_center_z() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The rotation center on the Z axis.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Vertex > property_rotation_center_z() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Center point for rotation around the Z axis.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Gravity > property_rotation_center_z_gravity() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Center point for rotation around the Z axis.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Gravity > property_rotation_center_z_gravity() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Scale factor on the X axis.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< double > property_scale_x() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Scale factor on the X axis.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< double > property_scale_x() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Scale factor on the Y axis.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< double > property_scale_y() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Scale factor on the Y axis.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< double > property_scale_y() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Horizontal scale center.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< double > property_scale_center_x() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Horizontal scale center.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< double > property_scale_center_x() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Vertical scale center.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< double > property_scale_center_y() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Vertical scale center.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< double > property_scale_center_y() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The center of scaling.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Gravity > property_scale_gravity() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The center of scaling.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Gravity > property_scale_gravity() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the actor is shown when parented.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_show_on_set_parent() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the actor is shown when parented.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_show_on_set_parent() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Direction of the text.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< TextDirection > property_text_direction() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Direction of the text.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< TextDirection > property_text_direction() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the actor is visible or not.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_visible() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the actor is visible or not.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_visible() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Width of the actor.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< float > property_width() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Width of the actor.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< float > property_width() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** X coordinate of the actor.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< float > property_x() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** X coordinate of the actor.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< float > property_x() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The alignment of the actor on the X axis within its allocation.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< ActorAlign > property_x_align() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The alignment of the actor on the X axis within its allocation.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< ActorAlign > property_x_align() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether extra horizontal space should be assigned to the actor.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_x_expand() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether extra horizontal space should be assigned to the actor.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_x_expand() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Y coordinate of the actor.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< float > property_y() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Y coordinate of the actor.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< float > property_y() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The alignment of the actor on the Y axis within its allocation.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< ActorAlign > property_y_align() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The alignment of the actor on the Y axis within its allocation.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< ActorAlign > property_y_align() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether extra vertical space should be assigned to the actor.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_y_expand() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether extra vertical space should be assigned to the actor.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_y_expand() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


protected:
  //TODO: Wrap ClutterShaderEffect.
  
#ifndef CLUTTERMM_DISABLE_DEPRECATED

  /** Sets the value for a named parameter of the shader applied
   * to @a actor.
   * 
   * @newin{1,0}
   * 
   * Deprecated: 1.8: Use Clutter::ShaderEffect::set_uniform_value() instead
   * @deprecated Use ShaderEffect::set_uniform_value() instead.
   * @param param The name of the parameter.
   * @param value The value of the parameter.
   */
  void set_shader_param_value(const Glib::ustring& param, const Glib::ValueBase& value);
#endif // CLUTTERMM_DISABLE_DEPRECATED


  //TODO: These are deprecated. Remove them when we can break ABI:
    virtual void show_all_vfunc();

    virtual void hide_all_vfunc();


  //The realize and unrealize vfuncs are deprecated.

    virtual void map_vfunc();

    virtual void unmap_vfunc();

    virtual void paint_vfunc();


  // TODO: I think we need to hand-code the vfuncs if we need to handle
  // the float* being NULL.
   

    virtual void get_preferred_width_vfunc(float for_height, float& min_width_p, float& natural_width_p) const;

    virtual void get_preferred_height_vfunc(float for_width, float& min_height_p, float& natural_height_p) const;

    virtual void allocate_vfunc(const ActorBox& box, AllocationFlags absolute_origin_changed);


    virtual void pick_vfunc(const Color& color);


  //TODO: _WRAP_VFUNC(Glib::RefPtr<Gtk::Object> get_accessible(), get_accessible)
  //TODO: Wrap ClutterPaintVolume?
    virtual bool get_paint_volume_vfunc(ClutterPaintVolume* volume);


    virtual bool has_overlaps_vfunc() const;


  //TODO: Wrap ClutterPaintNode*?
    virtual void paint_node_vfunc(ClutterPaintNode* root);


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::
  /// This is a default handler for the signal signal_button_press_event().
  virtual bool on_button_press_event(ButtonEvent* event);
  /// This is a default handler for the signal signal_button_release_event().
  virtual bool on_button_release_event(ButtonEvent* event);
  /// This is a default handler for the signal signal_motion_event().
  virtual bool on_motion_event(MotionEvent* event);
  /// This is a default handler for the signal signal_leave_event().
  virtual bool on_leave_event(CrossingEvent* event);
  /// This is a default handler for the signal signal_show().
  virtual void on_show();
  /// This is a default handler for the signal signal_hide().
  virtual void on_hide();
  /// This is a default handler for the signal signal_destroy().
  virtual void on_destroy();
  /// This is a default handler for the signal signal_key_release_event().
  virtual bool on_key_release_event(KeyEvent* event);
  /// This is a default handler for the signal signal_enter_event().
  virtual bool on_enter_event(CrossingEvent* event);
  /// This is a default handler for the signal signal_event().
  virtual bool on_event(Event* event);
  /// This is a default handler for the signal signal_key_focus_out().
  virtual void on_key_focus_out();
  /// This is a default handler for the signal signal_key_focus_in().
  virtual void on_key_focus_in();
  /// This is a default handler for the signal signal_parent_set().
  virtual void on_parent_set(const Glib::RefPtr<Actor>& old_parent);
  /// This is a default handler for the signal signal_scroll_event().
  virtual bool on_scroll_event(ScrollEvent* event);
  /// This is a default handler for the signal signal_key_press_event().
  virtual bool on_key_press_event(KeyEvent* event);
  /// This is a default handler for the signal signal_captured_event().
  virtual bool on_captured_event(Event* event);
  /// This is a default handler for the signal signal_paint().
  virtual void on_paint();
  /// This is a default handler for the signal signal_queue_redaw().
  virtual void on_queue_redaw(const Glib::RefPtr<Actor>& origin);
  /// This is a default handler for the signal signal_queue_relayout().
  virtual void on_queue_relayout();
  /// This is a default handler for the signal signal_realize().
  virtual void on_realize();
  /// This is a default handler for the signal signal_unrealize().
  virtual void on_unrealize();
  /// This is a default handler for the signal signal_pick().
  virtual void on_pick(const Color& color);
  /// This is a default handler for the signal signal_touch_event().
  virtual bool on_touch_event(ClutterTouchEvent* event);


};

#ifndef CLUTTERMM_DISABLE_DEPRECATED

#ifndef DOXYGEN_SHOULD_SKIP_THIS
template <class ParamType>
void Actor::set_shader_param(const Glib::ustring& param, const ParamType& value)
{
  Glib::Value<ParamType> param_value;
  param_value.init(Glib::Value<ParamType>::value_type());

  param_value.set(value);
  this->set_shader_param_value(param, param_value);
}
#endif /* DOXYGEN_SHOULD_SKIP_THIS */
#endif // CLUTTERMM_DISABLE_DEPRECATED


} // namespace Clutter


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Clutter::Actor
   */
  Glib::RefPtr<Clutter::Actor> wrap(ClutterActor* object, bool take_copy = false);
}


#endif /* _CLUTTERMM_ACTOR_H */

