<?xml version='1.0' encoding='ISO-8859-1' standalone='yes' ?>
<tagfile>
  <compound kind="page">
    <name>index</name>
    <title>cluttermm Reference Manual</title>
    <filename>index</filename>
    <docanchor file="index">basics</docanchor>
    <docanchor file="index">description</docanchor>
  </compound>
  <compound kind="group">
    <name>cluttermmEnums</name>
    <title>cluttermm Enums and Flags</title>
    <filename>group__cluttermmEnums.html</filename>
    <member kind="enumeration">
      <name>ActorFlags</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>ga3676cd0c391cde417f43e483034021aa</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ACTOR_MAPPED</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>gga3676cd0c391cde417f43e483034021aaa93f6c9917d806391cf27300003537435</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ACTOR_REALIZED</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>gga3676cd0c391cde417f43e483034021aaa90069b4cbc2f344ddb8a9af89145d6d4</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ACTOR_REACTIVE</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>gga3676cd0c391cde417f43e483034021aaaea886dddd9cbf83c7b568b4a3fdd1a2c</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ACTOR_VISIBLE</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>gga3676cd0c391cde417f43e483034021aaac6f01d312c9b060c2f110d6013ba6b97</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ACTOR_NO_LAYOUT</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>gga3676cd0c391cde417f43e483034021aaa7e5beecfa77d896bb2af0ec15dd5f564</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>AllocationFlags</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>ga023a2533b794fe872cdb57219addd4a9</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ALLOCATION_NONE</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>gga023a2533b794fe872cdb57219addd4a9ae3c2556244173fbd6cb113e5d373e87e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ABSOLUTE_ORIGIN_CHANGED</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>gga023a2533b794fe872cdb57219addd4a9a962e549fc80d95d371e6f13ed2dbd876</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>Interpolation</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>gae2bd1c083b7dd5b23c9009bfa8d0e0c6</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>INTERPOLATION_LINEAR</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>ggae2bd1c083b7dd5b23c9009bfa8d0e0c6aceb0fbcba7c82b029eccab970a9c0fc0</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>INTERPOLATION_CUBIC</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>ggae2bd1c083b7dd5b23c9009bfa8d0e0c6a22b14e0a13c00d4b1edd15f7875a1c50</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>BinAlignment</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>gab5645f3338aee331b3be1646f56ddda5</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>BIN_ALIGNMENT_FIXED</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>ggab5645f3338aee331b3be1646f56ddda5afcfbd6055efb1054f6887604dbc6282d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>BIN_ALIGNMENT_FILL</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>ggab5645f3338aee331b3be1646f56ddda5a3b8a22ff438973a25102229491e1c369</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>BIN_ALIGNMENT_START</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>ggab5645f3338aee331b3be1646f56ddda5aaa564c62d088c28f439b71840a33730a</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>BIN_ALIGNMENT_END</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>ggab5645f3338aee331b3be1646f56ddda5aaa87acff355b373ce7bdc138c641a130</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>BIN_ALIGNMENT_CENTER</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>ggab5645f3338aee331b3be1646f56ddda5a88d1a757afa0ec84ce8ae184dfe0cde9</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>BoxAlignment</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>ga2cfb791fd49509cf09c4a32f8b5d4808</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>BOX_ALIGNMENT_START</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>gga2cfb791fd49509cf09c4a32f8b5d4808a46840cbd7af99e840fc9fa6822991eb8</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>BOX_ALIGNMENT_END</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>gga2cfb791fd49509cf09c4a32f8b5d4808a3a80a3f1f36042d4bf9fb6f390df6253</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>BOX_ALIGNMENT_CENTER</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>gga2cfb791fd49509cf09c4a32f8b5d4808a4d8a5c65cf9314a4cfdef478c9b7fb63</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>FlowOrientation</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>ga35ecb603f62778df7cd01125dd5687da</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FLOW_HORIZONTAL</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>gga35ecb603f62778df7cd01125dd5687daaa3c5850e173b91a5a931c981399948b1</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FLOW_VERTICAL</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>gga35ecb603f62778df7cd01125dd5687daa6073aba7ffe87c844a0d60485e683b0d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>InputDeviceType</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>ga7a893498c94740925e6f255273c76da8</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>POINTER_DEVICE</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>gga7a893498c94740925e6f255273c76da8a9d546e38b4125bbc9a41451cd4dbb474</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>KEYBOARD_DEVICE</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>gga7a893498c94740925e6f255273c76da8aea26a5d88dc2788a0ec959466ea526ce</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>EXTENSION_DEVICE</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>gga7a893498c94740925e6f255273c76da8aa827a3704a5e186ace0dc40d88aed070</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>N_DEVICE_TYPES</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>gga7a893498c94740925e6f255273c76da8ae0330eedf9e6ae1b7365beeb1980008d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>PickMode</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>ga9fba732a6f372b8adad8eb4e18b642ac</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PICK_NONE</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>gga9fba732a6f372b8adad8eb4e18b642aca6782c0648f20b59bb27d64c7577c7bd1</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PICK_REACTIVE</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>gga9fba732a6f372b8adad8eb4e18b642aca0cec83e1263ace2ccfcace8f4efb5a73</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PICK_ALL</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>gga9fba732a6f372b8adad8eb4e18b642acadfc156f5153055a708c9e2edd588f2e7</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>TextureFlags</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>ga33c7c0f8d0bebfe65a6d7394b93e029a</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>TEXTURE_NONE</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>gga33c7c0f8d0bebfe65a6d7394b93e029aa848496eeff61784a643ab29258115757</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>TEXTURE_RGB_FLAG_BGR</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>gga33c7c0f8d0bebfe65a6d7394b93e029aa970e4b9bbc6fa5395b0cedece219d373</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>TEXTURE_RGB_FLAG_PREMULT</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>gga33c7c0f8d0bebfe65a6d7394b93e029aab919a84687f5e15ef372cff0bf24c256</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>TEXTURE_YUV_FLAG_YUV2</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>gga33c7c0f8d0bebfe65a6d7394b93e029aa7c34a36c82fdd1e0a6c9e9251c16e0b4</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>TextureQuality</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>gab7eeab1d1d6a5024d9b8e954745fb277</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>TEXTURE_QUALITY_LOW</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>ggab7eeab1d1d6a5024d9b8e954745fb277a8166313842c33698b6f6514fd3065d24</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>TEXTURE_QUALITY_MEDIUM</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>ggab7eeab1d1d6a5024d9b8e954745fb277adf91e9c0115959c6f665733786ba940c</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>TEXTURE_QUALITY_HIGH</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>ggab7eeab1d1d6a5024d9b8e954745fb277a68c412b6222215e13ce3984ce8b4f17d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>TimelineDirection</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>gac63a039bf5143c3efe0a4620e8d550bf</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>TIMELINE_FORWARD</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>ggac63a039bf5143c3efe0a4620e8d550bfab088eda9ac6e91207d2379ce8419b432</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>TIMELINE_BACKWARD</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>ggac63a039bf5143c3efe0a4620e8d550bfaf90061e1523ce9192868fafdce77ba3f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>AnimationMode</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>ga17e6c1b47abef11eac045c2c19c63198</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>CUSTOM_MODE</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>gga17e6c1b47abef11eac045c2c19c63198a0a6a0614dba7fae3934995a641c543df</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>LINEAR</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>gga17e6c1b47abef11eac045c2c19c63198a01dc8aebee31bfaea27e2076883fc9c4</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>EASE_IN_QUAD</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>gga17e6c1b47abef11eac045c2c19c63198a42378395b98df3316d63acc9cbdc85f9</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>EASE_OUT_QUAD</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>gga17e6c1b47abef11eac045c2c19c63198a8f30a8b8cd6e2f5cb5beb6550de11d0b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>EASE_IN_OUT_QUAD</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>gga17e6c1b47abef11eac045c2c19c63198a2a70b40df026c64fd4f1d84627e7cb0e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>EASE_IN_CUBIC</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>gga17e6c1b47abef11eac045c2c19c63198a0f51d647af30e74041e5409e7d1a0750</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>EASE_OUT_CUBIC</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>gga17e6c1b47abef11eac045c2c19c63198a081b0396b26920ac8eecf6a5242a1520</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>EASE_IN_OUT_CUBIC</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>gga17e6c1b47abef11eac045c2c19c63198ad7051a6dc28b30da265943d91b2596ca</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>EASE_IN_QUART</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>gga17e6c1b47abef11eac045c2c19c63198a2d48339d11a8b4e089a0db4fbf012101</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>EASE_OUT_QUART</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>gga17e6c1b47abef11eac045c2c19c63198a307d9cbcc33e6b292d79ef6070ad9b81</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>EASE_IN_OUT_QUART</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>gga17e6c1b47abef11eac045c2c19c63198a0325064fc77fdd2a0441a25e0699d964</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>EASE_IN_QUINT</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>gga17e6c1b47abef11eac045c2c19c63198a69fc62d657b023585f7a30c84a94ae68</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>EASE_OUT_QUINT</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>gga17e6c1b47abef11eac045c2c19c63198a1f543ae5ff90fdf7bbac11395d76fb7c</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>EASE_IN_OUT_QUINT</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>gga17e6c1b47abef11eac045c2c19c63198ac38cb11ebef684fcb75b29092b00e27f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>EASE_IN_SINE</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>gga17e6c1b47abef11eac045c2c19c63198ab5e95d5c172502fc29349296df3b9457</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>EASE_OUT_SINE</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>gga17e6c1b47abef11eac045c2c19c63198ae92a074a2e6cd23105a9b3fdd5e9851a</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>EASE_IN_OUT_SINE</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>gga17e6c1b47abef11eac045c2c19c63198a419f112b4102abe7f4a091c6bc590290</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>EASE_IN_EXPO</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>gga17e6c1b47abef11eac045c2c19c63198aaf56f106f612e9cd03dba38b71a35ae2</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>EASE_OUT_EXPO</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>gga17e6c1b47abef11eac045c2c19c63198a0c781eb84c9a9252bcc8f79b4fc748b6</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>EASE_IN_OUT_EXPO</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>gga17e6c1b47abef11eac045c2c19c63198a0bb43835bfcb09e85a7bc20ebdbc5872</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>EASE_IN_CIRC</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>gga17e6c1b47abef11eac045c2c19c63198ab0d5e890947489132eb24826b3292534</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>EASE_OUT_CIRC</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>gga17e6c1b47abef11eac045c2c19c63198a9f04f9ed89e48a95094354ed4c0e6a74</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>EASE_IN_OUT_CIRC</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>gga17e6c1b47abef11eac045c2c19c63198adfe743c1966d374ed7820cdabe4ae9d4</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>EASE_IN_ELASTIC</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>gga17e6c1b47abef11eac045c2c19c63198ae576178c5adbdb1851d49e532f08490a</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>EASE_OUT_ELASTIC</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>gga17e6c1b47abef11eac045c2c19c63198a64861bcfb9c7ce85239950fb48a1b787</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>EASE_IN_OUT_ELASTIC</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>gga17e6c1b47abef11eac045c2c19c63198a065a1accbc0cc24819b9f9b1a7a39d04</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>EASE_IN_BACK</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>gga17e6c1b47abef11eac045c2c19c63198a95f771cc8de56432647a5e6e3071508b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>EASE_OUT_BACK</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>gga17e6c1b47abef11eac045c2c19c63198aefce9f29f9de054f4b59aced5303e983</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>EASE_IN_OUT_BACK</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>gga17e6c1b47abef11eac045c2c19c63198a7367f0aedc181aff2882a6e1bfd852cc</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>EASE_IN_BOUNCE</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>gga17e6c1b47abef11eac045c2c19c63198aeea8bf08d2af517a6dd4d0c081a96c8e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>EASE_OUT_BOUNCE</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>gga17e6c1b47abef11eac045c2c19c63198a906b803287a8f0e973eaf958b1636293</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>EASE_IN_OUT_BOUNCE</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>gga17e6c1b47abef11eac045c2c19c63198a531681b4ac13eeb60f1d53556fe1d8fe</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ANIMATION_LAST</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>gga17e6c1b47abef11eac045c2c19c63198a34a1ac965155005a5d1c55b4c68eeecb</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>RotateDirection</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>ga5b204af046360b6dbd6395a0d9c0766a</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ROTATE_CW</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>gga5b204af046360b6dbd6395a0d9c0766aa73602c23932e4aea767bd32139528d79</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ROTATE_CCW</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>gga5b204af046360b6dbd6395a0d9c0766aaff70538d6bc08d0b2bc78597b54688ce</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>RotateAxis</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>gad4904567ffd946e5c9ddd3615cd77dae</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>X_AXIS</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>ggad4904567ffd946e5c9ddd3615cd77daeaa3e138ffe36ff846fb84b0a1b0b403b3</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>Y_AXIS</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>ggad4904567ffd946e5c9ddd3615cd77daea46ecf3ae5af90b10d598200f32f63014</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>Z_AXIS</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>ggad4904567ffd946e5c9ddd3615cd77daea1b593634a6bb04d4097ab71844585203</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>Gravity</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>gafc761d383119dc9f5af8b1cb329b6c1c</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>GRAVITY_NONE</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>ggafc761d383119dc9f5af8b1cb329b6c1caf48d5e460ffa71e59f788fb4c5950958</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>GRAVITY_NORTH</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>ggafc761d383119dc9f5af8b1cb329b6c1ca4af51dc4a36985ffc5eb9a8a7e461367</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>GRAVITY_NORTH_EAST</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>ggafc761d383119dc9f5af8b1cb329b6c1ca220f6ff79f3425ab2be4dbebc6b38707</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>GRAVITY_EAST</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>ggafc761d383119dc9f5af8b1cb329b6c1ca0127164beceff2784b889429b4dff598</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>GRAVITY_SOUTH_EAST</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>ggafc761d383119dc9f5af8b1cb329b6c1caa62471d85dacb5b7a81646fcb6370f06</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>GRAVITY_SOUTH</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>ggafc761d383119dc9f5af8b1cb329b6c1cafb5bbb20f2c4ddcae27f01fd36973129</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>GRAVITY_SOUTH_WEST</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>ggafc761d383119dc9f5af8b1cb329b6c1ca4d535e4981ff9f219d2c4e2c102ecd56</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>GRAVITY_WEST</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>ggafc761d383119dc9f5af8b1cb329b6c1ca31c68df75724496573c6337b70a37bd4</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>GRAVITY_NORTH_WEST</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>ggafc761d383119dc9f5af8b1cb329b6c1ca4e548e058eafa96dbe486610579416b0</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>GRAVITY_CENTER</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>ggafc761d383119dc9f5af8b1cb329b6c1ca6c65457af9e6738e8b322cfe9da445d4</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>RequestMode</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>ga1351cc99f04fe4cfb4238eb340b44c9a</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>REQUEST_HEIGHT_FOR_WIDTH</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>gga1351cc99f04fe4cfb4238eb340b44c9aaf57a399ae090202446057d348ae666a9</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>REQUEST_WIDTH_FOR_HEIGHT</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>gga1351cc99f04fe4cfb4238eb340b44c9aadbb97f76af00931bfee994cf0231be83</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>FontFlags</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>gac7579b3df6963b5a0c15efa2f54ed38c</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FONT_MIPMAPPING</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>ggac7579b3df6963b5a0c15efa2f54ed38ca3699bc3b7950c89313ba524cdc5c6057</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FONT_HINTING</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>ggac7579b3df6963b5a0c15efa2f54ed38cac05bbc35682ceb8a06d5cf1f3c7e04e3</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>TextDirection</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>gac2a674a9ab8d1937fc4e02d5b092289e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>TEXT_DIRECTION_DEFAULT</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>ggac2a674a9ab8d1937fc4e02d5b092289ea64bbce6bf9c55dff7d1e42b718e2c125</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>TEXT_DIRECTION_LTR</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>ggac2a674a9ab8d1937fc4e02d5b092289ea3930b0ca1abb395a2e9b175eb8e7a854</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>TEXT_DIRECTION_RTL</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>ggac2a674a9ab8d1937fc4e02d5b092289ea1db45eb435cae08d2c9e5ba120ab5dc9</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>ActorFlags</type>
      <name>operator|</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>ga719936ad8913cf83d658fe13d9a86f53</anchor>
      <arglist>(ActorFlags lhs, ActorFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>ActorFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>gafc0df2161e741be215b49129f95f09d2</anchor>
      <arglist>(ActorFlags lhs, ActorFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>ActorFlags</type>
      <name>operator^</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>ga066c399d91a36365d0f09e09d7258eaa</anchor>
      <arglist>(ActorFlags lhs, ActorFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>ActorFlags</type>
      <name>operator~</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>ga0ef21380c30bb15294dc76c1703963bc</anchor>
      <arglist>(ActorFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>ActorFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>ga7ab038eb77ab9c81fe68dda1bc1db284</anchor>
      <arglist>(ActorFlags &amp;lhs, ActorFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>ActorFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>gaab36bc099a028ff2aaa267466bfc4b8e</anchor>
      <arglist>(ActorFlags &amp;lhs, ActorFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>ActorFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>gab3ac52485a7854c998a5bfefc727d17e</anchor>
      <arglist>(ActorFlags &amp;lhs, ActorFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>AllocationFlags</type>
      <name>operator|</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>ga72f9b8e17fc76f28e88d7c33f19689e3</anchor>
      <arglist>(AllocationFlags lhs, AllocationFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>AllocationFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>ga8ec9cc3d45bc8f87481e977a4a04967a</anchor>
      <arglist>(AllocationFlags lhs, AllocationFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>AllocationFlags</type>
      <name>operator^</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>gad2012dfec3d188d826342277ae874898</anchor>
      <arglist>(AllocationFlags lhs, AllocationFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>AllocationFlags</type>
      <name>operator~</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>ga2382e036c49ae8ca99cb36e7ca2ea9b6</anchor>
      <arglist>(AllocationFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>AllocationFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>ga541c185ec5cb34fb8f699f476182e1c6</anchor>
      <arglist>(AllocationFlags &amp;lhs, AllocationFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>AllocationFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>ga6e66e74194c73fc5f123ef49d9824a84</anchor>
      <arglist>(AllocationFlags &amp;lhs, AllocationFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>AllocationFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>ga56a3d9e660b22fcfb653578ca2b02459</anchor>
      <arglist>(AllocationFlags &amp;lhs, AllocationFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>TextureFlags</type>
      <name>operator|</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>gaee0b5ed2fe8589b48ca872d4eacbde44</anchor>
      <arglist>(TextureFlags lhs, TextureFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>TextureFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>ga8cf05791bd696a3f508cad90a088023c</anchor>
      <arglist>(TextureFlags lhs, TextureFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>TextureFlags</type>
      <name>operator^</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>ga90c41d7fc8d591fe52dfd1384608c2ff</anchor>
      <arglist>(TextureFlags lhs, TextureFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>TextureFlags</type>
      <name>operator~</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>ga32fef17ac294e73eabc0d62cbaf228a4</anchor>
      <arglist>(TextureFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>TextureFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>ga0fc9707064e18f127946ebc620e22589</anchor>
      <arglist>(TextureFlags &amp;lhs, TextureFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>TextureFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>ga0a35d50ac54664360e062506b9423d43</anchor>
      <arglist>(TextureFlags &amp;lhs, TextureFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>TextureFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>ga53cdf987cac7f3f621a3a646eb823951</anchor>
      <arglist>(TextureFlags &amp;lhs, TextureFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FontFlags</type>
      <name>operator|</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>gadca204f8368633ac31d634930b69e6ff</anchor>
      <arglist>(FontFlags lhs, FontFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FontFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>ga363e6c5043beccf9f8a76659b2d948c6</anchor>
      <arglist>(FontFlags lhs, FontFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FontFlags</type>
      <name>operator^</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>gab6d70b628ce402a5dba5f674ebb7618e</anchor>
      <arglist>(FontFlags lhs, FontFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FontFlags</type>
      <name>operator~</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>ga9e03050decf6a07788932491adc9d2ad</anchor>
      <arglist>(FontFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>FontFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>ga6f8748e53c4cebc7be02dbbe4fe3c047</anchor>
      <arglist>(FontFlags &amp;lhs, FontFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FontFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>ga375ae5110dd5ad98c83a04c6a06b7305</anchor>
      <arglist>(FontFlags &amp;lhs, FontFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FontFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>gac458380be7f8178a345f47ef6f2af8df</anchor>
      <arglist>(FontFlags &amp;lhs, FontFlags rhs)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glib::Error</name>
    <filename>classGlib_1_1Error.html</filename>
  </compound>
  <compound kind="class">
    <name>Glib::Interface</name>
    <filename>classGlib_1_1Interface.html</filename>
  </compound>
  <compound kind="class">
    <name>Glib::Object</name>
    <filename>classGlib_1_1Object.html</filename>
  </compound>
  <compound kind="namespace">
    <name>Clutter</name>
    <filename>namespaceClutter.html</filename>
    <namespace>Clutter::Cairo</namespace>
    <class kind="class">Clutter::ActorBox</class>
    <class kind="class">Clutter::Actor</class>
    <class kind="class">Clutter::Alpha</class>
    <class kind="class">Clutter::Animation</class>
    <class kind="class">Clutter::Animator</class>
    <class kind="class">Clutter::Backend</class>
    <class kind="class">Clutter::Behaviour</class>
    <class kind="class">Clutter::BehaviourDepth</class>
    <class kind="class">Clutter::BehaviourEllipse</class>
    <class kind="class">Clutter::BehaviourOpacity</class>
    <class kind="class">Clutter::BehaviourPath</class>
    <class kind="class">Clutter::BehaviourRotate</class>
    <class kind="class">Clutter::BehaviourScale</class>
    <class kind="class">Clutter::BinLayout</class>
    <class kind="class">Clutter::Box</class>
    <class kind="class">Clutter::BoxLayout</class>
    <class kind="class">Clutter::ChildMeta</class>
    <class kind="class">Clutter::Clone</class>
    <class kind="class">Clutter::Color</class>
    <class kind="class">Clutter::Container</class>
    <class kind="class">Clutter::DeviceManager</class>
    <class kind="class">Clutter::FixedLayout</class>
    <class kind="class">Clutter::FlowLayout</class>
    <class kind="class">Clutter::Group</class>
    <class kind="class">Clutter::InputDevice</class>
    <class kind="class">Clutter::Interval</class>
    <class kind="class">Clutter::LayoutMeta</class>
    <class kind="class">Clutter::LayoutManager</class>
    <class kind="class">Clutter::Media</class>
    <class kind="class">Clutter::PathNode</class>
    <class kind="class">Clutter::Path</class>
    <class kind="class">Clutter::Rectangle</class>
    <class kind="class">Clutter::Score</class>
    <class kind="class">Clutter::Script</class>
    <class kind="class">Clutter::Scriptable</class>
    <class kind="class">Clutter::Shader</class>
    <class kind="class">Clutter::Perspective</class>
    <class kind="class">Clutter::Stage</class>
    <class kind="class">Clutter::Text</class>
    <class kind="class">Clutter::TextureError</class>
    <class kind="class">Clutter::Texture</class>
    <class kind="class">Clutter::Timeline</class>
    <class kind="class">Clutter::InitError</class>
    <class kind="class">Clutter::Vertex</class>
    <class kind="class">Clutter::Geometry</class>
    <class kind="class">Clutter::Knot</class>
    <member kind="typedef">
      <type>ClutterFog</type>
      <name>Fog</name>
      <anchorfile>namespaceClutter.html</anchorfile>
      <anchor>a8cd946b526dee096aba1188e5efa8dd9</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>ClutterEvent</type>
      <name>Event</name>
      <anchorfile>namespaceClutter.html</anchorfile>
      <anchor>ae276f073c26372f1ff2f427a0671a295</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>ClutterButtonEvent</type>
      <name>ButtonEvent</name>
      <anchorfile>namespaceClutter.html</anchorfile>
      <anchor>ae420fb14758a54c95f9c2d86562e5450</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>ClutterKeyEvent</type>
      <name>KeyEvent</name>
      <anchorfile>namespaceClutter.html</anchorfile>
      <anchor>a334be3c4cf21610aa4fa5dcfa843ffff</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>ClutterMotionEvent</type>
      <name>MotionEvent</name>
      <anchorfile>namespaceClutter.html</anchorfile>
      <anchor>a83fd5932cb5049596ae63cc59c038a02</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>ClutterScrollEvent</type>
      <name>ScrollEvent</name>
      <anchorfile>namespaceClutter.html</anchorfile>
      <anchor>a38ff80551e9619c2f5783d8c2811a218</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>ClutterCrossingEvent</type>
      <name>CrossingEvent</name>
      <anchorfile>namespaceClutter.html</anchorfile>
      <anchor>a8a5822cd6264af95ef36395ed4ca6ef1</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>ActorFlags</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>ga3676cd0c391cde417f43e483034021aa</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ACTOR_MAPPED</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>gga3676cd0c391cde417f43e483034021aaa93f6c9917d806391cf27300003537435</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ACTOR_REALIZED</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>gga3676cd0c391cde417f43e483034021aaa90069b4cbc2f344ddb8a9af89145d6d4</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ACTOR_REACTIVE</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>gga3676cd0c391cde417f43e483034021aaaea886dddd9cbf83c7b568b4a3fdd1a2c</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ACTOR_VISIBLE</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>gga3676cd0c391cde417f43e483034021aaac6f01d312c9b060c2f110d6013ba6b97</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ACTOR_NO_LAYOUT</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>gga3676cd0c391cde417f43e483034021aaa7e5beecfa77d896bb2af0ec15dd5f564</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>AllocationFlags</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>ga023a2533b794fe872cdb57219addd4a9</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ALLOCATION_NONE</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>gga023a2533b794fe872cdb57219addd4a9ae3c2556244173fbd6cb113e5d373e87e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ABSOLUTE_ORIGIN_CHANGED</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>gga023a2533b794fe872cdb57219addd4a9a962e549fc80d95d371e6f13ed2dbd876</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>Interpolation</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>gae2bd1c083b7dd5b23c9009bfa8d0e0c6</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>INTERPOLATION_LINEAR</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>ggae2bd1c083b7dd5b23c9009bfa8d0e0c6aceb0fbcba7c82b029eccab970a9c0fc0</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>INTERPOLATION_CUBIC</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>ggae2bd1c083b7dd5b23c9009bfa8d0e0c6a22b14e0a13c00d4b1edd15f7875a1c50</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>BinAlignment</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>gab5645f3338aee331b3be1646f56ddda5</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>BIN_ALIGNMENT_FIXED</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>ggab5645f3338aee331b3be1646f56ddda5afcfbd6055efb1054f6887604dbc6282d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>BIN_ALIGNMENT_FILL</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>ggab5645f3338aee331b3be1646f56ddda5a3b8a22ff438973a25102229491e1c369</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>BIN_ALIGNMENT_START</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>ggab5645f3338aee331b3be1646f56ddda5aaa564c62d088c28f439b71840a33730a</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>BIN_ALIGNMENT_END</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>ggab5645f3338aee331b3be1646f56ddda5aaa87acff355b373ce7bdc138c641a130</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>BIN_ALIGNMENT_CENTER</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>ggab5645f3338aee331b3be1646f56ddda5a88d1a757afa0ec84ce8ae184dfe0cde9</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>BoxAlignment</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>ga2cfb791fd49509cf09c4a32f8b5d4808</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>BOX_ALIGNMENT_START</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>gga2cfb791fd49509cf09c4a32f8b5d4808a46840cbd7af99e840fc9fa6822991eb8</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>BOX_ALIGNMENT_END</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>gga2cfb791fd49509cf09c4a32f8b5d4808a3a80a3f1f36042d4bf9fb6f390df6253</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>BOX_ALIGNMENT_CENTER</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>gga2cfb791fd49509cf09c4a32f8b5d4808a4d8a5c65cf9314a4cfdef478c9b7fb63</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>FlowOrientation</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>ga35ecb603f62778df7cd01125dd5687da</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FLOW_HORIZONTAL</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>gga35ecb603f62778df7cd01125dd5687daaa3c5850e173b91a5a931c981399948b1</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FLOW_VERTICAL</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>gga35ecb603f62778df7cd01125dd5687daa6073aba7ffe87c844a0d60485e683b0d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>InputDeviceType</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>ga7a893498c94740925e6f255273c76da8</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>POINTER_DEVICE</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>gga7a893498c94740925e6f255273c76da8a9d546e38b4125bbc9a41451cd4dbb474</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>KEYBOARD_DEVICE</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>gga7a893498c94740925e6f255273c76da8aea26a5d88dc2788a0ec959466ea526ce</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>EXTENSION_DEVICE</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>gga7a893498c94740925e6f255273c76da8aa827a3704a5e186ace0dc40d88aed070</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>N_DEVICE_TYPES</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>gga7a893498c94740925e6f255273c76da8ae0330eedf9e6ae1b7365beeb1980008d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>PathNodeType</name>
      <anchorfile>namespaceClutter.html</anchorfile>
      <anchor>a8510c318bbb108f18660ac1495658fae</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PATH_MOVE_TO</name>
      <anchorfile>namespaceClutter.html</anchorfile>
      <anchor>a8510c318bbb108f18660ac1495658faea5838121a1c3e603e6c25d5aea994e942</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PATH_LINE_TO</name>
      <anchorfile>namespaceClutter.html</anchorfile>
      <anchor>a8510c318bbb108f18660ac1495658faea3d163bb488430c29d66ffda50af2a8fd</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PATH_CURVE_TO</name>
      <anchorfile>namespaceClutter.html</anchorfile>
      <anchor>a8510c318bbb108f18660ac1495658faeab816a06e7b0f2be92067f94194c23d18</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PATH_CLOSE</name>
      <anchorfile>namespaceClutter.html</anchorfile>
      <anchor>a8510c318bbb108f18660ac1495658faea04d241f7f01f9da7661718605c66bfb9</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PATH_REL_MOVE_TO</name>
      <anchorfile>namespaceClutter.html</anchorfile>
      <anchor>a8510c318bbb108f18660ac1495658faea8a25c5639c6aec9e48a49818f1d920c2</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PATH_REL_LINE_TO</name>
      <anchorfile>namespaceClutter.html</anchorfile>
      <anchor>a8510c318bbb108f18660ac1495658faead859f09fe7663753e43b585a0e3ab4bf</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PATH_REL_CURVE_TO</name>
      <anchorfile>namespaceClutter.html</anchorfile>
      <anchor>a8510c318bbb108f18660ac1495658faeac5b0e0792fbb2c9f10791a6866298597</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>PickMode</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>ga9fba732a6f372b8adad8eb4e18b642ac</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PICK_NONE</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>gga9fba732a6f372b8adad8eb4e18b642aca6782c0648f20b59bb27d64c7577c7bd1</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PICK_REACTIVE</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>gga9fba732a6f372b8adad8eb4e18b642aca0cec83e1263ace2ccfcace8f4efb5a73</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PICK_ALL</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>gga9fba732a6f372b8adad8eb4e18b642acadfc156f5153055a708c9e2edd588f2e7</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>TextureFlags</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>ga33c7c0f8d0bebfe65a6d7394b93e029a</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>TEXTURE_NONE</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>gga33c7c0f8d0bebfe65a6d7394b93e029aa848496eeff61784a643ab29258115757</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>TEXTURE_RGB_FLAG_BGR</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>gga33c7c0f8d0bebfe65a6d7394b93e029aa970e4b9bbc6fa5395b0cedece219d373</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>TEXTURE_RGB_FLAG_PREMULT</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>gga33c7c0f8d0bebfe65a6d7394b93e029aab919a84687f5e15ef372cff0bf24c256</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>TEXTURE_YUV_FLAG_YUV2</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>gga33c7c0f8d0bebfe65a6d7394b93e029aa7c34a36c82fdd1e0a6c9e9251c16e0b4</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>TextureQuality</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>gab7eeab1d1d6a5024d9b8e954745fb277</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>TEXTURE_QUALITY_LOW</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>ggab7eeab1d1d6a5024d9b8e954745fb277a8166313842c33698b6f6514fd3065d24</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>TEXTURE_QUALITY_MEDIUM</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>ggab7eeab1d1d6a5024d9b8e954745fb277adf91e9c0115959c6f665733786ba940c</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>TEXTURE_QUALITY_HIGH</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>ggab7eeab1d1d6a5024d9b8e954745fb277a68c412b6222215e13ce3984ce8b4f17d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>TimelineDirection</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>gac63a039bf5143c3efe0a4620e8d550bf</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>TIMELINE_FORWARD</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>ggac63a039bf5143c3efe0a4620e8d550bfab088eda9ac6e91207d2379ce8419b432</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>TIMELINE_BACKWARD</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>ggac63a039bf5143c3efe0a4620e8d550bfaf90061e1523ce9192868fafdce77ba3f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>AnimationMode</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>ga17e6c1b47abef11eac045c2c19c63198</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>CUSTOM_MODE</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>gga17e6c1b47abef11eac045c2c19c63198a0a6a0614dba7fae3934995a641c543df</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>LINEAR</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>gga17e6c1b47abef11eac045c2c19c63198a01dc8aebee31bfaea27e2076883fc9c4</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>EASE_IN_QUAD</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>gga17e6c1b47abef11eac045c2c19c63198a42378395b98df3316d63acc9cbdc85f9</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>EASE_OUT_QUAD</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>gga17e6c1b47abef11eac045c2c19c63198a8f30a8b8cd6e2f5cb5beb6550de11d0b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>EASE_IN_OUT_QUAD</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>gga17e6c1b47abef11eac045c2c19c63198a2a70b40df026c64fd4f1d84627e7cb0e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>EASE_IN_CUBIC</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>gga17e6c1b47abef11eac045c2c19c63198a0f51d647af30e74041e5409e7d1a0750</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>EASE_OUT_CUBIC</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>gga17e6c1b47abef11eac045c2c19c63198a081b0396b26920ac8eecf6a5242a1520</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>EASE_IN_OUT_CUBIC</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>gga17e6c1b47abef11eac045c2c19c63198ad7051a6dc28b30da265943d91b2596ca</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>EASE_IN_QUART</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>gga17e6c1b47abef11eac045c2c19c63198a2d48339d11a8b4e089a0db4fbf012101</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>EASE_OUT_QUART</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>gga17e6c1b47abef11eac045c2c19c63198a307d9cbcc33e6b292d79ef6070ad9b81</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>EASE_IN_OUT_QUART</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>gga17e6c1b47abef11eac045c2c19c63198a0325064fc77fdd2a0441a25e0699d964</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>EASE_IN_QUINT</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>gga17e6c1b47abef11eac045c2c19c63198a69fc62d657b023585f7a30c84a94ae68</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>EASE_OUT_QUINT</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>gga17e6c1b47abef11eac045c2c19c63198a1f543ae5ff90fdf7bbac11395d76fb7c</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>EASE_IN_OUT_QUINT</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>gga17e6c1b47abef11eac045c2c19c63198ac38cb11ebef684fcb75b29092b00e27f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>EASE_IN_SINE</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>gga17e6c1b47abef11eac045c2c19c63198ab5e95d5c172502fc29349296df3b9457</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>EASE_OUT_SINE</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>gga17e6c1b47abef11eac045c2c19c63198ae92a074a2e6cd23105a9b3fdd5e9851a</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>EASE_IN_OUT_SINE</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>gga17e6c1b47abef11eac045c2c19c63198a419f112b4102abe7f4a091c6bc590290</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>EASE_IN_EXPO</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>gga17e6c1b47abef11eac045c2c19c63198aaf56f106f612e9cd03dba38b71a35ae2</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>EASE_OUT_EXPO</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>gga17e6c1b47abef11eac045c2c19c63198a0c781eb84c9a9252bcc8f79b4fc748b6</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>EASE_IN_OUT_EXPO</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>gga17e6c1b47abef11eac045c2c19c63198a0bb43835bfcb09e85a7bc20ebdbc5872</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>EASE_IN_CIRC</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>gga17e6c1b47abef11eac045c2c19c63198ab0d5e890947489132eb24826b3292534</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>EASE_OUT_CIRC</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>gga17e6c1b47abef11eac045c2c19c63198a9f04f9ed89e48a95094354ed4c0e6a74</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>EASE_IN_OUT_CIRC</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>gga17e6c1b47abef11eac045c2c19c63198adfe743c1966d374ed7820cdabe4ae9d4</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>EASE_IN_ELASTIC</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>gga17e6c1b47abef11eac045c2c19c63198ae576178c5adbdb1851d49e532f08490a</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>EASE_OUT_ELASTIC</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>gga17e6c1b47abef11eac045c2c19c63198a64861bcfb9c7ce85239950fb48a1b787</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>EASE_IN_OUT_ELASTIC</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>gga17e6c1b47abef11eac045c2c19c63198a065a1accbc0cc24819b9f9b1a7a39d04</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>EASE_IN_BACK</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>gga17e6c1b47abef11eac045c2c19c63198a95f771cc8de56432647a5e6e3071508b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>EASE_OUT_BACK</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>gga17e6c1b47abef11eac045c2c19c63198aefce9f29f9de054f4b59aced5303e983</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>EASE_IN_OUT_BACK</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>gga17e6c1b47abef11eac045c2c19c63198a7367f0aedc181aff2882a6e1bfd852cc</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>EASE_IN_BOUNCE</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>gga17e6c1b47abef11eac045c2c19c63198aeea8bf08d2af517a6dd4d0c081a96c8e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>EASE_OUT_BOUNCE</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>gga17e6c1b47abef11eac045c2c19c63198a906b803287a8f0e973eaf958b1636293</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>EASE_IN_OUT_BOUNCE</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>gga17e6c1b47abef11eac045c2c19c63198a531681b4ac13eeb60f1d53556fe1d8fe</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ANIMATION_LAST</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>gga17e6c1b47abef11eac045c2c19c63198a34a1ac965155005a5d1c55b4c68eeecb</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>RotateDirection</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>ga5b204af046360b6dbd6395a0d9c0766a</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ROTATE_CW</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>gga5b204af046360b6dbd6395a0d9c0766aa73602c23932e4aea767bd32139528d79</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ROTATE_CCW</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>gga5b204af046360b6dbd6395a0d9c0766aaff70538d6bc08d0b2bc78597b54688ce</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>RotateAxis</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>gad4904567ffd946e5c9ddd3615cd77dae</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>X_AXIS</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>ggad4904567ffd946e5c9ddd3615cd77daeaa3e138ffe36ff846fb84b0a1b0b403b3</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>Y_AXIS</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>ggad4904567ffd946e5c9ddd3615cd77daea46ecf3ae5af90b10d598200f32f63014</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>Z_AXIS</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>ggad4904567ffd946e5c9ddd3615cd77daea1b593634a6bb04d4097ab71844585203</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>Gravity</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>gafc761d383119dc9f5af8b1cb329b6c1c</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>GRAVITY_NONE</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>ggafc761d383119dc9f5af8b1cb329b6c1caf48d5e460ffa71e59f788fb4c5950958</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>GRAVITY_NORTH</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>ggafc761d383119dc9f5af8b1cb329b6c1ca4af51dc4a36985ffc5eb9a8a7e461367</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>GRAVITY_NORTH_EAST</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>ggafc761d383119dc9f5af8b1cb329b6c1ca220f6ff79f3425ab2be4dbebc6b38707</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>GRAVITY_EAST</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>ggafc761d383119dc9f5af8b1cb329b6c1ca0127164beceff2784b889429b4dff598</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>GRAVITY_SOUTH_EAST</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>ggafc761d383119dc9f5af8b1cb329b6c1caa62471d85dacb5b7a81646fcb6370f06</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>GRAVITY_SOUTH</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>ggafc761d383119dc9f5af8b1cb329b6c1cafb5bbb20f2c4ddcae27f01fd36973129</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>GRAVITY_SOUTH_WEST</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>ggafc761d383119dc9f5af8b1cb329b6c1ca4d535e4981ff9f219d2c4e2c102ecd56</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>GRAVITY_WEST</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>ggafc761d383119dc9f5af8b1cb329b6c1ca31c68df75724496573c6337b70a37bd4</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>GRAVITY_NORTH_WEST</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>ggafc761d383119dc9f5af8b1cb329b6c1ca4e548e058eafa96dbe486610579416b0</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>GRAVITY_CENTER</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>ggafc761d383119dc9f5af8b1cb329b6c1ca6c65457af9e6738e8b322cfe9da445d4</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>RequestMode</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>ga1351cc99f04fe4cfb4238eb340b44c9a</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>REQUEST_HEIGHT_FOR_WIDTH</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>gga1351cc99f04fe4cfb4238eb340b44c9aaf57a399ae090202446057d348ae666a9</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>REQUEST_WIDTH_FOR_HEIGHT</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>gga1351cc99f04fe4cfb4238eb340b44c9aadbb97f76af00931bfee994cf0231be83</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>FontFlags</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>gac7579b3df6963b5a0c15efa2f54ed38c</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FONT_MIPMAPPING</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>ggac7579b3df6963b5a0c15efa2f54ed38ca3699bc3b7950c89313ba524cdc5c6057</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FONT_HINTING</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>ggac7579b3df6963b5a0c15efa2f54ed38cac05bbc35682ceb8a06d5cf1f3c7e04e3</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>TextDirection</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>gac2a674a9ab8d1937fc4e02d5b092289e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>TEXT_DIRECTION_DEFAULT</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>ggac2a674a9ab8d1937fc4e02d5b092289ea64bbce6bf9c55dff7d1e42b718e2c125</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>TEXT_DIRECTION_LTR</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>ggac2a674a9ab8d1937fc4e02d5b092289ea3930b0ca1abb395a2e9b175eb8e7a854</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>TEXT_DIRECTION_RTL</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>ggac2a674a9ab8d1937fc4e02d5b092289ea1db45eb435cae08d2c9e5ba120ab5dc9</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>ActorFlags</type>
      <name>operator|</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>ga719936ad8913cf83d658fe13d9a86f53</anchor>
      <arglist>(ActorFlags lhs, ActorFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>ActorFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>gafc0df2161e741be215b49129f95f09d2</anchor>
      <arglist>(ActorFlags lhs, ActorFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>ActorFlags</type>
      <name>operator^</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>ga066c399d91a36365d0f09e09d7258eaa</anchor>
      <arglist>(ActorFlags lhs, ActorFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>ActorFlags</type>
      <name>operator~</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>ga0ef21380c30bb15294dc76c1703963bc</anchor>
      <arglist>(ActorFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>ActorFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>ga7ab038eb77ab9c81fe68dda1bc1db284</anchor>
      <arglist>(ActorFlags &amp;lhs, ActorFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>ActorFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>gaab36bc099a028ff2aaa267466bfc4b8e</anchor>
      <arglist>(ActorFlags &amp;lhs, ActorFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>ActorFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>gab3ac52485a7854c998a5bfefc727d17e</anchor>
      <arglist>(ActorFlags &amp;lhs, ActorFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>AllocationFlags</type>
      <name>operator|</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>ga72f9b8e17fc76f28e88d7c33f19689e3</anchor>
      <arglist>(AllocationFlags lhs, AllocationFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>AllocationFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>ga8ec9cc3d45bc8f87481e977a4a04967a</anchor>
      <arglist>(AllocationFlags lhs, AllocationFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>AllocationFlags</type>
      <name>operator^</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>gad2012dfec3d188d826342277ae874898</anchor>
      <arglist>(AllocationFlags lhs, AllocationFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>AllocationFlags</type>
      <name>operator~</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>ga2382e036c49ae8ca99cb36e7ca2ea9b6</anchor>
      <arglist>(AllocationFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>AllocationFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>ga541c185ec5cb34fb8f699f476182e1c6</anchor>
      <arglist>(AllocationFlags &amp;lhs, AllocationFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>AllocationFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>ga6e66e74194c73fc5f123ef49d9824a84</anchor>
      <arglist>(AllocationFlags &amp;lhs, AllocationFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>AllocationFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>ga56a3d9e660b22fcfb653578ca2b02459</anchor>
      <arglist>(AllocationFlags &amp;lhs, AllocationFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>TextureFlags</type>
      <name>operator|</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>gaee0b5ed2fe8589b48ca872d4eacbde44</anchor>
      <arglist>(TextureFlags lhs, TextureFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>TextureFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>ga8cf05791bd696a3f508cad90a088023c</anchor>
      <arglist>(TextureFlags lhs, TextureFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>TextureFlags</type>
      <name>operator^</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>ga90c41d7fc8d591fe52dfd1384608c2ff</anchor>
      <arglist>(TextureFlags lhs, TextureFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>TextureFlags</type>
      <name>operator~</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>ga32fef17ac294e73eabc0d62cbaf228a4</anchor>
      <arglist>(TextureFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>TextureFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>ga0fc9707064e18f127946ebc620e22589</anchor>
      <arglist>(TextureFlags &amp;lhs, TextureFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>TextureFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>ga0a35d50ac54664360e062506b9423d43</anchor>
      <arglist>(TextureFlags &amp;lhs, TextureFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>TextureFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>ga53cdf987cac7f3f621a3a646eb823951</anchor>
      <arglist>(TextureFlags &amp;lhs, TextureFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FontFlags</type>
      <name>operator|</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>gadca204f8368633ac31d634930b69e6ff</anchor>
      <arglist>(FontFlags lhs, FontFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FontFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>ga363e6c5043beccf9f8a76659b2d948c6</anchor>
      <arglist>(FontFlags lhs, FontFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FontFlags</type>
      <name>operator^</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>gab6d70b628ce402a5dba5f674ebb7618e</anchor>
      <arglist>(FontFlags lhs, FontFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FontFlags</type>
      <name>operator~</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>ga9e03050decf6a07788932491adc9d2ad</anchor>
      <arglist>(FontFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>FontFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>ga6f8748e53c4cebc7be02dbbe4fe3c047</anchor>
      <arglist>(FontFlags &amp;lhs, FontFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FontFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>ga375ae5110dd5ad98c83a04c6a06b7305</anchor>
      <arglist>(FontFlags &amp;lhs, FontFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FontFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__cluttermmEnums.html</anchorfile>
      <anchor>gac458380be7f8178a345f47ef6f2af8df</anchor>
      <arglist>(FontFlags &amp;lhs, FontFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>events_pending</name>
      <anchorfile>namespaceClutter.html</anchorfile>
      <anchor>acaf921558dd7104c846d90a5c83ddcb2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>guint</type>
      <name>key_event_get_symbol</name>
      <anchorfile>namespaceClutter.html</anchorfile>
      <anchor>ac19b8040b3555c6c44d565179f1f2f7f</anchor>
      <arglist>(KeyEvent *keyev)</arglist>
    </member>
    <member kind="function">
      <type>guint16</type>
      <name>key_event_get_code</name>
      <anchorfile>namespaceClutter.html</anchorfile>
      <anchor>ac1d6bcb93df44f75923d1f3df2213079</anchor>
      <arglist>(KeyEvent *keyev)</arglist>
    </member>
    <member kind="function">
      <type>guint32</type>
      <name>key_event_get_unicode</name>
      <anchorfile>namespaceClutter.html</anchorfile>
      <anchor>a43eeb86772cec323c5d67a3aaa9b26ed</anchor>
      <arglist>(KeyEvent *keyev)</arglist>
    </member>
    <member kind="function">
      <type>guint32</type>
      <name>keysym_to_unicode</name>
      <anchorfile>namespaceClutter.html</anchorfile>
      <anchor>a33ff4a3676723d834a6cc98ced3ee7fd</anchor>
      <arglist>(guint keyval)</arglist>
    </member>
    <member kind="function">
      <type>sigc::connection</type>
      <name>frame_source_add</name>
      <anchorfile>namespaceClutter.html</anchorfile>
      <anchor>a0332f5b7b92fb9539d90739a00d88d8e</anchor>
      <arglist>(const sigc::slot&lt; bool &gt; &amp;callback, guint interval, int priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>init</name>
      <anchorfile>namespaceClutter.html</anchorfile>
      <anchor>a3c1743a0a8c9cb71701710c48d296cf5</anchor>
      <arglist>(int *argc, gchar **argv[])</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>init</name>
      <anchorfile>namespaceClutter.html</anchorfile>
      <anchor>a335ac7dc6399e7638c97b40e585d3bf0</anchor>
      <arglist>(int &amp;argc, gchar **&amp;argv)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>add_clutter_option_group</name>
      <anchorfile>namespaceClutter.html</anchorfile>
      <anchor>a2b8e42503adb345f8c49b9a0df519405</anchor>
      <arglist>(Glib::OptionContext &amp;option_context)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>main</name>
      <anchorfile>namespaceClutter.html</anchorfile>
      <anchor>aed003c0a72da801bdfc7da6cd2b0dc91</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>main_quit</name>
      <anchorfile>namespaceClutter.html</anchorfile>
      <anchor>a0dc607e441dff3d52d440f7de986b3e8</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>main_level</name>
      <anchorfile>namespaceClutter.html</anchorfile>
      <anchor>a34d5e7b1bab7516aaa7dc7fe25d94ca5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_debug_enabled</name>
      <anchorfile>namespaceClutter.html</anchorfile>
      <anchor>aee8286912d9cf1c67ebd87234838d207</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_show_fps</name>
      <anchorfile>namespaceClutter.html</anchorfile>
      <anchor>a1227d1126a98199851db6399f962a8be</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>gulong</type>
      <name>get_timestamp</name>
      <anchorfile>namespaceClutter.html</anchorfile>
      <anchor>abdd3063626929670520cb0d50cfcd77a</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Actor &gt;</type>
      <name>get_actor_by_gid</name>
      <anchorfile>namespaceClutter.html</anchorfile>
      <anchor>a6cbc9935262edd0f28aaf1649b6d52df</anchor>
      <arglist>(guint32 id)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_default_frame_rate</name>
      <anchorfile>namespaceClutter.html</anchorfile>
      <anchor>a4711581c0b92004ed7e47835a3e69a16</anchor>
      <arglist>(guint frames_per_sec)</arglist>
    </member>
    <member kind="function">
      <type>guint</type>
      <name>get_default_frame_rate</name>
      <anchorfile>namespaceClutter.html</anchorfile>
      <anchor>aaf8d91ad6594e9b20c334f3a721d9019</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_motion_events_enabled</name>
      <anchorfile>namespaceClutter.html</anchorfile>
      <anchor>a3fef5e73d27401f55c006ddcba3b7138</anchor>
      <arglist>(bool enable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_motion_events_enabled</name>
      <anchorfile>namespaceClutter.html</anchorfile>
      <anchor>a902bb2e4d4f44f1332effc5013036c5f</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>clear_glyph_cache</name>
      <anchorfile>namespaceClutter.html</anchorfile>
      <anchor>a2b63f59d3dc0f2a2bb3814151e5c1598</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_font_flags</name>
      <anchorfile>namespaceClutter.html</anchorfile>
      <anchor>a799b3ea5c4e774e95867d8de2772f21f</anchor>
      <arglist>(FontFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>FontFlags</type>
      <name>get_font_flags</name>
      <anchorfile>namespaceClutter.html</anchorfile>
      <anchor>a4ec43c700f013730007d37cf6293dd18</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Pango::FontMap &gt;</type>
      <name>get_font_map</name>
      <anchorfile>namespaceClutter.html</anchorfile>
      <anchor>a1eb2dfe42b1ecc3c5db2296d150ad949</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Actor &gt;</type>
      <name>get_keyboard_grab</name>
      <anchorfile>namespaceClutter.html</anchorfile>
      <anchor>a2f2f20278d130535385ee663f63b27d5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Actor &gt;</type>
      <name>get_pointer_grab</name>
      <anchorfile>namespaceClutter.html</anchorfile>
      <anchor>aab5097b63b76233ea168dedb6defe51f</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>grab_keyboard</name>
      <anchorfile>namespaceClutter.html</anchorfile>
      <anchor>ac428ccc5dfa7e292b66f7e37741d034f</anchor>
      <arglist>(const Glib::RefPtr&lt; Actor &gt; &amp;actor)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>grab_pointer</name>
      <anchorfile>namespaceClutter.html</anchorfile>
      <anchor>a64ce6f180cee1ae709fdeba8fd7e654d</anchor>
      <arglist>(const Glib::RefPtr&lt; Actor &gt; &amp;actor)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>ungrab_keyboard</name>
      <anchorfile>namespaceClutter.html</anchorfile>
      <anchor>ae5ee0080ad33874c962fabf0c1503b02</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>ungrab_pointer</name>
      <anchorfile>namespaceClutter.html</anchorfile>
      <anchor>a204c6844a02d85a934372ce2d8dec819</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>grab_pointer_for_device</name>
      <anchorfile>namespaceClutter.html</anchorfile>
      <anchor>a11aa085a6ff368268f536bc0db1895cf</anchor>
      <arglist>(const Glib::RefPtr&lt; Actor &gt; &amp;actor, int id)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>ungrab_pointer_for_device</name>
      <anchorfile>namespaceClutter.html</anchorfile>
      <anchor>add14f47afc2a9d08c85bcaa44a5ca7d6</anchor>
      <arglist>(int id)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>threads_init</name>
      <anchorfile>namespaceClutter.html</anchorfile>
      <anchor>aeb2de6933828473acb336deeb20b686a</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>threads_enter</name>
      <anchorfile>namespaceClutter.html</anchorfile>
      <anchor>a9ac68ebfabbd09be953b55b30cd75951</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>threads_leave</name>
      <anchorfile>namespaceClutter.html</anchorfile>
      <anchor>a7edefde2f9382033418df480b3f5d4f1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>sigc::connection</type>
      <name>threads_add_idle</name>
      <anchorfile>namespaceClutter.html</anchorfile>
      <anchor>a225ab0bbff8a1fa4a22a179162c50870</anchor>
      <arglist>(const sigc::slot&lt; bool &gt; &amp;callback, int priority=Glib::PRIORITY_DEFAULT_IDLE)</arglist>
    </member>
    <member kind="function">
      <type>sigc::connection</type>
      <name>threads_add_timeout</name>
      <anchorfile>namespaceClutter.html</anchorfile>
      <anchor>a2b09d4a41d5cbd45c83da002fe1abed1</anchor>
      <arglist>(const sigc::slot&lt; bool &gt; &amp;callback, guint interval, gint priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>sigc::connection</type>
      <name>threads_add_frame_source</name>
      <anchorfile>namespaceClutter.html</anchorfile>
      <anchor>af9f893d4b340ddf89cdc5a8b0512906a</anchor>
      <arglist>(const sigc::slot&lt; bool &gt; &amp;callback, guint interval, gint priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Clutter::ActorBox</name>
    <filename>classClutter_1_1ActorBox.html</filename>
    <member kind="function">
      <type></type>
      <name>ActorBox</name>
      <anchorfile>classClutter_1_1ActorBox.html</anchorfile>
      <anchor>a1453c77bcaaf1fd2b7fdb195be4a4615</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>ActorBox</name>
      <anchorfile>classClutter_1_1ActorBox.html</anchorfile>
      <anchor>a92cfd83be0353c4166a7818d597e5c49</anchor>
      <arglist>(const ClutterActorBox *gobject)</arglist>
    </member>
    <member kind="function">
      <type>ClutterActorBox *</type>
      <name>gobj</name>
      <anchorfile>classClutter_1_1ActorBox.html</anchorfile>
      <anchor>aeab10382c3c18e34b26a178f9077e6b9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const ClutterActorBox *</type>
      <name>gobj</name>
      <anchorfile>classClutter_1_1ActorBox.html</anchorfile>
      <anchor>a9c70660ba75e75ad9be4a5e42084071e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>ActorBox</name>
      <anchorfile>classClutter_1_1ActorBox.html</anchorfile>
      <anchor>aba36b8245e5fbd49be62f69a4802cb8b</anchor>
      <arglist>(float x1, float y1, float x2, float y2)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>get_origin</name>
      <anchorfile>classClutter_1_1ActorBox.html</anchorfile>
      <anchor>aa174900925ffb88392378eef124a6a04</anchor>
      <arglist>(float &amp;x, float &amp;y) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>get_size</name>
      <anchorfile>classClutter_1_1ActorBox.html</anchorfile>
      <anchor>ad745b4be4da17204fa0ea53b903200a1</anchor>
      <arglist>(float &amp;width, float &amp;height) const </arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>get_area</name>
      <anchorfile>classClutter_1_1ActorBox.html</anchorfile>
      <anchor>af53ca0987246427177b2ece3fce50f8b</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>contains</name>
      <anchorfile>classClutter_1_1ActorBox.html</anchorfile>
      <anchor>aaf05a8d866f507a28c36481e86d7e2f5</anchor>
      <arglist>(float x, float y) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>clamp_to_pixel</name>
      <anchorfile>classClutter_1_1ActorBox.html</anchorfile>
      <anchor>a37a395394554e4c26731d60368ef4d47</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>get_x1</name>
      <anchorfile>classClutter_1_1ActorBox.html</anchorfile>
      <anchor>afc3f907d626512c2402c289d8a606091</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_x1</name>
      <anchorfile>classClutter_1_1ActorBox.html</anchorfile>
      <anchor>aff379edcb4ec55f3a2174631e61fd34e</anchor>
      <arglist>(const float &amp;value)</arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>get_y1</name>
      <anchorfile>classClutter_1_1ActorBox.html</anchorfile>
      <anchor>a34034b6947536aa2485af505f567af05</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_y1</name>
      <anchorfile>classClutter_1_1ActorBox.html</anchorfile>
      <anchor>a5a781201b88871d693a9ba42cff878ee</anchor>
      <arglist>(const float &amp;value)</arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>get_x2</name>
      <anchorfile>classClutter_1_1ActorBox.html</anchorfile>
      <anchor>a1201301841e6794621a333f081fb82c8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_x2</name>
      <anchorfile>classClutter_1_1ActorBox.html</anchorfile>
      <anchor>aa6af32d2b19a519f783c65bf743eca14</anchor>
      <arglist>(const float &amp;value)</arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>get_y2</name>
      <anchorfile>classClutter_1_1ActorBox.html</anchorfile>
      <anchor>a7f5705220562d2832fd1ef2ab34f89d4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_y2</name>
      <anchorfile>classClutter_1_1ActorBox.html</anchorfile>
      <anchor>a8760a809a94bf426eae881ea23a86edc</anchor>
      <arglist>(const float &amp;value)</arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>ClutterActorBox</type>
      <name>gobject_</name>
      <anchorfile>classClutter_1_1ActorBox.html</anchorfile>
      <anchor>a250a0d2374a21a8b91469f3f02f1dc21</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>Clutter::ActorBox &amp;</type>
      <name>wrap</name>
      <anchorfile>classClutter_1_1ActorBox.html</anchorfile>
      <anchor>a98eefcd880bcae692a8b74b817fea073</anchor>
      <arglist>(ClutterActorBox *object)</arglist>
    </member>
    <member kind="function">
      <type>const Clutter::ActorBox &amp;</type>
      <name>wrap</name>
      <anchorfile>classClutter_1_1ActorBox.html</anchorfile>
      <anchor>a46a7c056e942acfeaba68e118ab4255e</anchor>
      <arglist>(const ClutterActorBox *object)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Clutter::Actor</name>
    <filename>classClutter_1_1Actor.html</filename>
    <base>Glib::Object</base>
    <base>Clutter::Scriptable</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~Actor</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>a27624732665fc0ff719da7e726f5ce9f</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>ClutterActor *</type>
      <name>gobj</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>add08539e0cacf1abc65705b53123186f</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const ClutterActor *</type>
      <name>gobj</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>a4e97b8d3b4d586392b96e3a094ab81d7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>ClutterActor *</type>
      <name>gobj_copy</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>a66c35d498df0f88dfec80b0d910ae47b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_flags</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>a6eae3925ddaa04417a62de8eaaa15f54</anchor>
      <arglist>(ActorFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>unset_flags</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>ab3f058d8186dd60159f846e5af42eb5e</anchor>
      <arglist>(ActorFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>ActorFlags</type>
      <name>get_flags</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>a42e90d665201dc53974ee12ae77e65c3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_mapped</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>aee19497fd7f86f5231a2ebc4bc8aa968</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_realized</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>aa893c4f3cdf654a3d2d8e4b982b4ca2c</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_visible</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>ac6c04b25b2cf53f614e4c6deec10618a</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_reactive</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>abbfda59485f822f35e4edaf6805cfd33</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>show</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>a47ec6c74a786abbc17f8464d0b8e03e7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>show_all</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>a49b5f5395fcc30b2c76f14d50a30b327</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>hide</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>ac755bd9e6b0757dfc16d93b4cdd278ac</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>hide_all</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>ad1b46962d79f95d005ef673d2e41707b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>realize</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>a15d821795567fe7453df683e70e814b4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>unrealize</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>a24d3d6400f105c13e84e7ef03733cbdd</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>map</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>abbfc4848656c8fbdf1c1692708f7e355</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>unmap</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>aa3191a25949ea1e03415a967e410613f</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>paint</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>aec7c6a31cd67ad6cf8066299554e9b44</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>queue_redraw</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>aaf3d1da553aae2d22737eb85b418e1d4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>queue_relayout</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>ac4895bbb15ee53f4ea0373a037f39d87</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Pango::Context &gt;</type>
      <name>get_pango_context</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>af8dd662c83222a229bee794076b66ceb</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const Pango::Context &gt;</type>
      <name>get_pango_context</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>a5e5e115dc1460a0ccb031c82993cb019</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Pango::Context &gt;</type>
      <name>create_pango_context</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>aa6561677f2822b10bdabfb5609f02152</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Pango::Layout &gt;</type>
      <name>create_pango_layout</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>ad1704177565e016f1c30337ac741f7e0</anchor>
      <arglist>(const Glib::ustring &amp;text)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>get_transformation_matrix</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>a6a4ae26426a55a45eb32ac8aaa4705e6</anchor>
      <arglist>(CoglMatrix *matrix)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_in_clone_paint</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>a340ecb70f69d454ffdcc244cb11d8bd2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>has_pointer</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>a3452bdb36f3e3f7abdc139baa796f6e9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_text_direction</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>ae6408869fd081f86b4c1d2a4d64d2fc6</anchor>
      <arglist>(TextDirection text_dir)</arglist>
    </member>
    <member kind="function">
      <type>TextDirection</type>
      <name>get_text_direction</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>a43b23617a269969f407ec3ae4c89f8cd</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Actor &gt;</type>
      <name>get_stage</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>a7b081005957ab02e1309612048e832a8</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const Actor &gt;</type>
      <name>get_stage</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>aee6d89e245503fc932de2626044d7ab8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_geometry</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>afba29ed7713153837d9d5f51a99a1e58</anchor>
      <arglist>(const Geometry &amp;geometry)</arglist>
    </member>
    <member kind="function">
      <type>Geometry</type>
      <name>get_geometry</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>a227dafad56858d64a299b96ba78f0ec1</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_size</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>ab9805663f56b1ced64055103d71a5e8d</anchor>
      <arglist>(float width, float height)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>get_position</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>acffc4f92e353a0d97dd65a6a21a25428</anchor>
      <arglist>(float &amp;x, float &amp;y)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_position</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>abc7ffd766ff8ded42fa614dbba38455c</anchor>
      <arglist>(float x, float y)</arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>get_width</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>a8b2308c40c691c8345fbcc85b4f36a7d</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>get_height</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>a7a67c5b716cc94679df8c28d84cbde7e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_width</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>afaa6c1a24c6ad4a2d3033820633ab40a</anchor>
      <arglist>(float width)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_height</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>a9b165336610c1c33e10d10f388ae30ed</anchor>
      <arglist>(float height)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_x</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>a6b3199ee80a148c27bfb4dd626f3395c</anchor>
      <arglist>(float x)</arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>get_x</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>a9d5e656284fe30a5e087c65efabee49c</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_y</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>a124be29033c8d79529b3cf507477953a</anchor>
      <arglist>(float y)</arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>get_y</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>ac2bc6184fb63701e4fec301b9a8d69a5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_reactive</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>ac9f40bedf21574da51e5d80ac81f1e09</anchor>
      <arglist>(bool reactive=true)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_reactive</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>aa37b2b4b700b3b11cb027048683152c9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_rotation</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>a2cfb41295fdafbbe0c6a760f22d8286c</anchor>
      <arglist>(RotateAxis axis, double angle, float x, float y, float z)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_z_rotation_from_gravity</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>a1d8f67a6aca6f144db45b35850bacd75</anchor>
      <arglist>(double angle, Gravity gravity)</arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>get_rotation</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>a81fde291254fb679d5bdf2277c7607a4</anchor>
      <arglist>(RotateAxis axis, float &amp;x, float &amp;y, float &amp;z) const </arglist>
    </member>
    <member kind="function">
      <type>Gravity</type>
      <name>get_z_rotation_gravity</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>ad9dd2106ec27ca8f57bf747d2b1313a3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_opacity</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>a5b3bccc51d8a711a506a4d79d7fc996a</anchor>
      <arglist>(guint8 opacity)</arglist>
    </member>
    <member kind="function">
      <type>guint8</type>
      <name>get_opacity</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>a777e5f6bb812c67f84718e43723afe58</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_name</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>a4ca6cff1a102df657bbe8b605f30c16e</anchor>
      <arglist>(const gchar *name)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_name</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>a320070f9335652a3ef473f26502c1525</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>guint32</type>
      <name>get_gid</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>a3fad86aebf9870630d988c6e0c587185</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_clip</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>a04bd53cedd2e186a0e56d93aa6f6ca73</anchor>
      <arglist>(float xoff, float yoff, float width, float height)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>get_clip</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>a9ae9ca71b2ea085f999a971061e4502e</anchor>
      <arglist>(float &amp;xoff, float &amp;yoff, float &amp;width, float &amp;height)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>remove_clip</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>a52e78a537a1e2aa6c7efb8adab425f23</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>has_clip</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>a92ec213f3156118f20e2179f72dc6acd</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_parent</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>a8d18008e98b99a495f9d4b5da362b0fb</anchor>
      <arglist>(const Glib::RefPtr&lt; Actor &gt; &amp;parent)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Actor &gt;</type>
      <name>get_parent</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>a49a95d313495302fac16f3bf4b2c40e2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const Actor &gt;</type>
      <name>get_parent</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>a8cf0204954ccfacecd7b3b2a43baafee</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>reparent</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>a95ae28526d9352421b9f102f6adb7e67</anchor>
      <arglist>(const Glib::RefPtr&lt; Actor &gt; &amp;new_parent)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>unparent</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>ac72f7a81ba3bf300b6429c2a098b67c3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>raise</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>a8a1d6d2f2866dd37ae2c7f4eafb60e56</anchor>
      <arglist>(const Glib::RefPtr&lt; Actor &gt; &amp;below)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>lower</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>a2c8af224e1f0d81bf556a83630c46273</anchor>
      <arglist>(const Glib::RefPtr&lt; Actor &gt; &amp;above)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>raise_top</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>ab98ae4a0254c8f386fd565d3ce41e5be</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>lower_bottom</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>aab7709fa0da83a2ef12703e66242600e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Shader &gt;</type>
      <name>get_shader</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>a5ee4c8d9ef7079a05d69a448046b568e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const Shader &gt;</type>
      <name>get_shader</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>ab9ea4f55562e2e1fb7a0800518d1a5f0</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_shader</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>a554be8a97725f6872cfe440bff0deff3</anchor>
      <arglist>(const Glib::RefPtr&lt; Shader &gt; &amp;shader)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_shader_param</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>a345981c4476f82faa5d2a2d259b90221</anchor>
      <arglist>(const Glib::ustring &amp;param, const ParamType &amp;value)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_rotated</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>a0d51834738e2c8aab95bde3f51ed1e7c</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_scaled</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>a11883a3d5f121a246b49d8ec7b41d839</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>should_pick_paint</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>ad31aa27adbb2fb777d27566bb3107862</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>get_allocation_vertices</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>a8c8eb2772aa2da3381dbb9c0b15abcbf</anchor>
      <arglist>(Vertex vertices[4]) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>get_allocation_vertices</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>a0a925270e43fee7970454b26c4368f51</anchor>
      <arglist>(const Glib::RefPtr&lt; Actor &gt; &amp;ancestor, Vertex vertices[4]) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>get_abs_allocation_vertices</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>a288682df9986921132b4e31710662ce9</anchor>
      <arglist>(Vertex vertices[4]) const </arglist>
    </member>
    <member kind="function">
      <type>ActorBox</type>
      <name>get_allocation_box</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>af609d89a1dafb47a3bb8d77925d1cda6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>allocate</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>a98ada5f95c0b37cc27f26949e0681419</anchor>
      <arglist>(const ActorBox &amp;box, AllocationFlags absolute_origin_changed=ALLOCATION_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>allocate_preferred_size</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>a208d2d9202e4a82f336d8ec42efe773d</anchor>
      <arglist>(AllocationFlags absolute_origin_changed=ALLOCATION_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>allocate_available_size</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>ad9a40a3021ddb804c4718e55eccc1c85</anchor>
      <arglist>(float x, float y, float available_width, float available_height, AllocationFlags flags=ALLOCATION_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>apply_relative_transform_to_point</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>a3507558a2dc2587841be66f4b1278f44</anchor>
      <arglist>(const Glib::RefPtr&lt; Actor &gt; &amp;ancestor, const Vertex &amp;point, Vertex &amp;vertex) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>apply_relative_transform_to_point</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>ab07422994a925d47382cc54f256fbd8a</anchor>
      <arglist>(const Vertex &amp;point, Vertex &amp;vertex) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_request_mode</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>acf0c9cb5b8de2cfebda022db92cdd93e</anchor>
      <arglist>(RequestMode mode)</arglist>
    </member>
    <member kind="function">
      <type>RequestMode</type>
      <name>get_request_mode</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>a1db7e7c07062997a7710b8baa3df0409</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>get_preferred_size</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>ab78c811813bfd2282c8d47defd6aa0c0</anchor>
      <arglist>(float &amp;min_width_p, float &amp;min_height_p, float &amp;natural_width_p, float &amp;natural_height_p) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>get_preferred_width</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>a4fd0d9411b2b120a7d039c108cd204fd</anchor>
      <arglist>(float for_height, float &amp;min_width_p, float &amp;natural_width_p) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>get_preferred_height</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>aee176f4ac1e951284271dfa5c26b7888</anchor>
      <arglist>(float for_width, float &amp;min_height_p, float &amp;natural_height_p) const </arglist>
    </member>
    <member kind="function">
      <type>guint8</type>
      <name>get_paint_opacity</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>a8cfbb0644e2afe2132cb3e1f194ace79</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_paint_visibility</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>aa98d4218a21f0bd9729e628a88ec471c</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>move_anchor_point_from_gravity</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>a0e0b06d5fb5caac18422be459119d679</anchor>
      <arglist>(Gravity gravity)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>move_anchor_point</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>a453de4c5ac2edaff5c4e7a2a2eee59cd</anchor>
      <arglist>(float anchor_x, float anchor_y)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_fixed_position_set</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>adb959f32006db4eb69a422967512579e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_fixed_position_set</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>aa619898eb6602c1452203d69bf24edfa</anchor>
      <arglist>(bool is_set)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>get_transformed_position</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>a831166d9444379df0d010a1476074209</anchor>
      <arglist>(float &amp;x, float &amp;y) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>get_transformed_size</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>a9d42fe543fa8bfaf934160d5383cda1f</anchor>
      <arglist>(float &amp;width, float &amp;height) const </arglist>
    </member>
    <member kind="function">
      <type>Geometry</type>
      <name>get_allocation_geometry</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>ad01d0d44023f2d79089ed4cb8cf627ff</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_depth</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>a2bcb20b61a8e4fa097e951dd65958c2b</anchor>
      <arglist>(float depth)</arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>get_depth</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>afde5acb9a7f5ded7bbab6aed1c8e1ec3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_scale</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>a01a41e74d07a61252dc85e0c387ad042</anchor>
      <arglist>(double scale_x, double scale_y)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_scale_full</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>a8740720c4c4ab0c3ae7a8cfd6d756f35</anchor>
      <arglist>(double scale_x, double scale_y, float center_x, float center_y)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_scale_with_gravity</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>a4d90716e23821f8b2a0131ea35b8e9ab</anchor>
      <arglist>(double scale_x, double scale_y, Gravity gravity)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>get_scale</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>aaadc0317ac7abe1c65d116820a075453</anchor>
      <arglist>(double &amp;scale_x, double &amp;scale_y) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>get_scale_center</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>ab2988b2fe2fc6a916ae8367caa0f9abf</anchor>
      <arglist>(float &amp;center_x, float &amp;center_y) const </arglist>
    </member>
    <member kind="function">
      <type>Gravity</type>
      <name>get_scale_gravity</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>a9a94a29cd00d3411dac22add04d982e6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>get_size</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>a34e8b524b071da7e79a1755bb424920c</anchor>
      <arglist>(float &amp;width, float &amp;height) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>move_by</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>a4722d844ac36b483d566d1954f9a6111</anchor>
      <arglist>(float dx, float dy)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>apply_transform_to_point</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>abd08eb90232422f647b6068351a76525</anchor>
      <arglist>(const Vertex &amp;point, Vertex &amp;vertex) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>transform_stage_point</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>afec4ff6fe05117931b5ae92dfe0ce760</anchor>
      <arglist>(float x, float y, float &amp;x_out, float &amp;y_out) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>event</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>ad35482e582cf6f29dfd246b7043fe81d</anchor>
      <arglist>(ClutterEvent *event, bool capture)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_anchor_point</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>a3c07ab9bb45dc479036cfa6e6065defb</anchor>
      <arglist>(float anchor_x, float anchor_y)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>get_anchor_point</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>afaf5f00948d40d8f6524a089d527fca3</anchor>
      <arglist>(float &amp;anchor_x, float &amp;anchor_y) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_anchor_point_from_gravity</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>a2e55491a8fd4d2e3d2c1da4eb4cbd32d</anchor>
      <arglist>(ClutterGravity gravity)</arglist>
    </member>
    <member kind="function">
      <type>Gravity</type>
      <name>get_anchor_point_gravity</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>ae51a68b153b8351f20d314e6cef11bbb</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>grab_key_focus</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>a6eab34eb4e0f9555b7d5cf48a84f9d84</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Animation &gt;</type>
      <name>animate</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>a579ac5bdf4ec272a3665101963c4b8c5</anchor>
      <arglist>(gulong mode, guint duration, const std::map&lt; std::string, Glib::ValueBase &gt; &amp;properties)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Animation &gt;</type>
      <name>animate</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>a46918a6aea94111b2448692631165c24</anchor>
      <arglist>(gulong mode, const Glib::RefPtr&lt; Timeline &gt; &amp;timeline, const std::map&lt; std::string, Glib::ValueBase &gt; &amp;properties)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Animation &gt;</type>
      <name>animate</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>a434906c4ebdbab73e8539aeb7a121aec</anchor>
      <arglist>(const Glib::RefPtr&lt; Alpha &gt; &amp;alpha, const std::map&lt; std::string, Glib::ValueBase &gt; &amp;properties)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Animation &gt;</type>
      <name>get_animation</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>af5fb491b3080b1d6ef6d452406730294</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const Animation &gt;</type>
      <name>get_animation</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>a2b1cc9400395675645f31b41ee53db4a</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>push_internal</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>ab7735ff952adf63f4127bcb3a526b53b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>pop_internal</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>a68e791b803f71a3ae44b52da23650d75</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy1&lt; bool, ButtonEvent * &gt;</type>
      <name>signal_button_press_event</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>a31ec50882e8ffd71c9bfc83bf6b953af</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy1&lt; bool, ButtonEvent * &gt;</type>
      <name>signal_button_release_event</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>a597a53cdaa2b6e85108df55f514a1a3b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy1&lt; bool, MotionEvent * &gt;</type>
      <name>signal_motion_event</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>aa3d5313f9d08f21a2339c5b92fd74633</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy1&lt; bool, CrossingEvent * &gt;</type>
      <name>signal_leave_event</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>a768b86d6fe3c6dcb6b890d4f07b23615</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy0&lt; void &gt;</type>
      <name>signal_show</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>a25dc323c0d60200cf4668d7fc3205198</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy0&lt; void &gt;</type>
      <name>signal_hide</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>a8a749f3a1c7ab67b1c0ab6ee7dd7843e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy0&lt; void &gt;</type>
      <name>signal_destroy</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>a2520e771dab26b5d02922c77ec2c973c</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy1&lt; bool, KeyEvent * &gt;</type>
      <name>signal_key_release_event</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>a525fc414ddf513a7c19fc5dbd6488273</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy1&lt; bool, CrossingEvent * &gt;</type>
      <name>signal_enter_event</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>a05d63e4b950c431f03add4b4b7455e11</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy1&lt; bool, Event * &gt;</type>
      <name>signal_event</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>a8db8d91dfeb0646d4c765b7e2727b85f</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy0&lt; void &gt;</type>
      <name>signal_key_focus_out</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>ae61ba56e6a4c4f936794a53676548a23</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy0&lt; void &gt;</type>
      <name>signal_key_focus_in</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>a899e92374017b6f457b87184ba559ce2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy1&lt; void, const Glib::RefPtr&lt; Actor &gt; &amp; &gt;</type>
      <name>signal_parent_set</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>a0d0703e8779fba7396b7d6adcbf61c18</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy1&lt; bool, ScrollEvent * &gt;</type>
      <name>signal_scroll_event</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>ad5277fef40f50706a0961c8ea8761ecd</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy1&lt; bool, KeyEvent * &gt;</type>
      <name>signal_key_press_event</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>a7252117d85af36aae6bd69c9e00e5cef</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy1&lt; bool, Event * &gt;</type>
      <name>signal_captured_event</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>a5c4f9ac1e80a51ba63a0334abac0e0ef</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy0&lt; void &gt;</type>
      <name>signal_paint</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>ade29a401dcda29d8dfcb5cc26d9ccc87</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy1&lt; void, const Glib::RefPtr&lt; Actor &gt; &amp; &gt;</type>
      <name>signal_queue_redaw</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>a1c3272caf9721d69ccc9b75451c8112b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy0&lt; void &gt;</type>
      <name>signal_queue_relayout</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>ab9234f792db7f78c92bd6fa85faf47b5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy0&lt; void &gt;</type>
      <name>signal_realize</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>a22b68cadbd6f8c6c22af28efa4a61a9c</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy0&lt; void &gt;</type>
      <name>signal_unrealize</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>a6f16b773cc8628855ec84f5572392735</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy1&lt; void, const Color &amp; &gt;</type>
      <name>signal_pick</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>a682869c5ce82317bb962fe4dce82cc2a</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy2&lt; void, const ActorBox &amp;, AllocationFlags &gt;</type>
      <name>signal_allocation_changed</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>a0ed076fd9d31881f00eb110326eddc88</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; ActorBox &gt;</type>
      <name>property_allocation</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>ad486d92676b0678166ebbfc5372f0745</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; float &gt;</type>
      <name>property_anchor_x</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>af6f26b0d6c08aefe3cd349c7f59eff88</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; float &gt;</type>
      <name>property_anchor_x</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>aa86cd0336dfae0fcfdf5bbd039d054fa</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; float &gt;</type>
      <name>property_anchor_y</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>a82616afd6f3edb527d3c8ea2b2b8cc54</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; float &gt;</type>
      <name>property_anchor_y</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>a278c85aa95f5fc5c57dcc9c4019d1866</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; Gravity &gt;</type>
      <name>property_anchor_gravity</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>a9e43f76f44081344ef9de2a3b38530b9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; Gravity &gt;</type>
      <name>property_anchor_gravity</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>a214e33bec50fd9b28646d9a93753cd03</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; Geometry &gt;</type>
      <name>property_clip</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>a7996923081621e39e9fa8a7b3592be85</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; Geometry &gt;</type>
      <name>property_clip</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>a1f21a3ef80eabc58b73bef20ec010be5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; bool &gt;</type>
      <name>property_clip_to_allocation</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>ac04512a3fdb5086c4af6c43172d4017e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; bool &gt;</type>
      <name>property_clip_to_allocation</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>a7ad315ef7b86fddddab0c04c88fd4992</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; float &gt;</type>
      <name>property_depth</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>ae78d795100f1f4d8916eaae9533d1036</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; float &gt;</type>
      <name>property_depth</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>abf2a986f5ab68aa98b60523087d50106</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; bool &gt;</type>
      <name>property_fixed_position_set</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>a6d05f836d83ea0032139d9420b2115b0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; bool &gt;</type>
      <name>property_fixed_position_set</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>ab845bd0b736ed0912abc9760331f9035</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; float &gt;</type>
      <name>property_fixed_x</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>a05828b1d6126180f31dd3558d97a03a4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; float &gt;</type>
      <name>property_fixed_x</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>ade259d83ef7d2fa8456d2d6a19ac9307</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; float &gt;</type>
      <name>property_fixed_y</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>aa1f6aeee462b03e580f083a160f0b329</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; float &gt;</type>
      <name>property_fixed_y</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>a660990e2422a6dcc37936fe4eae2d463</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; bool &gt;</type>
      <name>property_has_clip</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>a45f47fd9147fa8c54512ca2e028c483c</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; bool &gt;</type>
      <name>property_has_pointer</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>a72920347076ba3ec65df184cb052c5be</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; float &gt;</type>
      <name>property_height</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>a4ad2b65c3438229fb71a5dec85d5869f</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; float &gt;</type>
      <name>property_height</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>adfc0df5b6549a54aabc8a11c863b137f</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; float &gt;</type>
      <name>property_min_height</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>a02978ce7dac32bc0e07f086e637cb85e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; float &gt;</type>
      <name>property_min_height</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>aa6c11b70753970ef9d3499816c63c54a</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; bool &gt;</type>
      <name>property_min_height_set</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>afdc0037bab1202c9cc61c228619f4ed8</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; bool &gt;</type>
      <name>property_min_height_set</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>a5120dd11639804221720e57eb8cb4742</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; float &gt;</type>
      <name>property_min_width</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>adea5450c166bc474170ba5e49b4d9aa3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; float &gt;</type>
      <name>property_min_width</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>a3d71edb7898881b0937457bc461d8086</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; bool &gt;</type>
      <name>property_min_width_set</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>ac62647f057f02b6ea18227a7e1c11b4f</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; bool &gt;</type>
      <name>property_min_width_set</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>ae2caed1cb74e1743a16a3b81839a6334</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; Glib::ustring &gt;</type>
      <name>property_name</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>a7fae4e7a272ae9d901d8a7ca3afc876e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; Glib::ustring &gt;</type>
      <name>property_name</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>af2c6061fcdf359bca975e11634c4e19c</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; guint8 &gt;</type>
      <name>property_opacity</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>adc975ef715473e522ff80dae8c9e2257</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; guint8 &gt;</type>
      <name>property_opacity</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>a5fd70a69bfc231c40810441861dd1c33</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; bool &gt;</type>
      <name>property_reactive</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>a85973a02bb082f6ac2bd513f1001699a</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; bool &gt;</type>
      <name>property_reactive</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>a2b5c3ccfea9dfa34068450b3cdb780f6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; RequestMode &gt;</type>
      <name>property_request_mode</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>a24d31f1ffe72f0fae98553cb1da657be</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; RequestMode &gt;</type>
      <name>property_request_mode</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>a44ee78cb2bca53bd64ca8270c7c122d4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; double &gt;</type>
      <name>property_rotation_angle_x</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>ac2e2ef94327fc846864b7cff885ec00e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; double &gt;</type>
      <name>property_rotation_angle_x</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>aa597db1b1cbcb4fbbc5d7a454d28f0a9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; double &gt;</type>
      <name>property_rotation_angle_y</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>a35105d7582f9755357d849a8f0c096ef</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; double &gt;</type>
      <name>property_rotation_angle_y</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>a605dacc776cee758c60d25ad6a992570</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; double &gt;</type>
      <name>property_rotation_angle_z</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>a3042b8cdf3f220eebc64a558011d11a6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; double &gt;</type>
      <name>property_rotation_angle_z</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>aeeb27afc46c5cacfce61495ef14e538c</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; Vertex &gt;</type>
      <name>property_rotation_center_x</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>ac9fd24c3c3e5997c772141285892f015</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; Vertex &gt;</type>
      <name>property_rotation_center_x</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>ac9fac2a43ac0619f11e3f2194b979aa9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; Vertex &gt;</type>
      <name>property_rotation_center_y</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>ac23f0c830a2812a1a3e068e88dcfc3c0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; Vertex &gt;</type>
      <name>property_rotation_center_y</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>a8d5f961cfcce004fc1186940d941042d</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; Vertex &gt;</type>
      <name>property_rotation_center_z</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>a1450202b1ed5d6fde73fbe52c9519b54</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; Vertex &gt;</type>
      <name>property_rotation_center_z</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>acb2bdad7f65ed4977ccf9f2774973e19</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; Gravity &gt;</type>
      <name>property_rotation_center_z_gravity</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>afae8ce83936954f0619d58d48740054f</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; Gravity &gt;</type>
      <name>property_rotation_center_z_gravity</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>aeb1dd931c9c299eda80dbd8e47c392d1</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; double &gt;</type>
      <name>property_scale_x</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>ae5491e0bdc3c0661560aacb7f4dfdbd1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; double &gt;</type>
      <name>property_scale_x</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>aaa67bc20f91d183f2268db4bbc72966c</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; double &gt;</type>
      <name>property_scale_y</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>a9252b40910a26d5ccf8c7e7f8be4071f</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; double &gt;</type>
      <name>property_scale_y</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>a62cc9085c5ea1b8727c40d4ca5dce362</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; double &gt;</type>
      <name>property_scale_center_x</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>a380e262f6686c1bbca23a062f0ef4762</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; double &gt;</type>
      <name>property_scale_center_x</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>aa4239b8bb3057ea3507b47a63cbedf44</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; double &gt;</type>
      <name>property_scale_center_y</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>a600e94cf9fcf265080830fedd3df9ced</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; double &gt;</type>
      <name>property_scale_center_y</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>a07c5a5b7ab5780c559dad814001fefea</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; Gravity &gt;</type>
      <name>property_scale_gravity</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>a0f034dc5e6de9f06166253d332605fb6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; Gravity &gt;</type>
      <name>property_scale_gravity</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>ab0af81f7b1e22ebb5b27d1694e4a9ed8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; bool &gt;</type>
      <name>property_show_on_set_parent</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>a976ec311e45b320fe11d0f2ed1ae9bb9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; bool &gt;</type>
      <name>property_show_on_set_parent</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>a2b9c2930a087a40cdc146c5ac69024d3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; TextDirection &gt;</type>
      <name>property_text_direction</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>afd620f8f5d7f09fdeb5e1864561d5f0b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; TextDirection &gt;</type>
      <name>property_text_direction</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>aa2858ed69e898bafbb57f7493561b07c</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; bool &gt;</type>
      <name>property_visible</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>a9551dba3846d95ac15694c98bb0e1094</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; bool &gt;</type>
      <name>property_visible</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>a6714ea4cee4bce9ac08242bd29cdad8a</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; float &gt;</type>
      <name>property_width</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>ac5c6aafd5d7519fc6378afe0613ce40c</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; float &gt;</type>
      <name>property_width</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>a79aa3e766ec7acebcfc84930a67f3c8b</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; float &gt;</type>
      <name>property_x</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>a77b46ac8e47965c3a4de139471035b12</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; float &gt;</type>
      <name>property_x</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>ab41b614271a3d978af642f032e0deed4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; float &gt;</type>
      <name>property_y</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>ac106ce17faaa90373e770d34d43c073a</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; float &gt;</type>
      <name>property_y</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>a8f5d695a69d9cbe2f18b0d87486f9b53</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; Actor &gt;</type>
      <name>get_actor_by_gid</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>a195333f4916c62af9ac3af15cecc0015</anchor>
      <arglist>(guint32 id)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>Actor</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>ab5e841d318dff2bac5463988168f3441</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>set_shader_param_value</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>a2e829090d782bd68bcd32e27e3a0336e</anchor>
      <arglist>(const Glib::ustring &amp;param, const Glib::ValueBase &amp;value)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>show_all_vfunc</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>ab2d9462858d9d225920e2d2e9c23fd4e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>hide_all_vfunc</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>a2f5729a1b2d9dc7820f09d8f209a532f</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>pick_vfunc</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>a5abf5d5b5ded02c8f151e7c993c06d83</anchor>
      <arglist>(const Color &amp;color)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>get_preferred_width_vfunc</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>a714843f6fd86ea64e433db9c18cc028f</anchor>
      <arglist>(float for_height, float &amp;min_width_p, float &amp;natural_width_p) const </arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>get_preferred_height_vfunc</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>ac061e3c73a2f309df9c798185f012b9b</anchor>
      <arglist>(float for_width, float &amp;min_height_p, float &amp;natural_height_p) const </arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>allocate_vfunc</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>a0f7f269b37ef1b478c30f8b81edb9048</anchor>
      <arglist>(const ActorBox &amp;box, AllocationFlags absolute_origin_changed)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual bool</type>
      <name>on_button_press_event</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>aefb63eb91d5561abb8ea74f589fc54da</anchor>
      <arglist>(ButtonEvent *event)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual bool</type>
      <name>on_button_release_event</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>a274be97cd163e6629a4c584dbb37c62f</anchor>
      <arglist>(ButtonEvent *event)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual bool</type>
      <name>on_motion_event</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>a9918e5d3ecd3a9c8ce9d8c1cb752191f</anchor>
      <arglist>(MotionEvent *event)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual bool</type>
      <name>on_leave_event</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>a980531e76ff41574eff70c212008bbdc</anchor>
      <arglist>(CrossingEvent *event)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>on_show</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>adf1ae2b8000342a327c9e7a4164e7418</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>on_hide</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>a2eef86850d6c86da21a3a351c00b3997</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>on_destroy</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>a13f4a0b988afebe39204452da564cfe3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual bool</type>
      <name>on_key_release_event</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>a11915e3313129750883b75778e68f9e5</anchor>
      <arglist>(KeyEvent *event)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual bool</type>
      <name>on_enter_event</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>aed26ef093642c8f98163cd4d8561c7d4</anchor>
      <arglist>(CrossingEvent *event)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual bool</type>
      <name>on_event</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>a40d634b0e265fcaeb2dfd3e6bb3ee8f7</anchor>
      <arglist>(Event *event)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>on_key_focus_out</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>a37ffb5807cedd6f9fb51a005ce189f07</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>on_key_focus_in</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>a0ab886f4f1d9d3a57e8c2e1fddb096c8</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>on_parent_set</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>a9563a4ef2aba1a120de426f383944803</anchor>
      <arglist>(const Glib::RefPtr&lt; Actor &gt; &amp;old_parent)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual bool</type>
      <name>on_scroll_event</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>ab6dcdf5d7a01ae9f5e808784dea9446b</anchor>
      <arglist>(ScrollEvent *event)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual bool</type>
      <name>on_key_press_event</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>a920df0cc3750156b7aa17f4cee36f937</anchor>
      <arglist>(KeyEvent *event)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual bool</type>
      <name>on_captured_event</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>a49e222866ca31d7c0cd7305925d583dc</anchor>
      <arglist>(Event *event)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>on_paint</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>a10cb142c7c30e6dacfec717a01d3804e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>on_queue_redaw</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>a72b7a482d90703530a1763c5706d4f4d</anchor>
      <arglist>(const Glib::RefPtr&lt; Actor &gt; &amp;origin)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>on_queue_relayout</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>a7c1356c06d945a2f106510aad6b20a3d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>on_realize</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>a26cadcac9f9f55ca15bca7e8f656b6a3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>on_unrealize</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>a216cf0fac8243ef84dec002cfc730b04</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>on_pick</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>a09cf686a213c675ba8d62a2422a3e2fa</anchor>
      <arglist>(const Color &amp;color)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Clutter::Actor &gt;</type>
      <name>wrap</name>
      <anchorfile>classClutter_1_1Actor.html</anchorfile>
      <anchor>a1baeeffc76f602d6ac4876efc5528276</anchor>
      <arglist>(ClutterActor *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Clutter::Alpha</name>
    <filename>classClutter_1_1Alpha.html</filename>
    <base>Glib::Object</base>
    <member kind="enumvalue">
      <name>MAX_ALPHA</name>
      <anchorfile>classClutter_1_1Alpha.html</anchorfile>
      <anchor>a694260e7806fc432b238e746c159dbbcab2f04620fa74627ce5c1f2bc8df36a8f</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>sigc::slot&lt; double, const Glib::RefPtr&lt; Alpha &gt; &amp; &gt;</type>
      <name>SlotAlphaFunc</name>
      <anchorfile>classClutter_1_1Alpha.html</anchorfile>
      <anchor>a9430d2e815be93a4d4b67edb459acfb9</anchor>
      <arglist></arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~Alpha</name>
      <anchorfile>classClutter_1_1Alpha.html</anchorfile>
      <anchor>a985400ae1e8d2700a10cd6f375f10bbb</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>ClutterAlpha *</type>
      <name>gobj</name>
      <anchorfile>classClutter_1_1Alpha.html</anchorfile>
      <anchor>a0419a94c6e738ce6254841d20e8ab309</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const ClutterAlpha *</type>
      <name>gobj</name>
      <anchorfile>classClutter_1_1Alpha.html</anchorfile>
      <anchor>ac8e7d7634d8f1a30fcfe712500f78149</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>ClutterAlpha *</type>
      <name>gobj_copy</name>
      <anchorfile>classClutter_1_1Alpha.html</anchorfile>
      <anchor>a38b28a0b5cc01b0e9668cc8c86859321</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_timeline</name>
      <anchorfile>classClutter_1_1Alpha.html</anchorfile>
      <anchor>aa1c21dac974b4098974a79f75b00b16d</anchor>
      <arglist>(const Glib::RefPtr&lt; Timeline &gt; &amp;timeline)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Timeline &gt;</type>
      <name>get_timeline</name>
      <anchorfile>classClutter_1_1Alpha.html</anchorfile>
      <anchor>a6cdcd8223a7af89e266389fa6f0e5909</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const Timeline &gt;</type>
      <name>get_timeline</name>
      <anchorfile>classClutter_1_1Alpha.html</anchorfile>
      <anchor>a5a48c5aa5ad13ccb20d7c027ae4edf79</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>get_alpha</name>
      <anchorfile>classClutter_1_1Alpha.html</anchorfile>
      <anchor>a4727bd641010017bbe1264de0a3aecf7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_func</name>
      <anchorfile>classClutter_1_1Alpha.html</anchorfile>
      <anchor>a0006b046a592722e4b03bf9d9bd497f1</anchor>
      <arglist>(const SlotAlphaFunc &amp;slot)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_mode</name>
      <anchorfile>classClutter_1_1Alpha.html</anchorfile>
      <anchor>ac9ef0cd98f2a499b55baec117defeb78</anchor>
      <arglist>(gulong mode)</arglist>
    </member>
    <member kind="function">
      <type>gulong</type>
      <name>get_mode</name>
      <anchorfile>classClutter_1_1Alpha.html</anchorfile>
      <anchor>ad305002cba34a3e839bd244c3c875f34</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; double &gt;</type>
      <name>property_alpha</name>
      <anchorfile>classClutter_1_1Alpha.html</anchorfile>
      <anchor>ae257cdae084e65cbce986bc81bd0b019</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; Glib::RefPtr&lt; Timeline &gt; &gt;</type>
      <name>property_timeline</name>
      <anchorfile>classClutter_1_1Alpha.html</anchorfile>
      <anchor>ae2cdcc8ab4cbfff62f2543c66f8246e2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; Glib::RefPtr&lt; Timeline &gt; &gt;</type>
      <name>property_timeline</name>
      <anchorfile>classClutter_1_1Alpha.html</anchorfile>
      <anchor>a10d7d23a5bedc09b3165b9df60e7d275</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; Alpha &gt;</type>
      <name>create</name>
      <anchorfile>classClutter_1_1Alpha.html</anchorfile>
      <anchor>aedefea7afd63fdd92dee48903d0ac27e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; Alpha &gt;</type>
      <name>create</name>
      <anchorfile>classClutter_1_1Alpha.html</anchorfile>
      <anchor>aa178f84502c213516af10dc88f361504</anchor>
      <arglist>(const Glib::RefPtr&lt; Timeline &gt; &amp;timeline, const SlotAlphaFunc &amp;slot)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; Alpha &gt;</type>
      <name>create</name>
      <anchorfile>classClutter_1_1Alpha.html</anchorfile>
      <anchor>ac089aed5d515841611d021019e7ecdf4</anchor>
      <arglist>(const Glib::RefPtr&lt; Timeline &gt; &amp;timeline, gulong mode)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>Alpha</name>
      <anchorfile>classClutter_1_1Alpha.html</anchorfile>
      <anchor>a4bfd1913114f94db57561369de9fb929</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>Alpha</name>
      <anchorfile>classClutter_1_1Alpha.html</anchorfile>
      <anchor>ae13e662b804fa6f61fa070dc2cf4ab7c</anchor>
      <arglist>(const Glib::RefPtr&lt; Timeline &gt; &amp;timeline, gulong mode)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>Alpha</name>
      <anchorfile>classClutter_1_1Alpha.html</anchorfile>
      <anchor>a11d82e7c212b68103edcd48444d62273</anchor>
      <arglist>(const Glib::RefPtr&lt; Timeline &gt; &amp;timeline, const SlotAlphaFunc &amp;slot)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Clutter::Alpha &gt;</type>
      <name>wrap</name>
      <anchorfile>classClutter_1_1Alpha.html</anchorfile>
      <anchor>a460ea6afd01247f42461793dda64be7a</anchor>
      <arglist>(ClutterAlpha *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Clutter::Animation</name>
    <filename>classClutter_1_1Animation.html</filename>
    <base>Glib::Object</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~Animation</name>
      <anchorfile>classClutter_1_1Animation.html</anchorfile>
      <anchor>aa1292b3a249dd961bde7f740f90e5922</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>ClutterAnimation *</type>
      <name>gobj</name>
      <anchorfile>classClutter_1_1Animation.html</anchorfile>
      <anchor>a326b9a503874eb1818a882cbdcb846ce</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const ClutterAnimation *</type>
      <name>gobj</name>
      <anchorfile>classClutter_1_1Animation.html</anchorfile>
      <anchor>ae8fc9bfe4fccd913c7e8e5f74af05e5b</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>ClutterAnimation *</type>
      <name>gobj_copy</name>
      <anchorfile>classClutter_1_1Animation.html</anchorfile>
      <anchor>adb29cc341948648394ac6b82d419c2fe</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_object</name>
      <anchorfile>classClutter_1_1Animation.html</anchorfile>
      <anchor>ad580be1406a8ab33963bed97f2a6184e</anchor>
      <arglist>(const Glib::RefPtr&lt; Glib::Object &gt; &amp;object)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Glib::Object &gt;</type>
      <name>get_object</name>
      <anchorfile>classClutter_1_1Animation.html</anchorfile>
      <anchor>a4ddbaed55aad944b768976495e0063e2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const Glib::Object &gt;</type>
      <name>get_object</name>
      <anchorfile>classClutter_1_1Animation.html</anchorfile>
      <anchor>aefc74a5d7346acf623d338e42f0424a0</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_mode</name>
      <anchorfile>classClutter_1_1Animation.html</anchorfile>
      <anchor>ae7fb817fefacc4d528cb54b02b489e3c</anchor>
      <arglist>(gulong mode)</arglist>
    </member>
    <member kind="function">
      <type>gulong</type>
      <name>get_mode</name>
      <anchorfile>classClutter_1_1Animation.html</anchorfile>
      <anchor>aa5be69526c6506a51d10e21576336974</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_duration</name>
      <anchorfile>classClutter_1_1Animation.html</anchorfile>
      <anchor>a9a4c70656224f93ccf5a0e3ab126e80d</anchor>
      <arglist>(guint msecs)</arglist>
    </member>
    <member kind="function">
      <type>guint</type>
      <name>get_duration</name>
      <anchorfile>classClutter_1_1Animation.html</anchorfile>
      <anchor>a7971911553c9d6c388a014cbf90e93f3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_loop</name>
      <anchorfile>classClutter_1_1Animation.html</anchorfile>
      <anchor>a5eee7d5f6a7cf26acdfa500fd3b23289</anchor>
      <arglist>(bool loop=true)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_loop</name>
      <anchorfile>classClutter_1_1Animation.html</anchorfile>
      <anchor>a16adb36938ec389bd4865732130f7729</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_timeline</name>
      <anchorfile>classClutter_1_1Animation.html</anchorfile>
      <anchor>a751d00c0ab6befbe703cd0380c6c6776</anchor>
      <arglist>(const Glib::RefPtr&lt; Timeline &gt; &amp;timeline)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Timeline &gt;</type>
      <name>get_timeline</name>
      <anchorfile>classClutter_1_1Animation.html</anchorfile>
      <anchor>a1f7338ab32dd0e6222758c83fbd3e74b</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_alpha</name>
      <anchorfile>classClutter_1_1Animation.html</anchorfile>
      <anchor>aa857e51d642fc276bd293c062d910f11</anchor>
      <arglist>(const Glib::RefPtr&lt; Alpha &gt; &amp;alpha)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Alpha &gt;</type>
      <name>get_alpha</name>
      <anchorfile>classClutter_1_1Animation.html</anchorfile>
      <anchor>a5e20c03fff787dd1dc34f6e8d90add6a</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>completed</name>
      <anchorfile>classClutter_1_1Animation.html</anchorfile>
      <anchor>a08066af57695f54247903150e3fc9bc9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Animation &gt;</type>
      <name>bind</name>
      <anchorfile>classClutter_1_1Animation.html</anchorfile>
      <anchor>a5fcfe197b486fbc175a362d6837fd802</anchor>
      <arglist>(const std::string &amp;property_name, const Glib::ValueBase &amp;final)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>bind_interval</name>
      <anchorfile>classClutter_1_1Animation.html</anchorfile>
      <anchor>a706447e83a955a4fc2edd1a1749d0edb</anchor>
      <arglist>(const std::string &amp;property_name, const Glib::RefPtr&lt; Interval &gt; &amp;interval)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>update_interval</name>
      <anchorfile>classClutter_1_1Animation.html</anchorfile>
      <anchor>adafcab1f3600095e6da8096dec66b9e4</anchor>
      <arglist>(const std::string &amp;property_name, const Glib::RefPtr&lt; Interval &gt; &amp;interval)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>has_property</name>
      <anchorfile>classClutter_1_1Animation.html</anchorfile>
      <anchor>a9cf65d8dba2bb3ae66cfb2ea06545715</anchor>
      <arglist>(const std::string &amp;property_name) const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Animation &gt;</type>
      <name>update</name>
      <anchorfile>classClutter_1_1Animation.html</anchorfile>
      <anchor>abafac0d8b975f345a25ac5c59e7380d4</anchor>
      <arglist>(const std::string &amp;property_name, const Glib::ValueBase &amp;final)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>unbind_property</name>
      <anchorfile>classClutter_1_1Animation.html</anchorfile>
      <anchor>adc8cefeb1ba2c0d270e49085ee838cdb</anchor>
      <arglist>(const std::string &amp;property_name)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Interval &gt;</type>
      <name>get_interval</name>
      <anchorfile>classClutter_1_1Animation.html</anchorfile>
      <anchor>af12ce1ef2cacb395a69eba95576b3bcd</anchor>
      <arglist>(const std::string &amp;property_name) const </arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy0&lt; void &gt;</type>
      <name>signal_started</name>
      <anchorfile>classClutter_1_1Animation.html</anchorfile>
      <anchor>afbc5c0a248b4d6c81eba61f22e26e910</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy0&lt; void &gt;</type>
      <name>signal_completed</name>
      <anchorfile>classClutter_1_1Animation.html</anchorfile>
      <anchor>a211d9f20dc0116f4790d57197cde3cd1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; Glib::RefPtr&lt; Glib::Object &gt; &gt;</type>
      <name>property_object</name>
      <anchorfile>classClutter_1_1Animation.html</anchorfile>
      <anchor>a36ecafd7a822ee686d897dd81a507bf6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; Glib::RefPtr&lt; Glib::Object &gt; &gt;</type>
      <name>property_object</name>
      <anchorfile>classClutter_1_1Animation.html</anchorfile>
      <anchor>a9d4f493ef0f9e3fca89cb71ebcc92504</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; gulong &gt;</type>
      <name>property_mode</name>
      <anchorfile>classClutter_1_1Animation.html</anchorfile>
      <anchor>ae97caa8cb9321c75dc4dc5dfc5d9f2a8</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; gulong &gt;</type>
      <name>property_mode</name>
      <anchorfile>classClutter_1_1Animation.html</anchorfile>
      <anchor>a6fe4d3b1de86763eefc619a477a71c9b</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; guint &gt;</type>
      <name>property_duration</name>
      <anchorfile>classClutter_1_1Animation.html</anchorfile>
      <anchor>a68e6914afc0bbf1c4d7412d86fad8ffe</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; guint &gt;</type>
      <name>property_duration</name>
      <anchorfile>classClutter_1_1Animation.html</anchorfile>
      <anchor>aed1b25d64d799a6d92dd4d8a04b934e1</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; bool &gt;</type>
      <name>property_loop</name>
      <anchorfile>classClutter_1_1Animation.html</anchorfile>
      <anchor>a9e5d093ad46b83b7f750d15fe1b771db</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; bool &gt;</type>
      <name>property_loop</name>
      <anchorfile>classClutter_1_1Animation.html</anchorfile>
      <anchor>a7c2f7529f999cb00c4ac335813fd150d</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; Glib::RefPtr&lt; Timeline &gt; &gt;</type>
      <name>property_timeline</name>
      <anchorfile>classClutter_1_1Animation.html</anchorfile>
      <anchor>a37230ee61d5698abf28e2d8a6c1ec165</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; Glib::RefPtr&lt; Timeline &gt; &gt;</type>
      <name>property_timeline</name>
      <anchorfile>classClutter_1_1Animation.html</anchorfile>
      <anchor>a5520343d407933f01e2c513a3e0df92c</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; Glib::RefPtr&lt; Alpha &gt; &gt;</type>
      <name>property_alpha</name>
      <anchorfile>classClutter_1_1Animation.html</anchorfile>
      <anchor>a48cf5a8e03e3df2ceda269e65d861e33</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; Glib::RefPtr&lt; Alpha &gt; &gt;</type>
      <name>property_alpha</name>
      <anchorfile>classClutter_1_1Animation.html</anchorfile>
      <anchor>ac6cbeba80bf9d9e9c97a94e9235336d2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; Animation &gt;</type>
      <name>create</name>
      <anchorfile>classClutter_1_1Animation.html</anchorfile>
      <anchor>a90514ac099ac1ed8c1c08956febe86e3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>Animation</name>
      <anchorfile>classClutter_1_1Animation.html</anchorfile>
      <anchor>adf9c4c288d244999e9eb2933fd069c01</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>on_started</name>
      <anchorfile>classClutter_1_1Animation.html</anchorfile>
      <anchor>a67d4136a7b16bb956f16eab80571841e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>on_completed</name>
      <anchorfile>classClutter_1_1Animation.html</anchorfile>
      <anchor>aada88dfd239b8109cf5bda5c42c1da71</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Clutter::Animation &gt;</type>
      <name>wrap</name>
      <anchorfile>classClutter_1_1Animation.html</anchorfile>
      <anchor>ae5916a962447104464ee2d8de8c6e744</anchor>
      <arglist>(ClutterAnimation *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Clutter::Animator</name>
    <filename>classClutter_1_1Animator.html</filename>
    <base>Glib::Object</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~Animator</name>
      <anchorfile>classClutter_1_1Animator.html</anchorfile>
      <anchor>acb9e439ff212cc33a66b08d6250e8b4d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>ClutterAnimator *</type>
      <name>gobj</name>
      <anchorfile>classClutter_1_1Animator.html</anchorfile>
      <anchor>afdbee3a9b39a553c9594f744254b7163</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const ClutterAnimator *</type>
      <name>gobj</name>
      <anchorfile>classClutter_1_1Animator.html</anchorfile>
      <anchor>a789f65fae107e01a3133717ed40afaf3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>ClutterAnimator *</type>
      <name>gobj_copy</name>
      <anchorfile>classClutter_1_1Animator.html</anchorfile>
      <anchor>a4055bad914124f23dbecd998a9cd0355</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Animator &gt;</type>
      <name>set_key</name>
      <anchorfile>classClutter_1_1Animator.html</anchorfile>
      <anchor>abea0cdd43f08fc601fd85cccffa5a7b7</anchor>
      <arglist>(const Glib::RefPtr&lt; Glib::Object &gt; &amp;object, const Glib::ustring &amp;property_name, guint mode, double progress, const Glib::ValueBase &amp;value)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const Animator &gt;</type>
      <name>set_key</name>
      <anchorfile>classClutter_1_1Animator.html</anchorfile>
      <anchor>a228b4e0d0cf1b1fef1cba60e7c986aa2</anchor>
      <arglist>(const Glib::RefPtr&lt; Glib::Object &gt; &amp;object, const Glib::ustring &amp;property_name, guint mode, double progress, const Glib::ValueBase &amp;value) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>remove_key</name>
      <anchorfile>classClutter_1_1Animator.html</anchorfile>
      <anchor>a3939ca34026daf2e0f977368b32da785</anchor>
      <arglist>(const Glib::RefPtr&lt; Glib::Object &gt; &amp;object, const Glib::ustring &amp;property_name, double progress)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Timeline &gt;</type>
      <name>start</name>
      <anchorfile>classClutter_1_1Animator.html</anchorfile>
      <anchor>ac47233e76fc58b7767d82513e21edaa4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const Timeline &gt;</type>
      <name>start</name>
      <anchorfile>classClutter_1_1Animator.html</anchorfile>
      <anchor>a61670f43e126214907ff7f22fc0da3fc</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>compute_value</name>
      <anchorfile>classClutter_1_1Animator.html</anchorfile>
      <anchor>aa82532aa5a602c5025636e38c702c785</anchor>
      <arglist>(const Glib::RefPtr&lt; Glib::Object &gt; &amp;object, const Glib::ustring &amp;property_name, double progress, Glib::ValueBase &amp;value)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_timeline</name>
      <anchorfile>classClutter_1_1Animator.html</anchorfile>
      <anchor>abcd4c108eb4167f6ec48f6cc3562984c</anchor>
      <arglist>(const Glib::RefPtr&lt; Timeline &gt; &amp;timeline)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Timeline &gt;</type>
      <name>get_timeline</name>
      <anchorfile>classClutter_1_1Animator.html</anchorfile>
      <anchor>ad053358426350ac0861e3bc0edb358d4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const Timeline &gt;</type>
      <name>get_timeline</name>
      <anchorfile>classClutter_1_1Animator.html</anchorfile>
      <anchor>ac5add2b5a71390fc82470ee0721ba1c8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_duration</name>
      <anchorfile>classClutter_1_1Animator.html</anchorfile>
      <anchor>ab9d14a26fb5dc3fe4ee6d960b6836a0c</anchor>
      <arglist>(guint duration)</arglist>
    </member>
    <member kind="function">
      <type>guint</type>
      <name>get_duration</name>
      <anchorfile>classClutter_1_1Animator.html</anchorfile>
      <anchor>a1e496428ce71936701ab64f949486d05</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>property_set_ease_in</name>
      <anchorfile>classClutter_1_1Animator.html</anchorfile>
      <anchor>a6a2fa4c81f7b6fb384bff28cecf9d26d</anchor>
      <arglist>(const Glib::RefPtr&lt; Glib::Object &gt; &amp;object, const Glib::ustring &amp;property_name, bool ease_in)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>property_get_ease_in</name>
      <anchorfile>classClutter_1_1Animator.html</anchorfile>
      <anchor>ae316c22852bc08f82aa766823ba12f01</anchor>
      <arglist>(const Glib::RefPtr&lt; Glib::Object &gt; &amp;object, const Glib::ustring &amp;property_name)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>property_set_interpolation</name>
      <anchorfile>classClutter_1_1Animator.html</anchorfile>
      <anchor>ade9018665f09c549fb2fc78f902d9c18</anchor>
      <arglist>(const Glib::RefPtr&lt; Glib::Object &gt; &amp;object, const Glib::ustring &amp;property_name, Interpolation interpolation)</arglist>
    </member>
    <member kind="function">
      <type>Interpolation</type>
      <name>property_get_interpolation</name>
      <anchorfile>classClutter_1_1Animator.html</anchorfile>
      <anchor>a43e10dd5fd3c81be09d3daede719a0ec</anchor>
      <arglist>(const Glib::RefPtr&lt; Glib::Object &gt; &amp;object, const Glib::ustring &amp;property_name)</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; guint &gt;</type>
      <name>property_duration</name>
      <anchorfile>classClutter_1_1Animator.html</anchorfile>
      <anchor>a7e13d5b2e32021b6a4b9ec8aadda639f</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; guint &gt;</type>
      <name>property_duration</name>
      <anchorfile>classClutter_1_1Animator.html</anchorfile>
      <anchor>a4cec115282f3276dc90748f57fe18d6c</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; Glib::RefPtr&lt; Timeline &gt; &gt;</type>
      <name>property_timeline</name>
      <anchorfile>classClutter_1_1Animator.html</anchorfile>
      <anchor>a03425bd2ff76dc5f920c5781df16b3d1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; Glib::RefPtr&lt; Timeline &gt; &gt;</type>
      <name>property_timeline</name>
      <anchorfile>classClutter_1_1Animator.html</anchorfile>
      <anchor>a68144ecde02fbb09c4954e7ebd3a2bde</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; Animator &gt;</type>
      <name>create</name>
      <anchorfile>classClutter_1_1Animator.html</anchorfile>
      <anchor>a454492a38bb25ba9e682eb11a77bdcc3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>Animator</name>
      <anchorfile>classClutter_1_1Animator.html</anchorfile>
      <anchor>a8b1532613486b4f0fae59350ab36d58c</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Clutter::Animator &gt;</type>
      <name>wrap</name>
      <anchorfile>classClutter_1_1Animator.html</anchorfile>
      <anchor>aaa1d543e5191fcbc88988d010d763694</anchor>
      <arglist>(ClutterAnimator *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Clutter::Backend</name>
    <filename>classClutter_1_1Backend.html</filename>
    <base>Glib::Object</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~Backend</name>
      <anchorfile>classClutter_1_1Backend.html</anchorfile>
      <anchor>afd4ab58b34dc4c9210e8d363cb9e0b49</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>ClutterBackend *</type>
      <name>gobj</name>
      <anchorfile>classClutter_1_1Backend.html</anchorfile>
      <anchor>aea741292a3aaef1820bbbe73549a0d93</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const ClutterBackend *</type>
      <name>gobj</name>
      <anchorfile>classClutter_1_1Backend.html</anchorfile>
      <anchor>ac2d975f6a75e54ac1f035833721b419f</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>ClutterBackend *</type>
      <name>gobj_copy</name>
      <anchorfile>classClutter_1_1Backend.html</anchorfile>
      <anchor>ab130eaa456641897addf738915d1d722</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>get_resolution</name>
      <anchorfile>classClutter_1_1Backend.html</anchorfile>
      <anchor>aee3f548046b44f4f55631395c6154c92</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_resolution</name>
      <anchorfile>classClutter_1_1Backend.html</anchorfile>
      <anchor>af3ccbfc307ed7842d8a730866d0dc907</anchor>
      <arglist>(double dpi)</arglist>
    </member>
    <member kind="function">
      <type>guint</type>
      <name>get_double_click_time</name>
      <anchorfile>classClutter_1_1Backend.html</anchorfile>
      <anchor>a0afb8694d6c0c4a29311156c2c093359</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_double_click_time</name>
      <anchorfile>classClutter_1_1Backend.html</anchorfile>
      <anchor>a1eb37531f7da87fe9b437fb15855e43f</anchor>
      <arglist>(guint msec)</arglist>
    </member>
    <member kind="function">
      <type>guint</type>
      <name>get_double_click_distance</name>
      <anchorfile>classClutter_1_1Backend.html</anchorfile>
      <anchor>aa3142f6f7a18be78e589d5d9c60dbd13</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_double_click_distance</name>
      <anchorfile>classClutter_1_1Backend.html</anchorfile>
      <anchor>acc726e03ec04972b0eb4be1dd14079f8</anchor>
      <arglist>(guint distance)</arglist>
    </member>
    <member kind="function">
      <type>::Cairo::FontOptions</type>
      <name>get_font_options</name>
      <anchorfile>classClutter_1_1Backend.html</anchorfile>
      <anchor>a6e42c901b78db6d10006cd97eb424d4f</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_font_options</name>
      <anchorfile>classClutter_1_1Backend.html</anchorfile>
      <anchor>a85b855cede6b6a954ed04b5868f205ca</anchor>
      <arglist>(const ::Cairo::FontOptions &amp;options)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_font_name</name>
      <anchorfile>classClutter_1_1Backend.html</anchorfile>
      <anchor>a36ab3f7e948de8c7cfa7621ad84cb939</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_font_name</name>
      <anchorfile>classClutter_1_1Backend.html</anchorfile>
      <anchor>a3a1d15e13efe503b46b232ab19da5210</anchor>
      <arglist>(const Glib::ustring &amp;font_name)</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy0&lt; void &gt;</type>
      <name>signal_font_changed</name>
      <anchorfile>classClutter_1_1Backend.html</anchorfile>
      <anchor>ac3e49b8ad1fb2bc9ad45f6228ccbcf3f</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy0&lt; void &gt;</type>
      <name>signal_resolution_changed</name>
      <anchorfile>classClutter_1_1Backend.html</anchorfile>
      <anchor>afeaa26069f14cfbf63af1aa7dd0ef498</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; Backend &gt;</type>
      <name>get_default</name>
      <anchorfile>classClutter_1_1Backend.html</anchorfile>
      <anchor>a49a032b5c10eb26e437680eac7295109</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>Backend</name>
      <anchorfile>classClutter_1_1Backend.html</anchorfile>
      <anchor>a841d048895293afb8d2ac5261001db44</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Clutter::Backend &gt;</type>
      <name>wrap</name>
      <anchorfile>classClutter_1_1Backend.html</anchorfile>
      <anchor>ae5dfa3d88c5e366831cd7178a09ab857</anchor>
      <arglist>(ClutterBackend *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Clutter::Behaviour</name>
    <filename>classClutter_1_1Behaviour.html</filename>
    <base>Glib::Object</base>
    <member kind="typedef">
      <type>sigc::slot&lt; void, const Glib::RefPtr&lt; Behaviour &gt; &amp;, const Glib::RefPtr&lt; Actor &gt; &amp; &gt;</type>
      <name>SlotForEach</name>
      <anchorfile>classClutter_1_1Behaviour.html</anchorfile>
      <anchor>a46f6c621452b3b4f0a11fd4ad2970cd9</anchor>
      <arglist></arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~Behaviour</name>
      <anchorfile>classClutter_1_1Behaviour.html</anchorfile>
      <anchor>a98edda94bbb7dde1cbc93e45d7cd87ac</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>ClutterBehaviour *</type>
      <name>gobj</name>
      <anchorfile>classClutter_1_1Behaviour.html</anchorfile>
      <anchor>ad2cb9b831ad8a42c0046270fd99df5b2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const ClutterBehaviour *</type>
      <name>gobj</name>
      <anchorfile>classClutter_1_1Behaviour.html</anchorfile>
      <anchor>a1e8252a01ae2995f773dce52b73b1794</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>ClutterBehaviour *</type>
      <name>gobj_copy</name>
      <anchorfile>classClutter_1_1Behaviour.html</anchorfile>
      <anchor>aca7b7889db9eb1562ce4421d51cdc0b1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>apply</name>
      <anchorfile>classClutter_1_1Behaviour.html</anchorfile>
      <anchor>a254808b37fe98c0ecdcc9aba00d2fa48</anchor>
      <arglist>(const Glib::RefPtr&lt; Actor &gt; &amp;actor)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>remove</name>
      <anchorfile>classClutter_1_1Behaviour.html</anchorfile>
      <anchor>a1d72f9251e3af60dfbafccb490644db3</anchor>
      <arglist>(const Glib::RefPtr&lt; Actor &gt; &amp;actor)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>remove_all</name>
      <anchorfile>classClutter_1_1Behaviour.html</anchorfile>
      <anchor>a7ff437e5df797b4ba99f425ce1cd1648</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_applied</name>
      <anchorfile>classClutter_1_1Behaviour.html</anchorfile>
      <anchor>ae286ecbdf2f1b6e61bdff7ae9bba2585</anchor>
      <arglist>(const Glib::RefPtr&lt; Actor &gt; &amp;actor)</arglist>
    </member>
    <member kind="function">
      <type>std::vector&lt; Glib::RefPtr&lt; Actor &gt; &gt;</type>
      <name>get_actors</name>
      <anchorfile>classClutter_1_1Behaviour.html</anchorfile>
      <anchor>ab166491d686254cb374db328b474bbd7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>std::vector&lt; Glib::RefPtr&lt; Actor const  &gt; &gt;</type>
      <name>get_actors</name>
      <anchorfile>classClutter_1_1Behaviour.html</anchorfile>
      <anchor>afd1998b7f013b642c6b15291af820250</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>get_n_actors</name>
      <anchorfile>classClutter_1_1Behaviour.html</anchorfile>
      <anchor>a87af3f026a81c4d5bda4e53230a2d83a</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Actor &gt;</type>
      <name>get_nth_actor</name>
      <anchorfile>classClutter_1_1Behaviour.html</anchorfile>
      <anchor>a0b518c6b36e75cdbb0638e59f2aac727</anchor>
      <arglist>(int index)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const Actor &gt;</type>
      <name>get_nth_actor</name>
      <anchorfile>classClutter_1_1Behaviour.html</anchorfile>
      <anchor>ad9c8f2a4c2d134737354d4b1142c3c50</anchor>
      <arglist>(int index) const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Alpha &gt;</type>
      <name>get_alpha</name>
      <anchorfile>classClutter_1_1Behaviour.html</anchorfile>
      <anchor>a2f081d1a2e9e9b79679a9a43f9f755c2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const Alpha &gt;</type>
      <name>get_alpha</name>
      <anchorfile>classClutter_1_1Behaviour.html</anchorfile>
      <anchor>ada129376f9023d1d283cc3c57b6a8a57</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_alpha</name>
      <anchorfile>classClutter_1_1Behaviour.html</anchorfile>
      <anchor>a2b0e0c31c6f45c8219c2df1b9aebee7a</anchor>
      <arglist>(const Glib::RefPtr&lt; Alpha &gt; &amp;alpha)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>actors_foreach</name>
      <anchorfile>classClutter_1_1Behaviour.html</anchorfile>
      <anchor>ac905d8d2c8a642d21161e998c03a459d</anchor>
      <arglist>(const SlotForEach &amp;slot)</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy1&lt; void, const Glib::RefPtr&lt; Actor &gt; &amp; &gt;</type>
      <name>signal_applied</name>
      <anchorfile>classClutter_1_1Behaviour.html</anchorfile>
      <anchor>a7a0954e1e8379bca4c51c60ee09fb1b8</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy1&lt; void, const Glib::RefPtr&lt; Actor &gt; &amp; &gt;</type>
      <name>signal_removed</name>
      <anchorfile>classClutter_1_1Behaviour.html</anchorfile>
      <anchor>a0de787fd06a6de1f4a3a8b53a7e2823c</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>Behaviour</name>
      <anchorfile>classClutter_1_1Behaviour.html</anchorfile>
      <anchor>a81c14c748e423276c20cfcbc23c5d765</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>alpha_notify_vfunc</name>
      <anchorfile>classClutter_1_1Behaviour.html</anchorfile>
      <anchor>a63fcc155a153a387147fa8da4685d511</anchor>
      <arglist>(double alpha_value)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>on_applied</name>
      <anchorfile>classClutter_1_1Behaviour.html</anchorfile>
      <anchor>aa9e15400407781424aa34299639cc156</anchor>
      <arglist>(const Glib::RefPtr&lt; Actor &gt; &amp;actor)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>on_removed</name>
      <anchorfile>classClutter_1_1Behaviour.html</anchorfile>
      <anchor>a8da6d10818e751d72b297f456178f35e</anchor>
      <arglist>(const Glib::RefPtr&lt; Actor &gt; &amp;actor)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Clutter::Behaviour &gt;</type>
      <name>wrap</name>
      <anchorfile>classClutter_1_1Behaviour.html</anchorfile>
      <anchor>ae2f89bbab0d0c27486fa02572e0b133b</anchor>
      <arglist>(ClutterBehaviour *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Clutter::BehaviourDepth</name>
    <filename>classClutter_1_1BehaviourDepth.html</filename>
    <base>Clutter::Behaviour</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~BehaviourDepth</name>
      <anchorfile>classClutter_1_1BehaviourDepth.html</anchorfile>
      <anchor>af05eeb0b9685419a0c3534ed8c2b6682</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>ClutterBehaviourDepth *</type>
      <name>gobj</name>
      <anchorfile>classClutter_1_1BehaviourDepth.html</anchorfile>
      <anchor>a2bb9c3460d633c95098ecebc90b62330</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const ClutterBehaviourDepth *</type>
      <name>gobj</name>
      <anchorfile>classClutter_1_1BehaviourDepth.html</anchorfile>
      <anchor>ae0d73e1bf1e83ab61cda8435d54a2d6c</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>ClutterBehaviourDepth *</type>
      <name>gobj_copy</name>
      <anchorfile>classClutter_1_1BehaviourDepth.html</anchorfile>
      <anchor>a4a978e6d46236564e9e519d507fa1ba6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_bounds</name>
      <anchorfile>classClutter_1_1BehaviourDepth.html</anchorfile>
      <anchor>a8c344836b942a665a74c80a554d5cf11</anchor>
      <arglist>(int depth_start, int depth_end)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>get_bounds</name>
      <anchorfile>classClutter_1_1BehaviourDepth.html</anchorfile>
      <anchor>a3d5f9b8fdd25c8b4999da0715a4d7dc6</anchor>
      <arglist>(int &amp;depth_start, int &amp;depth_end)</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; int &gt;</type>
      <name>property_depth_end</name>
      <anchorfile>classClutter_1_1BehaviourDepth.html</anchorfile>
      <anchor>a180db88b94490d809759d197fb6be264</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; int &gt;</type>
      <name>property_depth_end</name>
      <anchorfile>classClutter_1_1BehaviourDepth.html</anchorfile>
      <anchor>a0bc598b21fc504221334cf89f77c1282</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; int &gt;</type>
      <name>property_depth_start</name>
      <anchorfile>classClutter_1_1BehaviourDepth.html</anchorfile>
      <anchor>ae459887a5e0cf62eed701b585b2930a2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; int &gt;</type>
      <name>property_depth_start</name>
      <anchorfile>classClutter_1_1BehaviourDepth.html</anchorfile>
      <anchor>a1e4422b46b18641828922a5968bbac10</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; BehaviourDepth &gt;</type>
      <name>create</name>
      <anchorfile>classClutter_1_1BehaviourDepth.html</anchorfile>
      <anchor>aafcab39970a4a59f30a8fb533187e2b0</anchor>
      <arglist>(const Glib::RefPtr&lt; Alpha &gt; &amp;alpha, int start_depth, int end_depth)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>BehaviourDepth</name>
      <anchorfile>classClutter_1_1BehaviourDepth.html</anchorfile>
      <anchor>adb74cb529f888d4f55a8fece131d484d</anchor>
      <arglist>(const Glib::RefPtr&lt; Alpha &gt; &amp;alpha, int depth_start, int depth_end)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Clutter::BehaviourDepth &gt;</type>
      <name>wrap</name>
      <anchorfile>classClutter_1_1BehaviourDepth.html</anchorfile>
      <anchor>ad805769338e038029b5f331a84780974</anchor>
      <arglist>(ClutterBehaviourDepth *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Clutter::BehaviourEllipse</name>
    <filename>classClutter_1_1BehaviourEllipse.html</filename>
    <base>Clutter::Behaviour</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~BehaviourEllipse</name>
      <anchorfile>classClutter_1_1BehaviourEllipse.html</anchorfile>
      <anchor>abf799817ddef16e05936a75535f7b1d5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>ClutterBehaviourEllipse *</type>
      <name>gobj</name>
      <anchorfile>classClutter_1_1BehaviourEllipse.html</anchorfile>
      <anchor>a9cdcee91a1343de41cfebe518c674415</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const ClutterBehaviourEllipse *</type>
      <name>gobj</name>
      <anchorfile>classClutter_1_1BehaviourEllipse.html</anchorfile>
      <anchor>a8605ebce9fba56291516fde489eb55fc</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>ClutterBehaviourEllipse *</type>
      <name>gobj_copy</name>
      <anchorfile>classClutter_1_1BehaviourEllipse.html</anchorfile>
      <anchor>a617f2909f037abb4e6ffd45b1856b849</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_center</name>
      <anchorfile>classClutter_1_1BehaviourEllipse.html</anchorfile>
      <anchor>aa507be3b2c559d1124bd4d934ad4411d</anchor>
      <arglist>(int x, int y)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>get_center</name>
      <anchorfile>classClutter_1_1BehaviourEllipse.html</anchorfile>
      <anchor>a67eac4d7b2b3131bf053ad1dcd9799e0</anchor>
      <arglist>(int &amp;x, int &amp;y) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_height</name>
      <anchorfile>classClutter_1_1BehaviourEllipse.html</anchorfile>
      <anchor>ab4c9e094e8064d31dc12d1aa93be6951</anchor>
      <arglist>(int height)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>get_height</name>
      <anchorfile>classClutter_1_1BehaviourEllipse.html</anchorfile>
      <anchor>a8832e1905f286b22ef08d12da9550a05</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_width</name>
      <anchorfile>classClutter_1_1BehaviourEllipse.html</anchorfile>
      <anchor>a406feac184affd3a1327ebb08f511c6c</anchor>
      <arglist>(int width)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>get_width</name>
      <anchorfile>classClutter_1_1BehaviourEllipse.html</anchorfile>
      <anchor>ac80eb5b3183a8075ba7fa4d3522d896c</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_angle_start</name>
      <anchorfile>classClutter_1_1BehaviourEllipse.html</anchorfile>
      <anchor>ac5bdf9b2e629bea742c71df7074bdd64</anchor>
      <arglist>(double angle_start)</arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>get_angle_start</name>
      <anchorfile>classClutter_1_1BehaviourEllipse.html</anchorfile>
      <anchor>ac51a86d54f6965734c0096ebe3e095f0</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_angle_end</name>
      <anchorfile>classClutter_1_1BehaviourEllipse.html</anchorfile>
      <anchor>a453215dd498a4362327de402e9730be7</anchor>
      <arglist>(double angle_end)</arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>get_angle_end</name>
      <anchorfile>classClutter_1_1BehaviourEllipse.html</anchorfile>
      <anchor>a66f9a220cb1381dfc59d102a49905650</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_angle_tilt</name>
      <anchorfile>classClutter_1_1BehaviourEllipse.html</anchorfile>
      <anchor>a9e9124ffa55b21de8e5cb654cde3a5ce</anchor>
      <arglist>(RotateAxis axis, double angle_tilt)</arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>get_angle_tilt</name>
      <anchorfile>classClutter_1_1BehaviourEllipse.html</anchorfile>
      <anchor>ac30ec7cc925b97dc5d74551befebf2d6</anchor>
      <arglist>(RotateAxis axis) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_tilt</name>
      <anchorfile>classClutter_1_1BehaviourEllipse.html</anchorfile>
      <anchor>a8bdde5eee42af986b294b15a55f3c43a</anchor>
      <arglist>(double angle_tilt_x, double angle_tilt_y, double angle_tilt_z)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>get_tilt</name>
      <anchorfile>classClutter_1_1BehaviourEllipse.html</anchorfile>
      <anchor>a9be718df6e7e35a121931508e0dd836b</anchor>
      <arglist>(double &amp;angle_tilt_x, double &amp;angle_tilt_y, double &amp;angle_tilt_z) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_direction</name>
      <anchorfile>classClutter_1_1BehaviourEllipse.html</anchorfile>
      <anchor>a8bf9df0b2126de42cacc7f3e4aafc318</anchor>
      <arglist>(RotateDirection direction)</arglist>
    </member>
    <member kind="function">
      <type>RotateDirection</type>
      <name>get_direction</name>
      <anchorfile>classClutter_1_1BehaviourEllipse.html</anchorfile>
      <anchor>a0f5505ee0f055268a990c80cd4b842bf</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; double &gt;</type>
      <name>property_angle_end</name>
      <anchorfile>classClutter_1_1BehaviourEllipse.html</anchorfile>
      <anchor>a1525e5902a5cbac00b8c46bdfc0bbae1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; double &gt;</type>
      <name>property_angle_end</name>
      <anchorfile>classClutter_1_1BehaviourEllipse.html</anchorfile>
      <anchor>a25c23b45b0a64cf672de5b6e889a5885</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; double &gt;</type>
      <name>property_angle_start</name>
      <anchorfile>classClutter_1_1BehaviourEllipse.html</anchorfile>
      <anchor>a00966bd202d46013ce9fadf9b9d2c6a7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; double &gt;</type>
      <name>property_angle_start</name>
      <anchorfile>classClutter_1_1BehaviourEllipse.html</anchorfile>
      <anchor>a5b969db4844e10e296b8d43e526048ba</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; double &gt;</type>
      <name>property_angle_tilt_x</name>
      <anchorfile>classClutter_1_1BehaviourEllipse.html</anchorfile>
      <anchor>a0344c1bb8e649760ab0b82de6a0ef62a</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; double &gt;</type>
      <name>property_angle_tilt_x</name>
      <anchorfile>classClutter_1_1BehaviourEllipse.html</anchorfile>
      <anchor>a6769c6328c47aba7f49d06cbfe22ea5c</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; double &gt;</type>
      <name>property_angle_tilt_y</name>
      <anchorfile>classClutter_1_1BehaviourEllipse.html</anchorfile>
      <anchor>a416560120ec8597bab0b3984185d4673</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; double &gt;</type>
      <name>property_angle_tilt_y</name>
      <anchorfile>classClutter_1_1BehaviourEllipse.html</anchorfile>
      <anchor>a5ceafdcc051072df2b331e7bcd5d0a22</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; double &gt;</type>
      <name>property_angle_tilt_z</name>
      <anchorfile>classClutter_1_1BehaviourEllipse.html</anchorfile>
      <anchor>aae24602d826ac61209b422c080524dae</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; double &gt;</type>
      <name>property_angle_tilt_z</name>
      <anchorfile>classClutter_1_1BehaviourEllipse.html</anchorfile>
      <anchor>ace833aa0bec4710f61229094147d6a8e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; Knot &gt;</type>
      <name>property_center</name>
      <anchorfile>classClutter_1_1BehaviourEllipse.html</anchorfile>
      <anchor>ad7a1f5177ca5608e51ee00d16f114df6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; Knot &gt;</type>
      <name>property_center</name>
      <anchorfile>classClutter_1_1BehaviourEllipse.html</anchorfile>
      <anchor>a849bb0778398f278f039e68d5904930a</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; RotateDirection &gt;</type>
      <name>property_direction</name>
      <anchorfile>classClutter_1_1BehaviourEllipse.html</anchorfile>
      <anchor>ae3f95b08728a00a3534fb72d37cf2046</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; RotateDirection &gt;</type>
      <name>property_direction</name>
      <anchorfile>classClutter_1_1BehaviourEllipse.html</anchorfile>
      <anchor>a5c1a0e660341c98b933f21b5af229c3d</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; int &gt;</type>
      <name>property_height</name>
      <anchorfile>classClutter_1_1BehaviourEllipse.html</anchorfile>
      <anchor>ac0a7809ce5c5fb60952a5a2faef547be</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; int &gt;</type>
      <name>property_height</name>
      <anchorfile>classClutter_1_1BehaviourEllipse.html</anchorfile>
      <anchor>a3382ef77ff9dcdea70a00cf2fe0622a7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; int &gt;</type>
      <name>property_width</name>
      <anchorfile>classClutter_1_1BehaviourEllipse.html</anchorfile>
      <anchor>a86d54a383a481163e849247d265ea486</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; int &gt;</type>
      <name>property_width</name>
      <anchorfile>classClutter_1_1BehaviourEllipse.html</anchorfile>
      <anchor>aea4a737576bc403e1335ce6d3dcd685b</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; BehaviourEllipse &gt;</type>
      <name>create</name>
      <anchorfile>classClutter_1_1BehaviourEllipse.html</anchorfile>
      <anchor>a0f15a25aebf70cb3ef07d411565811d0</anchor>
      <arglist>(const Glib::RefPtr&lt; Alpha &gt; &amp;alpha, int x, int y, int width, int height, RotateDirection direction, double begin, double end)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>BehaviourEllipse</name>
      <anchorfile>classClutter_1_1BehaviourEllipse.html</anchorfile>
      <anchor>aca8558d4785f8fc182cd9aa8da23ba03</anchor>
      <arglist>(const Glib::RefPtr&lt; Alpha &gt; &amp;alpha, int x, int y, int width, int height, RotateDirection direction, double angle_start, double angle_end)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Clutter::BehaviourEllipse &gt;</type>
      <name>wrap</name>
      <anchorfile>classClutter_1_1BehaviourEllipse.html</anchorfile>
      <anchor>ab1b03b3ca58ea4e49711c42ec1fbd9e9</anchor>
      <arglist>(ClutterBehaviourEllipse *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Clutter::BehaviourOpacity</name>
    <filename>classClutter_1_1BehaviourOpacity.html</filename>
    <base>Clutter::Behaviour</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~BehaviourOpacity</name>
      <anchorfile>classClutter_1_1BehaviourOpacity.html</anchorfile>
      <anchor>ac6c6dd35864cc92dfedea184ed3462d7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>ClutterBehaviourOpacity *</type>
      <name>gobj</name>
      <anchorfile>classClutter_1_1BehaviourOpacity.html</anchorfile>
      <anchor>a549ebdeefacc44132f120ce891617f1b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const ClutterBehaviourOpacity *</type>
      <name>gobj</name>
      <anchorfile>classClutter_1_1BehaviourOpacity.html</anchorfile>
      <anchor>ac7313b6aefcdaeda5a24329c7c9e267b</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>ClutterBehaviourOpacity *</type>
      <name>gobj_copy</name>
      <anchorfile>classClutter_1_1BehaviourOpacity.html</anchorfile>
      <anchor>aca952b50597e4dea2140697a797c256c</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_bounds</name>
      <anchorfile>classClutter_1_1BehaviourOpacity.html</anchorfile>
      <anchor>a5d908c256fbaf8758f5078c116e0fbe8</anchor>
      <arglist>(guint8 opacity_start, guint8 opacity_end)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>get_bounds</name>
      <anchorfile>classClutter_1_1BehaviourOpacity.html</anchorfile>
      <anchor>a203415008da042aa702cc3390c996f8a</anchor>
      <arglist>(guint8 &amp;opacity_start, guint8 &amp;opacity_end) const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; guint &gt;</type>
      <name>property_opacity_end</name>
      <anchorfile>classClutter_1_1BehaviourOpacity.html</anchorfile>
      <anchor>a3d3282b0bf9a8e13cf99159c871c7ee8</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; guint &gt;</type>
      <name>property_opacity_end</name>
      <anchorfile>classClutter_1_1BehaviourOpacity.html</anchorfile>
      <anchor>a2c5210b5ed25b0adb864bbfc968e1de2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; guint &gt;</type>
      <name>property_opacity_start</name>
      <anchorfile>classClutter_1_1BehaviourOpacity.html</anchorfile>
      <anchor>abe753133fcc5c3b64ec3d8ee33b703ea</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; guint &gt;</type>
      <name>property_opacity_start</name>
      <anchorfile>classClutter_1_1BehaviourOpacity.html</anchorfile>
      <anchor>a6acfecbced6684365cc851ac92004529</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; BehaviourOpacity &gt;</type>
      <name>create</name>
      <anchorfile>classClutter_1_1BehaviourOpacity.html</anchorfile>
      <anchor>af0d5732b2bc78247e4b413ab224a26ab</anchor>
      <arglist>(const Glib::RefPtr&lt; Alpha &gt; &amp;alpha, guint8 opacity_start, guint8 opacity_end)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>BehaviourOpacity</name>
      <anchorfile>classClutter_1_1BehaviourOpacity.html</anchorfile>
      <anchor>a9788267fa0a79d89aee3d620139c106b</anchor>
      <arglist>(const Glib::RefPtr&lt; Alpha &gt; &amp;alpha, guint8 opacity_start, guint8 opacity_end)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Clutter::BehaviourOpacity &gt;</type>
      <name>wrap</name>
      <anchorfile>classClutter_1_1BehaviourOpacity.html</anchorfile>
      <anchor>a738bd46061efb402e4dc69dd6e1ae805</anchor>
      <arglist>(ClutterBehaviourOpacity *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Clutter::BehaviourPath</name>
    <filename>classClutter_1_1BehaviourPath.html</filename>
    <base>Clutter::Behaviour</base>
    <base>Clutter::Scriptable</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~BehaviourPath</name>
      <anchorfile>classClutter_1_1BehaviourPath.html</anchorfile>
      <anchor>aca6c13c1546bc63b515f25d2b4869cd1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>ClutterBehaviourPath *</type>
      <name>gobj</name>
      <anchorfile>classClutter_1_1BehaviourPath.html</anchorfile>
      <anchor>af52219802ba58747e725bcf468f893cf</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const ClutterBehaviourPath *</type>
      <name>gobj</name>
      <anchorfile>classClutter_1_1BehaviourPath.html</anchorfile>
      <anchor>a72d704613c356f857ead191df753125b</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>ClutterBehaviourPath *</type>
      <name>gobj_copy</name>
      <anchorfile>classClutter_1_1BehaviourPath.html</anchorfile>
      <anchor>ad12ae413c3febe18fde91b94b6e83df1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_path</name>
      <anchorfile>classClutter_1_1BehaviourPath.html</anchorfile>
      <anchor>ac42532cf8306eb5d891e40fa4720e468</anchor>
      <arglist>(const Glib::RefPtr&lt; Path &gt; &amp;path)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Path &gt;</type>
      <name>get_path</name>
      <anchorfile>classClutter_1_1BehaviourPath.html</anchorfile>
      <anchor>a15c34a8f25b46478b3ab267300f35b79</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const Path &gt;</type>
      <name>get_path</name>
      <anchorfile>classClutter_1_1BehaviourPath.html</anchorfile>
      <anchor>a03b5abd52dc3a4659db05e60a6809eff</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy1&lt; void, guint &gt;</type>
      <name>signal_knot_reached</name>
      <anchorfile>classClutter_1_1BehaviourPath.html</anchorfile>
      <anchor>a948c84d9e61b691bf97c7a7318bca3fc</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; BehaviourPath &gt;</type>
      <name>create</name>
      <anchorfile>classClutter_1_1BehaviourPath.html</anchorfile>
      <anchor>a809b065f3caec1c4e5a79b187044c0cb</anchor>
      <arglist>(const Glib::RefPtr&lt; Alpha &gt; &amp;alpha, const Glib::RefPtr&lt; Path &gt; &amp;path)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; BehaviourPath &gt;</type>
      <name>create_with_knots</name>
      <anchorfile>classClutter_1_1BehaviourPath.html</anchorfile>
      <anchor>a0c2e92c3879b3c9633c165749f0e36b5</anchor>
      <arglist>(const Glib::RefPtr&lt; Alpha &gt; &amp;alpha, const std::vector&lt; Knot &gt; &amp;knots)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; BehaviourPath &gt;</type>
      <name>create_with_description</name>
      <anchorfile>classClutter_1_1BehaviourPath.html</anchorfile>
      <anchor>a6ddaafb9be3baafd7011e2877e899644</anchor>
      <arglist>(const Glib::RefPtr&lt; Alpha &gt; &amp;alpha, const Glib::ustring &amp;description)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>BehaviourPath</name>
      <anchorfile>classClutter_1_1BehaviourPath.html</anchorfile>
      <anchor>aaeac5fb312e86eb802193a673e375680</anchor>
      <arglist>(const Glib::RefPtr&lt; Alpha &gt; &amp;alpha, const Glib::RefPtr&lt; Path &gt; &amp;path)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>on_knot_reached</name>
      <anchorfile>classClutter_1_1BehaviourPath.html</anchorfile>
      <anchor>a1b630ce4f19d8b17ec7eddfcb287373d</anchor>
      <arglist>(guint knot_num)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Clutter::BehaviourPath &gt;</type>
      <name>wrap</name>
      <anchorfile>classClutter_1_1BehaviourPath.html</anchorfile>
      <anchor>a976b2b9273143ac80e4d8e62bc521887</anchor>
      <arglist>(ClutterBehaviourPath *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Clutter::BehaviourRotate</name>
    <filename>classClutter_1_1BehaviourRotate.html</filename>
    <base>Clutter::Behaviour</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~BehaviourRotate</name>
      <anchorfile>classClutter_1_1BehaviourRotate.html</anchorfile>
      <anchor>a100d1aff2ac77e2bdc12ca7bc4054d98</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>ClutterBehaviourRotate *</type>
      <name>gobj</name>
      <anchorfile>classClutter_1_1BehaviourRotate.html</anchorfile>
      <anchor>a88ab16d08a3e90e8b5b18844bfbdeb63</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const ClutterBehaviourRotate *</type>
      <name>gobj</name>
      <anchorfile>classClutter_1_1BehaviourRotate.html</anchorfile>
      <anchor>a9d9d5807b26b7f9807b77e440d2340db</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>ClutterBehaviourRotate *</type>
      <name>gobj_copy</name>
      <anchorfile>classClutter_1_1BehaviourRotate.html</anchorfile>
      <anchor>a186083e2c25f38cc05652d613b611d2c</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_axis</name>
      <anchorfile>classClutter_1_1BehaviourRotate.html</anchorfile>
      <anchor>a2b5219eaa7014169e9d3c88d99fc461c</anchor>
      <arglist>(RotateAxis axis)</arglist>
    </member>
    <member kind="function">
      <type>RotateAxis</type>
      <name>get_axis</name>
      <anchorfile>classClutter_1_1BehaviourRotate.html</anchorfile>
      <anchor>ae2e9a8a5d04850526b3fc839fd147cfd</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_direction</name>
      <anchorfile>classClutter_1_1BehaviourRotate.html</anchorfile>
      <anchor>afc9706391a3acdb65979b2be02fc5373</anchor>
      <arglist>(RotateDirection direction)</arglist>
    </member>
    <member kind="function">
      <type>RotateDirection</type>
      <name>get_direction</name>
      <anchorfile>classClutter_1_1BehaviourRotate.html</anchorfile>
      <anchor>a3402b9187aad6e063eafff03d37c51b0</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_center</name>
      <anchorfile>classClutter_1_1BehaviourRotate.html</anchorfile>
      <anchor>a9618f08ec7f367db386d36d5c3bd2701</anchor>
      <arglist>(int x, int y, int z)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>get_center</name>
      <anchorfile>classClutter_1_1BehaviourRotate.html</anchorfile>
      <anchor>a0abda598db4c506f08202e263d334698</anchor>
      <arglist>(int &amp;x, int &amp;y, int &amp;z) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_bounds</name>
      <anchorfile>classClutter_1_1BehaviourRotate.html</anchorfile>
      <anchor>a112b94ea234d884e1395b08b5d401a32</anchor>
      <arglist>(double angle_begin, double angle_end)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>get_bounds</name>
      <anchorfile>classClutter_1_1BehaviourRotate.html</anchorfile>
      <anchor>a3950c3522fa401d04a2fea27decaa61c</anchor>
      <arglist>(double &amp;angle_begin, double &amp;angle_end) const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; double &gt;</type>
      <name>property_angle_end</name>
      <anchorfile>classClutter_1_1BehaviourRotate.html</anchorfile>
      <anchor>a43afa0820c2f80a06efbb5f431fad453</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; double &gt;</type>
      <name>property_angle_end</name>
      <anchorfile>classClutter_1_1BehaviourRotate.html</anchorfile>
      <anchor>afdec6555a0164217417d2549a46b15e0</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; double &gt;</type>
      <name>property_angle_start</name>
      <anchorfile>classClutter_1_1BehaviourRotate.html</anchorfile>
      <anchor>a0698824b52ddf5aae62491e7c3c1694e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; double &gt;</type>
      <name>property_angle_start</name>
      <anchorfile>classClutter_1_1BehaviourRotate.html</anchorfile>
      <anchor>ab3ae6b4f7b71c8c5e9141a295800fd95</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; RotateAxis &gt;</type>
      <name>property_axis</name>
      <anchorfile>classClutter_1_1BehaviourRotate.html</anchorfile>
      <anchor>a19f83ef26edd07b465db328a9665e786</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; RotateAxis &gt;</type>
      <name>property_axis</name>
      <anchorfile>classClutter_1_1BehaviourRotate.html</anchorfile>
      <anchor>a75e17b93410129af1d6e40acd2b09c48</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; int &gt;</type>
      <name>property_center_x</name>
      <anchorfile>classClutter_1_1BehaviourRotate.html</anchorfile>
      <anchor>a56d45f3e2d9646ceff42eefe0760ecf9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; int &gt;</type>
      <name>property_center_x</name>
      <anchorfile>classClutter_1_1BehaviourRotate.html</anchorfile>
      <anchor>a2b64b2ac569b784ca885aa40e2a1be0a</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; int &gt;</type>
      <name>property_center_y</name>
      <anchorfile>classClutter_1_1BehaviourRotate.html</anchorfile>
      <anchor>a5ed7c631ad82607f9021e24f35ee3410</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; int &gt;</type>
      <name>property_center_y</name>
      <anchorfile>classClutter_1_1BehaviourRotate.html</anchorfile>
      <anchor>ae1cd3042ae7eca6830fd4411aa727f78</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; int &gt;</type>
      <name>property_center_z</name>
      <anchorfile>classClutter_1_1BehaviourRotate.html</anchorfile>
      <anchor>a092f7527d3c3e1c901bca19ec4f4563f</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; int &gt;</type>
      <name>property_center_z</name>
      <anchorfile>classClutter_1_1BehaviourRotate.html</anchorfile>
      <anchor>af5e2576f5f70f8325dc754723ca44c71</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; RotateDirection &gt;</type>
      <name>property_direction</name>
      <anchorfile>classClutter_1_1BehaviourRotate.html</anchorfile>
      <anchor>a91d157fc6b61a40af198a2e585048e51</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; RotateDirection &gt;</type>
      <name>property_direction</name>
      <anchorfile>classClutter_1_1BehaviourRotate.html</anchorfile>
      <anchor>a808554981f2c1f461fd460e38e90966d</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; BehaviourRotate &gt;</type>
      <name>create</name>
      <anchorfile>classClutter_1_1BehaviourRotate.html</anchorfile>
      <anchor>ae9450d9464e52bb5266b837b32a4337f</anchor>
      <arglist>(const Glib::RefPtr&lt; Alpha &gt; &amp;alpha, RotateAxis axis, RotateDirection direction, double angle_begin, double angle_end)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>BehaviourRotate</name>
      <anchorfile>classClutter_1_1BehaviourRotate.html</anchorfile>
      <anchor>ab4979992b913bfff6e211e14f839f217</anchor>
      <arglist>(const Glib::RefPtr&lt; Alpha &gt; &amp;alpha, RotateAxis axis, RotateDirection direction, double angle_begin, double angle_end)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Clutter::BehaviourRotate &gt;</type>
      <name>wrap</name>
      <anchorfile>classClutter_1_1BehaviourRotate.html</anchorfile>
      <anchor>a096c5d93d5fe084ad6044f091178411b</anchor>
      <arglist>(ClutterBehaviourRotate *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Clutter::BehaviourScale</name>
    <filename>classClutter_1_1BehaviourScale.html</filename>
    <base>Clutter::Behaviour</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~BehaviourScale</name>
      <anchorfile>classClutter_1_1BehaviourScale.html</anchorfile>
      <anchor>a8857a661214b16d4f00bf39b30e7409b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>ClutterBehaviourScale *</type>
      <name>gobj</name>
      <anchorfile>classClutter_1_1BehaviourScale.html</anchorfile>
      <anchor>aac2e8493c0b4d12476cda8729931eede</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const ClutterBehaviourScale *</type>
      <name>gobj</name>
      <anchorfile>classClutter_1_1BehaviourScale.html</anchorfile>
      <anchor>a930a5638cee95db55a42069161a34f28</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>ClutterBehaviourScale *</type>
      <name>gobj_copy</name>
      <anchorfile>classClutter_1_1BehaviourScale.html</anchorfile>
      <anchor>a63bfcbb283ec9e353f2aaf26eb9d5c1b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_bounds</name>
      <anchorfile>classClutter_1_1BehaviourScale.html</anchorfile>
      <anchor>a2f34dadf3d291430cc79ceca7b951f55</anchor>
      <arglist>(double x_scale_start, double y_scale_start, double x_scale_end, double y_scale_end)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>get_bounds</name>
      <anchorfile>classClutter_1_1BehaviourScale.html</anchorfile>
      <anchor>a46e18ef843295b150f4b7dd4423fa613</anchor>
      <arglist>(double &amp;x_scale_start, double &amp;y_scale_start, double &amp;x_scale_end, double &amp;y_scale_end) const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; double &gt;</type>
      <name>property_x_scale_start</name>
      <anchorfile>classClutter_1_1BehaviourScale.html</anchorfile>
      <anchor>af22dd07ed212b497702c60726a01e57f</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; double &gt;</type>
      <name>property_x_scale_start</name>
      <anchorfile>classClutter_1_1BehaviourScale.html</anchorfile>
      <anchor>a3a7970928b146118f30e5b4c35077bd3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; double &gt;</type>
      <name>property_x_scale_end</name>
      <anchorfile>classClutter_1_1BehaviourScale.html</anchorfile>
      <anchor>a8493d7e67bea2845308f02fc69a44145</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; double &gt;</type>
      <name>property_x_scale_end</name>
      <anchorfile>classClutter_1_1BehaviourScale.html</anchorfile>
      <anchor>a12acfde60cdd9a039d13bc8a412fc02e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; double &gt;</type>
      <name>property_y_scale_start</name>
      <anchorfile>classClutter_1_1BehaviourScale.html</anchorfile>
      <anchor>a7cc7070325ec9b5dae2be5a0f9be9835</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; double &gt;</type>
      <name>property_y_scale_start</name>
      <anchorfile>classClutter_1_1BehaviourScale.html</anchorfile>
      <anchor>a4562755ac8e87f59a9b24f38d62c4cbe</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; double &gt;</type>
      <name>property_y_scale_end</name>
      <anchorfile>classClutter_1_1BehaviourScale.html</anchorfile>
      <anchor>a4407a983f5bc695be5cbead59068e44b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; double &gt;</type>
      <name>property_y_scale_end</name>
      <anchorfile>classClutter_1_1BehaviourScale.html</anchorfile>
      <anchor>a4a7ecf23c86256a76785a9513ce59d08</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; BehaviourScale &gt;</type>
      <name>create</name>
      <anchorfile>classClutter_1_1BehaviourScale.html</anchorfile>
      <anchor>a02eebc59b60407e32c9104dca0a2baf3</anchor>
      <arglist>(const Glib::RefPtr&lt; Alpha &gt; &amp;alpha, double x_scale_start, double y_scale_start, double x_scale_end, double y_scale_end)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>BehaviourScale</name>
      <anchorfile>classClutter_1_1BehaviourScale.html</anchorfile>
      <anchor>a9d3f65e3e85292bc053684e7b862eb00</anchor>
      <arglist>(const Glib::RefPtr&lt; Alpha &gt; &amp;alpha, double x_scale_start, double y_scale_start, double x_scale_end, double y_scale_end)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Clutter::BehaviourScale &gt;</type>
      <name>wrap</name>
      <anchorfile>classClutter_1_1BehaviourScale.html</anchorfile>
      <anchor>a61771bacb32c6d24fce6d35148f76925</anchor>
      <arglist>(ClutterBehaviourScale *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Clutter::BinLayout</name>
    <filename>classClutter_1_1BinLayout.html</filename>
    <base>Clutter::LayoutManager</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~BinLayout</name>
      <anchorfile>classClutter_1_1BinLayout.html</anchorfile>
      <anchor>a5aa1bc45f98989339cf71a18234629ec</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>ClutterBinLayout *</type>
      <name>gobj</name>
      <anchorfile>classClutter_1_1BinLayout.html</anchorfile>
      <anchor>a8eae0d2b30b52b400c8f21860f00e1eb</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const ClutterBinLayout *</type>
      <name>gobj</name>
      <anchorfile>classClutter_1_1BinLayout.html</anchorfile>
      <anchor>ae016ae700c05c81411c8822a1cd52f6e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>ClutterBinLayout *</type>
      <name>gobj_copy</name>
      <anchorfile>classClutter_1_1BinLayout.html</anchorfile>
      <anchor>aab70e66349179b01d8dc0e999784b462</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_alignment</name>
      <anchorfile>classClutter_1_1BinLayout.html</anchorfile>
      <anchor>a400b669f8a516e4bf48097175553cebf</anchor>
      <arglist>(const Glib::RefPtr&lt; Actor &gt; &amp;child, BinAlignment x_align, BinAlignment y_align)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>get_alignment</name>
      <anchorfile>classClutter_1_1BinLayout.html</anchorfile>
      <anchor>a199410697999415db7abb730af1bbcfd</anchor>
      <arglist>(const Glib::RefPtr&lt; Actor &gt; &amp;child, BinAlignment &amp;x_align, BinAlignment &amp;y_align) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>add</name>
      <anchorfile>classClutter_1_1BinLayout.html</anchorfile>
      <anchor>aa4d794d4e75d813029bf0dadec1f6e47</anchor>
      <arglist>(const Glib::RefPtr&lt; Actor &gt; &amp;child, BinAlignment x_align, BinAlignment y_align)</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; BinAlignment &gt;</type>
      <name>property_x_align</name>
      <anchorfile>classClutter_1_1BinLayout.html</anchorfile>
      <anchor>ac51b2f96ecad2541da83401e5632d23a</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; BinAlignment &gt;</type>
      <name>property_x_align</name>
      <anchorfile>classClutter_1_1BinLayout.html</anchorfile>
      <anchor>ad1ef17ef7b9bf75cb5501968a13cb5c4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; BinAlignment &gt;</type>
      <name>property_y_align</name>
      <anchorfile>classClutter_1_1BinLayout.html</anchorfile>
      <anchor>a337842d0613ba4a4d133ba656c764b5e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; BinAlignment &gt;</type>
      <name>property_y_align</name>
      <anchorfile>classClutter_1_1BinLayout.html</anchorfile>
      <anchor>acb84bff9dbbd79c2742acd2d279cca3a</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; BinLayout &gt;</type>
      <name>create</name>
      <anchorfile>classClutter_1_1BinLayout.html</anchorfile>
      <anchor>a4d394589a599478d83865d063e3a0f69</anchor>
      <arglist>(BinAlignment x_align, BinAlignment y_align)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>BinLayout</name>
      <anchorfile>classClutter_1_1BinLayout.html</anchorfile>
      <anchor>af48bc9e6abd4adfcbe5e6bf357842b64</anchor>
      <arglist>(BinAlignment x_align, BinAlignment y_align)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Clutter::BinLayout &gt;</type>
      <name>wrap</name>
      <anchorfile>classClutter_1_1BinLayout.html</anchorfile>
      <anchor>a789c40644936050d066e52f8e0cccaaa</anchor>
      <arglist>(ClutterBinLayout *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Clutter::Box</name>
    <filename>classClutter_1_1Box.html</filename>
    <base>Clutter::LayoutManager</base>
    <base>Clutter::Container</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~Box</name>
      <anchorfile>classClutter_1_1Box.html</anchorfile>
      <anchor>ac71097c52770e8f23c6c02560998bada</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>ClutterBox *</type>
      <name>gobj</name>
      <anchorfile>classClutter_1_1Box.html</anchorfile>
      <anchor>af18f3ac163bcbd2a1e60449100b0fdf1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const ClutterBox *</type>
      <name>gobj</name>
      <anchorfile>classClutter_1_1Box.html</anchorfile>
      <anchor>a6147d4cf4c59c044dc8d558a3f25a3ae</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>ClutterBox *</type>
      <name>gobj_copy</name>
      <anchorfile>classClutter_1_1Box.html</anchorfile>
      <anchor>a0a1e04c902765599f2005ee6e2d59509</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_color</name>
      <anchorfile>classClutter_1_1Box.html</anchorfile>
      <anchor>a63764bcfbdd63b83a4970381106df546</anchor>
      <arglist>(const Color &amp;color)</arglist>
    </member>
    <member kind="function">
      <type>Color</type>
      <name>get_color</name>
      <anchorfile>classClutter_1_1Box.html</anchorfile>
      <anchor>a1cccdf8e60b60774c5fe6e16a77e3290</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>pack</name>
      <anchorfile>classClutter_1_1Box.html</anchorfile>
      <anchor>a19c50d113d1f7b1d1708b89e08004b69</anchor>
      <arglist>(const Glib::RefPtr&lt; Actor &gt; &amp;actor, const std::map&lt; std::string, Glib::ValueBase &gt; &amp;properties)</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; Color &gt;</type>
      <name>property_color</name>
      <anchorfile>classClutter_1_1Box.html</anchorfile>
      <anchor>a02d56e7c434f635afdad0008405fb56a</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; Color &gt;</type>
      <name>property_color</name>
      <anchorfile>classClutter_1_1Box.html</anchorfile>
      <anchor>ad9e560979a5f83fdf8751f6831312d7e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; bool &gt;</type>
      <name>property_color_set</name>
      <anchorfile>classClutter_1_1Box.html</anchorfile>
      <anchor>a9ea153b33aeb3b302d9e42eed17d64a7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; bool &gt;</type>
      <name>property_color_set</name>
      <anchorfile>classClutter_1_1Box.html</anchorfile>
      <anchor>a5e81ee7d14a01f3828147f5c74a304e3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; Glib::RefPtr&lt; LayoutManager &gt; &gt;</type>
      <name>property_manager</name>
      <anchorfile>classClutter_1_1Box.html</anchorfile>
      <anchor>abfd6e1e869eec1482c51e834b2716dc6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; Box &gt;</type>
      <name>create</name>
      <anchorfile>classClutter_1_1Box.html</anchorfile>
      <anchor>aff869fb6692d25fb2c28cda64c03222f</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>Box</name>
      <anchorfile>classClutter_1_1Box.html</anchorfile>
      <anchor>a397afad8efd269de48ba32a468e65e43</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>Box</name>
      <anchorfile>classClutter_1_1Box.html</anchorfile>
      <anchor>aa04cc48b09ce3b7deae7030b985613df</anchor>
      <arglist>(const Glib::RefPtr&lt; LayoutManager &gt; &amp;layoutManager)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Clutter::Box &gt;</type>
      <name>wrap</name>
      <anchorfile>classClutter_1_1Box.html</anchorfile>
      <anchor>ad5b7a418fadd2e0c98e26e10a44c6340</anchor>
      <arglist>(ClutterBox *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Clutter::BoxLayout</name>
    <filename>classClutter_1_1BoxLayout.html</filename>
    <base>Clutter::LayoutManager</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~BoxLayout</name>
      <anchorfile>classClutter_1_1BoxLayout.html</anchorfile>
      <anchor>a5e0f9c910c0cec131524fb7affb205c5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>ClutterBoxLayout *</type>
      <name>gobj</name>
      <anchorfile>classClutter_1_1BoxLayout.html</anchorfile>
      <anchor>ad6480632765d467fd180cffb1cef7753</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const ClutterBoxLayout *</type>
      <name>gobj</name>
      <anchorfile>classClutter_1_1BoxLayout.html</anchorfile>
      <anchor>afe67195ccb6ec1b62b2c857794e7794c</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>ClutterBoxLayout *</type>
      <name>gobj_copy</name>
      <anchorfile>classClutter_1_1BoxLayout.html</anchorfile>
      <anchor>ab3b9be7c64498c43fb59fc2e1b4ce3ab</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_pack_start</name>
      <anchorfile>classClutter_1_1BoxLayout.html</anchorfile>
      <anchor>a1cb677e59588bc8d5454d8724b280ec7</anchor>
      <arglist>(bool pack_start)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_pack_start</name>
      <anchorfile>classClutter_1_1BoxLayout.html</anchorfile>
      <anchor>a4f1506859754046bf57352867c75295f</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_spacing</name>
      <anchorfile>classClutter_1_1BoxLayout.html</anchorfile>
      <anchor>ac3336f3959fa27ceff8bf1c212148f20</anchor>
      <arglist>(guint spacing)</arglist>
    </member>
    <member kind="function">
      <type>guint</type>
      <name>get_spacing</name>
      <anchorfile>classClutter_1_1BoxLayout.html</anchorfile>
      <anchor>a53f60111c7facf94b19457b78182d2c4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_vertical</name>
      <anchorfile>classClutter_1_1BoxLayout.html</anchorfile>
      <anchor>a766f3254f955ce8741bbc0697261257b</anchor>
      <arglist>(bool vertical)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_vertical</name>
      <anchorfile>classClutter_1_1BoxLayout.html</anchorfile>
      <anchor>ab72362c6592654314aeb3e10c755aff4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>pack</name>
      <anchorfile>classClutter_1_1BoxLayout.html</anchorfile>
      <anchor>ae91a0a1a0aa44cca24fb2218b5aeaec4</anchor>
      <arglist>(const Glib::RefPtr&lt; Actor &gt; &amp;, bool expand, bool x_fill, bool y_fill, BoxAlignment x_align, BoxAlignment y_align)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_alignment</name>
      <anchorfile>classClutter_1_1BoxLayout.html</anchorfile>
      <anchor>a1249fdee5c1dc1dde1215372f32a4b6e</anchor>
      <arglist>(const Glib::RefPtr&lt; Actor &gt; &amp;child, BoxAlignment x_align, BoxAlignment y_align)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>get_alignment</name>
      <anchorfile>classClutter_1_1BoxLayout.html</anchorfile>
      <anchor>ad7b3cde729a85d98356b53a882599479</anchor>
      <arglist>(const Glib::RefPtr&lt; Actor &gt; &amp;child, BoxAlignment &amp;x_align, BoxAlignment &amp;y_align) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_expand</name>
      <anchorfile>classClutter_1_1BoxLayout.html</anchorfile>
      <anchor>a333a3811c91e516fddf5914db4c4b872</anchor>
      <arglist>(const Glib::RefPtr&lt; Actor &gt; &amp;child, bool expand)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_expand</name>
      <anchorfile>classClutter_1_1BoxLayout.html</anchorfile>
      <anchor>a3df4e87e30bf3260cfc1d6ca0d4b3638</anchor>
      <arglist>(const Glib::RefPtr&lt; Actor &gt; &amp;child) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_fill</name>
      <anchorfile>classClutter_1_1BoxLayout.html</anchorfile>
      <anchor>aa9ec9963d741781f492cbdf7ea439898</anchor>
      <arglist>(const Glib::RefPtr&lt; Actor &gt; &amp;child, bool x_fill, bool y_fill)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>get_fill</name>
      <anchorfile>classClutter_1_1BoxLayout.html</anchorfile>
      <anchor>a124293668524bf5d6647eea7d7546804</anchor>
      <arglist>(const Glib::RefPtr&lt; Actor &gt; &amp;child, bool &amp;x_fill, bool &amp;y_fill) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_use_animations</name>
      <anchorfile>classClutter_1_1BoxLayout.html</anchorfile>
      <anchor>a636f14f3f0e37f9611d9e9ba1696a427</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_easing_duration</name>
      <anchorfile>classClutter_1_1BoxLayout.html</anchorfile>
      <anchor>a3975b79ef5e57d3ab6ccef0a18680446</anchor>
      <arglist>(guint msecs)</arglist>
    </member>
    <member kind="function">
      <type>guint</type>
      <name>get_easing_duration</name>
      <anchorfile>classClutter_1_1BoxLayout.html</anchorfile>
      <anchor>a5d1ebecec63ef61d0412ae66af7f10c6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_easing_mode</name>
      <anchorfile>classClutter_1_1BoxLayout.html</anchorfile>
      <anchor>aaac12d4f5441428ebee2f4e237aaa0de</anchor>
      <arglist>(gulong mode)</arglist>
    </member>
    <member kind="function">
      <type>gulong</type>
      <name>get_easing_mode</name>
      <anchorfile>classClutter_1_1BoxLayout.html</anchorfile>
      <anchor>a18e7a5fb1402bc184856ba9ddfaaac89</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; guint &gt;</type>
      <name>property_easing_duration</name>
      <anchorfile>classClutter_1_1BoxLayout.html</anchorfile>
      <anchor>a092b874a1f8acd2b999aca0e2e1f76e4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; guint &gt;</type>
      <name>property_easing_duration</name>
      <anchorfile>classClutter_1_1BoxLayout.html</anchorfile>
      <anchor>a1ddafb494c6d576f9d91163870f6ddca</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; unsigned long &gt;</type>
      <name>property_easing_mode</name>
      <anchorfile>classClutter_1_1BoxLayout.html</anchorfile>
      <anchor>a9e843d0d149aebd13b9b7ae297c53ee8</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; unsigned long &gt;</type>
      <name>property_easing_mode</name>
      <anchorfile>classClutter_1_1BoxLayout.html</anchorfile>
      <anchor>a1f8c1898a8e968ecdd477e0f332e9314</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; bool &gt;</type>
      <name>property_pack_start</name>
      <anchorfile>classClutter_1_1BoxLayout.html</anchorfile>
      <anchor>a41ef6008236e18776a352e5a394bf69b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; bool &gt;</type>
      <name>property_pack_start</name>
      <anchorfile>classClutter_1_1BoxLayout.html</anchorfile>
      <anchor>a3a015dfaa32695a7b5651010a6e52ad1</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; guint &gt;</type>
      <name>property_spacing</name>
      <anchorfile>classClutter_1_1BoxLayout.html</anchorfile>
      <anchor>a74d267a296d91610a4a8f9a3ef10f962</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; guint &gt;</type>
      <name>property_spacing</name>
      <anchorfile>classClutter_1_1BoxLayout.html</anchorfile>
      <anchor>ab1a6c1d1b4078a9bc423d9ce2fba5da7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; bool &gt;</type>
      <name>property_use_animations</name>
      <anchorfile>classClutter_1_1BoxLayout.html</anchorfile>
      <anchor>ace3172707a6b998727acd2b53bfc14fe</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; bool &gt;</type>
      <name>property_use_animations</name>
      <anchorfile>classClutter_1_1BoxLayout.html</anchorfile>
      <anchor>a8efb0b890047a7a69aab97234fe021ad</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; bool &gt;</type>
      <name>property_vertical</name>
      <anchorfile>classClutter_1_1BoxLayout.html</anchorfile>
      <anchor>a2d6d3dd01e74532bac55c3c7e75d8320</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; bool &gt;</type>
      <name>property_vertical</name>
      <anchorfile>classClutter_1_1BoxLayout.html</anchorfile>
      <anchor>acc4b1186e4046300c0307cc1c34db14a</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; BoxLayout &gt;</type>
      <name>create</name>
      <anchorfile>classClutter_1_1BoxLayout.html</anchorfile>
      <anchor>a233754d75ccc8f037e2ef915ca5669be</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>BoxLayout</name>
      <anchorfile>classClutter_1_1BoxLayout.html</anchorfile>
      <anchor>ae7ed4c31f0971d13696251828fde763c</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Clutter::BoxLayout &gt;</type>
      <name>wrap</name>
      <anchorfile>classClutter_1_1BoxLayout.html</anchorfile>
      <anchor>a01da13021ac6d21202c651b883a39556</anchor>
      <arglist>(ClutterBoxLayout *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Clutter::ChildMeta</name>
    <filename>classClutter_1_1ChildMeta.html</filename>
    <base>Glib::Object</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~ChildMeta</name>
      <anchorfile>classClutter_1_1ChildMeta.html</anchorfile>
      <anchor>a34de57585c426a73aad2e7688cef279e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>ClutterChildMeta *</type>
      <name>gobj</name>
      <anchorfile>classClutter_1_1ChildMeta.html</anchorfile>
      <anchor>a2821cd781966ca84a1aadfb823c6238b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const ClutterChildMeta *</type>
      <name>gobj</name>
      <anchorfile>classClutter_1_1ChildMeta.html</anchorfile>
      <anchor>aaca1a218540021b74ebec040429ce15c</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>ClutterChildMeta *</type>
      <name>gobj_copy</name>
      <anchorfile>classClutter_1_1ChildMeta.html</anchorfile>
      <anchor>a6c25ffb097c149b3e030eb38564ef524</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Container &gt;</type>
      <name>get_container</name>
      <anchorfile>classClutter_1_1ChildMeta.html</anchorfile>
      <anchor>affcd3e40481bf4d236d4a4bc1a6ad612</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const Container &gt;</type>
      <name>get_container</name>
      <anchorfile>classClutter_1_1ChildMeta.html</anchorfile>
      <anchor>a00bbeb857c69dccb8527e2f362d69d65</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Actor &gt;</type>
      <name>get_actor</name>
      <anchorfile>classClutter_1_1ChildMeta.html</anchorfile>
      <anchor>a0eef205582e368162903d3fe28f641ee</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const Actor &gt;</type>
      <name>get_actor</name>
      <anchorfile>classClutter_1_1ChildMeta.html</anchorfile>
      <anchor>a079433ff73bf29e7d4d103adc0fa1a92</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; Glib::RefPtr&lt; Container &gt; &gt;</type>
      <name>property_container</name>
      <anchorfile>classClutter_1_1ChildMeta.html</anchorfile>
      <anchor>a545cd2b37622dfb7e0c0442c8b84c971</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; Glib::RefPtr&lt; Actor &gt; &gt;</type>
      <name>property_actor</name>
      <anchorfile>classClutter_1_1ChildMeta.html</anchorfile>
      <anchor>a0ff2c59ed2222b36e04b3468d3413b21</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>ChildMeta</name>
      <anchorfile>classClutter_1_1ChildMeta.html</anchorfile>
      <anchor>a1fbefce3c09358bec7170ce2919efa43</anchor>
      <arglist>(const Glib::RefPtr&lt; Container &gt; &amp;container, const Glib::RefPtr&lt; Actor &gt; &amp;actor)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Clutter::ChildMeta &gt;</type>
      <name>wrap</name>
      <anchorfile>classClutter_1_1ChildMeta.html</anchorfile>
      <anchor>a22368183ecd640ec52a8a717f69db413</anchor>
      <arglist>(ClutterChildMeta *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Clutter::Clone</name>
    <filename>classClutter_1_1Clone.html</filename>
    <base>Clutter::Actor</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~Clone</name>
      <anchorfile>classClutter_1_1Clone.html</anchorfile>
      <anchor>ac115333af2c94079ff5b82dea73285a2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>ClutterClone *</type>
      <name>gobj</name>
      <anchorfile>classClutter_1_1Clone.html</anchorfile>
      <anchor>ad7d67548e22d3437f9ae2a5b60e50f06</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const ClutterClone *</type>
      <name>gobj</name>
      <anchorfile>classClutter_1_1Clone.html</anchorfile>
      <anchor>a6dafd1673997669eb97f73e3411421eb</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>ClutterClone *</type>
      <name>gobj_copy</name>
      <anchorfile>classClutter_1_1Clone.html</anchorfile>
      <anchor>ae7f73fc45442c2b0619cf5d0f586556c</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Actor &gt;</type>
      <name>get_source</name>
      <anchorfile>classClutter_1_1Clone.html</anchorfile>
      <anchor>ac6f0a10bfdf81bf46e10d689a3756008</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const Actor &gt;</type>
      <name>get_source</name>
      <anchorfile>classClutter_1_1Clone.html</anchorfile>
      <anchor>af7a39afd9b7bd33e17421fb9a58a7601</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>get_source</name>
      <anchorfile>classClutter_1_1Clone.html</anchorfile>
      <anchor>a5a2e7c14943de0c51c11a65d25ffdd3a</anchor>
      <arglist>(const Glib::RefPtr&lt; Actor &gt; &amp;source)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; Clone &gt;</type>
      <name>create</name>
      <anchorfile>classClutter_1_1Clone.html</anchorfile>
      <anchor>aecdb151afc438d921b0ddfd709b71a05</anchor>
      <arglist>(const Glib::RefPtr&lt; Actor &gt; &amp;source)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>Clone</name>
      <anchorfile>classClutter_1_1Clone.html</anchorfile>
      <anchor>ab3c42e5a9480222875df93bd646a28d0</anchor>
      <arglist>(const Glib::RefPtr&lt; Actor &gt; &amp;source)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Clutter::Clone &gt;</type>
      <name>wrap</name>
      <anchorfile>classClutter_1_1Clone.html</anchorfile>
      <anchor>a51068c42178325dc1166e511e2c78597</anchor>
      <arglist>(ClutterClone *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Clutter::Color</name>
    <filename>classClutter_1_1Color.html</filename>
    <member kind="function">
      <type></type>
      <name>Color</name>
      <anchorfile>classClutter_1_1Color.html</anchorfile>
      <anchor>adc613274363f722f410798a0fefdf88b</anchor>
      <arglist>(ClutterColor *gobject, bool make_a_copy=true)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Color</name>
      <anchorfile>classClutter_1_1Color.html</anchorfile>
      <anchor>a333195c322ddcc49d886005bdf090a6b</anchor>
      <arglist>(const Color &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>Color &amp;</type>
      <name>operator=</name>
      <anchorfile>classClutter_1_1Color.html</anchorfile>
      <anchor>a2be4e4873a20e1f5890f4148928b6125</anchor>
      <arglist>(const Color &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~Color</name>
      <anchorfile>classClutter_1_1Color.html</anchorfile>
      <anchor>aef34c97365faed1f4927e253194c1ed0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>swap</name>
      <anchorfile>classClutter_1_1Color.html</anchorfile>
      <anchor>a54c293faca658e4634bee5672a30babf</anchor>
      <arglist>(Color &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>ClutterColor *</type>
      <name>gobj</name>
      <anchorfile>classClutter_1_1Color.html</anchorfile>
      <anchor>a9249cdf3bbcd07d092ee12b200a23a33</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const ClutterColor *</type>
      <name>gobj</name>
      <anchorfile>classClutter_1_1Color.html</anchorfile>
      <anchor>a5cd9091259f5a5a85a84d47db04b6255</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>ClutterColor *</type>
      <name>gobj_copy</name>
      <anchorfile>classClutter_1_1Color.html</anchorfile>
      <anchor>ae25a4e605674b8914584326df7a4c3fa</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Color</name>
      <anchorfile>classClutter_1_1Color.html</anchorfile>
      <anchor>a4aa67211965c8ed942303a18e878ab6c</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Color</name>
      <anchorfile>classClutter_1_1Color.html</anchorfile>
      <anchor>a0e42c0f352ea91fa774b98226b10e8b3</anchor>
      <arglist>(guint8 red, guint8 green, guint8 blue, guint8 alpha=255)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Color</name>
      <anchorfile>classClutter_1_1Color.html</anchorfile>
      <anchor>af2443ec76d07f129df8cfcc0cbb0c08e</anchor>
      <arglist>(guint32 pixel)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Color</name>
      <anchorfile>classClutter_1_1Color.html</anchorfile>
      <anchor>a35e8748e59b7c061bf7fdabdda7c5fbf</anchor>
      <arglist>(const Glib::ustring &amp;color)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_from_rgb</name>
      <anchorfile>classClutter_1_1Color.html</anchorfile>
      <anchor>af97b482644bf75d8508755479dd19341</anchor>
      <arglist>(guint8 red, guint8 blue, guint8 green)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_from_string</name>
      <anchorfile>classClutter_1_1Color.html</anchorfile>
      <anchor>a75e0d5b1d356a3a323a6099406e94cb9</anchor>
      <arglist>(const Glib::ustring &amp;color)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>to_string</name>
      <anchorfile>classClutter_1_1Color.html</anchorfile>
      <anchor>ab9cd47f02cebe64de9f4e2a56affbccc</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_from_hls</name>
      <anchorfile>classClutter_1_1Color.html</anchorfile>
      <anchor>a527d30ab99513a231aadc638da4e30bf</anchor>
      <arglist>(float hue, float luminance, float saturation)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>to_hls</name>
      <anchorfile>classClutter_1_1Color.html</anchorfile>
      <anchor>a75ee8aae89a581e1785bd81db768f490</anchor>
      <arglist>(float &amp;hue, float &amp;luminance, float &amp;saturation) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_from_pixel</name>
      <anchorfile>classClutter_1_1Color.html</anchorfile>
      <anchor>a5a9becc5aa0aa46bc718b08d44611956</anchor>
      <arglist>(guint32 pixel)</arglist>
    </member>
    <member kind="function">
      <type>guint32</type>
      <name>to_pixel</name>
      <anchorfile>classClutter_1_1Color.html</anchorfile>
      <anchor>a41b037d159d3745abd5506f9970bce90</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Color</type>
      <name>add</name>
      <anchorfile>classClutter_1_1Color.html</anchorfile>
      <anchor>aa27bcd9b449a3df139b5a81962f86117</anchor>
      <arglist>(const Color &amp;color) const </arglist>
    </member>
    <member kind="function">
      <type>Color</type>
      <name>subtract</name>
      <anchorfile>classClutter_1_1Color.html</anchorfile>
      <anchor>a0aabd1a3eff79ac3dbd5cd7607c900bb</anchor>
      <arglist>(const Color &amp;color) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>darken</name>
      <anchorfile>classClutter_1_1Color.html</anchorfile>
      <anchor>ada6d580020a2ef7e78acb01e091aadfa</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>lighten</name>
      <anchorfile>classClutter_1_1Color.html</anchorfile>
      <anchor>a4c9380e94c033c26615df3778fd4230f</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>shade</name>
      <anchorfile>classClutter_1_1Color.html</anchorfile>
      <anchor>afb7f893652c6854bebbde1b389dc1ac9</anchor>
      <arglist>(double shade)</arglist>
    </member>
    <member kind="function">
      <type>guint8</type>
      <name>get_red</name>
      <anchorfile>classClutter_1_1Color.html</anchorfile>
      <anchor>a64712c5d8acc8773b5bb428281c33f94</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_red</name>
      <anchorfile>classClutter_1_1Color.html</anchorfile>
      <anchor>a76c50f4b09d9be6a4901ed8f155b158f</anchor>
      <arglist>(const guint8 &amp;value)</arglist>
    </member>
    <member kind="function">
      <type>guint8</type>
      <name>get_green</name>
      <anchorfile>classClutter_1_1Color.html</anchorfile>
      <anchor>a1f5879a239308b46ca761b4371455c0c</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_green</name>
      <anchorfile>classClutter_1_1Color.html</anchorfile>
      <anchor>abe98d7f843252cd10a1b4f3721e01a32</anchor>
      <arglist>(const guint8 &amp;value)</arglist>
    </member>
    <member kind="function">
      <type>guint8</type>
      <name>get_blue</name>
      <anchorfile>classClutter_1_1Color.html</anchorfile>
      <anchor>a47a20a315bbbc9801e1cd10be8e8a669</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_blue</name>
      <anchorfile>classClutter_1_1Color.html</anchorfile>
      <anchor>a0525c49197b908e1ae9bb1b900434ee2</anchor>
      <arglist>(const guint8 &amp;value)</arglist>
    </member>
    <member kind="function">
      <type>guint8</type>
      <name>get_alpha</name>
      <anchorfile>classClutter_1_1Color.html</anchorfile>
      <anchor>af06b5b0c0990b1270464e243955c8b12</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_alpha</name>
      <anchorfile>classClutter_1_1Color.html</anchorfile>
      <anchor>a8aca48c3994ee360b81894dcce1a4261</anchor>
      <arglist>(const guint8 &amp;value)</arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>ClutterColor *</type>
      <name>gobject_</name>
      <anchorfile>classClutter_1_1Color.html</anchorfile>
      <anchor>a4aba011ac276ab871bfbadd689a63ec6</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>Color</type>
      <name>operator+</name>
      <anchorfile>classClutter_1_1Color.html</anchorfile>
      <anchor>a109b6c8e058d6b043af9fd2f4910c62f</anchor>
      <arglist>(const Color &amp;color1, const Color &amp;color2)</arglist>
    </member>
    <member kind="function">
      <type>Color</type>
      <name>operator-</name>
      <anchorfile>classClutter_1_1Color.html</anchorfile>
      <anchor>a573ff27f2697f5c2fc15a71534529c6f</anchor>
      <arglist>(const Color &amp;color1, const Color &amp;color2)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchorfile>classClutter_1_1Color.html</anchorfile>
      <anchor>a8cbf40ce97eb2127b5bcd681c6fcdc4d</anchor>
      <arglist>(const Color &amp;lhs, const Color &amp;rhs)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator!=</name>
      <anchorfile>classClutter_1_1Color.html</anchorfile>
      <anchor>a42634d2d9874c6d75cb9340d801862a2</anchor>
      <arglist>(const Color &amp;lhs, const Color &amp;rhs)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>swap</name>
      <anchorfile>classClutter_1_1Color.html</anchorfile>
      <anchor>adcb79fe3b49c02ea51fd0eea73b8b460</anchor>
      <arglist>(Color &amp;lhs, Color &amp;rhs)</arglist>
    </member>
    <member kind="function">
      <type>Clutter::Color</type>
      <name>wrap</name>
      <anchorfile>classClutter_1_1Color.html</anchorfile>
      <anchor>a174a8a0c688b799916af31b5c67fdc5f</anchor>
      <arglist>(ClutterColor *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Clutter::Container</name>
    <filename>classClutter_1_1Container.html</filename>
    <base>Glib::Interface</base>
    <member kind="typedef">
      <type>sigc::slot&lt; void, const Glib::RefPtr&lt; Actor &gt; &amp; &gt;</type>
      <name>SlotForEach</name>
      <anchorfile>classClutter_1_1Container.html</anchorfile>
      <anchor>a588e9e0bbe7316f0085216b981f2c27f</anchor>
      <arglist></arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~Container</name>
      <anchorfile>classClutter_1_1Container.html</anchorfile>
      <anchor>a3dc6a095f1600236f83b2cb736b93d68</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>ClutterContainer *</type>
      <name>gobj</name>
      <anchorfile>classClutter_1_1Container.html</anchorfile>
      <anchor>abd8aa2215cdd75122fc72a1eb64e9f94</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const ClutterContainer *</type>
      <name>gobj</name>
      <anchorfile>classClutter_1_1Container.html</anchorfile>
      <anchor>ad027d361086a6784ff31ea3d8a7e22ad</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>add_actor</name>
      <anchorfile>classClutter_1_1Container.html</anchorfile>
      <anchor>a7cd202303495f3663ca59daa88524044</anchor>
      <arglist>(const Glib::RefPtr&lt; Actor &gt; &amp;actor)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>remove_actor</name>
      <anchorfile>classClutter_1_1Container.html</anchorfile>
      <anchor>af1acade44e392094ed897410193444aa</anchor>
      <arglist>(const Glib::RefPtr&lt; Actor &gt; &amp;actor)</arglist>
    </member>
    <member kind="function">
      <type>std::vector&lt; Glib::RefPtr&lt; Actor &gt; &gt;</type>
      <name>get_children</name>
      <anchorfile>classClutter_1_1Container.html</anchorfile>
      <anchor>a2fa1de02ed0544db2382a6297c983eb9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>std::vector&lt; Glib::RefPtr&lt; const Actor &gt; &gt;</type>
      <name>get_children</name>
      <anchorfile>classClutter_1_1Container.html</anchorfile>
      <anchor>a697f4af0676868d1d2a4ab28624ac3a3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>lower_child</name>
      <anchorfile>classClutter_1_1Container.html</anchorfile>
      <anchor>ad7ca4a8caf22523b446a529763ae5e3b</anchor>
      <arglist>(const Glib::RefPtr&lt; Actor &gt; &amp;actor, const Glib::RefPtr&lt; Actor &gt; &amp;sibling)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>lower_child</name>
      <anchorfile>classClutter_1_1Container.html</anchorfile>
      <anchor>ac8326b115b74a9fbcfb359a514a06a12</anchor>
      <arglist>(const Glib::RefPtr&lt; Actor &gt; &amp;actor)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>raise_child</name>
      <anchorfile>classClutter_1_1Container.html</anchorfile>
      <anchor>a0428bfe223687a9620044fad6c3fc8cb</anchor>
      <arglist>(const Glib::RefPtr&lt; Actor &gt; &amp;actor, const Glib::RefPtr&lt; Actor &gt; &amp;sibling)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>raise_child</name>
      <anchorfile>classClutter_1_1Container.html</anchorfile>
      <anchor>a644d9879a016c7adaaa6ec8170a31b79</anchor>
      <arglist>(const Glib::RefPtr&lt; Actor &gt; &amp;actor)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Actor &gt;</type>
      <name>find_child</name>
      <anchorfile>classClutter_1_1Container.html</anchorfile>
      <anchor>aa8b9ef8f0e0d5adc30324001bd8d0f11</anchor>
      <arglist>(const Glib::ustring &amp;child_name)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const Actor &gt;</type>
      <name>find_child</name>
      <anchorfile>classClutter_1_1Container.html</anchorfile>
      <anchor>ac48fdfdbcbf83fb2e078f57c20901a09</anchor>
      <arglist>(const Glib::ustring &amp;child_name) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>foreach</name>
      <anchorfile>classClutter_1_1Container.html</anchorfile>
      <anchor>a22162fcad7baa7b66038ba83fe03bb38</anchor>
      <arglist>(const SlotForEach &amp;slot)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_child_property</name>
      <anchorfile>classClutter_1_1Container.html</anchorfile>
      <anchor>ae513f809bf1c43343ea293c6fee09cb9</anchor>
      <arglist>(const Glib::RefPtr&lt; Actor &gt; &amp;child, const Glib::ustring &amp;property_name, const PropertyType &amp;value)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_child_property_value</name>
      <anchorfile>classClutter_1_1Container.html</anchorfile>
      <anchor>a6d4be2a351d94fc853e608c4d7d44c17</anchor>
      <arglist>(const Glib::RefPtr&lt; Actor &gt; &amp;child, const Glib::ustring &amp;property_name, const Glib::ValueBase &amp;value)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>get_child_property</name>
      <anchorfile>classClutter_1_1Container.html</anchorfile>
      <anchor>ae2de27349d59ac7de79222ec13a03f13</anchor>
      <arglist>(const Glib::RefPtr&lt; const Actor &gt; &amp;child, const Glib::ustring &amp;property_name, PropertyType &amp;value) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>get_child_property_value</name>
      <anchorfile>classClutter_1_1Container.html</anchorfile>
      <anchor>aeae83ecacc8dc72537bfcccd6cf29615</anchor>
      <arglist>(const Glib::RefPtr&lt; const Actor &gt; &amp;child, const Glib::ustring &amp;property_name, Glib::ValueBase &amp;value) const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; ChildMeta &gt;</type>
      <name>get_child_meta</name>
      <anchorfile>classClutter_1_1Container.html</anchorfile>
      <anchor>a19894ae1b9c4b2b1863a366fa474796a</anchor>
      <arglist>(const Glib::RefPtr&lt; const Actor &gt; &amp;actor)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const ChildMeta &gt;</type>
      <name>get_child_meta</name>
      <anchorfile>classClutter_1_1Container.html</anchorfile>
      <anchor>a0786284d4897a797b9c0694a44dc618b</anchor>
      <arglist>(const Glib::RefPtr&lt; const Actor &gt; &amp;actor) const </arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy1&lt; void, const Glib::RefPtr&lt; Actor &gt; &amp; &gt;</type>
      <name>signal_actor_added</name>
      <anchorfile>classClutter_1_1Container.html</anchorfile>
      <anchor>a435265dd2650bcf8ed9a4204d0ac803f</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy1&lt; void, const Glib::RefPtr&lt; Actor &gt; &amp; &gt;</type>
      <name>signal_actor_removed</name>
      <anchorfile>classClutter_1_1Container.html</anchorfile>
      <anchor>a9ce89ec3f64fbb607be21f893fd2f565</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy2&lt; void, const Glib::RefPtr&lt; Actor &gt; &amp;, GParamSpec * &gt;</type>
      <name>signal_child_notify</name>
      <anchorfile>classClutter_1_1Container.html</anchorfile>
      <anchor>a0967217464a58cd119164b373064e39c</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>add_interface</name>
      <anchorfile>classClutter_1_1Container.html</anchorfile>
      <anchor>a4723a92ca464a5eff2d261cc6e36c11b</anchor>
      <arglist>(GType gtype_implementer)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>sort_depth_order</name>
      <anchorfile>classClutter_1_1Container.html</anchorfile>
      <anchor>abcad19978064d87630859e7fcd45f834</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>add_vfunc</name>
      <anchorfile>classClutter_1_1Container.html</anchorfile>
      <anchor>a3fba49e92058679545560a50dfce5279</anchor>
      <arglist>(const Glib::RefPtr&lt; Actor &gt; &amp;actor)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>remove_vfunc</name>
      <anchorfile>classClutter_1_1Container.html</anchorfile>
      <anchor>acea67fa085b429d02c0b86c15f2474f7</anchor>
      <arglist>(const Glib::RefPtr&lt; Actor &gt; &amp;actor)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>raise_vfunc</name>
      <anchorfile>classClutter_1_1Container.html</anchorfile>
      <anchor>aeeb96bc1079aea5315e5fb9841316b47</anchor>
      <arglist>(const Glib::RefPtr&lt; Actor &gt; &amp;actor, const Glib::RefPtr&lt; Actor &gt; &amp;sibling)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>lower_vfunc</name>
      <anchorfile>classClutter_1_1Container.html</anchorfile>
      <anchor>a4affbfed0dbebca52462ebd5d8700f9b</anchor>
      <arglist>(const Glib::RefPtr&lt; Actor &gt; &amp;actor, const Glib::RefPtr&lt; Actor &gt; &amp;sibling)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>sort_depth_order_vfunc</name>
      <anchorfile>classClutter_1_1Container.html</anchorfile>
      <anchor>a6e6cb449d41f2abb1dd1b3ba3fb78c62</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>foreach_vfunc</name>
      <anchorfile>classClutter_1_1Container.html</anchorfile>
      <anchor>a419eb2ff6ebaf6294848a6eb8fec64c6</anchor>
      <arglist>(ClutterCallback callback, gpointer user_data)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>actor_added</name>
      <anchorfile>classClutter_1_1Container.html</anchorfile>
      <anchor>a108c4d5454c161c3581d33bc18c9a247</anchor>
      <arglist>(const Glib::RefPtr&lt; Actor &gt; &amp;actor)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>actor_removed</name>
      <anchorfile>classClutter_1_1Container.html</anchorfile>
      <anchor>ab240b40508183d778658ee7098b2c398</anchor>
      <arglist>(const Glib::RefPtr&lt; Actor &gt; &amp;actor)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>create_child_meta_vfunc</name>
      <anchorfile>classClutter_1_1Container.html</anchorfile>
      <anchor>af9b1967dbc5610272468f3ef0b965fb3</anchor>
      <arglist>(const Glib::RefPtr&lt; Actor &gt; &amp;actor)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>destroy_child_meta_vfunc</name>
      <anchorfile>classClutter_1_1Container.html</anchorfile>
      <anchor>ae6eb48fcad55ac4dcda198c5cf3a12ce</anchor>
      <arglist>(const Glib::RefPtr&lt; Actor &gt; &amp;actor)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual Glib::RefPtr&lt; ChildMeta &gt;</type>
      <name>get_child_meta_vfunc</name>
      <anchorfile>classClutter_1_1Container.html</anchorfile>
      <anchor>a52a8c6d59615ba41e2442cf3926aaa25</anchor>
      <arglist>(const Glib::RefPtr&lt; Actor &gt; &amp;actor)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>on_actor_added</name>
      <anchorfile>classClutter_1_1Container.html</anchorfile>
      <anchor>a382cd4c9ae705001a654e8af434cc514</anchor>
      <arglist>(const Glib::RefPtr&lt; Actor &gt; &amp;actor)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>on_actor_removed</name>
      <anchorfile>classClutter_1_1Container.html</anchorfile>
      <anchor>a32717f06ff5409d35f044ea3594f7209</anchor>
      <arglist>(const Glib::RefPtr&lt; Actor &gt; &amp;actor)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>on_child_notify</name>
      <anchorfile>classClutter_1_1Container.html</anchorfile>
      <anchor>a04fe51150829c51bc6e0101210faef62</anchor>
      <arglist>(const Glib::RefPtr&lt; Actor &gt; &amp;actor, GParamSpec *pspec)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Clutter::Container &gt;</type>
      <name>wrap</name>
      <anchorfile>classClutter_1_1Container.html</anchorfile>
      <anchor>a3796c3e775ba32a432dac8fda66bbaea</anchor>
      <arglist>(ClutterContainer *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Clutter::DeviceManager</name>
    <filename>classClutter_1_1DeviceManager.html</filename>
    <base>Glib::Object</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~DeviceManager</name>
      <anchorfile>classClutter_1_1DeviceManager.html</anchorfile>
      <anchor>a4c76e6f926dff6bb52afdd5fba4793fd</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>ClutterDeviceManager *</type>
      <name>gobj</name>
      <anchorfile>classClutter_1_1DeviceManager.html</anchorfile>
      <anchor>a08dca61286f18f86f45d575ccb4e03f3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const ClutterDeviceManager *</type>
      <name>gobj</name>
      <anchorfile>classClutter_1_1DeviceManager.html</anchorfile>
      <anchor>a28e4f7159f2cde57537142305586007a</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>ClutterDeviceManager *</type>
      <name>gobj_copy</name>
      <anchorfile>classClutter_1_1DeviceManager.html</anchorfile>
      <anchor>acfb6fff8fcd6f313e7ed295328ca34a6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; DeviceManager &gt;</type>
      <name>get_default</name>
      <anchorfile>classClutter_1_1DeviceManager.html</anchorfile>
      <anchor>a5f13b72a789a4086fdcb2704d923a48e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>std::vector&lt; Glib::RefPtr&lt; InputDevice &gt; &gt;</type>
      <name>list_devices</name>
      <anchorfile>classClutter_1_1DeviceManager.html</anchorfile>
      <anchor>abd7cd79e0c2aed9e48299967d3d5b0ca</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>std::vector&lt; Glib::RefPtr&lt; const InputDevice &gt; &gt;</type>
      <name>list_devices</name>
      <anchorfile>classClutter_1_1DeviceManager.html</anchorfile>
      <anchor>ac8450dd10a535c554a6a74cf7ab699cf</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; InputDevice &gt;</type>
      <name>get_device</name>
      <anchorfile>classClutter_1_1DeviceManager.html</anchorfile>
      <anchor>ac70fed1a601df250f89af80839f16375</anchor>
      <arglist>(int device_id)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const InputDevice &gt;</type>
      <name>get_device</name>
      <anchorfile>classClutter_1_1DeviceManager.html</anchorfile>
      <anchor>a977113fed25bfbf71c069bb6a1a8041c</anchor>
      <arglist>(int device_id) const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; InputDevice &gt;</type>
      <name>get_core_device</name>
      <anchorfile>classClutter_1_1DeviceManager.html</anchorfile>
      <anchor>a53aadc1e8158b2b147d6b29c3d7a435c</anchor>
      <arglist>(InputDeviceType device_type)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const InputDevice &gt;</type>
      <name>get_core_device</name>
      <anchorfile>classClutter_1_1DeviceManager.html</anchorfile>
      <anchor>a747bc62a252d0f36520c204b761694b7</anchor>
      <arglist>(InputDeviceType device_type) const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; Glib::RefPtr&lt; Backend &gt; &gt;</type>
      <name>property_backend</name>
      <anchorfile>classClutter_1_1DeviceManager.html</anchorfile>
      <anchor>a66a48137ee29e88232a70440455a63d3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>DeviceManager</name>
      <anchorfile>classClutter_1_1DeviceManager.html</anchorfile>
      <anchor>ad41d76035657ccdadb5a70894481d46b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Clutter::DeviceManager &gt;</type>
      <name>wrap</name>
      <anchorfile>classClutter_1_1DeviceManager.html</anchorfile>
      <anchor>a408a3b6de7ffed695af078a91236f28b</anchor>
      <arglist>(ClutterDeviceManager *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Clutter::FixedLayout</name>
    <filename>classClutter_1_1FixedLayout.html</filename>
    <base>Clutter::LayoutManager</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~FixedLayout</name>
      <anchorfile>classClutter_1_1FixedLayout.html</anchorfile>
      <anchor>a9c5c465524f6c97415cacb9100508413</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>ClutterFixedLayout *</type>
      <name>gobj</name>
      <anchorfile>classClutter_1_1FixedLayout.html</anchorfile>
      <anchor>a3243f2095cc609c4fce582e9eb166209</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const ClutterFixedLayout *</type>
      <name>gobj</name>
      <anchorfile>classClutter_1_1FixedLayout.html</anchorfile>
      <anchor>a66e1402aed89c28d95691ab087c58a78</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>ClutterFixedLayout *</type>
      <name>gobj_copy</name>
      <anchorfile>classClutter_1_1FixedLayout.html</anchorfile>
      <anchor>a35bb5d563b602fc649aeb7f74dfd3ec9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; FixedLayout &gt;</type>
      <name>create</name>
      <anchorfile>classClutter_1_1FixedLayout.html</anchorfile>
      <anchor>a1e868a347aad3277bc79cf3da54deaed</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>FixedLayout</name>
      <anchorfile>classClutter_1_1FixedLayout.html</anchorfile>
      <anchor>a0299c7e38049fadd2a143908cb8bf4d2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Clutter::FixedLayout &gt;</type>
      <name>wrap</name>
      <anchorfile>classClutter_1_1FixedLayout.html</anchorfile>
      <anchor>a9e77a2b729cc213df41e90d40b06704a</anchor>
      <arglist>(ClutterFixedLayout *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Clutter::FlowLayout</name>
    <filename>classClutter_1_1FlowLayout.html</filename>
    <base>Clutter::LayoutManager</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~FlowLayout</name>
      <anchorfile>classClutter_1_1FlowLayout.html</anchorfile>
      <anchor>ad7d988dc3c3b4d573e5221a7d72d554b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>ClutterFlowLayout *</type>
      <name>gobj</name>
      <anchorfile>classClutter_1_1FlowLayout.html</anchorfile>
      <anchor>adf765996e6e2363ac829cea61716bd2f</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const ClutterFlowLayout *</type>
      <name>gobj</name>
      <anchorfile>classClutter_1_1FlowLayout.html</anchorfile>
      <anchor>a2766d308d96d833897344469caae1bb5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>ClutterFlowLayout *</type>
      <name>gobj_copy</name>
      <anchorfile>classClutter_1_1FlowLayout.html</anchorfile>
      <anchor>a5cde8b9782a5fb190257e92978772d6d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_homogeneous</name>
      <anchorfile>classClutter_1_1FlowLayout.html</anchorfile>
      <anchor>a43a3c39b4307b29bdba38f6d975347c1</anchor>
      <arglist>(bool homogeneous)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_homogeneous</name>
      <anchorfile>classClutter_1_1FlowLayout.html</anchorfile>
      <anchor>a25405d7d86e0d18bc1a93f03e6b821f7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_orientation</name>
      <anchorfile>classClutter_1_1FlowLayout.html</anchorfile>
      <anchor>a8d62e7f14cb20b13e8e18ebc4270a3b1</anchor>
      <arglist>(FlowOrientation orientation)</arglist>
    </member>
    <member kind="function">
      <type>ClutterFlowOrientation</type>
      <name>get_orientation</name>
      <anchorfile>classClutter_1_1FlowLayout.html</anchorfile>
      <anchor>ab1cd1330e03a0a850a53019fadc68bdf</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_column_spacing</name>
      <anchorfile>classClutter_1_1FlowLayout.html</anchorfile>
      <anchor>a255890b03de665ddf3552823f41dbebc</anchor>
      <arglist>(float spacing)</arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>get_column_spacing</name>
      <anchorfile>classClutter_1_1FlowLayout.html</anchorfile>
      <anchor>a31fd5c4e36f5a542a0e382122e3d17c1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_row_spacing</name>
      <anchorfile>classClutter_1_1FlowLayout.html</anchorfile>
      <anchor>ae9fe037df753c119b6a7f7c376910e16</anchor>
      <arglist>(float spacing)</arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>get_row_spacing</name>
      <anchorfile>classClutter_1_1FlowLayout.html</anchorfile>
      <anchor>adc106fa04356cc7036049e1d0f7ca922</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_column_width</name>
      <anchorfile>classClutter_1_1FlowLayout.html</anchorfile>
      <anchor>ae01b37f865db236b465a915fda14f4ac</anchor>
      <arglist>(float min_width, float max_width)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>get_column_width</name>
      <anchorfile>classClutter_1_1FlowLayout.html</anchorfile>
      <anchor>a339f6acbe2e8b8d44c465aa31b8c693e</anchor>
      <arglist>(float &amp;min_width, float &amp;max_width)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_row_height</name>
      <anchorfile>classClutter_1_1FlowLayout.html</anchorfile>
      <anchor>a8f11d5834a60d5cbb78ac7aae80da152</anchor>
      <arglist>(float min_height, float max_height)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>get_row_height</name>
      <anchorfile>classClutter_1_1FlowLayout.html</anchorfile>
      <anchor>ad91e343e720e70efc1ef638a4a15be83</anchor>
      <arglist>(float &amp;min_height, float &amp;max_height)</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; bool &gt;</type>
      <name>property_homogeneous</name>
      <anchorfile>classClutter_1_1FlowLayout.html</anchorfile>
      <anchor>a0013d7c4ab86e7e5175f905a960ec50c</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; bool &gt;</type>
      <name>property_homogeneous</name>
      <anchorfile>classClutter_1_1FlowLayout.html</anchorfile>
      <anchor>ad2a353de73bcd1efeb29874ea4567248</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; FlowOrientation &gt;</type>
      <name>property_orientation</name>
      <anchorfile>classClutter_1_1FlowLayout.html</anchorfile>
      <anchor>ad0ca03cc029171c19fa6aaa9da2da2ce</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; FlowOrientation &gt;</type>
      <name>property_orientation</name>
      <anchorfile>classClutter_1_1FlowLayout.html</anchorfile>
      <anchor>a2f6d1c87b8ee87d80a2f6e89bc5fed2a</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; float &gt;</type>
      <name>property_column_spacing</name>
      <anchorfile>classClutter_1_1FlowLayout.html</anchorfile>
      <anchor>abf0256d79627dd73a0e1194ccf8e68a5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; float &gt;</type>
      <name>property_column_spacing</name>
      <anchorfile>classClutter_1_1FlowLayout.html</anchorfile>
      <anchor>a76f4082e8be1268500aba99a677efe7b</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; float &gt;</type>
      <name>property_row_spacing</name>
      <anchorfile>classClutter_1_1FlowLayout.html</anchorfile>
      <anchor>a07b65d9f47240cec39eb83a79e253d8f</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; float &gt;</type>
      <name>property_row_spacing</name>
      <anchorfile>classClutter_1_1FlowLayout.html</anchorfile>
      <anchor>a4eb7932ddad5b970d8246988132136af</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; float &gt;</type>
      <name>property_min_column_width</name>
      <anchorfile>classClutter_1_1FlowLayout.html</anchorfile>
      <anchor>ad39f86c6a5bdf8259b62ea6f2cdf73f9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; float &gt;</type>
      <name>property_min_column_width</name>
      <anchorfile>classClutter_1_1FlowLayout.html</anchorfile>
      <anchor>a223598d3aa344db214ff801d04b9f2c3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; float &gt;</type>
      <name>property_max_column_width</name>
      <anchorfile>classClutter_1_1FlowLayout.html</anchorfile>
      <anchor>a145729ebd8a044d694cf2d6a6e266097</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; float &gt;</type>
      <name>property_max_column_width</name>
      <anchorfile>classClutter_1_1FlowLayout.html</anchorfile>
      <anchor>a435c7603f35227acf5dfb714cf36e0bd</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; FlowLayout &gt;</type>
      <name>create</name>
      <anchorfile>classClutter_1_1FlowLayout.html</anchorfile>
      <anchor>a904651adea4ed467b9956218ee7244b6</anchor>
      <arglist>(FlowOrientation orientation)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>FlowLayout</name>
      <anchorfile>classClutter_1_1FlowLayout.html</anchorfile>
      <anchor>a0ba82afcf614ee132b1b589eb7e46b51</anchor>
      <arglist>(FlowOrientation orientation)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Clutter::FlowLayout &gt;</type>
      <name>wrap</name>
      <anchorfile>classClutter_1_1FlowLayout.html</anchorfile>
      <anchor>a04e065e9251509fda26abd3f2f127351</anchor>
      <arglist>(ClutterFlowLayout *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Clutter::Group</name>
    <filename>classClutter_1_1Group.html</filename>
    <base>Clutter::Actor</base>
    <base>Clutter::Container</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~Group</name>
      <anchorfile>classClutter_1_1Group.html</anchorfile>
      <anchor>a136c8ffe2c132dfc8699b3067b11492d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>ClutterGroup *</type>
      <name>gobj</name>
      <anchorfile>classClutter_1_1Group.html</anchorfile>
      <anchor>ad64650e9c37c7b064909007e4fda958e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const ClutterGroup *</type>
      <name>gobj</name>
      <anchorfile>classClutter_1_1Group.html</anchorfile>
      <anchor>a581ed3caf5f9b28933aaa602cc6b7062</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>ClutterGroup *</type>
      <name>gobj_copy</name>
      <anchorfile>classClutter_1_1Group.html</anchorfile>
      <anchor>a9e33614f259fad05ce4eded6a85c287b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>remove_all</name>
      <anchorfile>classClutter_1_1Group.html</anchorfile>
      <anchor>a5bd542655224c297ffc4f866c1bf2195</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>get_n_children</name>
      <anchorfile>classClutter_1_1Group.html</anchorfile>
      <anchor>aee5d4e3982cb52817989cd51f0ce277d</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Actor &gt;</type>
      <name>get_nth_child</name>
      <anchorfile>classClutter_1_1Group.html</anchorfile>
      <anchor>afffe311f73c9bdde02d0d23bda442501</anchor>
      <arglist>(int index)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const Actor &gt;</type>
      <name>get_nth_child</name>
      <anchorfile>classClutter_1_1Group.html</anchorfile>
      <anchor>a64fb3f1721816e9ee00d4318c1d0b092</anchor>
      <arglist>(int index) const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; Group &gt;</type>
      <name>create</name>
      <anchorfile>classClutter_1_1Group.html</anchorfile>
      <anchor>a8451890060db43c5ac1c9d98f995b51e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>Group</name>
      <anchorfile>classClutter_1_1Group.html</anchorfile>
      <anchor>afcd6f57a78813e37f3d5d6f63528207b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Clutter::Group &gt;</type>
      <name>wrap</name>
      <anchorfile>classClutter_1_1Group.html</anchorfile>
      <anchor>a1bc3e2bda13e501526fba39d1a853f11</anchor>
      <arglist>(ClutterGroup *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Clutter::InputDevice</name>
    <filename>classClutter_1_1InputDevice.html</filename>
    <base>Glib::Object</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~InputDevice</name>
      <anchorfile>classClutter_1_1InputDevice.html</anchorfile>
      <anchor>aa716273cfdad97276659edca015718d2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>ClutterInputDevice *</type>
      <name>gobj</name>
      <anchorfile>classClutter_1_1InputDevice.html</anchorfile>
      <anchor>acaf8d46fe5633e3b746612c8dec064c4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const ClutterInputDevice *</type>
      <name>gobj</name>
      <anchorfile>classClutter_1_1InputDevice.html</anchorfile>
      <anchor>a65140a26fe6a906792b2eb370a26dada</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>ClutterInputDevice *</type>
      <name>gobj_copy</name>
      <anchorfile>classClutter_1_1InputDevice.html</anchorfile>
      <anchor>a81d3be78596b5b526102b094fe935f1c</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>get_device_id</name>
      <anchorfile>classClutter_1_1InputDevice.html</anchorfile>
      <anchor>ad08057790820d2a96c15376cd5f2ce05</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>InputDeviceType</type>
      <name>get_device_type</name>
      <anchorfile>classClutter_1_1InputDevice.html</anchorfile>
      <anchor>a7247460da0cf94836d7dc9849fbffbbe</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_device_name</name>
      <anchorfile>classClutter_1_1InputDevice.html</anchorfile>
      <anchor>aaae37e68916c91c3f751b1a69e042777</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>get_device_coords</name>
      <anchorfile>classClutter_1_1InputDevice.html</anchorfile>
      <anchor>a35dea79b25a94a107b8450f611e0cc9e</anchor>
      <arglist>(int &amp;x, int &amp;y) const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Actor &gt;</type>
      <name>get_pointer_actor</name>
      <anchorfile>classClutter_1_1InputDevice.html</anchorfile>
      <anchor>a79e45d097f4e195430bfa8d7bc277844</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const Actor &gt;</type>
      <name>get_pointer_actor</name>
      <anchorfile>classClutter_1_1InputDevice.html</anchorfile>
      <anchor>a38ef3ad810c23b7534bdb9e08ba8cb71</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Stage &gt;</type>
      <name>get_pointer_stage</name>
      <anchorfile>classClutter_1_1InputDevice.html</anchorfile>
      <anchor>ac4e79602fc4d50f8bc32af2429e6d98e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const Stage &gt;</type>
      <name>get_pointer_stage</name>
      <anchorfile>classClutter_1_1InputDevice.html</anchorfile>
      <anchor>ac38442226c33d075074937e03390a8fa</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; InputDeviceType &gt;</type>
      <name>property_device_type</name>
      <anchorfile>classClutter_1_1InputDevice.html</anchorfile>
      <anchor>a0275a2f3cb9b141b894e1e9f8f1fe5c7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; int &gt;</type>
      <name>property_id</name>
      <anchorfile>classClutter_1_1InputDevice.html</anchorfile>
      <anchor>a8c82f19e1c15444b1065221f0c561483</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; Glib::ustring &gt;</type>
      <name>property_name</name>
      <anchorfile>classClutter_1_1InputDevice.html</anchorfile>
      <anchor>a11a45dc5304db471105472f98f0dd694</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>InputDevice</name>
      <anchorfile>classClutter_1_1InputDevice.html</anchorfile>
      <anchor>ad1c648da281abd371f2f33cb38a9c4da</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Clutter::InputDevice &gt;</type>
      <name>wrap</name>
      <anchorfile>classClutter_1_1InputDevice.html</anchorfile>
      <anchor>adb2687181a9694eee6be492d51e4cf92</anchor>
      <arglist>(ClutterInputDevice *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Clutter::Interval</name>
    <filename>classClutter_1_1Interval.html</filename>
    <base>Glib::Object</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~Interval</name>
      <anchorfile>classClutter_1_1Interval.html</anchorfile>
      <anchor>ab8c890163e92b05de41b4cfc59fa6537</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>ClutterInterval *</type>
      <name>gobj</name>
      <anchorfile>classClutter_1_1Interval.html</anchorfile>
      <anchor>a2db7f7063a39f78f5653e3b47ba009b0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const ClutterInterval *</type>
      <name>gobj</name>
      <anchorfile>classClutter_1_1Interval.html</anchorfile>
      <anchor>a92bbfd05c1104fa55043dac6a46f214b</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>ClutterInterval *</type>
      <name>gobj_copy</name>
      <anchorfile>classClutter_1_1Interval.html</anchorfile>
      <anchor>a342d0e8240eddfb293bb4d664eafc3e4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Interval &gt;</type>
      <name>clone</name>
      <anchorfile>classClutter_1_1Interval.html</anchorfile>
      <anchor>a5ff4f2e3bea4e2a7de000c8b3c95aed4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GType</type>
      <name>get_value_type</name>
      <anchorfile>classClutter_1_1Interval.html</anchorfile>
      <anchor>a3fb60812110347b5ca5781ba94ecf187</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_initial_value</name>
      <anchorfile>classClutter_1_1Interval.html</anchorfile>
      <anchor>a7d93c09dec29612416db698509bd9163</anchor>
      <arglist>(const Glib::ValueBase &amp;value)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>get_initial_value</name>
      <anchorfile>classClutter_1_1Interval.html</anchorfile>
      <anchor>a37f0737bf802886ab942d933b0a02595</anchor>
      <arglist>(Glib::ValueBase &amp;value) const </arglist>
    </member>
    <member kind="function">
      <type>GValue *</type>
      <name>peek_initial_value</name>
      <anchorfile>classClutter_1_1Interval.html</anchorfile>
      <anchor>a2cd62ef29bbb3f0909a70c4da2db31c0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_final_value</name>
      <anchorfile>classClutter_1_1Interval.html</anchorfile>
      <anchor>a6c2c8f64ac7a5bef5cf0d63002d6b491</anchor>
      <arglist>(const Glib::ValueBase &amp;value)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>get_final_value</name>
      <anchorfile>classClutter_1_1Interval.html</anchorfile>
      <anchor>ae7fa673cad0ab192d594949df745e796</anchor>
      <arglist>(Glib::ValueBase &amp;value) const </arglist>
    </member>
    <member kind="function">
      <type>GValue *</type>
      <name>peek_final_value</name>
      <anchorfile>classClutter_1_1Interval.html</anchorfile>
      <anchor>a53561e1763c0f499e95ce6135eb55d97</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_interval</name>
      <anchorfile>classClutter_1_1Interval.html</anchorfile>
      <anchor>a04a710d3b041aa456d29d2a8a21033d3</anchor>
      <arglist>(const Glib::ValueBase &amp;initial, const Glib::ValueBase &amp;final)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>get_interval</name>
      <anchorfile>classClutter_1_1Interval.html</anchorfile>
      <anchor>a340eb52028b147be316e705e0014abaa</anchor>
      <arglist>(Glib::ValueBase &amp;initial, Glib::ValueBase &amp;final)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>compute_value</name>
      <anchorfile>classClutter_1_1Interval.html</anchorfile>
      <anchor>ab2b4106befd83f9ca003a212e71ae977</anchor>
      <arglist>(double factor, Glib::ValueBase &amp;value) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>validate</name>
      <anchorfile>classClutter_1_1Interval.html</anchorfile>
      <anchor>a3fb10e88dc7addc579ce2da94c8ebef3</anchor>
      <arglist>(GParamSpec *pspec) const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; GType &gt;</type>
      <name>property_value_type</name>
      <anchorfile>classClutter_1_1Interval.html</anchorfile>
      <anchor>a406d28ec4f3cb254578396b278a7feb4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; Interval &gt;</type>
      <name>create</name>
      <anchorfile>classClutter_1_1Interval.html</anchorfile>
      <anchor>a9dd4ed681dba36ccae34d5858237b948</anchor>
      <arglist>(const ValueType initial, const ValueType final)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; Interval &gt;</type>
      <name>create_with_values</name>
      <anchorfile>classClutter_1_1Interval.html</anchorfile>
      <anchor>ab1aaf795ddf535b4a5711cae000f07d3</anchor>
      <arglist>(const Glib::Value&lt; ValueType &gt; &amp;initial, const Glib::Value&lt; ValueType &gt; &amp;final)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>Interval</name>
      <anchorfile>classClutter_1_1Interval.html</anchorfile>
      <anchor>a228fe1a3ee7e7b504451294e86e9b66b</anchor>
      <arglist>(GType type, const Glib::ValueBase &amp;initial, const Glib::ValueBase &amp;final)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Clutter::Interval &gt;</type>
      <name>wrap</name>
      <anchorfile>classClutter_1_1Interval.html</anchorfile>
      <anchor>a9e1d7afb6fe818b846239e29f4d6bf1b</anchor>
      <arglist>(ClutterInterval *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Clutter::LayoutMeta</name>
    <filename>classClutter_1_1LayoutMeta.html</filename>
    <base>Clutter::ChildMeta</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~LayoutMeta</name>
      <anchorfile>classClutter_1_1LayoutMeta.html</anchorfile>
      <anchor>a6f65253eb26acd80c5c68e1945b25efc</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>ClutterLayoutMeta *</type>
      <name>gobj</name>
      <anchorfile>classClutter_1_1LayoutMeta.html</anchorfile>
      <anchor>a1f18f2f6a93b4b2eafe2ce95fe131318</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const ClutterLayoutMeta *</type>
      <name>gobj</name>
      <anchorfile>classClutter_1_1LayoutMeta.html</anchorfile>
      <anchor>a7879e219b3554090d8b5484b09bf795c</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>ClutterLayoutMeta *</type>
      <name>gobj_copy</name>
      <anchorfile>classClutter_1_1LayoutMeta.html</anchorfile>
      <anchor>a92c830db026a65ecc8a9105aefc23396</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; LayoutManager &gt;</type>
      <name>get_manager</name>
      <anchorfile>classClutter_1_1LayoutMeta.html</anchorfile>
      <anchor>a29f09294a9640db0373ffc14b7bd2a9e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const LayoutManager &gt;</type>
      <name>get_manager</name>
      <anchorfile>classClutter_1_1LayoutMeta.html</anchorfile>
      <anchor>a652e580a81df2e3fa95b08a1f534c270</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; Glib::RefPtr&lt; LayoutManager &gt; &gt;</type>
      <name>property_manager</name>
      <anchorfile>classClutter_1_1LayoutMeta.html</anchorfile>
      <anchor>aa58105be15d1310b2945786dc4fa8faa</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>LayoutMeta</name>
      <anchorfile>classClutter_1_1LayoutMeta.html</anchorfile>
      <anchor>a01d980cc824f5d5f99c3c402152bc66b</anchor>
      <arglist>(const Glib::RefPtr&lt; LayoutManager &gt; &amp;layoutManager)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Clutter::LayoutMeta &gt;</type>
      <name>wrap</name>
      <anchorfile>classClutter_1_1LayoutMeta.html</anchorfile>
      <anchor>abec78901ed3de5c4c32f283a8626dc8c</anchor>
      <arglist>(ClutterLayoutMeta *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Clutter::LayoutManager</name>
    <filename>classClutter_1_1LayoutManager.html</filename>
    <base>Glib::Object</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~LayoutManager</name>
      <anchorfile>classClutter_1_1LayoutManager.html</anchorfile>
      <anchor>a17f4ac5dce26e6f4fe46c47e0748cb40</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>ClutterLayoutManager *</type>
      <name>gobj</name>
      <anchorfile>classClutter_1_1LayoutManager.html</anchorfile>
      <anchor>a4ba6d37dd6033f277e4296d65fc5ab44</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const ClutterLayoutManager *</type>
      <name>gobj</name>
      <anchorfile>classClutter_1_1LayoutManager.html</anchorfile>
      <anchor>a289a4d522b76d5d7e8902eb6cbf37b01</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>ClutterLayoutManager *</type>
      <name>gobj_copy</name>
      <anchorfile>classClutter_1_1LayoutManager.html</anchorfile>
      <anchor>a276256b027d96dceaa910cf946d484c9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_child_property</name>
      <anchorfile>classClutter_1_1LayoutManager.html</anchorfile>
      <anchor>ad47ff0b8e7dbeecdc2103c5a22a6f51a</anchor>
      <arglist>(const Glib::RefPtr&lt; Container &gt; &amp;container, const Glib::RefPtr&lt; Actor &gt; &amp;child, const Glib::ustring &amp;property_name, const PropertyType &amp;value)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_child_property_value</name>
      <anchorfile>classClutter_1_1LayoutManager.html</anchorfile>
      <anchor>a64247d8f2ccbaca0ef61036dce3a46ec</anchor>
      <arglist>(const Glib::RefPtr&lt; Container &gt; &amp;container, const Glib::RefPtr&lt; Actor &gt; &amp;child, const Glib::ustring &amp;property_name, const Glib::ValueBase &amp;value)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>get_child_property</name>
      <anchorfile>classClutter_1_1LayoutManager.html</anchorfile>
      <anchor>a2d0c3e8d4994b21c646f6124e8c4fad8</anchor>
      <arglist>(const Glib::RefPtr&lt; Container &gt; &amp;container, const Glib::RefPtr&lt; const Actor &gt; &amp;actor, const Glib::ustring &amp;property_name, PropertyType &amp;value) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>get_child_property_value</name>
      <anchorfile>classClutter_1_1LayoutManager.html</anchorfile>
      <anchor>a3b9977d77d3be7d5b841423714e08513</anchor>
      <arglist>(const Glib::RefPtr&lt; Container &gt; &amp;container, const Glib::RefPtr&lt; const Actor &gt; &amp;actor, const Glib::ustring &amp;property_name, Glib::ValueBase &amp;value) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>get_preferred_width</name>
      <anchorfile>classClutter_1_1LayoutManager.html</anchorfile>
      <anchor>a6636d0f479713c4a717cb4b7ecfb15d7</anchor>
      <arglist>(const Glib::RefPtr&lt; Container &gt; &amp;container, float for_height, float &amp;min_width_p, float &amp;natural_width_p) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>get_preferred_height</name>
      <anchorfile>classClutter_1_1LayoutManager.html</anchorfile>
      <anchor>a81565de04341f3c6c603f53b26f282e5</anchor>
      <arglist>(const Glib::RefPtr&lt; Container &gt; &amp;container, float for_width, float &amp;min_height_p, float &amp;natural_height_p) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>allocate</name>
      <anchorfile>classClutter_1_1LayoutManager.html</anchorfile>
      <anchor>a048a6c75cfbf1618dc258a5ebe02f0e1</anchor>
      <arglist>(const Glib::RefPtr&lt; Container &gt; &amp;container, const ActorBox &amp;box, AllocationFlags absolute_origin_changed)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_container</name>
      <anchorfile>classClutter_1_1LayoutManager.html</anchorfile>
      <anchor>a32094d5870f689a03bd149e478b135bb</anchor>
      <arglist>(const Glib::RefPtr&lt; Container &gt; &amp;container)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Alpha &gt;</type>
      <name>begin_animation</name>
      <anchorfile>classClutter_1_1LayoutManager.html</anchorfile>
      <anchor>ad6f8969488b2081e844efa7dc895736a</anchor>
      <arglist>(guint duration, gulong mode)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const Alpha &gt;</type>
      <name>begin_animation</name>
      <anchorfile>classClutter_1_1LayoutManager.html</anchorfile>
      <anchor>a1f2bb97bb05f5eeb284cce623b86cae4</anchor>
      <arglist>(guint duration, gulong mode) const </arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>get_animation_progress</name>
      <anchorfile>classClutter_1_1LayoutManager.html</anchorfile>
      <anchor>a5edcd94c58bb4714594676f0f9e36f50</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>end_animation</name>
      <anchorfile>classClutter_1_1LayoutManager.html</anchorfile>
      <anchor>a6e76f097d4c7debef978b0180370e3af</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>get_preferred_width_vfunc</name>
      <anchorfile>classClutter_1_1LayoutManager.html</anchorfile>
      <anchor>a608017f0df39d45d29f108994bd6ebb7</anchor>
      <arglist>(const Glib::RefPtr&lt; Container &gt; &amp;container, float for_height, float &amp;min_width_p, float &amp;natural_width_p) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>get_preferred_height_vfunc</name>
      <anchorfile>classClutter_1_1LayoutManager.html</anchorfile>
      <anchor>a3a064da6df240ded6fb482b96e07ee00</anchor>
      <arglist>(const Glib::RefPtr&lt; Container &gt; &amp;container, float for_width, float &amp;min_height_p, float &amp;natural_height_p) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>allocate_vfunc</name>
      <anchorfile>classClutter_1_1LayoutManager.html</anchorfile>
      <anchor>a5cbf6136537d32bc95b0a4243b0e706d</anchor>
      <arglist>(const Glib::RefPtr&lt; Container &gt; &amp;container, const ActorBox &amp;box, AllocationFlags absolute_origin_changed)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>set_container_vfunc</name>
      <anchorfile>classClutter_1_1LayoutManager.html</anchorfile>
      <anchor>ac37e32b117b38128a69f909714c796b4</anchor>
      <arglist>(const Glib::RefPtr&lt; Container &gt; &amp;container)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual GType</type>
      <name>get_child_meta_type_vfunc</name>
      <anchorfile>classClutter_1_1LayoutManager.html</anchorfile>
      <anchor>a47b7c1cc3c88d000b08f00d3badf44dc</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual Glib::RefPtr&lt; LayoutMeta &gt;</type>
      <name>create_child_meta_vfunc</name>
      <anchorfile>classClutter_1_1LayoutManager.html</anchorfile>
      <anchor>acb32eb3b051feaccbf8cd93effdf6751</anchor>
      <arglist>(const Glib::RefPtr&lt; Container &gt; &amp;container, const Glib::RefPtr&lt; Actor &gt; &amp;actor)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual Glib::RefPtr&lt; Alpha &gt;</type>
      <name>begin_animation_vfunc</name>
      <anchorfile>classClutter_1_1LayoutManager.html</anchorfile>
      <anchor>aa3faf1fd80ae8a58880a2a3b449c8d2d</anchor>
      <arglist>(guint duration, gulong mode)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual double</type>
      <name>get_animation_progress_vfunc</name>
      <anchorfile>classClutter_1_1LayoutManager.html</anchorfile>
      <anchor>aad9e09af6babaee652ecba8c1252c6c5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>end_animation_vfunc</name>
      <anchorfile>classClutter_1_1LayoutManager.html</anchorfile>
      <anchor>aae26de356261f29bfcf41f99986bfa81</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy0&lt; void &gt;</type>
      <name>signal_layout_changed</name>
      <anchorfile>classClutter_1_1LayoutManager.html</anchorfile>
      <anchor>a95ccac0dcd701d593480a8ea8be61ff8</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>LayoutManager</name>
      <anchorfile>classClutter_1_1LayoutManager.html</anchorfile>
      <anchor>a34a5a7f54bd4f2e7f95d7daf105af313</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>on_layout_changed</name>
      <anchorfile>classClutter_1_1LayoutManager.html</anchorfile>
      <anchor>a6c907979af9cfdc701537b3af17956c8</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Clutter::LayoutManager &gt;</type>
      <name>wrap</name>
      <anchorfile>classClutter_1_1LayoutManager.html</anchorfile>
      <anchor>a733aaee32b63c42c07804fe51aa05913</anchor>
      <arglist>(ClutterLayoutManager *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Clutter::Media</name>
    <filename>classClutter_1_1Media.html</filename>
    <base>Glib::Interface</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~Media</name>
      <anchorfile>classClutter_1_1Media.html</anchorfile>
      <anchor>a59b50cc12f1ea377448d1c53c3347559</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>ClutterMedia *</type>
      <name>gobj</name>
      <anchorfile>classClutter_1_1Media.html</anchorfile>
      <anchor>a01cdaab4eb6724b5a51bfd7f7af1eb85</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const ClutterMedia *</type>
      <name>gobj</name>
      <anchorfile>classClutter_1_1Media.html</anchorfile>
      <anchor>ac45efa1baa3f72281067cdf284764c00</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_uri</name>
      <anchorfile>classClutter_1_1Media.html</anchorfile>
      <anchor>ab857819058176fb711f8dad5ae4337f0</anchor>
      <arglist>(const Glib::ustring &amp;uri)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_uri</name>
      <anchorfile>classClutter_1_1Media.html</anchorfile>
      <anchor>a25f8e641151ca319fce38d58fcbb33cb</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_playing</name>
      <anchorfile>classClutter_1_1Media.html</anchorfile>
      <anchor>a218ffc51a18ea8e3936b51577d950945</anchor>
      <arglist>(bool playing=true)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_playing</name>
      <anchorfile>classClutter_1_1Media.html</anchorfile>
      <anchor>a1ae9c659af6970e29ffc1a34d9d36916</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_progress</name>
      <anchorfile>classClutter_1_1Media.html</anchorfile>
      <anchor>a83aee3b9ed4a27ddb275fcbec6ee0e7f</anchor>
      <arglist>(double progress)</arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>get_progress</name>
      <anchorfile>classClutter_1_1Media.html</anchorfile>
      <anchor>a574a6c3f032f99f70425cd9a887fdb2b</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_subtitle_uri</name>
      <anchorfile>classClutter_1_1Media.html</anchorfile>
      <anchor>a42e0b73874b5a33f5f0e7967a559df35</anchor>
      <arglist>(const gchar *uri)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_subtitle_uri</name>
      <anchorfile>classClutter_1_1Media.html</anchorfile>
      <anchor>a316b5a0cccfefde566a767d01b57fcda</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_subtitle_font_name</name>
      <anchorfile>classClutter_1_1Media.html</anchorfile>
      <anchor>a4e8606a90daa1e38350c887ade2c614f</anchor>
      <arglist>(const std::string &amp;font_name)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_subtitle_font_name</name>
      <anchorfile>classClutter_1_1Media.html</anchorfile>
      <anchor>abf50bc3a6d33848bdca84ccc15ffd199</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_audio_volume</name>
      <anchorfile>classClutter_1_1Media.html</anchorfile>
      <anchor>a66469f993e3bf15dda4d3d8e5cb51267</anchor>
      <arglist>(double volume)</arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>get_audio_volume</name>
      <anchorfile>classClutter_1_1Media.html</anchorfile>
      <anchor>ac1c2a6a18d8ac7edc3ed1f360b0888a0</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>get_buffer_percent</name>
      <anchorfile>classClutter_1_1Media.html</anchorfile>
      <anchor>a28bbcea9fc28ca5b5d5c92258446362f</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_filename</name>
      <anchorfile>classClutter_1_1Media.html</anchorfile>
      <anchor>a5498d02a698b11c23f404364497dcc6d</anchor>
      <arglist>(const Glib::ustring &amp;filename)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_can_seek</name>
      <anchorfile>classClutter_1_1Media.html</anchorfile>
      <anchor>a423395d4b946a363c3730463bca2cd56</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>get_duration</name>
      <anchorfile>classClutter_1_1Media.html</anchorfile>
      <anchor>a0382d0366ca5d0090ffe215e48a78098</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy0&lt; void &gt;</type>
      <name>signal_eos</name>
      <anchorfile>classClutter_1_1Media.html</anchorfile>
      <anchor>af3c3a39407a01a50272a5b0afc560ea7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; double &gt;</type>
      <name>property_buffer_fill</name>
      <anchorfile>classClutter_1_1Media.html</anchorfile>
      <anchor>a5fc9672db6fc5ce60e9bb7150dc1a92e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; bool &gt;</type>
      <name>property_can_seek</name>
      <anchorfile>classClutter_1_1Media.html</anchorfile>
      <anchor>a812f4835bbd52affe4886702c9d2200f</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; guint &gt;</type>
      <name>property_duration</name>
      <anchorfile>classClutter_1_1Media.html</anchorfile>
      <anchor>a946103e2e9c13b6e8c3b8fc8dc230850</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; bool &gt;</type>
      <name>property_playing</name>
      <anchorfile>classClutter_1_1Media.html</anchorfile>
      <anchor>af3c66e262128f2fd2abfbd392b9347dc</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; bool &gt;</type>
      <name>property_playing</name>
      <anchorfile>classClutter_1_1Media.html</anchorfile>
      <anchor>a82a7924cffb0c1d57a6b0b008cda488a</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; double &gt;</type>
      <name>property_progress</name>
      <anchorfile>classClutter_1_1Media.html</anchorfile>
      <anchor>ac7bef54417977ad6150b375300a1d1e9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; double &gt;</type>
      <name>property_progress</name>
      <anchorfile>classClutter_1_1Media.html</anchorfile>
      <anchor>a895974502b6a28b175956869f7f56eea</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; Glib::ustring &gt;</type>
      <name>property_uri</name>
      <anchorfile>classClutter_1_1Media.html</anchorfile>
      <anchor>af581bfb6b14b222a1e58ce29c8eeb797</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; Glib::ustring &gt;</type>
      <name>property_uri</name>
      <anchorfile>classClutter_1_1Media.html</anchorfile>
      <anchor>ac774f481d119594cf808d5797e65d0e2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; double &gt;</type>
      <name>property_audio_volume</name>
      <anchorfile>classClutter_1_1Media.html</anchorfile>
      <anchor>a415e65f2767a779b496fadea50969d18</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; double &gt;</type>
      <name>property_audio_volume</name>
      <anchorfile>classClutter_1_1Media.html</anchorfile>
      <anchor>a4f77a628ce38641ad7a04ea2f9d2c469</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; Glib::ustring &gt;</type>
      <name>property_subtitle_font_name</name>
      <anchorfile>classClutter_1_1Media.html</anchorfile>
      <anchor>a33439db4dc401aab9cb53c6ae3a6b00a</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; Glib::ustring &gt;</type>
      <name>property_subtitle_font_name</name>
      <anchorfile>classClutter_1_1Media.html</anchorfile>
      <anchor>a8490ccc735f39443207f00ed0aac66fc</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; Glib::ustring &gt;</type>
      <name>property_subtitle_uri</name>
      <anchorfile>classClutter_1_1Media.html</anchorfile>
      <anchor>a7a3de34acdc57ee0a95b7530e9969d48</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; Glib::ustring &gt;</type>
      <name>property_subtitle_uri</name>
      <anchorfile>classClutter_1_1Media.html</anchorfile>
      <anchor>a00df1c0e2afe36fa64fa54cee0490b94</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>add_interface</name>
      <anchorfile>classClutter_1_1Media.html</anchorfile>
      <anchor>ada62fe508bd3ccf346d2642434651c34</anchor>
      <arglist>(GType gtype_implementer)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>on_eos</name>
      <anchorfile>classClutter_1_1Media.html</anchorfile>
      <anchor>a8861f1fe42a3ba0882d68077c75d3782</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Clutter::Media &gt;</type>
      <name>wrap</name>
      <anchorfile>classClutter_1_1Media.html</anchorfile>
      <anchor>a8bc7472b699556b25fe81faf65cbee7f</anchor>
      <arglist>(ClutterMedia *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Clutter::PathNode</name>
    <filename>classClutter_1_1PathNode.html</filename>
    <member kind="typedef">
      <type>guint</type>
      <name>size_type</name>
      <anchorfile>classClutter_1_1PathNode.html</anchorfile>
      <anchor>a7ca017d8f8d5de4f3c99d2ca6febb2ac</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>int</type>
      <name>difference_type</name>
      <anchorfile>classClutter_1_1PathNode.html</anchorfile>
      <anchor>ac8449f13f6ff9492163385531fb138c0</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Knot</type>
      <name>value_type</name>
      <anchorfile>classClutter_1_1PathNode.html</anchorfile>
      <anchor>a398a3a6ef36c1b39de03f220d2022cd0</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Knot &amp;</type>
      <name>reference</name>
      <anchorfile>classClutter_1_1PathNode.html</anchorfile>
      <anchor>a4f20090ad0885f346c88387b571cb607</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>const Knot &amp;</type>
      <name>const_reference</name>
      <anchorfile>classClutter_1_1PathNode.html</anchorfile>
      <anchor>a23ac531a4e167623f9e50e000d1551ce</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Knot *</type>
      <name>iterator</name>
      <anchorfile>classClutter_1_1PathNode.html</anchorfile>
      <anchor>a10a27b88458b7f89b64b06545c9307c7</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>const Knot *</type>
      <name>const_iterator</name>
      <anchorfile>classClutter_1_1PathNode.html</anchorfile>
      <anchor>a2eb3b42efe1647fdada6cd6fdc68d53b</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>std::reverse_iterator&lt; iterator &gt;</type>
      <name>reverse_iterator</name>
      <anchorfile>classClutter_1_1PathNode.html</anchorfile>
      <anchor>ae3f140d36613b9e2c45ecc9bff1bfd50</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>std::reverse_iterator&lt; const_iterator &gt;</type>
      <name>const_reverse_iterator</name>
      <anchorfile>classClutter_1_1PathNode.html</anchorfile>
      <anchor>a232366e61707c810f77a54e0a2759599</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>PathNode</name>
      <anchorfile>classClutter_1_1PathNode.html</anchorfile>
      <anchor>a94cd03e75f41c5385cf29b1e6a638df0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>PathNode</name>
      <anchorfile>classClutter_1_1PathNode.html</anchorfile>
      <anchor>a39998cfec15d83a37bdf91bf0d99c3a1</anchor>
      <arglist>(const ClutterPathNode *gobject)</arglist>
    </member>
    <member kind="function">
      <type>ClutterPathNode *</type>
      <name>gobj</name>
      <anchorfile>classClutter_1_1PathNode.html</anchorfile>
      <anchor>af229a30b19d448ce80745327b7a494d2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const ClutterPathNode *</type>
      <name>gobj</name>
      <anchorfile>classClutter_1_1PathNode.html</anchorfile>
      <anchor>a7c8c4ffcef5235f5a40008a3d7f3c842</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>PathNode</name>
      <anchorfile>classClutter_1_1PathNode.html</anchorfile>
      <anchor>a8ddd6802c48597615f34863c0eca17d8</anchor>
      <arglist>(PathNodeType type)</arglist>
    </member>
    <member kind="function">
      <type>size_type</type>
      <name>size</name>
      <anchorfile>classClutter_1_1PathNode.html</anchorfile>
      <anchor>acaf393f9aba80b010a76acbe65143ee9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>empty</name>
      <anchorfile>classClutter_1_1PathNode.html</anchorfile>
      <anchor>a84338da4a0322f7c9e5bda433c5af04b</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>iterator</type>
      <name>begin</name>
      <anchorfile>classClutter_1_1PathNode.html</anchorfile>
      <anchor>a69d6e61f78f7bffd92e6e213afe2623c</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>iterator</type>
      <name>end</name>
      <anchorfile>classClutter_1_1PathNode.html</anchorfile>
      <anchor>a9c0dbe478280101c5d31c81aa35f809c</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const_iterator</type>
      <name>begin</name>
      <anchorfile>classClutter_1_1PathNode.html</anchorfile>
      <anchor>a0ae5f8a83a7e6f223b88732c12b76d48</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const_iterator</type>
      <name>end</name>
      <anchorfile>classClutter_1_1PathNode.html</anchorfile>
      <anchor>abaa47815b46e05ad4b44767272f6a0b9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>reverse_iterator</type>
      <name>rbegin</name>
      <anchorfile>classClutter_1_1PathNode.html</anchorfile>
      <anchor>a27e7040161922cbd57a324fdf1d28bc0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>reverse_iterator</type>
      <name>rend</name>
      <anchorfile>classClutter_1_1PathNode.html</anchorfile>
      <anchor>a2feb8e1eaf6e9819fa9c6ca910342695</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const_reverse_iterator</type>
      <name>rbegin</name>
      <anchorfile>classClutter_1_1PathNode.html</anchorfile>
      <anchor>a689ca221053defe1262945199fe78fb3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const_reverse_iterator</type>
      <name>rend</name>
      <anchorfile>classClutter_1_1PathNode.html</anchorfile>
      <anchor>a3deff8afcf2268060bb98a50adb57925</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>reference</type>
      <name>front</name>
      <anchorfile>classClutter_1_1PathNode.html</anchorfile>
      <anchor>af9efdc4cc8a1e741a3e8caebf584ca07</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const_reference</type>
      <name>front</name>
      <anchorfile>classClutter_1_1PathNode.html</anchorfile>
      <anchor>abdc30e50f3e8b8162ac39f7779169c1f</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>reference</type>
      <name>back</name>
      <anchorfile>classClutter_1_1PathNode.html</anchorfile>
      <anchor>a83759a0ab668fd17cd6a9fc1eb60cb9c</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const_reference</type>
      <name>back</name>
      <anchorfile>classClutter_1_1PathNode.html</anchorfile>
      <anchor>a78333db10e1a09778b76b9f1524c7878</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>reference</type>
      <name>operator[]</name>
      <anchorfile>classClutter_1_1PathNode.html</anchorfile>
      <anchor>aa720dbc404a35f311c04ad77b8367ed5</anchor>
      <arglist>(size_type i)</arglist>
    </member>
    <member kind="function">
      <type>const_reference</type>
      <name>operator[]</name>
      <anchorfile>classClutter_1_1PathNode.html</anchorfile>
      <anchor>aab68fc62c9383168c4f75d457bf19ba3</anchor>
      <arglist>(size_type i) const </arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>ClutterPathNode</type>
      <name>gobject_</name>
      <anchorfile>classClutter_1_1PathNode.html</anchorfile>
      <anchor>a111510de7fd8080e6ee4fdf216267fca</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchorfile>classClutter_1_1PathNode.html</anchorfile>
      <anchor>afcacaeead9d37afbfb116261611eb020</anchor>
      <arglist>(const PathNode &amp;lhs, const PathNode &amp;rhs)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator!=</name>
      <anchorfile>classClutter_1_1PathNode.html</anchorfile>
      <anchor>a7a7f8abf34f680fa9896001368b9c969</anchor>
      <arglist>(const PathNode &amp;lhs, const PathNode &amp;rhs)</arglist>
    </member>
    <member kind="function">
      <type>Clutter::PathNode &amp;</type>
      <name>wrap</name>
      <anchorfile>classClutter_1_1PathNode.html</anchorfile>
      <anchor>a3eb4f6f5ad1bd8d3ab5a83e003cbf745</anchor>
      <arglist>(ClutterPathNode *object)</arglist>
    </member>
    <member kind="function">
      <type>const Clutter::PathNode &amp;</type>
      <name>wrap</name>
      <anchorfile>classClutter_1_1PathNode.html</anchorfile>
      <anchor>a4be8a509582ecf6587139f21bb689b9a</anchor>
      <arglist>(const ClutterPathNode *object)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Clutter::Path</name>
    <filename>classClutter_1_1Path.html</filename>
    <base>Glib::Object</base>
    <class kind="class">Clutter::Path::Nodes</class>
    <member kind="typedef">
      <type>void(*</type>
      <name>ClutterPathCallback</name>
      <anchorfile>classClutter_1_1Path.html</anchorfile>
      <anchor>a406c3b2ca32346c6b5c3979dbacce595</anchor>
      <arglist>)(const ClutterPathNode *node, gpointer data)</arglist>
    </member>
    <member kind="typedef">
      <type>sigc::slot&lt; void, PathNode &gt;</type>
      <name>ForEachSlot</name>
      <anchorfile>classClutter_1_1Path.html</anchorfile>
      <anchor>ad242b402acae3e67f2993fc5ae471b94</anchor>
      <arglist></arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~Path</name>
      <anchorfile>classClutter_1_1Path.html</anchorfile>
      <anchor>a2afd2320080ab20a694a851ca30eea5b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>ClutterPath *</type>
      <name>gobj</name>
      <anchorfile>classClutter_1_1Path.html</anchorfile>
      <anchor>af070cb5b5e007e2aa4ed697ab4f965fa</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const ClutterPath *</type>
      <name>gobj</name>
      <anchorfile>classClutter_1_1Path.html</anchorfile>
      <anchor>ab7dc7042718fe186a1e4257f7b290cc5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>ClutterPath *</type>
      <name>gobj_copy</name>
      <anchorfile>classClutter_1_1Path.html</anchorfile>
      <anchor>a1d1117829c10c9e48af18b6f75bfcc76</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Nodes</type>
      <name>nodes</name>
      <anchorfile>classClutter_1_1Path.html</anchorfile>
      <anchor>a2e1febad6b8cf31c195ab633a968e8c7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const Nodes</type>
      <name>nodes</name>
      <anchorfile>classClutter_1_1Path.html</anchorfile>
      <anchor>a9c5087d045843e1fa2e87e6f5466da2b</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>add_move_to</name>
      <anchorfile>classClutter_1_1Path.html</anchorfile>
      <anchor>a43134bcb4bb5259a9c628eb051f78fb9</anchor>
      <arglist>(int x, int y)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>add_rel_move_to</name>
      <anchorfile>classClutter_1_1Path.html</anchorfile>
      <anchor>ad85984ce53bf592fc34d7ac5bb3b147f</anchor>
      <arglist>(int x, int y)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>add_line_to</name>
      <anchorfile>classClutter_1_1Path.html</anchorfile>
      <anchor>a84bad5704677c3c27414eade81eaee2b</anchor>
      <arglist>(int x, int y)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>add_rel_line_to</name>
      <anchorfile>classClutter_1_1Path.html</anchorfile>
      <anchor>a67e5bf191dd69a2cc3b99c82c81fa72c</anchor>
      <arglist>(int x, int y)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>add_curve_to</name>
      <anchorfile>classClutter_1_1Path.html</anchorfile>
      <anchor>ac5af55e2c8c224418b0c7616f5535071</anchor>
      <arglist>(int x1, int y1, int x2, int y2, int x3, int y3)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>add_rel_curve_to</name>
      <anchorfile>classClutter_1_1Path.html</anchorfile>
      <anchor>a71318f6822bd23428a2063765012a2aa</anchor>
      <arglist>(int x1, int y1, int x2, int y2, int x3, int y3)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>add_close</name>
      <anchorfile>classClutter_1_1Path.html</anchorfile>
      <anchor>a806d4e88159555c1b8675f7357c16c12</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>add_string</name>
      <anchorfile>classClutter_1_1Path.html</anchorfile>
      <anchor>a94f5a85693c22e1dcb520a12560db7fb</anchor>
      <arglist>(const Glib::ustring &amp;str)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>foreach</name>
      <anchorfile>classClutter_1_1Path.html</anchorfile>
      <anchor>a94d19e8d669b9634969482cc81ea8249</anchor>
      <arglist>(const ForEachSlot &amp;slot)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_description</name>
      <anchorfile>classClutter_1_1Path.html</anchorfile>
      <anchor>a73fb5ff0abf318e413a40c796995c139</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_description</name>
      <anchorfile>classClutter_1_1Path.html</anchorfile>
      <anchor>a967d3f654471a5e3962147bcc02e953d</anchor>
      <arglist>(const Glib::ustring &amp;str)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>add_cairo_path</name>
      <anchorfile>classClutter_1_1Path.html</anchorfile>
      <anchor>a69a596de73e848bb67fccaab427d2327</anchor>
      <arglist>(const Glib::RefPtr&lt; Cairo::Path &gt; &amp;path)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>to_cairo_path</name>
      <anchorfile>classClutter_1_1Path.html</anchorfile>
      <anchor>aca2cda61ee1c5c97c6578543acae6688</anchor>
      <arglist>(Glib::RefPtr&lt; Cairo::Context &gt; &amp;context) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>clear</name>
      <anchorfile>classClutter_1_1Path.html</anchorfile>
      <anchor>a210633cf6047e4b60f22b76397a585aa</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>guint</type>
      <name>get_position</name>
      <anchorfile>classClutter_1_1Path.html</anchorfile>
      <anchor>aba6c85d1597dd075e92e4c79066cfdb2</anchor>
      <arglist>(double progress, Knot &amp;position)</arglist>
    </member>
    <member kind="function">
      <type>guint</type>
      <name>get_length</name>
      <anchorfile>classClutter_1_1Path.html</anchorfile>
      <anchor>ab0b0d6c0ae52da351140505f37806c37</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; Glib::ustring &gt;</type>
      <name>property_description</name>
      <anchorfile>classClutter_1_1Path.html</anchorfile>
      <anchor>adc6657568ae36dde9c56e71569b9d419</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; Glib::ustring &gt;</type>
      <name>property_description</name>
      <anchorfile>classClutter_1_1Path.html</anchorfile>
      <anchor>ad9ad6185f6dcafcbded39f923e86d339</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; guint &gt;</type>
      <name>property_length</name>
      <anchorfile>classClutter_1_1Path.html</anchorfile>
      <anchor>a363d27e156846244dbdeaa82e8e08718</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; Path &gt;</type>
      <name>create</name>
      <anchorfile>classClutter_1_1Path.html</anchorfile>
      <anchor>a90c075e833964412a5989b227e39cc27</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; Path &gt;</type>
      <name>create</name>
      <anchorfile>classClutter_1_1Path.html</anchorfile>
      <anchor>add3de8603975cdc780ed7015a3efebad</anchor>
      <arglist>(const Glib::ustring &amp;description)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>Path</name>
      <anchorfile>classClutter_1_1Path.html</anchorfile>
      <anchor>ad6f6701814b84f16773a44817104b1e8</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>Path</name>
      <anchorfile>classClutter_1_1Path.html</anchorfile>
      <anchor>a149116d9607d6b49bd63746be3b27c3f</anchor>
      <arglist>(const Glib::ustring &amp;description)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Clutter::Path &gt;</type>
      <name>wrap</name>
      <anchorfile>classClutter_1_1Path.html</anchorfile>
      <anchor>a24b0f4b8a547d8ff3adab431e71072a9</anchor>
      <arglist>(ClutterPath *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Clutter::Path::Nodes</name>
    <filename>classClutter_1_1Path_1_1Nodes.html</filename>
    <class kind="class">Clutter::Path::Nodes::const_iterator</class>
    <class kind="class">Clutter::Path::Nodes::iterator</class>
    <class kind="class">Clutter::Path::Nodes::reference</class>
    <member kind="typedef">
      <type>guint</type>
      <name>size_type</name>
      <anchorfile>classClutter_1_1Path_1_1Nodes.html</anchorfile>
      <anchor>ad9ad0270b28ed7ed61494800c246728f</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>int</type>
      <name>difference_type</name>
      <anchorfile>classClutter_1_1Path_1_1Nodes.html</anchorfile>
      <anchor>a91a6d0d006948d889929e0d8e3143c28</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>PathNode</type>
      <name>value_type</name>
      <anchorfile>classClutter_1_1Path_1_1Nodes.html</anchorfile>
      <anchor>a3b5990fab7c87f9fdce0bef5392a4ff5</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>const value_type</type>
      <name>const_reference</name>
      <anchorfile>classClutter_1_1Path_1_1Nodes.html</anchorfile>
      <anchor>a79ccdb4a61280cb1a80afc0ae3b71368</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>std::reverse_iterator&lt; iterator &gt;</type>
      <name>reverse_iterator</name>
      <anchorfile>classClutter_1_1Path_1_1Nodes.html</anchorfile>
      <anchor>a276237b39f0fa3b8648e28ab844d56ef</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>std::reverse_iterator&lt; const_iterator &gt;</type>
      <name>const_reverse_iterator</name>
      <anchorfile>classClutter_1_1Path_1_1Nodes.html</anchorfile>
      <anchor>acdcc1f9b7082ec0e00e3aa05253862b0</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>size_type</type>
      <name>size</name>
      <anchorfile>classClutter_1_1Path_1_1Nodes.html</anchorfile>
      <anchor>acca6b5d75c4d7ed8c343d0341b7e9cd4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>empty</name>
      <anchorfile>classClutter_1_1Path_1_1Nodes.html</anchorfile>
      <anchor>a2c02ce461f3588be5e61f2523215ade2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>iterator</type>
      <name>begin</name>
      <anchorfile>classClutter_1_1Path_1_1Nodes.html</anchorfile>
      <anchor>ae1beb7b5f0c40aad271578c64508b4f6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const_iterator</type>
      <name>begin</name>
      <anchorfile>classClutter_1_1Path_1_1Nodes.html</anchorfile>
      <anchor>ad5a1c0b92dce9b12508bf6da767369ff</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>iterator</type>
      <name>end</name>
      <anchorfile>classClutter_1_1Path_1_1Nodes.html</anchorfile>
      <anchor>a8af4d4963f5761b02f8a71579f454ba7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const_iterator</type>
      <name>end</name>
      <anchorfile>classClutter_1_1Path_1_1Nodes.html</anchorfile>
      <anchor>a9e3dc8ad92128a01b3ffb19b6e68c66f</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>reverse_iterator</type>
      <name>rbegin</name>
      <anchorfile>classClutter_1_1Path_1_1Nodes.html</anchorfile>
      <anchor>ade2b334eb0447e8ec0eb536f0d1f0815</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>reverse_iterator</type>
      <name>rend</name>
      <anchorfile>classClutter_1_1Path_1_1Nodes.html</anchorfile>
      <anchor>acb2f0a5b394c665f49f6be6ef106cfd5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const_reverse_iterator</type>
      <name>rbegin</name>
      <anchorfile>classClutter_1_1Path_1_1Nodes.html</anchorfile>
      <anchor>a9154de101efd884e3d61e32868821be3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const_reverse_iterator</type>
      <name>rend</name>
      <anchorfile>classClutter_1_1Path_1_1Nodes.html</anchorfile>
      <anchor>a5c84c87f46accc5cd30f1ecac161015b</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const_reference</type>
      <name>operator[]</name>
      <anchorfile>classClutter_1_1Path_1_1Nodes.html</anchorfile>
      <anchor>a6fcb641ddc9c4c014910881ed48bf5bb</anchor>
      <arglist>(size_type i) const </arglist>
    </member>
    <member kind="function">
      <type>reference</type>
      <name>operator[]</name>
      <anchorfile>classClutter_1_1Path_1_1Nodes.html</anchorfile>
      <anchor>a791dbc4025515d0b8f0e8b6cdd71cc00</anchor>
      <arglist>(size_type i)</arglist>
    </member>
    <member kind="function">
      <type>reference</type>
      <name>front</name>
      <anchorfile>classClutter_1_1Path_1_1Nodes.html</anchorfile>
      <anchor>ac61e7193d0c8de3120f6a356d533f71f</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const_reference</type>
      <name>front</name>
      <anchorfile>classClutter_1_1Path_1_1Nodes.html</anchorfile>
      <anchor>a92a371994df44fd7ae4c393267e89a09</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>reference</type>
      <name>back</name>
      <anchorfile>classClutter_1_1Path_1_1Nodes.html</anchorfile>
      <anchor>aef354288a030ba5bb39353e77dbc567b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const_reference</type>
      <name>back</name>
      <anchorfile>classClutter_1_1Path_1_1Nodes.html</anchorfile>
      <anchor>a41f49847a32c2f3072117baadc5470f0</anchor>
      <arglist>() const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Clutter::Path::Nodes::const_iterator</name>
    <filename>classClutter_1_1Path_1_1Nodes_1_1const__iterator.html</filename>
    <member kind="typedef">
      <type>std::random_access_iterator_tag</type>
      <name>iterator_category</name>
      <anchorfile>classClutter_1_1Path_1_1Nodes_1_1const__iterator.html</anchorfile>
      <anchor>a5702babf1053d581c80ca12057b4f5ec</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>PathNode</type>
      <name>value_type</name>
      <anchorfile>classClutter_1_1Path_1_1Nodes_1_1const__iterator.html</anchorfile>
      <anchor>a6fe887678f7c6fc731ca260b25b6a35a</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>int</type>
      <name>difference_type</name>
      <anchorfile>classClutter_1_1Path_1_1Nodes_1_1const__iterator.html</anchorfile>
      <anchor>a5cc56da6b60a8d1c332a86438f20ba92</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>const value_type</type>
      <name>reference</name>
      <anchorfile>classClutter_1_1Path_1_1Nodes_1_1const__iterator.html</anchorfile>
      <anchor>a0b4c60ea03080a35e09f3f4455f78df5</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>void</type>
      <name>pointer</name>
      <anchorfile>classClutter_1_1Path_1_1Nodes_1_1const__iterator.html</anchorfile>
      <anchor>af85029775045d51f3eb80455b687e4a0</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>const_iterator</name>
      <anchorfile>classClutter_1_1Path_1_1Nodes_1_1const__iterator.html</anchorfile>
      <anchor>aa673c85c27df29d5087108dec583c1dc</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>reference</type>
      <name>operator*</name>
      <anchorfile>classClutter_1_1Path_1_1Nodes_1_1const__iterator.html</anchorfile>
      <anchor>a263cf90260a4889680fbc38dac122a66</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>reference</type>
      <name>operator[]</name>
      <anchorfile>classClutter_1_1Path_1_1Nodes_1_1const__iterator.html</anchorfile>
      <anchor>a31a32453376f5dcc7b4cf2ce1779bdb0</anchor>
      <arglist>(difference_type i) const </arglist>
    </member>
    <member kind="function">
      <type>const_iterator &amp;</type>
      <name>operator++</name>
      <anchorfile>classClutter_1_1Path_1_1Nodes_1_1const__iterator.html</anchorfile>
      <anchor>a4b568b9113363a585e39b41c59ba5d7f</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const_iterator</type>
      <name>operator++</name>
      <anchorfile>classClutter_1_1Path_1_1Nodes_1_1const__iterator.html</anchorfile>
      <anchor>af72d44bb6d94679c154d34fc159bec8f</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="function">
      <type>const_iterator &amp;</type>
      <name>operator--</name>
      <anchorfile>classClutter_1_1Path_1_1Nodes_1_1const__iterator.html</anchorfile>
      <anchor>adfc0b9ddd32d38e68dacc5cff0bf6d55</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const_iterator</type>
      <name>operator--</name>
      <anchorfile>classClutter_1_1Path_1_1Nodes_1_1const__iterator.html</anchorfile>
      <anchor>aaa31cb16eff50161de91905a57a3f34f</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchorfile>classClutter_1_1Path_1_1Nodes_1_1const__iterator.html</anchorfile>
      <anchor>a24f0fe60d70cef8e4d34d7c938e8fb7b</anchor>
      <arglist>(const Path::Nodes::const_iterator &amp;a, const Path::Nodes::const_iterator &amp;b)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator!=</name>
      <anchorfile>classClutter_1_1Path_1_1Nodes_1_1const__iterator.html</anchorfile>
      <anchor>a5d33e27725048f1e11ccea4f0cd4e50f</anchor>
      <arglist>(const Path::Nodes::const_iterator &amp;a, const Path::Nodes::const_iterator &amp;b)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Clutter::Path::Nodes::iterator</name>
    <filename>classClutter_1_1Path_1_1Nodes_1_1iterator.html</filename>
    <base>Clutter::Path::Nodes::const_iterator</base>
    <member kind="typedef">
      <type>Path::Nodes::reference</type>
      <name>reference</name>
      <anchorfile>classClutter_1_1Path_1_1Nodes_1_1iterator.html</anchorfile>
      <anchor>a8e80f334b9b926e50d08064cfe0831c6</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>iterator</name>
      <anchorfile>classClutter_1_1Path_1_1Nodes_1_1iterator.html</anchorfile>
      <anchor>aa5233c821235ccc4e2bcab13890e1074</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>reference</type>
      <name>operator*</name>
      <anchorfile>classClutter_1_1Path_1_1Nodes_1_1iterator.html</anchorfile>
      <anchor>ae7fb712a2b1a8e699a7c8bb20a6f131f</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>reference</type>
      <name>operator[]</name>
      <anchorfile>classClutter_1_1Path_1_1Nodes_1_1iterator.html</anchorfile>
      <anchor>a23a281300c24329ae05cfb4801bb97f1</anchor>
      <arglist>(difference_type i) const </arglist>
    </member>
    <member kind="function">
      <type>iterator &amp;</type>
      <name>operator++</name>
      <anchorfile>classClutter_1_1Path_1_1Nodes_1_1iterator.html</anchorfile>
      <anchor>a35fcf3043aa2f2e5e733fe7b855938cb</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>iterator</type>
      <name>operator++</name>
      <anchorfile>classClutter_1_1Path_1_1Nodes_1_1iterator.html</anchorfile>
      <anchor>aff6ef1cd302284c031ca240307b205a6</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="function">
      <type>iterator &amp;</type>
      <name>operator--</name>
      <anchorfile>classClutter_1_1Path_1_1Nodes_1_1iterator.html</anchorfile>
      <anchor>af8bd38c1c39d0560827e63883436bb59</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>iterator</type>
      <name>operator--</name>
      <anchorfile>classClutter_1_1Path_1_1Nodes_1_1iterator.html</anchorfile>
      <anchor>acd3d166bc842d31f349957e9244bc2d4</anchor>
      <arglist>(int)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Clutter::Path::Nodes::reference</name>
    <filename>classClutter_1_1Path_1_1Nodes_1_1reference.html</filename>
    <member kind="function">
      <type>reference &amp;</type>
      <name>operator=</name>
      <anchorfile>classClutter_1_1Path_1_1Nodes_1_1reference.html</anchorfile>
      <anchor>a12613119a39bf2ff829c4e60dc3c05ae</anchor>
      <arglist>(const PathNode &amp;node)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>operator PathNode</name>
      <anchorfile>classClutter_1_1Path_1_1Nodes_1_1reference.html</anchorfile>
      <anchor>ae90e3a08180a50a927fb740e07c431ce</anchor>
      <arglist>() const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Clutter::Rectangle</name>
    <filename>classClutter_1_1Rectangle.html</filename>
    <base>Clutter::Actor</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~Rectangle</name>
      <anchorfile>classClutter_1_1Rectangle.html</anchorfile>
      <anchor>a16c4d16751cc8794ae359db6be8b3547</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>ClutterRectangle *</type>
      <name>gobj</name>
      <anchorfile>classClutter_1_1Rectangle.html</anchorfile>
      <anchor>aea397e7ed16df2694a92f1abd1210aad</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const ClutterRectangle *</type>
      <name>gobj</name>
      <anchorfile>classClutter_1_1Rectangle.html</anchorfile>
      <anchor>a8d93ccc1af9fa3404186053685a723a4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>ClutterRectangle *</type>
      <name>gobj_copy</name>
      <anchorfile>classClutter_1_1Rectangle.html</anchorfile>
      <anchor>a553bd7af629ea90c7e5af31e486669b2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Color</type>
      <name>get_color</name>
      <anchorfile>classClutter_1_1Rectangle.html</anchorfile>
      <anchor>ab53e71e27197765cafc319ac7db99d1a</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_color</name>
      <anchorfile>classClutter_1_1Rectangle.html</anchorfile>
      <anchor>a0e2b27cb25a58c25da7d8ce42ee574dd</anchor>
      <arglist>(const Color &amp;color)</arglist>
    </member>
    <member kind="function">
      <type>Color</type>
      <name>get_border_color</name>
      <anchorfile>classClutter_1_1Rectangle.html</anchorfile>
      <anchor>a245f3bd7bd879a86bf885eb156bcf63e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_border_color</name>
      <anchorfile>classClutter_1_1Rectangle.html</anchorfile>
      <anchor>a20c483aa9a2ee2b01822ffd74c787eb8</anchor>
      <arglist>(const Color &amp;color)</arglist>
    </member>
    <member kind="function">
      <type>guint</type>
      <name>get_border_width</name>
      <anchorfile>classClutter_1_1Rectangle.html</anchorfile>
      <anchor>a31b63e57f7fcccbcc6724cf50ba0f80f</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_border_width</name>
      <anchorfile>classClutter_1_1Rectangle.html</anchorfile>
      <anchor>a1a29581bdcc8be334b04d2b9814a170a</anchor>
      <arglist>(guint width)</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; Color &gt;</type>
      <name>property_border_color</name>
      <anchorfile>classClutter_1_1Rectangle.html</anchorfile>
      <anchor>aac1d38b8c2b38cc9739b0acd17aeffbc</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; Color &gt;</type>
      <name>property_border_color</name>
      <anchorfile>classClutter_1_1Rectangle.html</anchorfile>
      <anchor>ac5cf57ff24cc0c7a00e9e07ce7602336</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; guint &gt;</type>
      <name>property_border_width</name>
      <anchorfile>classClutter_1_1Rectangle.html</anchorfile>
      <anchor>a648de41e6d0f2d58c2fe28b569067973</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; guint &gt;</type>
      <name>property_border_width</name>
      <anchorfile>classClutter_1_1Rectangle.html</anchorfile>
      <anchor>a4dc5f2d6696378d431ae11891324bbec</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; Color &gt;</type>
      <name>property_color</name>
      <anchorfile>classClutter_1_1Rectangle.html</anchorfile>
      <anchor>a9ad1c488ccaace02f91f02e6058fecda</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; Color &gt;</type>
      <name>property_color</name>
      <anchorfile>classClutter_1_1Rectangle.html</anchorfile>
      <anchor>ab90f46165a46cb1e3ddb37aee40c8412</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; bool &gt;</type>
      <name>property_has_border</name>
      <anchorfile>classClutter_1_1Rectangle.html</anchorfile>
      <anchor>aef92ac452e119781ea9b1f0929ef3385</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; bool &gt;</type>
      <name>property_has_border</name>
      <anchorfile>classClutter_1_1Rectangle.html</anchorfile>
      <anchor>a86b3ce7d01ee84274c10deaf8376f0a9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; Rectangle &gt;</type>
      <name>create</name>
      <anchorfile>classClutter_1_1Rectangle.html</anchorfile>
      <anchor>a8aef7ccbc6927a9940d3e2613bff48fd</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; Rectangle &gt;</type>
      <name>create</name>
      <anchorfile>classClutter_1_1Rectangle.html</anchorfile>
      <anchor>ae786605d7d2311dc8bc359208cbff0ef</anchor>
      <arglist>(const Color &amp;color)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>Rectangle</name>
      <anchorfile>classClutter_1_1Rectangle.html</anchorfile>
      <anchor>a1ab1309fb49d467346640e532e36f924</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>Rectangle</name>
      <anchorfile>classClutter_1_1Rectangle.html</anchorfile>
      <anchor>a8a7ae7694862fcd9061f0bcc04b408e0</anchor>
      <arglist>(const Color &amp;color)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Clutter::Rectangle &gt;</type>
      <name>wrap</name>
      <anchorfile>classClutter_1_1Rectangle.html</anchorfile>
      <anchor>accdae709b99dc756901afa7fbaa3aae5</anchor>
      <arglist>(ClutterRectangle *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Clutter::Score</name>
    <filename>classClutter_1_1Score.html</filename>
    <base>Glib::Object</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~Score</name>
      <anchorfile>classClutter_1_1Score.html</anchorfile>
      <anchor>aad82d2b47e136551e2080b493caa622f</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>ClutterScore *</type>
      <name>gobj</name>
      <anchorfile>classClutter_1_1Score.html</anchorfile>
      <anchor>a621866a1c933801a7103b44c76202b2f</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const ClutterScore *</type>
      <name>gobj</name>
      <anchorfile>classClutter_1_1Score.html</anchorfile>
      <anchor>abacd947415a765b370500a874868c0fb</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>ClutterScore *</type>
      <name>gobj_copy</name>
      <anchorfile>classClutter_1_1Score.html</anchorfile>
      <anchor>ae8450f34efd06301eee4017f9e6e1d2e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_loop</name>
      <anchorfile>classClutter_1_1Score.html</anchorfile>
      <anchor>aa11b68de71b658943208de7b811cf1a8</anchor>
      <arglist>(bool loop=true)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_loop</name>
      <anchorfile>classClutter_1_1Score.html</anchorfile>
      <anchor>a17bb59603a6b33d1afce018b42e37002</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>gulong</type>
      <name>append</name>
      <anchorfile>classClutter_1_1Score.html</anchorfile>
      <anchor>aa7485c3e7264025a3edf4a29c44a98c2</anchor>
      <arglist>(const Glib::RefPtr&lt; Timeline &gt; &amp;parent, const Glib::RefPtr&lt; Timeline &gt; &amp;timeline)</arglist>
    </member>
    <member kind="function">
      <type>gulong</type>
      <name>append</name>
      <anchorfile>classClutter_1_1Score.html</anchorfile>
      <anchor>a3526bba56a09a53ff6cd382ab16c6f70</anchor>
      <arglist>(const Glib::RefPtr&lt; Timeline &gt; &amp;timeline)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>append_at_marker</name>
      <anchorfile>classClutter_1_1Score.html</anchorfile>
      <anchor>a9c8ebeab0dbc15b92ce7a3c80a196fb1</anchor>
      <arglist>(const Glib::RefPtr&lt; Timeline &gt; &amp;parent, const Glib::ustring &amp;marker_name, const Glib::RefPtr&lt; Timeline &gt; &amp;timeline)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>remove</name>
      <anchorfile>classClutter_1_1Score.html</anchorfile>
      <anchor>a5f2c2bd8b784628b30ea94bb00d5368b</anchor>
      <arglist>(gulong id)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>remove_all</name>
      <anchorfile>classClutter_1_1Score.html</anchorfile>
      <anchor>a1411b17cc00d3229df457359082f4410</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Timeline &gt;</type>
      <name>get_timeline</name>
      <anchorfile>classClutter_1_1Score.html</anchorfile>
      <anchor>ab539c359ee89bb92178a28a28a131681</anchor>
      <arglist>(gulong id)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const Timeline &gt;</type>
      <name>get_timeline</name>
      <anchorfile>classClutter_1_1Score.html</anchorfile>
      <anchor>a49ade5abfb2761cd1429f79e2a0f3bd1</anchor>
      <arglist>(gulong id) const </arglist>
    </member>
    <member kind="function">
      <type>std::vector&lt; Glib::RefPtr&lt; Timeline &gt; &gt;</type>
      <name>list_timelines</name>
      <anchorfile>classClutter_1_1Score.html</anchorfile>
      <anchor>a2b0bfdef7e02fa454dac1851f614fdd7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>std::vector&lt; Glib::RefPtr&lt; const Timeline &gt; &gt;</type>
      <name>list_timelines</name>
      <anchorfile>classClutter_1_1Score.html</anchorfile>
      <anchor>a825e1d7ef031368f181efda329629e73</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>start</name>
      <anchorfile>classClutter_1_1Score.html</anchorfile>
      <anchor>a4b7d44952642ec6c7cd922638f0cbe48</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>pause</name>
      <anchorfile>classClutter_1_1Score.html</anchorfile>
      <anchor>ac58aa773beb1fdc6c048082fe995b222</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>stop</name>
      <anchorfile>classClutter_1_1Score.html</anchorfile>
      <anchor>aa0d90c02b23d37b98a99b060229cb11b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>rewind</name>
      <anchorfile>classClutter_1_1Score.html</anchorfile>
      <anchor>ad02f76db9a62cc1efe1930e5de89972b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_playing</name>
      <anchorfile>classClutter_1_1Score.html</anchorfile>
      <anchor>a018b8e2f6640ef24c4d0b325bb8f9295</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; bool &gt;</type>
      <name>property_loop</name>
      <anchorfile>classClutter_1_1Score.html</anchorfile>
      <anchor>a9c409cee784e4ebc8e87a6dd8e8cc5a8</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; bool &gt;</type>
      <name>property_loop</name>
      <anchorfile>classClutter_1_1Score.html</anchorfile>
      <anchor>a25f2c783e5acc3c2f421eec40fa06fa3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy0&lt; void &gt;</type>
      <name>signal_completed</name>
      <anchorfile>classClutter_1_1Score.html</anchorfile>
      <anchor>af3e019a8ac76699d4315a05e67e8bf0f</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy0&lt; void &gt;</type>
      <name>signal_paused</name>
      <anchorfile>classClutter_1_1Score.html</anchorfile>
      <anchor>a6d171ed8db2673e0180d9c481d553f6c</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy0&lt; void &gt;</type>
      <name>signal_started</name>
      <anchorfile>classClutter_1_1Score.html</anchorfile>
      <anchor>a686dba666e105ca0d9eb4e7d323deda1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy1&lt; void, const Glib::RefPtr&lt; Timeline &gt; &amp; &gt;</type>
      <name>signal_timeline_completed</name>
      <anchorfile>classClutter_1_1Score.html</anchorfile>
      <anchor>acba535903b99e89f39df8f5379dc71dc</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy1&lt; void, const Glib::RefPtr&lt; Timeline &gt; &amp; &gt;</type>
      <name>signal_timeline_started</name>
      <anchorfile>classClutter_1_1Score.html</anchorfile>
      <anchor>a3cedc69b83d1924893b20df75fdd7756</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; Score &gt;</type>
      <name>create</name>
      <anchorfile>classClutter_1_1Score.html</anchorfile>
      <anchor>a20e1b87597dcfb848136a1c9d0e4b1fe</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>Score</name>
      <anchorfile>classClutter_1_1Score.html</anchorfile>
      <anchor>a9beee0af68cc9947accfa7c9f2d3d9e5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>on_completed</name>
      <anchorfile>classClutter_1_1Score.html</anchorfile>
      <anchor>a335ba42f3c6d7e40eaa6788d13264d6d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>on_paused</name>
      <anchorfile>classClutter_1_1Score.html</anchorfile>
      <anchor>a9919ceb87028f5556bf1b5c6379aa4f7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>on_started</name>
      <anchorfile>classClutter_1_1Score.html</anchorfile>
      <anchor>a9877d197ae14772297d5b66913f587dc</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>on_timeline_completed</name>
      <anchorfile>classClutter_1_1Score.html</anchorfile>
      <anchor>aa341ef06c924b346582e3cb13f706255</anchor>
      <arglist>(const Glib::RefPtr&lt; Timeline &gt; &amp;timeline)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>on_timeline_started</name>
      <anchorfile>classClutter_1_1Score.html</anchorfile>
      <anchor>a11d22e52833ffad4aaf44a27d6a30c62</anchor>
      <arglist>(const Glib::RefPtr&lt; Timeline &gt; &amp;timeline)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Clutter::Score &gt;</type>
      <name>wrap</name>
      <anchorfile>classClutter_1_1Score.html</anchorfile>
      <anchor>a3fcbcf47e4030379bac58eb0b0b8a9e6</anchor>
      <arglist>(ClutterScore *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Clutter::Script</name>
    <filename>classClutter_1_1Script.html</filename>
    <base>Glib::Object</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~Script</name>
      <anchorfile>classClutter_1_1Script.html</anchorfile>
      <anchor>a359bf274fc9a85ba0adfa11d7e4b2850</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>ClutterScript *</type>
      <name>gobj</name>
      <anchorfile>classClutter_1_1Script.html</anchorfile>
      <anchor>aa6f346dd62127555eafbf851b9a03279</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const ClutterScript *</type>
      <name>gobj</name>
      <anchorfile>classClutter_1_1Script.html</anchorfile>
      <anchor>a874b20f57e9bc0791f643759c152947c</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>ClutterScript *</type>
      <name>gobj_copy</name>
      <anchorfile>classClutter_1_1Script.html</anchorfile>
      <anchor>a1c8a72ffdae6ae726ae315bc3b1b519f</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>guint</type>
      <name>load_from_data</name>
      <anchorfile>classClutter_1_1Script.html</anchorfile>
      <anchor>ac440de140c2246f39453842e1cbcae99</anchor>
      <arglist>(const Glib::ustring &amp;data)</arglist>
    </member>
    <member kind="function">
      <type>guint</type>
      <name>load_from_file</name>
      <anchorfile>classClutter_1_1Script.html</anchorfile>
      <anchor>ab3dd2a40514428aa6c08efe19b133df0</anchor>
      <arglist>(const std::string &amp;filename)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>add_search_paths</name>
      <anchorfile>classClutter_1_1Script.html</anchorfile>
      <anchor>a202eb82c2ef0bda0d20d5e18ca889a67</anchor>
      <arglist>(const std::vector&lt; Glib::ustring &gt; &amp;paths)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>lookup_filename</name>
      <anchorfile>classClutter_1_1Script.html</anchorfile>
      <anchor>a878dc5be17f18f3abef8b720684b4576</anchor>
      <arglist>(const Glib::ustring &amp;filename)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Glib::Object &gt;</type>
      <name>get_object</name>
      <anchorfile>classClutter_1_1Script.html</anchorfile>
      <anchor>a5fd4f0898c7037b09adac3497ca16c35</anchor>
      <arglist>(const Glib::ustring &amp;name)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const Glib::Object &gt;</type>
      <name>get_object</name>
      <anchorfile>classClutter_1_1Script.html</anchorfile>
      <anchor>af24e1b89efe57fc2b701297684436a17</anchor>
      <arglist>(const Glib::ustring &amp;name) const </arglist>
    </member>
    <member kind="function">
      <type>std::vector&lt; Glib::RefPtr&lt; Glib::Object &gt; &gt;</type>
      <name>list_objects</name>
      <anchorfile>classClutter_1_1Script.html</anchorfile>
      <anchor>acf8c0fd201b8dad666d609daa37af11b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>std::vector&lt; Glib::RefPtr&lt; const Glib::Object &gt; &gt;</type>
      <name>list_objects</name>
      <anchorfile>classClutter_1_1Script.html</anchorfile>
      <anchor>a3352e972dfbfeef5e3310bccd8ef07e1</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>unmerge_object</name>
      <anchorfile>classClutter_1_1Script.html</anchorfile>
      <anchor>a3d6063a29bf5bee669ab875f219a313a</anchor>
      <arglist>(guint merge_id)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>ensure_objects</name>
      <anchorfile>classClutter_1_1Script.html</anchorfile>
      <anchor>a613e43e88d5e8f37162584a1a8a91486</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; std::string &gt;</type>
      <name>property_filename</name>
      <anchorfile>classClutter_1_1Script.html</anchorfile>
      <anchor>a6c0d3aa1b21454b03ffa3a8002d68760</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; bool &gt;</type>
      <name>property_filename_set</name>
      <anchorfile>classClutter_1_1Script.html</anchorfile>
      <anchor>ab1f810034ff3c62ee6a02d10eb1c03db</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; Script &gt;</type>
      <name>create</name>
      <anchorfile>classClutter_1_1Script.html</anchorfile>
      <anchor>a68d6cb0c6ae750376a9ebb53885daafd</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static std::string</type>
      <name>get_script_id</name>
      <anchorfile>classClutter_1_1Script.html</anchorfile>
      <anchor>a66868cc2cbf8624fe77675f1b613825c</anchor>
      <arglist>(const Glib::RefPtr&lt; const Glib::Object &gt; &amp;object)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>Script</name>
      <anchorfile>classClutter_1_1Script.html</anchorfile>
      <anchor>a8699acfc54851e8e96898e15f67f11fc</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual GType</type>
      <name>get_type_from_name_vfunc</name>
      <anchorfile>classClutter_1_1Script.html</anchorfile>
      <anchor>abebf6fe7916b10a25d9a55836176310e</anchor>
      <arglist>(const Glib::ustring &amp;type_name)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Clutter::Script &gt;</type>
      <name>wrap</name>
      <anchorfile>classClutter_1_1Script.html</anchorfile>
      <anchor>a667bbbabcb414335bb9c37a917b3850e</anchor>
      <arglist>(ClutterScript *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Clutter::Scriptable</name>
    <filename>classClutter_1_1Scriptable.html</filename>
    <base>Glib::Interface</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~Scriptable</name>
      <anchorfile>classClutter_1_1Scriptable.html</anchorfile>
      <anchor>af6676d678fc4e2e9501a28019f6e9f77</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>ClutterScriptable *</type>
      <name>gobj</name>
      <anchorfile>classClutter_1_1Scriptable.html</anchorfile>
      <anchor>ae31c05350401bc10fa9298dcfc63c779</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const ClutterScriptable *</type>
      <name>gobj</name>
      <anchorfile>classClutter_1_1Scriptable.html</anchorfile>
      <anchor>afde72534c8ff1ecb3bade69cda2b5bcd</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_id</name>
      <anchorfile>classClutter_1_1Scriptable.html</anchorfile>
      <anchor>ab6be5218f658d7fdb1cbc11245fee3d0</anchor>
      <arglist>(const std::string &amp;id)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_id</name>
      <anchorfile>classClutter_1_1Scriptable.html</anchorfile>
      <anchor>af3a217fd76773a16363a9d8657209df2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>parse_custom_node</name>
      <anchorfile>classClutter_1_1Scriptable.html</anchorfile>
      <anchor>ab12421fe724dad87f55cd7399ca1713d</anchor>
      <arglist>(const Glib::RefPtr&lt; Script &gt; &amp;script, Glib::ValueBase &amp;value, const Glib::ustring &amp;name, JsonNode *node)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_custom_property</name>
      <anchorfile>classClutter_1_1Scriptable.html</anchorfile>
      <anchor>a593152da4270b7160bc90d2a6bf2c022</anchor>
      <arglist>(const Glib::RefPtr&lt; Script &gt; &amp;script, const Glib::ustring &amp;name, const Glib::ValueBase &amp;value)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>add_interface</name>
      <anchorfile>classClutter_1_1Scriptable.html</anchorfile>
      <anchor>a1f52052a166628337531f47df582094b</anchor>
      <arglist>(GType gtype_implementer)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>set_id_vfunc</name>
      <anchorfile>classClutter_1_1Scriptable.html</anchorfile>
      <anchor>a134815190d1da5f1e189a6b9923a81c3</anchor>
      <arglist>(const std::string &amp;id)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual const char *</type>
      <name>get_id_vfunc</name>
      <anchorfile>classClutter_1_1Scriptable.html</anchorfile>
      <anchor>a77a8e1e3ba80280d4d4786290bff44a1</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>set_custom_property_vfunc</name>
      <anchorfile>classClutter_1_1Scriptable.html</anchorfile>
      <anchor>a10047cc9b006b78b8e5b5fa5aa2e74ab</anchor>
      <arglist>(const Glib::RefPtr&lt; Script &gt; &amp;script, const Glib::ustring &amp;name, const Glib::ValueBase &amp;value)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Clutter::Scriptable &gt;</type>
      <name>wrap</name>
      <anchorfile>classClutter_1_1Scriptable.html</anchorfile>
      <anchor>a813afae2f60173cc51d6e3251cfa71da</anchor>
      <arglist>(ClutterScriptable *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Clutter::Shader</name>
    <filename>classClutter_1_1Shader.html</filename>
    <base>Glib::Object</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~Shader</name>
      <anchorfile>classClutter_1_1Shader.html</anchorfile>
      <anchor>ac6774b0a0809a8f9005a0ec5cea1570d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>ClutterShader *</type>
      <name>gobj</name>
      <anchorfile>classClutter_1_1Shader.html</anchorfile>
      <anchor>a096f2fedffb839e730ae6d2f6a3ed196</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const ClutterShader *</type>
      <name>gobj</name>
      <anchorfile>classClutter_1_1Shader.html</anchorfile>
      <anchor>a51a35457d5d4c8579800b9ca2df9b864</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>ClutterShader *</type>
      <name>gobj_copy</name>
      <anchorfile>classClutter_1_1Shader.html</anchorfile>
      <anchor>aabc3120418965096ea4e92a1a7eb3116</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_vertex_source</name>
      <anchorfile>classClutter_1_1Shader.html</anchorfile>
      <anchor>a958942902fef90a055eb010597dc1074</anchor>
      <arglist>(const std::string &amp;source_code)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_vertex_source</name>
      <anchorfile>classClutter_1_1Shader.html</anchorfile>
      <anchor>ab911d5fd93ae75e14b7418faa8e8ee1e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_fragment_source</name>
      <anchorfile>classClutter_1_1Shader.html</anchorfile>
      <anchor>a94ef51965663ac637473fd70f62abc75</anchor>
      <arglist>(const std::string &amp;source_code)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_fragment_source</name>
      <anchorfile>classClutter_1_1Shader.html</anchorfile>
      <anchor>afb9c7644784c979215dd4620bec6d24d</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>compile</name>
      <anchorfile>classClutter_1_1Shader.html</anchorfile>
      <anchor>a33faa3fd958585681b044104792d1588</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_compiled</name>
      <anchorfile>classClutter_1_1Shader.html</anchorfile>
      <anchor>ad2b5e6aa3b08512ef3efd3aa20bc8991</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>release</name>
      <anchorfile>classClutter_1_1Shader.html</anchorfile>
      <anchor>ab55cc9734da2f33bef9378ab501da969</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_is_enabled</name>
      <anchorfile>classClutter_1_1Shader.html</anchorfile>
      <anchor>af2838e63008ecf0ed9d51a701e25731c</anchor>
      <arglist>(bool enabled=true)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_is_enabled</name>
      <anchorfile>classClutter_1_1Shader.html</anchorfile>
      <anchor>ab475aa14e04ca0fb19096467752f7e85</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_uniform</name>
      <anchorfile>classClutter_1_1Shader.html</anchorfile>
      <anchor>a8832f07e7d39adf54dcdc2668c600d76</anchor>
      <arglist>(const Glib::ustring &amp;name, const Glib::ValueBase &amp;value)</arglist>
    </member>
    <member kind="function">
      <type>CoglHandle</type>
      <name>get_cogl_program</name>
      <anchorfile>classClutter_1_1Shader.html</anchorfile>
      <anchor>ad51609d0f55124f8d610acd4eb5f0e88</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>CoglHandle</type>
      <name>get_cogl_vertex_shader</name>
      <anchorfile>classClutter_1_1Shader.html</anchorfile>
      <anchor>a8bc601e6ca8fcdee753f9c09fb9a4365</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>CoglHandle</type>
      <name>get_cogl_fragment_shader</name>
      <anchorfile>classClutter_1_1Shader.html</anchorfile>
      <anchor>a860778084978c9fe2e73f50637811bf9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; bool &gt;</type>
      <name>property_compiled</name>
      <anchorfile>classClutter_1_1Shader.html</anchorfile>
      <anchor>a1464e6631289828ef958657f69997f90</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; bool &gt;</type>
      <name>property_enabled</name>
      <anchorfile>classClutter_1_1Shader.html</anchorfile>
      <anchor>a52bd3a33933ab799db25ff11a0d4f879</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; bool &gt;</type>
      <name>property_enabled</name>
      <anchorfile>classClutter_1_1Shader.html</anchorfile>
      <anchor>ab0c617b8f8be8970472b13bda6c01943</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; std::string &gt;</type>
      <name>property_fragment_source</name>
      <anchorfile>classClutter_1_1Shader.html</anchorfile>
      <anchor>aa36b7bf6b8b13c40dfa39564d582a5a7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; std::string &gt;</type>
      <name>property_fragment_source</name>
      <anchorfile>classClutter_1_1Shader.html</anchorfile>
      <anchor>a36a150dd4e07b2c0d4cd351dde9024e6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; std::string &gt;</type>
      <name>property_vertex_source</name>
      <anchorfile>classClutter_1_1Shader.html</anchorfile>
      <anchor>ada2477ec9c187dae6d1f31a844a60e7e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; std::string &gt;</type>
      <name>property_vertex_source</name>
      <anchorfile>classClutter_1_1Shader.html</anchorfile>
      <anchor>a0adbd9f2605e4d6579fe9c6d842874e4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; Shader &gt;</type>
      <name>create</name>
      <anchorfile>classClutter_1_1Shader.html</anchorfile>
      <anchor>a12145a69e4120f5bb5921623eb1065b1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>Shader</name>
      <anchorfile>classClutter_1_1Shader.html</anchorfile>
      <anchor>a3160629f70e7df24dc9153f326ab3d0b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Clutter::Shader &gt;</type>
      <name>wrap</name>
      <anchorfile>classClutter_1_1Shader.html</anchorfile>
      <anchor>a311a5590e34cff3daf0b3e2fa8a3b260</anchor>
      <arglist>(ClutterShader *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Clutter::Perspective</name>
    <filename>classClutter_1_1Perspective.html</filename>
    <member kind="function">
      <type></type>
      <name>Perspective</name>
      <anchorfile>classClutter_1_1Perspective.html</anchorfile>
      <anchor>ac71c51e1fd77df633d2648411b42866c</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Perspective</name>
      <anchorfile>classClutter_1_1Perspective.html</anchorfile>
      <anchor>a17853139f9078bedc4bf24c7a5a4139e</anchor>
      <arglist>(const ClutterPerspective *gobject)</arglist>
    </member>
    <member kind="function">
      <type>ClutterPerspective *</type>
      <name>gobj</name>
      <anchorfile>classClutter_1_1Perspective.html</anchorfile>
      <anchor>a07f7cfad0afc4cb6766afcdf83a87a5c</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const ClutterPerspective *</type>
      <name>gobj</name>
      <anchorfile>classClutter_1_1Perspective.html</anchorfile>
      <anchor>a9e2382e17f68960f850f99a8bf203d2b</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Perspective</name>
      <anchorfile>classClutter_1_1Perspective.html</anchorfile>
      <anchor>a5c0191247b95bc573fd57d34331fcb15</anchor>
      <arglist>(Cogl::Fixed fovy, Cogl::Fixed aspect, Cogl::Fixed z_near, Cogl::Fixed z_far)</arglist>
    </member>
    <member kind="function">
      <type>Cogl::Fixed</type>
      <name>get_fovy</name>
      <anchorfile>classClutter_1_1Perspective.html</anchorfile>
      <anchor>a50922a892ff08c4ed6c7d886ee63f4a4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_fovy</name>
      <anchorfile>classClutter_1_1Perspective.html</anchorfile>
      <anchor>a21fd700677aaa664a884ed078c5e179e</anchor>
      <arglist>(const Cogl::Fixed &amp;value)</arglist>
    </member>
    <member kind="function">
      <type>Cogl::Fixed</type>
      <name>get_aspect</name>
      <anchorfile>classClutter_1_1Perspective.html</anchorfile>
      <anchor>add0d56188a6af375b367298cf4b3695f</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_aspect</name>
      <anchorfile>classClutter_1_1Perspective.html</anchorfile>
      <anchor>a944d714c2415b273b7c53438bf3f9787</anchor>
      <arglist>(const Cogl::Fixed &amp;value)</arglist>
    </member>
    <member kind="function">
      <type>Cogl::Fixed</type>
      <name>get_z_near</name>
      <anchorfile>classClutter_1_1Perspective.html</anchorfile>
      <anchor>a891e4fe3826a6cf8aa61723d1bf7ad1c</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_z_near</name>
      <anchorfile>classClutter_1_1Perspective.html</anchorfile>
      <anchor>a716fb4acece31992f61b8858d846d435</anchor>
      <arglist>(const Cogl::Fixed &amp;value)</arglist>
    </member>
    <member kind="function">
      <type>Cogl::Fixed</type>
      <name>get_z_far</name>
      <anchorfile>classClutter_1_1Perspective.html</anchorfile>
      <anchor>a31a719853de6ef9a742cfaf2fde794a3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_z_far</name>
      <anchorfile>classClutter_1_1Perspective.html</anchorfile>
      <anchor>a5366f8730a08b3d214608ad83ca1af26</anchor>
      <arglist>(const Cogl::Fixed &amp;value)</arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>ClutterPerspective</type>
      <name>gobject_</name>
      <anchorfile>classClutter_1_1Perspective.html</anchorfile>
      <anchor>afc233969e6e90babed20d29a7c4cc1eb</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>Clutter::Perspective &amp;</type>
      <name>wrap</name>
      <anchorfile>classClutter_1_1Perspective.html</anchorfile>
      <anchor>aca67951adbe26364052b7e7a3d91a27c</anchor>
      <arglist>(ClutterPerspective *object)</arglist>
    </member>
    <member kind="function">
      <type>const Clutter::Perspective &amp;</type>
      <name>wrap</name>
      <anchorfile>classClutter_1_1Perspective.html</anchorfile>
      <anchor>ad0f67b3a3aae26a0ca92cd797efbd28e</anchor>
      <arglist>(const ClutterPerspective *object)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Clutter::Stage</name>
    <filename>classClutter_1_1Stage.html</filename>
    <base>Clutter::Group</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~Stage</name>
      <anchorfile>classClutter_1_1Stage.html</anchorfile>
      <anchor>ab1fc59507a1b8c9ae49d7aa17b7c876e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>ClutterStage *</type>
      <name>gobj</name>
      <anchorfile>classClutter_1_1Stage.html</anchorfile>
      <anchor>a662722377814f94574ec5018d73a24ec</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const ClutterStage *</type>
      <name>gobj</name>
      <anchorfile>classClutter_1_1Stage.html</anchorfile>
      <anchor>ae923fd2da5d97d9fa7044bfbba789d0d</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>ClutterStage *</type>
      <name>gobj_copy</name>
      <anchorfile>classClutter_1_1Stage.html</anchorfile>
      <anchor>a649399fdfb295c2dddfee3ea3c2cc608</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_color</name>
      <anchorfile>classClutter_1_1Stage.html</anchorfile>
      <anchor>ad1ba05245c33fefec51ca2a22f762cd7</anchor>
      <arglist>(const Color &amp;color)</arglist>
    </member>
    <member kind="function">
      <type>Color</type>
      <name>get_color</name>
      <anchorfile>classClutter_1_1Stage.html</anchorfile>
      <anchor>ab7e5bc8946aac3d6ed9343d461765d8d</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_perspective</name>
      <anchorfile>classClutter_1_1Stage.html</anchorfile>
      <anchor>ada0641914a55b9cae6bdeba5b0231a42</anchor>
      <arglist>(const Perspective &amp;prespective)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>get_perspective</name>
      <anchorfile>classClutter_1_1Stage.html</anchorfile>
      <anchor>a62cc08cc65627471fa1d37b390a0208e</anchor>
      <arglist>(Perspective &amp;prespective)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_fullscreen</name>
      <anchorfile>classClutter_1_1Stage.html</anchorfile>
      <anchor>a032c54efdbc38f8dd3d6bd1ec71568a8</anchor>
      <arglist>(bool fullscreen=true)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_fullscreen</name>
      <anchorfile>classClutter_1_1Stage.html</anchorfile>
      <anchor>a483cf814b482cfd8eb32ec6c80fcdf16</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>show_cursor</name>
      <anchorfile>classClutter_1_1Stage.html</anchorfile>
      <anchor>a1e72fe801405c5fe63ce4f614c1d3350</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>hide_cursor</name>
      <anchorfile>classClutter_1_1Stage.html</anchorfile>
      <anchor>aed6c29e654bccb310e63cf7a87c0c3ae</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_title</name>
      <anchorfile>classClutter_1_1Stage.html</anchorfile>
      <anchor>add3eeba447c7e700ba8cf2212b91c4d6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_title</name>
      <anchorfile>classClutter_1_1Stage.html</anchorfile>
      <anchor>ab63b1234d956c06846ff21c001019494</anchor>
      <arglist>(const Glib::ustring &amp;title)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_user_resizable</name>
      <anchorfile>classClutter_1_1Stage.html</anchorfile>
      <anchor>adc89810f6b3102c6f02b0694e990073b</anchor>
      <arglist>(bool value)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_user_resizable</name>
      <anchorfile>classClutter_1_1Stage.html</anchorfile>
      <anchor>aec1b4c1162d3fc278b81098f5d524cb3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Actor &gt;</type>
      <name>get_actor_at_pos</name>
      <anchorfile>classClutter_1_1Stage.html</anchorfile>
      <anchor>a54531aa5783d23e78cbb4d52743482b7</anchor>
      <arglist>(PickMode pick_mode, int x, int y)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const Actor &gt;</type>
      <name>get_actor_at_pos</name>
      <anchorfile>classClutter_1_1Stage.html</anchorfile>
      <anchor>aeb7c46f52cf31593edfe5ab4175537d5</anchor>
      <arglist>(PickMode pick_mode, int x, int y) const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Actor &gt;</type>
      <name>get_key_focus</name>
      <anchorfile>classClutter_1_1Stage.html</anchorfile>
      <anchor>a6974f13e415face1502c6692ae621ecb</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const Actor &gt;</type>
      <name>get_key_focus</name>
      <anchorfile>classClutter_1_1Stage.html</anchorfile>
      <anchor>a53928f8a5a5887a62b8641a118e7c242</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_key_focus</name>
      <anchorfile>classClutter_1_1Stage.html</anchorfile>
      <anchor>af1322177333f2234d219182d18582647</anchor>
      <arglist>(const Glib::RefPtr&lt; Actor &gt; &amp;actor)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_key_focus</name>
      <anchorfile>classClutter_1_1Stage.html</anchorfile>
      <anchor>a2db34b19e685d087a767c2e786414b21</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>guchar *</type>
      <name>read_pixels</name>
      <anchorfile>classClutter_1_1Stage.html</anchorfile>
      <anchor>a3e080f952a61fc356edca2dea27cb756</anchor>
      <arglist>(int x, int y, int width, int height) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_use_fog</name>
      <anchorfile>classClutter_1_1Stage.html</anchorfile>
      <anchor>ad02c595af746caf09367d356ecea0a49</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_use_fog</name>
      <anchorfile>classClutter_1_1Stage.html</anchorfile>
      <anchor>a2ccdfb6cd92be6e56b40830c97773cde</anchor>
      <arglist>(bool fog=true)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_fog</name>
      <anchorfile>classClutter_1_1Stage.html</anchorfile>
      <anchor>a58a4837bfcf39905fd1f16c4b27d624b</anchor>
      <arglist>(const Fog &amp;fog)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>get_fog</name>
      <anchorfile>classClutter_1_1Stage.html</anchorfile>
      <anchor>a8c3493c59faeb1209bfb421130ba11cd</anchor>
      <arglist>(Fog &amp;fog) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>stage_event</name>
      <anchorfile>classClutter_1_1Stage.html</anchorfile>
      <anchor>addf08517c40c7380915766bf86873bd4</anchor>
      <arglist>(Event *event)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_default</name>
      <anchorfile>classClutter_1_1Stage.html</anchorfile>
      <anchor>af2f1420e12e97eac9d236f5f1c2668a0</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>ensure_current</name>
      <anchorfile>classClutter_1_1Stage.html</anchorfile>
      <anchor>a3f0f2d8a687d8e655078f2f936627888</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>ensure_viewport</name>
      <anchorfile>classClutter_1_1Stage.html</anchorfile>
      <anchor>aec0055aed66cff7d0dc3a84faca224e2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>ensure_redraw</name>
      <anchorfile>classClutter_1_1Stage.html</anchorfile>
      <anchor>a64ecf5d8a02b592cad6cc5dcb1aace63</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_throttle_motion_events</name>
      <anchorfile>classClutter_1_1Stage.html</anchorfile>
      <anchor>a4b96a820c7ac4af88883b89bc0c21eff</anchor>
      <arglist>(bool throttle=true)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_throttle_motion_events</name>
      <anchorfile>classClutter_1_1Stage.html</anchorfile>
      <anchor>ac1edca5e5a5d36eafe62be6977075a14</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_use_alpha</name>
      <anchorfile>classClutter_1_1Stage.html</anchorfile>
      <anchor>a043b6617c3083006f955e345310d14ca</anchor>
      <arglist>(bool use_alpha=true)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_use_alpha</name>
      <anchorfile>classClutter_1_1Stage.html</anchorfile>
      <anchor>abcc8c66f454e4e013b14805237252f72</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_minimum_size</name>
      <anchorfile>classClutter_1_1Stage.html</anchorfile>
      <anchor>a8035700960313b8b008628b7e56fcc3c</anchor>
      <arglist>(guint width, guint height)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>get_minimum_size</name>
      <anchorfile>classClutter_1_1Stage.html</anchorfile>
      <anchor>a40a618ebf26ea618acb7bb29bdc6448d</anchor>
      <arglist>(guint &amp;width, guint &amp;height)</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy0&lt; void &gt;</type>
      <name>signal_fullscreen</name>
      <anchorfile>classClutter_1_1Stage.html</anchorfile>
      <anchor>ae40b0caf9ec864738e8c98f621ba9c3e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy0&lt; void &gt;</type>
      <name>signal_unfullscreen</name>
      <anchorfile>classClutter_1_1Stage.html</anchorfile>
      <anchor>a532a2244c790e741a2a00c7f07a1ec5c</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy0&lt; void &gt;</type>
      <name>signal_activate</name>
      <anchorfile>classClutter_1_1Stage.html</anchorfile>
      <anchor>a7c9f3e4f71225bd38e8bbbe82e2c347f</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy0&lt; void &gt;</type>
      <name>signal_deactivate</name>
      <anchorfile>classClutter_1_1Stage.html</anchorfile>
      <anchor>aa256bf6945a24e9773003a029719e752</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy1&lt; bool, ClutterEvent * &gt;</type>
      <name>signal_delete_event</name>
      <anchorfile>classClutter_1_1Stage.html</anchorfile>
      <anchor>a932e7baee42484495fd3f7e98c3e9636</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; Color &gt;</type>
      <name>property_color</name>
      <anchorfile>classClutter_1_1Stage.html</anchorfile>
      <anchor>aab0efc27c86ff2aa40106823c3b39138</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; Color &gt;</type>
      <name>property_color</name>
      <anchorfile>classClutter_1_1Stage.html</anchorfile>
      <anchor>af00a311410b0e860b888e4e7970baf57</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; bool &gt;</type>
      <name>property_cursor_visible</name>
      <anchorfile>classClutter_1_1Stage.html</anchorfile>
      <anchor>abce051b96bd7f065c5b8fc5f4e120b16</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; bool &gt;</type>
      <name>property_cursor_visible</name>
      <anchorfile>classClutter_1_1Stage.html</anchorfile>
      <anchor>a7c6e1b6cf167ea6cbe9621fa625b92ad</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; bool &gt;</type>
      <name>property_fullscreen_set</name>
      <anchorfile>classClutter_1_1Stage.html</anchorfile>
      <anchor>acf2dd43f8027365a8933e911d6848d3a</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; bool &gt;</type>
      <name>property_offscreen</name>
      <anchorfile>classClutter_1_1Stage.html</anchorfile>
      <anchor>abc3a05ca6ded1e872fb9e154fe5ae905</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; bool &gt;</type>
      <name>property_offscreen</name>
      <anchorfile>classClutter_1_1Stage.html</anchorfile>
      <anchor>a15c551f76302cf6ab45f55882c62574a</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; Perspective &gt;</type>
      <name>property_perspective</name>
      <anchorfile>classClutter_1_1Stage.html</anchorfile>
      <anchor>a1d6989d9c64f48895d8de0541df1ca05</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; Perspective &gt;</type>
      <name>property_perspective</name>
      <anchorfile>classClutter_1_1Stage.html</anchorfile>
      <anchor>a22a39f2c64a2e6cfa1e38c84e8b500ec</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; Glib::ustring &gt;</type>
      <name>property_title</name>
      <anchorfile>classClutter_1_1Stage.html</anchorfile>
      <anchor>a6b1b495d5b1b443956397c947cece247</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; Glib::ustring &gt;</type>
      <name>property_title</name>
      <anchorfile>classClutter_1_1Stage.html</anchorfile>
      <anchor>a676ebfe292e69ede7bc85c7d07b05d76</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; bool &gt;</type>
      <name>property_use_fog</name>
      <anchorfile>classClutter_1_1Stage.html</anchorfile>
      <anchor>a90cd80a0d93c99c956f2681e5639768f</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; bool &gt;</type>
      <name>property_use_fog</name>
      <anchorfile>classClutter_1_1Stage.html</anchorfile>
      <anchor>a2346f6f84ea360fe9a667c6667e28441</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; bool &gt;</type>
      <name>property_user_resizable</name>
      <anchorfile>classClutter_1_1Stage.html</anchorfile>
      <anchor>a99f71e03d852a81305b683a64f30aaff</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; bool &gt;</type>
      <name>property_user_resizable</name>
      <anchorfile>classClutter_1_1Stage.html</anchorfile>
      <anchor>a708b987beecaebd4ff7606a716d2772f</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; Fog &gt;</type>
      <name>property_fog</name>
      <anchorfile>classClutter_1_1Stage.html</anchorfile>
      <anchor>a875d97cb049d8b09abf01e18caece94d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; Fog &gt;</type>
      <name>property_fog</name>
      <anchorfile>classClutter_1_1Stage.html</anchorfile>
      <anchor>ab7b88739b87542af180ebe14b7a1a0ac</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; bool &gt;</type>
      <name>property_use_alpha</name>
      <anchorfile>classClutter_1_1Stage.html</anchorfile>
      <anchor>a396d8929a864cc347fd270b2553dc732</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; bool &gt;</type>
      <name>property_use_alpha</name>
      <anchorfile>classClutter_1_1Stage.html</anchorfile>
      <anchor>aaccfd16626a029c4080d05f2fd4b5031</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; Glib::RefPtr&lt; Actor &gt; &gt;</type>
      <name>property_key_focus</name>
      <anchorfile>classClutter_1_1Stage.html</anchorfile>
      <anchor>a29ed0c9cde1daa51052996f6978d1402</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; Glib::RefPtr&lt; Actor &gt; &gt;</type>
      <name>property_key_focus</name>
      <anchorfile>classClutter_1_1Stage.html</anchorfile>
      <anchor>a3cb7f285ee22bed808b9a4b09572659a</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; Stage &gt;</type>
      <name>get_default</name>
      <anchorfile>classClutter_1_1Stage.html</anchorfile>
      <anchor>aad1d69ba719e4ef5617295f93d3acd44</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>Stage</name>
      <anchorfile>classClutter_1_1Stage.html</anchorfile>
      <anchor>aacffd4db27ebeb847e18721828b1340e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>on_fullscreen</name>
      <anchorfile>classClutter_1_1Stage.html</anchorfile>
      <anchor>a3ac285549c5af4d8289952be090596ff</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>on_unfullscreen</name>
      <anchorfile>classClutter_1_1Stage.html</anchorfile>
      <anchor>a0b0956b07445843ea4df1b1bb459cd73</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>on_activate</name>
      <anchorfile>classClutter_1_1Stage.html</anchorfile>
      <anchor>ab1a8398da03f7f9fbca95aca61c7c806</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>on_deactivate</name>
      <anchorfile>classClutter_1_1Stage.html</anchorfile>
      <anchor>a50e425b3e360a88c0ac54ff6e0f19958</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual bool</type>
      <name>on_delete_event</name>
      <anchorfile>classClutter_1_1Stage.html</anchorfile>
      <anchor>a96dd462f9da9db0b1a5b6920741acc8a</anchor>
      <arglist>(ClutterEvent *event)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Clutter::Stage &gt;</type>
      <name>wrap</name>
      <anchorfile>classClutter_1_1Stage.html</anchorfile>
      <anchor>a35c13bc0a49c2a7d91290216c09eba08</anchor>
      <arglist>(ClutterStage *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Clutter::Text</name>
    <filename>classClutter_1_1Text.html</filename>
    <base>Clutter::Actor</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~Text</name>
      <anchorfile>classClutter_1_1Text.html</anchorfile>
      <anchor>a76def4ef64f441a747b56c05e2b60073</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>ClutterText *</type>
      <name>gobj</name>
      <anchorfile>classClutter_1_1Text.html</anchorfile>
      <anchor>ab5e5276a13821e9b09cf47c073d7319e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const ClutterText *</type>
      <name>gobj</name>
      <anchorfile>classClutter_1_1Text.html</anchorfile>
      <anchor>ab879bd48bd9bd9b9baae1d0b9020adb1</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>ClutterText *</type>
      <name>gobj_copy</name>
      <anchorfile>classClutter_1_1Text.html</anchorfile>
      <anchor>a4398e14ac043dc00d82b1d7c546be5bd</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_text</name>
      <anchorfile>classClutter_1_1Text.html</anchorfile>
      <anchor>a4df3bfb941db99b142d990614a161cf0</anchor>
      <arglist>(const Glib::ustring &amp;text)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_markup</name>
      <anchorfile>classClutter_1_1Text.html</anchorfile>
      <anchor>a0c54d43f17c0a0dc79f98ff2c147a9da</anchor>
      <arglist>(const Glib::ustring &amp;markup)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_text</name>
      <anchorfile>classClutter_1_1Text.html</anchorfile>
      <anchor>a408979ee9faa121fae84c89d37357610</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_activatable</name>
      <anchorfile>classClutter_1_1Text.html</anchorfile>
      <anchor>afe307ac2b08fba7321b6b34611250b39</anchor>
      <arglist>(bool activatable=true)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_activatable</name>
      <anchorfile>classClutter_1_1Text.html</anchorfile>
      <anchor>ab7ced0a81e96e5d031cbb7a1822f0e92</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_attributes</name>
      <anchorfile>classClutter_1_1Text.html</anchorfile>
      <anchor>a9fd734e5412bae917d0cf86342d90a47</anchor>
      <arglist>(Pango::AttrList &amp;attrs)</arglist>
    </member>
    <member kind="function">
      <type>Pango::AttrList</type>
      <name>get_attributes</name>
      <anchorfile>classClutter_1_1Text.html</anchorfile>
      <anchor>a10248da7ee1a72e0a6fffab215701164</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_color</name>
      <anchorfile>classClutter_1_1Text.html</anchorfile>
      <anchor>aca2bf418247896f246d99992eb86a3b3</anchor>
      <arglist>(const Color &amp;color)</arglist>
    </member>
    <member kind="function">
      <type>Color</type>
      <name>get_color</name>
      <anchorfile>classClutter_1_1Text.html</anchorfile>
      <anchor>a5e73e9a964a16b4e0973faedf4cfdb71</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_ellipsize</name>
      <anchorfile>classClutter_1_1Text.html</anchorfile>
      <anchor>a7a5e357ce69b914f5647548c73d28508</anchor>
      <arglist>(Pango::EllipsizeMode mode)</arglist>
    </member>
    <member kind="function">
      <type>Pango::EllipsizeMode</type>
      <name>get_ellipsize</name>
      <anchorfile>classClutter_1_1Text.html</anchorfile>
      <anchor>a52bd562c4c9ee0ee07488973cc66124c</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_font_name</name>
      <anchorfile>classClutter_1_1Text.html</anchorfile>
      <anchor>af8318339202f776e90889841866ec539</anchor>
      <arglist>(const Glib::ustring &amp;font_name)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_font_name</name>
      <anchorfile>classClutter_1_1Text.html</anchorfile>
      <anchor>a4249bb249c8d69c777c9a9f6c5e2242a</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_font_description</name>
      <anchorfile>classClutter_1_1Text.html</anchorfile>
      <anchor>a24d491173cdb66d9a78cac5e486fad2d</anchor>
      <arglist>(const Pango::FontDescription &amp;font_desc)</arglist>
    </member>
    <member kind="function">
      <type>Pango::FontDescription</type>
      <name>get_font_description</name>
      <anchorfile>classClutter_1_1Text.html</anchorfile>
      <anchor>a984a1c952d365300faaa60524873e157</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_password_char</name>
      <anchorfile>classClutter_1_1Text.html</anchorfile>
      <anchor>a6c85cee20bb49f4e0f011fcd600bebbf</anchor>
      <arglist>(gunichar wc)</arglist>
    </member>
    <member kind="function">
      <type>gunichar</type>
      <name>get_password_char</name>
      <anchorfile>classClutter_1_1Text.html</anchorfile>
      <anchor>a8c5722e63f8ff8b6318ec501ea9e6372</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_justify</name>
      <anchorfile>classClutter_1_1Text.html</anchorfile>
      <anchor>ade8c440d5c4917817593171789c377ca</anchor>
      <arglist>(bool justify=true)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_justify</name>
      <anchorfile>classClutter_1_1Text.html</anchorfile>
      <anchor>abd50c09f71a85b0f499115dbb4f58260</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Pango::Layout &gt;</type>
      <name>get_layout</name>
      <anchorfile>classClutter_1_1Text.html</anchorfile>
      <anchor>a69b07051234dbbc8192d18cf3ca637f5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const Pango::Layout &gt;</type>
      <name>get_layout</name>
      <anchorfile>classClutter_1_1Text.html</anchorfile>
      <anchor>aee5b671922a59196a1a192c274de814f</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_line_alignment</name>
      <anchorfile>classClutter_1_1Text.html</anchorfile>
      <anchor>a93b2b0676fc2c3ebd14eb04183522040</anchor>
      <arglist>(Pango::Alignment alignment)</arglist>
    </member>
    <member kind="function">
      <type>Pango::Alignment</type>
      <name>get_line_alignment</name>
      <anchorfile>classClutter_1_1Text.html</anchorfile>
      <anchor>a6c318ebda31fb7df3d9659bcd5be1c1a</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_line_wrap</name>
      <anchorfile>classClutter_1_1Text.html</anchorfile>
      <anchor>a83dc5dd7805bae2e63efd94b06f6b413</anchor>
      <arglist>(bool line_wrap=true)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_line_wrap</name>
      <anchorfile>classClutter_1_1Text.html</anchorfile>
      <anchor>a5d8fae0226dcbfc6f0ff598e111cf4ef</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Pango::WrapMode</type>
      <name>get_line_wrap_mode</name>
      <anchorfile>classClutter_1_1Text.html</anchorfile>
      <anchor>ab88194f116ea0b16e4dbe8afe2b95a3a</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_line_wrap_mode</name>
      <anchorfile>classClutter_1_1Text.html</anchorfile>
      <anchor>a1cbd9ba7b5b0c6de59a7872214ff26ea</anchor>
      <arglist>(Pango::WrapMode wrap_mode)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>get_max_length</name>
      <anchorfile>classClutter_1_1Text.html</anchorfile>
      <anchor>a270d9868c188c5b1d1fd5d9c841e4455</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_max_length</name>
      <anchorfile>classClutter_1_1Text.html</anchorfile>
      <anchor>a8c5b4139c7db6417d7487920d8a1e801</anchor>
      <arglist>(int max_length)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_selectable</name>
      <anchorfile>classClutter_1_1Text.html</anchorfile>
      <anchor>a287156e8cd0487dc9b44440676d3c2c4</anchor>
      <arglist>(bool selectable=true)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_selectable</name>
      <anchorfile>classClutter_1_1Text.html</anchorfile>
      <anchor>a159c5f2fa4bd0aeb96f9591191a71c2d</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_selection</name>
      <anchorfile>classClutter_1_1Text.html</anchorfile>
      <anchor>a7796a110b42f6e19c0090c9834232b98</anchor>
      <arglist>(gssize start_pos, gssize end_pos)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_selection</name>
      <anchorfile>classClutter_1_1Text.html</anchorfile>
      <anchor>a3aba9b402e6446486190f63955fa63a1</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_selection_bound</name>
      <anchorfile>classClutter_1_1Text.html</anchorfile>
      <anchor>ad2b8be8b34691ce585f9de392d7de69e</anchor>
      <arglist>(int selection_bound)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>get_selection_bound</name>
      <anchorfile>classClutter_1_1Text.html</anchorfile>
      <anchor>ac4f68d07b982df3c56b15ae5dd15b483</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_selection_color</name>
      <anchorfile>classClutter_1_1Text.html</anchorfile>
      <anchor>ace586f49059836ee8cd91d813fe5922d</anchor>
      <arglist>(const Color &amp;color)</arglist>
    </member>
    <member kind="function">
      <type>Color</type>
      <name>get_selection_color</name>
      <anchorfile>classClutter_1_1Text.html</anchorfile>
      <anchor>a4890ede73d2e191a419691e472367afd</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_single_line_mode</name>
      <anchorfile>classClutter_1_1Text.html</anchorfile>
      <anchor>abb08f39ed9312186b4f3f298b9480da9</anchor>
      <arglist>(bool single_line=true)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_single_line_mode</name>
      <anchorfile>classClutter_1_1Text.html</anchorfile>
      <anchor>ad0126f0ea81b429d959ae7820036026b</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_use_markup</name>
      <anchorfile>classClutter_1_1Text.html</anchorfile>
      <anchor>ac03dded63be65abb1dd18a10bfaa19f3</anchor>
      <arglist>(bool setting=true)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_use_markup</name>
      <anchorfile>classClutter_1_1Text.html</anchorfile>
      <anchor>a953c3c53b876c7eb6cf4d2717f31afdb</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_editable</name>
      <anchorfile>classClutter_1_1Text.html</anchorfile>
      <anchor>a9e1a7fd87d8ba646350560b186cde17e</anchor>
      <arglist>(bool editable=true)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_editable</name>
      <anchorfile>classClutter_1_1Text.html</anchorfile>
      <anchor>aee27eda3f3492beb9ffeb6137560ca39</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>insert</name>
      <anchorfile>classClutter_1_1Text.html</anchorfile>
      <anchor>a4929c8205b5fca4971314bfb34a759a7</anchor>
      <arglist>(gunichar wc)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>insert</name>
      <anchorfile>classClutter_1_1Text.html</anchorfile>
      <anchor>af39085cc9afdbee030dce2aafa759946</anchor>
      <arglist>(const Glib::ustring &amp;text, gssize position)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>delete_chars</name>
      <anchorfile>classClutter_1_1Text.html</anchorfile>
      <anchor>a9124e4ae3b568e98246de7598c2d1888</anchor>
      <arglist>(guint len)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>delete_text</name>
      <anchorfile>classClutter_1_1Text.html</anchorfile>
      <anchor>ad4a81b9e6180a524af7a54952144630e</anchor>
      <arglist>(gssize start_pos, gssize end_pos)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>delete_selection</name>
      <anchorfile>classClutter_1_1Text.html</anchorfile>
      <anchor>aff012a80e8c5af0e70a9b4240d0392df</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_chars</name>
      <anchorfile>classClutter_1_1Text.html</anchorfile>
      <anchor>adcaeaee7f80ddb9d9ff6047229d8a860</anchor>
      <arglist>(gssize start_pos, gssize end_pos) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_cursor_color</name>
      <anchorfile>classClutter_1_1Text.html</anchorfile>
      <anchor>a5a0b24f2ed741df704b0b9b1dd186751</anchor>
      <arglist>(const Color &amp;color)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>get_cursor_color</name>
      <anchorfile>classClutter_1_1Text.html</anchorfile>
      <anchor>a958479dba2fbc04824e9e29425a32477</anchor>
      <arglist>(Color &amp;color) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_cursor_position</name>
      <anchorfile>classClutter_1_1Text.html</anchorfile>
      <anchor>a1b79245597f451505ef819237a7f0a0e</anchor>
      <arglist>(int position)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>get_cursor_position</name>
      <anchorfile>classClutter_1_1Text.html</anchorfile>
      <anchor>ab817f113f9a5581f37908eee62b0faf3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_cursor_visible</name>
      <anchorfile>classClutter_1_1Text.html</anchorfile>
      <anchor>a4d82901de9d0e7c8ff6656438ec92fa8</anchor>
      <arglist>(bool visible)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_cursor_visible</name>
      <anchorfile>classClutter_1_1Text.html</anchorfile>
      <anchor>aae54ea5cb22d9f1639da8bcf99fd8868</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_cursor_size</name>
      <anchorfile>classClutter_1_1Text.html</anchorfile>
      <anchor>ad0fe87398c39edd477fac842b3193589</anchor>
      <arglist>(int size)</arglist>
    </member>
    <member kind="function">
      <type>guint</type>
      <name>get_cursor_size</name>
      <anchorfile>classClutter_1_1Text.html</anchorfile>
      <anchor>ae966642a2c0195530676d12f9399e7ca</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>activate</name>
      <anchorfile>classClutter_1_1Text.html</anchorfile>
      <anchor>a0bdb8b297be63394f7c3c55787d8dc64</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>position_to_coords</name>
      <anchorfile>classClutter_1_1Text.html</anchorfile>
      <anchor>a55d796f1a93f5accbb5c6feec048a13a</anchor>
      <arglist>(int position, float &amp;x, float &amp;y, float &amp;line_height)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_preedit_string</name>
      <anchorfile>classClutter_1_1Text.html</anchorfile>
      <anchor>a2f13bdd3d0842124c4d8b6020c5533ae</anchor>
      <arglist>(const Glib::ustring &amp;preedit_str, const Pango::AttrList &amp;preedit_attrs, guint ursor_pos)</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy0&lt; void &gt;</type>
      <name>signal_activate</name>
      <anchorfile>classClutter_1_1Text.html</anchorfile>
      <anchor>a02a16605b15195d0ee30c5a2f93f33b0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy0&lt; void &gt;</type>
      <name>signal_text_changed</name>
      <anchorfile>classClutter_1_1Text.html</anchorfile>
      <anchor>a29bf88ab096d7437f2bf079a0917e0eb</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy1&lt; void, const Geometry &amp; &gt;</type>
      <name>signal_cursor_event</name>
      <anchorfile>classClutter_1_1Text.html</anchorfile>
      <anchor>a77104773a4623e5e4807c48c90a5ef37</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; bool &gt;</type>
      <name>property_activatable</name>
      <anchorfile>classClutter_1_1Text.html</anchorfile>
      <anchor>ade498e6c794b5298560cb63bcf755026</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; bool &gt;</type>
      <name>property_activatable</name>
      <anchorfile>classClutter_1_1Text.html</anchorfile>
      <anchor>aac0df5f886bf8c782b4a9202f4af7031</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; Pango::AttrList &gt;</type>
      <name>property_attributes</name>
      <anchorfile>classClutter_1_1Text.html</anchorfile>
      <anchor>a3c1668e5d535490e24815277bb288755</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; Pango::AttrList &gt;</type>
      <name>property_attributes</name>
      <anchorfile>classClutter_1_1Text.html</anchorfile>
      <anchor>abebf42b79d908ba19cd1832d273293da</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; Color &gt;</type>
      <name>property_color</name>
      <anchorfile>classClutter_1_1Text.html</anchorfile>
      <anchor>aa70129f913cf006be41f5959b24594a2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; Color &gt;</type>
      <name>property_color</name>
      <anchorfile>classClutter_1_1Text.html</anchorfile>
      <anchor>a16d51a1295996256a6d8eeaea2465d52</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; Color &gt;</type>
      <name>property_cursor_color</name>
      <anchorfile>classClutter_1_1Text.html</anchorfile>
      <anchor>aec467d057ab72db620efd47fa3e55ec4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; Color &gt;</type>
      <name>property_cursor_color</name>
      <anchorfile>classClutter_1_1Text.html</anchorfile>
      <anchor>a36785cafe0c068658c51fd612fd1e799</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; bool &gt;</type>
      <name>property_cursor_color_set</name>
      <anchorfile>classClutter_1_1Text.html</anchorfile>
      <anchor>af9862a6b8368bb5f2927f77e4b92fa4c</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; int &gt;</type>
      <name>property_cursor_size</name>
      <anchorfile>classClutter_1_1Text.html</anchorfile>
      <anchor>a4ecc24c352a59a0e20efa11084ba1bb8</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; int &gt;</type>
      <name>property_cursor_size</name>
      <anchorfile>classClutter_1_1Text.html</anchorfile>
      <anchor>a65cb6c511e92e0a0a64f1e82f4fd1cd1</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; bool &gt;</type>
      <name>property_cursor_visible</name>
      <anchorfile>classClutter_1_1Text.html</anchorfile>
      <anchor>a0b353e6add27a665fd21cff3b7da11f4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; bool &gt;</type>
      <name>property_cursor_visible</name>
      <anchorfile>classClutter_1_1Text.html</anchorfile>
      <anchor>ae3e3b27eefe4510696e93487d8ed9834</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; bool &gt;</type>
      <name>property_editable</name>
      <anchorfile>classClutter_1_1Text.html</anchorfile>
      <anchor>a64afab2b127b763044e991155a41d191</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; bool &gt;</type>
      <name>property_editable</name>
      <anchorfile>classClutter_1_1Text.html</anchorfile>
      <anchor>af8b9debdd690db230093d78552ca6247</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; Pango::EllipsizeMode &gt;</type>
      <name>property_ellipsize</name>
      <anchorfile>classClutter_1_1Text.html</anchorfile>
      <anchor>ab8957127d1b7409b6b9cdd5c75a54d4f</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; Pango::EllipsizeMode &gt;</type>
      <name>property_ellipsize</name>
      <anchorfile>classClutter_1_1Text.html</anchorfile>
      <anchor>a9eb9fa44f054a56d3f1ba26aa84437ac</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; Glib::ustring &gt;</type>
      <name>property_font_name</name>
      <anchorfile>classClutter_1_1Text.html</anchorfile>
      <anchor>ab8c2a8dc0621324cfb9196c8d03ab172</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; Glib::ustring &gt;</type>
      <name>property_font_name</name>
      <anchorfile>classClutter_1_1Text.html</anchorfile>
      <anchor>aba52aec3237a1ed5c9b64dd4f2d28b7f</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; Pango::FontDescription &gt;</type>
      <name>property_font_description</name>
      <anchorfile>classClutter_1_1Text.html</anchorfile>
      <anchor>a4578e0316caa6649192d37e99e6dd2ca</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; Pango::FontDescription &gt;</type>
      <name>property_font_description</name>
      <anchorfile>classClutter_1_1Text.html</anchorfile>
      <anchor>a283c513994bd602acdf0024b9b5f848b</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; bool &gt;</type>
      <name>property_justify</name>
      <anchorfile>classClutter_1_1Text.html</anchorfile>
      <anchor>aa184b96a8975f4aeb3997fa542d68aac</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; bool &gt;</type>
      <name>property_justify</name>
      <anchorfile>classClutter_1_1Text.html</anchorfile>
      <anchor>aae69602d9b78c7f502d071970426c874</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; Pango::Alignment &gt;</type>
      <name>property_line_alignment</name>
      <anchorfile>classClutter_1_1Text.html</anchorfile>
      <anchor>a64558648fa59b8904db370ea79ad75a9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; Pango::Alignment &gt;</type>
      <name>property_line_alignment</name>
      <anchorfile>classClutter_1_1Text.html</anchorfile>
      <anchor>ab401dcbbd6a91e1318fbc446d1a6953a</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; Pango::WrapMode &gt;</type>
      <name>property_line_wrap_mode</name>
      <anchorfile>classClutter_1_1Text.html</anchorfile>
      <anchor>a12a731e9edc2391b7ecefbc7df683a7e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; Pango::WrapMode &gt;</type>
      <name>property_line_wrap_mode</name>
      <anchorfile>classClutter_1_1Text.html</anchorfile>
      <anchor>afe07a1839aea5ab00cded8ecd60a6b1c</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; bool &gt;</type>
      <name>property_line_wrap</name>
      <anchorfile>classClutter_1_1Text.html</anchorfile>
      <anchor>a8984ba958dd64c9d4e40bb574808b9a9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; bool &gt;</type>
      <name>property_line_wrap</name>
      <anchorfile>classClutter_1_1Text.html</anchorfile>
      <anchor>ae37618a52ec72d8287848f773d73dadb</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; int &gt;</type>
      <name>property_max_length</name>
      <anchorfile>classClutter_1_1Text.html</anchorfile>
      <anchor>ae2b172dfa8b5508a57780aadd1696920</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; int &gt;</type>
      <name>property_max_length</name>
      <anchorfile>classClutter_1_1Text.html</anchorfile>
      <anchor>a02aa646015db9076cad10029d493f594</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; gunichar &gt;</type>
      <name>property_password_char</name>
      <anchorfile>classClutter_1_1Text.html</anchorfile>
      <anchor>a9e26209ee4d4eceeb18702d8b333e5ef</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; gunichar &gt;</type>
      <name>property_password_char</name>
      <anchorfile>classClutter_1_1Text.html</anchorfile>
      <anchor>aa462ad094923fd5f8d422dfead6c1fec</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; int &gt;</type>
      <name>property_position</name>
      <anchorfile>classClutter_1_1Text.html</anchorfile>
      <anchor>a8118d7372a1b714bfa8435f014163193</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; int &gt;</type>
      <name>property_position</name>
      <anchorfile>classClutter_1_1Text.html</anchorfile>
      <anchor>ae43f3ab92c74bb594c737ae5e04a49d3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; bool &gt;</type>
      <name>property_selectable</name>
      <anchorfile>classClutter_1_1Text.html</anchorfile>
      <anchor>a4a7dee58c70ce640bedb69137669fec6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; bool &gt;</type>
      <name>property_selectable</name>
      <anchorfile>classClutter_1_1Text.html</anchorfile>
      <anchor>afbb7574f177d8ba4f8df75067aa9426a</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; int &gt;</type>
      <name>property_selection_bound</name>
      <anchorfile>classClutter_1_1Text.html</anchorfile>
      <anchor>a417468e45e9b846a7e2de7eb87498f5c</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; int &gt;</type>
      <name>property_selection_bound</name>
      <anchorfile>classClutter_1_1Text.html</anchorfile>
      <anchor>a53f7365ff20ab792ae03eda2f65f8b31</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; Color &gt;</type>
      <name>property_selection_color</name>
      <anchorfile>classClutter_1_1Text.html</anchorfile>
      <anchor>a4ec60806fc149dac160b790b822c7541</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; Color &gt;</type>
      <name>property_selection_color</name>
      <anchorfile>classClutter_1_1Text.html</anchorfile>
      <anchor>a20dba44c5d99e5929a7d769da2575502</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; bool &gt;</type>
      <name>property_selection_color_set</name>
      <anchorfile>classClutter_1_1Text.html</anchorfile>
      <anchor>a1c3072efce6bcb3dd12ac23a7d6dbecd</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; bool &gt;</type>
      <name>property_single_line_mode</name>
      <anchorfile>classClutter_1_1Text.html</anchorfile>
      <anchor>a213afb521743f4e43faa6ed6c1c73988</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; bool &gt;</type>
      <name>property_single_line_mode</name>
      <anchorfile>classClutter_1_1Text.html</anchorfile>
      <anchor>ae2cee85e4d2bd886b32a2d5c0bacc3dc</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; Glib::ustring &gt;</type>
      <name>property_text</name>
      <anchorfile>classClutter_1_1Text.html</anchorfile>
      <anchor>a87de77a23dd2016c5eb0897a4772a67a</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; Glib::ustring &gt;</type>
      <name>property_text</name>
      <anchorfile>classClutter_1_1Text.html</anchorfile>
      <anchor>abc6760fccb24dc1f1ad1ff8b553a9e63</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; bool &gt;</type>
      <name>property_use_markup</name>
      <anchorfile>classClutter_1_1Text.html</anchorfile>
      <anchor>ae942eaa1ed7c6957089f97230f394787</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; bool &gt;</type>
      <name>property_use_markup</name>
      <anchorfile>classClutter_1_1Text.html</anchorfile>
      <anchor>a47a24e27ca94d6a3dcf8ed214e330404</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; Text &gt;</type>
      <name>create</name>
      <anchorfile>classClutter_1_1Text.html</anchorfile>
      <anchor>a98d2ac7ffb3188613fb624ecdd1058d4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; Text &gt;</type>
      <name>create</name>
      <anchorfile>classClutter_1_1Text.html</anchorfile>
      <anchor>a8de4aeb2e1f5da2c9e0ad1a6aa4c5297</anchor>
      <arglist>(const Glib::ustring &amp;font_name, const Glib::ustring &amp;text)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; Text &gt;</type>
      <name>create</name>
      <anchorfile>classClutter_1_1Text.html</anchorfile>
      <anchor>a101409e7c287bd2720084d2c520f6499</anchor>
      <arglist>(const Glib::ustring &amp;font_name, const Glib::ustring &amp;text, const Color &amp;color)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>Text</name>
      <anchorfile>classClutter_1_1Text.html</anchorfile>
      <anchor>aca4c5b22c12bf1dde3a33e916a7ebe8c</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>Text</name>
      <anchorfile>classClutter_1_1Text.html</anchorfile>
      <anchor>ad688754bfeaaff0cf835c132d4460f7b</anchor>
      <arglist>(const Glib::ustring &amp;font_name, const Glib::ustring &amp;text)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>Text</name>
      <anchorfile>classClutter_1_1Text.html</anchorfile>
      <anchor>acb4279f68f6775aee305b449f0452e63</anchor>
      <arglist>(const Glib::ustring &amp;font_name, const Glib::ustring &amp;text, const Color &amp;color)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>on_activate</name>
      <anchorfile>classClutter_1_1Text.html</anchorfile>
      <anchor>a1bf3062265a6d02046193076f1549cbb</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>on_text_changed</name>
      <anchorfile>classClutter_1_1Text.html</anchorfile>
      <anchor>a0f46b671e8bf0944991ebee80ae9cd0f</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>on_cursor_event</name>
      <anchorfile>classClutter_1_1Text.html</anchorfile>
      <anchor>a9509c24a571738e2df4f7e5b52cee6b2</anchor>
      <arglist>(const Geometry &amp;geometry)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Clutter::Text &gt;</type>
      <name>wrap</name>
      <anchorfile>classClutter_1_1Text.html</anchorfile>
      <anchor>a2f3f7588b61aee5cd97ffb75a90178c8</anchor>
      <arglist>(ClutterText *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Clutter::TextureError</name>
    <filename>classClutter_1_1TextureError.html</filename>
    <base>Glib::Error</base>
    <member kind="enumeration">
      <name>Code</name>
      <anchorfile>classClutter_1_1TextureError.html</anchorfile>
      <anchor>a7624606020bc9dd791f95226191aae1a</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>OUT_OF_MEMORY</name>
      <anchorfile>classClutter_1_1TextureError.html</anchorfile>
      <anchor>a7624606020bc9dd791f95226191aae1aa0a5123373b146aa15ff2fee42c8a43ab</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>NO_YUV</name>
      <anchorfile>classClutter_1_1TextureError.html</anchorfile>
      <anchor>a7624606020bc9dd791f95226191aae1aa18c83125b00b0d564284f281e44f8fa1</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>BAD_FORMAT</name>
      <anchorfile>classClutter_1_1TextureError.html</anchorfile>
      <anchor>a7624606020bc9dd791f95226191aae1aaadfa9b48f4f8095cf8623f58af5d0d2c</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>TextureError</name>
      <anchorfile>classClutter_1_1TextureError.html</anchorfile>
      <anchor>a2778dc8dff372dd9bb49ad8507859147</anchor>
      <arglist>(Code error_code, const Glib::ustring &amp;error_message)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>TextureError</name>
      <anchorfile>classClutter_1_1TextureError.html</anchorfile>
      <anchor>a4875bd1ef7b790d697d12a5ae94c8b79</anchor>
      <arglist>(GError *gobject)</arglist>
    </member>
    <member kind="function">
      <type>Code</type>
      <name>code</name>
      <anchorfile>classClutter_1_1TextureError.html</anchorfile>
      <anchor>a8318effc27aa6ade114c4c5cc73602bc</anchor>
      <arglist>() const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Clutter::Texture</name>
    <filename>classClutter_1_1Texture.html</filename>
    <base>Clutter::Actor</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~Texture</name>
      <anchorfile>classClutter_1_1Texture.html</anchorfile>
      <anchor>a59253fdac3b90b8324980434cf4805ad</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>ClutterTexture *</type>
      <name>gobj</name>
      <anchorfile>classClutter_1_1Texture.html</anchorfile>
      <anchor>a5ddc4217f53c3d96cdfeb433c969522d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const ClutterTexture *</type>
      <name>gobj</name>
      <anchorfile>classClutter_1_1Texture.html</anchorfile>
      <anchor>a5a03e4c0ac5c0e12250082426937657a</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>ClutterTexture *</type>
      <name>gobj_copy</name>
      <anchorfile>classClutter_1_1Texture.html</anchorfile>
      <anchor>a28cc9381eb4f7681f6d7a4e41fabc208</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>set_from_file</name>
      <anchorfile>classClutter_1_1Texture.html</anchorfile>
      <anchor>a02b32288027ac53913aa3301ed751915</anchor>
      <arglist>(const std::string &amp;filename)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>set_from_rgb_data</name>
      <anchorfile>classClutter_1_1Texture.html</anchorfile>
      <anchor>ac5f19a1d27d2a5231132d43ed11a7200</anchor>
      <arglist>(const guchar *data, bool has_alpha, int width, int height, int rowstride, int bpp, TextureFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>set_from_yuv_data</name>
      <anchorfile>classClutter_1_1Texture.html</anchorfile>
      <anchor>a7074fbb6d7eddfc094a3b5666980246f</anchor>
      <arglist>(const guchar *data, int width, int height, TextureFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>set_area_from_rgb_data</name>
      <anchorfile>classClutter_1_1Texture.html</anchorfile>
      <anchor>a61bd118b134c10669e8193124f0a3ba7</anchor>
      <arglist>(const guchar *data, bool has_alpha, int x, int y, int width, int height, int rowstride, int bpp, TextureFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>get_base_size</name>
      <anchorfile>classClutter_1_1Texture.html</anchorfile>
      <anchor>af60c4d1d1f19d67a3259ab499c4e5132</anchor>
      <arglist>(int &amp;width, int &amp;height) const </arglist>
    </member>
    <member kind="function">
      <type>CoglPixelFormat</type>
      <name>get_pixel_format</name>
      <anchorfile>classClutter_1_1Texture.html</anchorfile>
      <anchor>a79304415e84d6a7d56e00b6adce24821</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>TextureQuality</type>
      <name>get_filter_quality</name>
      <anchorfile>classClutter_1_1Texture.html</anchorfile>
      <anchor>a1f4d9856cccf09e4ff8bd4fbb4c57c56</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_filter_quality</name>
      <anchorfile>classClutter_1_1Texture.html</anchorfile>
      <anchor>a4d1a47beda4a1e6fb8e6949c947bb088</anchor>
      <arglist>(TextureQuality filter_quality)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>get_max_tile_waste</name>
      <anchorfile>classClutter_1_1Texture.html</anchorfile>
      <anchor>ab7cb0b86b4d27a8c3fb2e5325eb1ea2a</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>CoglHandle</type>
      <name>get_cogl_texture</name>
      <anchorfile>classClutter_1_1Texture.html</anchorfile>
      <anchor>a5b3bca844a9ff4e5405e169ffd7270fe</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_cogl_texture</name>
      <anchorfile>classClutter_1_1Texture.html</anchorfile>
      <anchor>a1fccdd914dad647930b560490be93d19</anchor>
      <arglist>(CoglHandle handle)</arglist>
    </member>
    <member kind="function">
      <type>CoglHandle</type>
      <name>get_cogl_material</name>
      <anchorfile>classClutter_1_1Texture.html</anchorfile>
      <anchor>a9f8785c085a46f8f15fd69a49ae3364f</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_cogl_material</name>
      <anchorfile>classClutter_1_1Texture.html</anchorfile>
      <anchor>abbf49732ad7cd6626d9549370d3db2df</anchor>
      <arglist>(CoglHandle handle)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_sync_size</name>
      <anchorfile>classClutter_1_1Texture.html</anchorfile>
      <anchor>ab7ce04807614d8733ae43478fabadf90</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_sync_size</name>
      <anchorfile>classClutter_1_1Texture.html</anchorfile>
      <anchor>a75ec81d7c307008a5e8ad80b13baf0f2</anchor>
      <arglist>(bool sync_size=true)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>get_repeat</name>
      <anchorfile>classClutter_1_1Texture.html</anchorfile>
      <anchor>a8530852fd03a4e120e06dc37f35429a8</anchor>
      <arglist>(bool &amp;repeat_x, bool &amp;repeat_y) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_repeat</name>
      <anchorfile>classClutter_1_1Texture.html</anchorfile>
      <anchor>aa790cff5220dd8e3ec0d216f479fa7a6</anchor>
      <arglist>(bool repeat_x=true, bool repeat_y=true)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_keep_aspect_ratio</name>
      <anchorfile>classClutter_1_1Texture.html</anchorfile>
      <anchor>ae6e334c63ac0a201e52b0bb569e92b8b</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_keep_aspect_ratio</name>
      <anchorfile>classClutter_1_1Texture.html</anchorfile>
      <anchor>a9388729cce58bf3afe7e93b20780cada</anchor>
      <arglist>(bool keep_aspect=true)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_load_async</name>
      <anchorfile>classClutter_1_1Texture.html</anchorfile>
      <anchor>a1e1a6cdd1fdcb44e2b689e5250327c09</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_load_async</name>
      <anchorfile>classClutter_1_1Texture.html</anchorfile>
      <anchor>adba14086f228faf3b426b681576d8a58</anchor>
      <arglist>(bool load_async=true)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_load_data_async</name>
      <anchorfile>classClutter_1_1Texture.html</anchorfile>
      <anchor>acf43bf848c1dcd86b0ce390b12ef00d9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_load_data_async</name>
      <anchorfile>classClutter_1_1Texture.html</anchorfile>
      <anchor>a8d67439bcdc83ba595546a1304c34070</anchor>
      <arglist>(bool load_async=true)</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy2&lt; void, int, int &gt;</type>
      <name>signal_size_change</name>
      <anchorfile>classClutter_1_1Texture.html</anchorfile>
      <anchor>a96b0f4d732bbdbe0cd31bff635bb9fbd</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy0&lt; void &gt;</type>
      <name>signal_pixbuf_change</name>
      <anchorfile>classClutter_1_1Texture.html</anchorfile>
      <anchor>aeaadb0dc708efec8bc780405adffb62e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; CoglHandle &gt;</type>
      <name>property_cogl_texture</name>
      <anchorfile>classClutter_1_1Texture.html</anchorfile>
      <anchor>a8c00ed20e7677d58da2fe526fdf60d5f</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; CoglHandle &gt;</type>
      <name>property_cogl_texture</name>
      <anchorfile>classClutter_1_1Texture.html</anchorfile>
      <anchor>ae3458e1cc1a29edbddaabea18d4d0c7f</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; bool &gt;</type>
      <name>property_disable_slicing</name>
      <anchorfile>classClutter_1_1Texture.html</anchorfile>
      <anchor>a918d064c37c1aea10a633e3548b6f0e7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_WriteOnly&lt; std::string &gt;</type>
      <name>property_filename</name>
      <anchorfile>classClutter_1_1Texture.html</anchorfile>
      <anchor>a1bb39e544e1d01ef6d6dedd9e5614275</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; TextureQuality &gt;</type>
      <name>property_filter_quality</name>
      <anchorfile>classClutter_1_1Texture.html</anchorfile>
      <anchor>afb5ace0d9d7ce4f200191508369bd374</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; TextureQuality &gt;</type>
      <name>property_filter_quality</name>
      <anchorfile>classClutter_1_1Texture.html</anchorfile>
      <anchor>a912afc40d0f16e04217b38c28560ce37</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; bool &gt;</type>
      <name>property_keep_aspect_ratio</name>
      <anchorfile>classClutter_1_1Texture.html</anchorfile>
      <anchor>af3ec708557bd95b9677b25bf8021b724</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; bool &gt;</type>
      <name>property_keep_aspect_ratio</name>
      <anchorfile>classClutter_1_1Texture.html</anchorfile>
      <anchor>afeb821ed4946b2de79616b38e6ebe6ec</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_WriteOnly&lt; bool &gt;</type>
      <name>property_load_async</name>
      <anchorfile>classClutter_1_1Texture.html</anchorfile>
      <anchor>ae16fc6ad46422fb1c65ed9faaed3e4b9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_WriteOnly&lt; bool &gt;</type>
      <name>property_load_data_async</name>
      <anchorfile>classClutter_1_1Texture.html</anchorfile>
      <anchor>ab70d2308d5944aad5c2e20996c364115</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; int &gt;</type>
      <name>property_pixel_format</name>
      <anchorfile>classClutter_1_1Texture.html</anchorfile>
      <anchor>a04cee5012a4788ab37d2694048b9a526</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; bool &gt;</type>
      <name>property_repeat_x</name>
      <anchorfile>classClutter_1_1Texture.html</anchorfile>
      <anchor>a8b9330124b5c206537780ca4b517edd7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; bool &gt;</type>
      <name>property_repeat_x</name>
      <anchorfile>classClutter_1_1Texture.html</anchorfile>
      <anchor>a1f66ad11d691112b8427fa31cdf4146a</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; bool &gt;</type>
      <name>property_repeat_y</name>
      <anchorfile>classClutter_1_1Texture.html</anchorfile>
      <anchor>afca4ff03f7d0ddc43d2b34127b7adc15</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; bool &gt;</type>
      <name>property_repeat_y</name>
      <anchorfile>classClutter_1_1Texture.html</anchorfile>
      <anchor>a6ec8cc9a6e7db33fc26c3e823c1d1cfa</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; bool &gt;</type>
      <name>property_sync_size</name>
      <anchorfile>classClutter_1_1Texture.html</anchorfile>
      <anchor>ac274a47c4a228a1addfd8d014c4f15f0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; bool &gt;</type>
      <name>property_sync_size</name>
      <anchorfile>classClutter_1_1Texture.html</anchorfile>
      <anchor>ae8181516c92fd9c766dc1e125c789565</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; int &gt;</type>
      <name>property_tile_waste</name>
      <anchorfile>classClutter_1_1Texture.html</anchorfile>
      <anchor>a02b1cd9ee931ce2e4e35f70fed8d57d6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; Texture &gt;</type>
      <name>create</name>
      <anchorfile>classClutter_1_1Texture.html</anchorfile>
      <anchor>aeab3ff326ecd67a1a53c7ac6167de3e0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; Texture &gt;</type>
      <name>create_from_file</name>
      <anchorfile>classClutter_1_1Texture.html</anchorfile>
      <anchor>a3bc5f1d77f182ee1ba433f23a51469f2</anchor>
      <arglist>(const std::string &amp;filename)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>Texture</name>
      <anchorfile>classClutter_1_1Texture.html</anchorfile>
      <anchor>ad16cca861d250c37ea709ff9dd629b47</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>on_size_change</name>
      <anchorfile>classClutter_1_1Texture.html</anchorfile>
      <anchor>a3f2f3deea57537448112f77491f6f4ce</anchor>
      <arglist>(int width, int height)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>on_pixbuf_change</name>
      <anchorfile>classClutter_1_1Texture.html</anchorfile>
      <anchor>a7526541f8689e1076f9af126dbd0c334</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Clutter::Texture &gt;</type>
      <name>wrap</name>
      <anchorfile>classClutter_1_1Texture.html</anchorfile>
      <anchor>a9d624fde60fbe997ff846aa86386b07b</anchor>
      <arglist>(ClutterTexture *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Clutter::Timeline</name>
    <filename>classClutter_1_1Timeline.html</filename>
    <base>Glib::Object</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~Timeline</name>
      <anchorfile>classClutter_1_1Timeline.html</anchorfile>
      <anchor>ad4721f3bec3687a23ade5c6e7f89fd29</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>ClutterTimeline *</type>
      <name>gobj</name>
      <anchorfile>classClutter_1_1Timeline.html</anchorfile>
      <anchor>a774608e7456d6c8a79a4644c87063836</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const ClutterTimeline *</type>
      <name>gobj</name>
      <anchorfile>classClutter_1_1Timeline.html</anchorfile>
      <anchor>a3b40f76f0f0d8b9ed6e72ea6488ccdfe</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>ClutterTimeline *</type>
      <name>gobj_copy</name>
      <anchorfile>classClutter_1_1Timeline.html</anchorfile>
      <anchor>ab6988a85db1beac3f98cc1e60fefa708</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Timeline &gt;</type>
      <name>clone</name>
      <anchorfile>classClutter_1_1Timeline.html</anchorfile>
      <anchor>a9ba1e38b560c5feb62e90c6338a83acc</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_duration</name>
      <anchorfile>classClutter_1_1Timeline.html</anchorfile>
      <anchor>ad8c43125912bfacf4b10c2c39eeca59f</anchor>
      <arglist>(guint msecs)</arglist>
    </member>
    <member kind="function">
      <type>guint</type>
      <name>get_duration</name>
      <anchorfile>classClutter_1_1Timeline.html</anchorfile>
      <anchor>a5169950c7b23240538e38865c5295d03</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>start</name>
      <anchorfile>classClutter_1_1Timeline.html</anchorfile>
      <anchor>a4705415f0b8794b53f4501793f6c6e3e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>pause</name>
      <anchorfile>classClutter_1_1Timeline.html</anchorfile>
      <anchor>a9bd25532f5df08aa6be178e052f6aa7a</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>stop</name>
      <anchorfile>classClutter_1_1Timeline.html</anchorfile>
      <anchor>af16bf65c664fda2aa1d00e3907437ff8</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>rewind</name>
      <anchorfile>classClutter_1_1Timeline.html</anchorfile>
      <anchor>a6b5e39888613890fd8ccdbbc404edd50</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_loop</name>
      <anchorfile>classClutter_1_1Timeline.html</anchorfile>
      <anchor>aef454d18ff75a9a0388dfcf2d99e1cba</anchor>
      <arglist>(bool loop=true)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_loop</name>
      <anchorfile>classClutter_1_1Timeline.html</anchorfile>
      <anchor>a11e13f91ee366cf2346f424a3b1f1a95</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>skip</name>
      <anchorfile>classClutter_1_1Timeline.html</anchorfile>
      <anchor>a35d88b59418dfda25511508d2761ee6f</anchor>
      <arglist>(guint n_frames)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>advance</name>
      <anchorfile>classClutter_1_1Timeline.html</anchorfile>
      <anchor>a9cc86163630ba59ad9fe05b9cb221e4c</anchor>
      <arglist>(guint frame_num)</arglist>
    </member>
    <member kind="function">
      <type>guint</type>
      <name>get_delta</name>
      <anchorfile>classClutter_1_1Timeline.html</anchorfile>
      <anchor>a8661985ba1a1f36411aa3a94be992366</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_playing</name>
      <anchorfile>classClutter_1_1Timeline.html</anchorfile>
      <anchor>a70ab61e41fb4b3f38d5ce5928940bfa1</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_delay</name>
      <anchorfile>classClutter_1_1Timeline.html</anchorfile>
      <anchor>a6bc0c5c59d015755017db83a63e9ddfc</anchor>
      <arglist>(guint msecs)</arglist>
    </member>
    <member kind="function">
      <type>guint</type>
      <name>get_delay</name>
      <anchorfile>classClutter_1_1Timeline.html</anchorfile>
      <anchor>a12551d57491a58236b05dfa4b37ba06f</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>guint</type>
      <name>get_elapsed_time</name>
      <anchorfile>classClutter_1_1Timeline.html</anchorfile>
      <anchor>ad229be85733bb7de5d897f83026920a2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>get_progress</name>
      <anchorfile>classClutter_1_1Timeline.html</anchorfile>
      <anchor>a4cb870e110850dd6a5dadb1d63803999</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_direction</name>
      <anchorfile>classClutter_1_1Timeline.html</anchorfile>
      <anchor>abab82052e5c8495db087f28cfc77a890</anchor>
      <arglist>(TimelineDirection direction)</arglist>
    </member>
    <member kind="function">
      <type>TimelineDirection</type>
      <name>get_direction</name>
      <anchorfile>classClutter_1_1Timeline.html</anchorfile>
      <anchor>a693c9fb087f0a4165abda8c0c96e3c1f</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>std::vector&lt; Glib::ustring &gt;</type>
      <name>list_markers</name>
      <anchorfile>classClutter_1_1Timeline.html</anchorfile>
      <anchor>a11a69919c595c4c8c9307966b1c36dfd</anchor>
      <arglist>(int frame_num) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>add_marker_at_time</name>
      <anchorfile>classClutter_1_1Timeline.html</anchorfile>
      <anchor>aaec3a04f6188897576c6cf3ae9e72751</anchor>
      <arglist>(const Glib::ustring &amp;marker_name, guint msecs)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>has_marker</name>
      <anchorfile>classClutter_1_1Timeline.html</anchorfile>
      <anchor>a17e95ad907a99a8d05fd4272111b0055</anchor>
      <arglist>(const Glib::ustring &amp;marker_name)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>remove_marker</name>
      <anchorfile>classClutter_1_1Timeline.html</anchorfile>
      <anchor>a8a564f9bcf76f144b39b7a5abdf8bb74</anchor>
      <arglist>(const Glib::ustring &amp;marker_name)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>advance_to_marker</name>
      <anchorfile>classClutter_1_1Timeline.html</anchorfile>
      <anchor>afb9585019042c8e035aa2795964f0347</anchor>
      <arglist>(const Glib::ustring &amp;marker_name)</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; guint &gt;</type>
      <name>property_delay</name>
      <anchorfile>classClutter_1_1Timeline.html</anchorfile>
      <anchor>a0f9606316291a086ff478cf00499b760</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; guint &gt;</type>
      <name>property_delay</name>
      <anchorfile>classClutter_1_1Timeline.html</anchorfile>
      <anchor>afd3c8bb3c89ddcb6ded85228b2ad6996</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; TimelineDirection &gt;</type>
      <name>property_direction</name>
      <anchorfile>classClutter_1_1Timeline.html</anchorfile>
      <anchor>abedd28cad6a70aba8cda0f07784907ee</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; TimelineDirection &gt;</type>
      <name>property_direction</name>
      <anchorfile>classClutter_1_1Timeline.html</anchorfile>
      <anchor>a34b5ac43754d2a4fd26a6c1452e5c961</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; guint &gt;</type>
      <name>property_duration</name>
      <anchorfile>classClutter_1_1Timeline.html</anchorfile>
      <anchor>a4015f0db07a176b2edc0f4beeb1dca6e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; guint &gt;</type>
      <name>property_duration</name>
      <anchorfile>classClutter_1_1Timeline.html</anchorfile>
      <anchor>ae63c28faf00b2fee591bb701610e2b56</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; bool &gt;</type>
      <name>property_loop</name>
      <anchorfile>classClutter_1_1Timeline.html</anchorfile>
      <anchor>ac82484c4f092bb17d9aa6972dfd87bcd</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; bool &gt;</type>
      <name>property_loop</name>
      <anchorfile>classClutter_1_1Timeline.html</anchorfile>
      <anchor>a39c8de709ce7127042487eaf2c8192ab</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy0&lt; void &gt;</type>
      <name>signal_completed</name>
      <anchorfile>classClutter_1_1Timeline.html</anchorfile>
      <anchor>a5692631a5d72cd66aecb6ff5c57fdd7f</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy1&lt; void, int &gt;</type>
      <name>signal_new_frame</name>
      <anchorfile>classClutter_1_1Timeline.html</anchorfile>
      <anchor>ae7d2e626e399af7cc57a5f3af5361ba7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy0&lt; void &gt;</type>
      <name>signal_paused</name>
      <anchorfile>classClutter_1_1Timeline.html</anchorfile>
      <anchor>a23eb2bac42a20ff97c4105ecee649dca</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy0&lt; void &gt;</type>
      <name>signal_started</name>
      <anchorfile>classClutter_1_1Timeline.html</anchorfile>
      <anchor>a84323ff18f6ac1ee4cf590c5051eeef3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy2&lt; void, const Glib::ustring &amp;, int &gt;</type>
      <name>signal_marker_reached</name>
      <anchorfile>classClutter_1_1Timeline.html</anchorfile>
      <anchor>a0a2eb9082d5790a87f5965be3ed4d892</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; Timeline &gt;</type>
      <name>create</name>
      <anchorfile>classClutter_1_1Timeline.html</anchorfile>
      <anchor>a1d7902c25b5924839b83b4d57fb0131c</anchor>
      <arglist>(guint msecs)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>Timeline</name>
      <anchorfile>classClutter_1_1Timeline.html</anchorfile>
      <anchor>a3d17a5dd910962d859e6cdae17c1e514</anchor>
      <arglist>(guint msecs)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>on_completed</name>
      <anchorfile>classClutter_1_1Timeline.html</anchorfile>
      <anchor>a4ba93f7d9107ea5475f30b1a7b0f2b8a</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>on_new_frame</name>
      <anchorfile>classClutter_1_1Timeline.html</anchorfile>
      <anchor>a0232218456636886cb25cb7e8915ae88</anchor>
      <arglist>(int fram_num)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>on_paused</name>
      <anchorfile>classClutter_1_1Timeline.html</anchorfile>
      <anchor>afd04c379a8a95a5b4382923e04b82510</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>on_started</name>
      <anchorfile>classClutter_1_1Timeline.html</anchorfile>
      <anchor>a44e17abd3e3252c836b5bd80c77a3e1c</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>on_marker_reached</name>
      <anchorfile>classClutter_1_1Timeline.html</anchorfile>
      <anchor>a971d11f9293014a5336bca1600358371</anchor>
      <arglist>(const Glib::ustring &amp;marker_name, int frame_num)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Clutter::Timeline &gt;</type>
      <name>wrap</name>
      <anchorfile>classClutter_1_1Timeline.html</anchorfile>
      <anchor>aa67ac9dd597a386da4a550bbe7574656</anchor>
      <arglist>(ClutterTimeline *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Clutter::InitError</name>
    <filename>classClutter_1_1InitError.html</filename>
    <base>Glib::Error</base>
    <member kind="enumeration">
      <name>Code</name>
      <anchorfile>classClutter_1_1InitError.html</anchorfile>
      <anchor>aefa5dfadc5378186b670449f39af7468</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>INIT_SUCCESS</name>
      <anchorfile>classClutter_1_1InitError.html</anchorfile>
      <anchor>aefa5dfadc5378186b670449f39af7468a015dc494a2728900569360d1cceb03f0</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNKNOWN</name>
      <anchorfile>classClutter_1_1InitError.html</anchorfile>
      <anchor>aefa5dfadc5378186b670449f39af7468ae8ca1cde83f0a8d5c03f83b75256d24b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>THREADS</name>
      <anchorfile>classClutter_1_1InitError.html</anchorfile>
      <anchor>aefa5dfadc5378186b670449f39af7468aade8c2729eddcf987cfba8e9a89e6a10</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>BACKEND</name>
      <anchorfile>classClutter_1_1InitError.html</anchorfile>
      <anchor>aefa5dfadc5378186b670449f39af7468a8fdfd9bb5a2914978f7370b0711057ec</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>INTERNAL</name>
      <anchorfile>classClutter_1_1InitError.html</anchorfile>
      <anchor>aefa5dfadc5378186b670449f39af7468ab78ce12b1bb7d989d550c6ab2ae0cca3</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>InitError</name>
      <anchorfile>classClutter_1_1InitError.html</anchorfile>
      <anchor>a5e72655b3bef31f24bc0bba0be6fa11b</anchor>
      <arglist>(Code error_code, const Glib::ustring &amp;error_message)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>InitError</name>
      <anchorfile>classClutter_1_1InitError.html</anchorfile>
      <anchor>abe3fc0ae0a678d5b7848f284cbe30c01</anchor>
      <arglist>(GError *gobject)</arglist>
    </member>
    <member kind="function">
      <type>Code</type>
      <name>code</name>
      <anchorfile>classClutter_1_1InitError.html</anchorfile>
      <anchor>afaa714c0e49c3efb7da59839f1df5b1e</anchor>
      <arglist>() const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Clutter::Vertex</name>
    <filename>classClutter_1_1Vertex.html</filename>
    <member kind="function">
      <type></type>
      <name>Vertex</name>
      <anchorfile>classClutter_1_1Vertex.html</anchorfile>
      <anchor>a26956f5612df9f3d11dde7178c56ea74</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Vertex</name>
      <anchorfile>classClutter_1_1Vertex.html</anchorfile>
      <anchor>a06480308f14dbb2b0d38857cefd222df</anchor>
      <arglist>(const ClutterVertex *gobject)</arglist>
    </member>
    <member kind="function">
      <type>ClutterVertex *</type>
      <name>gobj</name>
      <anchorfile>classClutter_1_1Vertex.html</anchorfile>
      <anchor>aa464b141edc5d32418d7fc5c6c70ff85</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const ClutterVertex *</type>
      <name>gobj</name>
      <anchorfile>classClutter_1_1Vertex.html</anchorfile>
      <anchor>a67f8710a35b04463325a33e3ece5157e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Vertex</name>
      <anchorfile>classClutter_1_1Vertex.html</anchorfile>
      <anchor>a8a074f11519b0e87f5b77c80bb88af26</anchor>
      <arglist>(float x, float y, float z=0)</arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>get_x</name>
      <anchorfile>classClutter_1_1Vertex.html</anchorfile>
      <anchor>affcb5ff489972450660fca2e27216456</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_x</name>
      <anchorfile>classClutter_1_1Vertex.html</anchorfile>
      <anchor>ac592369851f596ec40627c413edfe4bc</anchor>
      <arglist>(const float &amp;value)</arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>get_y</name>
      <anchorfile>classClutter_1_1Vertex.html</anchorfile>
      <anchor>abc6766d5f76ddd5be1ebd567aef954a1</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_y</name>
      <anchorfile>classClutter_1_1Vertex.html</anchorfile>
      <anchor>ac3f368ba327ae2a3fb7a8e0187187dea</anchor>
      <arglist>(const float &amp;value)</arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>get_z</name>
      <anchorfile>classClutter_1_1Vertex.html</anchorfile>
      <anchor>a4e1f29b3952fa11ebdabbde8c2f1cf59</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_z</name>
      <anchorfile>classClutter_1_1Vertex.html</anchorfile>
      <anchor>aa5e4c884eed2bda112c18427ea14d47d</anchor>
      <arglist>(const float &amp;value)</arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>ClutterVertex</type>
      <name>gobject_</name>
      <anchorfile>classClutter_1_1Vertex.html</anchorfile>
      <anchor>ab569e5e5d974c93643fe27134462933c</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>Clutter::Vertex &amp;</type>
      <name>wrap</name>
      <anchorfile>classClutter_1_1Vertex.html</anchorfile>
      <anchor>a1574cf755e50dbb325bde1d70cab9ef2</anchor>
      <arglist>(ClutterVertex *object)</arglist>
    </member>
    <member kind="function">
      <type>const Clutter::Vertex &amp;</type>
      <name>wrap</name>
      <anchorfile>classClutter_1_1Vertex.html</anchorfile>
      <anchor>a7e4c2ab0b2dfa2dd4a06a70301c787f7</anchor>
      <arglist>(const ClutterVertex *object)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Clutter::Geometry</name>
    <filename>classClutter_1_1Geometry.html</filename>
    <member kind="function">
      <type></type>
      <name>Geometry</name>
      <anchorfile>classClutter_1_1Geometry.html</anchorfile>
      <anchor>a4d5fbbb1d0e22c55ae5b2b673922790a</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Geometry</name>
      <anchorfile>classClutter_1_1Geometry.html</anchorfile>
      <anchor>ae31fe27612cdcea1731b1d5aa7d53b67</anchor>
      <arglist>(const ClutterGeometry *gobject)</arglist>
    </member>
    <member kind="function">
      <type>ClutterGeometry *</type>
      <name>gobj</name>
      <anchorfile>classClutter_1_1Geometry.html</anchorfile>
      <anchor>aff78890d5bbd9a7627144249a6e1cc28</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const ClutterGeometry *</type>
      <name>gobj</name>
      <anchorfile>classClutter_1_1Geometry.html</anchorfile>
      <anchor>a1d02f086781c64f1821f16ce03c1470d</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Geometry</name>
      <anchorfile>classClutter_1_1Geometry.html</anchorfile>
      <anchor>a9373d7f6f153fd0df4c567efb8d77988</anchor>
      <arglist>(int x, int y, guint width=0, guint height=0)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>get_x</name>
      <anchorfile>classClutter_1_1Geometry.html</anchorfile>
      <anchor>ad520637d362e6c5d10f94e614bfd7e38</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_x</name>
      <anchorfile>classClutter_1_1Geometry.html</anchorfile>
      <anchor>a81958dfae5c23adfe014b91d0b7a58bd</anchor>
      <arglist>(int x)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>get_y</name>
      <anchorfile>classClutter_1_1Geometry.html</anchorfile>
      <anchor>ae375ca5daef154adeeeb4fe511890252</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_y</name>
      <anchorfile>classClutter_1_1Geometry.html</anchorfile>
      <anchor>a8617b0d59e3b4a3334efea55d7b6c9c0</anchor>
      <arglist>(int y)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_xy</name>
      <anchorfile>classClutter_1_1Geometry.html</anchorfile>
      <anchor>a980420d30b80a8bbbcd964fbc3b1fe42</anchor>
      <arglist>(int x, int y)</arglist>
    </member>
    <member kind="function">
      <type>guint</type>
      <name>get_width</name>
      <anchorfile>classClutter_1_1Geometry.html</anchorfile>
      <anchor>a0eb8165ca7216892ec5d563058311823</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_width</name>
      <anchorfile>classClutter_1_1Geometry.html</anchorfile>
      <anchor>ac6114df6bd604b792caf028a43d5a238</anchor>
      <arglist>(guint width)</arglist>
    </member>
    <member kind="function">
      <type>guint</type>
      <name>get_height</name>
      <anchorfile>classClutter_1_1Geometry.html</anchorfile>
      <anchor>ae235a26cae68ce3f9baa57bc0a693c42</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_height</name>
      <anchorfile>classClutter_1_1Geometry.html</anchorfile>
      <anchor>ad8de2febddb34fe0c6ddf5987d44de5d</anchor>
      <arglist>(guint height)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_size</name>
      <anchorfile>classClutter_1_1Geometry.html</anchorfile>
      <anchor>a197d6a0f73ac792aa78b0f9361c9a5e4</anchor>
      <arglist>(guint width, guint height)</arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>ClutterGeometry</type>
      <name>gobject_</name>
      <anchorfile>classClutter_1_1Geometry.html</anchorfile>
      <anchor>ae19de813a598e013c6b4d2791fb9eaed</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>Clutter::Geometry &amp;</type>
      <name>wrap</name>
      <anchorfile>classClutter_1_1Geometry.html</anchorfile>
      <anchor>ac8b49d34e2a341190d3dcfadb33c9b07</anchor>
      <arglist>(ClutterGeometry *object)</arglist>
    </member>
    <member kind="function">
      <type>const Clutter::Geometry &amp;</type>
      <name>wrap</name>
      <anchorfile>classClutter_1_1Geometry.html</anchorfile>
      <anchor>afb885c653109e6cbd59ce502250b7ce9</anchor>
      <arglist>(const ClutterGeometry *object)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Clutter::Knot</name>
    <filename>classClutter_1_1Knot.html</filename>
    <member kind="function">
      <type></type>
      <name>Knot</name>
      <anchorfile>classClutter_1_1Knot.html</anchorfile>
      <anchor>a365a5d6716a9188c9fc323b4d3adcb40</anchor>
      <arglist>(ClutterKnot *gobject, bool make_a_copy=true)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Knot</name>
      <anchorfile>classClutter_1_1Knot.html</anchorfile>
      <anchor>a063f502488329ee9516aead2514bf39e</anchor>
      <arglist>(const Knot &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>Knot &amp;</type>
      <name>operator=</name>
      <anchorfile>classClutter_1_1Knot.html</anchorfile>
      <anchor>a813edbaddd989a270e308c22cfb3a8b9</anchor>
      <arglist>(const Knot &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~Knot</name>
      <anchorfile>classClutter_1_1Knot.html</anchorfile>
      <anchor>aa0f1acacf6b5fab71450d064097b4b2c</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>swap</name>
      <anchorfile>classClutter_1_1Knot.html</anchorfile>
      <anchor>a18d4e834550ebc34f985d43cbc39efa2</anchor>
      <arglist>(Knot &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>ClutterKnot *</type>
      <name>gobj</name>
      <anchorfile>classClutter_1_1Knot.html</anchorfile>
      <anchor>a49a8e44b87aeedb05579b878e03b6348</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const ClutterKnot *</type>
      <name>gobj</name>
      <anchorfile>classClutter_1_1Knot.html</anchorfile>
      <anchor>a1a4805434b2e7f6bc11dce08ec3c1494</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>ClutterKnot *</type>
      <name>gobj_copy</name>
      <anchorfile>classClutter_1_1Knot.html</anchorfile>
      <anchor>a8c291542f4d214a78ad6efff788f25d5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Knot</name>
      <anchorfile>classClutter_1_1Knot.html</anchorfile>
      <anchor>afe0d0f13c7e867b0d2b0230831762966</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Knot</name>
      <anchorfile>classClutter_1_1Knot.html</anchorfile>
      <anchor>acdc015ae640f83aab3479ba6aa768e00</anchor>
      <arglist>(int x, int y)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>get_x</name>
      <anchorfile>classClutter_1_1Knot.html</anchorfile>
      <anchor>acf814dfb7e48f827e49bcd926a1a5d51</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_x</name>
      <anchorfile>classClutter_1_1Knot.html</anchorfile>
      <anchor>a1ee05fa16c03a570138ae931484a0bc8</anchor>
      <arglist>(int x)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>get_y</name>
      <anchorfile>classClutter_1_1Knot.html</anchorfile>
      <anchor>a9cce3ffcda25971bfadeed054f1de339</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_y</name>
      <anchorfile>classClutter_1_1Knot.html</anchorfile>
      <anchor>a3afa5d2d9c347155d79ca359f7ae3af4</anchor>
      <arglist>(int y)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_xy</name>
      <anchorfile>classClutter_1_1Knot.html</anchorfile>
      <anchor>abb3cdfd06e33003ea307086fc2e784d9</anchor>
      <arglist>(int x, int y)</arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>ClutterKnot *</type>
      <name>gobject_</name>
      <anchorfile>classClutter_1_1Knot.html</anchorfile>
      <anchor>a1c3a03a5c8e04ee8319a4fb1321b77e3</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchorfile>classClutter_1_1Knot.html</anchorfile>
      <anchor>ac43c5dd626717c4b890f653c095a5140</anchor>
      <arglist>(const Knot &amp;lhs, const Knot &amp;rhs)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator!=</name>
      <anchorfile>classClutter_1_1Knot.html</anchorfile>
      <anchor>af3d77277d38106b4b731ab551ff78064</anchor>
      <arglist>(const Knot &amp;lhs, const Knot &amp;rhs)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>swap</name>
      <anchorfile>classClutter_1_1Knot.html</anchorfile>
      <anchor>a3c4443b750e507642291b24199a24aff</anchor>
      <arglist>(Knot &amp;lhs, Knot &amp;rhs)</arglist>
    </member>
    <member kind="function">
      <type>Clutter::Knot</type>
      <name>wrap</name>
      <anchorfile>classClutter_1_1Knot.html</anchorfile>
      <anchor>ac06eeba7f1136a12e402c8773539e928</anchor>
      <arglist>(ClutterKnot *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="namespace">
    <name>Clutter::Cairo</name>
    <filename>namespaceClutter_1_1Cairo.html</filename>
    <class kind="class">Clutter::Cairo::Texture</class>
    <member kind="function">
      <type>void</type>
      <name>set_source_color</name>
      <anchorfile>namespaceClutter_1_1Cairo.html</anchorfile>
      <anchor>ad3eb24ca32459c6fba775e405a8e8037</anchor>
      <arglist>(Glib::RefPtr&lt; ::Cairo::Context &gt; &amp;context,::Clutter::Color color)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Clutter::Cairo::Texture</name>
    <filename>classClutter_1_1Cairo_1_1Texture.html</filename>
    <base>Clutter::Texture</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~Texture</name>
      <anchorfile>classClutter_1_1Cairo_1_1Texture.html</anchorfile>
      <anchor>a6eb2a5d2b680c83e36372037bcfdf783</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>ClutterCairoTexture *</type>
      <name>gobj</name>
      <anchorfile>classClutter_1_1Cairo_1_1Texture.html</anchorfile>
      <anchor>af15edae7b2ccabfa770cbf455f2976f7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const ClutterCairoTexture *</type>
      <name>gobj</name>
      <anchorfile>classClutter_1_1Cairo_1_1Texture.html</anchorfile>
      <anchor>ab12ea5ba4c80f45720de8c1a29262ff2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>ClutterCairoTexture *</type>
      <name>gobj_copy</name>
      <anchorfile>classClutter_1_1Cairo_1_1Texture.html</anchorfile>
      <anchor>a3b0fbb8521e101152fbeb63bcea08c0e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>clear</name>
      <anchorfile>classClutter_1_1Cairo_1_1Texture.html</anchorfile>
      <anchor>ab6e1eba9c310889d155b5fd5cb99fe31</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_surface_size</name>
      <anchorfile>classClutter_1_1Cairo_1_1Texture.html</anchorfile>
      <anchor>a2498562074780cc222dd630c951072f8</anchor>
      <arglist>(guint width, guint height)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>get_surface_size</name>
      <anchorfile>classClutter_1_1Cairo_1_1Texture.html</anchorfile>
      <anchor>a9c1213aa3c057921566410fabd86e751</anchor>
      <arglist>(guint &amp;width, guint &amp;height) const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; ::Cairo::Context &gt;</type>
      <name>create_context</name>
      <anchorfile>classClutter_1_1Cairo_1_1Texture.html</anchorfile>
      <anchor>ab2bcde45801458830519ff9a80c36c20</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; ::Cairo::Context &gt;</type>
      <name>create_context_region</name>
      <anchorfile>classClutter_1_1Cairo_1_1Texture.html</anchorfile>
      <anchor>a517e732566bafa3d64294c5ad0c7aafc</anchor>
      <arglist>(int x_offset, int y_offset, int width, int height)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; Texture &gt;</type>
      <name>create</name>
      <anchorfile>classClutter_1_1Cairo_1_1Texture.html</anchorfile>
      <anchor>a1b90eaa889a902f04135e4c24e0d5cdd</anchor>
      <arglist>(guint surface_width, guint surface_height)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>Texture</name>
      <anchorfile>classClutter_1_1Cairo_1_1Texture.html</anchorfile>
      <anchor>a707fc87c4a4c67e3f2c8a15ae5b1acbb</anchor>
      <arglist>(guint surface_width, guint surface_height)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Clutter::Cairo::Texture &gt;</type>
      <name>wrap</name>
      <anchorfile>classClutter_1_1Cairo_1_1Texture.html</anchorfile>
      <anchor>a1c88deda06e0ee9034480b92b653a340</anchor>
      <arglist>(ClutterCairoTexture *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="namespace">
    <name>Cogl</name>
    <filename>namespaceCogl.html</filename>
    <member kind="typedef">
      <type>CoglAngle</type>
      <name>Angle</name>
      <anchorfile>namespaceCogl.html</anchorfile>
      <anchor>aa0c1e757cf3e14fc718aa090d5af2ec9</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>CoglFixed</type>
      <name>Fixed</name>
      <anchorfile>namespaceCogl.html</anchorfile>
      <anchor>afa1773baa39b006c5976bb85ed06eaaf</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="namespace">
    <name>Glib</name>
    <filename>namespaceGlib.html</filename>
  </compound>
</tagfile>
