// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _CLUTTERMM_BEHAVIOUR_H
#define _CLUTTERMM_BEHAVIOUR_H


#include <glibmm.h>

/* Copyright (C) 2007 The cluttermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <cluttermm/alpha.h>
#include <cluttermm/actor.h>
 

#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _ClutterBehaviour ClutterBehaviour;
typedef struct _ClutterBehaviourClass ClutterBehaviourClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Clutter
{ class Behaviour_Class; } // namespace Clutter
namespace Clutter
{


class Behaviour : public Glib::Object
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef Behaviour CppObjectType;
  typedef Behaviour_Class CppClassType;
  typedef ClutterBehaviour BaseObjectType;
  typedef ClutterBehaviourClass BaseClassType;

private:  friend class Behaviour_Class;
  static CppClassType behaviour_class_;

private:
  // noncopyable
  Behaviour(const Behaviour&);
  Behaviour& operator=(const Behaviour&);

protected:
  explicit Behaviour(const Glib::ConstructParams& construct_params);
  explicit Behaviour(ClutterBehaviour* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~Behaviour();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  ClutterBehaviour*       gobj()       { return reinterpret_cast<ClutterBehaviour*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const ClutterBehaviour* gobj() const { return reinterpret_cast<ClutterBehaviour*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  ClutterBehaviour* gobj_copy();

private:


protected:
  Behaviour();

public:
  //There is no create() because this is an abstract base class.
  //_WRAP_CREATE()

  
  void apply(const Glib::RefPtr<Actor>& actor);
  
  void remove(const Glib::RefPtr<Actor>& actor);
  
  /** Removes every actor from the list that @a behave holds.
   * 
   * Since: 0.4
   */
  void remove_all();
  
  bool is_applied(const Glib::RefPtr<Actor>& actor);

 
  Glib::SListHandle<Glib::RefPtr<Actor> > get_actors();
  
  Glib::SListHandle<Glib::RefPtr<const Actor> > get_actors() const;

  
  int get_n_actors() const;

  
  Glib::RefPtr<Actor> get_nth_actor(int index);
  
  Glib::RefPtr<const Actor> get_nth_actor(int index) const;

  
  Glib::RefPtr<Alpha> get_alpha();
  
  Glib::RefPtr<const Alpha> get_alpha() const;

  
  void set_alpha(const Glib::RefPtr<Alpha>& alpha);

  // TODO: does this need the 'behaviour' argument, or could that be
  // approximated with an Object-oriented 'this' pointer?
  /** For instance, 
   * void on_foreach(const Glib::RefPtr<Behaviour>& behaviour, const Glib::RefPtr<Actor>& actor)
   */
  typedef sigc::slot<void, const Glib::RefPtr<Behaviour>&, const Glib::RefPtr<Actor>&> SlotForEach;

  void actors_foreach(const SlotForEach& slot);
  

  /**
   * @par Prototype:
   * <tt>void on_my_%applied(const Glib::RefPtr<Actor>& actor)</tt>
   */

  Glib::SignalProxy1< void,const Glib::RefPtr<Actor>& > signal_applied();

  
  /**
   * @par Prototype:
   * <tt>void on_my_%removed(const Glib::RefPtr<Actor>& actor)</tt>
   */

  Glib::SignalProxy1< void,const Glib::RefPtr<Actor>& > signal_removed();


protected:
  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual void alpha_notify_vfunc(double alpha_value);
#endif //GLIBMM_VFUNCS_ENABLED


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
  virtual void on_applied(const Glib::RefPtr<Actor>& actor);
  virtual void on_removed(const Glib::RefPtr<Actor>& actor);
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


};

} // namespace Clutter
// vim:ts=2,sw=2


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Clutter::Behaviour
   */
  Glib::RefPtr<Clutter::Behaviour> wrap(ClutterBehaviour* object, bool take_copy = false);
}


#endif /* _CLUTTERMM_BEHAVIOUR_H */

