/* cheese-preferences.c generated by valac 0.20.1.61-8f308, the Vala compiler
 * generated from cheese-preferences.vala, do not modify */

/*
 * Copyright © 2010 Yuvaraj Pandian T <yuvipanda@yuvi.in>
 * Copyright © 2010 daniel g. siegel <dgsiegel@gnome.org>
 * Copyright © 2008 Filippo Argiolas <filippo.argiolas@gmail.com>
 *
 * Licensed under the GNU General Public License Version 2
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <cheese-camera.h>
#include <gio/gio.h>
#include <gtk/gtk.h>
#include <cheese-fileutil.h>
#include <cheese-config.h>
#include <float.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>
#include <cheese-camera-device.h>
#include <gdk/gdk.h>


#define CHEESE_TYPE_PREFERENCES_DIALOG (cheese_preferences_dialog_get_type ())
#define CHEESE_PREFERENCES_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CHEESE_TYPE_PREFERENCES_DIALOG, CheesePreferencesDialog))
#define CHEESE_PREFERENCES_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CHEESE_TYPE_PREFERENCES_DIALOG, CheesePreferencesDialogClass))
#define CHEESE_IS_PREFERENCES_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CHEESE_TYPE_PREFERENCES_DIALOG))
#define CHEESE_IS_PREFERENCES_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CHEESE_TYPE_PREFERENCES_DIALOG))
#define CHEESE_PREFERENCES_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CHEESE_TYPE_PREFERENCES_DIALOG, CheesePreferencesDialogClass))

typedef struct _CheesePreferencesDialog CheesePreferencesDialog;
typedef struct _CheesePreferencesDialogClass CheesePreferencesDialogClass;
typedef struct _CheesePreferencesDialogPrivate CheesePreferencesDialogPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block1Data Block1Data;
typedef struct _Block2Data Block2Data;

struct _CheesePreferencesDialog {
	GObject parent_instance;
	CheesePreferencesDialogPrivate * priv;
};

struct _CheesePreferencesDialogClass {
	GObjectClass parent_class;
};

struct _CheesePreferencesDialogPrivate {
	CheeseCamera* camera;
	GSettings* settings;
	GtkDialog* dialog;
	GtkComboBox* photo_resolution_combo;
	GtkComboBox* video_resolution_combo;
	GtkComboBox* source_combo;
	GtkListStore* camera_model;
	GtkAdjustment* brightness_adjustment;
	GtkAdjustment* contrast_adjustment;
	GtkAdjustment* hue_adjustment;
	GtkAdjustment* saturation_adjustment;
	GtkScale* brightness_scale;
	GtkScale* contrast_scale;
	GtkScale* hue_scale;
	GtkScale* saturation_scale;
	GtkSpinButton* burst_repeat_spin;
	GtkSpinButton* burst_delay_spin;
	GtkCheckButton* countdown_check;
	GtkCheckButton* flash_check;
	CheeseMediaMode current_mode;
};

struct _Block1Data {
	int _ref_count_;
	CheesePreferencesDialog * self;
	GtkListStore* resolution_model;
};

struct _Block2Data {
	int _ref_count_;
	CheesePreferencesDialog * self;
	GtkTreeIter iter;
	CheeseCameraDevice* active_device;
	gboolean device_removed;
};


static gpointer cheese_preferences_dialog_parent_class = NULL;

GType cheese_preferences_dialog_get_type (void) G_GNUC_CONST;
#define CHEESE_PREFERENCES_DIALOG_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), CHEESE_TYPE_PREFERENCES_DIALOG, CheesePreferencesDialogPrivate))
enum  {
	CHEESE_PREFERENCES_DIALOG_DUMMY_PROPERTY
};
CheesePreferencesDialog* cheese_preferences_dialog_new (CheeseCamera* camera);
CheesePreferencesDialog* cheese_preferences_dialog_construct (GType object_type, CheeseCamera* camera);
static void cheese_preferences_dialog_setup_combo_box_models (CheesePreferencesDialog* self);
static void cheese_preferences_dialog_initialize_camera_devices (CheesePreferencesDialog* self);
static void cheese_preferences_dialog_initialize_values_from_settings (CheesePreferencesDialog* self);
static void cheese_preferences_dialog_on_camera_update_num_camera_devices (CheesePreferencesDialog* self);
static void _cheese_preferences_dialog_on_camera_update_num_camera_devices_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void cheese_preferences_dialog_add_camera_device (CheesePreferencesDialog* self, void* device);
static void _cheese_preferences_dialog_add_camera_device_gfunc (gconstpointer data, gpointer self);
static void cheese_preferences_dialog_setup_resolutions_for_device (CheesePreferencesDialog* self, CheeseCameraDevice* device);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void __lambda3_ (Block1Data* _data1_, CheeseVideoFormat* format);
static void ___lambda3__gfunc (gconstpointer data, gpointer self);
void cheese_preferences_dialog_on_source_change (GtkComboBox* combo, CheesePreferencesDialog* self);
void cheese_preferences_dialog_on_photo_resolution_change (GtkComboBox* combo, CheesePreferencesDialog* self);
void cheese_preferences_dialog_on_video_resolution_change (GtkComboBox* combo, CheesePreferencesDialog* self);
void cheese_preferences_dialog_on_delete (GtkDialog* dialog, CheesePreferencesDialog* self);
void cheese_preferences_dialog_on_dialog_close (GtkButton* button, CheesePreferencesDialog* self);
void cheese_preferences_dialog_on_dialog_help (GtkButton* button, CheesePreferencesDialog* self);
void cheese_preferences_dialog_on_countdown_toggle (GtkCheckButton* checkbutton, CheesePreferencesDialog* self);
void cheese_preferences_dialog_on_flash_toggle (GtkCheckButton* checkbutton, CheesePreferencesDialog* self);
void cheese_preferences_dialog_on_burst_repeat_change (GtkSpinButton* spinbutton, CheesePreferencesDialog* self);
void cheese_preferences_dialog_on_burst_delay_change (GtkSpinButton* spinbutton, CheesePreferencesDialog* self);
void cheese_preferences_dialog_on_brightness_change (GtkAdjustment* adjustment, CheesePreferencesDialog* self);
void cheese_preferences_dialog_on_contrast_change (GtkAdjustment* adjustment, CheesePreferencesDialog* self);
void cheese_preferences_dialog_on_hue_change (GtkAdjustment* adjustment, CheesePreferencesDialog* self);
void cheese_preferences_dialog_on_saturation_change (GtkAdjustment* adjustment, CheesePreferencesDialog* self);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void ___lambda4_ (Block2Data* _data2_, void* device);
static void cheese_preferences_dialog_remove_camera_device (CheesePreferencesDialog* self, GtkTreeIter* iter, CheeseCameraDevice* device_node, CheeseCameraDevice* active_device_node);
static void ____lambda4__gfunc (gconstpointer data, gpointer self);
static void cheese_preferences_dialog_set_new_available_camera_device (CheesePreferencesDialog* self, GtkTreeIter* iter);
void cheese_preferences_dialog_show (CheesePreferencesDialog* self);
void cheese_preferences_dialog_set_current_mode (CheesePreferencesDialog* self, CheeseMediaMode mode);
static void cheese_preferences_dialog_finalize (GObject* obj);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _cheese_preferences_dialog_on_camera_update_num_camera_devices_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	cheese_preferences_dialog_on_camera_update_num_camera_devices (self);
}


CheesePreferencesDialog* cheese_preferences_dialog_construct (GType object_type, CheeseCamera* camera) {
	CheesePreferencesDialog * self = NULL;
	CheeseCamera* _tmp0_ = NULL;
	CheeseCamera* _tmp1_ = NULL;
	GSettings* _tmp2_ = NULL;
	GtkBuilder* builder = NULL;
	GtkBuilder* _tmp3_ = NULL;
	GObject* _tmp7_ = NULL;
	GtkDialog* _tmp8_ = NULL;
	GObject* _tmp9_ = NULL;
	GtkAdjustment* _tmp10_ = NULL;
	GObject* _tmp11_ = NULL;
	GtkAdjustment* _tmp12_ = NULL;
	GtkAdjustment* _tmp13_ = NULL;
	GtkAdjustment* _tmp14_ = NULL;
	GtkAdjustment* _tmp15_ = NULL;
	GObject* _tmp16_ = NULL;
	GtkAdjustment* _tmp17_ = NULL;
	GObject* _tmp18_ = NULL;
	GtkAdjustment* _tmp19_ = NULL;
	GObject* _tmp20_ = NULL;
	GtkScale* _tmp21_ = NULL;
	GObject* _tmp22_ = NULL;
	GtkScale* _tmp23_ = NULL;
	GObject* _tmp24_ = NULL;
	GtkScale* _tmp25_ = NULL;
	GObject* _tmp26_ = NULL;
	GtkScale* _tmp27_ = NULL;
	GtkScale* _tmp28_ = NULL;
	GtkScale* _tmp29_ = NULL;
	GtkScale* _tmp30_ = NULL;
	GtkScale* _tmp31_ = NULL;
	GObject* _tmp32_ = NULL;
	GtkComboBox* _tmp33_ = NULL;
	GObject* _tmp34_ = NULL;
	GtkComboBox* _tmp35_ = NULL;
	GObject* _tmp36_ = NULL;
	GtkComboBox* _tmp37_ = NULL;
	GObject* _tmp38_ = NULL;
	GtkSpinButton* _tmp39_ = NULL;
	GObject* _tmp40_ = NULL;
	GtkSpinButton* _tmp41_ = NULL;
	GObject* _tmp42_ = NULL;
	GtkCheckButton* _tmp43_ = NULL;
	GObject* _tmp44_ = NULL;
	GtkCheckButton* _tmp45_ = NULL;
	CheeseCamera* _tmp46_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (camera != NULL, NULL);
	self = (CheesePreferencesDialog*) g_object_new (object_type, NULL);
	_tmp0_ = camera;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->camera);
	self->priv->camera = _tmp1_;
	_tmp2_ = g_settings_new ("org.gnome.Cheese");
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp2_;
	_tmp3_ = gtk_builder_new ();
	builder = _tmp3_;
	{
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		_tmp4_ = g_build_filename (PACKAGE_DATADIR, "cheese-prefs.ui", NULL);
		_tmp5_ = _tmp4_;
		gtk_builder_add_from_file (builder, _tmp5_, &_inner_error_);
		_g_free0 (_tmp5_);
		if (_inner_error_ != NULL) {
			goto __catch4_g_error;
		}
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError* err = NULL;
		const gchar* _tmp6_ = NULL;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp6_ = err->message;
		g_error ("cheese-preferences.vala:69: Error: %s", _tmp6_);
		_g_error_free0 (err);
	}
	__finally4:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (builder);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp7_ = gtk_builder_get_object (builder, "cheese_prefs_dialog");
	_tmp8_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, GTK_TYPE_DIALOG) ? ((GtkDialog*) _tmp7_) : NULL);
	_g_object_unref0 (self->priv->dialog);
	self->priv->dialog = _tmp8_;
	_tmp9_ = gtk_builder_get_object (builder, "brightness_adjustment");
	_tmp10_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp9_, GTK_TYPE_ADJUSTMENT) ? ((GtkAdjustment*) _tmp9_) : NULL);
	_g_object_unref0 (self->priv->brightness_adjustment);
	self->priv->brightness_adjustment = _tmp10_;
	_tmp11_ = gtk_builder_get_object (builder, "contrast_adjustment");
	_tmp12_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp11_, GTK_TYPE_ADJUSTMENT) ? ((GtkAdjustment*) _tmp11_) : NULL;
	_tmp13_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp12_, GTK_TYPE_ADJUSTMENT) ? ((GtkAdjustment*) _tmp12_) : NULL;
	_tmp14_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp13_, GTK_TYPE_ADJUSTMENT) ? ((GtkAdjustment*) _tmp13_) : NULL;
	_tmp15_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp14_, GTK_TYPE_ADJUSTMENT) ? ((GtkAdjustment*) _tmp14_) : NULL);
	_g_object_unref0 (self->priv->contrast_adjustment);
	self->priv->contrast_adjustment = _tmp15_;
	_tmp16_ = gtk_builder_get_object (builder, "hue_adjustment");
	_tmp17_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp16_, GTK_TYPE_ADJUSTMENT) ? ((GtkAdjustment*) _tmp16_) : NULL);
	_g_object_unref0 (self->priv->hue_adjustment);
	self->priv->hue_adjustment = _tmp17_;
	_tmp18_ = gtk_builder_get_object (builder, "saturation_adjustment");
	_tmp19_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp18_, GTK_TYPE_ADJUSTMENT) ? ((GtkAdjustment*) _tmp18_) : NULL);
	_g_object_unref0 (self->priv->saturation_adjustment);
	self->priv->saturation_adjustment = _tmp19_;
	_tmp20_ = gtk_builder_get_object (builder, "brightness_scale");
	_tmp21_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp20_, GTK_TYPE_SCALE) ? ((GtkScale*) _tmp20_) : NULL);
	_g_object_unref0 (self->priv->brightness_scale);
	self->priv->brightness_scale = _tmp21_;
	_tmp22_ = gtk_builder_get_object (builder, "contrast_scale");
	_tmp23_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp22_, GTK_TYPE_SCALE) ? ((GtkScale*) _tmp22_) : NULL);
	_g_object_unref0 (self->priv->contrast_scale);
	self->priv->contrast_scale = _tmp23_;
	_tmp24_ = gtk_builder_get_object (builder, "hue_scale");
	_tmp25_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp24_, GTK_TYPE_SCALE) ? ((GtkScale*) _tmp24_) : NULL);
	_g_object_unref0 (self->priv->hue_scale);
	self->priv->hue_scale = _tmp25_;
	_tmp26_ = gtk_builder_get_object (builder, "saturation_scale");
	_tmp27_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp26_, GTK_TYPE_SCALE) ? ((GtkScale*) _tmp26_) : NULL);
	_g_object_unref0 (self->priv->saturation_scale);
	self->priv->saturation_scale = _tmp27_;
	_tmp28_ = self->priv->brightness_scale;
	gtk_scale_add_mark (_tmp28_, (gdouble) 0, GTK_POS_BOTTOM, NULL);
	_tmp29_ = self->priv->contrast_scale;
	gtk_scale_add_mark (_tmp29_, (gdouble) 1, GTK_POS_BOTTOM, NULL);
	_tmp30_ = self->priv->hue_scale;
	gtk_scale_add_mark (_tmp30_, (gdouble) 0, GTK_POS_BOTTOM, NULL);
	_tmp31_ = self->priv->saturation_scale;
	gtk_scale_add_mark (_tmp31_, (gdouble) 1, GTK_POS_BOTTOM, NULL);
	_tmp32_ = gtk_builder_get_object (builder, "photo_resolution_combo_box");
	_tmp33_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp32_, GTK_TYPE_COMBO_BOX) ? ((GtkComboBox*) _tmp32_) : NULL);
	_g_object_unref0 (self->priv->photo_resolution_combo);
	self->priv->photo_resolution_combo = _tmp33_;
	_tmp34_ = gtk_builder_get_object (builder, "video_resolution_combo_box");
	_tmp35_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp34_, GTK_TYPE_COMBO_BOX) ? ((GtkComboBox*) _tmp34_) : NULL);
	_g_object_unref0 (self->priv->video_resolution_combo);
	self->priv->video_resolution_combo = _tmp35_;
	_tmp36_ = gtk_builder_get_object (builder, "camera_combo_box");
	_tmp37_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp36_, GTK_TYPE_COMBO_BOX) ? ((GtkComboBox*) _tmp36_) : NULL);
	_g_object_unref0 (self->priv->source_combo);
	self->priv->source_combo = _tmp37_;
	_tmp38_ = gtk_builder_get_object (builder, "burst_repeat");
	_tmp39_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp38_, GTK_TYPE_SPIN_BUTTON) ? ((GtkSpinButton*) _tmp38_) : NULL);
	_g_object_unref0 (self->priv->burst_repeat_spin);
	self->priv->burst_repeat_spin = _tmp39_;
	_tmp40_ = gtk_builder_get_object (builder, "burst_delay");
	_tmp41_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp40_, GTK_TYPE_SPIN_BUTTON) ? ((GtkSpinButton*) _tmp40_) : NULL);
	_g_object_unref0 (self->priv->burst_delay_spin);
	self->priv->burst_delay_spin = _tmp41_;
	_tmp42_ = gtk_builder_get_object (builder, "countdown");
	_tmp43_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp42_, GTK_TYPE_CHECK_BUTTON) ? ((GtkCheckButton*) _tmp42_) : NULL);
	_g_object_unref0 (self->priv->countdown_check);
	self->priv->countdown_check = _tmp43_;
	_tmp44_ = gtk_builder_get_object (builder, "flash");
	_tmp45_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp44_, GTK_TYPE_CHECK_BUTTON) ? ((GtkCheckButton*) _tmp44_) : NULL);
	_g_object_unref0 (self->priv->flash_check);
	self->priv->flash_check = _tmp45_;
	cheese_preferences_dialog_setup_combo_box_models (self);
	cheese_preferences_dialog_initialize_camera_devices (self);
	cheese_preferences_dialog_initialize_values_from_settings (self);
	gtk_builder_connect_signals (builder, self);
	_tmp46_ = camera;
	g_signal_connect_object ((GObject*) _tmp46_, "notify::num-camera-devices", (GCallback) _cheese_preferences_dialog_on_camera_update_num_camera_devices_g_object_notify, self, 0);
	_g_object_unref0 (builder);
	return self;
}


CheesePreferencesDialog* cheese_preferences_dialog_new (CheeseCamera* camera) {
	return cheese_preferences_dialog_construct (CHEESE_TYPE_PREFERENCES_DIALOG, camera);
}


/**
   * Set up combo box cell renderers.
   */
static void cheese_preferences_dialog_setup_combo_box_models (CheesePreferencesDialog* self) {
	GtkCellRendererText* cell = NULL;
	GtkCellRendererText* _tmp0_ = NULL;
	GtkComboBox* _tmp1_ = NULL;
	GtkComboBox* _tmp2_ = NULL;
	GtkComboBox* _tmp3_ = NULL;
	GtkComboBox* _tmp4_ = NULL;
	GtkComboBox* _tmp5_ = NULL;
	GtkComboBox* _tmp6_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	g_object_ref_sink (_tmp0_);
	cell = _tmp0_;
	_tmp1_ = self->priv->photo_resolution_combo;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp1_, (GtkCellRenderer*) cell, FALSE);
	_tmp2_ = self->priv->photo_resolution_combo;
	gtk_cell_layout_set_attributes ((GtkCellLayout*) _tmp2_, (GtkCellRenderer*) cell, "text", 0, NULL);
	_tmp3_ = self->priv->video_resolution_combo;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp3_, (GtkCellRenderer*) cell, FALSE);
	_tmp4_ = self->priv->video_resolution_combo;
	gtk_cell_layout_set_attributes ((GtkCellLayout*) _tmp4_, (GtkCellRenderer*) cell, "text", 0, NULL);
	_tmp5_ = self->priv->source_combo;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp5_, (GtkCellRenderer*) cell, FALSE);
	_tmp6_ = self->priv->source_combo;
	gtk_cell_layout_set_attributes ((GtkCellLayout*) _tmp6_, (GtkCellRenderer*) cell, "text", 0, NULL);
	_g_object_unref0 (cell);
}


/**
   * Initialize and populate the camera device combo box model.
   */
static void _cheese_preferences_dialog_add_camera_device_gfunc (gconstpointer data, gpointer self) {
	cheese_preferences_dialog_add_camera_device (self, data);
}


static void cheese_preferences_dialog_initialize_camera_devices (CheesePreferencesDialog* self) {
	GPtrArray* devices = NULL;
	CheeseCamera* _tmp0_ = NULL;
	GPtrArray* _tmp1_ = NULL;
	GtkListStore* _tmp2_ = NULL;
	GtkComboBox* _tmp3_ = NULL;
	GtkListStore* _tmp4_ = NULL;
	GtkComboBox* _tmp5_ = NULL;
	GSettings* _tmp6_ = NULL;
	CheeseCamera* _tmp7_ = NULL;
	CheeseCameraDevice* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	CheeseCamera* _tmp10_ = NULL;
	CheeseCameraDevice* _tmp11_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->camera;
	_tmp1_ = cheese_camera_get_camera_devices (_tmp0_);
	devices = _tmp1_;
	_tmp2_ = gtk_list_store_new (2, G_TYPE_STRING, CHEESE_TYPE_CAMERA_DEVICE);
	_g_object_unref0 (self->priv->camera_model);
	self->priv->camera_model = _tmp2_;
	_tmp3_ = self->priv->source_combo;
	_tmp4_ = self->priv->camera_model;
	gtk_combo_box_set_model (_tmp3_, (GtkTreeModel*) _tmp4_);
	_tmp5_ = self->priv->source_combo;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp5_, FALSE);
	g_ptr_array_foreach (devices, _cheese_preferences_dialog_add_camera_device_gfunc, self);
	_tmp6_ = self->priv->settings;
	_tmp7_ = self->priv->camera;
	_tmp8_ = cheese_camera_get_selected_device (_tmp7_);
	_tmp9_ = cheese_camera_device_get_device_node (_tmp8_);
	g_settings_set_string (_tmp6_, "camera", _tmp9_);
	_tmp10_ = self->priv->camera;
	_tmp11_ = cheese_camera_get_selected_device (_tmp10_);
	cheese_preferences_dialog_setup_resolutions_for_device (self, _tmp11_);
}


/**
   * Initialize and populate the resolution combo box models for the device.
   *
   * @param device the Cheese.CameraDevice for which to enumerate resolutions
   */
static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		CheesePreferencesDialog * self;
		self = _data1_->self;
		_g_object_unref0 (_data1_->resolution_model);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}


static void __lambda3_ (Block1Data* _data1_, CheeseVideoFormat* format) {
	CheesePreferencesDialog * self;
	GtkTreeIter iter = {0};
	GtkListStore* _tmp0_ = NULL;
	GtkTreeIter _tmp1_ = {0};
	GtkListStore* _tmp2_ = NULL;
	GtkTreeIter _tmp3_ = {0};
	CheeseVideoFormat* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	CheeseVideoFormat* _tmp10_ = NULL;
	gint _tmp11_ = 0;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
	CheeseVideoFormat* _tmp16_ = NULL;
	gboolean _tmp17_ = FALSE;
	CheeseCamera* _tmp18_ = NULL;
	CheeseVideoFormat* _tmp19_ = NULL;
	gint _tmp20_ = 0;
	CheeseVideoFormat* _tmp21_ = NULL;
	gint _tmp22_ = 0;
	gboolean _tmp28_ = FALSE;
	gboolean _tmp37_ = FALSE;
	GSettings* _tmp38_ = NULL;
	gint _tmp39_ = 0;
	CheeseVideoFormat* _tmp40_ = NULL;
	gint _tmp41_ = 0;
	gboolean _tmp46_ = FALSE;
	self = _data1_->self;
	g_return_if_fail (format != NULL);
	_tmp0_ = _data1_->resolution_model;
	gtk_list_store_append (_tmp0_, &_tmp1_);
	iter = _tmp1_;
	_tmp2_ = _data1_->resolution_model;
	_tmp3_ = iter;
	_tmp4_ = format;
	_tmp5_ = _tmp4_->width;
	_tmp6_ = g_strdup_printf ("%i", _tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strconcat (_tmp7_, " × ", NULL);
	_tmp9_ = _tmp8_;
	_tmp10_ = format;
	_tmp11_ = _tmp10_->height;
	_tmp12_ = g_strdup_printf ("%i", _tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = g_strconcat (_tmp9_, _tmp13_, NULL);
	_tmp15_ = _tmp14_;
	_tmp16_ = format;
	gtk_list_store_set (_tmp2_, &_tmp3_, 0, _tmp15_, 1, _tmp16_, -1);
	_g_free0 (_tmp15_);
	_g_free0 (_tmp13_);
	_g_free0 (_tmp9_);
	_g_free0 (_tmp7_);
	_tmp18_ = self->priv->camera;
	_tmp19_ = cheese_camera_get_current_video_format (_tmp18_);
	_tmp20_ = _tmp19_->width;
	_tmp21_ = format;
	_tmp22_ = _tmp21_->width;
	if (_tmp20_ == _tmp22_) {
		CheeseCamera* _tmp23_ = NULL;
		CheeseVideoFormat* _tmp24_ = NULL;
		gint _tmp25_ = 0;
		CheeseVideoFormat* _tmp26_ = NULL;
		gint _tmp27_ = 0;
		_tmp23_ = self->priv->camera;
		_tmp24_ = cheese_camera_get_current_video_format (_tmp23_);
		_tmp25_ = _tmp24_->height;
		_tmp26_ = format;
		_tmp27_ = _tmp26_->height;
		_tmp17_ = _tmp25_ == _tmp27_;
	} else {
		_tmp17_ = FALSE;
	}
	_tmp28_ = _tmp17_;
	if (_tmp28_) {
		GtkComboBox* _tmp29_ = NULL;
		GtkTreeIter _tmp30_ = {0};
		GSettings* _tmp31_ = NULL;
		CheeseVideoFormat* _tmp32_ = NULL;
		gint _tmp33_ = 0;
		GSettings* _tmp34_ = NULL;
		CheeseVideoFormat* _tmp35_ = NULL;
		gint _tmp36_ = 0;
		_tmp29_ = self->priv->photo_resolution_combo;
		_tmp30_ = iter;
		gtk_combo_box_set_active_iter (_tmp29_, &_tmp30_);
		_tmp31_ = self->priv->settings;
		_tmp32_ = format;
		_tmp33_ = _tmp32_->width;
		g_settings_set_int (_tmp31_, "photo-x-resolution", _tmp33_);
		_tmp34_ = self->priv->settings;
		_tmp35_ = format;
		_tmp36_ = _tmp35_->height;
		g_settings_set_int (_tmp34_, "photo-y-resolution", _tmp36_);
	}
	_tmp38_ = self->priv->settings;
	_tmp39_ = g_settings_get_int (_tmp38_, "video-x-resolution");
	_tmp40_ = format;
	_tmp41_ = _tmp40_->width;
	if (_tmp39_ == _tmp41_) {
		GSettings* _tmp42_ = NULL;
		gint _tmp43_ = 0;
		CheeseVideoFormat* _tmp44_ = NULL;
		gint _tmp45_ = 0;
		_tmp42_ = self->priv->settings;
		_tmp43_ = g_settings_get_int (_tmp42_, "video-y-resolution");
		_tmp44_ = format;
		_tmp45_ = _tmp44_->height;
		_tmp37_ = _tmp43_ == _tmp45_;
	} else {
		_tmp37_ = FALSE;
	}
	_tmp46_ = _tmp37_;
	if (_tmp46_) {
		GtkComboBox* _tmp47_ = NULL;
		GtkTreeIter _tmp48_ = {0};
		_tmp47_ = self->priv->video_resolution_combo;
		_tmp48_ = iter;
		gtk_combo_box_set_active_iter (_tmp47_, &_tmp48_);
	}
}


static void ___lambda3__gfunc (gconstpointer data, gpointer self) {
	__lambda3_ (self, data);
}


static void cheese_preferences_dialog_setup_resolutions_for_device (CheesePreferencesDialog* self, CheeseCameraDevice* device) {
	Block1Data* _data1_;
	GList* formats = NULL;
	CheeseCameraDevice* _tmp0_ = NULL;
	GList* _tmp1_ = NULL;
	GtkListStore* _tmp2_ = NULL;
	GtkComboBox* _tmp3_ = NULL;
	GtkListStore* _tmp4_ = NULL;
	GtkComboBox* _tmp5_ = NULL;
	GtkListStore* _tmp6_ = NULL;
	GList* _tmp7_ = NULL;
	GtkComboBox* _tmp8_ = NULL;
	gint _tmp9_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (device != NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_tmp0_ = device;
	_tmp1_ = cheese_camera_device_get_format_list (_tmp0_);
	formats = _tmp1_;
	_tmp2_ = gtk_list_store_new (2, G_TYPE_STRING, CHEESE_TYPE_VIDEO_FORMAT);
	_data1_->resolution_model = _tmp2_;
	_tmp3_ = self->priv->photo_resolution_combo;
	_tmp4_ = _data1_->resolution_model;
	gtk_combo_box_set_model (_tmp3_, (GtkTreeModel*) _tmp4_);
	_tmp5_ = self->priv->video_resolution_combo;
	_tmp6_ = _data1_->resolution_model;
	gtk_combo_box_set_model (_tmp5_, (GtkTreeModel*) _tmp6_);
	_tmp7_ = formats;
	g_list_foreach (_tmp7_, ___lambda3__gfunc, _data1_);
	_tmp8_ = self->priv->video_resolution_combo;
	_tmp9_ = gtk_combo_box_get_active (_tmp8_);
	if (_tmp9_ == (-1)) {
		GtkComboBox* _tmp10_ = NULL;
		GtkComboBox* _tmp11_ = NULL;
		gint _tmp12_ = 0;
		GSettings* _tmp13_ = NULL;
		GSettings* _tmp14_ = NULL;
		gint _tmp15_ = 0;
		GSettings* _tmp16_ = NULL;
		GSettings* _tmp17_ = NULL;
		gint _tmp18_ = 0;
		_tmp10_ = self->priv->video_resolution_combo;
		_tmp11_ = self->priv->photo_resolution_combo;
		_tmp12_ = gtk_combo_box_get_active (_tmp11_);
		gtk_combo_box_set_active (_tmp10_, _tmp12_);
		_tmp13_ = self->priv->settings;
		_tmp14_ = self->priv->settings;
		_tmp15_ = g_settings_get_int (_tmp14_, "photo-x-resolution");
		g_settings_set_int (_tmp13_, "video-x-resolution", _tmp15_);
		_tmp16_ = self->priv->settings;
		_tmp17_ = self->priv->settings;
		_tmp18_ = g_settings_get_int (_tmp17_, "photo-y-resolution");
		g_settings_set_int (_tmp16_, "video-y-resolution", _tmp18_);
	}
	block1_data_unref (_data1_);
	_data1_ = NULL;
}


/**
   * Take the user preferences from GSettings.
   */
static void cheese_preferences_dialog_initialize_values_from_settings (CheesePreferencesDialog* self) {
	GtkAdjustment* _tmp0_ = NULL;
	GSettings* _tmp1_ = NULL;
	gdouble _tmp2_ = 0.0;
	GtkAdjustment* _tmp3_ = NULL;
	GSettings* _tmp4_ = NULL;
	gdouble _tmp5_ = 0.0;
	GtkAdjustment* _tmp6_ = NULL;
	GSettings* _tmp7_ = NULL;
	gdouble _tmp8_ = 0.0;
	GtkAdjustment* _tmp9_ = NULL;
	GSettings* _tmp10_ = NULL;
	gdouble _tmp11_ = 0.0;
	GtkSpinButton* _tmp12_ = NULL;
	GSettings* _tmp13_ = NULL;
	gint _tmp14_ = 0;
	GtkSpinButton* _tmp15_ = NULL;
	GSettings* _tmp16_ = NULL;
	gint _tmp17_ = 0;
	GtkCheckButton* _tmp18_ = NULL;
	GSettings* _tmp19_ = NULL;
	gboolean _tmp20_ = FALSE;
	GtkCheckButton* _tmp21_ = NULL;
	GSettings* _tmp22_ = NULL;
	gboolean _tmp23_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->brightness_adjustment;
	_tmp1_ = self->priv->settings;
	_tmp2_ = g_settings_get_double (_tmp1_, "brightness");
	gtk_adjustment_set_value (_tmp0_, _tmp2_);
	_tmp3_ = self->priv->contrast_adjustment;
	_tmp4_ = self->priv->settings;
	_tmp5_ = g_settings_get_double (_tmp4_, "contrast");
	gtk_adjustment_set_value (_tmp3_, _tmp5_);
	_tmp6_ = self->priv->hue_adjustment;
	_tmp7_ = self->priv->settings;
	_tmp8_ = g_settings_get_double (_tmp7_, "hue");
	gtk_adjustment_set_value (_tmp6_, _tmp8_);
	_tmp9_ = self->priv->saturation_adjustment;
	_tmp10_ = self->priv->settings;
	_tmp11_ = g_settings_get_double (_tmp10_, "saturation");
	gtk_adjustment_set_value (_tmp9_, _tmp11_);
	_tmp12_ = self->priv->burst_repeat_spin;
	_tmp13_ = self->priv->settings;
	_tmp14_ = g_settings_get_int (_tmp13_, "burst-repeat");
	gtk_spin_button_set_value (_tmp12_, (gdouble) _tmp14_);
	_tmp15_ = self->priv->burst_delay_spin;
	_tmp16_ = self->priv->settings;
	_tmp17_ = g_settings_get_int (_tmp16_, "burst-delay");
	gtk_spin_button_set_value (_tmp15_, (gdouble) (_tmp17_ / 1000));
	_tmp18_ = self->priv->countdown_check;
	_tmp19_ = self->priv->settings;
	_tmp20_ = g_settings_get_boolean (_tmp19_, "countdown");
	gtk_toggle_button_set_active ((GtkToggleButton*) _tmp18_, _tmp20_);
	_tmp21_ = self->priv->flash_check;
	_tmp22_ = self->priv->settings;
	_tmp23_ = g_settings_get_boolean (_tmp22_, "flash");
	gtk_toggle_button_set_active ((GtkToggleButton*) _tmp21_, _tmp23_);
}


/**
   * Update the active device to the active iter of the device combo box.
   *
   * @param combo the video device combo box
   */
void cheese_preferences_dialog_on_source_change (GtkComboBox* combo, CheesePreferencesDialog* self) {
	CheeseCamera* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	guint _tmp2_ = 0U;
	GtkTreeIter iter = {0};
	CheeseCameraDevice* dev = NULL;
	GtkComboBox* _tmp3_ = NULL;
	GtkTreeIter _tmp4_ = {0};
	GtkComboBox* _tmp5_ = NULL;
	GtkTreeModel* _tmp6_ = NULL;
	GtkTreeModel* _tmp7_ = NULL;
	GtkTreeIter _tmp8_ = {0};
	CheeseCamera* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	CheeseCamera* _tmp11_ = NULL;
	CheeseCamera* _tmp12_ = NULL;
	CheeseCameraDevice* _tmp13_ = NULL;
	GSettings* _tmp14_ = NULL;
	const gchar* _tmp15_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (combo != NULL);
	_tmp0_ = self->priv->camera;
	g_object_get (_tmp0_, "num-camera-devices", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	g_return_if_fail (_tmp2_ > ((guint) 0));
	_tmp3_ = combo;
	gtk_combo_box_get_active_iter (_tmp3_, &_tmp4_);
	iter = _tmp4_;
	_tmp5_ = combo;
	_tmp6_ = gtk_combo_box_get_model (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = iter;
	gtk_tree_model_get (_tmp7_, &_tmp8_, 1, &dev, -1);
	_tmp9_ = self->priv->camera;
	_tmp10_ = cheese_camera_device_get_device_node (dev);
	cheese_camera_set_device_by_device_node (_tmp9_, _tmp10_);
	_tmp11_ = self->priv->camera;
	cheese_camera_switch_camera_device (_tmp11_);
	_tmp12_ = self->priv->camera;
	_tmp13_ = cheese_camera_get_selected_device (_tmp12_);
	cheese_preferences_dialog_setup_resolutions_for_device (self, _tmp13_);
	_tmp14_ = self->priv->settings;
	_tmp15_ = cheese_camera_device_get_device_node (dev);
	g_settings_set_string (_tmp14_, "camera", _tmp15_);
	_g_object_unref0 (dev);
}


/**
   * Update the current photo capture resolution to the active iter of the
   * photo resolution combo box.
   *
   * @param combo the photo resolution combo box
   */
void cheese_preferences_dialog_on_photo_resolution_change (GtkComboBox* combo, CheesePreferencesDialog* self) {
	GtkTreeIter iter = {0};
	CheeseVideoFormat* format = NULL;
	GtkComboBox* _tmp0_ = NULL;
	GtkTreeIter _tmp1_ = {0};
	GtkComboBox* _tmp2_ = NULL;
	GtkTreeModel* _tmp3_ = NULL;
	GtkTreeModel* _tmp4_ = NULL;
	GtkTreeIter _tmp5_ = {0};
	gboolean _tmp6_ = FALSE;
	CheeseMediaMode _tmp7_ = 0;
	gboolean _tmp9_ = FALSE;
	GSettings* _tmp12_ = NULL;
	CheeseVideoFormat* _tmp13_ = NULL;
	gint _tmp14_ = 0;
	GSettings* _tmp15_ = NULL;
	CheeseVideoFormat* _tmp16_ = NULL;
	gint _tmp17_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (combo != NULL);
	_tmp0_ = combo;
	gtk_combo_box_get_active_iter (_tmp0_, &_tmp1_);
	iter = _tmp1_;
	_tmp2_ = combo;
	_tmp3_ = gtk_combo_box_get_model (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = iter;
	gtk_tree_model_get (_tmp4_, &_tmp5_, 1, &format, -1);
	_tmp7_ = self->priv->current_mode;
	if (_tmp7_ == CHEESE_MEDIA_MODE_PHOTO) {
		_tmp6_ = TRUE;
	} else {
		CheeseMediaMode _tmp8_ = 0;
		_tmp8_ = self->priv->current_mode;
		_tmp6_ = _tmp8_ == CHEESE_MEDIA_MODE_BURST;
	}
	_tmp9_ = _tmp6_;
	if (_tmp9_) {
		CheeseCamera* _tmp10_ = NULL;
		CheeseVideoFormat* _tmp11_ = NULL;
		_tmp10_ = self->priv->camera;
		_tmp11_ = format;
		cheese_camera_set_video_format (_tmp10_, _tmp11_);
	}
	_tmp12_ = self->priv->settings;
	_tmp13_ = format;
	_tmp14_ = _tmp13_->width;
	g_settings_set_int (_tmp12_, "photo-x-resolution", _tmp14_);
	_tmp15_ = self->priv->settings;
	_tmp16_ = format;
	_tmp17_ = _tmp16_->height;
	g_settings_set_int (_tmp15_, "photo-y-resolution", _tmp17_);
}


/**
   * Update the current video capture resolution to the active iter of the
   * video resolution combo box.
   *
   * @param combo the video resolution combo box
   */
void cheese_preferences_dialog_on_video_resolution_change (GtkComboBox* combo, CheesePreferencesDialog* self) {
	GtkTreeIter iter = {0};
	CheeseVideoFormat* format = NULL;
	GtkComboBox* _tmp0_ = NULL;
	GtkTreeIter _tmp1_ = {0};
	GtkComboBox* _tmp2_ = NULL;
	GtkTreeModel* _tmp3_ = NULL;
	GtkTreeModel* _tmp4_ = NULL;
	GtkTreeIter _tmp5_ = {0};
	CheeseMediaMode _tmp6_ = 0;
	GSettings* _tmp9_ = NULL;
	CheeseVideoFormat* _tmp10_ = NULL;
	gint _tmp11_ = 0;
	GSettings* _tmp12_ = NULL;
	CheeseVideoFormat* _tmp13_ = NULL;
	gint _tmp14_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (combo != NULL);
	_tmp0_ = combo;
	gtk_combo_box_get_active_iter (_tmp0_, &_tmp1_);
	iter = _tmp1_;
	_tmp2_ = combo;
	_tmp3_ = gtk_combo_box_get_model (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = iter;
	gtk_tree_model_get (_tmp4_, &_tmp5_, 1, &format, -1);
	_tmp6_ = self->priv->current_mode;
	if (_tmp6_ == CHEESE_MEDIA_MODE_VIDEO) {
		CheeseCamera* _tmp7_ = NULL;
		CheeseVideoFormat* _tmp8_ = NULL;
		_tmp7_ = self->priv->camera;
		_tmp8_ = format;
		cheese_camera_set_video_format (_tmp7_, _tmp8_);
	}
	_tmp9_ = self->priv->settings;
	_tmp10_ = format;
	_tmp11_ = _tmp10_->width;
	g_settings_set_int (_tmp9_, "video-x-resolution", _tmp11_);
	_tmp12_ = self->priv->settings;
	_tmp13_ = format;
	_tmp14_ = _tmp13_->height;
	g_settings_set_int (_tmp12_, "video-y-resolution", _tmp14_);
}


/**
   * Hide the dialog when it is closed, rather than deleting it.
   *
   * @param dialog the dialog on which the delete event was generated
   */
void cheese_preferences_dialog_on_delete (GtkDialog* dialog, CheesePreferencesDialog* self) {
	GtkDialog* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (dialog != NULL);
	_tmp0_ = dialog;
	gtk_widget_hide_on_delete ((GtkWidget*) _tmp0_);
}


/**
   * Hide the dialog when it is closed, rather than deleting it.
   *
   * @param button the close button
   */
void cheese_preferences_dialog_on_dialog_close (GtkButton* button, CheesePreferencesDialog* self) {
	GtkDialog* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (button != NULL);
	_tmp0_ = self->priv->dialog;
	gtk_widget_hide ((GtkWidget*) _tmp0_);
}


/**
   * Show the help for the preferences dialog.
   *
   * @param button the help button
   */
void cheese_preferences_dialog_on_dialog_help (GtkButton* button, CheesePreferencesDialog* self) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (button != NULL);
	{
		GtkDialog* _tmp0_ = NULL;
		GdkScreen* _tmp1_ = NULL;
		_tmp0_ = self->priv->dialog;
		_tmp1_ = gtk_window_get_screen ((GtkWindow*) _tmp0_);
		gtk_show_uri (_tmp1_, "help:cheese/index#preferences", (guint32) GDK_CURRENT_TIME, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch5_g_error;
		}
	}
	goto __finally5;
	__catch5_g_error:
	{
		g_clear_error (&_inner_error_);
		_inner_error_ = NULL;
		g_warning ("cheese-preferences.vala:317: %s", "Error showing help");
	}
	__finally5:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


/**
   * Toggle the countdown GSetting when toggling the check button.
   *
   * @param checkbutton the countdown check button
   */
void cheese_preferences_dialog_on_countdown_toggle (GtkCheckButton* checkbutton, CheesePreferencesDialog* self) {
	GSettings* _tmp0_ = NULL;
	GtkCheckButton* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (checkbutton != NULL);
	_tmp0_ = self->priv->settings;
	_tmp1_ = checkbutton;
	_tmp2_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp1_);
	_tmp3_ = _tmp2_;
	g_settings_set_boolean (_tmp0_, "countdown", _tmp3_);
}


/**
   * Toggle the flash GSetting when toggling the check button.
   *
   * @param checkbutton the flash check button
   */
void cheese_preferences_dialog_on_flash_toggle (GtkCheckButton* checkbutton, CheesePreferencesDialog* self) {
	GSettings* _tmp0_ = NULL;
	GtkCheckButton* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (checkbutton != NULL);
	_tmp0_ = self->priv->settings;
	_tmp1_ = checkbutton;
	_tmp2_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp1_);
	_tmp3_ = _tmp2_;
	g_settings_set_boolean (_tmp0_, "flash", _tmp3_);
}


/**
   * Change the burst-repeat GSetting when changing the spin button.
   *
   * The burst repeat is the total number of photos to take in a single burst.
   *
   * @param spinbutton the burst-repeat spin button
   */
void cheese_preferences_dialog_on_burst_repeat_change (GtkSpinButton* spinbutton, CheesePreferencesDialog* self) {
	GSettings* _tmp0_ = NULL;
	GtkSpinButton* _tmp1_ = NULL;
	gdouble _tmp2_ = 0.0;
	gdouble _tmp3_ = 0.0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (spinbutton != NULL);
	_tmp0_ = self->priv->settings;
	_tmp1_ = spinbutton;
	_tmp2_ = gtk_spin_button_get_value (_tmp1_);
	_tmp3_ = _tmp2_;
	g_settings_set_int (_tmp0_, "burst-repeat", (gint) _tmp3_);
}


/**
   * Change the burst-delay GSetting when changing the spin button.
   *
   * The burst delay is the time, in milliseconds, between individual photos in
   * a burst.
   *
   * @param spinbutton the burst-delay spin button
   */
void cheese_preferences_dialog_on_burst_delay_change (GtkSpinButton* spinbutton, CheesePreferencesDialog* self) {
	GSettings* _tmp0_ = NULL;
	GtkSpinButton* _tmp1_ = NULL;
	gdouble _tmp2_ = 0.0;
	gdouble _tmp3_ = 0.0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (spinbutton != NULL);
	_tmp0_ = self->priv->settings;
	_tmp1_ = spinbutton;
	_tmp2_ = gtk_spin_button_get_value (_tmp1_);
	_tmp3_ = _tmp2_;
	g_settings_set_int (_tmp0_, "burst-delay", ((gint) _tmp3_) * 1000);
}


/**
   * Change the brightness of the image, and update the GSetting, when changing
   * the scale.
   *
   * @param adjustment the adjustment of the brightness Gtk.Scale
   */
void cheese_preferences_dialog_on_brightness_change (GtkAdjustment* adjustment, CheesePreferencesDialog* self) {
	CheeseCamera* _tmp0_ = NULL;
	GtkAdjustment* _tmp1_ = NULL;
	gdouble _tmp2_ = 0.0;
	gdouble _tmp3_ = 0.0;
	GSettings* _tmp4_ = NULL;
	GtkAdjustment* _tmp5_ = NULL;
	gdouble _tmp6_ = 0.0;
	gdouble _tmp7_ = 0.0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (adjustment != NULL);
	_tmp0_ = self->priv->camera;
	_tmp1_ = adjustment;
	_tmp2_ = gtk_adjustment_get_value (_tmp1_);
	_tmp3_ = _tmp2_;
	cheese_camera_set_balance_property (_tmp0_, "brightness", _tmp3_);
	_tmp4_ = self->priv->settings;
	_tmp5_ = adjustment;
	_tmp6_ = gtk_adjustment_get_value (_tmp5_);
	_tmp7_ = _tmp6_;
	g_settings_set_double (_tmp4_, "brightness", _tmp7_);
}


/**
   * Change the contrast of the image, and update the GSetting, when changing
   * the scale.
   *
   * @param adjustment the adjustment of the contrast Gtk.Scale
   */
void cheese_preferences_dialog_on_contrast_change (GtkAdjustment* adjustment, CheesePreferencesDialog* self) {
	CheeseCamera* _tmp0_ = NULL;
	GtkAdjustment* _tmp1_ = NULL;
	gdouble _tmp2_ = 0.0;
	gdouble _tmp3_ = 0.0;
	GSettings* _tmp4_ = NULL;
	GtkAdjustment* _tmp5_ = NULL;
	gdouble _tmp6_ = 0.0;
	gdouble _tmp7_ = 0.0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (adjustment != NULL);
	_tmp0_ = self->priv->camera;
	_tmp1_ = adjustment;
	_tmp2_ = gtk_adjustment_get_value (_tmp1_);
	_tmp3_ = _tmp2_;
	cheese_camera_set_balance_property (_tmp0_, "contrast", _tmp3_);
	_tmp4_ = self->priv->settings;
	_tmp5_ = adjustment;
	_tmp6_ = gtk_adjustment_get_value (_tmp5_);
	_tmp7_ = _tmp6_;
	g_settings_set_double (_tmp4_, "contrast", _tmp7_);
}


/**
   * Change the hue of the image, and update the GSetting, when changing the
   * scale.
   *
   * @param adjustment the adjustment of the hue Gtk.Scale
   */
void cheese_preferences_dialog_on_hue_change (GtkAdjustment* adjustment, CheesePreferencesDialog* self) {
	CheeseCamera* _tmp0_ = NULL;
	GtkAdjustment* _tmp1_ = NULL;
	gdouble _tmp2_ = 0.0;
	gdouble _tmp3_ = 0.0;
	GSettings* _tmp4_ = NULL;
	GtkAdjustment* _tmp5_ = NULL;
	gdouble _tmp6_ = 0.0;
	gdouble _tmp7_ = 0.0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (adjustment != NULL);
	_tmp0_ = self->priv->camera;
	_tmp1_ = adjustment;
	_tmp2_ = gtk_adjustment_get_value (_tmp1_);
	_tmp3_ = _tmp2_;
	cheese_camera_set_balance_property (_tmp0_, "hue", _tmp3_);
	_tmp4_ = self->priv->settings;
	_tmp5_ = adjustment;
	_tmp6_ = gtk_adjustment_get_value (_tmp5_);
	_tmp7_ = _tmp6_;
	g_settings_set_double (_tmp4_, "hue", _tmp7_);
}


/**
   * Change the saturation of the image, and update the GSetting, when changing
   * the scale.
   *
   * @param adjustment the adjustment of the saturation Gtk.Scale
   */
void cheese_preferences_dialog_on_saturation_change (GtkAdjustment* adjustment, CheesePreferencesDialog* self) {
	CheeseCamera* _tmp0_ = NULL;
	GtkAdjustment* _tmp1_ = NULL;
	gdouble _tmp2_ = 0.0;
	gdouble _tmp3_ = 0.0;
	GSettings* _tmp4_ = NULL;
	GtkAdjustment* _tmp5_ = NULL;
	gdouble _tmp6_ = 0.0;
	gdouble _tmp7_ = 0.0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (adjustment != NULL);
	_tmp0_ = self->priv->camera;
	_tmp1_ = adjustment;
	_tmp2_ = gtk_adjustment_get_value (_tmp1_);
	_tmp3_ = _tmp2_;
	cheese_camera_set_balance_property (_tmp0_, "saturation", _tmp3_);
	_tmp4_ = self->priv->settings;
	_tmp5_ = adjustment;
	_tmp6_ = gtk_adjustment_get_value (_tmp5_);
	_tmp7_ = _tmp6_;
	g_settings_set_double (_tmp4_, "saturation", _tmp7_);
}


/**
   * Update the video device combo box when a camera device was added or
   * removed.
   */
static Block2Data* block2_data_ref (Block2Data* _data2_) {
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}


static void block2_data_unref (void * _userdata_) {
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		CheesePreferencesDialog * self;
		self = _data2_->self;
		_g_object_unref0 (_data2_->active_device);
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}


static void ___lambda4_ (Block2Data* _data2_, void* device) {
	CheesePreferencesDialog * self;
	CheeseCameraDevice* old_device = NULL;
	void* _tmp0_ = NULL;
	CheeseCameraDevice* _tmp1_ = NULL;
	CheeseCameraDevice* new_device = NULL;
	GtkListStore* _tmp2_ = NULL;
	GtkTreeIter _tmp3_ = {0};
	GCompareFunc _tmp4_ = NULL;
	CheeseCameraDevice* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	CheeseCameraDevice* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	gint _tmp11_ = 0;
	GtkListStore* _tmp15_ = NULL;
	self = _data2_->self;
	_tmp0_ = device;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, CHEESE_TYPE_CAMERA_DEVICE, CheeseCameraDevice));
	old_device = _tmp1_;
	_tmp2_ = self->priv->camera_model;
	_tmp3_ = _data2_->iter;
	gtk_tree_model_get ((GtkTreeModel*) _tmp2_, &_tmp3_, 1, &new_device, -1, -1);
	_tmp4_ = g_strcmp0;
	_tmp5_ = old_device;
	_tmp6_ = cheese_camera_device_get_device_node (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = new_device;
	_tmp9_ = cheese_camera_device_get_device_node (_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = _tmp4_ (_tmp7_, _tmp10_);
	if (_tmp11_ != 0) {
		GtkTreeIter _tmp12_ = {0};
		CheeseCameraDevice* _tmp13_ = NULL;
		CheeseCameraDevice* _tmp14_ = NULL;
		_tmp12_ = _data2_->iter;
		_tmp13_ = new_device;
		_tmp14_ = _data2_->active_device;
		cheese_preferences_dialog_remove_camera_device (self, &_tmp12_, _tmp13_, _tmp14_);
		_data2_->device_removed = TRUE;
		_g_object_unref0 (new_device);
		_g_object_unref0 (old_device);
		return;
	}
	_tmp15_ = self->priv->camera_model;
	gtk_tree_model_iter_next ((GtkTreeModel*) _tmp15_, &_data2_->iter);
	_g_object_unref0 (new_device);
	_g_object_unref0 (old_device);
}


static void ____lambda4__gfunc (gconstpointer data, gpointer self) {
	___lambda4_ (self, data);
}


static void cheese_preferences_dialog_on_camera_update_num_camera_devices (CheesePreferencesDialog* self) {
	GPtrArray* devices = NULL;
	CheeseCamera* _tmp0_ = NULL;
	GPtrArray* _tmp1_ = NULL;
	CheeseCameraDevice* dev = NULL;
	GPtrArray* _tmp2_ = NULL;
	guint _tmp3_ = 0U;
	GtkListStore* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	GSettings* _tmp25_ = NULL;
	CheeseCamera* _tmp26_ = NULL;
	CheeseCameraDevice* _tmp27_ = NULL;
	const gchar* _tmp28_ = NULL;
	CheeseCamera* _tmp29_ = NULL;
	CheeseCameraDevice* _tmp30_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->camera;
	_tmp1_ = cheese_camera_get_camera_devices (_tmp0_);
	devices = _tmp1_;
	_tmp2_ = devices;
	_tmp3_ = _tmp2_->len;
	_tmp4_ = self->priv->camera_model;
	_tmp5_ = gtk_tree_model_iter_n_children ((GtkTreeModel*) _tmp4_, NULL);
	if (_tmp3_ > ((guint) _tmp5_)) {
		GPtrArray* _tmp6_ = NULL;
		GPtrArray* _tmp7_ = NULL;
		guint _tmp8_ = 0U;
		void* _tmp9_ = NULL;
		CheeseCameraDevice* _tmp10_ = NULL;
		CheeseCameraDevice* _tmp11_ = NULL;
		_tmp6_ = devices;
		_tmp7_ = devices;
		_tmp8_ = _tmp7_->len;
		_tmp9_ = g_ptr_array_index (_tmp6_, _tmp8_ - 1);
		_tmp10_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, CHEESE_TYPE_CAMERA_DEVICE, CheeseCameraDevice));
		_g_object_unref0 (dev);
		dev = _tmp10_;
		_tmp11_ = dev;
		cheese_preferences_dialog_add_camera_device (self, _tmp11_);
	} else {
		Block2Data* _data2_;
		GtkListStore* _tmp12_ = NULL;
		GtkTreeIter _tmp13_ = {0};
		GtkTreeIter active_iter = {0};
		GtkComboBox* _tmp14_ = NULL;
		GtkTreeIter _tmp15_ = {0};
		GtkListStore* _tmp16_ = NULL;
		GtkTreeIter _tmp17_ = {0};
		GPtrArray* _tmp18_ = NULL;
		gboolean _tmp19_ = FALSE;
		_data2_ = g_slice_new0 (Block2Data);
		_data2_->_ref_count_ = 1;
		_data2_->self = g_object_ref (self);
		_tmp12_ = self->priv->camera_model;
		gtk_tree_model_get_iter_first ((GtkTreeModel*) _tmp12_, &_tmp13_);
		_data2_->iter = _tmp13_;
		_tmp14_ = self->priv->source_combo;
		gtk_combo_box_get_active_iter (_tmp14_, &_tmp15_);
		active_iter = _tmp15_;
		_tmp16_ = self->priv->camera_model;
		_tmp17_ = active_iter;
		gtk_tree_model_get ((GtkTreeModel*) _tmp16_, &_tmp17_, 1, &_data2_->active_device, -1, -1);
		_data2_->device_removed = FALSE;
		_tmp18_ = devices;
		g_ptr_array_foreach (_tmp18_, ____lambda4__gfunc, _data2_);
		_tmp19_ = _data2_->device_removed;
		if (!_tmp19_) {
			CheeseCameraDevice* old_device = NULL;
			GtkListStore* _tmp20_ = NULL;
			GtkTreeIter _tmp21_ = {0};
			GtkTreeIter _tmp22_ = {0};
			CheeseCameraDevice* _tmp23_ = NULL;
			CheeseCameraDevice* _tmp24_ = NULL;
			_tmp20_ = self->priv->camera_model;
			_tmp21_ = _data2_->iter;
			gtk_tree_model_get ((GtkTreeModel*) _tmp20_, &_tmp21_, 1, &old_device, -1, -1);
			_tmp22_ = _data2_->iter;
			_tmp23_ = old_device;
			_tmp24_ = _data2_->active_device;
			cheese_preferences_dialog_remove_camera_device (self, &_tmp22_, _tmp23_, _tmp24_);
			_g_object_unref0 (old_device);
		}
		block2_data_unref (_data2_);
		_data2_ = NULL;
	}
	_tmp25_ = self->priv->settings;
	_tmp26_ = self->priv->camera;
	_tmp27_ = cheese_camera_get_selected_device (_tmp26_);
	_tmp28_ = cheese_camera_device_get_device_node (_tmp27_);
	g_settings_set_string (_tmp25_, "camera", _tmp28_);
	_tmp29_ = self->priv->camera;
	_tmp30_ = cheese_camera_get_selected_device (_tmp29_);
	cheese_preferences_dialog_setup_resolutions_for_device (self, _tmp30_);
	_g_object_unref0 (dev);
}


/**
   * Add the supplied camera device to the device combo box model.
   *
   * This method is intended to be used with the foreach method of GLib
   * containers.
   *
   * @param device a Cheese.CameraDevice to add to the device combo box model
   */
static void cheese_preferences_dialog_add_camera_device (CheesePreferencesDialog* self, void* device) {
	GtkTreeIter iter = {0};
	CheeseCameraDevice* dev = NULL;
	void* _tmp0_ = NULL;
	CheeseCameraDevice* _tmp1_ = NULL;
	GtkListStore* _tmp2_ = NULL;
	GtkTreeIter _tmp3_ = {0};
	GtkListStore* _tmp4_ = NULL;
	GtkTreeIter _tmp5_ = {0};
	CheeseCameraDevice* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	CheeseCameraDevice* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
	CheeseCameraDevice* _tmp16_ = NULL;
	CheeseCamera* _tmp17_ = NULL;
	CheeseCameraDevice* _tmp18_ = NULL;
	const gchar* _tmp19_ = NULL;
	CheeseCameraDevice* _tmp20_ = NULL;
	const gchar* _tmp21_ = NULL;
	GtkListStore* _tmp24_ = NULL;
	gint _tmp25_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = device;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, CHEESE_TYPE_CAMERA_DEVICE, CheeseCameraDevice));
	dev = _tmp1_;
	_tmp2_ = self->priv->camera_model;
	gtk_list_store_append (_tmp2_, &_tmp3_);
	iter = _tmp3_;
	_tmp4_ = self->priv->camera_model;
	_tmp5_ = iter;
	_tmp6_ = dev;
	_tmp7_ = cheese_camera_device_get_name (_tmp6_);
	_tmp8_ = g_strconcat (_tmp7_, " (", NULL);
	_tmp9_ = _tmp8_;
	_tmp10_ = dev;
	_tmp11_ = cheese_camera_device_get_device_node (_tmp10_);
	_tmp12_ = g_strconcat (_tmp9_, _tmp11_, NULL);
	_tmp13_ = _tmp12_;
	_tmp14_ = g_strconcat (_tmp13_, ")", NULL);
	_tmp15_ = _tmp14_;
	_tmp16_ = dev;
	gtk_list_store_set (_tmp4_, &_tmp5_, 0, _tmp15_, 1, _tmp16_, -1);
	_g_free0 (_tmp15_);
	_g_free0 (_tmp13_);
	_g_free0 (_tmp9_);
	_tmp17_ = self->priv->camera;
	_tmp18_ = cheese_camera_get_selected_device (_tmp17_);
	_tmp19_ = cheese_camera_device_get_device_node (_tmp18_);
	_tmp20_ = dev;
	_tmp21_ = cheese_camera_device_get_device_node (_tmp20_);
	if (g_strcmp0 (_tmp19_, _tmp21_) == 0) {
		GtkComboBox* _tmp22_ = NULL;
		GtkTreeIter _tmp23_ = {0};
		_tmp22_ = self->priv->source_combo;
		_tmp23_ = iter;
		gtk_combo_box_set_active_iter (_tmp22_, &_tmp23_);
	}
	_tmp24_ = self->priv->camera_model;
	_tmp25_ = gtk_tree_model_iter_n_children ((GtkTreeModel*) _tmp24_, NULL);
	if (_tmp25_ > 1) {
		GtkComboBox* _tmp26_ = NULL;
		_tmp26_ = self->priv->source_combo;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp26_, TRUE);
	}
	_g_object_unref0 (dev);
}


/**
   * Remove the supplied camera device from the device combo box model.
   *
   * @param iter the iterator of the device to remove
   * @param device_node the device to remove from the combo box model
   * @param active_device_node the currently-active camera device
   */
static void cheese_preferences_dialog_remove_camera_device (CheesePreferencesDialog* self, GtkTreeIter* iter, CheeseCameraDevice* device_node, CheeseCameraDevice* active_device_node) {
	GPtrArray* devices = NULL;
	CheeseCamera* _tmp0_ = NULL;
	GPtrArray* _tmp1_ = NULL;
	GCompareFunc _tmp2_ = NULL;
	CheeseCameraDevice* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	CheeseCameraDevice* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	gint _tmp9_ = 0;
	GtkListStore* _tmp14_ = NULL;
	GtkTreeIter _tmp15_ = {0};
	GtkListStore* _tmp16_ = NULL;
	gint _tmp17_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (iter != NULL);
	g_return_if_fail (device_node != NULL);
	g_return_if_fail (active_device_node != NULL);
	_tmp0_ = self->priv->camera;
	_tmp1_ = cheese_camera_get_camera_devices (_tmp0_);
	devices = _tmp1_;
	_tmp2_ = g_strcmp0;
	_tmp3_ = device_node;
	_tmp4_ = cheese_camera_device_get_device_node (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = active_device_node;
	_tmp7_ = cheese_camera_device_get_device_node (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = _tmp2_ (_tmp5_, _tmp8_);
	if (_tmp9_ == 0) {
		GPtrArray* _tmp10_ = NULL;
		guint _tmp11_ = 0U;
		_tmp10_ = devices;
		_tmp11_ = _tmp10_->len;
		if (_tmp11_ > ((guint) 0)) {
			GtkTreeIter _tmp12_ = {0};
			_tmp12_ = *iter;
			cheese_preferences_dialog_set_new_available_camera_device (self, &_tmp12_);
		} else {
			GtkDialog* _tmp13_ = NULL;
			_tmp13_ = self->priv->dialog;
			gtk_widget_hide ((GtkWidget*) _tmp13_);
		}
	}
	_tmp14_ = self->priv->camera_model;
	_tmp15_ = *iter;
	gtk_list_store_remove (_tmp14_, &_tmp15_);
	_tmp16_ = self->priv->camera_model;
	_tmp17_ = gtk_tree_model_iter_n_children ((GtkTreeModel*) _tmp16_, NULL);
	if (_tmp17_ <= 1) {
		GtkComboBox* _tmp18_ = NULL;
		_tmp18_ = self->priv->source_combo;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp18_, FALSE);
	}
}


/**
   * Search for an available camera device and activate it in the device combo
   * box model.
   *
   * @param iter a device in the combo box model to search either side of
   */
static void cheese_preferences_dialog_set_new_available_camera_device (CheesePreferencesDialog* self, GtkTreeIter* iter) {
	GtkTreeIter new_iter = {0};
	GtkTreeIter _tmp0_ = {0};
	GtkListStore* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	GtkComboBox* _tmp5_ = NULL;
	GtkTreeIter _tmp6_ = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (iter != NULL);
	_tmp0_ = *iter;
	new_iter = _tmp0_;
	_tmp1_ = self->priv->camera_model;
	_tmp2_ = gtk_tree_model_iter_next ((GtkTreeModel*) _tmp1_, &new_iter);
	if (!_tmp2_) {
		GtkTreeIter _tmp3_ = {0};
		GtkListStore* _tmp4_ = NULL;
		_tmp3_ = *iter;
		new_iter = _tmp3_;
		_tmp4_ = self->priv->camera_model;
		gtk_tree_model_iter_previous ((GtkTreeModel*) _tmp4_, &new_iter);
	}
	_tmp5_ = self->priv->source_combo;
	_tmp6_ = new_iter;
	gtk_combo_box_set_active_iter (_tmp5_, &_tmp6_);
}


/**
   * Show the dialog.
   */
void cheese_preferences_dialog_show (CheesePreferencesDialog* self) {
	GtkDialog* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->dialog;
	gtk_widget_show_all ((GtkWidget*) _tmp0_);
}


/**
     * Set the current media mode (photo, video or burst).
     *
     * The current mode is used to update the video format on the Cheese.Camera
     * when the resolution for the current mode is changed.
     *
     * @param mode the media mode to set
     */
void cheese_preferences_dialog_set_current_mode (CheesePreferencesDialog* self, CheeseMediaMode mode) {
	CheeseMediaMode _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = mode;
	self->priv->current_mode = _tmp0_;
}


static void cheese_preferences_dialog_class_init (CheesePreferencesDialogClass * klass) {
	cheese_preferences_dialog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (CheesePreferencesDialogPrivate));
	G_OBJECT_CLASS (klass)->finalize = cheese_preferences_dialog_finalize;
}


static void cheese_preferences_dialog_instance_init (CheesePreferencesDialog * self) {
	self->priv = CHEESE_PREFERENCES_DIALOG_GET_PRIVATE (self);
}


static void cheese_preferences_dialog_finalize (GObject* obj) {
	CheesePreferencesDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CHEESE_TYPE_PREFERENCES_DIALOG, CheesePreferencesDialog);
	_g_object_unref0 (self->priv->camera);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->dialog);
	_g_object_unref0 (self->priv->photo_resolution_combo);
	_g_object_unref0 (self->priv->video_resolution_combo);
	_g_object_unref0 (self->priv->source_combo);
	_g_object_unref0 (self->priv->camera_model);
	_g_object_unref0 (self->priv->brightness_adjustment);
	_g_object_unref0 (self->priv->contrast_adjustment);
	_g_object_unref0 (self->priv->hue_adjustment);
	_g_object_unref0 (self->priv->saturation_adjustment);
	_g_object_unref0 (self->priv->brightness_scale);
	_g_object_unref0 (self->priv->contrast_scale);
	_g_object_unref0 (self->priv->hue_scale);
	_g_object_unref0 (self->priv->saturation_scale);
	_g_object_unref0 (self->priv->burst_repeat_spin);
	_g_object_unref0 (self->priv->burst_delay_spin);
	_g_object_unref0 (self->priv->countdown_check);
	_g_object_unref0 (self->priv->flash_check);
	G_OBJECT_CLASS (cheese_preferences_dialog_parent_class)->finalize (obj);
}


GType cheese_preferences_dialog_get_type (void) {
	static volatile gsize cheese_preferences_dialog_type_id__volatile = 0;
	if (g_once_init_enter (&cheese_preferences_dialog_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (CheesePreferencesDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) cheese_preferences_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CheesePreferencesDialog), 0, (GInstanceInitFunc) cheese_preferences_dialog_instance_init, NULL };
		GType cheese_preferences_dialog_type_id;
		cheese_preferences_dialog_type_id = g_type_register_static (G_TYPE_OBJECT, "CheesePreferencesDialog", &g_define_type_info, 0);
		g_once_init_leave (&cheese_preferences_dialog_type_id__volatile, cheese_preferences_dialog_type_id);
	}
	return cheese_preferences_dialog_type_id__volatile;
}



