/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * This file is part of capuchin-glib. 
 *
 * Copyright (C) Sebastian Pölsterl 2008 <marduk@k-d-w.org>
 * 
 * capuchin-glib is free software.
 * 
 * You may redistribute it and/or modify it under the terms of the
 * GNU General Public License, as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option)
 * any later version.
 * 
 * capuchin-glib is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with capuchin-glib.
 * If not, see <http://www.gnu.org/licenses/>.
 */

#include <capuchin-glib/capuchin-g-plugin-info.h>

#define CAPUCHIN_G_PLUGIN_INFO_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), CAPUCHIN_TYPE_G_PLUGIN_INFO, CapuchinGPluginInfoPrivate))

struct _CapuchinGPluginInfoPrivate {
	gchar *id;
	gchar *version;
};

enum
{
	PROP_0,

	PROP_ID,
	PROP_VERSION
};

G_DEFINE_TYPE (CapuchinGPluginInfo, capuchin_g_plugin_info, G_TYPE_OBJECT);

static void
capuchin_g_plugin_info_init (CapuchinGPluginInfo *object)
{
	object->priv = CAPUCHIN_G_PLUGIN_INFO_PRIVATE (object);
	object->priv->id = NULL;
	object->priv->version = NULL;
}

static void
capuchin_g_plugin_info_finalize (GObject *object)
{
	CapuchinGPluginInfo *info;
	
	info = CAPUCHIN_G_PLUGIN_INFO (object);
	
	g_free (info->priv->id);
	g_free (info->priv->version);

	G_OBJECT_CLASS (capuchin_g_plugin_info_parent_class)->finalize (object);
}

static void
capuchin_g_plugin_info_set_property (GObject *object, guint prop_id, const GValue *value, GParamSpec *pspec)
{
	CapuchinGPluginInfo *info;
	
	g_return_if_fail (CAPUCHIN_IS_G_PLUGIN_INFO (object));
	
	info = CAPUCHIN_G_PLUGIN_INFO (object);

	switch (prop_id)
	{
	case PROP_ID:
		g_free (info->priv->id);
		info->priv->id = g_value_dup_string (value);
		break;
	case PROP_VERSION:
		g_free (info->priv->version);
		info->priv->version = g_value_dup_string (value);
		break;
	default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, prop_id, pspec);
		break;
	}
}

static void
capuchin_g_plugin_info_get_property (GObject *object, guint prop_id, GValue *value, GParamSpec *pspec)
{
	CapuchinGPluginInfo *info;
	
	g_return_if_fail (CAPUCHIN_IS_G_PLUGIN_INFO (object));
	
	info = CAPUCHIN_G_PLUGIN_INFO (object);

	switch (prop_id)
	{
	case PROP_ID:
		g_value_set_string (value, info->priv->id);
		break;
	case PROP_VERSION:
		g_value_set_string (value, info->priv->version);
		break;
	default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, prop_id, pspec);
		break;
	}
}

static void
capuchin_g_plugin_info_class_init (CapuchinGPluginInfoClass *klass)
{
	GObjectClass* object_class = G_OBJECT_CLASS (klass);
	GObjectClass* parent_class = G_OBJECT_CLASS (klass);

	g_type_class_add_private (klass, sizeof (CapuchinGPluginInfoPrivate));
	
	object_class->finalize = capuchin_g_plugin_info_finalize;
	object_class->set_property = capuchin_g_plugin_info_set_property;
	object_class->get_property = capuchin_g_plugin_info_get_property;

	g_object_class_install_property (object_class,
	                                 PROP_ID,
	                                 g_param_spec_string ("id",
	                                                      "Plugin ID",
	                                                      "ID of the plugin",
	                                                      NULL,
	                                                      G_PARAM_READABLE | G_PARAM_WRITABLE));

	g_object_class_install_property (object_class,
	                                 PROP_VERSION,
	                                 g_param_spec_string ("version",
	                                                      "Plugin version",
	                                                      "ID of the plugin",
	                                                      NULL,
	                                                      G_PARAM_READABLE | G_PARAM_WRITABLE));
}

/**
  * capuchin_g_plugin_info_new
  * @plugin_id: Plugin's ID
  * @version: Plugin's version
  * @returns: #CapuchinGPluginInfo object
  *
  * Create new #CapuchinGPluginInfo object
  */
CapuchinGPluginInfo*
capuchin_g_plugin_info_new (const gchar *plugin_id, const gchar *version)
{
	CapuchinGPluginInfo *info;
	
	info = CAPUCHIN_G_PLUGIN_INFO (g_object_new (CAPUCHIN_TYPE_G_PLUGIN_INFO,
												 "id", plugin_id,
												 "version", version,
												 NULL));
	
	return info;
}
