/* util-string.c generated by valac 0.26.0, the Vala compiler
 * generated from util-string.vala, do not modify */

/* Copyright 2014 Yorba Foundation
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))


extern gchar california_string_NUL;
gchar california_string_NUL = '\0';

gboolean california_string_is_empty (const gchar* str);
gint california_string_stricmp (const gchar* a, const gchar* b);
guint california_string_ci_hash (const gchar* str);
gboolean california_string_ci_equal (const gchar* a, const gchar* b);
gchar* california_string_reduce_whitespace (const gchar* str);
gboolean california_string_is_numeric (const gchar* str);
gchar* california_string_remove_leading_chars (const gchar* str, gunichar ch, const gchar* delims);


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_ = 0L;
	gchar _tmp1_ = '\0';
#line 996 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, '\0');
#line 997 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
	_tmp0_ = index;
#line 997 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
	_tmp1_ = ((gchar*) self)[_tmp0_];
#line 997 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
	result = _tmp1_;
#line 997 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
	return result;
#line 46 "util-string.c"
}


inline gboolean california_string_is_empty (const gchar* str) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_ = NULL;
#line 12 "/home/jim/git/california/src/util/util-string.vala"
	_tmp1_ = str;
#line 12 "/home/jim/git/california/src/util/util-string.vala"
	if (_tmp1_ == NULL) {
#line 12 "/home/jim/git/california/src/util/util-string.vala"
		_tmp0_ = TRUE;
#line 60 "util-string.c"
	} else {
		const gchar* _tmp2_ = NULL;
		gchar _tmp3_ = '\0';
		gchar _tmp4_ = '\0';
#line 12 "/home/jim/git/california/src/util/util-string.vala"
		_tmp2_ = str;
#line 12 "/home/jim/git/california/src/util/util-string.vala"
		_tmp3_ = string_get (_tmp2_, (glong) 0);
#line 12 "/home/jim/git/california/src/util/util-string.vala"
		_tmp4_ = california_string_NUL;
#line 12 "/home/jim/git/california/src/util/util-string.vala"
		_tmp0_ = _tmp3_ == _tmp4_;
#line 73 "util-string.c"
	}
#line 12 "/home/jim/git/california/src/util/util-string.vala"
	result = _tmp0_;
#line 12 "/home/jim/git/california/src/util/util-string.vala"
	return result;
#line 79 "util-string.c"
}


gint california_string_stricmp (const gchar* a, const gchar* b) {
	gint result = 0;
	GCompareFunc _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
#line 15 "/home/jim/git/california/src/util/util-string.vala"
	g_return_val_if_fail (a != NULL, 0);
#line 15 "/home/jim/git/california/src/util/util-string.vala"
	g_return_val_if_fail (b != NULL, 0);
#line 16 "/home/jim/git/california/src/util/util-string.vala"
	_tmp0_ = g_strcmp0;
#line 16 "/home/jim/git/california/src/util/util-string.vala"
	_tmp1_ = a;
#line 16 "/home/jim/git/california/src/util/util-string.vala"
	_tmp2_ = g_utf8_casefold (_tmp1_, (gssize) (-1));
#line 16 "/home/jim/git/california/src/util/util-string.vala"
	_tmp3_ = _tmp2_;
#line 16 "/home/jim/git/california/src/util/util-string.vala"
	_tmp4_ = b;
#line 16 "/home/jim/git/california/src/util/util-string.vala"
	_tmp5_ = g_utf8_casefold (_tmp4_, (gssize) (-1));
#line 16 "/home/jim/git/california/src/util/util-string.vala"
	_tmp6_ = _tmp5_;
#line 16 "/home/jim/git/california/src/util/util-string.vala"
	_tmp7_ = _tmp0_ (_tmp3_, _tmp6_);
#line 16 "/home/jim/git/california/src/util/util-string.vala"
	_tmp8_ = _tmp7_;
#line 16 "/home/jim/git/california/src/util/util-string.vala"
	_g_free0 (_tmp6_);
#line 16 "/home/jim/git/california/src/util/util-string.vala"
	_g_free0 (_tmp3_);
#line 16 "/home/jim/git/california/src/util/util-string.vala"
	result = _tmp8_;
#line 16 "/home/jim/git/california/src/util/util-string.vala"
	return result;
#line 124 "util-string.c"
}


guint california_string_ci_hash (const gchar* str) {
	guint result = 0U;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	guint _tmp3_ = 0U;
	guint _tmp4_ = 0U;
#line 19 "/home/jim/git/california/src/util/util-string.vala"
	g_return_val_if_fail (str != NULL, 0U);
#line 20 "/home/jim/git/california/src/util/util-string.vala"
	_tmp0_ = str;
#line 20 "/home/jim/git/california/src/util/util-string.vala"
	_tmp1_ = g_utf8_casefold (_tmp0_, (gssize) (-1));
#line 20 "/home/jim/git/california/src/util/util-string.vala"
	_tmp2_ = _tmp1_;
#line 20 "/home/jim/git/california/src/util/util-string.vala"
	_tmp3_ = g_str_hash (_tmp2_);
#line 20 "/home/jim/git/california/src/util/util-string.vala"
	_tmp4_ = _tmp3_;
#line 20 "/home/jim/git/california/src/util/util-string.vala"
	_g_free0 (_tmp2_);
#line 20 "/home/jim/git/california/src/util/util-string.vala"
	result = _tmp4_;
#line 20 "/home/jim/git/california/src/util/util-string.vala"
	return result;
#line 153 "util-string.c"
}


gboolean california_string_ci_equal (const gchar* a, const gchar* b) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gint _tmp2_ = 0;
#line 23 "/home/jim/git/california/src/util/util-string.vala"
	g_return_val_if_fail (a != NULL, FALSE);
#line 23 "/home/jim/git/california/src/util/util-string.vala"
	g_return_val_if_fail (b != NULL, FALSE);
#line 24 "/home/jim/git/california/src/util/util-string.vala"
	_tmp0_ = a;
#line 24 "/home/jim/git/california/src/util/util-string.vala"
	_tmp1_ = b;
#line 24 "/home/jim/git/california/src/util/util-string.vala"
	_tmp2_ = california_string_stricmp (_tmp0_, _tmp1_);
#line 24 "/home/jim/git/california/src/util/util-string.vala"
	result = _tmp2_ == 0;
#line 24 "/home/jim/git/california/src/util/util-string.vala"
	return result;
#line 176 "util-string.c"
}


/**
 * Removes redundant whitespace (including tabs and newlines) and strips whitespace from beginning
 * and end of string.
 */
static gboolean string_get_next_char (const gchar* self, gint* index, gunichar* c) {
	gunichar _vala_c = 0U;
	gboolean result = FALSE;
	gint _tmp0_ = 0;
	gunichar _tmp1_ = 0U;
	gunichar _tmp2_ = 0U;
#line 1015 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1016 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
	_tmp0_ = *index;
#line 1016 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
	_tmp1_ = g_utf8_get_char (((gchar*) self) + _tmp0_);
#line 1016 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
	_vala_c = _tmp1_;
#line 1017 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
	_tmp2_ = _vala_c;
#line 1017 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
	if (_tmp2_ != ((gunichar) 0)) {
#line 202 "util-string.c"
		gint _tmp3_ = 0;
		gchar* _tmp4_ = NULL;
#line 1018 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
		_tmp3_ = *index;
#line 1018 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
		_tmp4_ = g_utf8_next_char (((gchar*) self) + _tmp3_);
#line 1018 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
		*index = (gint) (_tmp4_ - ((gchar*) self));
#line 1019 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
		result = TRUE;
#line 1019 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
		if (c) {
#line 1019 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
			*c = _vala_c;
#line 217 "util-string.c"
		}
#line 1019 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
		return result;
#line 221 "util-string.c"
	} else {
#line 1021 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
		result = FALSE;
#line 1021 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
		if (c) {
#line 1021 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
			*c = _vala_c;
#line 229 "util-string.c"
		}
#line 1021 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
		return result;
#line 233 "util-string.c"
	}
#line 1015 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
	if (c) {
#line 1015 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
		*c = _vala_c;
#line 239 "util-string.c"
	}
}


static gchar* string_chomp (const gchar* self) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
#line 1099 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1100 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
	_tmp0_ = g_strdup (self);
#line 1100 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
	_result_ = _tmp0_;
#line 1101 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
	_tmp1_ = _result_;
#line 1101 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
	g_strchomp (_tmp1_);
#line 1102 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
	result = _result_;
#line 1102 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
	return result;
#line 263 "util-string.c"
}


gchar* california_string_reduce_whitespace (const gchar* str) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gchar _tmp1_ = '\0';
	gchar _tmp2_ = '\0';
	GString* builder = NULL;
	GString* _tmp5_ = NULL;
	gunichar ch = 0U;
	gunichar last_ch = 0U;
	gchar _tmp6_ = '\0';
	gint index = 0;
	GString* _tmp22_ = NULL;
	const gchar* _tmp23_ = NULL;
	gchar* _tmp24_ = NULL;
#line 31 "/home/jim/git/california/src/util/util-string.vala"
	g_return_val_if_fail (str != NULL, NULL);
#line 32 "/home/jim/git/california/src/util/util-string.vala"
	_tmp0_ = str;
#line 32 "/home/jim/git/california/src/util/util-string.vala"
	_tmp1_ = string_get (_tmp0_, (glong) 0);
#line 32 "/home/jim/git/california/src/util/util-string.vala"
	_tmp2_ = california_string_NUL;
#line 32 "/home/jim/git/california/src/util/util-string.vala"
	if (_tmp1_ == _tmp2_) {
#line 291 "util-string.c"
		const gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
#line 33 "/home/jim/git/california/src/util/util-string.vala"
		_tmp3_ = str;
#line 33 "/home/jim/git/california/src/util/util-string.vala"
		_tmp4_ = g_strdup (_tmp3_);
#line 33 "/home/jim/git/california/src/util/util-string.vala"
		result = _tmp4_;
#line 33 "/home/jim/git/california/src/util/util-string.vala"
		return result;
#line 302 "util-string.c"
	}
#line 35 "/home/jim/git/california/src/util/util-string.vala"
	_tmp5_ = g_string_new ("");
#line 35 "/home/jim/git/california/src/util/util-string.vala"
	builder = _tmp5_;
#line 37 "/home/jim/git/california/src/util/util-string.vala"
	_tmp6_ = california_string_NUL;
#line 37 "/home/jim/git/california/src/util/util-string.vala"
	last_ch = (gunichar) _tmp6_;
#line 38 "/home/jim/git/california/src/util/util-string.vala"
	index = 0;
#line 39 "/home/jim/git/california/src/util/util-string.vala"
	while (TRUE) {
#line 316 "util-string.c"
		const gchar* _tmp7_ = NULL;
		gunichar _tmp8_ = 0U;
		gboolean _tmp9_ = FALSE;
		gunichar _tmp10_ = 0U;
		gboolean _tmp11_ = FALSE;
		gunichar _tmp21_ = 0U;
#line 39 "/home/jim/git/california/src/util/util-string.vala"
		_tmp7_ = str;
#line 39 "/home/jim/git/california/src/util/util-string.vala"
		_tmp9_ = string_get_next_char (_tmp7_, &index, &_tmp8_);
#line 39 "/home/jim/git/california/src/util/util-string.vala"
		ch = _tmp8_;
#line 39 "/home/jim/git/california/src/util/util-string.vala"
		if (!_tmp9_) {
#line 39 "/home/jim/git/california/src/util/util-string.vala"
			break;
#line 333 "util-string.c"
		}
#line 42 "/home/jim/git/california/src/util/util-string.vala"
		_tmp10_ = ch;
#line 42 "/home/jim/git/california/src/util/util-string.vala"
		_tmp11_ = g_unichar_isspace (_tmp10_);
#line 42 "/home/jim/git/california/src/util/util-string.vala"
		if (_tmp11_) {
#line 341 "util-string.c"
			gboolean _tmp12_ = FALSE;
			gunichar _tmp13_ = 0U;
			gchar _tmp14_ = '\0';
#line 43 "/home/jim/git/california/src/util/util-string.vala"
			_tmp13_ = last_ch;
#line 43 "/home/jim/git/california/src/util/util-string.vala"
			_tmp14_ = california_string_NUL;
#line 43 "/home/jim/git/california/src/util/util-string.vala"
			if (_tmp13_ != ((gunichar) _tmp14_)) {
#line 351 "util-string.c"
				gunichar _tmp15_ = 0U;
				gboolean _tmp16_ = FALSE;
#line 43 "/home/jim/git/california/src/util/util-string.vala"
				_tmp15_ = last_ch;
#line 43 "/home/jim/git/california/src/util/util-string.vala"
				_tmp16_ = g_unichar_isspace (_tmp15_);
#line 43 "/home/jim/git/california/src/util/util-string.vala"
				_tmp12_ = !_tmp16_;
#line 360 "util-string.c"
			} else {
#line 43 "/home/jim/git/california/src/util/util-string.vala"
				_tmp12_ = FALSE;
#line 364 "util-string.c"
			}
#line 43 "/home/jim/git/california/src/util/util-string.vala"
			if (_tmp12_) {
#line 368 "util-string.c"
				GString* _tmp17_ = NULL;
				gunichar _tmp18_ = 0U;
#line 44 "/home/jim/git/california/src/util/util-string.vala"
				_tmp17_ = builder;
#line 44 "/home/jim/git/california/src/util/util-string.vala"
				_tmp18_ = ch;
#line 44 "/home/jim/git/california/src/util/util-string.vala"
				g_string_append_unichar (_tmp17_, _tmp18_);
#line 377 "util-string.c"
			}
		} else {
			GString* _tmp19_ = NULL;
			gunichar _tmp20_ = 0U;
#line 46 "/home/jim/git/california/src/util/util-string.vala"
			_tmp19_ = builder;
#line 46 "/home/jim/git/california/src/util/util-string.vala"
			_tmp20_ = ch;
#line 46 "/home/jim/git/california/src/util/util-string.vala"
			g_string_append_unichar (_tmp19_, _tmp20_);
#line 388 "util-string.c"
		}
#line 49 "/home/jim/git/california/src/util/util-string.vala"
		_tmp21_ = ch;
#line 49 "/home/jim/git/california/src/util/util-string.vala"
		last_ch = _tmp21_;
#line 394 "util-string.c"
	}
#line 54 "/home/jim/git/california/src/util/util-string.vala"
	_tmp22_ = builder;
#line 54 "/home/jim/git/california/src/util/util-string.vala"
	_tmp23_ = _tmp22_->str;
#line 54 "/home/jim/git/california/src/util/util-string.vala"
	_tmp24_ = string_chomp (_tmp23_);
#line 54 "/home/jim/git/california/src/util/util-string.vala"
	result = _tmp24_;
#line 54 "/home/jim/git/california/src/util/util-string.vala"
	_g_string_free0 (builder);
#line 54 "/home/jim/git/california/src/util/util-string.vala"
	return result;
#line 408 "util-string.c"
}


/**
 * Returns true if every character in the string is a numeric digit.
 */
gboolean california_string_is_numeric (const gchar* str) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gunichar ch = 0U;
	gint index = 0;
#line 61 "/home/jim/git/california/src/util/util-string.vala"
	_tmp0_ = str;
#line 61 "/home/jim/git/california/src/util/util-string.vala"
	_tmp1_ = california_string_is_empty (_tmp0_);
#line 61 "/home/jim/git/california/src/util/util-string.vala"
	if (_tmp1_) {
#line 62 "/home/jim/git/california/src/util/util-string.vala"
		result = FALSE;
#line 62 "/home/jim/git/california/src/util/util-string.vala"
		return result;
#line 431 "util-string.c"
	}
#line 65 "/home/jim/git/california/src/util/util-string.vala"
	index = 0;
#line 66 "/home/jim/git/california/src/util/util-string.vala"
	while (TRUE) {
#line 437 "util-string.c"
		const gchar* _tmp2_ = NULL;
		gunichar _tmp3_ = 0U;
		gboolean _tmp4_ = FALSE;
		gunichar _tmp5_ = 0U;
		gboolean _tmp6_ = FALSE;
#line 66 "/home/jim/git/california/src/util/util-string.vala"
		_tmp2_ = str;
#line 66 "/home/jim/git/california/src/util/util-string.vala"
		_tmp4_ = string_get_next_char (_tmp2_, &index, &_tmp3_);
#line 66 "/home/jim/git/california/src/util/util-string.vala"
		ch = _tmp3_;
#line 66 "/home/jim/git/california/src/util/util-string.vala"
		if (!_tmp4_) {
#line 66 "/home/jim/git/california/src/util/util-string.vala"
			break;
#line 453 "util-string.c"
		}
#line 67 "/home/jim/git/california/src/util/util-string.vala"
		_tmp5_ = ch;
#line 67 "/home/jim/git/california/src/util/util-string.vala"
		_tmp6_ = g_unichar_isdigit (_tmp5_);
#line 67 "/home/jim/git/california/src/util/util-string.vala"
		if (!_tmp6_) {
#line 68 "/home/jim/git/california/src/util/util-string.vala"
			result = FALSE;
#line 68 "/home/jim/git/california/src/util/util-string.vala"
			return result;
#line 465 "util-string.c"
		}
	}
#line 71 "/home/jim/git/california/src/util/util-string.vala"
	result = TRUE;
#line 71 "/home/jim/git/california/src/util/util-string.vala"
	return result;
#line 472 "util-string.c"
}


/**
 * Removes leading characters from throughout the string.
 *
 * Both the leading character and what constitutes tokens can be specified.
 *
 * Results are undefined if the leading character is also found in the delimiter string.
 */
static gint string_index_of_char (const gchar* self, gunichar c, gint start_index) {
	gint result = 0;
	gchar* _result_ = NULL;
	gint _tmp0_ = 0;
	gunichar _tmp1_ = 0U;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
#line 920 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0);
#line 921 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
	_tmp0_ = start_index;
#line 921 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
	_tmp1_ = c;
#line 921 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
	_tmp2_ = g_utf8_strchr (((gchar*) self) + _tmp0_, (gssize) (-1), _tmp1_);
#line 921 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
	_result_ = _tmp2_;
#line 923 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
	_tmp3_ = _result_;
#line 923 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
	if (_tmp3_ != NULL) {
#line 504 "util-string.c"
		gchar* _tmp4_ = NULL;
#line 924 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
		_tmp4_ = _result_;
#line 924 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
		result = (gint) (_tmp4_ - ((gchar*) self));
#line 924 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
		return result;
#line 512 "util-string.c"
	} else {
#line 926 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
		result = -1;
#line 926 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
		return result;
#line 518 "util-string.c"
	}
}


gchar* california_string_remove_leading_chars (const gchar* str, gunichar ch, const gchar* delims) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	GString* builder = NULL;
	GString* _tmp4_ = NULL;
	gunichar current_ch = 0U;
	gint index = 0;
	gboolean leading = FALSE;
	GString* _tmp19_ = NULL;
	const gchar* _tmp20_ = NULL;
	gchar* _tmp21_ = NULL;
#line 81 "/home/jim/git/california/src/util/util-string.vala"
	g_return_val_if_fail (delims != NULL, NULL);
#line 82 "/home/jim/git/california/src/util/util-string.vala"
	_tmp0_ = str;
#line 82 "/home/jim/git/california/src/util/util-string.vala"
	_tmp1_ = california_string_is_empty (_tmp0_);
#line 82 "/home/jim/git/california/src/util/util-string.vala"
	if (_tmp1_) {
#line 543 "util-string.c"
		const gchar* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
#line 83 "/home/jim/git/california/src/util/util-string.vala"
		_tmp2_ = str;
#line 83 "/home/jim/git/california/src/util/util-string.vala"
		_tmp3_ = g_strdup (_tmp2_);
#line 83 "/home/jim/git/california/src/util/util-string.vala"
		result = _tmp3_;
#line 83 "/home/jim/git/california/src/util/util-string.vala"
		return result;
#line 554 "util-string.c"
	}
#line 85 "/home/jim/git/california/src/util/util-string.vala"
	_tmp4_ = g_string_new ("");
#line 85 "/home/jim/git/california/src/util/util-string.vala"
	builder = _tmp4_;
#line 87 "/home/jim/git/california/src/util/util-string.vala"
	index = 0;
#line 88 "/home/jim/git/california/src/util/util-string.vala"
	leading = TRUE;
#line 89 "/home/jim/git/california/src/util/util-string.vala"
	while (TRUE) {
#line 566 "util-string.c"
		const gchar* _tmp5_ = NULL;
		gunichar _tmp6_ = 0U;
		gboolean _tmp7_ = FALSE;
		const gchar* _tmp8_ = NULL;
		gunichar _tmp9_ = 0U;
		gint _tmp10_ = 0;
		gboolean _tmp13_ = FALSE;
		gboolean _tmp14_ = FALSE;
		GString* _tmp17_ = NULL;
		gunichar _tmp18_ = 0U;
#line 89 "/home/jim/git/california/src/util/util-string.vala"
		_tmp5_ = str;
#line 89 "/home/jim/git/california/src/util/util-string.vala"
		_tmp7_ = string_get_next_char (_tmp5_, &index, &_tmp6_);
#line 89 "/home/jim/git/california/src/util/util-string.vala"
		current_ch = _tmp6_;
#line 89 "/home/jim/git/california/src/util/util-string.vala"
		if (!_tmp7_) {
#line 89 "/home/jim/git/california/src/util/util-string.vala"
			break;
#line 587 "util-string.c"
		}
#line 91 "/home/jim/git/california/src/util/util-string.vala"
		_tmp8_ = delims;
#line 91 "/home/jim/git/california/src/util/util-string.vala"
		_tmp9_ = current_ch;
#line 91 "/home/jim/git/california/src/util/util-string.vala"
		_tmp10_ = string_index_of_char (_tmp8_, _tmp9_, 0);
#line 91 "/home/jim/git/california/src/util/util-string.vala"
		if (_tmp10_ >= 0) {
#line 597 "util-string.c"
			GString* _tmp11_ = NULL;
			gunichar _tmp12_ = 0U;
#line 92 "/home/jim/git/california/src/util/util-string.vala"
			leading = TRUE;
#line 93 "/home/jim/git/california/src/util/util-string.vala"
			_tmp11_ = builder;
#line 93 "/home/jim/git/california/src/util/util-string.vala"
			_tmp12_ = current_ch;
#line 93 "/home/jim/git/california/src/util/util-string.vala"
			g_string_append_unichar (_tmp11_, _tmp12_);
#line 95 "/home/jim/git/california/src/util/util-string.vala"
			continue;
#line 610 "util-string.c"
		}
#line 99 "/home/jim/git/california/src/util/util-string.vala"
		_tmp14_ = leading;
#line 99 "/home/jim/git/california/src/util/util-string.vala"
		if (_tmp14_) {
#line 616 "util-string.c"
			gunichar _tmp15_ = 0U;
			gunichar _tmp16_ = 0U;
#line 99 "/home/jim/git/california/src/util/util-string.vala"
			_tmp15_ = current_ch;
#line 99 "/home/jim/git/california/src/util/util-string.vala"
			_tmp16_ = ch;
#line 99 "/home/jim/git/california/src/util/util-string.vala"
			_tmp13_ = _tmp15_ == _tmp16_;
#line 625 "util-string.c"
		} else {
#line 99 "/home/jim/git/california/src/util/util-string.vala"
			_tmp13_ = FALSE;
#line 629 "util-string.c"
		}
#line 99 "/home/jim/git/california/src/util/util-string.vala"
		if (_tmp13_) {
#line 100 "/home/jim/git/california/src/util/util-string.vala"
			continue;
#line 635 "util-string.c"
		}
#line 103 "/home/jim/git/california/src/util/util-string.vala"
		leading = FALSE;
#line 104 "/home/jim/git/california/src/util/util-string.vala"
		_tmp17_ = builder;
#line 104 "/home/jim/git/california/src/util/util-string.vala"
		_tmp18_ = current_ch;
#line 104 "/home/jim/git/california/src/util/util-string.vala"
		g_string_append_unichar (_tmp17_, _tmp18_);
#line 645 "util-string.c"
	}
#line 107 "/home/jim/git/california/src/util/util-string.vala"
	_tmp19_ = builder;
#line 107 "/home/jim/git/california/src/util/util-string.vala"
	_tmp20_ = _tmp19_->str;
#line 107 "/home/jim/git/california/src/util/util-string.vala"
	_tmp21_ = g_strdup (_tmp20_);
#line 107 "/home/jim/git/california/src/util/util-string.vala"
	result = _tmp21_;
#line 107 "/home/jim/git/california/src/util/util-string.vala"
	_g_string_free0 (builder);
#line 107 "/home/jim/git/california/src/util/util-string.vala"
	return result;
#line 659 "util-string.c"
}



