/* calendar-wall-time.c generated by valac 0.25.1, the Vala compiler
 * generated from calendar-wall-time.vala, do not modify */

/* Copyright 2014 Yorba Foundation
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>


#define CALIFORNIA_TYPE_BASE_OBJECT (california_base_object_get_type ())
#define CALIFORNIA_BASE_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_TYPE_BASE_OBJECT, CaliforniaBaseObject))
#define CALIFORNIA_BASE_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_TYPE_BASE_OBJECT, CaliforniaBaseObjectClass))
#define CALIFORNIA_IS_BASE_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_TYPE_BASE_OBJECT))
#define CALIFORNIA_IS_BASE_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_TYPE_BASE_OBJECT))
#define CALIFORNIA_BASE_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_TYPE_BASE_OBJECT, CaliforniaBaseObjectClass))

typedef struct _CaliforniaBaseObject CaliforniaBaseObject;
typedef struct _CaliforniaBaseObjectClass CaliforniaBaseObjectClass;
typedef struct _CaliforniaBaseObjectPrivate CaliforniaBaseObjectPrivate;

#define CALIFORNIA_CALENDAR_TYPE_WALL_TIME (california_calendar_wall_time_get_type ())
#define CALIFORNIA_CALENDAR_WALL_TIME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_CALENDAR_TYPE_WALL_TIME, CaliforniaCalendarWallTime))
#define CALIFORNIA_CALENDAR_WALL_TIME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_CALENDAR_TYPE_WALL_TIME, CaliforniaCalendarWallTimeClass))
#define CALIFORNIA_CALENDAR_IS_WALL_TIME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_CALENDAR_TYPE_WALL_TIME))
#define CALIFORNIA_CALENDAR_IS_WALL_TIME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_CALENDAR_TYPE_WALL_TIME))
#define CALIFORNIA_CALENDAR_WALL_TIME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_CALENDAR_TYPE_WALL_TIME, CaliforniaCalendarWallTimeClass))

typedef struct _CaliforniaCalendarWallTime CaliforniaCalendarWallTime;
typedef struct _CaliforniaCalendarWallTimeClass CaliforniaCalendarWallTimeClass;
typedef struct _CaliforniaCalendarWallTimePrivate CaliforniaCalendarWallTimePrivate;

#define CALIFORNIA_CALENDAR_WALL_TIME_TYPE_PRETTY_FLAG (california_calendar_wall_time_pretty_flag_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define CALIFORNIA_CALENDAR_TYPE_TIME_UNIT (california_calendar_time_unit_get_type ())
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _CaliforniaBaseObject {
	GObject parent_instance;
	CaliforniaBaseObjectPrivate * priv;
};

struct _CaliforniaBaseObjectClass {
	GObjectClass parent_class;
	gchar* (*to_string) (CaliforniaBaseObject* self);
};

struct _CaliforniaCalendarWallTime {
	CaliforniaBaseObject parent_instance;
	CaliforniaCalendarWallTimePrivate * priv;
};

struct _CaliforniaCalendarWallTimeClass {
	CaliforniaBaseObjectClass parent_class;
};

struct _CaliforniaCalendarWallTimePrivate {
	gint _hour;
	gint _12hour;
	gint _minute;
	gint _second;
};

typedef enum  {
	CALIFORNIA_CALENDAR_WALL_TIME_PRETTY_FLAG_NONE = 0,
	CALIFORNIA_CALENDAR_WALL_TIME_PRETTY_FLAG_INCLUDE_SECONDS = 1 << 0,
	CALIFORNIA_CALENDAR_WALL_TIME_PRETTY_FLAG_OPTIONAL_MINUTES = 1 << 1,
	CALIFORNIA_CALENDAR_WALL_TIME_PRETTY_FLAG_MERIDIEM_POST_ONLY = 1 << 2,
	CALIFORNIA_CALENDAR_WALL_TIME_PRETTY_FLAG_BRIEF_MERIDIEM = 1 << 3
} CaliforniaCalendarWallTimePrettyFlag;

typedef enum  {
	CALIFORNIA_CALENDAR_TIME_UNIT_SECOND,
	CALIFORNIA_CALENDAR_TIME_UNIT_MINUTE,
	CALIFORNIA_CALENDAR_TIME_UNIT_HOUR
} CaliforniaCalendarTimeUnit;


static gpointer california_calendar_wall_time_parent_class = NULL;
static CaliforniaCalendarWallTime* california_calendar_wall_time__earliest;
static CaliforniaCalendarWallTime* california_calendar_wall_time__earliest = NULL;
static CaliforniaCalendarWallTime* california_calendar_wall_time__latest;
static CaliforniaCalendarWallTime* california_calendar_wall_time__latest = NULL;
extern const gchar* california_calendar_MIDNIGHT;
extern const gchar* california_calendar_NOON;
extern const gchar* california_calendar_FMT_BRIEF_PM;
extern const gchar* california_calendar_FMT_PM;
extern const gchar* california_calendar_FMT_BRIEF_AM;
extern const gchar* california_calendar_FMT_AM;
extern const gchar* california_calendar_FMT_24HOUR_MIN;
extern const gchar* california_calendar_FMT_12HOUR_MIN_MERIDIEM;
extern const gchar* california_calendar_FMT_24HOUR_MIN_SEC;
extern const gchar* california_calendar_FMT_12HOUR_MIN_SEC_MERIDIEM;
static GeeComparableIface* california_calendar_wall_time_gee_comparable_parent_iface = NULL;
static GeeHashableIface* california_calendar_wall_time_gee_hashable_parent_iface = NULL;

GType california_base_object_get_type (void) G_GNUC_CONST;
GType california_calendar_wall_time_get_type (void) G_GNUC_CONST;
#define CALIFORNIA_CALENDAR_WALL_TIME_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), CALIFORNIA_CALENDAR_TYPE_WALL_TIME, CaliforniaCalendarWallTimePrivate))
enum  {
	CALIFORNIA_CALENDAR_WALL_TIME_DUMMY_PROPERTY,
	CALIFORNIA_CALENDAR_WALL_TIME_HOUR,
	CALIFORNIA_CALENDAR_WALL_TIME_MINUTE,
	CALIFORNIA_CALENDAR_WALL_TIME_SECOND,
	CALIFORNIA_CALENDAR_WALL_TIME_IS_PM
};
GType california_calendar_wall_time_pretty_flag_get_type (void) G_GNUC_CONST;
#define CALIFORNIA_CALENDAR_WALL_TIME_HOURS_PER_DAY 24
#define CALIFORNIA_CALENDAR_WALL_TIME_MIN_HOUR 0
#define CALIFORNIA_CALENDAR_WALL_TIME_MAX_HOUR (CALIFORNIA_CALENDAR_WALL_TIME_HOURS_PER_DAY - 1)
#define CALIFORNIA_CALENDAR_WALL_TIME_MINUTES_PER_HOUR 60
#define CALIFORNIA_CALENDAR_WALL_TIME_MIN_MINUTE 0
#define CALIFORNIA_CALENDAR_WALL_TIME_MAX_MINUTE (CALIFORNIA_CALENDAR_WALL_TIME_MINUTES_PER_HOUR - 1)
#define CALIFORNIA_CALENDAR_WALL_TIME_SECONDS_PER_MINUTE 60
#define CALIFORNIA_CALENDAR_WALL_TIME_MIN_SECOND 0
#define CALIFORNIA_CALENDAR_WALL_TIME_MAX_SECOND (CALIFORNIA_CALENDAR_WALL_TIME_SECONDS_PER_MINUTE - 1)
CaliforniaCalendarWallTime* california_calendar_wall_time_new (gint hour, gint minute, gint second);
CaliforniaCalendarWallTime* california_calendar_wall_time_construct (GType object_type, gint hour, gint minute, gint second);
CaliforniaBaseObject* california_base_object_construct (GType object_type);
static void california_calendar_wall_time_set_hour (CaliforniaCalendarWallTime* self, gint value);
static void california_calendar_wall_time_set_minute (CaliforniaCalendarWallTime* self, gint value);
static void california_calendar_wall_time_set_second (CaliforniaCalendarWallTime* self, gint value);
static void california_calendar_wall_time_set_12hour (CaliforniaCalendarWallTime* self, gint value);
void california_calendar_wall_time_init (void);
CaliforniaCalendarWallTime* california_calendar_wall_time_get_earliest (void);
static void california_calendar_wall_time_set_earliest (CaliforniaCalendarWallTime* value);
CaliforniaCalendarWallTime* california_calendar_wall_time_get_latest (void);
static void california_calendar_wall_time_set_latest (CaliforniaCalendarWallTime* value);
void california_calendar_wall_time_terminate (void);
CaliforniaCalendarWallTime* california_calendar_wall_time_parse (const gchar* str, gboolean* strictly_parsed);
gboolean california_string_is_empty (const gchar* str);
gchar* california_calendar_parse_meridiem (const gchar* str, gboolean* meridiem_unknown, gboolean* is_pm);
gboolean california_string_is_numeric (const gchar* str);
GType california_calendar_time_unit_get_type (void) G_GNUC_CONST;
CaliforniaCalendarWallTime* california_calendar_wall_time_adjust (CaliforniaCalendarWallTime* self, gint value, CaliforniaCalendarTimeUnit unit, gboolean* rollover);
gint california_calendar_wall_time_get_hour (CaliforniaCalendarWallTime* self);
gint california_calendar_wall_time_get_minute (CaliforniaCalendarWallTime* self);
gint california_calendar_wall_time_get_second (CaliforniaCalendarWallTime* self);
static void california_calendar_wall_time_adjust_hour (CaliforniaCalendarWallTime* self, gint* current_hour, gint value, gboolean* rollover);
static void california_calendar_wall_time_adjust_minute (CaliforniaCalendarWallTime* self, gint* current_hour, gint* current_minute, gint value, gboolean* rollover);
static void california_calendar_wall_time_adjust_second (CaliforniaCalendarWallTime* self, gint* current_hour, gint* current_minute, gint* current_second, gint value, gboolean* rollover);
CaliforniaCalendarWallTime* california_calendar_wall_time_round (CaliforniaCalendarWallTime* self, gint multiple, CaliforniaCalendarTimeUnit time_unit, gboolean* rollover);
CaliforniaCalendarWallTime* california_calendar_wall_time_free_adjust (CaliforniaCalendarWallTime* self, gint amount, CaliforniaCalendarTimeUnit time_unit);
gchar* california_calendar_wall_time_to_pretty_string (CaliforniaCalendarWallTime* self, CaliforniaCalendarWallTimePrettyFlag flags);
gboolean california_calendar_system_get_is_24hr (void);
gboolean california_calendar_wall_time_get_is_pm (CaliforniaCalendarWallTime* self);
gint california_calendar_wall_time_get_12hour (CaliforniaCalendarWallTime* self);
gchar* california_string_reduce_whitespace (const gchar* str);
static gint california_calendar_wall_time_real_compare_to (GeeComparable* base, CaliforniaCalendarWallTime* other);
static gboolean california_calendar_wall_time_real_equal_to (GeeHashable* base, CaliforniaCalendarWallTime* other);
static guint california_calendar_wall_time_real_hash (GeeHashable* base);
static gchar* california_calendar_wall_time_real_to_string (CaliforniaBaseObject* base);
static void california_calendar_wall_time_finalize (GObject* obj);
static void _vala_california_calendar_wall_time_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_california_calendar_wall_time_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


/**
     * Options for {@link to_pretty_string}.
     */
GType california_calendar_wall_time_pretty_flag_get_type (void) {
	static volatile gsize california_calendar_wall_time_pretty_flag_type_id__volatile = 0;
	if (g_once_init_enter (&california_calendar_wall_time_pretty_flag_type_id__volatile)) {
		static const GFlagsValue values[] = {{CALIFORNIA_CALENDAR_WALL_TIME_PRETTY_FLAG_NONE, "CALIFORNIA_CALENDAR_WALL_TIME_PRETTY_FLAG_NONE", "none"}, {CALIFORNIA_CALENDAR_WALL_TIME_PRETTY_FLAG_INCLUDE_SECONDS, "CALIFORNIA_CALENDAR_WALL_TIME_PRETTY_FLAG_INCLUDE_SECONDS", "include-seconds"}, {CALIFORNIA_CALENDAR_WALL_TIME_PRETTY_FLAG_OPTIONAL_MINUTES, "CALIFORNIA_CALENDAR_WALL_TIME_PRETTY_FLAG_OPTIONAL_MINUTES", "optional-minutes"}, {CALIFORNIA_CALENDAR_WALL_TIME_PRETTY_FLAG_MERIDIEM_POST_ONLY, "CALIFORNIA_CALENDAR_WALL_TIME_PRETTY_FLAG_MERIDIEM_POST_ONLY", "meridiem-post-only"}, {CALIFORNIA_CALENDAR_WALL_TIME_PRETTY_FLAG_BRIEF_MERIDIEM, "CALIFORNIA_CALENDAR_WALL_TIME_PRETTY_FLAG_BRIEF_MERIDIEM", "brief-meridiem"}, {0, NULL, NULL}};
		GType california_calendar_wall_time_pretty_flag_type_id;
		california_calendar_wall_time_pretty_flag_type_id = g_flags_register_static ("CaliforniaCalendarWallTimePrettyFlag", values);
		g_once_init_leave (&california_calendar_wall_time_pretty_flag_type_id__volatile, california_calendar_wall_time_pretty_flag_type_id);
	}
	return california_calendar_wall_time_pretty_flag_type_id__volatile;
}


/**
     * Generate a new {@link WallTime} object with the specified values.
     *
     * Note that hour must be in 24-hour time.
     *
     * Values will be clamped to create a valid time.
     */
CaliforniaCalendarWallTime* california_calendar_wall_time_construct (GType object_type, gint hour, gint minute, gint second) {
	CaliforniaCalendarWallTime * self = NULL;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
#line 99 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	self = (CaliforniaCalendarWallTime*) california_base_object_construct (object_type);
#line 100 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp0_ = hour;
#line 100 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp1_ = CLAMP (_tmp0_, CALIFORNIA_CALENDAR_WALL_TIME_MIN_HOUR, CALIFORNIA_CALENDAR_WALL_TIME_MAX_HOUR);
#line 100 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	california_calendar_wall_time_set_hour (self, _tmp1_);
#line 101 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp2_ = minute;
#line 101 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp3_ = CLAMP (_tmp2_, CALIFORNIA_CALENDAR_WALL_TIME_MIN_MINUTE, CALIFORNIA_CALENDAR_WALL_TIME_MAX_MINUTE);
#line 101 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	california_calendar_wall_time_set_minute (self, _tmp3_);
#line 102 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp4_ = second;
#line 102 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp5_ = CLAMP (_tmp4_, CALIFORNIA_CALENDAR_WALL_TIME_MIN_SECOND, CALIFORNIA_CALENDAR_WALL_TIME_MAX_SECOND);
#line 102 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	california_calendar_wall_time_set_second (self, _tmp5_);
#line 104 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp6_ = hour;
#line 104 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (_tmp6_ == 0) {
#line 105 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		california_calendar_wall_time_set_12hour (self, 12);
#line 226 "calendar-wall-time.c"
	} else {
		gint _tmp7_ = 0;
#line 106 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp7_ = hour;
#line 106 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		if (_tmp7_ > 12) {
#line 233 "calendar-wall-time.c"
			gint _tmp8_ = 0;
#line 107 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp8_ = hour;
#line 107 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			california_calendar_wall_time_set_12hour (self, _tmp8_ - 12);
#line 239 "calendar-wall-time.c"
		} else {
			gint _tmp9_ = 0;
#line 109 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp9_ = hour;
#line 109 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			california_calendar_wall_time_set_12hour (self, _tmp9_);
#line 246 "calendar-wall-time.c"
		}
	}
#line 99 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	return self;
#line 251 "calendar-wall-time.c"
}


CaliforniaCalendarWallTime* california_calendar_wall_time_new (gint hour, gint minute, gint second) {
#line 99 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	return california_calendar_wall_time_construct (CALIFORNIA_CALENDAR_TYPE_WALL_TIME, hour, minute, second);
#line 258 "calendar-wall-time.c"
}


/**
     * Called from Calendar.init().
     */
void california_calendar_wall_time_init (void) {
	CaliforniaCalendarWallTime* _tmp0_ = NULL;
	CaliforniaCalendarWallTime* _tmp1_ = NULL;
	CaliforniaCalendarWallTime* _tmp2_ = NULL;
	CaliforniaCalendarWallTime* _tmp3_ = NULL;
	CaliforniaCalendarWallTime* _tmp4_ = NULL;
	CaliforniaCalendarWallTime* _tmp5_ = NULL;
	CaliforniaCalendarWallTime* _tmp6_ = NULL;
	CaliforniaCalendarWallTime* _tmp7_ = NULL;
#line 116 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp0_ = california_calendar_wall_time_get_earliest ();
#line 116 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp1_ = _tmp0_;
#line 116 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp2_ = california_calendar_wall_time_new (CALIFORNIA_CALENDAR_WALL_TIME_MIN_HOUR, CALIFORNIA_CALENDAR_WALL_TIME_MIN_MINUTE, CALIFORNIA_CALENDAR_WALL_TIME_MIN_SECOND);
#line 116 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp3_ = _tmp2_;
#line 116 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	california_calendar_wall_time_set_earliest (_tmp3_);
#line 116 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_g_object_unref0 (_tmp3_);
#line 117 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp4_ = california_calendar_wall_time_get_latest ();
#line 117 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp5_ = _tmp4_;
#line 117 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp6_ = california_calendar_wall_time_new (CALIFORNIA_CALENDAR_WALL_TIME_MAX_HOUR, CALIFORNIA_CALENDAR_WALL_TIME_MAX_MINUTE, CALIFORNIA_CALENDAR_WALL_TIME_MAX_SECOND);
#line 117 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp7_ = _tmp6_;
#line 117 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	california_calendar_wall_time_set_latest (_tmp7_);
#line 117 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_g_object_unref0 (_tmp7_);
#line 298 "calendar-wall-time.c"
}


/**
     * Called from Calendar.terminate().
     */
void california_calendar_wall_time_terminate (void) {
	CaliforniaCalendarWallTime* _tmp0_ = NULL;
	CaliforniaCalendarWallTime* _tmp1_ = NULL;
	CaliforniaCalendarWallTime* _tmp2_ = NULL;
	CaliforniaCalendarWallTime* _tmp3_ = NULL;
#line 124 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp0_ = california_calendar_wall_time_get_earliest ();
#line 124 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp1_ = _tmp0_;
#line 124 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	california_calendar_wall_time_set_earliest (NULL);
#line 125 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp2_ = california_calendar_wall_time_get_latest ();
#line 125 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp3_ = _tmp2_;
#line 125 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	california_calendar_wall_time_set_latest (NULL);
#line 322 "calendar-wall-time.c"
}


/**
     * Attempt to convert a string into {@link WallTime}.
     *
     * 24-hour and 12-hour time is recognized, as are localized versions of AM and PM.  If the time
     * was "liberally" parsed (in other words, "8" is converted to 8am), the returned flag is
     * cleared.
     */
static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
#line 1115 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1116 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
	_tmp0_ = g_strdup (self);
#line 1116 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
	_result_ = _tmp0_;
#line 1117 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
	_tmp1_ = _result_;
#line 1117 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
	g_strstrip (_tmp1_);
#line 1118 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
	result = _result_;
#line 1118 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
	return result;
#line 352 "calendar-wall-time.c"
}


static gint string_index_of (const gchar* self, const gchar* needle, gint start_index) {
	gint result = 0;
	gchar* _result_ = NULL;
	gint _tmp0_ = 0;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
#line 900 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0);
#line 900 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
	g_return_val_if_fail (needle != NULL, 0);
#line 901 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
	_tmp0_ = start_index;
#line 901 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
	_tmp1_ = needle;
#line 901 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
	_tmp2_ = strstr (((gchar*) self) + _tmp0_, (gchar*) _tmp1_);
#line 901 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
	_result_ = _tmp2_;
#line 903 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
	_tmp3_ = _result_;
#line 903 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
	if (_tmp3_ != NULL) {
#line 379 "calendar-wall-time.c"
		gchar* _tmp4_ = NULL;
#line 904 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
		_tmp4_ = _result_;
#line 904 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
		result = (gint) (_tmp4_ - ((gchar*) self));
#line 904 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
		return result;
#line 387 "calendar-wall-time.c"
	} else {
#line 906 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
		result = -1;
#line 906 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
		return result;
#line 393 "calendar-wall-time.c"
	}
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
#line 1282 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1282 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
	g_return_val_if_fail (old != NULL, NULL);
#line 1282 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
	g_return_val_if_fail (replacement != NULL, NULL);
#line 407 "calendar-wall-time.c"
	{
		GRegex* regex = NULL;
		const gchar* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		GRegex* _tmp3_ = NULL;
		GRegex* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		GRegex* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
#line 1284 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
		_tmp0_ = old;
#line 1284 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
#line 1284 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
		_tmp2_ = _tmp1_;
#line 1284 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
#line 1284 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
		_tmp4_ = _tmp3_;
#line 1284 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
		_g_free0 (_tmp2_);
#line 1284 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
		regex = _tmp4_;
#line 1284 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1284 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 438 "calendar-wall-time.c"
				goto __catch29_g_regex_error;
			}
#line 1284 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1284 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
			g_clear_error (&_inner_error_);
#line 1284 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
			return NULL;
#line 447 "calendar-wall-time.c"
		}
#line 1285 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
		_tmp6_ = regex;
#line 1285 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
		_tmp7_ = replacement;
#line 1285 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
		_tmp8_ = g_regex_replace_literal (_tmp6_, self, (gssize) (-1), 0, _tmp7_, 0, &_inner_error_);
#line 1285 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
		_tmp5_ = _tmp8_;
#line 1285 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1285 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1285 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 463 "calendar-wall-time.c"
				goto __catch29_g_regex_error;
			}
#line 1285 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1285 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1285 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
			g_clear_error (&_inner_error_);
#line 1285 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
			return NULL;
#line 474 "calendar-wall-time.c"
		}
#line 1285 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
		_tmp9_ = _tmp5_;
#line 1285 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
		_tmp5_ = NULL;
#line 1285 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
		result = _tmp9_;
#line 1285 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
		_g_free0 (_tmp5_);
#line 1285 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
		_g_regex_unref0 (regex);
#line 1285 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
		return result;
#line 488 "calendar-wall-time.c"
	}
	goto __finally29;
	__catch29_g_regex_error:
	{
		GError* e = NULL;
#line 1283 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
		e = _inner_error_;
#line 1283 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
		_inner_error_ = NULL;
#line 1287 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
		g_assert_not_reached ();
#line 1283 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
		_g_error_free0 (e);
#line 502 "calendar-wall-time.c"
	}
	__finally29:
#line 1283 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1283 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1283 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
		g_clear_error (&_inner_error_);
#line 1283 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
		return NULL;
#line 513 "calendar-wall-time.c"
	}
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	glong string_length = 0L;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	glong _tmp2_ = 0L;
	glong _tmp5_ = 0L;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_ = 0L;
	gboolean _tmp12_ = FALSE;
	glong _tmp13_ = 0L;
	glong _tmp16_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	gchar* _tmp21_ = NULL;
#line 1230 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1231 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
	_tmp0_ = strlen (self);
#line 1231 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 1231 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
	string_length = (glong) _tmp1_;
#line 1232 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
	_tmp2_ = start;
#line 1232 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
	if (_tmp2_ < ((glong) 0)) {
#line 547 "calendar-wall-time.c"
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
#line 1233 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
		_tmp3_ = string_length;
#line 1233 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
		_tmp4_ = start;
#line 1233 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
		start = _tmp3_ + _tmp4_;
#line 556 "calendar-wall-time.c"
	}
#line 1235 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
	_tmp5_ = end;
#line 1235 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
	if (_tmp5_ < ((glong) 0)) {
#line 562 "calendar-wall-time.c"
		glong _tmp6_ = 0L;
		glong _tmp7_ = 0L;
#line 1236 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
		_tmp6_ = string_length;
#line 1236 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
		_tmp7_ = end;
#line 1236 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
		end = _tmp6_ + _tmp7_;
#line 571 "calendar-wall-time.c"
	}
#line 1238 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
	_tmp9_ = start;
#line 1238 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
	if (_tmp9_ >= ((glong) 0)) {
#line 577 "calendar-wall-time.c"
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
#line 1238 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
		_tmp10_ = start;
#line 1238 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
		_tmp11_ = string_length;
#line 1238 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
		_tmp8_ = _tmp10_ <= _tmp11_;
#line 586 "calendar-wall-time.c"
	} else {
#line 1238 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
		_tmp8_ = FALSE;
#line 590 "calendar-wall-time.c"
	}
#line 1238 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp8_, NULL);
#line 1239 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
	_tmp13_ = end;
#line 1239 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
	if (_tmp13_ >= ((glong) 0)) {
#line 598 "calendar-wall-time.c"
		glong _tmp14_ = 0L;
		glong _tmp15_ = 0L;
#line 1239 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
		_tmp14_ = end;
#line 1239 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
		_tmp15_ = string_length;
#line 1239 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
		_tmp12_ = _tmp14_ <= _tmp15_;
#line 607 "calendar-wall-time.c"
	} else {
#line 1239 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
		_tmp12_ = FALSE;
#line 611 "calendar-wall-time.c"
	}
#line 1239 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp12_, NULL);
#line 1240 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
	_tmp16_ = start;
#line 1240 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
	_tmp17_ = end;
#line 1240 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp16_ <= _tmp17_, NULL);
#line 1241 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
	_tmp18_ = start;
#line 1241 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
	_tmp19_ = end;
#line 1241 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
	_tmp20_ = start;
#line 1241 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
	_tmp21_ = g_strndup (((gchar*) self) + _tmp18_, (gsize) (_tmp19_ - _tmp20_));
#line 1241 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
	result = _tmp21_;
#line 1241 "/usr/local/share/vala-0.26/vapi/glib-2.0.vapi"
	return result;
#line 633 "calendar-wall-time.c"
}


CaliforniaCalendarWallTime* california_calendar_wall_time_parse (const gchar* str, gboolean* strictly_parsed) {
	gboolean _vala_strictly_parsed = FALSE;
	CaliforniaCalendarWallTime* result = NULL;
	gchar* token = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	const gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gboolean _tmp11_ = FALSE;
	gboolean meridiem_unknown = FALSE;
	gboolean pm = FALSE;
	const gchar* _tmp19_ = NULL;
	gboolean _tmp20_ = FALSE;
	gboolean _tmp21_ = FALSE;
	gchar* _tmp22_ = NULL;
	gboolean has_colon = FALSE;
	const gchar* _tmp23_ = NULL;
	gint _tmp24_ = 0;
	const gchar* _tmp25_ = NULL;
	gchar* _tmp26_ = NULL;
	gint length = 0;
	const gchar* _tmp27_ = NULL;
	gint _tmp28_ = 0;
	gint _tmp29_ = 0;
	gboolean _tmp30_ = FALSE;
	gboolean _tmp31_ = FALSE;
	const gchar* _tmp32_ = NULL;
	gboolean _tmp33_ = FALSE;
	gboolean _tmp36_ = FALSE;
	gint _tmp37_ = 0;
	gint h = 0;
	const gchar* _tmp76_ = NULL;
	gint _tmp77_ = 0;
	gboolean _tmp78_ = FALSE;
	gboolean _tmp79_ = FALSE;
	gboolean _tmp80_ = FALSE;
	gint _tmp84_ = 0;
	gboolean _tmp85_ = FALSE;
	gint _tmp86_ = 0;
	gboolean _tmp88_ = FALSE;
	gint _tmp89_ = 0;
	CaliforniaCalendarWallTime* _tmp90_ = NULL;
#line 135 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	g_return_val_if_fail (str != NULL, NULL);
#line 136 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_vala_strictly_parsed = FALSE;
#line 138 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp0_ = str;
#line 138 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp1_ = string_strip (_tmp0_);
#line 138 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp2_ = _tmp1_;
#line 138 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp3_ = g_utf8_casefold (_tmp2_, (gssize) (-1));
#line 138 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp4_ = _tmp3_;
#line 138 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_g_free0 (_tmp2_);
#line 138 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	token = _tmp4_;
#line 139 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp5_ = token;
#line 139 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp6_ = california_string_is_empty (_tmp5_);
#line 139 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (_tmp6_) {
#line 140 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		result = NULL;
#line 140 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_g_free0 (token);
#line 140 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		if (strictly_parsed) {
#line 140 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			*strictly_parsed = _vala_strictly_parsed;
#line 718 "calendar-wall-time.c"
		}
#line 140 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		return result;
#line 722 "calendar-wall-time.c"
	}
#line 143 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp7_ = token;
#line 143 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp8_ = california_calendar_MIDNIGHT;
#line 143 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp9_ = g_utf8_casefold (_tmp8_, (gssize) (-1));
#line 143 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp10_ = _tmp9_;
#line 143 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp11_ = g_strcmp0 (_tmp7_, _tmp10_) == 0;
#line 143 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_g_free0 (_tmp10_);
#line 143 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (_tmp11_) {
#line 738 "calendar-wall-time.c"
		CaliforniaCalendarWallTime* _tmp12_ = NULL;
#line 144 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_vala_strictly_parsed = TRUE;
#line 146 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp12_ = california_calendar_wall_time_new (0, 0, 0);
#line 146 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		result = _tmp12_;
#line 146 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_g_free0 (token);
#line 146 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		if (strictly_parsed) {
#line 146 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			*strictly_parsed = _vala_strictly_parsed;
#line 752 "calendar-wall-time.c"
		}
#line 146 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		return result;
#line 756 "calendar-wall-time.c"
	} else {
		const gchar* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
		gchar* _tmp15_ = NULL;
		gchar* _tmp16_ = NULL;
		gboolean _tmp17_ = FALSE;
#line 147 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp13_ = token;
#line 147 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp14_ = california_calendar_NOON;
#line 147 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp15_ = g_utf8_casefold (_tmp14_, (gssize) (-1));
#line 147 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp16_ = _tmp15_;
#line 147 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp17_ = g_strcmp0 (_tmp13_, _tmp16_) == 0;
#line 147 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_g_free0 (_tmp16_);
#line 147 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		if (_tmp17_) {
#line 777 "calendar-wall-time.c"
			CaliforniaCalendarWallTime* _tmp18_ = NULL;
#line 148 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_vala_strictly_parsed = TRUE;
#line 150 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp18_ = california_calendar_wall_time_new (12, 0, 0);
#line 150 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			result = _tmp18_;
#line 150 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_g_free0 (token);
#line 150 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			if (strictly_parsed) {
#line 150 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
				*strictly_parsed = _vala_strictly_parsed;
#line 791 "calendar-wall-time.c"
			}
#line 150 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			return result;
#line 795 "calendar-wall-time.c"
		}
	}
#line 154 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp19_ = token;
#line 154 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp22_ = california_calendar_parse_meridiem (_tmp19_, &_tmp20_, &_tmp21_);
#line 154 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	meridiem_unknown = _tmp20_;
#line 154 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	pm = _tmp21_;
#line 154 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_g_free0 (token);
#line 154 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	token = _tmp22_;
#line 157 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp23_ = token;
#line 157 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp24_ = string_index_of (_tmp23_, ":", 0);
#line 157 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	has_colon = _tmp24_ > 0;
#line 158 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp25_ = token;
#line 158 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp26_ = string_replace (_tmp25_, ":", "");
#line 158 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_g_free0 (token);
#line 158 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	token = _tmp26_;
#line 159 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp27_ = token;
#line 159 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp28_ = strlen (_tmp27_);
#line 159 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp29_ = _tmp28_;
#line 159 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	length = _tmp29_;
#line 162 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp32_ = token;
#line 162 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp33_ = california_string_is_numeric (_tmp32_);
#line 162 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (!_tmp33_) {
#line 162 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp31_ = TRUE;
#line 840 "calendar-wall-time.c"
	} else {
		gint _tmp34_ = 0;
#line 162 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp34_ = length;
#line 162 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp31_ = _tmp34_ == 0;
#line 847 "calendar-wall-time.c"
	}
#line 162 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (_tmp31_) {
#line 162 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp30_ = TRUE;
#line 853 "calendar-wall-time.c"
	} else {
		gint _tmp35_ = 0;
#line 162 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp35_ = length;
#line 162 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp30_ = _tmp35_ > 4;
#line 860 "calendar-wall-time.c"
	}
#line 162 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (_tmp30_) {
#line 163 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		result = NULL;
#line 163 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_g_free0 (token);
#line 163 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		if (strictly_parsed) {
#line 163 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			*strictly_parsed = _vala_strictly_parsed;
#line 872 "calendar-wall-time.c"
		}
#line 163 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		return result;
#line 876 "calendar-wall-time.c"
	}
#line 166 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp37_ = length;
#line 166 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (_tmp37_ == 3) {
#line 166 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp36_ = TRUE;
#line 884 "calendar-wall-time.c"
	} else {
		gint _tmp38_ = 0;
#line 166 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp38_ = length;
#line 166 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp36_ = _tmp38_ == 4;
#line 891 "calendar-wall-time.c"
	}
#line 166 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (_tmp36_) {
#line 895 "calendar-wall-time.c"
		gboolean _tmp39_ = FALSE;
		gint h = 0;
		gint m = 0;
		gint _tmp40_ = 0;
		gboolean _tmp57_ = FALSE;
		gboolean _tmp58_ = FALSE;
		gboolean _tmp59_ = FALSE;
		gboolean _tmp63_ = FALSE;
		gint _tmp64_ = 0;
		gboolean _tmp66_ = FALSE;
		gboolean _tmp67_ = FALSE;
		gboolean _tmp68_ = FALSE;
		gint _tmp69_ = 0;
		gint _tmp73_ = 0;
		gint _tmp74_ = 0;
		CaliforniaCalendarWallTime* _tmp75_ = NULL;
#line 169 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp39_ = has_colon;
#line 169 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		if (!_tmp39_) {
#line 170 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			result = NULL;
#line 170 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_g_free0 (token);
#line 170 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			if (strictly_parsed) {
#line 170 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
				*strictly_parsed = _vala_strictly_parsed;
#line 924 "calendar-wall-time.c"
			}
#line 170 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			return result;
#line 928 "calendar-wall-time.c"
		}
#line 173 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp40_ = length;
#line 173 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		if (_tmp40_ == 3) {
#line 934 "calendar-wall-time.c"
			const gchar* _tmp41_ = NULL;
			gchar* _tmp42_ = NULL;
			gchar* _tmp43_ = NULL;
			gint _tmp44_ = 0;
			const gchar* _tmp45_ = NULL;
			gchar* _tmp46_ = NULL;
			gchar* _tmp47_ = NULL;
			gint _tmp48_ = 0;
#line 174 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp41_ = token;
#line 174 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp42_ = string_slice (_tmp41_, (glong) 0, (glong) 1);
#line 174 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp43_ = _tmp42_;
#line 174 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp44_ = atoi (_tmp43_);
#line 174 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			h = _tmp44_;
#line 174 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_g_free0 (_tmp43_);
#line 175 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp45_ = token;
#line 175 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp46_ = string_slice (_tmp45_, (glong) 1, (glong) 3);
#line 175 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp47_ = _tmp46_;
#line 175 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp48_ = atoi (_tmp47_);
#line 175 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			m = _tmp48_;
#line 175 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_g_free0 (_tmp47_);
#line 967 "calendar-wall-time.c"
		} else {
			const gchar* _tmp49_ = NULL;
			gchar* _tmp50_ = NULL;
			gchar* _tmp51_ = NULL;
			gint _tmp52_ = 0;
			const gchar* _tmp53_ = NULL;
			gchar* _tmp54_ = NULL;
			gchar* _tmp55_ = NULL;
			gint _tmp56_ = 0;
#line 177 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp49_ = token;
#line 177 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp50_ = string_slice (_tmp49_, (glong) 0, (glong) 2);
#line 177 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp51_ = _tmp50_;
#line 177 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp52_ = atoi (_tmp51_);
#line 177 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			h = _tmp52_;
#line 177 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_g_free0 (_tmp51_);
#line 178 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp53_ = token;
#line 178 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp54_ = string_slice (_tmp53_, (glong) 2, (glong) 4);
#line 178 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp55_ = _tmp54_;
#line 178 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp56_ = atoi (_tmp55_);
#line 178 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			m = _tmp56_;
#line 178 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_g_free0 (_tmp55_);
#line 1001 "calendar-wall-time.c"
		}
#line 183 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp59_ = meridiem_unknown;
#line 183 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		if (!_tmp59_) {
#line 1007 "calendar-wall-time.c"
			gboolean _tmp60_ = FALSE;
#line 183 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp60_ = pm;
#line 183 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp58_ = _tmp60_;
#line 1013 "calendar-wall-time.c"
		} else {
#line 183 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp58_ = FALSE;
#line 1017 "calendar-wall-time.c"
		}
#line 183 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		if (_tmp58_) {
#line 1021 "calendar-wall-time.c"
			gint _tmp61_ = 0;
#line 183 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp61_ = h;
#line 183 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp57_ = _tmp61_ != 12;
#line 1027 "calendar-wall-time.c"
		} else {
#line 183 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp57_ = FALSE;
#line 1031 "calendar-wall-time.c"
		}
#line 183 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		if (_tmp57_) {
#line 1035 "calendar-wall-time.c"
			gint _tmp62_ = 0;
#line 184 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp62_ = h;
#line 184 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			h = _tmp62_ + 12;
#line 1041 "calendar-wall-time.c"
		}
#line 187 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp64_ = h;
#line 187 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		if (_tmp64_ == 24) {
#line 1047 "calendar-wall-time.c"
			gint _tmp65_ = 0;
#line 187 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp65_ = m;
#line 187 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp63_ = _tmp65_ == 0;
#line 1053 "calendar-wall-time.c"
		} else {
#line 187 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp63_ = FALSE;
#line 1057 "calendar-wall-time.c"
		}
#line 187 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		if (_tmp63_) {
#line 188 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			h = 0;
#line 1063 "calendar-wall-time.c"
		}
#line 192 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp69_ = h;
#line 192 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		if (_tmp69_ < CALIFORNIA_CALENDAR_WALL_TIME_MIN_HOUR) {
#line 192 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp68_ = TRUE;
#line 1071 "calendar-wall-time.c"
		} else {
			gint _tmp70_ = 0;
#line 192 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp70_ = h;
#line 192 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp68_ = _tmp70_ > CALIFORNIA_CALENDAR_WALL_TIME_MAX_HOUR;
#line 1078 "calendar-wall-time.c"
		}
#line 192 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		if (_tmp68_) {
#line 192 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp67_ = TRUE;
#line 1084 "calendar-wall-time.c"
		} else {
			gint _tmp71_ = 0;
#line 192 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp71_ = m;
#line 192 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp67_ = _tmp71_ < CALIFORNIA_CALENDAR_WALL_TIME_MIN_MINUTE;
#line 1091 "calendar-wall-time.c"
		}
#line 192 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		if (_tmp67_) {
#line 192 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp66_ = TRUE;
#line 1097 "calendar-wall-time.c"
		} else {
			gint _tmp72_ = 0;
#line 192 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp72_ = m;
#line 192 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp66_ = _tmp72_ > CALIFORNIA_CALENDAR_WALL_TIME_MAX_MINUTE;
#line 1104 "calendar-wall-time.c"
		}
#line 192 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		if (_tmp66_) {
#line 193 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			result = NULL;
#line 193 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_g_free0 (token);
#line 193 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			if (strictly_parsed) {
#line 193 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
				*strictly_parsed = _vala_strictly_parsed;
#line 1116 "calendar-wall-time.c"
			}
#line 193 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			return result;
#line 1120 "calendar-wall-time.c"
		}
#line 195 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_vala_strictly_parsed = TRUE;
#line 197 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp73_ = h;
#line 197 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp74_ = m;
#line 197 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp75_ = california_calendar_wall_time_new (_tmp73_, _tmp74_, 0);
#line 197 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		result = _tmp75_;
#line 197 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_g_free0 (token);
#line 197 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		if (strictly_parsed) {
#line 197 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			*strictly_parsed = _vala_strictly_parsed;
#line 1138 "calendar-wall-time.c"
		}
#line 197 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		return result;
#line 1142 "calendar-wall-time.c"
	}
#line 202 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp76_ = token;
#line 202 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp77_ = atoi (_tmp76_);
#line 202 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	h = _tmp77_;
#line 203 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp80_ = meridiem_unknown;
#line 203 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (!_tmp80_) {
#line 1154 "calendar-wall-time.c"
		gboolean _tmp81_ = FALSE;
#line 203 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp81_ = pm;
#line 203 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp79_ = _tmp81_;
#line 1160 "calendar-wall-time.c"
	} else {
#line 203 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp79_ = FALSE;
#line 1164 "calendar-wall-time.c"
	}
#line 203 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (_tmp79_) {
#line 1168 "calendar-wall-time.c"
		gint _tmp82_ = 0;
#line 203 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp82_ = h;
#line 203 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp78_ = _tmp82_ != 12;
#line 1174 "calendar-wall-time.c"
	} else {
#line 203 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp78_ = FALSE;
#line 1178 "calendar-wall-time.c"
	}
#line 203 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (_tmp78_) {
#line 1182 "calendar-wall-time.c"
		gint _tmp83_ = 0;
#line 204 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp83_ = h;
#line 204 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		h = _tmp83_ + 12;
#line 1188 "calendar-wall-time.c"
	}
#line 207 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp84_ = h;
#line 207 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (_tmp84_ == 24) {
#line 208 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		h = 0;
#line 1196 "calendar-wall-time.c"
	}
#line 211 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp86_ = h;
#line 211 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (_tmp86_ < CALIFORNIA_CALENDAR_WALL_TIME_MIN_HOUR) {
#line 211 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp85_ = TRUE;
#line 1204 "calendar-wall-time.c"
	} else {
		gint _tmp87_ = 0;
#line 211 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp87_ = h;
#line 211 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp85_ = _tmp87_ > CALIFORNIA_CALENDAR_WALL_TIME_MAX_HOUR;
#line 1211 "calendar-wall-time.c"
	}
#line 211 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (_tmp85_) {
#line 212 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		result = NULL;
#line 212 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_g_free0 (token);
#line 212 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		if (strictly_parsed) {
#line 212 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			*strictly_parsed = _vala_strictly_parsed;
#line 1223 "calendar-wall-time.c"
		}
#line 212 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		return result;
#line 1227 "calendar-wall-time.c"
	}
#line 214 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp88_ = meridiem_unknown;
#line 214 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_vala_strictly_parsed = !_tmp88_;
#line 216 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp89_ = h;
#line 216 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp90_ = california_calendar_wall_time_new (_tmp89_, 0, 0);
#line 216 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	result = _tmp90_;
#line 216 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_g_free0 (token);
#line 216 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (strictly_parsed) {
#line 216 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		*strictly_parsed = _vala_strictly_parsed;
#line 1245 "calendar-wall-time.c"
	}
#line 216 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	return result;
#line 1249 "calendar-wall-time.c"
}


/**
     * Returns {@link WallTime} adjusted before or after this one.
     *
     * To subtract time, use a negative value.
     *
     * Like a wall clock, this will rollover to the next or previous day if enough time is
     * specified.  When this occurs, it's indicated in the rollover bool as an out result.
     */
static gpointer _g_object_ref0 (gpointer self) {
#line 231 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	return self ? g_object_ref (self) : NULL;
#line 1264 "calendar-wall-time.c"
}


CaliforniaCalendarWallTime* california_calendar_wall_time_adjust (CaliforniaCalendarWallTime* self, gint value, CaliforniaCalendarTimeUnit unit, gboolean* rollover) {
	gboolean _vala_rollover = FALSE;
	CaliforniaCalendarWallTime* result = NULL;
	gint _tmp0_ = 0;
	gint new_hour = 0;
	gint _tmp2_ = 0;
	gint new_minute = 0;
	gint _tmp3_ = 0;
	gint new_second = 0;
	gint _tmp4_ = 0;
	CaliforniaCalendarTimeUnit _tmp5_ = 0;
	gint _tmp12_ = 0;
	gint _tmp13_ = 0;
	gint _tmp14_ = 0;
	CaliforniaCalendarWallTime* _tmp15_ = NULL;
#line 227 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_WALL_TIME (self), NULL);
#line 228 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp0_ = value;
#line 228 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (_tmp0_ == 0) {
#line 1289 "calendar-wall-time.c"
		CaliforniaCalendarWallTime* _tmp1_ = NULL;
#line 229 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_vala_rollover = FALSE;
#line 231 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp1_ = _g_object_ref0 (self);
#line 231 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		result = _tmp1_;
#line 231 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		if (rollover) {
#line 231 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			*rollover = _vala_rollover;
#line 1301 "calendar-wall-time.c"
		}
#line 231 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		return result;
#line 1305 "calendar-wall-time.c"
	}
#line 234 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp2_ = self->priv->_hour;
#line 234 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	new_hour = _tmp2_;
#line 235 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp3_ = self->priv->_minute;
#line 235 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	new_minute = _tmp3_;
#line 236 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp4_ = self->priv->_second;
#line 236 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	new_second = _tmp4_;
#line 238 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp5_ = unit;
#line 238 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	switch (_tmp5_) {
#line 238 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		case CALIFORNIA_CALENDAR_TIME_UNIT_HOUR:
#line 1325 "calendar-wall-time.c"
		{
			gint _tmp6_ = 0;
			gboolean _tmp7_ = FALSE;
#line 240 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp6_ = value;
#line 240 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			california_calendar_wall_time_adjust_hour (self, &new_hour, _tmp6_, &_tmp7_);
#line 240 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_vala_rollover = _tmp7_;
#line 241 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			break;
#line 1337 "calendar-wall-time.c"
		}
#line 238 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		case CALIFORNIA_CALENDAR_TIME_UNIT_MINUTE:
#line 1341 "calendar-wall-time.c"
		{
			gint _tmp8_ = 0;
			gboolean _tmp9_ = FALSE;
#line 244 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp8_ = value;
#line 244 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			california_calendar_wall_time_adjust_minute (self, &new_hour, &new_minute, _tmp8_, &_tmp9_);
#line 244 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_vala_rollover = _tmp9_;
#line 245 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			break;
#line 1353 "calendar-wall-time.c"
		}
#line 238 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		case CALIFORNIA_CALENDAR_TIME_UNIT_SECOND:
#line 1357 "calendar-wall-time.c"
		{
			gint _tmp10_ = 0;
			gboolean _tmp11_ = FALSE;
#line 248 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp10_ = value;
#line 248 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			california_calendar_wall_time_adjust_second (self, &new_hour, &new_minute, &new_second, _tmp10_, &_tmp11_);
#line 248 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_vala_rollover = _tmp11_;
#line 249 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			break;
#line 1369 "calendar-wall-time.c"
		}
		default:
		{
#line 252 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			g_assert_not_reached ();
#line 1375 "calendar-wall-time.c"
		}
	}
#line 255 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp12_ = new_hour;
#line 255 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp13_ = new_minute;
#line 255 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp14_ = new_second;
#line 255 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp15_ = california_calendar_wall_time_new (_tmp12_, _tmp13_, _tmp14_);
#line 255 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	result = _tmp15_;
#line 255 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (rollover) {
#line 255 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		*rollover = _vala_rollover;
#line 1392 "calendar-wall-time.c"
	}
#line 255 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	return result;
#line 1396 "calendar-wall-time.c"
}


static void california_calendar_wall_time_adjust_hour (CaliforniaCalendarWallTime* self, gint* current_hour, gint value, gboolean* rollover) {
	gboolean _vala_rollover = FALSE;
	gint _tmp0_ = 0;
	gint rem = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
#line 258 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	g_return_if_fail (CALIFORNIA_CALENDAR_IS_WALL_TIME (self));
#line 259 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp0_ = value;
#line 259 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (_tmp0_ == 0) {
#line 260 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_vala_rollover = FALSE;
#line 262 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		if (rollover) {
#line 262 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			*rollover = _vala_rollover;
#line 1422 "calendar-wall-time.c"
		}
#line 262 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		return;
#line 1426 "calendar-wall-time.c"
	}
#line 267 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp1_ = value;
#line 267 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp2_ = abs (_tmp1_);
#line 267 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	rem = _tmp2_ % CALIFORNIA_CALENDAR_WALL_TIME_HOURS_PER_DAY;
#line 268 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp4_ = value;
#line 268 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (_tmp4_ > 0) {
#line 1438 "calendar-wall-time.c"
		gint _tmp5_ = 0;
#line 268 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp5_ = rem;
#line 268 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp3_ = _tmp5_;
#line 1444 "calendar-wall-time.c"
	} else {
		gint _tmp6_ = 0;
#line 268 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp6_ = rem;
#line 268 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp3_ = 0 - _tmp6_;
#line 1451 "calendar-wall-time.c"
	}
#line 268 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp7_ = *current_hour;
#line 268 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	*current_hour = _tmp7_ + _tmp3_;
#line 271 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp8_ = *current_hour;
#line 271 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (_tmp8_ < 0) {
#line 1461 "calendar-wall-time.c"
		gint _tmp9_ = 0;
		gint _tmp10_ = 0;
#line 272 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp9_ = *current_hour;
#line 272 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp10_ = abs (_tmp9_);
#line 272 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		*current_hour = CALIFORNIA_CALENDAR_WALL_TIME_HOURS_PER_DAY - _tmp10_;
#line 273 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_vala_rollover = TRUE;
#line 1472 "calendar-wall-time.c"
	} else {
		gint _tmp11_ = 0;
#line 274 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp11_ = *current_hour;
#line 274 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		if (_tmp11_ >= CALIFORNIA_CALENDAR_WALL_TIME_HOURS_PER_DAY) {
#line 1479 "calendar-wall-time.c"
			gint _tmp12_ = 0;
#line 275 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp12_ = *current_hour;
#line 275 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			*current_hour = _tmp12_ - CALIFORNIA_CALENDAR_WALL_TIME_HOURS_PER_DAY;
#line 276 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_vala_rollover = TRUE;
#line 1487 "calendar-wall-time.c"
		} else {
			gint _tmp13_ = 0;
			gint _tmp14_ = 0;
#line 277 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp13_ = value;
#line 277 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp14_ = abs (_tmp13_);
#line 277 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			if (_tmp14_ >= CALIFORNIA_CALENDAR_WALL_TIME_HOURS_PER_DAY) {
#line 278 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
				_vala_rollover = TRUE;
#line 1499 "calendar-wall-time.c"
			} else {
#line 280 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
				_vala_rollover = FALSE;
#line 1503 "calendar-wall-time.c"
			}
		}
	}
#line 258 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (rollover) {
#line 258 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		*rollover = _vala_rollover;
#line 1511 "calendar-wall-time.c"
	}
}


static void california_calendar_wall_time_adjust_minute (CaliforniaCalendarWallTime* self, gint* current_hour, gint* current_minute, gint value, gboolean* rollover) {
	gboolean _vala_rollover = FALSE;
	gint _tmp0_ = 0;
	gint hours = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gboolean _tmp7_ = FALSE;
	gint rem = 0;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	gint _tmp14_ = 0;
	gint _tmp15_ = 0;
#line 284 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	g_return_if_fail (CALIFORNIA_CALENDAR_IS_WALL_TIME (self));
#line 285 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp0_ = value;
#line 285 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (_tmp0_ == 0) {
#line 286 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_vala_rollover = FALSE;
#line 288 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		if (rollover) {
#line 288 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			*rollover = _vala_rollover;
#line 1544 "calendar-wall-time.c"
		}
#line 288 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		return;
#line 1548 "calendar-wall-time.c"
	}
#line 291 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp1_ = value;
#line 291 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp2_ = abs (_tmp1_);
#line 291 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	hours = _tmp2_ / CALIFORNIA_CALENDAR_WALL_TIME_MINUTES_PER_HOUR;
#line 292 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp4_ = value;
#line 292 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (_tmp4_ > 0) {
#line 1560 "calendar-wall-time.c"
		gint _tmp5_ = 0;
#line 292 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp5_ = hours;
#line 292 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp3_ = _tmp5_;
#line 1566 "calendar-wall-time.c"
	} else {
		gint _tmp6_ = 0;
#line 292 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp6_ = hours;
#line 292 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp3_ = 0 - _tmp6_;
#line 1573 "calendar-wall-time.c"
	}
#line 292 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	california_calendar_wall_time_adjust_hour (self, current_hour, _tmp3_, &_tmp7_);
#line 292 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_vala_rollover = _tmp7_;
#line 294 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp8_ = value;
#line 294 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp9_ = abs (_tmp8_);
#line 294 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	rem = _tmp9_ % CALIFORNIA_CALENDAR_WALL_TIME_MINUTES_PER_HOUR;
#line 295 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp11_ = value;
#line 295 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (_tmp11_ > 0) {
#line 1589 "calendar-wall-time.c"
		gint _tmp12_ = 0;
#line 295 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp12_ = rem;
#line 295 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp10_ = _tmp12_;
#line 1595 "calendar-wall-time.c"
	} else {
		gint _tmp13_ = 0;
#line 295 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp13_ = rem;
#line 295 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp10_ = 0 - _tmp13_;
#line 1602 "calendar-wall-time.c"
	}
#line 295 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp14_ = *current_minute;
#line 295 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	*current_minute = _tmp14_ + _tmp10_;
#line 298 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp15_ = *current_minute;
#line 298 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (_tmp15_ < 0) {
#line 1612 "calendar-wall-time.c"
		gint _tmp16_ = 0;
		gint _tmp17_ = 0;
		gboolean under_rollover = FALSE;
		gboolean _tmp18_ = FALSE;
		gboolean _tmp19_ = FALSE;
		gboolean _tmp20_ = FALSE;
#line 299 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp16_ = *current_minute;
#line 299 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp17_ = abs (_tmp16_);
#line 299 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		*current_minute = CALIFORNIA_CALENDAR_WALL_TIME_MINUTES_PER_HOUR - _tmp17_;
#line 301 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		california_calendar_wall_time_adjust_hour (self, current_hour, -1, &_tmp18_);
#line 301 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		under_rollover = _tmp18_;
#line 302 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp20_ = _vala_rollover;
#line 302 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		if (_tmp20_) {
#line 302 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp19_ = TRUE;
#line 1635 "calendar-wall-time.c"
		} else {
			gboolean _tmp21_ = FALSE;
#line 302 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp21_ = under_rollover;
#line 302 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp19_ = _tmp21_;
#line 1642 "calendar-wall-time.c"
		}
#line 302 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_vala_rollover = _tmp19_;
#line 1646 "calendar-wall-time.c"
	} else {
		gint _tmp22_ = 0;
#line 303 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp22_ = *current_minute;
#line 303 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		if (_tmp22_ >= CALIFORNIA_CALENDAR_WALL_TIME_MINUTES_PER_HOUR) {
#line 1653 "calendar-wall-time.c"
			gint _tmp23_ = 0;
			gboolean over_rollover = FALSE;
			gboolean _tmp24_ = FALSE;
			gboolean _tmp25_ = FALSE;
			gboolean _tmp26_ = FALSE;
#line 304 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp23_ = *current_minute;
#line 304 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			*current_minute = _tmp23_ - CALIFORNIA_CALENDAR_WALL_TIME_MINUTES_PER_HOUR;
#line 306 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			california_calendar_wall_time_adjust_hour (self, current_hour, 1, &_tmp24_);
#line 306 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			over_rollover = _tmp24_;
#line 307 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp26_ = _vala_rollover;
#line 307 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			if (_tmp26_) {
#line 307 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
				_tmp25_ = TRUE;
#line 1673 "calendar-wall-time.c"
			} else {
				gboolean _tmp27_ = FALSE;
#line 307 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
				_tmp27_ = over_rollover;
#line 307 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
				_tmp25_ = _tmp27_;
#line 1680 "calendar-wall-time.c"
			}
#line 307 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_vala_rollover = _tmp25_;
#line 1684 "calendar-wall-time.c"
		}
	}
#line 284 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (rollover) {
#line 284 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		*rollover = _vala_rollover;
#line 1691 "calendar-wall-time.c"
	}
}


static void california_calendar_wall_time_adjust_second (CaliforniaCalendarWallTime* self, gint* current_hour, gint* current_minute, gint* current_second, gint value, gboolean* rollover) {
	gboolean _vala_rollover = FALSE;
	gint _tmp0_ = 0;
	gint minutes = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gboolean _tmp7_ = FALSE;
	gint rem = 0;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	gint _tmp14_ = 0;
	gint _tmp15_ = 0;
#line 311 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	g_return_if_fail (CALIFORNIA_CALENDAR_IS_WALL_TIME (self));
#line 313 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp0_ = value;
#line 313 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (_tmp0_ == 0) {
#line 314 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_vala_rollover = FALSE;
#line 316 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		if (rollover) {
#line 316 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			*rollover = _vala_rollover;
#line 1724 "calendar-wall-time.c"
		}
#line 316 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		return;
#line 1728 "calendar-wall-time.c"
	}
#line 319 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp1_ = value;
#line 319 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp2_ = abs (_tmp1_);
#line 319 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	minutes = _tmp2_ / CALIFORNIA_CALENDAR_WALL_TIME_SECONDS_PER_MINUTE;
#line 320 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp4_ = value;
#line 320 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (_tmp4_ > 0) {
#line 1740 "calendar-wall-time.c"
		gint _tmp5_ = 0;
#line 320 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp5_ = minutes;
#line 320 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp3_ = _tmp5_;
#line 1746 "calendar-wall-time.c"
	} else {
		gint _tmp6_ = 0;
#line 320 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp6_ = minutes;
#line 320 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp3_ = 0 - _tmp6_;
#line 1753 "calendar-wall-time.c"
	}
#line 320 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	california_calendar_wall_time_adjust_minute (self, current_hour, current_minute, _tmp3_, &_tmp7_);
#line 320 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_vala_rollover = _tmp7_;
#line 323 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp8_ = value;
#line 323 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp9_ = abs (_tmp8_);
#line 323 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	rem = _tmp9_ % CALIFORNIA_CALENDAR_WALL_TIME_SECONDS_PER_MINUTE;
#line 324 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp11_ = value;
#line 324 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (_tmp11_ > 0) {
#line 1769 "calendar-wall-time.c"
		gint _tmp12_ = 0;
#line 324 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp12_ = rem;
#line 324 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp10_ = _tmp12_;
#line 1775 "calendar-wall-time.c"
	} else {
		gint _tmp13_ = 0;
#line 324 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp13_ = rem;
#line 324 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp10_ = 0 - _tmp13_;
#line 1782 "calendar-wall-time.c"
	}
#line 324 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp14_ = *current_second;
#line 324 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	*current_second = _tmp14_ + _tmp10_;
#line 327 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp15_ = *current_second;
#line 327 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (_tmp15_ < 0) {
#line 1792 "calendar-wall-time.c"
		gint _tmp16_ = 0;
		gint _tmp17_ = 0;
		gboolean under_rollover = FALSE;
		gboolean _tmp18_ = FALSE;
		gboolean _tmp19_ = FALSE;
		gboolean _tmp20_ = FALSE;
#line 328 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp16_ = *current_second;
#line 328 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp17_ = abs (_tmp16_);
#line 328 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		*current_second = CALIFORNIA_CALENDAR_WALL_TIME_SECONDS_PER_MINUTE - _tmp17_;
#line 330 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		california_calendar_wall_time_adjust_minute (self, current_hour, current_minute, -1, &_tmp18_);
#line 330 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		under_rollover = _tmp18_;
#line 331 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp20_ = _vala_rollover;
#line 331 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		if (_tmp20_) {
#line 331 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp19_ = TRUE;
#line 1815 "calendar-wall-time.c"
		} else {
			gboolean _tmp21_ = FALSE;
#line 331 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp21_ = under_rollover;
#line 331 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp19_ = _tmp21_;
#line 1822 "calendar-wall-time.c"
		}
#line 331 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_vala_rollover = _tmp19_;
#line 1826 "calendar-wall-time.c"
	} else {
		gint _tmp22_ = 0;
#line 332 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp22_ = *current_second;
#line 332 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		if (_tmp22_ >= CALIFORNIA_CALENDAR_WALL_TIME_SECONDS_PER_MINUTE) {
#line 1833 "calendar-wall-time.c"
			gint _tmp23_ = 0;
			gboolean over_rollover = FALSE;
			gboolean _tmp24_ = FALSE;
			gboolean _tmp25_ = FALSE;
			gboolean _tmp26_ = FALSE;
#line 333 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp23_ = *current_second;
#line 333 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			*current_second = _tmp23_ - CALIFORNIA_CALENDAR_WALL_TIME_SECONDS_PER_MINUTE;
#line 335 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			california_calendar_wall_time_adjust_minute (self, current_hour, current_minute, 1, &_tmp24_);
#line 335 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			over_rollover = _tmp24_;
#line 336 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp26_ = _vala_rollover;
#line 336 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			if (_tmp26_) {
#line 336 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
				_tmp25_ = TRUE;
#line 1853 "calendar-wall-time.c"
			} else {
				gboolean _tmp27_ = FALSE;
#line 336 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
				_tmp27_ = over_rollover;
#line 336 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
				_tmp25_ = _tmp27_;
#line 1860 "calendar-wall-time.c"
			}
#line 336 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_vala_rollover = _tmp25_;
#line 1864 "calendar-wall-time.c"
		}
	}
#line 311 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (rollover) {
#line 311 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		*rollover = _vala_rollover;
#line 1871 "calendar-wall-time.c"
	}
}


/**
     * Round a unit of the {@link WallTime} to a multiple of a supplied value.
     *
     * Supply a positive integer to round up, a negative integer to round down.
     *
     * By rounding wall-clock time, not only is the unit in question rounded to a multiple of
     * the supplied value, but the lesser units are truncated to zero.  Thus, 17:23:54 rounded down
     * to a multiple of 10 minutes returns 17:20:00.
     *
     * rollover is set to true if rounding by the multiple rolls the WallTime over to the next day.
     * Rolling back to the previous day isn't possible with this interface; rounding down any value
     * earlier than midnight results in midnight.  Rollover can occur when rounding up.
     *
     * It's important to note that zero is treated as a multiple of all values.  Hence rounding
     * 11:56:00 up to a multiple of 17 minutes will result in 12:00:00.  (In other words, don't
     * confuse this method with {@link adjust}.
     *
     * If the {@link TimeUnit} is already a multiple of the value, no change is made (although
     * there's no guarantee that the same WallTime instance will be returned, especially if the
     * lesser units are truncated).
     *
     * A multiple of zero is always rounded to the current WallTime.
     */
CaliforniaCalendarWallTime* california_calendar_wall_time_round (CaliforniaCalendarWallTime* self, gint multiple, CaliforniaCalendarTimeUnit time_unit, gboolean* rollover) {
	gboolean _vala_rollover = FALSE;
	CaliforniaCalendarWallTime* result = NULL;
	gint _tmp0_ = 0;
	gint current = 0;
	gint max = 0;
	CaliforniaCalendarTimeUnit _tmp2_ = 0;
	gint rounded = 0;
	gint _tmp6_ = 0;
	CaliforniaCalendarWallTime* rounded_wall_time = NULL;
	gboolean adjust_rollover = FALSE;
	CaliforniaCalendarTimeUnit _tmp22_ = 0;
	gboolean _tmp40_ = FALSE;
	gboolean _tmp41_ = FALSE;
#line 363 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_WALL_TIME (self), NULL);
#line 364 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_vala_rollover = FALSE;
#line 366 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp0_ = multiple;
#line 366 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (_tmp0_ == 0) {
#line 1921 "calendar-wall-time.c"
		CaliforniaCalendarWallTime* _tmp1_ = NULL;
#line 367 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp1_ = _g_object_ref0 (self);
#line 367 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		result = _tmp1_;
#line 367 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		if (rollover) {
#line 367 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			*rollover = _vala_rollover;
#line 1931 "calendar-wall-time.c"
		}
#line 367 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		return result;
#line 1935 "calendar-wall-time.c"
	}
#line 371 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp2_ = time_unit;
#line 371 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	switch (_tmp2_) {
#line 371 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		case CALIFORNIA_CALENDAR_TIME_UNIT_HOUR:
#line 1943 "calendar-wall-time.c"
		{
			gint _tmp3_ = 0;
#line 373 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp3_ = self->priv->_hour;
#line 373 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			current = _tmp3_;
#line 374 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			max = CALIFORNIA_CALENDAR_WALL_TIME_MAX_HOUR;
#line 375 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			break;
#line 1954 "calendar-wall-time.c"
		}
#line 371 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		case CALIFORNIA_CALENDAR_TIME_UNIT_MINUTE:
#line 1958 "calendar-wall-time.c"
		{
			gint _tmp4_ = 0;
#line 378 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp4_ = self->priv->_minute;
#line 378 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			current = _tmp4_;
#line 379 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			max = CALIFORNIA_CALENDAR_WALL_TIME_MAX_MINUTE;
#line 380 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			break;
#line 1969 "calendar-wall-time.c"
		}
#line 371 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		case CALIFORNIA_CALENDAR_TIME_UNIT_SECOND:
#line 1973 "calendar-wall-time.c"
		{
			gint _tmp5_ = 0;
#line 383 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp5_ = self->priv->_second;
#line 383 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			current = _tmp5_;
#line 384 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			max = CALIFORNIA_CALENDAR_WALL_TIME_MAX_SECOND;
#line 385 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			break;
#line 1984 "calendar-wall-time.c"
		}
		default:
		{
#line 388 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			g_assert_not_reached ();
#line 1990 "calendar-wall-time.c"
		}
	}
#line 392 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp6_ = multiple;
#line 392 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (_tmp6_ < 0) {
#line 1997 "calendar-wall-time.c"
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
		gint _tmp9_ = 0;
		gint _tmp10_ = 0;
		gint _tmp11_ = 0;
#line 394 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp7_ = current;
#line 394 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp8_ = current;
#line 394 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp9_ = multiple;
#line 394 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp10_ = abs (_tmp9_);
#line 394 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		rounded = _tmp7_ - (_tmp8_ % _tmp10_);
#line 395 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp11_ = rounded;
#line 395 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_vala_assert (_tmp11_ >= 0, "rounded >= 0");
#line 2017 "calendar-wall-time.c"
	} else {
		gint _tmp12_ = 0;
		gint rem = 0;
		gint _tmp13_ = 0;
		gint _tmp14_ = 0;
		gint _tmp15_ = 0;
#line 397 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp12_ = multiple;
#line 397 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_vala_assert (_tmp12_ > 0, "multiple > 0");
#line 400 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp13_ = current;
#line 400 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp14_ = multiple;
#line 400 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		rem = _tmp13_ % _tmp14_;
#line 401 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp15_ = rem;
#line 401 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		if (_tmp15_ != 0) {
#line 2038 "calendar-wall-time.c"
			gint _tmp16_ = 0;
			gint _tmp17_ = 0;
			gint _tmp18_ = 0;
			gint _tmp19_ = 0;
			gint _tmp20_ = 0;
#line 402 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp16_ = current;
#line 402 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp17_ = multiple;
#line 402 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp18_ = rem;
#line 402 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			rounded = _tmp16_ + (_tmp17_ - _tmp18_);
#line 403 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp19_ = rounded;
#line 403 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp20_ = max;
#line 403 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			if (_tmp19_ > _tmp20_) {
#line 404 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
				rounded = 0;
#line 405 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
				_vala_rollover = TRUE;
#line 2062 "calendar-wall-time.c"
			}
		} else {
			gint _tmp21_ = 0;
#line 409 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp21_ = current;
#line 409 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			rounded = _tmp21_;
#line 2070 "calendar-wall-time.c"
		}
	}
#line 415 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	adjust_rollover = FALSE;
#line 416 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp22_ = time_unit;
#line 416 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	switch (_tmp22_) {
#line 416 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		case CALIFORNIA_CALENDAR_TIME_UNIT_HOUR:
#line 2081 "calendar-wall-time.c"
		{
			gint _tmp23_ = 0;
			CaliforniaCalendarWallTime* _tmp24_ = NULL;
#line 419 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp23_ = rounded;
#line 419 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp24_ = california_calendar_wall_time_new (_tmp23_, 0, 0);
#line 419 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_g_object_unref0 (rounded_wall_time);
#line 419 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			rounded_wall_time = _tmp24_;
#line 420 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			break;
#line 2095 "calendar-wall-time.c"
		}
#line 416 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		case CALIFORNIA_CALENDAR_TIME_UNIT_MINUTE:
#line 2099 "calendar-wall-time.c"
		{
			gint _tmp25_ = 0;
			gint _tmp26_ = 0;
			CaliforniaCalendarWallTime* _tmp27_ = NULL;
			gboolean _tmp28_ = FALSE;
#line 423 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp25_ = self->priv->_hour;
#line 423 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp26_ = rounded;
#line 423 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp27_ = california_calendar_wall_time_new (_tmp25_, _tmp26_, 0);
#line 423 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_g_object_unref0 (rounded_wall_time);
#line 423 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			rounded_wall_time = _tmp27_;
#line 424 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp28_ = _vala_rollover;
#line 424 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			if (_tmp28_) {
#line 2119 "calendar-wall-time.c"
				CaliforniaCalendarWallTime* _tmp29_ = NULL;
				gboolean _tmp30_ = FALSE;
				CaliforniaCalendarWallTime* _tmp31_ = NULL;
#line 425 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
				_tmp29_ = rounded_wall_time;
#line 425 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
				_tmp31_ = california_calendar_wall_time_adjust (_tmp29_, 1, CALIFORNIA_CALENDAR_TIME_UNIT_HOUR, &_tmp30_);
#line 425 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
				adjust_rollover = _tmp30_;
#line 425 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
				_g_object_unref0 (rounded_wall_time);
#line 425 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
				rounded_wall_time = _tmp31_;
#line 2133 "calendar-wall-time.c"
			}
#line 426 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			break;
#line 2137 "calendar-wall-time.c"
		}
#line 416 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		case CALIFORNIA_CALENDAR_TIME_UNIT_SECOND:
#line 2141 "calendar-wall-time.c"
		{
			gint _tmp32_ = 0;
			gint _tmp33_ = 0;
			gint _tmp34_ = 0;
			CaliforniaCalendarWallTime* _tmp35_ = NULL;
			gboolean _tmp36_ = FALSE;
#line 429 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp32_ = self->priv->_hour;
#line 429 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp33_ = self->priv->_minute;
#line 429 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp34_ = rounded;
#line 429 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp35_ = california_calendar_wall_time_new (_tmp32_, _tmp33_, _tmp34_);
#line 429 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_g_object_unref0 (rounded_wall_time);
#line 429 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			rounded_wall_time = _tmp35_;
#line 430 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp36_ = _vala_rollover;
#line 430 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			if (_tmp36_) {
#line 2164 "calendar-wall-time.c"
				CaliforniaCalendarWallTime* _tmp37_ = NULL;
				gboolean _tmp38_ = FALSE;
				CaliforniaCalendarWallTime* _tmp39_ = NULL;
#line 431 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
				_tmp37_ = rounded_wall_time;
#line 431 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
				_tmp39_ = california_calendar_wall_time_adjust (_tmp37_, 1, CALIFORNIA_CALENDAR_TIME_UNIT_MINUTE, &_tmp38_);
#line 431 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
				adjust_rollover = _tmp38_;
#line 431 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
				_g_object_unref0 (rounded_wall_time);
#line 431 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
				rounded_wall_time = _tmp39_;
#line 2178 "calendar-wall-time.c"
			}
#line 432 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			break;
#line 2182 "calendar-wall-time.c"
		}
		default:
		{
#line 435 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			g_assert_not_reached ();
#line 2188 "calendar-wall-time.c"
		}
	}
#line 439 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp41_ = _vala_rollover;
#line 439 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (_tmp41_) {
#line 439 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp40_ = TRUE;
#line 2197 "calendar-wall-time.c"
	} else {
		gboolean _tmp42_ = FALSE;
#line 439 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp42_ = adjust_rollover;
#line 439 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp40_ = _tmp42_;
#line 2204 "calendar-wall-time.c"
	}
#line 439 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_vala_rollover = _tmp40_;
#line 441 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	result = rounded_wall_time;
#line 441 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (rollover) {
#line 441 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		*rollover = _vala_rollover;
#line 2214 "calendar-wall-time.c"
	}
#line 441 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	return result;
#line 2218 "calendar-wall-time.c"
}


/**
     * Adjust the time by the specified amount without affecting other units.
     *
     * "Free adjust" is designed to work like adjusting a clock's time where each unit is disengaged
     * from the others.  That is, if the minutes setting is adjusted from 59 to 0, the hour remains
     * unchanged.
     *
     * An amount of zero returns the current {@link WallTime}.
     *
     * @see adjust
     */
CaliforniaCalendarWallTime* california_calendar_wall_time_free_adjust (CaliforniaCalendarWallTime* self, gint amount, CaliforniaCalendarTimeUnit time_unit) {
	CaliforniaCalendarWallTime* result = NULL;
	gint _tmp0_ = 0;
	CaliforniaCalendarWallTime* adjusted = NULL;
	gint _tmp2_ = 0;
	CaliforniaCalendarTimeUnit _tmp3_ = 0;
	CaliforniaCalendarWallTime* _tmp4_ = NULL;
	CaliforniaCalendarTimeUnit _tmp5_ = 0;
#line 455 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_WALL_TIME (self), NULL);
#line 456 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp0_ = amount;
#line 456 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (_tmp0_ == 0) {
#line 2247 "calendar-wall-time.c"
		CaliforniaCalendarWallTime* _tmp1_ = NULL;
#line 457 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp1_ = _g_object_ref0 (self);
#line 457 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		result = _tmp1_;
#line 457 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		return result;
#line 2255 "calendar-wall-time.c"
	}
#line 460 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp2_ = amount;
#line 460 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp3_ = time_unit;
#line 460 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp4_ = california_calendar_wall_time_adjust (self, _tmp2_, _tmp3_, NULL);
#line 460 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	adjusted = _tmp4_;
#line 461 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp5_ = time_unit;
#line 461 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	switch (_tmp5_) {
#line 461 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		case CALIFORNIA_CALENDAR_TIME_UNIT_HOUR:
#line 2271 "calendar-wall-time.c"
		{
			CaliforniaCalendarWallTime* _tmp6_ = NULL;
			gint _tmp7_ = 0;
			gint _tmp8_ = 0;
			gint _tmp9_ = 0;
			CaliforniaCalendarWallTime* _tmp10_ = NULL;
#line 463 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp6_ = adjusted;
#line 463 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp7_ = _tmp6_->priv->_hour;
#line 463 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp8_ = self->priv->_minute;
#line 463 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp9_ = self->priv->_second;
#line 463 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp10_ = california_calendar_wall_time_new (_tmp7_, _tmp8_, _tmp9_);
#line 463 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			result = _tmp10_;
#line 463 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_g_object_unref0 (adjusted);
#line 463 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			return result;
#line 2294 "calendar-wall-time.c"
		}
#line 461 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		case CALIFORNIA_CALENDAR_TIME_UNIT_MINUTE:
#line 2298 "calendar-wall-time.c"
		{
			gint _tmp11_ = 0;
			CaliforniaCalendarWallTime* _tmp12_ = NULL;
			gint _tmp13_ = 0;
			gint _tmp14_ = 0;
			CaliforniaCalendarWallTime* _tmp15_ = NULL;
#line 466 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp11_ = self->priv->_hour;
#line 466 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp12_ = adjusted;
#line 466 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp13_ = _tmp12_->priv->_minute;
#line 466 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp14_ = self->priv->_second;
#line 466 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp15_ = california_calendar_wall_time_new (_tmp11_, _tmp13_, _tmp14_);
#line 466 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			result = _tmp15_;
#line 466 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_g_object_unref0 (adjusted);
#line 466 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			return result;
#line 2321 "calendar-wall-time.c"
		}
#line 461 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		case CALIFORNIA_CALENDAR_TIME_UNIT_SECOND:
#line 2325 "calendar-wall-time.c"
		{
			gint _tmp16_ = 0;
			gint _tmp17_ = 0;
			CaliforniaCalendarWallTime* _tmp18_ = NULL;
			gint _tmp19_ = 0;
			CaliforniaCalendarWallTime* _tmp20_ = NULL;
#line 469 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp16_ = self->priv->_hour;
#line 469 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp17_ = self->priv->_minute;
#line 469 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp18_ = adjusted;
#line 469 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp19_ = _tmp18_->priv->_second;
#line 469 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp20_ = california_calendar_wall_time_new (_tmp16_, _tmp17_, _tmp19_);
#line 469 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			result = _tmp20_;
#line 469 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_g_object_unref0 (adjusted);
#line 469 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			return result;
#line 2348 "calendar-wall-time.c"
		}
		default:
		{
#line 472 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			g_assert_not_reached ();
#line 2354 "calendar-wall-time.c"
		}
	}
#line 455 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_g_object_unref0 (adjusted);
#line 2359 "calendar-wall-time.c"
}


/**
     * Returns a prettified, localized user-visible string.
     *
     * The string respects {@link System.is_24hr}.
     */
gchar* california_calendar_wall_time_to_pretty_string (CaliforniaCalendarWallTime* self, CaliforniaCalendarWallTimePrettyFlag flags) {
	gchar* result = NULL;
	gboolean include_sec = FALSE;
	CaliforniaCalendarWallTimePrettyFlag _tmp0_ = 0;
	gboolean optional_min = FALSE;
	CaliforniaCalendarWallTimePrettyFlag _tmp1_ = 0;
	gboolean meridiem_post_only = FALSE;
	CaliforniaCalendarWallTimePrettyFlag _tmp2_ = 0;
	gboolean brief_meridiem = FALSE;
	CaliforniaCalendarWallTimePrettyFlag _tmp3_ = 0;
	gboolean is_24hr = FALSE;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	const gchar* _tmp6_ = NULL;
	gboolean _tmp7_ = FALSE;
	const gchar* pm = NULL;
	const gchar* _tmp10_ = NULL;
	gboolean _tmp11_ = FALSE;
	const gchar* am = NULL;
	const gchar* meridiem = NULL;
	gboolean _tmp14_ = FALSE;
	gboolean _tmp25_ = FALSE;
	gboolean _tmp26_ = FALSE;
	gboolean _tmp27_ = FALSE;
	gboolean _tmp36_ = FALSE;
	gboolean _tmp53_ = FALSE;
	const gchar* _tmp62_ = NULL;
	gint _tmp63_ = 0;
	gint _tmp64_ = 0;
	gint _tmp65_ = 0;
	const gchar* _tmp66_ = NULL;
	gchar* _tmp67_ = NULL;
	gchar* _tmp68_ = NULL;
	gchar* _tmp69_ = NULL;
	gchar* _tmp70_ = NULL;
#line 481 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_WALL_TIME (self), NULL);
#line 482 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp0_ = flags;
#line 482 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	include_sec = (_tmp0_ & CALIFORNIA_CALENDAR_WALL_TIME_PRETTY_FLAG_INCLUDE_SECONDS) != 0;
#line 483 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp1_ = flags;
#line 483 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	optional_min = (_tmp1_ & CALIFORNIA_CALENDAR_WALL_TIME_PRETTY_FLAG_OPTIONAL_MINUTES) != 0;
#line 484 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp2_ = flags;
#line 484 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	meridiem_post_only = (_tmp2_ & CALIFORNIA_CALENDAR_WALL_TIME_PRETTY_FLAG_MERIDIEM_POST_ONLY) != 0;
#line 485 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp3_ = flags;
#line 485 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	brief_meridiem = (_tmp3_ & CALIFORNIA_CALENDAR_WALL_TIME_PRETTY_FLAG_BRIEF_MERIDIEM) != 0;
#line 486 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp4_ = california_calendar_system_get_is_24hr ();
#line 486 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp5_ = _tmp4_;
#line 486 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	is_24hr = _tmp5_;
#line 488 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp7_ = brief_meridiem;
#line 488 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (_tmp7_) {
#line 2431 "calendar-wall-time.c"
		const gchar* _tmp8_ = NULL;
#line 488 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp8_ = california_calendar_FMT_BRIEF_PM;
#line 488 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp6_ = _tmp8_;
#line 2437 "calendar-wall-time.c"
	} else {
		const gchar* _tmp9_ = NULL;
#line 488 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp9_ = california_calendar_FMT_PM;
#line 488 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp6_ = _tmp9_;
#line 2444 "calendar-wall-time.c"
	}
#line 488 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	pm = _tmp6_;
#line 489 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp11_ = brief_meridiem;
#line 489 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (_tmp11_) {
#line 2452 "calendar-wall-time.c"
		const gchar* _tmp12_ = NULL;
#line 489 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp12_ = california_calendar_FMT_BRIEF_AM;
#line 489 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp10_ = _tmp12_;
#line 2458 "calendar-wall-time.c"
	} else {
		const gchar* _tmp13_ = NULL;
#line 489 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp13_ = california_calendar_FMT_AM;
#line 489 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp10_ = _tmp13_;
#line 2465 "calendar-wall-time.c"
	}
#line 489 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	am = _tmp10_;
#line 492 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp14_ = is_24hr;
#line 492 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (_tmp14_) {
#line 493 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		meridiem = "";
#line 2475 "calendar-wall-time.c"
	} else {
		gboolean _tmp15_ = FALSE;
#line 494 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp15_ = meridiem_post_only;
#line 494 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		if (_tmp15_) {
#line 2482 "calendar-wall-time.c"
			const gchar* _tmp16_ = NULL;
			gboolean _tmp17_ = FALSE;
			gboolean _tmp18_ = FALSE;
#line 495 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp17_ = california_calendar_wall_time_get_is_pm (self);
#line 495 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp18_ = _tmp17_;
#line 495 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			if (_tmp18_) {
#line 2492 "calendar-wall-time.c"
				const gchar* _tmp19_ = NULL;
#line 495 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
				_tmp19_ = pm;
#line 495 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
				_tmp16_ = _tmp19_;
#line 2498 "calendar-wall-time.c"
			} else {
#line 495 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
				_tmp16_ = "";
#line 2502 "calendar-wall-time.c"
			}
#line 495 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			meridiem = _tmp16_;
#line 2506 "calendar-wall-time.c"
		} else {
			const gchar* _tmp20_ = NULL;
			gboolean _tmp21_ = FALSE;
			gboolean _tmp22_ = FALSE;
#line 497 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp21_ = california_calendar_wall_time_get_is_pm (self);
#line 497 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp22_ = _tmp21_;
#line 497 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			if (_tmp22_) {
#line 2517 "calendar-wall-time.c"
				const gchar* _tmp23_ = NULL;
#line 497 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
				_tmp23_ = pm;
#line 497 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
				_tmp20_ = _tmp23_;
#line 2523 "calendar-wall-time.c"
			} else {
				const gchar* _tmp24_ = NULL;
#line 497 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
				_tmp24_ = am;
#line 497 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
				_tmp20_ = _tmp24_;
#line 2530 "calendar-wall-time.c"
			}
#line 497 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			meridiem = _tmp20_;
#line 2534 "calendar-wall-time.c"
		}
	}
#line 503 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp27_ = optional_min;
#line 503 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (_tmp27_) {
#line 2541 "calendar-wall-time.c"
		gint _tmp28_ = 0;
#line 503 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp28_ = self->priv->_minute;
#line 503 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp26_ = _tmp28_ == 0;
#line 2547 "calendar-wall-time.c"
	} else {
#line 503 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp26_ = FALSE;
#line 2551 "calendar-wall-time.c"
	}
#line 503 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (_tmp26_) {
#line 2555 "calendar-wall-time.c"
		gboolean _tmp29_ = FALSE;
#line 503 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp29_ = is_24hr;
#line 503 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp25_ = !_tmp29_;
#line 2561 "calendar-wall-time.c"
	} else {
#line 503 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp25_ = FALSE;
#line 2565 "calendar-wall-time.c"
	}
#line 503 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (_tmp25_) {
#line 2569 "calendar-wall-time.c"
		gint _tmp30_ = 0;
		gboolean _tmp31_ = FALSE;
		const gchar* _tmp34_ = NULL;
		gchar* _tmp35_ = NULL;
#line 504 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp31_ = is_24hr;
#line 504 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		if (_tmp31_) {
#line 2578 "calendar-wall-time.c"
			gint _tmp32_ = 0;
#line 504 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp32_ = self->priv->_hour;
#line 504 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp30_ = _tmp32_;
#line 2584 "calendar-wall-time.c"
		} else {
			gint _tmp33_ = 0;
#line 504 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp33_ = self->priv->_12hour;
#line 504 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp30_ = _tmp33_;
#line 2591 "calendar-wall-time.c"
		}
#line 504 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp34_ = meridiem;
#line 504 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp35_ = g_strdup_printf ("%d%s", _tmp30_, _tmp34_);
#line 504 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		result = _tmp35_;
#line 504 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		return result;
#line 2601 "calendar-wall-time.c"
	}
#line 506 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp36_ = include_sec;
#line 506 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (!_tmp36_) {
#line 2607 "calendar-wall-time.c"
		gboolean _tmp37_ = FALSE;
		const gchar* _tmp45_ = NULL;
		gint _tmp46_ = 0;
		gint _tmp47_ = 0;
		const gchar* _tmp48_ = NULL;
		gchar* _tmp49_ = NULL;
		gchar* _tmp50_ = NULL;
		gchar* _tmp51_ = NULL;
		gchar* _tmp52_ = NULL;
#line 508 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp37_ = is_24hr;
#line 508 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		if (_tmp37_) {
#line 2621 "calendar-wall-time.c"
			const gchar* _tmp38_ = NULL;
			gint _tmp39_ = 0;
			gint _tmp40_ = 0;
			gchar* _tmp41_ = NULL;
			gchar* _tmp42_ = NULL;
			gchar* _tmp43_ = NULL;
			gchar* _tmp44_ = NULL;
#line 509 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp38_ = california_calendar_FMT_24HOUR_MIN;
#line 509 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp39_ = self->priv->_hour;
#line 509 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp40_ = self->priv->_minute;
#line 509 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp41_ = g_strdup_printf (_tmp38_, _tmp39_, _tmp40_);
#line 509 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp42_ = _tmp41_;
#line 509 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp43_ = california_string_reduce_whitespace (_tmp42_);
#line 509 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_tmp44_ = _tmp43_;
#line 509 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			_g_free0 (_tmp42_);
#line 509 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			result = _tmp44_;
#line 509 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
			return result;
#line 2649 "calendar-wall-time.c"
		}
#line 511 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp45_ = california_calendar_FMT_12HOUR_MIN_MERIDIEM;
#line 511 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp46_ = self->priv->_12hour;
#line 511 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp47_ = self->priv->_minute;
#line 511 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp48_ = meridiem;
#line 511 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp49_ = g_strdup_printf (_tmp45_, _tmp46_, _tmp47_, _tmp48_);
#line 511 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp50_ = _tmp49_;
#line 511 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp51_ = california_string_reduce_whitespace (_tmp50_);
#line 511 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp52_ = _tmp51_;
#line 511 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_g_free0 (_tmp50_);
#line 511 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		result = _tmp52_;
#line 511 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		return result;
#line 2673 "calendar-wall-time.c"
	}
#line 515 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp53_ = is_24hr;
#line 515 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (_tmp53_) {
#line 2679 "calendar-wall-time.c"
		const gchar* _tmp54_ = NULL;
		gint _tmp55_ = 0;
		gint _tmp56_ = 0;
		gint _tmp57_ = 0;
		gchar* _tmp58_ = NULL;
		gchar* _tmp59_ = NULL;
		gchar* _tmp60_ = NULL;
		gchar* _tmp61_ = NULL;
#line 516 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp54_ = california_calendar_FMT_24HOUR_MIN_SEC;
#line 516 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp55_ = self->priv->_hour;
#line 516 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp56_ = self->priv->_minute;
#line 516 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp57_ = self->priv->_second;
#line 516 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp58_ = g_strdup_printf (_tmp54_, _tmp55_, _tmp56_, _tmp57_);
#line 516 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp59_ = _tmp58_;
#line 516 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp60_ = california_string_reduce_whitespace (_tmp59_);
#line 516 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_tmp61_ = _tmp60_;
#line 516 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		_g_free0 (_tmp59_);
#line 516 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		result = _tmp61_;
#line 516 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		return result;
#line 2710 "calendar-wall-time.c"
	}
#line 518 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp62_ = california_calendar_FMT_12HOUR_MIN_SEC_MERIDIEM;
#line 518 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp63_ = self->priv->_12hour;
#line 518 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp64_ = self->priv->_minute;
#line 518 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp65_ = self->priv->_second;
#line 518 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp66_ = meridiem;
#line 518 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp67_ = g_strdup_printf (_tmp62_, _tmp63_, _tmp64_, _tmp65_, _tmp66_);
#line 518 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp68_ = _tmp67_;
#line 518 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp69_ = california_string_reduce_whitespace (_tmp68_);
#line 518 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp70_ = _tmp69_;
#line 518 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_g_free0 (_tmp68_);
#line 518 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	result = _tmp70_;
#line 518 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	return result;
#line 2736 "calendar-wall-time.c"
}


static gint california_calendar_wall_time_real_compare_to (GeeComparable* base, CaliforniaCalendarWallTime* other) {
	CaliforniaCalendarWallTime * self;
	gint result = 0;
	CaliforniaCalendarWallTime* _tmp0_ = NULL;
	gint diff = 0;
	gint _tmp1_ = 0;
	CaliforniaCalendarWallTime* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	CaliforniaCalendarWallTime* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	CaliforniaCalendarWallTime* _tmp10_ = NULL;
	gint _tmp11_ = 0;
#line 521 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, CALIFORNIA_CALENDAR_TYPE_WALL_TIME, CaliforniaCalendarWallTime);
#line 521 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_WALL_TIME (other), 0);
#line 522 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp0_ = other;
#line 522 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (self == _tmp0_) {
#line 523 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		result = 0;
#line 523 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		return result;
#line 2768 "calendar-wall-time.c"
	}
#line 525 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp1_ = self->priv->_hour;
#line 525 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp2_ = other;
#line 525 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp3_ = _tmp2_->priv->_hour;
#line 525 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	diff = _tmp1_ - _tmp3_;
#line 526 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp4_ = diff;
#line 526 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (_tmp4_ != 0) {
#line 527 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		result = diff;
#line 527 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		return result;
#line 2786 "calendar-wall-time.c"
	}
#line 529 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp5_ = self->priv->_minute;
#line 529 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp6_ = other;
#line 529 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp7_ = _tmp6_->priv->_minute;
#line 529 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	diff = _tmp5_ - _tmp7_;
#line 530 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp8_ = diff;
#line 530 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	if (_tmp8_ != 0) {
#line 531 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		result = diff;
#line 531 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		return result;
#line 2804 "calendar-wall-time.c"
	}
#line 533 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp9_ = self->priv->_second;
#line 533 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp10_ = other;
#line 533 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp11_ = _tmp10_->priv->_second;
#line 533 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	result = _tmp9_ - _tmp11_;
#line 533 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	return result;
#line 2816 "calendar-wall-time.c"
}


static gboolean california_calendar_wall_time_real_equal_to (GeeHashable* base, CaliforniaCalendarWallTime* other) {
	CaliforniaCalendarWallTime * self;
	gboolean result = FALSE;
	CaliforniaCalendarWallTime* _tmp0_ = NULL;
	gint _tmp1_ = 0;
#line 536 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, CALIFORNIA_CALENDAR_TYPE_WALL_TIME, CaliforniaCalendarWallTime);
#line 536 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_WALL_TIME (other), FALSE);
#line 537 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp0_ = other;
#line 537 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp1_ = gee_comparable_compare_to (G_TYPE_CHECK_INSTANCE_CAST (self, GEE_TYPE_COMPARABLE, GeeComparable), _tmp0_);
#line 537 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	result = _tmp1_ == 0;
#line 537 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	return result;
#line 2837 "calendar-wall-time.c"
}


static guint california_calendar_wall_time_real_hash (GeeHashable* base) {
	CaliforniaCalendarWallTime * self;
	guint result = 0U;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
#line 540 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, CALIFORNIA_CALENDAR_TYPE_WALL_TIME, CaliforniaCalendarWallTime);
#line 542 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp0_ = self->priv->_hour;
#line 542 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp1_ = self->priv->_minute;
#line 542 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp2_ = self->priv->_second;
#line 542 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	result = ((((guint) _tmp0_) << 12) | (((guint) _tmp1_) << 6)) | ((guint) _tmp2_);
#line 542 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	return result;
#line 2859 "calendar-wall-time.c"
}


static gchar* california_calendar_wall_time_real_to_string (CaliforniaBaseObject* base) {
	CaliforniaCalendarWallTime * self;
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
#line 545 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, CALIFORNIA_CALENDAR_TYPE_WALL_TIME, CaliforniaCalendarWallTime);
#line 546 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp0_ = california_calendar_wall_time_to_pretty_string (self, CALIFORNIA_CALENDAR_WALL_TIME_PRETTY_FLAG_INCLUDE_SECONDS);
#line 546 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	result = _tmp0_;
#line 546 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	return result;
#line 2875 "calendar-wall-time.c"
}


CaliforniaCalendarWallTime* california_calendar_wall_time_get_earliest (void) {
	CaliforniaCalendarWallTime* result;
	CaliforniaCalendarWallTime* _tmp0_ = NULL;
#line 60 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp0_ = california_calendar_wall_time__earliest;
#line 60 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	result = _tmp0_;
#line 60 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	return result;
#line 2888 "calendar-wall-time.c"
}


static void california_calendar_wall_time_set_earliest (CaliforniaCalendarWallTime* value) {
	CaliforniaCalendarWallTime* _tmp0_ = NULL;
	CaliforniaCalendarWallTime* _tmp1_ = NULL;
#line 60 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp0_ = value;
#line 60 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 60 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_g_object_unref0 (california_calendar_wall_time__earliest);
#line 60 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	california_calendar_wall_time__earliest = _tmp1_;
#line 2903 "calendar-wall-time.c"
}


CaliforniaCalendarWallTime* california_calendar_wall_time_get_latest (void) {
	CaliforniaCalendarWallTime* result;
	CaliforniaCalendarWallTime* _tmp0_ = NULL;
#line 65 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp0_ = california_calendar_wall_time__latest;
#line 65 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	result = _tmp0_;
#line 65 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	return result;
#line 2916 "calendar-wall-time.c"
}


static void california_calendar_wall_time_set_latest (CaliforniaCalendarWallTime* value) {
	CaliforniaCalendarWallTime* _tmp0_ = NULL;
	CaliforniaCalendarWallTime* _tmp1_ = NULL;
#line 65 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp0_ = value;
#line 65 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 65 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_g_object_unref0 (california_calendar_wall_time__latest);
#line 65 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	california_calendar_wall_time__latest = _tmp1_;
#line 2931 "calendar-wall-time.c"
}


gint california_calendar_wall_time_get_hour (CaliforniaCalendarWallTime* self) {
	gint result;
	gint _tmp0_ = 0;
#line 70 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_WALL_TIME (self), 0);
#line 70 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp0_ = self->priv->_hour;
#line 70 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	result = _tmp0_;
#line 70 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	return result;
#line 2946 "calendar-wall-time.c"
}


static void california_calendar_wall_time_set_hour (CaliforniaCalendarWallTime* self, gint value) {
	gint _tmp0_ = 0;
#line 70 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	g_return_if_fail (CALIFORNIA_CALENDAR_IS_WALL_TIME (self));
#line 70 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp0_ = value;
#line 70 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	self->priv->_hour = _tmp0_;
#line 70 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	g_object_notify ((GObject *) self, "hour");
#line 2960 "calendar-wall-time.c"
}


gint california_calendar_wall_time_get_12hour (CaliforniaCalendarWallTime* self) {
	gint result;
	gint _tmp0_ = 0;
#line 75 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_WALL_TIME (self), 0);
#line 75 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp0_ = self->priv->_12hour;
#line 75 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	result = _tmp0_;
#line 75 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	return result;
#line 2975 "calendar-wall-time.c"
}


static void california_calendar_wall_time_set_12hour (CaliforniaCalendarWallTime* self, gint value) {
	gint _tmp0_ = 0;
#line 75 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	g_return_if_fail (CALIFORNIA_CALENDAR_IS_WALL_TIME (self));
#line 75 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp0_ = value;
#line 75 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	self->priv->_12hour = _tmp0_;
#line 2987 "calendar-wall-time.c"
}


gint california_calendar_wall_time_get_minute (CaliforniaCalendarWallTime* self) {
	gint result;
	gint _tmp0_ = 0;
#line 80 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_WALL_TIME (self), 0);
#line 80 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp0_ = self->priv->_minute;
#line 80 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	result = _tmp0_;
#line 80 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	return result;
#line 3002 "calendar-wall-time.c"
}


static void california_calendar_wall_time_set_minute (CaliforniaCalendarWallTime* self, gint value) {
	gint _tmp0_ = 0;
#line 80 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	g_return_if_fail (CALIFORNIA_CALENDAR_IS_WALL_TIME (self));
#line 80 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp0_ = value;
#line 80 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	self->priv->_minute = _tmp0_;
#line 80 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	g_object_notify ((GObject *) self, "minute");
#line 3016 "calendar-wall-time.c"
}


gint california_calendar_wall_time_get_second (CaliforniaCalendarWallTime* self) {
	gint result;
	gint _tmp0_ = 0;
#line 85 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_WALL_TIME (self), 0);
#line 85 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp0_ = self->priv->_second;
#line 85 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	result = _tmp0_;
#line 85 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	return result;
#line 3031 "calendar-wall-time.c"
}


static void california_calendar_wall_time_set_second (CaliforniaCalendarWallTime* self, gint value) {
	gint _tmp0_ = 0;
#line 85 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	g_return_if_fail (CALIFORNIA_CALENDAR_IS_WALL_TIME (self));
#line 85 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp0_ = value;
#line 85 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	self->priv->_second = _tmp0_;
#line 85 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	g_object_notify ((GObject *) self, "second");
#line 3045 "calendar-wall-time.c"
}


gboolean california_calendar_wall_time_get_is_pm (CaliforniaCalendarWallTime* self) {
	gboolean result;
	gint _tmp0_ = 0;
#line 90 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_WALL_TIME (self), FALSE);
#line 90 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	_tmp0_ = self->priv->_hour;
#line 90 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	result = _tmp0_ >= 12;
#line 90 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	return result;
#line 3060 "calendar-wall-time.c"
}


static void california_calendar_wall_time_class_init (CaliforniaCalendarWallTimeClass * klass) {
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	california_calendar_wall_time_parent_class = g_type_class_peek_parent (klass);
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	g_type_class_add_private (klass, sizeof (CaliforniaCalendarWallTimePrivate));
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	((CaliforniaBaseObjectClass *) klass)->to_string = california_calendar_wall_time_real_to_string;
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_california_calendar_wall_time_get_property;
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_california_calendar_wall_time_set_property;
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	G_OBJECT_CLASS (klass)->finalize = california_calendar_wall_time_finalize;
#line 3077 "calendar-wall-time.c"
	/**
	     * Zero-based hour of the day in 24-hour (or "military") time.
	     */
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALIFORNIA_CALENDAR_WALL_TIME_HOUR, g_param_spec_int ("hour", "hour", "hour", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 3083 "calendar-wall-time.c"
	/**
	     * Zero-based minute of the {@link hour}.
	     */
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALIFORNIA_CALENDAR_WALL_TIME_MINUTE, g_param_spec_int ("minute", "minute", "minute", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 3089 "calendar-wall-time.c"
	/**
	     * Zero-based second of the {@link minute}.
	     */
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALIFORNIA_CALENDAR_WALL_TIME_SECOND, g_param_spec_int ("second", "second", "second", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 3095 "calendar-wall-time.c"
	/**
	     * Indicates if post-meridiem.
	     */
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALIFORNIA_CALENDAR_WALL_TIME_IS_PM, g_param_spec_boolean ("is-pm", "is-pm", "is-pm", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 3101 "calendar-wall-time.c"
}


static void california_calendar_wall_time_gee_comparable_interface_init (GeeComparableIface * iface) {
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	california_calendar_wall_time_gee_comparable_parent_iface = g_type_interface_peek_parent (iface);
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	iface->compare_to = (gint (*)(GeeComparable*, gconstpointer)) california_calendar_wall_time_real_compare_to;
#line 3110 "calendar-wall-time.c"
}


static void california_calendar_wall_time_gee_hashable_interface_init (GeeHashableIface * iface) {
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	california_calendar_wall_time_gee_hashable_parent_iface = g_type_interface_peek_parent (iface);
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	iface->equal_to = (gboolean (*)(GeeHashable*, gconstpointer)) california_calendar_wall_time_real_equal_to;
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	iface->hash = (guint (*)(GeeHashable*)) california_calendar_wall_time_real_hash;
#line 3121 "calendar-wall-time.c"
}


static void california_calendar_wall_time_instance_init (CaliforniaCalendarWallTime * self) {
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	self->priv = CALIFORNIA_CALENDAR_WALL_TIME_GET_PRIVATE (self);
#line 3128 "calendar-wall-time.c"
}


static void california_calendar_wall_time_finalize (GObject* obj) {
	CaliforniaCalendarWallTime * self;
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CALIFORNIA_CALENDAR_TYPE_WALL_TIME, CaliforniaCalendarWallTime);
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	G_OBJECT_CLASS (california_calendar_wall_time_parent_class)->finalize (obj);
#line 3138 "calendar-wall-time.c"
}


/**
 * An immutable represenation of "wall clock time", that is, an hour, minute, and seconds with no
 * correspondence to a day of a year.
 */
GType california_calendar_wall_time_get_type (void) {
	static volatile gsize california_calendar_wall_time_type_id__volatile = 0;
	if (g_once_init_enter (&california_calendar_wall_time_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (CaliforniaCalendarWallTimeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) california_calendar_wall_time_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CaliforniaCalendarWallTime), 0, (GInstanceInitFunc) california_calendar_wall_time_instance_init, NULL };
		static const GInterfaceInfo gee_comparable_info = { (GInterfaceInitFunc) california_calendar_wall_time_gee_comparable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo gee_hashable_info = { (GInterfaceInitFunc) california_calendar_wall_time_gee_hashable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType california_calendar_wall_time_type_id;
		california_calendar_wall_time_type_id = g_type_register_static (CALIFORNIA_TYPE_BASE_OBJECT, "CaliforniaCalendarWallTime", &g_define_type_info, 0);
		g_type_add_interface_static (california_calendar_wall_time_type_id, GEE_TYPE_COMPARABLE, &gee_comparable_info);
		g_type_add_interface_static (california_calendar_wall_time_type_id, GEE_TYPE_HASHABLE, &gee_hashable_info);
		g_once_init_leave (&california_calendar_wall_time_type_id__volatile, california_calendar_wall_time_type_id);
	}
	return california_calendar_wall_time_type_id__volatile;
}


static void _vala_california_calendar_wall_time_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	CaliforniaCalendarWallTime * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CALIFORNIA_CALENDAR_TYPE_WALL_TIME, CaliforniaCalendarWallTime);
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	switch (property_id) {
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		case CALIFORNIA_CALENDAR_WALL_TIME_HOUR:
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		g_value_set_int (value, california_calendar_wall_time_get_hour (self));
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		break;
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		case CALIFORNIA_CALENDAR_WALL_TIME_MINUTE:
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		g_value_set_int (value, california_calendar_wall_time_get_minute (self));
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		break;
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		case CALIFORNIA_CALENDAR_WALL_TIME_SECOND:
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		g_value_set_int (value, california_calendar_wall_time_get_second (self));
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		break;
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		case CALIFORNIA_CALENDAR_WALL_TIME_IS_PM:
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		g_value_set_boolean (value, california_calendar_wall_time_get_is_pm (self));
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		break;
#line 3191 "calendar-wall-time.c"
		default:
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		break;
#line 3197 "calendar-wall-time.c"
	}
}


static void _vala_california_calendar_wall_time_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	CaliforniaCalendarWallTime * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CALIFORNIA_CALENDAR_TYPE_WALL_TIME, CaliforniaCalendarWallTime);
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
	switch (property_id) {
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		case CALIFORNIA_CALENDAR_WALL_TIME_HOUR:
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		california_calendar_wall_time_set_hour (self, g_value_get_int (value));
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		break;
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		case CALIFORNIA_CALENDAR_WALL_TIME_MINUTE:
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		california_calendar_wall_time_set_minute (self, g_value_get_int (value));
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		break;
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		case CALIFORNIA_CALENDAR_WALL_TIME_SECOND:
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		california_calendar_wall_time_set_second (self, g_value_get_int (value));
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		break;
#line 3225 "calendar-wall-time.c"
		default:
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 14 "/home/jim/git/california/src/calendar/calendar-wall-time.vala"
		break;
#line 3231 "calendar-wall-time.c"
	}
}



