/* toolkit-deck.c generated by valac 0.24.0, the Vala compiler
 * generated from toolkit-deck.vala, do not modify */

/* Copyright 2014 Yorba Foundation
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>


#define CALIFORNIA_TOOLKIT_TYPE_DECK (california_toolkit_deck_get_type ())
#define CALIFORNIA_TOOLKIT_DECK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_TOOLKIT_TYPE_DECK, CaliforniaToolkitDeck))
#define CALIFORNIA_TOOLKIT_DECK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_TOOLKIT_TYPE_DECK, CaliforniaToolkitDeckClass))
#define CALIFORNIA_TOOLKIT_IS_DECK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_TOOLKIT_TYPE_DECK))
#define CALIFORNIA_TOOLKIT_IS_DECK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_TOOLKIT_TYPE_DECK))
#define CALIFORNIA_TOOLKIT_DECK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_TOOLKIT_TYPE_DECK, CaliforniaToolkitDeckClass))

typedef struct _CaliforniaToolkitDeck CaliforniaToolkitDeck;
typedef struct _CaliforniaToolkitDeckClass CaliforniaToolkitDeckClass;
typedef struct _CaliforniaToolkitDeckPrivate CaliforniaToolkitDeckPrivate;

#define CALIFORNIA_TOOLKIT_TYPE_CARD (california_toolkit_card_get_type ())
#define CALIFORNIA_TOOLKIT_CARD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_TOOLKIT_TYPE_CARD, CaliforniaToolkitCard))
#define CALIFORNIA_TOOLKIT_IS_CARD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_TOOLKIT_TYPE_CARD))
#define CALIFORNIA_TOOLKIT_CARD_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), CALIFORNIA_TOOLKIT_TYPE_CARD, CaliforniaToolkitCardIface))

typedef struct _CaliforniaToolkitCard CaliforniaToolkitCard;
typedef struct _CaliforniaToolkitCardIface CaliforniaToolkitCardIface;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define CALIFORNIA_TYPE_BASE_OBJECT (california_base_object_get_type ())
#define CALIFORNIA_BASE_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_TYPE_BASE_OBJECT, CaliforniaBaseObject))
#define CALIFORNIA_BASE_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_TYPE_BASE_OBJECT, CaliforniaBaseObjectClass))
#define CALIFORNIA_IS_BASE_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_TYPE_BASE_OBJECT))
#define CALIFORNIA_IS_BASE_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_TYPE_BASE_OBJECT))
#define CALIFORNIA_BASE_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_TYPE_BASE_OBJECT, CaliforniaBaseObjectClass))

typedef struct _CaliforniaBaseObject CaliforniaBaseObject;
typedef struct _CaliforniaBaseObjectClass CaliforniaBaseObjectClass;

#define CALIFORNIA_TYPE_ITERABLE (california_iterable_get_type ())
#define CALIFORNIA_ITERABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_TYPE_ITERABLE, CaliforniaIterable))
#define CALIFORNIA_ITERABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_TYPE_ITERABLE, CaliforniaIterableClass))
#define CALIFORNIA_IS_ITERABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_TYPE_ITERABLE))
#define CALIFORNIA_IS_ITERABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_TYPE_ITERABLE))
#define CALIFORNIA_ITERABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_TYPE_ITERABLE, CaliforniaIterableClass))

typedef struct _CaliforniaIterable CaliforniaIterable;
typedef struct _CaliforniaIterableClass CaliforniaIterableClass;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _CaliforniaToolkitDeck {
	GtkStack parent_instance;
	CaliforniaToolkitDeckPrivate * priv;
};

struct _CaliforniaToolkitDeckClass {
	GtkStackClass parent_class;
};

struct _CaliforniaToolkitCardIface {
	GTypeInterface parent_iface;
	void (*jumped_to) (CaliforniaToolkitCard* self, CaliforniaToolkitCard* from, GValue* message);
	const gchar* (*get_card_id) (CaliforniaToolkitCard* self);
	const gchar* (*get_title) (CaliforniaToolkitCard* self);
	GtkWidget* (*get_default_widget) (CaliforniaToolkitCard* self);
	GtkWidget* (*get_initial_focus) (CaliforniaToolkitCard* self);
};

struct _CaliforniaToolkitDeckPrivate {
	CaliforniaToolkitCard* _top;
	GeeList* list;
	GeeDeque* navigation_stack;
	GeeHashMap* names;
};


static gpointer california_toolkit_deck_parent_class = NULL;

GType california_toolkit_deck_get_type (void) G_GNUC_CONST;
GType california_toolkit_card_get_type (void) G_GNUC_CONST;
#define CALIFORNIA_TOOLKIT_DECK_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), CALIFORNIA_TOOLKIT_TYPE_DECK, CaliforniaToolkitDeckPrivate))
enum  {
	CALIFORNIA_TOOLKIT_DECK_DUMMY_PROPERTY,
	CALIFORNIA_TOOLKIT_DECK_DEFAULT_WIDGET,
	CALIFORNIA_TOOLKIT_DECK_SIZE,
	CALIFORNIA_TOOLKIT_DECK_CARDS,
	CALIFORNIA_TOOLKIT_DECK_HOME,
	CALIFORNIA_TOOLKIT_DECK_TOP
};
static void california_toolkit_deck_on_card_mapped (CaliforniaToolkitDeck* self, GtkWidget* widget);
static void _california_toolkit_deck_on_card_mapped_gtk_widget_map (GtkWidget* _sender, gpointer self);
#define CALIFORNIA_TOOLKIT_DECK_DEFAULT_TRANSITION_MSEC 300
CaliforniaToolkitDeck* california_toolkit_deck_new (void);
CaliforniaToolkitDeck* california_toolkit_deck_construct (GType object_type);
static void california_toolkit_deck_on_child_to_top (CaliforniaToolkitDeck* self);
static void _california_toolkit_deck_on_child_to_top_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
CaliforniaToolkitCard* california_toolkit_deck_get_top (CaliforniaToolkitDeck* self);
static void california_toolkit_deck_on_jump_to_card (CaliforniaToolkitDeck* self, CaliforniaToolkitCard* card, CaliforniaToolkitCard* next, GValue* message);
static void _california_toolkit_deck_on_jump_to_card_california_toolkit_card_jump_to_card (CaliforniaToolkitCard* _sender, CaliforniaToolkitCard* next, GValue* message, gpointer self);
static void california_toolkit_deck_on_jump_to_card_by_name (CaliforniaToolkitDeck* self, CaliforniaToolkitCard* card, const gchar* name, GValue* message);
static void _california_toolkit_deck_on_jump_to_card_by_name_california_toolkit_card_jump_to_card_by_name (CaliforniaToolkitCard* _sender, const gchar* name, GValue* message, gpointer self);
static void california_toolkit_deck_on_jump_back (CaliforniaToolkitDeck* self, CaliforniaToolkitCard* card);
static void _california_toolkit_deck_on_jump_back_california_toolkit_card_jump_back (CaliforniaToolkitCard* _sender, gpointer self);
static void california_toolkit_deck_on_jump_home (CaliforniaToolkitDeck* self, CaliforniaToolkitCard* card);
static void _california_toolkit_deck_on_jump_home_california_toolkit_card_jump_home (CaliforniaToolkitCard* _sender, gpointer self);
static void california_toolkit_deck_on_dismiss (CaliforniaToolkitDeck* self, gboolean user_request, gboolean final);
static void _california_toolkit_deck_on_dismiss_california_toolkit_card_dismiss (CaliforniaToolkitCard* _sender, gboolean user_request, gboolean final, gpointer self);
static void california_toolkit_deck_on_success (CaliforniaToolkitDeck* self);
static void _california_toolkit_deck_on_success_california_toolkit_card_success (CaliforniaToolkitCard* _sender, gpointer self);
static void california_toolkit_deck_on_failure (CaliforniaToolkitDeck* self, const gchar* user_message);
static void _california_toolkit_deck_on_failure_california_toolkit_card_failure (CaliforniaToolkitCard* _sender, const gchar* user_message, gpointer self);
static void california_toolkit_deck_set_top (CaliforniaToolkitDeck* self, CaliforniaToolkitCard* value);
void california_toolkit_deck_add_card (CaliforniaToolkitDeck* self, CaliforniaToolkitCard* card);
void california_toolkit_deck_add_cards (CaliforniaToolkitDeck* self, GeeList* cards);
GType california_base_object_get_type (void) G_GNUC_CONST;
GType california_iterable_get_type (void) G_GNUC_CONST;
CaliforniaIterable* california_iterate (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, gconstpointer g, ...);
GeeArrayList* california_iterable_to_array_list (CaliforniaIterable* self, GeeEqualDataFunc equal_func, void* equal_func_target, GDestroyNotify equal_func_target_destroy_notify);
gint california_toolkit_deck_get_size (CaliforniaToolkitDeck* self);
gboolean california_string_is_empty (const gchar* str);
const gchar* california_toolkit_card_get_card_id (CaliforniaToolkitCard* self);
const gchar* california_toolkit_card_get_title (CaliforniaToolkitCard* self);
CaliforniaToolkitCard* california_toolkit_deck_get_home (CaliforniaToolkitDeck* self);
void california_toolkit_card_jumped_to (CaliforniaToolkitCard* self, CaliforniaToolkitCard* from, GValue* message);
void california_toolkit_deck_remove_cards (CaliforniaToolkitDeck* self, GeeIterable* cards);
void california_toolkit_deck_go_home (CaliforniaToolkitDeck* self, GValue* message);
GtkWidget* california_toolkit_card_get_default_widget (CaliforniaToolkitCard* self);
GtkWidget* california_toolkit_card_get_initial_focus (CaliforniaToolkitCard* self);
GtkWidget* california_toolkit_deck_get_default_widget (CaliforniaToolkitDeck* self);
GeeList* california_toolkit_deck_get_cards (CaliforniaToolkitDeck* self);
static void g_cclosure_user_marshal_VOID__BOOLEAN_BOOLEAN (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void california_toolkit_deck_finalize (GObject* obj);
static void _vala_california_toolkit_deck_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_california_toolkit_deck_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


static void _california_toolkit_deck_on_card_mapped_gtk_widget_map (GtkWidget* _sender, gpointer self) {
#line 82 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	california_toolkit_deck_on_card_mapped ((CaliforniaToolkitDeck*) self, _sender);
#line 149 "toolkit-deck.c"
}


/**
     * Create a new {@link Deck}.
     *
     * By default the Deck configures the underlying Gtk.Stack to slide left and right, depending
     * on the position of the {@link Card}s.  This can be changed, but the recommended
     * transition types are SLIDE_LEFT_RIGHT and SLIDE_UP_DOWN.
     */
static void _california_toolkit_deck_on_child_to_top_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 77 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	california_toolkit_deck_on_child_to_top ((CaliforniaToolkitDeck*) self);
#line 163 "toolkit-deck.c"
}


CaliforniaToolkitDeck* california_toolkit_deck_construct (GType object_type) {
	CaliforniaToolkitDeck * self = NULL;
#line 73 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	self = (CaliforniaToolkitDeck*) g_object_new (object_type, NULL);
#line 74 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	gtk_stack_set_transition_type (G_TYPE_CHECK_INSTANCE_CAST (self, GTK_TYPE_STACK, GtkStack), GTK_STACK_TRANSITION_TYPE_SLIDE_LEFT_RIGHT);
#line 75 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	gtk_stack_set_transition_duration (G_TYPE_CHECK_INSTANCE_CAST (self, GTK_TYPE_STACK, GtkStack), (guint) CALIFORNIA_TOOLKIT_DECK_DEFAULT_TRANSITION_MSEC);
#line 77 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (self, G_TYPE_OBJECT, GObject), "notify::visible-child", (GCallback) _california_toolkit_deck_on_child_to_top_g_object_notify, self, 0);
#line 73 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	return self;
#line 179 "toolkit-deck.c"
}


CaliforniaToolkitDeck* california_toolkit_deck_new (void) {
#line 73 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	return california_toolkit_deck_construct (CALIFORNIA_TOOLKIT_TYPE_DECK);
#line 186 "toolkit-deck.c"
}


static void _california_toolkit_deck_on_jump_to_card_california_toolkit_card_jump_to_card (CaliforniaToolkitCard* _sender, CaliforniaToolkitCard* next, GValue* message, gpointer self) {
#line 88 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	california_toolkit_deck_on_jump_to_card ((CaliforniaToolkitDeck*) self, _sender, next, message);
#line 193 "toolkit-deck.c"
}


static void _california_toolkit_deck_on_jump_to_card_by_name_california_toolkit_card_jump_to_card_by_name (CaliforniaToolkitCard* _sender, const gchar* name, GValue* message, gpointer self) {
#line 89 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	california_toolkit_deck_on_jump_to_card_by_name ((CaliforniaToolkitDeck*) self, _sender, name, message);
#line 200 "toolkit-deck.c"
}


static void _california_toolkit_deck_on_jump_back_california_toolkit_card_jump_back (CaliforniaToolkitCard* _sender, gpointer self) {
#line 90 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	california_toolkit_deck_on_jump_back ((CaliforniaToolkitDeck*) self, _sender);
#line 207 "toolkit-deck.c"
}


static void _california_toolkit_deck_on_jump_home_california_toolkit_card_jump_home (CaliforniaToolkitCard* _sender, gpointer self) {
#line 91 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	california_toolkit_deck_on_jump_home ((CaliforniaToolkitDeck*) self, _sender);
#line 214 "toolkit-deck.c"
}


static void _california_toolkit_deck_on_dismiss_california_toolkit_card_dismiss (CaliforniaToolkitCard* _sender, gboolean user_request, gboolean final, gpointer self) {
#line 92 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	california_toolkit_deck_on_dismiss ((CaliforniaToolkitDeck*) self, user_request, final);
#line 221 "toolkit-deck.c"
}


static void _california_toolkit_deck_on_success_california_toolkit_card_success (CaliforniaToolkitCard* _sender, gpointer self) {
#line 93 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	california_toolkit_deck_on_success ((CaliforniaToolkitDeck*) self);
#line 228 "toolkit-deck.c"
}


static void _california_toolkit_deck_on_failure_california_toolkit_card_failure (CaliforniaToolkitCard* _sender, const gchar* user_message, gpointer self) {
#line 94 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	california_toolkit_deck_on_failure ((CaliforniaToolkitDeck*) self, user_message);
#line 235 "toolkit-deck.c"
}


static void california_toolkit_deck_on_child_to_top (CaliforniaToolkitDeck* self) {
	CaliforniaToolkitCard* _tmp0_ = NULL;
	GtkWidget* _tmp17_ = NULL;
	GtkWidget* _tmp18_ = NULL;
	CaliforniaToolkitCard* _tmp19_ = NULL;
#line 85 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	g_return_if_fail (CALIFORNIA_TOOLKIT_IS_DECK (self));
#line 87 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp0_ = self->priv->_top;
#line 87 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	if (_tmp0_ != NULL) {
#line 250 "toolkit-deck.c"
		CaliforniaToolkitCard* _tmp1_ = NULL;
		guint _tmp2_ = 0U;
		CaliforniaToolkitCard* _tmp3_ = NULL;
		guint _tmp4_ = 0U;
		CaliforniaToolkitCard* _tmp5_ = NULL;
		guint _tmp6_ = 0U;
		CaliforniaToolkitCard* _tmp7_ = NULL;
		guint _tmp8_ = 0U;
		CaliforniaToolkitCard* _tmp9_ = NULL;
		guint _tmp10_ = 0U;
		CaliforniaToolkitCard* _tmp11_ = NULL;
		guint _tmp12_ = 0U;
		CaliforniaToolkitCard* _tmp13_ = NULL;
		guint _tmp14_ = 0U;
		GeeDeque* _tmp15_ = NULL;
		CaliforniaToolkitCard* _tmp16_ = NULL;
#line 88 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp1_ = self->priv->_top;
#line 88 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		g_signal_parse_name ("jump-to-card", CALIFORNIA_TOOLKIT_TYPE_CARD, &_tmp2_, NULL, FALSE);
#line 88 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		g_signal_handlers_disconnect_matched (_tmp1_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, 0, NULL, (GCallback) _california_toolkit_deck_on_jump_to_card_california_toolkit_card_jump_to_card, self);
#line 89 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp3_ = self->priv->_top;
#line 89 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		g_signal_parse_name ("jump-to-card-by-name", CALIFORNIA_TOOLKIT_TYPE_CARD, &_tmp4_, NULL, FALSE);
#line 89 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		g_signal_handlers_disconnect_matched (_tmp3_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp4_, 0, NULL, (GCallback) _california_toolkit_deck_on_jump_to_card_by_name_california_toolkit_card_jump_to_card_by_name, self);
#line 90 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp5_ = self->priv->_top;
#line 90 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		g_signal_parse_name ("jump-back", CALIFORNIA_TOOLKIT_TYPE_CARD, &_tmp6_, NULL, FALSE);
#line 90 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		g_signal_handlers_disconnect_matched (_tmp5_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp6_, 0, NULL, (GCallback) _california_toolkit_deck_on_jump_back_california_toolkit_card_jump_back, self);
#line 91 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp7_ = self->priv->_top;
#line 91 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		g_signal_parse_name ("jump-home", CALIFORNIA_TOOLKIT_TYPE_CARD, &_tmp8_, NULL, FALSE);
#line 91 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		g_signal_handlers_disconnect_matched (_tmp7_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp8_, 0, NULL, (GCallback) _california_toolkit_deck_on_jump_home_california_toolkit_card_jump_home, self);
#line 92 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp9_ = self->priv->_top;
#line 92 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		g_signal_parse_name ("dismiss", CALIFORNIA_TOOLKIT_TYPE_CARD, &_tmp10_, NULL, FALSE);
#line 92 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		g_signal_handlers_disconnect_matched (_tmp9_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp10_, 0, NULL, (GCallback) _california_toolkit_deck_on_dismiss_california_toolkit_card_dismiss, self);
#line 93 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp11_ = self->priv->_top;
#line 93 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		g_signal_parse_name ("success", CALIFORNIA_TOOLKIT_TYPE_CARD, &_tmp12_, NULL, FALSE);
#line 93 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		g_signal_handlers_disconnect_matched (_tmp11_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp12_, 0, NULL, (GCallback) _california_toolkit_deck_on_success_california_toolkit_card_success, self);
#line 94 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp13_ = self->priv->_top;
#line 94 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		g_signal_parse_name ("failure", CALIFORNIA_TOOLKIT_TYPE_CARD, &_tmp14_, NULL, FALSE);
#line 94 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		g_signal_handlers_disconnect_matched (_tmp13_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp14_, 0, NULL, (GCallback) _california_toolkit_deck_on_failure_california_toolkit_card_failure, self);
#line 96 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp15_ = self->priv->navigation_stack;
#line 96 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp16_ = self->priv->_top;
#line 96 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		gee_deque_offer_head (_tmp15_, _tmp16_);
#line 97 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		california_toolkit_deck_set_top (self, NULL);
#line 317 "toolkit-deck.c"
	}
#line 101 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp17_ = gtk_stack_get_visible_child (G_TYPE_CHECK_INSTANCE_CAST (self, GTK_TYPE_STACK, GtkStack));
#line 101 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp18_ = _tmp17_;
#line 101 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	california_toolkit_deck_set_top (self, G_TYPE_CHECK_INSTANCE_TYPE (_tmp18_, CALIFORNIA_TOOLKIT_TYPE_CARD) ? ((CaliforniaToolkitCard*) _tmp18_) : NULL);
#line 102 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp19_ = self->priv->_top;
#line 102 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	if (_tmp19_ != NULL) {
#line 329 "toolkit-deck.c"
		CaliforniaToolkitCard* _tmp20_ = NULL;
		CaliforniaToolkitCard* _tmp21_ = NULL;
		CaliforniaToolkitCard* _tmp22_ = NULL;
		CaliforniaToolkitCard* _tmp23_ = NULL;
		CaliforniaToolkitCard* _tmp24_ = NULL;
		CaliforniaToolkitCard* _tmp25_ = NULL;
		CaliforniaToolkitCard* _tmp26_ = NULL;
#line 103 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp20_ = self->priv->_top;
#line 103 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		g_signal_connect_object (_tmp20_, "jump-to-card", (GCallback) _california_toolkit_deck_on_jump_to_card_california_toolkit_card_jump_to_card, self, 0);
#line 104 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp21_ = self->priv->_top;
#line 104 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		g_signal_connect_object (_tmp21_, "jump-to-card-by-name", (GCallback) _california_toolkit_deck_on_jump_to_card_by_name_california_toolkit_card_jump_to_card_by_name, self, 0);
#line 105 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp22_ = self->priv->_top;
#line 105 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		g_signal_connect_object (_tmp22_, "jump-back", (GCallback) _california_toolkit_deck_on_jump_back_california_toolkit_card_jump_back, self, 0);
#line 106 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp23_ = self->priv->_top;
#line 106 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		g_signal_connect_object (_tmp23_, "jump-home", (GCallback) _california_toolkit_deck_on_jump_home_california_toolkit_card_jump_home, self, 0);
#line 107 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp24_ = self->priv->_top;
#line 107 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		g_signal_connect_object (_tmp24_, "dismiss", (GCallback) _california_toolkit_deck_on_dismiss_california_toolkit_card_dismiss, self, 0);
#line 108 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp25_ = self->priv->_top;
#line 108 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		g_signal_connect_object (_tmp25_, "success", (GCallback) _california_toolkit_deck_on_success_california_toolkit_card_success, self, 0);
#line 109 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp26_ = self->priv->_top;
#line 109 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		g_signal_connect_object (_tmp26_, "failure", (GCallback) _california_toolkit_deck_on_failure_california_toolkit_card_failure, self, 0);
#line 365 "toolkit-deck.c"
	}
}


/**
     * A helper method for {@link add_cards}.
     */
void california_toolkit_deck_add_card (CaliforniaToolkitDeck* self, CaliforniaToolkitCard* card) {
	CaliforniaToolkitCard* _tmp0_ = NULL;
	CaliforniaIterable* _tmp1_ = NULL;
	CaliforniaIterable* _tmp2_ = NULL;
	GeeArrayList* _tmp3_ = NULL;
	GeeArrayList* _tmp4_ = NULL;
#line 116 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	g_return_if_fail (CALIFORNIA_TOOLKIT_IS_DECK (self));
#line 116 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	g_return_if_fail (CALIFORNIA_TOOLKIT_IS_CARD (card));
#line 117 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp0_ = card;
#line 117 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp1_ = california_iterate (CALIFORNIA_TOOLKIT_TYPE_CARD, (GBoxedCopyFunc) g_object_ref, g_object_unref, _tmp0_, NULL);
#line 117 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp2_ = _tmp1_;
#line 117 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp3_ = california_iterable_to_array_list (_tmp2_, NULL, NULL, NULL);
#line 117 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp4_ = _tmp3_;
#line 117 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	california_toolkit_deck_add_cards (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEE_TYPE_LIST, GeeList));
#line 117 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_g_object_unref0 (_tmp4_);
#line 117 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_g_object_unref0 (_tmp2_);
#line 399 "toolkit-deck.c"
}


/**
     * Add {@link Card}s to the {@link Deck}.
     *
     * Cards can be added in multiple batches, but the ordering is important as it dictates how
     * they're presented to the user via transitions and slides.
     *
     * The first Card added is the "home" Card.  The Deck will automatically show it first.
     */
static gpointer _g_object_ref0 (gpointer self) {
#line 136 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	return self ? g_object_ref (self) : NULL;
#line 414 "toolkit-deck.c"
}


void california_toolkit_deck_add_cards (CaliforniaToolkitDeck* self, GeeList* cards) {
	GeeList* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gboolean set_home_visible = FALSE;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gboolean _tmp48_ = FALSE;
	gboolean _tmp49_ = FALSE;
#line 128 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	g_return_if_fail (CALIFORNIA_TOOLKIT_IS_DECK (self));
#line 128 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	g_return_if_fail (GEE_IS_LIST (cards));
#line 129 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp0_ = cards;
#line 129 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp1_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection));
#line 129 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp2_ = _tmp1_;
#line 129 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	if (_tmp2_ == 0) {
#line 130 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		return;
#line 441 "toolkit-deck.c"
	}
#line 133 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp3_ = california_toolkit_deck_get_size (self);
#line 133 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp4_ = _tmp3_;
#line 133 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	set_home_visible = _tmp4_ == 0;
#line 449 "toolkit-deck.c"
	{
		GeeList* _card_list = NULL;
		GeeList* _tmp5_ = NULL;
		GeeList* _tmp6_ = NULL;
		gint _card_size = 0;
		GeeList* _tmp7_ = NULL;
		gint _tmp8_ = 0;
		gint _tmp9_ = 0;
		gint _card_index = 0;
#line 136 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp5_ = cards;
#line 136 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp6_ = _g_object_ref0 (_tmp5_);
#line 136 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_card_list = _tmp6_;
#line 136 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp7_ = _card_list;
#line 136 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp8_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, GEE_TYPE_COLLECTION, GeeCollection));
#line 136 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp9_ = _tmp8_;
#line 136 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_card_size = _tmp9_;
#line 136 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_card_index = -1;
#line 136 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		while (TRUE) {
#line 477 "toolkit-deck.c"
			gint _tmp10_ = 0;
			gint _tmp11_ = 0;
			gint _tmp12_ = 0;
			CaliforniaToolkitCard* card = NULL;
			GeeList* _tmp13_ = NULL;
			gint _tmp14_ = 0;
			gpointer _tmp15_ = NULL;
			CaliforniaToolkitCard* _tmp16_ = NULL;
			const gchar* _tmp17_ = NULL;
			const gchar* _tmp18_ = NULL;
			gboolean _tmp19_ = FALSE;
			GeeHashMap* _tmp20_ = NULL;
			CaliforniaToolkitCard* _tmp21_ = NULL;
			const gchar* _tmp22_ = NULL;
			const gchar* _tmp23_ = NULL;
			gboolean _tmp24_ = FALSE;
			CaliforniaToolkitCard* _tmp25_ = NULL;
			const gchar* _tmp26_ = NULL;
			const gchar* _tmp27_ = NULL;
			gboolean _tmp28_ = FALSE;
			GeeHashMap* _tmp40_ = NULL;
			CaliforniaToolkitCard* _tmp41_ = NULL;
			const gchar* _tmp42_ = NULL;
			const gchar* _tmp43_ = NULL;
			CaliforniaToolkitCard* _tmp44_ = NULL;
			CaliforniaToolkitCard* _tmp45_ = NULL;
			GeeList* _tmp46_ = NULL;
			CaliforniaToolkitCard* _tmp47_ = NULL;
#line 136 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp10_ = _card_index;
#line 136 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_card_index = _tmp10_ + 1;
#line 136 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp11_ = _card_index;
#line 136 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp12_ = _card_size;
#line 136 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			if (!(_tmp11_ < _tmp12_)) {
#line 136 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
				break;
#line 518 "toolkit-deck.c"
			}
#line 136 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp13_ = _card_list;
#line 136 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp14_ = _card_index;
#line 136 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp15_ = gee_list_get (_tmp13_, _tmp14_);
#line 136 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			card = (CaliforniaToolkitCard*) _tmp15_;
#line 138 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp16_ = card;
#line 138 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp17_ = california_toolkit_card_get_card_id (_tmp16_);
#line 138 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp18_ = _tmp17_;
#line 138 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp19_ = california_string_is_empty (_tmp18_);
#line 138 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_vala_assert (!_tmp19_, "!String.is_empty(card.card_id)");
#line 139 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp20_ = self->priv->names;
#line 139 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp21_ = card;
#line 139 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp22_ = california_toolkit_card_get_card_id (_tmp21_);
#line 139 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp23_ = _tmp22_;
#line 139 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp24_ = gee_abstract_map_has_key (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp23_);
#line 139 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_vala_assert (!_tmp24_, "!names.has_key(card.card_id)");
#line 141 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp25_ = card;
#line 141 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp26_ = california_toolkit_card_get_title (_tmp25_);
#line 141 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp27_ = _tmp26_;
#line 141 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp28_ = california_string_is_empty (_tmp27_);
#line 141 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			if (_tmp28_) {
#line 560 "toolkit-deck.c"
				CaliforniaToolkitCard* _tmp29_ = NULL;
				CaliforniaToolkitCard* _tmp30_ = NULL;
				const gchar* _tmp31_ = NULL;
				const gchar* _tmp32_ = NULL;
#line 142 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
				_tmp29_ = card;
#line 142 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
				_tmp30_ = card;
#line 142 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
				_tmp31_ = california_toolkit_card_get_card_id (_tmp30_);
#line 142 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
				_tmp32_ = _tmp31_;
#line 142 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
				gtk_stack_add_named (G_TYPE_CHECK_INSTANCE_CAST (self, GTK_TYPE_STACK, GtkStack), G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, GTK_TYPE_WIDGET, GtkWidget), _tmp32_);
#line 575 "toolkit-deck.c"
			} else {
				CaliforniaToolkitCard* _tmp33_ = NULL;
				CaliforniaToolkitCard* _tmp34_ = NULL;
				const gchar* _tmp35_ = NULL;
				const gchar* _tmp36_ = NULL;
				CaliforniaToolkitCard* _tmp37_ = NULL;
				const gchar* _tmp38_ = NULL;
				const gchar* _tmp39_ = NULL;
#line 144 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
				_tmp33_ = card;
#line 144 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
				_tmp34_ = card;
#line 144 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
				_tmp35_ = california_toolkit_card_get_card_id (_tmp34_);
#line 144 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
				_tmp36_ = _tmp35_;
#line 144 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
				_tmp37_ = card;
#line 144 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
				_tmp38_ = california_toolkit_card_get_title (_tmp37_);
#line 144 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
				_tmp39_ = _tmp38_;
#line 144 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
				gtk_stack_add_titled (G_TYPE_CHECK_INSTANCE_CAST (self, GTK_TYPE_STACK, GtkStack), G_TYPE_CHECK_INSTANCE_CAST (_tmp33_, GTK_TYPE_WIDGET, GtkWidget), _tmp36_, _tmp39_);
#line 600 "toolkit-deck.c"
			}
#line 146 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp40_ = self->priv->names;
#line 146 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp41_ = card;
#line 146 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp42_ = california_toolkit_card_get_card_id (_tmp41_);
#line 146 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp43_ = _tmp42_;
#line 146 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp44_ = card;
#line 146 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp40_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp43_, _tmp44_);
#line 151 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp45_ = card;
#line 151 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp45_, GTK_TYPE_WIDGET, GtkWidget), "map", (GCallback) _california_toolkit_deck_on_card_mapped_gtk_widget_map, self, 0);
#line 154 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp46_ = self->priv->list;
#line 154 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp47_ = card;
#line 154 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp46_, GEE_TYPE_COLLECTION, GeeCollection), _tmp47_);
#line 136 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_g_object_unref0 (card);
#line 626 "toolkit-deck.c"
		}
#line 136 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_g_object_unref0 (_card_list);
#line 630 "toolkit-deck.c"
	}
#line 157 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp49_ = set_home_visible;
#line 157 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	if (_tmp49_) {
#line 636 "toolkit-deck.c"
		CaliforniaToolkitCard* _tmp50_ = NULL;
		CaliforniaToolkitCard* _tmp51_ = NULL;
		CaliforniaToolkitCard* _tmp52_ = NULL;
#line 157 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp50_ = california_toolkit_deck_get_home (self);
#line 157 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp51_ = _tmp50_;
#line 157 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp52_ = _tmp51_;
#line 157 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp48_ = _tmp52_ != NULL;
#line 157 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_g_object_unref0 (_tmp52_);
#line 650 "toolkit-deck.c"
	} else {
#line 157 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp48_ = FALSE;
#line 654 "toolkit-deck.c"
	}
#line 157 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	if (_tmp48_) {
#line 658 "toolkit-deck.c"
		CaliforniaToolkitCard* _tmp53_ = NULL;
		CaliforniaToolkitCard* _tmp54_ = NULL;
		CaliforniaToolkitCard* _tmp55_ = NULL;
		CaliforniaToolkitCard* _tmp56_ = NULL;
		CaliforniaToolkitCard* _tmp57_ = NULL;
		CaliforniaToolkitCard* _tmp58_ = NULL;
#line 158 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp53_ = california_toolkit_deck_get_home (self);
#line 158 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp54_ = _tmp53_;
#line 158 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp55_ = _tmp54_;
#line 158 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		gtk_stack_set_visible_child (G_TYPE_CHECK_INSTANCE_CAST (self, GTK_TYPE_STACK, GtkStack), G_TYPE_CHECK_INSTANCE_CAST (_tmp55_, GTK_TYPE_WIDGET, GtkWidget));
#line 158 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_g_object_unref0 (_tmp55_);
#line 159 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp56_ = california_toolkit_deck_get_home (self);
#line 159 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp57_ = _tmp56_;
#line 159 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp58_ = _tmp57_;
#line 159 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		california_toolkit_card_jumped_to (_tmp58_, NULL, NULL);
#line 159 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_g_object_unref0 (_tmp58_);
#line 685 "toolkit-deck.c"
	}
}


/**
     * Removes {@link Card}s from the {@link Deck}.
     *
     * If the {@link top} card is removed, the Deck will return {@link home}, clearing the
     * navigation stack in the process.
     */
void california_toolkit_deck_remove_cards (CaliforniaToolkitDeck* self, GeeIterable* cards) {
	gboolean displaying = FALSE;
	CaliforniaToolkitCard* _tmp0_ = NULL;
	gboolean _tmp28_ = FALSE;
	gboolean _tmp29_ = FALSE;
	gboolean _tmp30_ = FALSE;
#line 169 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	g_return_if_fail (CALIFORNIA_TOOLKIT_IS_DECK (self));
#line 169 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	g_return_if_fail (GEE_IS_ITERABLE (cards));
#line 170 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp0_ = self->priv->_top;
#line 170 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	displaying = _tmp0_ != NULL;
#line 710 "toolkit-deck.c"
	{
		GeeIterator* _card_it = NULL;
		GeeIterable* _tmp1_ = NULL;
		GeeIterator* _tmp2_ = NULL;
#line 172 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp1_ = cards;
#line 172 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp2_ = gee_iterable_iterator (_tmp1_);
#line 172 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_card_it = _tmp2_;
#line 172 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		while (TRUE) {
#line 723 "toolkit-deck.c"
			GeeIterator* _tmp3_ = NULL;
			gboolean _tmp4_ = FALSE;
			CaliforniaToolkitCard* card = NULL;
			GeeIterator* _tmp5_ = NULL;
			gpointer _tmp6_ = NULL;
			GeeHashMap* _tmp7_ = NULL;
			CaliforniaToolkitCard* _tmp8_ = NULL;
			const gchar* _tmp9_ = NULL;
			const gchar* _tmp10_ = NULL;
			gboolean _tmp11_ = FALSE;
			CaliforniaToolkitCard* _tmp15_ = NULL;
			guint _tmp16_ = 0U;
			CaliforniaToolkitCard* _tmp17_ = NULL;
			CaliforniaToolkitCard* _tmp18_ = NULL;
			CaliforniaToolkitCard* _tmp19_ = NULL;
			GeeDeque* _tmp20_ = NULL;
			CaliforniaToolkitCard* _tmp21_ = NULL;
			GeeHashMap* _tmp22_ = NULL;
			CaliforniaToolkitCard* _tmp23_ = NULL;
			const gchar* _tmp24_ = NULL;
			const gchar* _tmp25_ = NULL;
			GeeList* _tmp26_ = NULL;
			CaliforniaToolkitCard* _tmp27_ = NULL;
#line 172 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp3_ = _card_it;
#line 172 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp4_ = gee_iterator_next (_tmp3_);
#line 172 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			if (!_tmp4_) {
#line 172 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
				break;
#line 755 "toolkit-deck.c"
			}
#line 172 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp5_ = _card_it;
#line 172 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp6_ = gee_iterator_get (_tmp5_);
#line 172 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			card = (CaliforniaToolkitCard*) _tmp6_;
#line 173 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp7_ = self->priv->names;
#line 173 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp8_ = card;
#line 173 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp9_ = california_toolkit_card_get_card_id (_tmp8_);
#line 173 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp10_ = _tmp9_;
#line 173 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp11_ = gee_abstract_map_has_key (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp10_);
#line 173 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			if (!_tmp11_) {
#line 775 "toolkit-deck.c"
				CaliforniaToolkitCard* _tmp12_ = NULL;
				const gchar* _tmp13_ = NULL;
				const gchar* _tmp14_ = NULL;
#line 174 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
				_tmp12_ = card;
#line 174 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
				_tmp13_ = california_toolkit_card_get_card_id (_tmp12_);
#line 174 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
				_tmp14_ = _tmp13_;
#line 174 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
				g_message ("toolkit-deck.vala:174: Card %s not found in Deck", _tmp14_);
#line 176 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
				_g_object_unref0 (card);
#line 176 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
				continue;
#line 791 "toolkit-deck.c"
			}
#line 179 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp15_ = card;
#line 179 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			g_signal_parse_name ("map", GTK_TYPE_WIDGET, &_tmp16_, NULL, FALSE);
#line 179 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			g_signal_handlers_disconnect_matched (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, GTK_TYPE_WIDGET, GtkWidget), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp16_, 0, NULL, (GCallback) _california_toolkit_deck_on_card_mapped_gtk_widget_map, self);
#line 181 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp17_ = card;
#line 181 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			gtk_container_remove (G_TYPE_CHECK_INSTANCE_CAST (self, GTK_TYPE_CONTAINER, GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, GTK_TYPE_WIDGET, GtkWidget));
#line 183 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp18_ = self->priv->_top;
#line 183 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp19_ = card;
#line 183 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			if (_tmp18_ == _tmp19_) {
#line 184 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
				california_toolkit_deck_set_top (self, NULL);
#line 811 "toolkit-deck.c"
			}
#line 186 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp20_ = self->priv->navigation_stack;
#line 186 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp21_ = card;
#line 186 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			gee_collection_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, GEE_TYPE_COLLECTION, GeeCollection), _tmp21_);
#line 187 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp22_ = self->priv->names;
#line 187 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp23_ = card;
#line 187 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp24_ = california_toolkit_card_get_card_id (_tmp23_);
#line 187 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp25_ = _tmp24_;
#line 187 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			gee_abstract_map_unset (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp25_, NULL);
#line 188 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp26_ = self->priv->list;
#line 188 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp27_ = card;
#line 188 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			gee_collection_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp26_, GEE_TYPE_COLLECTION, GeeCollection), _tmp27_);
#line 172 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_g_object_unref0 (card);
#line 837 "toolkit-deck.c"
		}
#line 172 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_g_object_unref0 (_card_it);
#line 841 "toolkit-deck.c"
	}
#line 192 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp30_ = displaying;
#line 192 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	if (_tmp30_) {
#line 847 "toolkit-deck.c"
		CaliforniaToolkitCard* _tmp31_ = NULL;
#line 192 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp31_ = self->priv->_top;
#line 192 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp29_ = _tmp31_ == NULL;
#line 853 "toolkit-deck.c"
	} else {
#line 192 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp29_ = FALSE;
#line 857 "toolkit-deck.c"
	}
#line 192 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	if (_tmp29_) {
#line 861 "toolkit-deck.c"
		CaliforniaToolkitCard* _tmp32_ = NULL;
		CaliforniaToolkitCard* _tmp33_ = NULL;
		CaliforniaToolkitCard* _tmp34_ = NULL;
#line 192 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp32_ = california_toolkit_deck_get_home (self);
#line 192 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp33_ = _tmp32_;
#line 192 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp34_ = _tmp33_;
#line 192 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp28_ = _tmp34_ != NULL;
#line 192 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_g_object_unref0 (_tmp34_);
#line 875 "toolkit-deck.c"
	} else {
#line 192 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp28_ = FALSE;
#line 879 "toolkit-deck.c"
	}
#line 192 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	if (_tmp28_) {
#line 883 "toolkit-deck.c"
		GeeDeque* _tmp35_ = NULL;
		CaliforniaToolkitCard* _tmp36_ = NULL;
		CaliforniaToolkitCard* _tmp37_ = NULL;
		CaliforniaToolkitCard* _tmp38_ = NULL;
		CaliforniaToolkitCard* _tmp39_ = NULL;
		CaliforniaToolkitCard* _tmp40_ = NULL;
		CaliforniaToolkitCard* _tmp41_ = NULL;
#line 193 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp35_ = self->priv->navigation_stack;
#line 193 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		gee_collection_clear (G_TYPE_CHECK_INSTANCE_CAST (_tmp35_, GEE_TYPE_COLLECTION, GeeCollection));
#line 194 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp36_ = california_toolkit_deck_get_home (self);
#line 194 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp37_ = _tmp36_;
#line 194 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp38_ = _tmp37_;
#line 194 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		gtk_stack_set_visible_child (G_TYPE_CHECK_INSTANCE_CAST (self, GTK_TYPE_STACK, GtkStack), G_TYPE_CHECK_INSTANCE_CAST (_tmp38_, GTK_TYPE_WIDGET, GtkWidget));
#line 194 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_g_object_unref0 (_tmp38_);
#line 195 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp39_ = california_toolkit_deck_get_home (self);
#line 195 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp40_ = _tmp39_;
#line 195 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp41_ = _tmp40_;
#line 195 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		california_toolkit_card_jumped_to (_tmp41_, NULL, NULL);
#line 195 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_g_object_unref0 (_tmp41_);
#line 915 "toolkit-deck.c"
	}
}


/**
     * Force the {@link Deck} to jump to the {@link home} {@link Card}.
     *
     * In general, Deck avoids jumping to a Card if it's already displayed (on top).  However, for
     * this call it will call the Card's {@link Card.jumped_to} method and pass the supplied
     * message every time, even if already on top.  This allows for this call to be used for Deck
     * initialization.
     */
void california_toolkit_deck_go_home (CaliforniaToolkitDeck* self, GValue* message) {
	CaliforniaToolkitCard* _tmp0_ = NULL;
	CaliforniaToolkitCard* _tmp1_ = NULL;
	CaliforniaToolkitCard* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	GeeDeque* _tmp4_ = NULL;
	CaliforniaToolkitCard* _tmp5_ = NULL;
	CaliforniaToolkitCard* _tmp6_ = NULL;
	CaliforniaToolkitCard* _tmp7_ = NULL;
	CaliforniaToolkitCard* _tmp8_ = NULL;
	CaliforniaToolkitCard* _tmp9_ = NULL;
	CaliforniaToolkitCard* _tmp10_ = NULL;
	GValue* _tmp11_ = NULL;
#line 207 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	g_return_if_fail (CALIFORNIA_TOOLKIT_IS_DECK (self));
#line 208 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp0_ = california_toolkit_deck_get_home (self);
#line 208 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp1_ = _tmp0_;
#line 208 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp2_ = _tmp1_;
#line 208 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp3_ = _tmp2_ == NULL;
#line 208 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_g_object_unref0 (_tmp2_);
#line 208 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	if (_tmp3_) {
#line 209 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		return;
#line 957 "toolkit-deck.c"
	}
#line 212 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp4_ = self->priv->navigation_stack;
#line 212 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	gee_collection_clear (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEE_TYPE_COLLECTION, GeeCollection));
#line 214 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp5_ = california_toolkit_deck_get_home (self);
#line 214 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp6_ = _tmp5_;
#line 214 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp7_ = _tmp6_;
#line 214 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	gtk_stack_set_visible_child (G_TYPE_CHECK_INSTANCE_CAST (self, GTK_TYPE_STACK, GtkStack), G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, GTK_TYPE_WIDGET, GtkWidget));
#line 214 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_g_object_unref0 (_tmp7_);
#line 215 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp8_ = california_toolkit_deck_get_home (self);
#line 215 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp9_ = _tmp8_;
#line 215 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp10_ = _tmp9_;
#line 215 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp11_ = message;
#line 215 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	california_toolkit_card_jumped_to (_tmp10_, NULL, _tmp11_);
#line 215 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_g_object_unref0 (_tmp10_);
#line 985 "toolkit-deck.c"
}


static void california_toolkit_deck_on_jump_to_card (CaliforniaToolkitDeck* self, CaliforniaToolkitCard* card, CaliforniaToolkitCard* next, GValue* message) {
	GtkWidget* _tmp0_ = NULL;
	CaliforniaToolkitCard* _tmp1_ = NULL;
	GeeHashMap* _tmp5_ = NULL;
	GeeCollection* _tmp6_ = NULL;
	GeeCollection* _tmp7_ = NULL;
	GeeCollection* _tmp8_ = NULL;
	CaliforniaToolkitCard* _tmp9_ = NULL;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp11_ = FALSE;
	CaliforniaToolkitCard* _tmp15_ = NULL;
	CaliforniaToolkitCard* _tmp16_ = NULL;
	CaliforniaToolkitCard* _tmp17_ = NULL;
	GValue* _tmp18_ = NULL;
#line 218 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	g_return_if_fail (CALIFORNIA_TOOLKIT_IS_DECK (self));
#line 218 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	g_return_if_fail (CALIFORNIA_TOOLKIT_IS_CARD (card));
#line 218 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	g_return_if_fail (CALIFORNIA_TOOLKIT_IS_CARD (next));
#line 220 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp0_ = gtk_stack_get_visible_child (G_TYPE_CHECK_INSTANCE_CAST (self, GTK_TYPE_STACK, GtkStack));
#line 220 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp1_ = next;
#line 220 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	if (_tmp0_ == _tmp1_) {
#line 1015 "toolkit-deck.c"
		CaliforniaToolkitCard* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
#line 221 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp2_ = next;
#line 221 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp3_ = california_toolkit_card_get_card_id (_tmp2_);
#line 221 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp4_ = _tmp3_;
#line 221 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		g_debug ("toolkit-deck.vala:221: Already showing card %s", _tmp4_);
#line 223 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		return;
#line 1029 "toolkit-deck.c"
	}
#line 227 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp5_ = self->priv->names;
#line 227 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp6_ = gee_abstract_map_get_values (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, GEE_TYPE_MAP, GeeMap));
#line 227 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp7_ = _tmp6_;
#line 227 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp8_ = _tmp7_;
#line 227 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp9_ = next;
#line 227 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp10_ = gee_collection_contains (_tmp8_, _tmp9_);
#line 227 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp11_ = !_tmp10_;
#line 227 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_g_object_unref0 (_tmp8_);
#line 227 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	if (_tmp11_) {
#line 1049 "toolkit-deck.c"
		CaliforniaToolkitCard* _tmp12_ = NULL;
		const gchar* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
#line 228 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp12_ = next;
#line 228 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp13_ = california_toolkit_card_get_card_id (_tmp12_);
#line 228 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp14_ = _tmp13_;
#line 228 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		g_message ("toolkit-deck.vala:228: Card %s not registered with Deck", _tmp14_);
#line 230 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		return;
#line 1063 "toolkit-deck.c"
	}
#line 233 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp15_ = next;
#line 233 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	gtk_stack_set_visible_child (G_TYPE_CHECK_INSTANCE_CAST (self, GTK_TYPE_STACK, GtkStack), G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, GTK_TYPE_WIDGET, GtkWidget));
#line 234 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp16_ = next;
#line 234 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp17_ = card;
#line 234 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp18_ = message;
#line 234 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	california_toolkit_card_jumped_to (_tmp16_, _tmp17_, _tmp18_);
#line 1077 "toolkit-deck.c"
}


static void california_toolkit_deck_on_jump_to_card_by_name (CaliforniaToolkitDeck* self, CaliforniaToolkitCard* card, const gchar* name, GValue* message) {
	CaliforniaToolkitCard* next = NULL;
	GeeHashMap* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gpointer _tmp2_ = NULL;
	CaliforniaToolkitCard* _tmp3_ = NULL;
#line 237 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	g_return_if_fail (CALIFORNIA_TOOLKIT_IS_DECK (self));
#line 237 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	g_return_if_fail (CALIFORNIA_TOOLKIT_IS_CARD (card));
#line 237 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	g_return_if_fail (name != NULL);
#line 238 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp0_ = self->priv->names;
#line 238 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp1_ = name;
#line 238 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp2_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp1_);
#line 238 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	next = (CaliforniaToolkitCard*) _tmp2_;
#line 239 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp3_ = next;
#line 239 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	if (_tmp3_ != NULL) {
#line 1105 "toolkit-deck.c"
		CaliforniaToolkitCard* _tmp4_ = NULL;
		CaliforniaToolkitCard* _tmp5_ = NULL;
		GValue* _tmp6_ = NULL;
#line 240 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp4_ = card;
#line 240 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp5_ = next;
#line 240 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp6_ = message;
#line 240 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		california_toolkit_deck_on_jump_to_card (self, _tmp4_, _tmp5_, _tmp6_);
#line 1117 "toolkit-deck.c"
	} else {
		const gchar* _tmp7_ = NULL;
#line 242 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp7_ = name;
#line 242 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		g_message ("toolkit-deck.vala:242: Card %s not found in Deck", _tmp7_);
#line 1124 "toolkit-deck.c"
	}
#line 237 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_g_object_unref0 (next);
#line 1128 "toolkit-deck.c"
}


static void california_toolkit_deck_on_jump_back (CaliforniaToolkitDeck* self, CaliforniaToolkitCard* card) {
	GeeDeque* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
#line 245 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	g_return_if_fail (CALIFORNIA_TOOLKIT_IS_DECK (self));
#line 245 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	g_return_if_fail (CALIFORNIA_TOOLKIT_IS_CARD (card));
#line 247 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp0_ = self->priv->navigation_stack;
#line 247 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp1_ = gee_collection_get_is_empty (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection));
#line 247 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp2_ = _tmp1_;
#line 247 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	if (!_tmp2_) {
#line 1148 "toolkit-deck.c"
		CaliforniaToolkitCard* _tmp3_ = NULL;
		GeeDeque* _tmp4_ = NULL;
		gpointer _tmp5_ = NULL;
		CaliforniaToolkitCard* _tmp6_ = NULL;
#line 248 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp3_ = card;
#line 248 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp4_ = self->priv->navigation_stack;
#line 248 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp5_ = gee_deque_poll_head (_tmp4_);
#line 248 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp6_ = (CaliforniaToolkitCard*) _tmp5_;
#line 248 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		california_toolkit_deck_on_jump_to_card (self, _tmp3_, _tmp6_, NULL);
#line 248 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_g_object_unref0 (_tmp6_);
#line 1165 "toolkit-deck.c"
	}
}


static void california_toolkit_deck_on_jump_home (CaliforniaToolkitDeck* self, CaliforniaToolkitCard* card) {
	GeeDeque* _tmp0_ = NULL;
	CaliforniaToolkitCard* _tmp1_ = NULL;
	CaliforniaToolkitCard* _tmp2_ = NULL;
	CaliforniaToolkitCard* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
#line 251 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	g_return_if_fail (CALIFORNIA_TOOLKIT_IS_DECK (self));
#line 251 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	g_return_if_fail (CALIFORNIA_TOOLKIT_IS_CARD (card));
#line 253 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp0_ = self->priv->navigation_stack;
#line 253 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	gee_collection_clear (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection));
#line 255 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp1_ = california_toolkit_deck_get_home (self);
#line 255 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp2_ = _tmp1_;
#line 255 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp3_ = _tmp2_;
#line 255 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp4_ = _tmp3_ != NULL;
#line 255 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_g_object_unref0 (_tmp3_);
#line 255 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	if (_tmp4_) {
#line 1196 "toolkit-deck.c"
		CaliforniaToolkitCard* _tmp5_ = NULL;
		CaliforniaToolkitCard* _tmp6_ = NULL;
		CaliforniaToolkitCard* _tmp7_ = NULL;
		CaliforniaToolkitCard* _tmp8_ = NULL;
#line 256 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp5_ = card;
#line 256 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp6_ = california_toolkit_deck_get_home (self);
#line 256 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp7_ = _tmp6_;
#line 256 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp8_ = _tmp7_;
#line 256 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		california_toolkit_deck_on_jump_to_card (self, _tmp5_, _tmp8_, NULL);
#line 256 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_g_object_unref0 (_tmp8_);
#line 1213 "toolkit-deck.c"
	} else {
#line 258 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		g_message ("toolkit-deck.vala:258: No home card in Deck");
#line 1217 "toolkit-deck.c"
	}
}


static void california_toolkit_deck_on_dismiss (CaliforniaToolkitDeck* self, gboolean user_request, gboolean final) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
#line 261 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	g_return_if_fail (CALIFORNIA_TOOLKIT_IS_DECK (self));
#line 262 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp0_ = user_request;
#line 262 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp1_ = final;
#line 262 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	g_signal_emit_by_name (self, "dismiss", _tmp0_, _tmp1_);
#line 1233 "toolkit-deck.c"
}


static void california_toolkit_deck_on_success (CaliforniaToolkitDeck* self) {
#line 265 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	g_return_if_fail (CALIFORNIA_TOOLKIT_IS_DECK (self));
#line 266 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	g_signal_emit_by_name (self, "success");
#line 1242 "toolkit-deck.c"
}


static void california_toolkit_deck_on_failure (CaliforniaToolkitDeck* self, const gchar* user_message) {
	const gchar* _tmp0_ = NULL;
#line 269 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	g_return_if_fail (CALIFORNIA_TOOLKIT_IS_DECK (self));
#line 270 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp0_ = user_message;
#line 270 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	g_signal_emit_by_name (self, "failure", _tmp0_);
#line 1254 "toolkit-deck.c"
}


static void california_toolkit_deck_on_card_mapped (CaliforniaToolkitDeck* self, GtkWidget* widget) {
	CaliforniaToolkitCard* card = NULL;
	GtkWidget* _tmp0_ = NULL;
	CaliforniaToolkitCard* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	CaliforniaToolkitCard* _tmp3_ = NULL;
	GtkWidget* _tmp4_ = NULL;
	GtkWidget* _tmp5_ = NULL;
	gboolean _tmp14_ = FALSE;
	CaliforniaToolkitCard* _tmp15_ = NULL;
	GtkWidget* _tmp16_ = NULL;
	GtkWidget* _tmp17_ = NULL;
#line 273 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	g_return_if_fail (CALIFORNIA_TOOLKIT_IS_DECK (self));
#line 273 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	g_return_if_fail (GTK_IS_WIDGET (widget));
#line 274 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp0_ = widget;
#line 274 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, CALIFORNIA_TOOLKIT_TYPE_CARD, CaliforniaToolkitCard));
#line 274 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	card = _tmp1_;
#line 276 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp3_ = card;
#line 276 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp4_ = california_toolkit_card_get_default_widget (_tmp3_);
#line 276 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp5_ = _tmp4_;
#line 276 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	if (_tmp5_ != NULL) {
#line 1288 "toolkit-deck.c"
		CaliforniaToolkitCard* _tmp6_ = NULL;
		GtkWidget* _tmp7_ = NULL;
		GtkWidget* _tmp8_ = NULL;
		gboolean _tmp9_ = FALSE;
		gboolean _tmp10_ = FALSE;
#line 276 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp6_ = card;
#line 276 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp7_ = california_toolkit_card_get_default_widget (_tmp6_);
#line 276 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp8_ = _tmp7_;
#line 276 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp9_ = gtk_widget_get_can_default (_tmp8_);
#line 276 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp10_ = _tmp9_;
#line 276 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp2_ = _tmp10_;
#line 1306 "toolkit-deck.c"
	} else {
#line 276 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp2_ = FALSE;
#line 1310 "toolkit-deck.c"
	}
#line 276 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	if (_tmp2_) {
#line 1314 "toolkit-deck.c"
		CaliforniaToolkitCard* _tmp11_ = NULL;
		GtkWidget* _tmp12_ = NULL;
		GtkWidget* _tmp13_ = NULL;
#line 277 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp11_ = card;
#line 277 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp12_ = california_toolkit_card_get_default_widget (_tmp11_);
#line 277 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp13_ = _tmp12_;
#line 277 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		gtk_widget_grab_default (_tmp13_);
#line 1326 "toolkit-deck.c"
	}
#line 279 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp15_ = card;
#line 279 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp16_ = california_toolkit_card_get_initial_focus (_tmp15_);
#line 279 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp17_ = _tmp16_;
#line 279 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	if (_tmp17_ != NULL) {
#line 1336 "toolkit-deck.c"
		CaliforniaToolkitCard* _tmp18_ = NULL;
		GtkWidget* _tmp19_ = NULL;
		GtkWidget* _tmp20_ = NULL;
		gboolean _tmp21_ = FALSE;
		gboolean _tmp22_ = FALSE;
#line 279 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp18_ = card;
#line 279 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp19_ = california_toolkit_card_get_initial_focus (_tmp18_);
#line 279 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp20_ = _tmp19_;
#line 279 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		g_object_get (_tmp20_, "can-focus", &_tmp21_, NULL);
#line 279 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp22_ = _tmp21_;
#line 279 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp14_ = _tmp22_;
#line 1354 "toolkit-deck.c"
	} else {
#line 279 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp14_ = FALSE;
#line 1358 "toolkit-deck.c"
	}
#line 279 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	if (_tmp14_) {
#line 1362 "toolkit-deck.c"
		CaliforniaToolkitCard* _tmp23_ = NULL;
		GtkWidget* _tmp24_ = NULL;
		GtkWidget* _tmp25_ = NULL;
#line 280 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp23_ = card;
#line 280 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp24_ = california_toolkit_card_get_initial_focus (_tmp23_);
#line 280 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp25_ = _tmp24_;
#line 280 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		gtk_widget_grab_focus (_tmp25_);
#line 1374 "toolkit-deck.c"
	}
#line 273 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_g_object_unref0 (card);
#line 1378 "toolkit-deck.c"
}


GtkWidget* california_toolkit_deck_get_default_widget (CaliforniaToolkitDeck* self) {
	GtkWidget* result;
#line 25 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	g_return_val_if_fail (CALIFORNIA_TOOLKIT_IS_DECK (self), NULL);
#line 25 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	result = NULL;
#line 25 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	return result;
#line 1390 "toolkit-deck.c"
}


gint california_toolkit_deck_get_size (CaliforniaToolkitDeck* self) {
	gint result;
	GeeList* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
#line 30 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	g_return_val_if_fail (CALIFORNIA_TOOLKIT_IS_DECK (self), 0);
#line 30 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp0_ = self->priv->list;
#line 30 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp1_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection));
#line 30 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp2_ = _tmp1_;
#line 30 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	result = _tmp2_;
#line 30 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	return result;
#line 1411 "toolkit-deck.c"
}


GeeList* california_toolkit_deck_get_cards (CaliforniaToolkitDeck* self) {
	GeeList* result;
	GeeList* _tmp0_ = NULL;
	GeeList* _tmp1_ = NULL;
	GeeList* _tmp2_ = NULL;
#line 35 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	g_return_val_if_fail (CALIFORNIA_TOOLKIT_IS_DECK (self), NULL);
#line 35 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp0_ = self->priv->list;
#line 35 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp1_ = gee_list_get_read_only_view (_tmp0_);
#line 35 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp2_ = _tmp1_;
#line 35 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	result = _tmp2_;
#line 35 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	return result;
#line 1432 "toolkit-deck.c"
}


CaliforniaToolkitCard* california_toolkit_deck_get_home (CaliforniaToolkitDeck* self) {
	CaliforniaToolkitCard* result;
	CaliforniaToolkitCard* _tmp0_ = NULL;
	GeeList* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
#line 40 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	g_return_val_if_fail (CALIFORNIA_TOOLKIT_IS_DECK (self), NULL);
#line 40 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp1_ = self->priv->list;
#line 40 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp2_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_COLLECTION, GeeCollection));
#line 40 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp3_ = _tmp2_;
#line 40 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	if (_tmp3_ > 0) {
#line 1452 "toolkit-deck.c"
		GeeList* _tmp4_ = NULL;
		gpointer _tmp5_ = NULL;
#line 40 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp4_ = self->priv->list;
#line 40 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp5_ = gee_list_get (_tmp4_, 0);
#line 40 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_g_object_unref0 (_tmp0_);
#line 40 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp0_ = (CaliforniaToolkitCard*) _tmp5_;
#line 1463 "toolkit-deck.c"
	} else {
#line 40 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_g_object_unref0 (_tmp0_);
#line 40 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp0_ = NULL;
#line 1469 "toolkit-deck.c"
	}
#line 40 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	result = _tmp0_;
#line 40 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	return result;
#line 1475 "toolkit-deck.c"
}


CaliforniaToolkitCard* california_toolkit_deck_get_top (CaliforniaToolkitDeck* self) {
	CaliforniaToolkitCard* result;
	CaliforniaToolkitCard* _tmp0_ = NULL;
#line 45 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	g_return_val_if_fail (CALIFORNIA_TOOLKIT_IS_DECK (self), NULL);
#line 45 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp0_ = self->priv->_top;
#line 45 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	result = _tmp0_;
#line 45 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	return result;
#line 1490 "toolkit-deck.c"
}


static void california_toolkit_deck_set_top (CaliforniaToolkitDeck* self, CaliforniaToolkitCard* value) {
	CaliforniaToolkitCard* _tmp0_ = NULL;
	CaliforniaToolkitCard* _tmp1_ = NULL;
#line 45 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	g_return_if_fail (CALIFORNIA_TOOLKIT_IS_DECK (self));
#line 45 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp0_ = value;
#line 45 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 45 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_g_object_unref0 (self->priv->_top);
#line 45 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	self->priv->_top = _tmp1_;
#line 45 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	g_object_notify ((GObject *) self, "top");
#line 1509 "toolkit-deck.c"
}


static void g_cclosure_user_marshal_VOID__BOOLEAN_BOOLEAN (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__BOOLEAN_BOOLEAN) (gpointer data1, gboolean arg_1, gboolean arg_2, gpointer data2);
	register GMarshalFunc_VOID__BOOLEAN_BOOLEAN callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
#line 16 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	g_return_if_fail (n_param_values == 3);
#line 16 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	if (G_CCLOSURE_SWAP_DATA (closure)) {
#line 16 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		data1 = closure->data;
#line 16 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		data2 = param_values->data[0].v_pointer;
#line 1528 "toolkit-deck.c"
	} else {
#line 16 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		data1 = param_values->data[0].v_pointer;
#line 16 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		data2 = closure->data;
#line 1534 "toolkit-deck.c"
	}
#line 16 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	callback = (GMarshalFunc_VOID__BOOLEAN_BOOLEAN) (marshal_data ? marshal_data : cc->callback);
#line 16 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	callback (data1, g_value_get_boolean (param_values + 1), g_value_get_boolean (param_values + 2), data2);
#line 1540 "toolkit-deck.c"
}


static void california_toolkit_deck_class_init (CaliforniaToolkitDeckClass * klass) {
#line 16 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	california_toolkit_deck_parent_class = g_type_class_peek_parent (klass);
#line 16 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	g_type_class_add_private (klass, sizeof (CaliforniaToolkitDeckPrivate));
#line 16 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_california_toolkit_deck_get_property;
#line 16 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_california_toolkit_deck_set_property;
#line 16 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	G_OBJECT_CLASS (klass)->finalize = california_toolkit_deck_finalize;
#line 1555 "toolkit-deck.c"
	/**
	     * @inheritedDoc
	     */
#line 16 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALIFORNIA_TOOLKIT_DECK_DEFAULT_WIDGET, g_param_spec_object ("default-widget", "default-widget", "default-widget", GTK_TYPE_WIDGET, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 1561 "toolkit-deck.c"
	/**
	     * The number of {@link Card}s registered to the {@link Deck}.
	     */
#line 16 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALIFORNIA_TOOLKIT_DECK_SIZE, g_param_spec_int ("size", "size", "size", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 1567 "toolkit-deck.c"
	/**
	     * All registered {@link Card}s returned as a read-only List.
	     */
#line 16 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALIFORNIA_TOOLKIT_DECK_CARDS, g_param_spec_object ("cards", "cards", "cards", GEE_TYPE_LIST, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 1573 "toolkit-deck.c"
	/**
	     * The home {@link Card}.
	     */
#line 16 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALIFORNIA_TOOLKIT_DECK_HOME, g_param_spec_object ("home", "home", "home", CALIFORNIA_TOOLKIT_TYPE_CARD, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 1579 "toolkit-deck.c"
	/**
	     * The current displayed {@link Card}.
	     */
#line 16 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALIFORNIA_TOOLKIT_DECK_TOP, g_param_spec_object ("top", "top", "top", CALIFORNIA_TOOLKIT_TYPE_CARD, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 1585 "toolkit-deck.c"
	/**
	     * @see Card.dismiss
	     */
#line 16 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	g_signal_new ("dismiss", CALIFORNIA_TOOLKIT_TYPE_DECK, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__BOOLEAN_BOOLEAN, G_TYPE_NONE, 2, G_TYPE_BOOLEAN, G_TYPE_BOOLEAN);
#line 1591 "toolkit-deck.c"
	/**
	     * @see Card.success
	     */
#line 16 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	g_signal_new ("success", CALIFORNIA_TOOLKIT_TYPE_DECK, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 1597 "toolkit-deck.c"
	/**
	     * @see Card.failure
	     */
#line 16 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	g_signal_new ("failure", CALIFORNIA_TOOLKIT_TYPE_DECK, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
#line 1603 "toolkit-deck.c"
}


static void california_toolkit_deck_instance_init (CaliforniaToolkitDeck * self) {
	GeeLinkedList* _tmp0_ = NULL;
	GeeLinkedList* _tmp1_ = NULL;
	GeeHashMap* _tmp2_ = NULL;
#line 16 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	self->priv = CALIFORNIA_TOOLKIT_DECK_GET_PRIVATE (self);
#line 45 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	self->priv->_top = NULL;
#line 47 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp0_ = gee_linked_list_new (CALIFORNIA_TOOLKIT_TYPE_CARD, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
#line 47 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	self->priv->list = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_LIST, GeeList);
#line 48 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp1_ = gee_linked_list_new (CALIFORNIA_TOOLKIT_TYPE_CARD, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
#line 48 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	self->priv->navigation_stack = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_DEQUE, GeeDeque);
#line 49 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_tmp2_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, CALIFORNIA_TOOLKIT_TYPE_CARD, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 49 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	self->priv->names = _tmp2_;
#line 1627 "toolkit-deck.c"
}


static void california_toolkit_deck_finalize (GObject* obj) {
	CaliforniaToolkitDeck * self;
#line 16 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CALIFORNIA_TOOLKIT_TYPE_DECK, CaliforniaToolkitDeck);
#line 1635 "toolkit-deck.c"
	{
		GeeIterator* _card_it = NULL;
		GeeHashMap* _tmp0_ = NULL;
		GeeCollection* _tmp1_ = NULL;
		GeeCollection* _tmp2_ = NULL;
		GeeCollection* _tmp3_ = NULL;
		GeeIterator* _tmp4_ = NULL;
		GeeIterator* _tmp5_ = NULL;
#line 81 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp0_ = self->priv->names;
#line 81 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp1_ = gee_abstract_map_get_values (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_MAP, GeeMap));
#line 81 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp2_ = _tmp1_;
#line 81 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp3_ = _tmp2_;
#line 81 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp4_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_ITERABLE, GeeIterable));
#line 81 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_tmp5_ = _tmp4_;
#line 81 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_g_object_unref0 (_tmp3_);
#line 81 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_card_it = _tmp5_;
#line 81 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		while (TRUE) {
#line 1662 "toolkit-deck.c"
			GeeIterator* _tmp6_ = NULL;
			gboolean _tmp7_ = FALSE;
			CaliforniaToolkitCard* card = NULL;
			GeeIterator* _tmp8_ = NULL;
			gpointer _tmp9_ = NULL;
			CaliforniaToolkitCard* _tmp10_ = NULL;
			guint _tmp11_ = 0U;
#line 81 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp6_ = _card_it;
#line 81 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp7_ = gee_iterator_next (_tmp6_);
#line 81 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			if (!_tmp7_) {
#line 81 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
				break;
#line 1678 "toolkit-deck.c"
			}
#line 81 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp8_ = _card_it;
#line 81 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp9_ = gee_iterator_get (_tmp8_);
#line 81 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			card = (CaliforniaToolkitCard*) _tmp9_;
#line 82 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_tmp10_ = card;
#line 82 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			g_signal_parse_name ("map", GTK_TYPE_WIDGET, &_tmp11_, NULL, FALSE);
#line 82 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			g_signal_handlers_disconnect_matched (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, GTK_TYPE_WIDGET, GtkWidget), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp11_, 0, NULL, (GCallback) _california_toolkit_deck_on_card_mapped_gtk_widget_map, self);
#line 81 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
			_g_object_unref0 (card);
#line 1694 "toolkit-deck.c"
		}
#line 81 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		_g_object_unref0 (_card_it);
#line 1698 "toolkit-deck.c"
	}
#line 45 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_g_object_unref0 (self->priv->_top);
#line 47 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_g_object_unref0 (self->priv->list);
#line 48 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_g_object_unref0 (self->priv->navigation_stack);
#line 49 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	_g_object_unref0 (self->priv->names);
#line 16 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	G_OBJECT_CLASS (california_toolkit_deck_parent_class)->finalize (obj);
#line 1710 "toolkit-deck.c"
}


/**
 * A Deck is a collection of {@link Card}s maintained within a Gtk.Stack.
 *
 * Cards control navigation through their various signals, which Deck monitors and acts upon.
 * It also notifies Cards of nagivation changes which affect them via their abstract methods.
 */
GType california_toolkit_deck_get_type (void) {
	static volatile gsize california_toolkit_deck_type_id__volatile = 0;
	if (g_once_init_enter (&california_toolkit_deck_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (CaliforniaToolkitDeckClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) california_toolkit_deck_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CaliforniaToolkitDeck), 0, (GInstanceInitFunc) california_toolkit_deck_instance_init, NULL };
		GType california_toolkit_deck_type_id;
		california_toolkit_deck_type_id = g_type_register_static (GTK_TYPE_STACK, "CaliforniaToolkitDeck", &g_define_type_info, 0);
		g_once_init_leave (&california_toolkit_deck_type_id__volatile, california_toolkit_deck_type_id);
	}
	return california_toolkit_deck_type_id__volatile;
}


static void _vala_california_toolkit_deck_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	CaliforniaToolkitDeck * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CALIFORNIA_TOOLKIT_TYPE_DECK, CaliforniaToolkitDeck);
#line 16 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	switch (property_id) {
#line 16 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		case CALIFORNIA_TOOLKIT_DECK_DEFAULT_WIDGET:
#line 16 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		g_value_set_object (value, california_toolkit_deck_get_default_widget (self));
#line 16 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		break;
#line 16 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		case CALIFORNIA_TOOLKIT_DECK_SIZE:
#line 16 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		g_value_set_int (value, california_toolkit_deck_get_size (self));
#line 16 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		break;
#line 16 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		case CALIFORNIA_TOOLKIT_DECK_CARDS:
#line 16 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		g_value_take_object (value, california_toolkit_deck_get_cards (self));
#line 16 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		break;
#line 16 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		case CALIFORNIA_TOOLKIT_DECK_HOME:
#line 16 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		g_value_take_object (value, california_toolkit_deck_get_home (self));
#line 16 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		break;
#line 16 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		case CALIFORNIA_TOOLKIT_DECK_TOP:
#line 16 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		g_value_set_object (value, california_toolkit_deck_get_top (self));
#line 16 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		break;
#line 1767 "toolkit-deck.c"
		default:
#line 16 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 16 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		break;
#line 1773 "toolkit-deck.c"
	}
}


static void _vala_california_toolkit_deck_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	CaliforniaToolkitDeck * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CALIFORNIA_TOOLKIT_TYPE_DECK, CaliforniaToolkitDeck);
#line 16 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
	switch (property_id) {
#line 16 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		case CALIFORNIA_TOOLKIT_DECK_TOP:
#line 16 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		california_toolkit_deck_set_top (self, g_value_get_object (value));
#line 16 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		break;
#line 1789 "toolkit-deck.c"
		default:
#line 16 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 16 "/home/jim/git/california/src/toolkit/toolkit-deck.vala"
		break;
#line 1795 "toolkit-deck.c"
	}
}



