/* calendar-month-of-year.c generated by valac 0.24.0, the Vala compiler
 * generated from calendar-month-of-year.vala, do not modify */

/* Copyright 2014 Yorba Foundation
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>


#define CALIFORNIA_TYPE_BASE_OBJECT (california_base_object_get_type ())
#define CALIFORNIA_BASE_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_TYPE_BASE_OBJECT, CaliforniaBaseObject))
#define CALIFORNIA_BASE_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_TYPE_BASE_OBJECT, CaliforniaBaseObjectClass))
#define CALIFORNIA_IS_BASE_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_TYPE_BASE_OBJECT))
#define CALIFORNIA_IS_BASE_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_TYPE_BASE_OBJECT))
#define CALIFORNIA_BASE_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_TYPE_BASE_OBJECT, CaliforniaBaseObjectClass))

typedef struct _CaliforniaBaseObject CaliforniaBaseObject;
typedef struct _CaliforniaBaseObjectClass CaliforniaBaseObjectClass;
typedef struct _CaliforniaBaseObjectPrivate CaliforniaBaseObjectPrivate;

#define CALIFORNIA_COLLECTION_TYPE_SIMPLE_ITERABLE (california_collection_simple_iterable_get_type ())
#define CALIFORNIA_COLLECTION_SIMPLE_ITERABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_COLLECTION_TYPE_SIMPLE_ITERABLE, CaliforniaCollectionSimpleIterable))
#define CALIFORNIA_COLLECTION_IS_SIMPLE_ITERABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_COLLECTION_TYPE_SIMPLE_ITERABLE))
#define CALIFORNIA_COLLECTION_SIMPLE_ITERABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), CALIFORNIA_COLLECTION_TYPE_SIMPLE_ITERABLE, CaliforniaCollectionSimpleIterableIface))

typedef struct _CaliforniaCollectionSimpleIterable CaliforniaCollectionSimpleIterable;
typedef struct _CaliforniaCollectionSimpleIterableIface CaliforniaCollectionSimpleIterableIface;

#define CALIFORNIA_COLLECTION_TYPE_SIMPLE_ITERATOR (california_collection_simple_iterator_get_type ())
#define CALIFORNIA_COLLECTION_SIMPLE_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_COLLECTION_TYPE_SIMPLE_ITERATOR, CaliforniaCollectionSimpleIterator))
#define CALIFORNIA_COLLECTION_IS_SIMPLE_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_COLLECTION_TYPE_SIMPLE_ITERATOR))
#define CALIFORNIA_COLLECTION_SIMPLE_ITERATOR_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), CALIFORNIA_COLLECTION_TYPE_SIMPLE_ITERATOR, CaliforniaCollectionSimpleIteratorIface))

typedef struct _CaliforniaCollectionSimpleIterator CaliforniaCollectionSimpleIterator;
typedef struct _CaliforniaCollectionSimpleIteratorIface CaliforniaCollectionSimpleIteratorIface;

#define CALIFORNIA_CALENDAR_TYPE_SPAN (california_calendar_span_get_type ())
#define CALIFORNIA_CALENDAR_SPAN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_CALENDAR_TYPE_SPAN, CaliforniaCalendarSpan))
#define CALIFORNIA_CALENDAR_IS_SPAN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_CALENDAR_TYPE_SPAN))
#define CALIFORNIA_CALENDAR_SPAN_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), CALIFORNIA_CALENDAR_TYPE_SPAN, CaliforniaCalendarSpanIface))

typedef struct _CaliforniaCalendarSpan CaliforniaCalendarSpan;
typedef struct _CaliforniaCalendarSpanIface CaliforniaCalendarSpanIface;

#define CALIFORNIA_CALENDAR_TYPE_DATE (california_calendar_date_get_type ())
#define CALIFORNIA_CALENDAR_DATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_CALENDAR_TYPE_DATE, CaliforniaCalendarDate))
#define CALIFORNIA_CALENDAR_DATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_CALENDAR_TYPE_DATE, CaliforniaCalendarDateClass))
#define CALIFORNIA_CALENDAR_IS_DATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_CALENDAR_TYPE_DATE))
#define CALIFORNIA_CALENDAR_IS_DATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_CALENDAR_TYPE_DATE))
#define CALIFORNIA_CALENDAR_DATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_CALENDAR_TYPE_DATE, CaliforniaCalendarDateClass))

typedef struct _CaliforniaCalendarDate CaliforniaCalendarDate;
typedef struct _CaliforniaCalendarDateClass CaliforniaCalendarDateClass;

#define CALIFORNIA_CALENDAR_TYPE_DATE_SPAN (california_calendar_date_span_get_type ())
#define CALIFORNIA_CALENDAR_DATE_SPAN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_CALENDAR_TYPE_DATE_SPAN, CaliforniaCalendarDateSpan))
#define CALIFORNIA_CALENDAR_DATE_SPAN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_CALENDAR_TYPE_DATE_SPAN, CaliforniaCalendarDateSpanClass))
#define CALIFORNIA_CALENDAR_IS_DATE_SPAN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_CALENDAR_TYPE_DATE_SPAN))
#define CALIFORNIA_CALENDAR_IS_DATE_SPAN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_CALENDAR_TYPE_DATE_SPAN))
#define CALIFORNIA_CALENDAR_DATE_SPAN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_CALENDAR_TYPE_DATE_SPAN, CaliforniaCalendarDateSpanClass))

typedef struct _CaliforniaCalendarDateSpan CaliforniaCalendarDateSpan;
typedef struct _CaliforniaCalendarDateSpanClass CaliforniaCalendarDateSpanClass;
typedef struct _CaliforniaCalendarDateSpanPrivate CaliforniaCalendarDateSpanPrivate;

#define CALIFORNIA_CALENDAR_TYPE_MONTH_OF_YEAR (california_calendar_month_of_year_get_type ())
#define CALIFORNIA_CALENDAR_MONTH_OF_YEAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_CALENDAR_TYPE_MONTH_OF_YEAR, CaliforniaCalendarMonthOfYear))
#define CALIFORNIA_CALENDAR_MONTH_OF_YEAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_CALENDAR_TYPE_MONTH_OF_YEAR, CaliforniaCalendarMonthOfYearClass))
#define CALIFORNIA_CALENDAR_IS_MONTH_OF_YEAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_CALENDAR_TYPE_MONTH_OF_YEAR))
#define CALIFORNIA_CALENDAR_IS_MONTH_OF_YEAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_CALENDAR_TYPE_MONTH_OF_YEAR))
#define CALIFORNIA_CALENDAR_MONTH_OF_YEAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_CALENDAR_TYPE_MONTH_OF_YEAR, CaliforniaCalendarMonthOfYearClass))

typedef struct _CaliforniaCalendarMonthOfYear CaliforniaCalendarMonthOfYear;
typedef struct _CaliforniaCalendarMonthOfYearClass CaliforniaCalendarMonthOfYearClass;
typedef struct _CaliforniaCalendarMonthOfYearPrivate CaliforniaCalendarMonthOfYearPrivate;

#define CALIFORNIA_CALENDAR_TYPE_MONTH (california_calendar_month_get_type ())
#define CALIFORNIA_CALENDAR_MONTH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_CALENDAR_TYPE_MONTH, CaliforniaCalendarMonth))
#define CALIFORNIA_CALENDAR_MONTH_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_CALENDAR_TYPE_MONTH, CaliforniaCalendarMonthClass))
#define CALIFORNIA_CALENDAR_IS_MONTH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_CALENDAR_TYPE_MONTH))
#define CALIFORNIA_CALENDAR_IS_MONTH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_CALENDAR_TYPE_MONTH))
#define CALIFORNIA_CALENDAR_MONTH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_CALENDAR_TYPE_MONTH, CaliforniaCalendarMonthClass))

typedef struct _CaliforniaCalendarMonth CaliforniaCalendarMonth;
typedef struct _CaliforniaCalendarMonthClass CaliforniaCalendarMonthClass;

#define CALIFORNIA_CALENDAR_TYPE_YEAR (california_calendar_year_get_type ())
#define CALIFORNIA_CALENDAR_YEAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_CALENDAR_TYPE_YEAR, CaliforniaCalendarYear))
#define CALIFORNIA_CALENDAR_YEAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_CALENDAR_TYPE_YEAR, CaliforniaCalendarYearClass))
#define CALIFORNIA_CALENDAR_IS_YEAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_CALENDAR_TYPE_YEAR))
#define CALIFORNIA_CALENDAR_IS_YEAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_CALENDAR_TYPE_YEAR))
#define CALIFORNIA_CALENDAR_YEAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_CALENDAR_TYPE_YEAR, CaliforniaCalendarYearClass))

typedef struct _CaliforniaCalendarYear CaliforniaCalendarYear;
typedef struct _CaliforniaCalendarYearClass CaliforniaCalendarYearClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define CALIFORNIA_CALENDAR_TYPE_DAY_OF_MONTH (california_calendar_day_of_month_get_type ())
#define CALIFORNIA_CALENDAR_DAY_OF_MONTH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_CALENDAR_TYPE_DAY_OF_MONTH, CaliforniaCalendarDayOfMonth))
#define CALIFORNIA_CALENDAR_DAY_OF_MONTH_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_CALENDAR_TYPE_DAY_OF_MONTH, CaliforniaCalendarDayOfMonthClass))
#define CALIFORNIA_CALENDAR_IS_DAY_OF_MONTH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_CALENDAR_TYPE_DAY_OF_MONTH))
#define CALIFORNIA_CALENDAR_IS_DAY_OF_MONTH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_CALENDAR_TYPE_DAY_OF_MONTH))
#define CALIFORNIA_CALENDAR_DAY_OF_MONTH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_CALENDAR_TYPE_DAY_OF_MONTH, CaliforniaCalendarDayOfMonthClass))

typedef struct _CaliforniaCalendarDayOfMonth CaliforniaCalendarDayOfMonth;
typedef struct _CaliforniaCalendarDayOfMonthClass CaliforniaCalendarDayOfMonthClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define CALIFORNIA_CALENDAR_TYPE_DATE_UNIT (california_calendar_date_unit_get_type ())

struct _CaliforniaBaseObject {
	GObject parent_instance;
	CaliforniaBaseObjectPrivate * priv;
};

struct _CaliforniaBaseObjectClass {
	GObjectClass parent_class;
	gchar* (*to_string) (CaliforniaBaseObject* self);
};

struct _CaliforniaCollectionSimpleIteratorIface {
	GTypeInterface parent_iface;
	gboolean (*next) (CaliforniaCollectionSimpleIterator* self);
	gpointer (*get) (CaliforniaCollectionSimpleIterator* self);
};

struct _CaliforniaCollectionSimpleIterableIface {
	GTypeInterface parent_iface;
	CaliforniaCollectionSimpleIterator* (*iterator) (CaliforniaCollectionSimpleIterable* self);
};

struct _CaliforniaCalendarSpanIface {
	GTypeInterface parent_iface;
	gpointer (*start) (CaliforniaCalendarSpan* self);
	gpointer (*end) (CaliforniaCalendarSpan* self);
	gboolean (*contains) (CaliforniaCalendarSpan* self, CaliforniaCalendarDate* date);
	gboolean (*has) (CaliforniaCalendarSpan* self, gconstpointer unit);
	CaliforniaCalendarDate* (*get_start_date) (CaliforniaCalendarSpan* self);
	CaliforniaCalendarDate* (*get_end_date) (CaliforniaCalendarSpan* self);
};

struct _CaliforniaCalendarDateSpan {
	CaliforniaBaseObject parent_instance;
	CaliforniaCalendarDateSpanPrivate * priv;
};

struct _CaliforniaCalendarDateSpanClass {
	CaliforniaBaseObjectClass parent_class;
};

struct _CaliforniaCalendarMonthOfYear {
	CaliforniaCalendarDateSpan parent_instance;
	CaliforniaCalendarMonthOfYearPrivate * priv;
};

struct _CaliforniaCalendarMonthOfYearClass {
	CaliforniaCalendarDateSpanClass parent_class;
};

struct _CaliforniaCalendarMonthOfYearPrivate {
	CaliforniaCalendarMonth* _month;
	CaliforniaCalendarYear* _year;
	gint _days_in_month;
	gchar* _full_name;
	gchar* _abbrev_name;
};

typedef enum  {
	CALIFORNIA_CALENDAR_ERROR_INVALID
} CaliforniaCalendarError;
#define CALIFORNIA_CALENDAR_ERROR california_calendar_error_quark ()
typedef enum  {
	CALIFORNIA_CALENDAR_DATE_UNIT_DAY,
	CALIFORNIA_CALENDAR_DATE_UNIT_WEEK,
	CALIFORNIA_CALENDAR_DATE_UNIT_MONTH,
	CALIFORNIA_CALENDAR_DATE_UNIT_YEAR
} CaliforniaCalendarDateUnit;


static gpointer california_calendar_month_of_year_parent_class = NULL;
extern const gchar* california_calendar_FMT_MONTH_YEAR_FULL;
extern const gchar* california_calendar_FMT_MONTH_YEAR_ABBREV;

GType california_base_object_get_type (void) G_GNUC_CONST;
GType california_collection_simple_iterator_get_type (void) G_GNUC_CONST;
GType california_collection_simple_iterable_get_type (void) G_GNUC_CONST;
GType california_calendar_date_get_type (void) G_GNUC_CONST;
GType california_calendar_span_get_type (void) G_GNUC_CONST;
GType california_calendar_date_span_get_type (void) G_GNUC_CONST;
GType california_calendar_month_of_year_get_type (void) G_GNUC_CONST;
GType california_calendar_month_get_type (void) G_GNUC_CONST;
GType california_calendar_year_get_type (void) G_GNUC_CONST;
#define CALIFORNIA_CALENDAR_MONTH_OF_YEAR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), CALIFORNIA_CALENDAR_TYPE_MONTH_OF_YEAR, CaliforniaCalendarMonthOfYearPrivate))
enum  {
	CALIFORNIA_CALENDAR_MONTH_OF_YEAR_DUMMY_PROPERTY,
	CALIFORNIA_CALENDAR_MONTH_OF_YEAR_MONTH,
	CALIFORNIA_CALENDAR_MONTH_OF_YEAR_YEAR,
	CALIFORNIA_CALENDAR_MONTH_OF_YEAR_DAYS_IN_MONTH,
	CALIFORNIA_CALENDAR_MONTH_OF_YEAR_FULL_NAME,
	CALIFORNIA_CALENDAR_MONTH_OF_YEAR_ABBREV_NAME
};
CaliforniaCalendarMonthOfYear* california_calendar_month_of_year_new (CaliforniaCalendarMonth* month, CaliforniaCalendarYear* year);
CaliforniaCalendarMonthOfYear* california_calendar_month_of_year_construct (GType object_type, CaliforniaCalendarMonth* month, CaliforniaCalendarYear* year);
CaliforniaCalendarDateSpan* california_calendar_date_span_new_uninitialized (void);
CaliforniaCalendarDateSpan* california_calendar_date_span_construct_uninitialized (GType object_type);
static void california_calendar_month_of_year_set_month (CaliforniaCalendarMonthOfYear* self, CaliforniaCalendarMonth* value);
static void california_calendar_month_of_year_set_year (CaliforniaCalendarMonthOfYear* self, CaliforniaCalendarYear* value);
GDateMonth california_calendar_month_to_date_month (CaliforniaCalendarMonth* self);
GDateYear california_calendar_year_to_date_year (CaliforniaCalendarYear* self);
static void california_calendar_month_of_year_set_days_in_month (CaliforniaCalendarMonthOfYear* self, gint value);
GType california_calendar_day_of_month_get_type (void) G_GNUC_CONST;
GQuark california_calendar_error_quark (void);
CaliforniaCalendarDate* california_calendar_month_of_year_date_for (CaliforniaCalendarMonthOfYear* self, CaliforniaCalendarDayOfMonth* day_of_month, GError** error);
CaliforniaCalendarDayOfMonth* california_calendar_month_of_year_first_day_of_month (CaliforniaCalendarMonthOfYear* self);
CaliforniaCalendarDayOfMonth* california_calendar_month_of_year_last_day_of_month (CaliforniaCalendarMonthOfYear* self);
void california_calendar_date_span_init_span (CaliforniaCalendarDateSpan* self, CaliforniaCalendarDate* start_date, CaliforniaCalendarDate* end_date);
gchar* california_base_object_to_string (CaliforniaBaseObject* self);
CaliforniaCalendarDate* california_calendar_span_get_start_date (CaliforniaCalendarSpan* self);
gchar* california_calendar_date_format (CaliforniaCalendarDate* self, const gchar* fmt);
static void california_calendar_month_of_year_set_full_name (CaliforniaCalendarMonthOfYear* self, const gchar* value);
static void california_calendar_month_of_year_set_abbrev_name (CaliforniaCalendarMonthOfYear* self, const gchar* value);
CaliforniaCalendarDayOfMonth* california_calendar_day_of_month_first (void);
CaliforniaCalendarDayOfMonth* california_calendar_day_of_month_for_checked (gint value);
gint california_calendar_month_of_year_get_days_in_month (CaliforniaCalendarMonthOfYear* self);
CaliforniaCalendarMonth* california_calendar_month_of_year_get_month (CaliforniaCalendarMonthOfYear* self);
CaliforniaCalendarYear* california_calendar_month_of_year_get_year (CaliforniaCalendarMonthOfYear* self);
CaliforniaCalendarDate* california_calendar_date_new (CaliforniaCalendarDayOfMonth* day_of_month, CaliforniaCalendarMonth* month, CaliforniaCalendarYear* year, GError** error);
CaliforniaCalendarDate* california_calendar_date_construct (GType object_type, CaliforniaCalendarDayOfMonth* day_of_month, CaliforniaCalendarMonth* month, CaliforniaCalendarYear* year, GError** error);
CaliforniaCalendarMonthOfYear* california_calendar_month_of_year_adjust (CaliforniaCalendarMonthOfYear* self, gint quantity);
GType california_calendar_date_unit_get_type (void) G_GNUC_CONST;
CaliforniaCalendarDate* california_calendar_date_adjust (CaliforniaCalendarDate* self, gint quantity, CaliforniaCalendarDateUnit unit);
CaliforniaCalendarMonthOfYear* california_calendar_date_month_of_year (CaliforniaCalendarDate* self);
gint california_calendar_month_of_year_difference (CaliforniaCalendarMonthOfYear* self, CaliforniaCalendarMonthOfYear* other);
CaliforniaCalendarMonthOfYear* california_calendar_month_of_year_previous (CaliforniaCalendarMonthOfYear* self);
CaliforniaCalendarMonthOfYear* california_calendar_month_of_year_next (CaliforniaCalendarMonthOfYear* self);
static gchar* california_calendar_month_of_year_real_to_string (CaliforniaBaseObject* base);
const gchar* california_calendar_month_of_year_get_full_name (CaliforniaCalendarMonthOfYear* self);
const gchar* california_calendar_month_of_year_get_abbrev_name (CaliforniaCalendarMonthOfYear* self);
static void california_calendar_month_of_year_finalize (GObject* obj);
static void _vala_california_calendar_month_of_year_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_california_calendar_month_of_year_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


CaliforniaCalendarMonthOfYear* california_calendar_month_of_year_construct (GType object_type, CaliforniaCalendarMonth* month, CaliforniaCalendarYear* year) {
	CaliforniaCalendarMonthOfYear * self = NULL;
	CaliforniaCalendarMonth* _tmp0_ = NULL;
	CaliforniaCalendarYear* _tmp1_ = NULL;
	CaliforniaCalendarMonth* _tmp2_ = NULL;
	GDateMonth _tmp3_ = 0;
	CaliforniaCalendarYear* _tmp4_ = NULL;
	GDateYear _tmp5_ = 0U;
	guchar _tmp6_ = '\0';
	CaliforniaCalendarDate* _tmp20_ = NULL;
	CaliforniaCalendarDate* _tmp21_ = NULL;
	CaliforniaCalendarDate* _tmp22_ = NULL;
	const gchar* _tmp23_ = NULL;
	gchar* _tmp24_ = NULL;
	gchar* _tmp25_ = NULL;
	CaliforniaCalendarDate* _tmp26_ = NULL;
	CaliforniaCalendarDate* _tmp27_ = NULL;
	CaliforniaCalendarDate* _tmp28_ = NULL;
	const gchar* _tmp29_ = NULL;
	gchar* _tmp30_ = NULL;
	gchar* _tmp31_ = NULL;
	GError * _inner_error_ = NULL;
#line 39 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_MONTH (month), NULL);
#line 39 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_YEAR (year), NULL);
#line 40 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	self = (CaliforniaCalendarMonthOfYear*) california_calendar_date_span_construct_uninitialized (object_type);
#line 42 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	_tmp0_ = month;
#line 42 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	california_calendar_month_of_year_set_month (self, _tmp0_);
#line 43 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	_tmp1_ = year;
#line 43 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	california_calendar_month_of_year_set_year (self, _tmp1_);
#line 44 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	_tmp2_ = month;
#line 44 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	_tmp3_ = california_calendar_month_to_date_month (_tmp2_);
#line 44 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	_tmp4_ = year;
#line 44 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	_tmp5_ = california_calendar_year_to_date_year (_tmp4_);
#line 44 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	_tmp6_ = g_date_get_days_in_month (_tmp3_, _tmp5_);
#line 44 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	california_calendar_month_of_year_set_days_in_month (self, (gint) _tmp6_);
#line 301 "calendar-month-of-year.c"
	{
		CaliforniaCalendarDate* _tmp7_ = NULL;
		CaliforniaCalendarDayOfMonth* _tmp8_ = NULL;
		CaliforniaCalendarDayOfMonth* _tmp9_ = NULL;
		CaliforniaCalendarDate* _tmp10_ = NULL;
		CaliforniaCalendarDate* _tmp11_ = NULL;
		CaliforniaCalendarDate* _tmp12_ = NULL;
		CaliforniaCalendarDayOfMonth* _tmp13_ = NULL;
		CaliforniaCalendarDayOfMonth* _tmp14_ = NULL;
		CaliforniaCalendarDate* _tmp15_ = NULL;
		CaliforniaCalendarDate* _tmp16_ = NULL;
#line 47 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
		_tmp8_ = california_calendar_month_of_year_first_day_of_month (self);
#line 47 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
		_tmp9_ = _tmp8_;
#line 47 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
		_tmp10_ = california_calendar_month_of_year_date_for (self, _tmp9_, &_inner_error_);
#line 47 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
		_tmp11_ = _tmp10_;
#line 47 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
		_g_object_unref0 (_tmp9_);
#line 47 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
		_tmp7_ = _tmp11_;
#line 47 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
		if (_inner_error_ != NULL) {
#line 47 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
			if (_inner_error_->domain == CALIFORNIA_CALENDAR_ERROR) {
#line 329 "calendar-month-of-year.c"
				goto __catch25_california_calendar_error;
			}
#line 47 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 47 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
			g_clear_error (&_inner_error_);
#line 47 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
			return NULL;
#line 338 "calendar-month-of-year.c"
		}
#line 47 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
		_tmp13_ = california_calendar_month_of_year_last_day_of_month (self);
#line 47 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
		_tmp14_ = _tmp13_;
#line 47 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
		_tmp15_ = california_calendar_month_of_year_date_for (self, _tmp14_, &_inner_error_);
#line 47 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
		_tmp16_ = _tmp15_;
#line 47 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
		_g_object_unref0 (_tmp14_);
#line 47 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
		_tmp12_ = _tmp16_;
#line 47 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
		if (_inner_error_ != NULL) {
#line 47 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
			_g_object_unref0 (_tmp7_);
#line 47 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
			if (_inner_error_->domain == CALIFORNIA_CALENDAR_ERROR) {
#line 358 "calendar-month-of-year.c"
				goto __catch25_california_calendar_error;
			}
#line 47 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
			_g_object_unref0 (_tmp7_);
#line 47 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 47 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
			g_clear_error (&_inner_error_);
#line 47 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
			return NULL;
#line 369 "calendar-month-of-year.c"
		}
#line 47 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
		california_calendar_date_span_init_span (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_CALENDAR_TYPE_DATE_SPAN, CaliforniaCalendarDateSpan), _tmp7_, _tmp12_);
#line 46 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
		_g_object_unref0 (_tmp12_);
#line 46 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
		_g_object_unref0 (_tmp7_);
#line 377 "calendar-month-of-year.c"
	}
	goto __finally25;
	__catch25_california_calendar_error:
	{
		GError* calerr = NULL;
		gchar* _tmp17_ = NULL;
		gchar* _tmp18_ = NULL;
		const gchar* _tmp19_ = NULL;
#line 46 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
		calerr = _inner_error_;
#line 46 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
		_inner_error_ = NULL;
#line 49 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
		_tmp17_ = california_base_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_TYPE_BASE_OBJECT, CaliforniaBaseObject));
#line 49 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
		_tmp18_ = _tmp17_;
#line 49 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
		_tmp19_ = calerr->message;
#line 49 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
		g_error ("calendar-month-of-year.vala:49: Unable to generate first/last days of " \
"month for %s: %s", _tmp18_, _tmp19_);
#line 49 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
		_g_free0 (_tmp18_);
#line 46 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
		_g_error_free0 (calerr);
#line 402 "calendar-month-of-year.c"
	}
	__finally25:
#line 46 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	if (_inner_error_ != NULL) {
#line 46 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 46 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
		g_clear_error (&_inner_error_);
#line 46 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
		return NULL;
#line 413 "calendar-month-of-year.c"
	}
#line 52 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	_tmp20_ = california_calendar_span_get_start_date (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_CALENDAR_TYPE_SPAN, CaliforniaCalendarSpan));
#line 52 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	_tmp21_ = _tmp20_;
#line 52 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	_tmp22_ = _tmp21_;
#line 52 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	_tmp23_ = california_calendar_FMT_MONTH_YEAR_FULL;
#line 52 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	_tmp24_ = california_calendar_date_format (_tmp22_, _tmp23_);
#line 52 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	_tmp25_ = _tmp24_;
#line 52 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	california_calendar_month_of_year_set_full_name (self, _tmp25_);
#line 52 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	_g_free0 (_tmp25_);
#line 52 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	_g_object_unref0 (_tmp22_);
#line 53 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	_tmp26_ = california_calendar_span_get_start_date (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_CALENDAR_TYPE_SPAN, CaliforniaCalendarSpan));
#line 53 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	_tmp27_ = _tmp26_;
#line 53 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	_tmp28_ = _tmp27_;
#line 53 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	_tmp29_ = california_calendar_FMT_MONTH_YEAR_ABBREV;
#line 53 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	_tmp30_ = california_calendar_date_format (_tmp28_, _tmp29_);
#line 53 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	_tmp31_ = _tmp30_;
#line 53 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	california_calendar_month_of_year_set_abbrev_name (self, _tmp31_);
#line 53 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	_g_free0 (_tmp31_);
#line 53 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	_g_object_unref0 (_tmp28_);
#line 39 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	return self;
#line 453 "calendar-month-of-year.c"
}


CaliforniaCalendarMonthOfYear* california_calendar_month_of_year_new (CaliforniaCalendarMonth* month, CaliforniaCalendarYear* year) {
#line 39 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	return california_calendar_month_of_year_construct (CALIFORNIA_CALENDAR_TYPE_MONTH_OF_YEAR, month, year);
#line 460 "calendar-month-of-year.c"
}


/**
     * Returns the first {@link DayOfMonth} for the month in the associated year.
     */
CaliforniaCalendarDayOfMonth* california_calendar_month_of_year_first_day_of_month (CaliforniaCalendarMonthOfYear* self) {
	CaliforniaCalendarDayOfMonth* result = NULL;
	CaliforniaCalendarDayOfMonth* _tmp0_ = NULL;
#line 59 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_MONTH_OF_YEAR (self), NULL);
#line 60 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	_tmp0_ = california_calendar_day_of_month_first ();
#line 60 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	result = _tmp0_;
#line 60 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	return result;
#line 478 "calendar-month-of-year.c"
}


/**
     * Returns the last {@link DayOfMonth} for the month in the associated year.
     */
CaliforniaCalendarDayOfMonth* california_calendar_month_of_year_last_day_of_month (CaliforniaCalendarMonthOfYear* self) {
	CaliforniaCalendarDayOfMonth* result = NULL;
	gint _tmp0_ = 0;
	CaliforniaCalendarDayOfMonth* _tmp1_ = NULL;
#line 66 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_MONTH_OF_YEAR (self), NULL);
#line 67 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	_tmp0_ = self->priv->_days_in_month;
#line 67 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	_tmp1_ = california_calendar_day_of_month_for_checked (_tmp0_);
#line 67 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	result = _tmp1_;
#line 67 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	return result;
#line 499 "calendar-month-of-year.c"
}


/**
     * Returns the day of the week for the {@link DayOfMonth} for the month in the associated
     * year.
     */
CaliforniaCalendarDate* california_calendar_month_of_year_date_for (CaliforniaCalendarMonthOfYear* self, CaliforniaCalendarDayOfMonth* day_of_month, GError** error) {
	CaliforniaCalendarDate* result = NULL;
	CaliforniaCalendarDate* _tmp0_ = NULL;
	CaliforniaCalendarDayOfMonth* _tmp1_ = NULL;
	CaliforniaCalendarMonth* _tmp2_ = NULL;
	CaliforniaCalendarYear* _tmp3_ = NULL;
	CaliforniaCalendarDate* _tmp4_ = NULL;
	CaliforniaCalendarDate* _tmp5_ = NULL;
	GError * _inner_error_ = NULL;
#line 74 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_MONTH_OF_YEAR (self), NULL);
#line 74 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_DAY_OF_MONTH (day_of_month), NULL);
#line 75 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	_tmp1_ = day_of_month;
#line 75 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	_tmp2_ = self->priv->_month;
#line 75 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	_tmp3_ = self->priv->_year;
#line 75 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	_tmp4_ = california_calendar_date_new (_tmp1_, _tmp2_, _tmp3_, &_inner_error_);
#line 75 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	_tmp0_ = _tmp4_;
#line 75 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	if (_inner_error_ != NULL) {
#line 75 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
		if (_inner_error_->domain == CALIFORNIA_CALENDAR_ERROR) {
#line 75 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
			g_propagate_error (error, _inner_error_);
#line 75 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
			return NULL;
#line 538 "calendar-month-of-year.c"
		} else {
#line 75 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 75 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
			g_clear_error (&_inner_error_);
#line 75 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
			return NULL;
#line 546 "calendar-month-of-year.c"
		}
	}
#line 75 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	_tmp5_ = _tmp0_;
#line 75 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	_tmp0_ = NULL;
#line 75 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	result = _tmp5_;
#line 75 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	_g_object_unref0 (_tmp0_);
#line 75 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	return result;
#line 559 "calendar-month-of-year.c"
}


/**
     * Returns a {@link MonthOfYear} adjusted a quantity of months from this one.
     *
     * Subtraction (adjusting to a past date) is acheived by using a negative quantity.
     */
CaliforniaCalendarMonthOfYear* california_calendar_month_of_year_adjust (CaliforniaCalendarMonthOfYear* self, gint quantity) {
	CaliforniaCalendarMonthOfYear* result = NULL;
	CaliforniaCalendarDate* _tmp0_ = NULL;
	CaliforniaCalendarDate* _tmp1_ = NULL;
	CaliforniaCalendarDate* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	CaliforniaCalendarDate* _tmp4_ = NULL;
	CaliforniaCalendarDate* _tmp5_ = NULL;
	CaliforniaCalendarMonthOfYear* _tmp6_ = NULL;
	CaliforniaCalendarMonthOfYear* _tmp7_ = NULL;
#line 83 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_MONTH_OF_YEAR (self), NULL);
#line 84 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	_tmp0_ = california_calendar_span_get_start_date (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_CALENDAR_TYPE_SPAN, CaliforniaCalendarSpan));
#line 84 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	_tmp1_ = _tmp0_;
#line 84 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	_tmp2_ = _tmp1_;
#line 84 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	_tmp3_ = quantity;
#line 84 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	_tmp4_ = california_calendar_date_adjust (_tmp2_, _tmp3_, CALIFORNIA_CALENDAR_DATE_UNIT_MONTH);
#line 84 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	_tmp5_ = _tmp4_;
#line 84 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	_tmp6_ = california_calendar_date_month_of_year (_tmp5_);
#line 84 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	_tmp7_ = _tmp6_;
#line 84 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	_g_object_unref0 (_tmp5_);
#line 84 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	_g_object_unref0 (_tmp2_);
#line 84 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	result = _tmp7_;
#line 84 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	return result;
#line 604 "calendar-month-of-year.c"
}


/**
     * Returns the number of months between the two {@link MonthOfYear}s.
     *
     * If the supplied MonthOfYear is earlier than this one, a negative value is returned.
     */
static gpointer _g_object_ref0 (gpointer self) {
#line 99 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	return self ? g_object_ref (self) : NULL;
#line 616 "calendar-month-of-year.c"
}


gint california_calendar_month_of_year_difference (CaliforniaCalendarMonthOfYear* self, CaliforniaCalendarMonthOfYear* other) {
	gint result = 0;
	gint compare = 0;
	CaliforniaCalendarMonthOfYear* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint count = 0;
	CaliforniaCalendarMonthOfYear* current = NULL;
	CaliforniaCalendarMonthOfYear* _tmp3_ = NULL;
#line 92 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_MONTH_OF_YEAR (self), 0);
#line 92 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_MONTH_OF_YEAR (other), 0);
#line 93 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	_tmp0_ = other;
#line 93 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	_tmp1_ = gee_comparable_compare_to (G_TYPE_CHECK_INSTANCE_CAST (self, GEE_TYPE_COMPARABLE, GeeComparable), G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, CALIFORNIA_CALENDAR_TYPE_DATE_SPAN, CaliforniaCalendarDateSpan));
#line 93 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	compare = _tmp1_;
#line 94 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	_tmp2_ = compare;
#line 94 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	if (_tmp2_ == 0) {
#line 95 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
		result = 0;
#line 95 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
		return result;
#line 647 "calendar-month-of-year.c"
	}
#line 98 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	count = 0;
#line 99 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	_tmp3_ = _g_object_ref0 (self);
#line 99 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	current = _tmp3_;
#line 655 "calendar-month-of-year.c"
	{
		gboolean _tmp4_ = FALSE;
#line 100 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
		_tmp4_ = TRUE;
#line 100 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
		while (TRUE) {
#line 662 "calendar-month-of-year.c"
			CaliforniaCalendarMonthOfYear* _tmp5_ = NULL;
			gint _tmp6_ = 0;
			CaliforniaCalendarMonthOfYear* _tmp11_ = NULL;
			gint _tmp12_ = 0;
			gint _tmp13_ = 0;
			gint _tmp14_ = 0;
			CaliforniaCalendarMonthOfYear* _tmp15_ = NULL;
			CaliforniaCalendarMonthOfYear* _tmp16_ = NULL;
			gboolean _tmp17_ = FALSE;
#line 100 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
			if (!_tmp4_) {
#line 674 "calendar-month-of-year.c"
			}
#line 100 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
			_tmp4_ = FALSE;
#line 101 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
			_tmp6_ = compare;
#line 101 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
			if (_tmp6_ > 0) {
#line 682 "calendar-month-of-year.c"
				CaliforniaCalendarMonthOfYear* _tmp7_ = NULL;
				CaliforniaCalendarMonthOfYear* _tmp8_ = NULL;
#line 101 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
				_tmp7_ = current;
#line 101 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
				_tmp8_ = california_calendar_month_of_year_previous (_tmp7_);
#line 101 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
				_g_object_unref0 (_tmp5_);
#line 101 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
				_tmp5_ = _tmp8_;
#line 693 "calendar-month-of-year.c"
			} else {
				CaliforniaCalendarMonthOfYear* _tmp9_ = NULL;
				CaliforniaCalendarMonthOfYear* _tmp10_ = NULL;
#line 101 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
				_tmp9_ = current;
#line 101 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
				_tmp10_ = california_calendar_month_of_year_next (_tmp9_);
#line 101 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
				_g_object_unref0 (_tmp5_);
#line 101 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
				_tmp5_ = _tmp10_;
#line 705 "calendar-month-of-year.c"
			}
#line 101 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
			_tmp11_ = _g_object_ref0 (_tmp5_);
#line 101 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
			_g_object_unref0 (current);
#line 101 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
			current = _tmp11_;
#line 102 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
			_tmp13_ = compare;
#line 102 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
			if (_tmp13_ > 0) {
#line 102 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
				_tmp12_ = -1;
#line 719 "calendar-month-of-year.c"
			} else {
#line 102 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
				_tmp12_ = 1;
#line 723 "calendar-month-of-year.c"
			}
#line 102 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
			_tmp14_ = count;
#line 102 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
			count = _tmp14_ + _tmp12_;
#line 104 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
			_tmp15_ = current;
#line 104 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
			_tmp16_ = other;
#line 104 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
			_tmp17_ = gee_hashable_equal_to (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, GEE_TYPE_HASHABLE, GeeHashable), G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, CALIFORNIA_CALENDAR_TYPE_DATE_SPAN, CaliforniaCalendarDateSpan));
#line 104 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
			if (_tmp17_) {
#line 105 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
				result = count;
#line 105 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
				_g_object_unref0 (_tmp5_);
#line 105 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
				_g_object_unref0 (current);
#line 105 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
				return result;
#line 745 "calendar-month-of-year.c"
			}
#line 100 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
			_g_object_unref0 (_tmp5_);
#line 749 "calendar-month-of-year.c"
		}
	}
#line 92 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	_g_object_unref0 (current);
#line 754 "calendar-month-of-year.c"
}


/**
     * Returns the chronological next {@link MonthOfYear}.
     */
CaliforniaCalendarMonthOfYear* california_calendar_month_of_year_next (CaliforniaCalendarMonthOfYear* self) {
	CaliforniaCalendarMonthOfYear* result = NULL;
	CaliforniaCalendarMonthOfYear* _tmp0_ = NULL;
#line 112 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_MONTH_OF_YEAR (self), NULL);
#line 113 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	_tmp0_ = california_calendar_month_of_year_adjust (self, 1);
#line 113 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	result = _tmp0_;
#line 113 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	return result;
#line 772 "calendar-month-of-year.c"
}


/**
     * Returns the chronological prior {@link MonthOfYear}.
     */
CaliforniaCalendarMonthOfYear* california_calendar_month_of_year_previous (CaliforniaCalendarMonthOfYear* self) {
	CaliforniaCalendarMonthOfYear* result = NULL;
	CaliforniaCalendarMonthOfYear* _tmp0_ = NULL;
#line 119 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_MONTH_OF_YEAR (self), NULL);
#line 120 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	_tmp0_ = california_calendar_month_of_year_adjust (self, -1);
#line 120 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	result = _tmp0_;
#line 120 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	return result;
#line 790 "calendar-month-of-year.c"
}


static gchar* california_calendar_month_of_year_real_to_string (CaliforniaBaseObject* base) {
	CaliforniaCalendarMonthOfYear * self;
	gchar* result = NULL;
	CaliforniaCalendarMonth* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	CaliforniaCalendarYear* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
#line 123 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, CALIFORNIA_CALENDAR_TYPE_MONTH_OF_YEAR, CaliforniaCalendarMonthOfYear);
#line 124 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	_tmp0_ = self->priv->_month;
#line 124 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	_tmp1_ = california_base_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, CALIFORNIA_TYPE_BASE_OBJECT, CaliforniaBaseObject));
#line 124 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	_tmp2_ = _tmp1_;
#line 124 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	_tmp3_ = self->priv->_year;
#line 124 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	_tmp4_ = california_base_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, CALIFORNIA_TYPE_BASE_OBJECT, CaliforniaBaseObject));
#line 124 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	_tmp5_ = _tmp4_;
#line 124 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	_tmp6_ = g_strdup_printf ("%s %s", _tmp2_, _tmp5_);
#line 124 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	_tmp7_ = _tmp6_;
#line 124 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	_g_free0 (_tmp5_);
#line 124 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	_g_free0 (_tmp2_);
#line 124 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	result = _tmp7_;
#line 124 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	return result;
#line 831 "calendar-month-of-year.c"
}


CaliforniaCalendarMonth* california_calendar_month_of_year_get_month (CaliforniaCalendarMonthOfYear* self) {
	CaliforniaCalendarMonth* result;
	CaliforniaCalendarMonth* _tmp0_ = NULL;
#line 17 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_MONTH_OF_YEAR (self), NULL);
#line 17 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	_tmp0_ = self->priv->_month;
#line 17 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	result = _tmp0_;
#line 17 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	return result;
#line 846 "calendar-month-of-year.c"
}


static void california_calendar_month_of_year_set_month (CaliforniaCalendarMonthOfYear* self, CaliforniaCalendarMonth* value) {
	CaliforniaCalendarMonth* _tmp0_ = NULL;
	CaliforniaCalendarMonth* _tmp1_ = NULL;
#line 17 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	g_return_if_fail (CALIFORNIA_CALENDAR_IS_MONTH_OF_YEAR (self));
#line 17 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	_tmp0_ = value;
#line 17 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 17 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	_g_object_unref0 (self->priv->_month);
#line 17 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	self->priv->_month = _tmp1_;
#line 17 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	g_object_notify ((GObject *) self, "month");
#line 865 "calendar-month-of-year.c"
}


CaliforniaCalendarYear* california_calendar_month_of_year_get_year (CaliforniaCalendarMonthOfYear* self) {
	CaliforniaCalendarYear* result;
	CaliforniaCalendarYear* _tmp0_ = NULL;
#line 22 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_MONTH_OF_YEAR (self), NULL);
#line 22 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	_tmp0_ = self->priv->_year;
#line 22 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	result = _tmp0_;
#line 22 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	return result;
#line 880 "calendar-month-of-year.c"
}


static void california_calendar_month_of_year_set_year (CaliforniaCalendarMonthOfYear* self, CaliforniaCalendarYear* value) {
	CaliforniaCalendarYear* _tmp0_ = NULL;
	CaliforniaCalendarYear* _tmp1_ = NULL;
#line 22 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	g_return_if_fail (CALIFORNIA_CALENDAR_IS_MONTH_OF_YEAR (self));
#line 22 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	_tmp0_ = value;
#line 22 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 22 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	_g_object_unref0 (self->priv->_year);
#line 22 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	self->priv->_year = _tmp1_;
#line 22 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	g_object_notify ((GObject *) self, "year");
#line 899 "calendar-month-of-year.c"
}


gint california_calendar_month_of_year_get_days_in_month (CaliforniaCalendarMonthOfYear* self) {
	gint result;
	gint _tmp0_ = 0;
#line 27 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_MONTH_OF_YEAR (self), 0);
#line 27 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	_tmp0_ = self->priv->_days_in_month;
#line 27 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	result = _tmp0_;
#line 27 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	return result;
#line 914 "calendar-month-of-year.c"
}


static void california_calendar_month_of_year_set_days_in_month (CaliforniaCalendarMonthOfYear* self, gint value) {
	gint _tmp0_ = 0;
#line 27 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	g_return_if_fail (CALIFORNIA_CALENDAR_IS_MONTH_OF_YEAR (self));
#line 27 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	_tmp0_ = value;
#line 27 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	self->priv->_days_in_month = _tmp0_;
#line 27 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	g_object_notify ((GObject *) self, "days-in-month");
#line 928 "calendar-month-of-year.c"
}


const gchar* california_calendar_month_of_year_get_full_name (CaliforniaCalendarMonthOfYear* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
#line 32 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_MONTH_OF_YEAR (self), NULL);
#line 32 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	_tmp0_ = self->priv->_full_name;
#line 32 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	result = _tmp0_;
#line 32 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	return result;
#line 943 "calendar-month-of-year.c"
}


static void california_calendar_month_of_year_set_full_name (CaliforniaCalendarMonthOfYear* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 32 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	g_return_if_fail (CALIFORNIA_CALENDAR_IS_MONTH_OF_YEAR (self));
#line 32 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	_tmp0_ = value;
#line 32 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 32 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	_g_free0 (self->priv->_full_name);
#line 32 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	self->priv->_full_name = _tmp1_;
#line 32 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	g_object_notify ((GObject *) self, "full-name");
#line 962 "calendar-month-of-year.c"
}


const gchar* california_calendar_month_of_year_get_abbrev_name (CaliforniaCalendarMonthOfYear* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
#line 37 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_MONTH_OF_YEAR (self), NULL);
#line 37 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	_tmp0_ = self->priv->_abbrev_name;
#line 37 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	result = _tmp0_;
#line 37 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	return result;
#line 977 "calendar-month-of-year.c"
}


static void california_calendar_month_of_year_set_abbrev_name (CaliforniaCalendarMonthOfYear* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 37 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	g_return_if_fail (CALIFORNIA_CALENDAR_IS_MONTH_OF_YEAR (self));
#line 37 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	_tmp0_ = value;
#line 37 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 37 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	_g_free0 (self->priv->_abbrev_name);
#line 37 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	self->priv->_abbrev_name = _tmp1_;
#line 37 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	g_object_notify ((GObject *) self, "abbrev-name");
#line 996 "calendar-month-of-year.c"
}


static void california_calendar_month_of_year_class_init (CaliforniaCalendarMonthOfYearClass * klass) {
#line 13 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	california_calendar_month_of_year_parent_class = g_type_class_peek_parent (klass);
#line 13 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	g_type_class_add_private (klass, sizeof (CaliforniaCalendarMonthOfYearPrivate));
#line 13 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	CALIFORNIA_BASE_OBJECT_CLASS (klass)->to_string = california_calendar_month_of_year_real_to_string;
#line 13 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_california_calendar_month_of_year_get_property;
#line 13 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_california_calendar_month_of_year_set_property;
#line 13 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	G_OBJECT_CLASS (klass)->finalize = california_calendar_month_of_year_finalize;
#line 1013 "calendar-month-of-year.c"
	/**
	     * The {@link Month} of the associated {@link Year}.
	     */
#line 13 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALIFORNIA_CALENDAR_MONTH_OF_YEAR_MONTH, g_param_spec_object ("month", "month", "month", CALIFORNIA_CALENDAR_TYPE_MONTH, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 1019 "calendar-month-of-year.c"
	/**
	     * The {@link Year}.
	     */
#line 13 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALIFORNIA_CALENDAR_MONTH_OF_YEAR_YEAR, g_param_spec_object ("year", "year", "year", CALIFORNIA_CALENDAR_TYPE_YEAR, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 1025 "calendar-month-of-year.c"
	/**
	     * The number of days in the month.
	     */
#line 13 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALIFORNIA_CALENDAR_MONTH_OF_YEAR_DAYS_IN_MONTH, g_param_spec_int ("days-in-month", "days-in-month", "days-in-month", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 1031 "calendar-month-of-year.c"
	/**
	     * Full name for user display.
	     */
#line 13 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALIFORNIA_CALENDAR_MONTH_OF_YEAR_FULL_NAME, g_param_spec_string ("full-name", "full-name", "full-name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 1037 "calendar-month-of-year.c"
	/**
	     * Abbreviated name for user display.
	     */
#line 13 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALIFORNIA_CALENDAR_MONTH_OF_YEAR_ABBREV_NAME, g_param_spec_string ("abbrev-name", "abbrev-name", "abbrev-name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 1043 "calendar-month-of-year.c"
}


static void california_calendar_month_of_year_instance_init (CaliforniaCalendarMonthOfYear * self) {
#line 13 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	self->priv = CALIFORNIA_CALENDAR_MONTH_OF_YEAR_GET_PRIVATE (self);
#line 1050 "calendar-month-of-year.c"
}


static void california_calendar_month_of_year_finalize (GObject* obj) {
	CaliforniaCalendarMonthOfYear * self;
#line 13 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CALIFORNIA_CALENDAR_TYPE_MONTH_OF_YEAR, CaliforniaCalendarMonthOfYear);
#line 17 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	_g_object_unref0 (self->priv->_month);
#line 22 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	_g_object_unref0 (self->priv->_year);
#line 32 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	_g_free0 (self->priv->_full_name);
#line 37 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	_g_free0 (self->priv->_abbrev_name);
#line 13 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	G_OBJECT_CLASS (california_calendar_month_of_year_parent_class)->finalize (obj);
#line 1068 "calendar-month-of-year.c"
}


/**
 * An immutable representation of a {@link Month} of a {@link Year}.
 */
GType california_calendar_month_of_year_get_type (void) {
	static volatile gsize california_calendar_month_of_year_type_id__volatile = 0;
	if (g_once_init_enter (&california_calendar_month_of_year_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (CaliforniaCalendarMonthOfYearClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) california_calendar_month_of_year_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CaliforniaCalendarMonthOfYear), 0, (GInstanceInitFunc) california_calendar_month_of_year_instance_init, NULL };
		GType california_calendar_month_of_year_type_id;
		california_calendar_month_of_year_type_id = g_type_register_static (CALIFORNIA_CALENDAR_TYPE_DATE_SPAN, "CaliforniaCalendarMonthOfYear", &g_define_type_info, 0);
		g_once_init_leave (&california_calendar_month_of_year_type_id__volatile, california_calendar_month_of_year_type_id);
	}
	return california_calendar_month_of_year_type_id__volatile;
}


static void _vala_california_calendar_month_of_year_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	CaliforniaCalendarMonthOfYear * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CALIFORNIA_CALENDAR_TYPE_MONTH_OF_YEAR, CaliforniaCalendarMonthOfYear);
#line 13 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	switch (property_id) {
#line 13 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
		case CALIFORNIA_CALENDAR_MONTH_OF_YEAR_MONTH:
#line 13 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
		g_value_set_object (value, california_calendar_month_of_year_get_month (self));
#line 13 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
		break;
#line 13 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
		case CALIFORNIA_CALENDAR_MONTH_OF_YEAR_YEAR:
#line 13 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
		g_value_set_object (value, california_calendar_month_of_year_get_year (self));
#line 13 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
		break;
#line 13 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
		case CALIFORNIA_CALENDAR_MONTH_OF_YEAR_DAYS_IN_MONTH:
#line 13 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
		g_value_set_int (value, california_calendar_month_of_year_get_days_in_month (self));
#line 13 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
		break;
#line 13 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
		case CALIFORNIA_CALENDAR_MONTH_OF_YEAR_FULL_NAME:
#line 13 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
		g_value_set_string (value, california_calendar_month_of_year_get_full_name (self));
#line 13 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
		break;
#line 13 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
		case CALIFORNIA_CALENDAR_MONTH_OF_YEAR_ABBREV_NAME:
#line 13 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
		g_value_set_string (value, california_calendar_month_of_year_get_abbrev_name (self));
#line 13 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
		break;
#line 1122 "calendar-month-of-year.c"
		default:
#line 13 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 13 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
		break;
#line 1128 "calendar-month-of-year.c"
	}
}


static void _vala_california_calendar_month_of_year_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	CaliforniaCalendarMonthOfYear * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CALIFORNIA_CALENDAR_TYPE_MONTH_OF_YEAR, CaliforniaCalendarMonthOfYear);
#line 13 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
	switch (property_id) {
#line 13 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
		case CALIFORNIA_CALENDAR_MONTH_OF_YEAR_MONTH:
#line 13 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
		california_calendar_month_of_year_set_month (self, g_value_get_object (value));
#line 13 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
		break;
#line 13 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
		case CALIFORNIA_CALENDAR_MONTH_OF_YEAR_YEAR:
#line 13 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
		california_calendar_month_of_year_set_year (self, g_value_get_object (value));
#line 13 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
		break;
#line 13 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
		case CALIFORNIA_CALENDAR_MONTH_OF_YEAR_DAYS_IN_MONTH:
#line 13 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
		california_calendar_month_of_year_set_days_in_month (self, g_value_get_int (value));
#line 13 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
		break;
#line 13 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
		case CALIFORNIA_CALENDAR_MONTH_OF_YEAR_FULL_NAME:
#line 13 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
		california_calendar_month_of_year_set_full_name (self, g_value_get_string (value));
#line 13 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
		break;
#line 13 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
		case CALIFORNIA_CALENDAR_MONTH_OF_YEAR_ABBREV_NAME:
#line 13 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
		california_calendar_month_of_year_set_abbrev_name (self, g_value_get_string (value));
#line 13 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
		break;
#line 1168 "calendar-month-of-year.c"
		default:
#line 13 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 13 "/home/jim/git/california/src/calendar/calendar-month-of-year.vala"
		break;
#line 1174 "calendar-month-of-year.c"
	}
}



