/*
 * Java-Gnome Bindings Library
*
* Copyright 1998-2005 the Java-Gnome Team, all rights reserved.
*
* The Java-Gnome bindings library is free software distributed under
* the terms of the GNU Library General Public License version 2.
*/

package org.freedesktop.cairo;

import org.gnu.glib.Handle;

/**
 * The TextExtents stores the extents of a single glyph or a 
 * string of glyphs in user-space coordinates. Because text
 * extents are in user-space coordinates, they don't scale along with
 * the current transformation matrix.
 */
public class TextExtents extends CairoObject {

	TextExtents(Handle hndl) {
		super(hndl);
	}
	
	public double getXBearing() {
		return get_x_bearing(getHandle());
	}
	
	public double getYBearing(){
		return get_y_bearning(getHandle());
	}
	
	public double getWidth() {
		return get_width(getHandle());
	}
	
	public double getHeight() {
		return get_height(getHandle());
	}
	
	public double getXAdvance() {
		return get_x_advance(getHandle());
	}
	
	public double getYAdvance() {
		return get_y_advance(getHandle());
	}
	
	protected void finalize() throws Throwable {
		try {
			free(getHandle());
		} 
		finally {
			super.finalize();
		}
	}

	/*
	 * Native calls
	 */
	native static final private double get_x_bearing(Handle obj);
	native static final private double get_y_bearning(Handle obj);
	native static final private double get_width(Handle obj);
	native static final private double get_height(Handle obj);
	native static final private double get_x_advance(Handle obj);
	native static final private double get_y_advance(Handle obj);
	native static final private void free(Handle obj);
}
