/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
#include <config.h>
#include <gnome.h>
#include <libgnorba/gnorba.h>
#include <bonobo/Bonobo.h>
#include <bonobo/bonobo.h>

CORBA_Environment ev;
CORBA_ORB orb;

static BonoboView *
view_factory (BonoboEmbeddable *bonobo_object, const Bonobo_ViewFrame view_frame, void *data)
{
	BonoboView *view;
	GtkWidget *widget;
	

	widget = gtk_hbox_new (0, 0);
	gtk_container_add (GTK_CONTAINER (widget), gtk_entry_new ());
	gtk_widget_show_all (widget);
	view = bonobo_view_new (widget);
	
	return view;
}

static BonoboObject *
bonobo_object_factory (BonoboEmbeddableFactory *factory, void *closure)
{
	BonoboEmbeddable *server;
	
	server =  bonobo_embeddable_new (view_factory, NULL);
	if (server == NULL)
		g_error ("Can not create bonobo_embeddable");

	return (BonoboObject*) server;
}

static void
init_server_factory (void)
{
	bonobo_embeddable_factory_new (
		"Test_server_factory", bonobo_object_factory, NULL);
}

int
main (int argc, char *argv [])
{
	CORBA_exception_init (&ev);

	gnome_CORBA_init_with_popt_table ("MyServer", "1.0", &argc, argv, NULL, 0, NULL, GNORBA_INIT_SERVER_FUNC, &ev);
	orb = gnome_CORBA_ORB ();
	
	if (bonobo_init (orb, NULL, NULL) == FALSE)
		g_error ("Can not bonobo_init\n");

	init_server_factory ();
	bonobo_main ();
	CORBA_exception_free (&ev);

	return 0;
}

