#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/mman.h>
#include <string.h>
#include <sys/time.h>
      
#include "vefs.h"
#include "comp.h"
#include "simple.h"

/*
static void
spi(EFSFile *efile)
{
	SimpleDir *dir = (SimpleDir *)efile;
	SimpleFile *file = (SimpleFile *)((COMPFile *)efile)->of;

	if (!efile) {
	  printf("ERROR: SPI NULL\n");
	}

	if (efile->mode == EFS_DIR)
		printf("DIR %u\n",dir->inode);
	else
		printf("FILE %u\n",file->inode);
}
*/

static gint
create_test(gchar *dname)
{
	gchar buf[1024];
	EFSDir *root;

	printf("Starting Create Test for driver %s\n",dname);

	system("rm -rf /tmp/testdb");

	sprintf(buf,"%s:/tmp/testdb",dname);
	if (!(root = efs_open(buf, EFS_CREATE, 0644))) {
		printf("EFS OPEN FAILED!\n");
		return FALSE;
	}

	/*
	sprintf(buf,"%s:/tmp/testdb",dname);
	if ((root1 = efs_open(buf, EFS_CREATE, 0644))) {
		printf("File lock FAILED!\n");
		return FALSE;
	}
	*/

	if (efs_commit(root)) {
		printf("EFS COMMIT FAILED!\n");
		return FALSE;
	}

	if (efs_close (root)) {
		printf("EFS CLOSE FAILED!\n");
		return FALSE;
	}

	printf("-> Test is OK\n");
	return TRUE;
}

static gint
dir_test(gchar *dname)
{
	gchar buf[1024];
	EFSDir *root,*dir;
	gint i,j,res;

	printf("Starting Directory Test for driver %s\n",dname);

	system("rm -rf /tmp/testdb");

	sprintf(buf,"%s:/tmp/testdb",dname);
	if (!(root = efs_open(buf, EFS_CREATE, 0644))) {
		printf("EFS OPEN FAILED!\n");
		return FALSE;
	}

	for (i=0; i<2; i++) {
		sprintf(buf,"/test%d",i);
		dir = efs_dir_open (root, buf, EFS_CREATE);
		if (!dir) {
			printf("Create Dir 1 failed!\n");
			return FALSE;
		}

		sprintf(buf,"/test%d/subdir1",i);
		dir = efs_dir_open (root, buf, EFS_CREATE);
		if (!dir) {
			printf("Create Dir 2 failed!\n");
			return FALSE;
		}

		for (j=0;j<200;j++) {
			sprintf(buf,"/test%d/subdir1/s%d",i,j);
			dir = efs_dir_open (root, buf, EFS_CREATE);
			if (!dir) {
				printf("Create Dir 3 (%d) failed!\n",j);
				return FALSE;
			}
			if (efs_dir_close(dir)) {
				printf("Close Dir failed!\n");
				return FALSE;
			}
		}

		res = efs_erase (root, "/test0/subdir1/subdir0");
		if (res != -1) {
			printf("Name lookup 1 failed!\n");
			return FALSE;
		}

		sprintf(buf,"/test%d/subdir2",i);
		dir = efs_dir_open (root, buf, 0);
		if (dir) {
			printf("Name lookup 2 failed!\n");
			return FALSE;
		}
	}

	for (j=0;j<200;j++) {
		sprintf(buf,"/test0/subdir1/s%d",j);
		res = efs_erase (root, buf);
		if (res != 0) {
			printf("Erase failed!\n");
			return FALSE;
		}
	}
		
	if (efs_commit(root)) {
		printf("EFS COMMIT FAILED!\n");
		return FALSE;
	}

	if (efs_close (root)) {
		printf("EFS CLOSE FAILED!\n");
		return FALSE;
	}

	printf("-> Test is OK\n");
	return TRUE;
}

static gint
file_test(gchar *dname)
{
	gchar buf[1024],*buf1;
	EFSDir *root;
	EFSFile *file;
	gint res,l,i;

	printf("Starting File Test for driver %s\n",dname);

	system("rm -rf /tmp/testdb");

	sprintf(buf,"%s:/tmp/testdb",dname);
	if (!(root = efs_open(buf, EFS_CREATE, 0644))) {
		printf("EFS OPEN FAILED!\n");
		return FALSE;
	}

	file = efs_file_open (root, "/testfile" , EFS_CREATE);
	if (!file) {
		printf("create file 1 failed!\n");
		return FALSE;
	}
	if (efs_file_close (file)) {
		printf("close file 1 failed!\n");
		return FALSE;
	}


	file = efs_file_open (root, "/testfile" , EFS_READ);
	if (!file) {
		printf("open file failed!\n");
		return FALSE;
	}
	if (efs_file_close (file)) {
		printf("close file 2 failed!\n");
		return FALSE;
	}

	file = efs_file_open (root, "/testfile" , EFS_CREATE|EFS_EXCL);
	if (file) {
		printf("open file excl 1 failed!\n");
		return FALSE;
	}
	
	res = efs_erase (root, "/testfile");
	if (res) {
		printf("erase file failed!\n");
		return FALSE;
	}

	res = efs_erase (root, "/testfile");
	if (!res) {
		printf("name lookup 1 failed!\n");
		return FALSE;
	}
			
	file = efs_file_open (root, "/testfile" , EFS_CREATE|EFS_EXCL);
	if (!file) {
		printf("open file excl 2 failed!\n");
		return FALSE;
	}
	
	res = efs_rename (root, "/testfile", "/newfile");
	if (res) {
		printf("rename file failed!\n");
		return FALSE;
	}

	file = efs_file_open (root, "/newfile" , EFS_READ);
	if (!file) {
		printf("name lookup 2 failed!\n");
		return FALSE;
	}
	if (efs_file_close (file)) {
		printf("close file 3 failed!\n");
		return FALSE;
	}

	file = efs_file_open (root, "/testwrite" , EFS_CREATE);
	if (!file) {
		printf("create file 2 failed!\n");
		return FALSE;
	}
	
	buf1 = "0123456789 Dies ist ein Test 9876543210";
	l = strlen(buf1);

	for (i=0;i<(10000/l);i++) {
		if (efs_file_write (file, buf1, l) != l) {
			printf("file write failed!\n");
			return FALSE;
		}
	}

	if (efs_file_seek (file, 0, SEEK_SET) != 0) {
		printf("file seek failed!\n");
		return FALSE;
	}

	for (i=0;i<(10000/l);i++) {
		if (efs_file_read (file, buf, l) != l) {
			printf("file read 1 failed!\n");
			return FALSE;
		}
		if (strncmp(buf,buf1,l)) {
			printf("file read 2 failed!\n");
			return FALSE;
		}
	}

	if (efs_file_read (file, buf, l) != 0) {
		printf("missing oef!\n");
		return FALSE;
	}

	if (efs_file_trunc (file, 512)) {
		printf("truncate file failed!\n");
		return FALSE;
	}

	if (efs_file_close (file)) {
		printf("close file 4 failed!\n");
		return FALSE;
	}

	if (efs_commit(root)) {
		printf("EFS COMMIT FAILED!\n");
		return FALSE;
	}

	if (efs_close (root)) {
		printf("EFS CLOSE FAILED!\n");
		return FALSE;
	}

	printf("-> Test is OK\n");
	return TRUE;
}

int
main()
{
	gint dnum;
	gchar *dname;
	struct timeval tv,tv1;
	struct timezone tz;


	for (dnum=0;efs_driver_list[dnum];dnum++) {
		dname = strdup(efs_driver_list[dnum]->drivername);

		gettimeofday(&tv,&tz);

		if (!create_test(dname)) exit(-1);
		if (!dir_test(dname)) exit(-1);
		if (!file_test(dname)) exit(-1);

		gettimeofday(&tv1,&tz);

		printf("Time for %s driver tests: %.3fsec\n",dname,
		       ((tv1.tv_sec-tv.tv_sec)*1000000+
		       (tv1.tv_usec-tv.tv_usec))/1000000.0);

	}

	exit(0);
	
/*
  {
	EFSDir *root;
	gint i,j;

	system("rm -rf /tmp/testdb1");

	{
		EFSDir *dir;

		if (!(root = efs_open("fsys:/tmp/testdb1", EFS_CREATE, 
				      0644))) {
			printf("EFS OPEN FAILED!\n");
			exit(0);
		}
		printf("EFS OPEN OK!\n");

		dir = efs_dir_open (root, "testdir", EFS_CREATE);
		
		efs_dir_close(dir);

		efs_close (root);
	}


	system("rm -rf /tmp/testdb");

	if (!(root = efs_open("simple:/tmp/testdb", EFS_CREATE, 0644))) {
		printf("EFS OPEN FAILED!\n");
		exit(0);
	}
	printf("EFS OPEN OK!\n");

	{
		EFSDir *dir;
		gchar buf[256];
		gint res;

		printf("\nDIR TEST\n\n");
		
		for (i=0; i<2; i++) {
			sprintf(buf,"/test%d",i);
			dir = efs_dir_open (root, buf, EFS_CREATE);
			spi(dir);

			sprintf(buf,"/test%d/subdir1",i);
			dir = efs_dir_open (root, buf, EFS_CREATE);
			spi(dir);

			for (j=0;j<200;j++) {
				sprintf(buf,"/test%d/subdir1/s%d",i,j);
				dir = efs_dir_open (root, buf, EFS_CREATE);
				spi(dir);
			}

			res = efs_erase (root, "/test0/subdir1/subdir0");
			printf("RES %d\n",res);

			sprintf(buf,"/test%d/subdir2",i);
			dir = efs_dir_open (root, buf, 0);
			printf("DIR %p\n",dir);
			
							
			
		}

		for (j=0;j<200;j++) {
			sprintf(buf,"/test0/subdir1/s%d",j);
			res = efs_erase (root, buf);
			printf("RES %d\n",res);
		}
		
		
	}
	
	
	{
		EFSFile *file;
		gchar *buf;
		gint l;

		printf("\nFILE WRITE TEST\n\n");

		file = efs_file_open (root, "/testwrite" , EFS_CREATE);
		spi(file);

		buf = "0123456789 Dies ist ein Test 9876543210";
		l = strlen(buf);

		for (i=0;i<(10000/l);i++) {
			printf("WRITE %d\n",efs_file_write (file, buf, l));
		}

		efs_file_trunc (file, 512);
		efs_file_close (file);

	}
	
	
	{
		EFSFile *file;
		gint res;

		printf("\nFILE TEST\n\n");
		
		file = efs_file_open (root, "/testfile" , EFS_CREATE);
		spi(file);
		efs_file_close (file);

		file = efs_file_open (root, "/testfile" , EFS_READ);
		spi(file);
		efs_file_close (file);

		file = efs_file_open (root, "/testfile" , EFS_CREATE|EFS_EXCL);
		printf("FILE %p\n",file);


		res = efs_erase (root, "/testfile");
		printf("RES %d\n", res);

		res = efs_erase (root, "/testfile");
		printf("RES %d\n", res);
			

		file = efs_file_open (root, "/testfile" , EFS_CREATE|EFS_EXCL);
		spi(file);

		res = efs_rename (root, "/testfile", "/newfile");
		printf("RES %d\n", res);

		file = efs_file_open (root, "/newfile" , EFS_READ);
		spi(file);
		efs_file_close (file);
		
	}
	
	
	efs_commit(root);
	efs_close(root);
	exit(0);
	}
	*/
}






