/*
 * directory routines
 *
 * Author:
 *   Dietmar Maurer (dm@vlsivie.tuwien.ac.at)
 *
 *
 */

#include "vefs.h"

EFSDir*
efs_dir_open (EFSDir *dir, const char *path, gint flags)
{
	EFSDriver *d;

	g_return_val_if_fail(dir != NULL, NULL);
	g_return_val_if_fail(path != NULL, NULL);

	d = dir->efs->driver;

	return d->fops->dir_open (dir, path, flags);
}

gint         
efs_dir_close (EFSDir *dir)
{
	EFSDriver *d;

	g_return_val_if_fail(dir != NULL, -1);

	d = dir->efs->driver;

	return d->fops->dir_close (dir);
}

gint32       
efs_dir_seek (EFSDir *dir, gint32 offset)
{
	EFSDriver *d;

	g_return_val_if_fail(dir != NULL, -1);

	d = dir->efs->driver;

	return d->fops->dir_seek (dir, offset);
}

EFSDirEntry*
efs_dir_read (EFSDir *dir)
{
	EFSDriver *d;

	g_return_val_if_fail(dir != NULL, NULL);

	d = dir->efs->driver;

	return d->fops->dir_read (dir);
}
