#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/mman.h>

#include "vefs.h"
#include "simple.h"

static void
spi(EFSFile *efile)
{
	SimpleFile *file = (SimpleFile *)efile;

	if (efile->mode == EFS_DIR)
		printf("DIR %d\n",file->inode);
	else
		printf("FILE %d\n",file->inode);
}

int
main()
{
	EFSDir *root;
	gint i,j;

	system("rm -rf /tmp/testdb1");

	{
		EFSDir *dir;

		if (!(root = efs_open("fsys:/tmp/testdb1", EFS_CREATE, 
				      0644))) {
			printf("EFS OPEN FAILED!\n");
			exit(0);
		}
		printf("EFS OPEN OK!\n");

		dir = efs_dir_open (root, "testdir", EFS_CREATE);
		
		efs_dir_close(dir);

		efs_close (root);
	}

	system("rm /tmp/testdb");

	if (!(root = efs_open("simple:/tmp/testdb", EFS_CREATE, 0644))) {
		printf("EFS OPEN FAILED!\n");
		exit(0);
	}
	printf("EFS OPEN OK!\n");

	{
		EFSDir *dir;
		gchar buf[256];
		gint res;

		printf("\nDIR TEST\n\n");
		
		for (i=0; i<2; i++) {
			sprintf(buf,"/test%d",i);
			dir = efs_dir_open (root, buf, EFS_CREATE);
			spi(dir);

			sprintf(buf,"/test%d/subdir1",i);
			dir = efs_dir_open (root, buf, EFS_CREATE);
			spi(dir);

			for (j=0;j<200;j++) {
				sprintf(buf,"/test%d/subdir1/s%d",i,j);
				dir = efs_dir_open (root, buf, EFS_CREATE);
				spi(dir);
			}

			res = efs_erase (root, "/test0/subdir1/subdir0");
			printf("RES %d\n",res);

			sprintf(buf,"/test%d/subdir2",i);
			dir = efs_dir_open (root, buf, 0);
			printf("DIR %p\n",dir);
			
							
			
		}

		for (j=0;j<200;j++) {
			sprintf(buf,"/test0/subdir1/s%d",j);
			res = efs_erase (root, buf);
			printf("RES %d\n",res);
		}
		
		
	}
	

	
	{
		EFSFile *file;
		gchar *buf;
		gint l;

		printf("\nFILE WRITE TEST\n\n");

		file = efs_file_open (root, "/testwrite" , EFS_CREATE);
		spi(file);

		buf = "0123456789 Dies ist ein Test 9876543210";
		l = strlen(buf);

		for (i=0;i<(10000/l);i++) {
			printf("WRITE %d\n",efs_file_write (file, buf, l));
		}

		efs_file_trunc (file, 512);
		efs_file_close (file);

	}
	
	
	{
		EFSFile *file;
		gint res;

		printf("\nFILE TEST\n\n");
		
		file = efs_file_open (root, "/testfile" , EFS_CREATE);
		spi(file);
		efs_file_close (file);

		file = efs_file_open (root, "/testfile" , EFS_READ);
		spi(file);
		efs_file_close (file);

		file = efs_file_open (root, "/testfile" , EFS_CREATE|EFS_EXCL);
		printf("FILE %p\n",file);


		res = efs_erase (root, "/testfile");
		printf("RES %d\n", res);

		res = efs_erase (root, "/testfile");
		printf("RES %d\n", res);
			

		file = efs_file_open (root, "/testfile" , EFS_CREATE|EFS_EXCL);
		spi(file);

		res = efs_rename (root, "/testfile", "/newfile");
		printf("RES %d\n", res);

		file = efs_file_open (root, "/newfile" , EFS_READ);
		spi(file);
		efs_file_close (file);
		
	}
	
	efs_commit(root);
	efs_close(root);
	exit(0);
}






