
#include <config.h>
#include <gnome.h>
#include <bonobo/gnome-bonobo.h>

static void
button_clicked_cb (GtkWidget *button, gpointer data)
{
	GtkWidget *box = GTK_WIDGET (data);
	GnomeBonoboWidget *bw;

	bw = gnome_bonobo_widget_new ("embeddable:paint-component-simple", NULL);

	gtk_box_pack_start (GTK_BOX (box), GTK_WIDGET (bw), TRUE, TRUE, 0);

	gtk_widget_show_all (GTK_WIDGET (box));
}

int
main (int argc, char **argv)
{
	GtkWidget *app;
	CORBA_Environment ev;
	GtkWidget *box;
	GtkWidget *button;

	CORBA_exception_init (&ev);

	gnome_CORBA_init ("MyShell", "1.0", &argc, argv, 0, &ev);

	if (bonobo_init (gnome_CORBA_ORB (), NULL, NULL) == FALSE)
		g_error ("Cannot bonobo_init");

	app = gnome_app_new ("test-bw", "Test Bonobo Widget");

        gtk_window_set_default_size(GTK_WINDOW(app), 640, 480);
        gtk_window_set_policy(GTK_WINDOW(app), TRUE, TRUE, FALSE);

	box = gtk_vbox_new (FALSE, 5);

	button = gtk_button_new_with_label ("Add component");

	gtk_signal_connect (GTK_OBJECT (button), "clicked",
			    button_clicked_cb, box);

	gtk_box_pack_start (GTK_BOX (box), button, FALSE, FALSE, 0);

	gnome_app_set_contents (GNOME_APP (app), box);

	gtk_widget_show_all (app);

	bonobo_main ();

	return 0;
}
