/**
 * bonobo-selector.c: A control containing a BonoboSelector.
 *
 * Author:
 *     Michael Meeks (michael@helixcode.com)
 *
 * Copyright (C) 2000, Helix Code, Inc.
 */

/*
 * FIXME, vital features:
 *
 * ItemContainer - OAFIID:SelectorFactory!IDL:Bonobo/Control:1.0
 * Attach lots of lovely properties, perhaps an event source for double clicks
 */

#include <config.h>
#include <gnome.h>
#include <liboaf/liboaf.h>
#include <bonobo/bonobo.h>

static int running_objects = 0;
static BonoboGenericFactory *factory = NULL;

static void
bonobo_object_destroy_cb (BonoboObject *bonobo_object,
			  gpointer      dummy)
{
	running_objects--;
	if (running_objects > 0)
		return;

	bonobo_object_unref (BONOBO_OBJECT (factory));
	gtk_main_quit ();
}

static BonoboObject *
generic_factory (BonoboGenericFactory *this,  void *data)
{
	BonoboControl *bonobo_object = NULL;
	GtkWidget     *widget;
	const gchar   *query[] = { "IDL:Bonobo/Control:1.0", NULL };

	widget = bonobo_selector_widget_new ();
	bonobo_selector_widget_set_interfaces (
		BONOBO_SELECTOR_WIDGET (widget), query);

	bonobo_object = bonobo_control_new (widget);

	return BONOBO_OBJECT (bonobo_object);
}

int
main (int argc, char **argv)
{
	CORBA_Environment ev;
	CORBA_ORB         orb;

	CORBA_exception_init (&ev);

        gnome_init_with_popt_table ("bonobo-selector", VERSION,
				    argc, argv, oaf_popt_options, 0, NULL); 

	orb = oaf_init (argc, argv);

	if (!bonobo_init (orb, NULL, NULL))
		g_error (_("I could not initialize Bonobo"));

	factory = bonobo_generic_factory_new (
		"OAFIID:Bonobo_Selector_ControlFactory",
		generic_factory, NULL);

	bonobo_main ();

	CORBA_exception_free (&ev);

	return 0;
}
