#include "config.h"
#include <gnome.h>
#include <bonobo.h>
#include <liboaf/liboaf.h>

#include <gnome-xml/tree.h>
#include <gnome-xml/parser.h>

poptContext ctx;

static void
find_strings (FILE *f, xmlNode *node)
{
	xmlNode *l;
	xmlAttr *prop, *old_props;

	if (!node)
		return;

	old_props = node->properties;
	node->properties = NULL;

	for (prop = old_props; prop; prop = prop->next) {
		xmlChar *value;

		value = xmlNodeListGetString (NULL, prop->val, 1);

		/* Find translatable properties */
		if (value && prop->name && prop->name [0] == '_')
			fprintf (f, "gchar *s = N_(\"%s\");\n", value);

		if (value)
                        free (value);
	}

	for (l = node->childs; l; l = l->next)
		find_strings (f, l);
}

static void
seek_translatable_strings (FILE *f, xmlDoc *doc, const char *fname)
{
	if (!doc || !doc->root || !f)
		return;

	fprintf (f,
		 "/*\n"
		 " *  This file is autogenerated from %s, do not edit\n"
		 " *\n"
		 " *  This file contains translatable strings generated by\n"
		 " * bonobo-ui-extract. Add this file to your project's\n"
		 " * POTFILES.in. DO NOT compile it as part of your application.\n"
		 " */\n"
		 "\n", fname);

	find_strings (f, doc->root);
}

int
main (int argc, char **argv)
{
	const char **input_files;

	gnome_init_with_popt_table ("bonobo-ui-extract", VERSION,
				    argc, argv, oaf_popt_options, 0, &ctx);

	if (ctx)
		input_files = poptGetArgs (ctx);
	else
		input_files = NULL;

	if (input_files && input_files [0]) {
		xmlDoc  *doc;
		
		doc = xmlParseFile (input_files [0]);

		if (doc)
			seek_translatable_strings (stdout, doc, input_files [0]);
		xmlFreeDoc (doc);
	}

	if (ctx)
		poptFreeContext (ctx);

	return 0;
}
