/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
#ifndef _BONOBO_SIZEABLE_H_
#define _BONOBO_SIZEABLE_H_

#include <bonobo/bonobo-object.h>

BEGIN_GNOME_DECLS

#define BONOBO_SIZEABLE_TYPE        (bonobo_sizeable_get_type ())
#define BONOBO_SIZEABLE(o)          (GTK_CHECK_CAST ((o), BONOBO_SIZEABLE_TYPE, BonoboSizeable))
#define BONOBO_SIZEABLE_CLASS(k)    (GTK_CHECK_CLASS_CAST((k), BONOBO_SIZEABLE_TYPE, BonoboSizeableClass))
#define BONOBO_IS_SIZEABLE(o)       (GTK_CHECK_TYPE ((o), BONOBO_SIZEABLE_TYPE))
#define BONOBO_IS_SIZEABLE_CLASS(k) (GTK_CHECK_CLASS_TYPE ((k), BONOBO_SIZEABLE_TYPE))

typedef struct {
        BonoboObject object;

	CORBA_long   default_width;
	CORBA_long   default_height;

	CORBA_long   window_width;
	CORBA_long   window_height;

	gpointer     priv;
} BonoboSizeable;

typedef struct {
	BonoboObjectClass    parent;

	void                (*get_default_size) (BonoboSizeable *sizeable,
						 CORBA_long     *width,
						 CORBA_long     *height);
	void                (*set_window_size)  (BonoboSizeable *sizeable,
						 CORBA_long      width,
						 CORBA_long      height);
} BonoboSizeableClass;

POA_Bonobo_Sizeable__epv *bonobo_sizeable_get_epv  (void);

GtkType                   bonobo_sizeable_get_type (void);
Bonobo_Sizeable           bonobo_sizeable_corba_object_create (BonoboObject   *object);
BonoboSizeable           *bonobo_sizeable_construct           (BonoboSizeable *sizeable,
							       Bonobo_Sizeable corba_sizeable);
BonoboSizeable           *bonobo_sizeable_new                 (void);
void                      bonobo_sizeable_set_default_size    (BonoboSizeable *sizeable,
							       CORBA_long      width,
							       CORBA_long      height);
void                      bonobo_sizeable_get_window_size     (BonoboSizeable *sizeable,
							       CORBA_long     *width,
							       CORBA_long     *height);


END_GNOME_DECLS

#endif /* _BONOBO_SIZEABLE_H_ */

