/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * bonobo-sizeable: Handling for arbitrairly sizeable controls
 *
 * Author:
 *     Michael Meeks (michael@helixcode.com)
 *
 * Copyright 2000 Helix Code, Inc.
 */
#include <config.h>
#include <bonobo/bonobo-sizeable.h>

#undef SIZEABLE_DEBUG

static BonoboObjectClass   *bonobo_sizeable_parent_class;
static BonoboSizeableClass *bonobo_sizeable_class;

POA_Bonobo_Sizeable__vepv bonobo_sizeable_vepv;

#define CLASS(o) BONOBO_SIZEABLE_CLASS(GTK_OBJECT(o)->klass)

static inline BonoboSizeable *
bonobo_sizeable_from_servant (PortableServer_Servant _servant)
{
	if (!BONOBO_IS_SIZEABLE (bonobo_object_from_servant (_servant)))
		return NULL;
	else
		return BONOBO_SIZEABLE (bonobo_object_from_servant (_servant));
}

static void
impl_get_default_size (PortableServer_Servant _servant,
		       CORBA_long            *width,
		       CORBA_long            *height,
		       CORBA_Environment     *ev)
{
	BonoboSizeable *sizeable;

	sizeable = bonobo_sizeable_from_servant (_servant);
	g_return_if_fail (sizeable != NULL);

	if (CLASS(sizeable)->get_default_size)
		CLASS(sizeable)->get_default_size (
			sizeable,
			&sizeable->default_width,
			&sizeable->default_height);

	*width  = sizeable->default_width;
	*height = sizeable->default_height;
}

void
bonobo_sizeable_set_default_size (BonoboSizeable *sizeable,
				  CORBA_long      width,
				  CORBA_long      height)
{
	sizeable->default_width  = width;
	sizeable->default_height = height;
}

static void
impl_set_window_size (PortableServer_Servant _servant,
		      const CORBA_long       width,
		      const CORBA_long       height,
		      CORBA_Environment     *ev)
{
	BonoboSizeable *sizeable;

	sizeable = bonobo_sizeable_from_servant (_servant);
	g_return_if_fail (sizeable != NULL);

	sizeable->window_width  = width;
	sizeable->window_height = height;
	if (CLASS (sizeable)->get_default_size)
		CLASS (sizeable)->set_window_size (
			sizeable,
			sizeable->window_width,
			sizeable->window_height);
}

void
bonobo_sizeable_get_window_size (BonoboSizeable *sizeable,
				 CORBA_long     *width,
				 CORBA_long     *height)
{
	*width  = sizeable->window_width;
	*height = sizeable->window_height;
}

/**
 * bonobo_sizeable_get_epv:
 */
POA_Bonobo_Sizeable__epv *
bonobo_sizeable_get_epv (void)
{
	POA_Bonobo_Sizeable__epv *epv;

	epv = g_new0 (POA_Bonobo_Sizeable__epv, 1);

	epv->get_default_size = impl_get_default_size;
	epv->set_window_size  = impl_set_window_size;

	return epv;
}

static void
init_sizeable_corba_class (void)
{
	/* The VEPV */
	bonobo_sizeable_vepv.Bonobo_Unknown_epv  = bonobo_object_get_epv ();
	bonobo_sizeable_vepv.Bonobo_Sizeable_epv = bonobo_sizeable_get_epv ();
}

static void
bonobo_sizeable_class_init (BonoboSizeableClass *klass)
{
	bonobo_sizeable_parent_class = gtk_type_class (bonobo_object_get_type ());
	bonobo_sizeable_class = klass;

	init_sizeable_corba_class ();
}

static void
bonobo_sizeable_init (BonoboSizeable *sizeable)
{
	sizeable->window_width  = -1;
	sizeable->window_height = -1;
	sizeable->default_width  = -1;
	sizeable->default_height = -1;
}

/**
 * bonobo_sizeable_get_type:
 *
 * Returns: the GtkType for a BonoboSizeable object.
 */
GtkType
bonobo_sizeable_get_type (void)
{
	static GtkType type = 0;

	if (!type) {
		GtkTypeInfo info = {
			"BonoboSizeable",
			sizeof (BonoboSizeable),
			sizeof (BonoboSizeableClass),
			(GtkClassInitFunc) bonobo_sizeable_class_init,
			(GtkObjectInitFunc) bonobo_sizeable_init,
			NULL, /* reserved 1 */
			NULL, /* reserved 2 */
			(GtkClassInitFunc) NULL
		};

		type = gtk_type_unique (bonobo_object_get_type (), &info);
	}

	return type;
}

Bonobo_Sizeable
bonobo_sizeable_corba_object_create (BonoboObject *object)
{
	POA_Bonobo_Sizeable *servant;
	CORBA_Environment ev;

	servant = (POA_Bonobo_Sizeable *) g_new0 (BonoboObjectServant, 1);
	servant->vepv = &bonobo_sizeable_vepv;

	CORBA_exception_init (&ev);

	POA_Bonobo_Sizeable__init ((PortableServer_Servant) servant, &ev);
	if (ev._major != CORBA_NO_EXCEPTION){
                g_free (servant);
		CORBA_exception_free (&ev);
                return CORBA_OBJECT_NIL;
        }

	CORBA_exception_free (&ev);
	return (Bonobo_Sizeable) bonobo_object_activate_servant (object, servant);
}

BonoboSizeable *
bonobo_sizeable_construct (BonoboSizeable         *p,
			   Bonobo_Sizeable         corba_p)
{
	return BONOBO_SIZEABLE (
		bonobo_object_construct (BONOBO_OBJECT (p), corba_p));
}

/**
 * bonobo_sizeable_new:
 * 
 * Create a new bonobo-sizeable implementing BonoboObject
 * interface.
 * 
 * Return value: 
 **/
BonoboSizeable *
bonobo_sizeable_new (void)
{
	BonoboSizeable  *p;
	Bonobo_Sizeable  corba_p;

	p = gtk_type_new (bonobo_sizeable_get_type ());
	g_return_val_if_fail (p != NULL, NULL);

	corba_p = bonobo_sizeable_corba_object_create (BONOBO_OBJECT (p));
	if (corba_p == CORBA_OBJECT_NIL){
		bonobo_object_unref (BONOBO_OBJECT (p));
		return NULL;
	}

	return bonobo_sizeable_construct (p, corba_p);
}
