/*
 * EFS driver for native filesystems access: SuperOps
 *
 * Author:
 *   Dietmar Maurer (dm@vlsivie.tuwien.ac.at)
 *
 */

#include <sys/types.h>
#include <sys/stat.h>
#include <dirent.h>
#include <string.h>
#include <unistd.h>
#include <fcntl.h>

#include "fsys.h"
#include "comp.h"

static EFSDir  *fsys_open    (EFS *efs, const char *path, 
			      gint flags, gint mode);
static gint     fsys_close   (EFS *efs);
static gint     fsys_commit  (EFS *efs);
static EFSStat *fsys_stat    (EFS *efs);

EFSSuperOps super_ops_fsys = {
	fsys_open,
	fsys_close,
	fsys_commit,
	fsys_stat,
	NULL,
	NULL
};

EFSDriver efs_driver_fsys = {
	"FSys", 0, 
	&super_ops_fsys,
	NULL,
	&file_ops_comp_fsys
};

static EFSDir *
fsys_open (EFS *efs, const char *path, gint flags, gint mode)
{
	FSYSDir *dir;
/*	struct flock fl = {F_WRLCK, SEEK_SET, 0, 0};*/
	DIR *d;
	gchar *p;
	gint pflags;

	if (flags&EFS_CREATE) flags |= EFS_RDWR;
	if (flags&EFS_WRITE) efs->mode = EFS_RDWR;
	else efs->mode = EFS_READ;

	if (!(d = opendir(path)) && !(flags&EFS_CREATE)) return NULL;

	pflags = O_RDONLY;

	if (!d) { /* create */
		if (mkdir(path, mode)) return NULL;
		pflags |= O_CREAT;

	}

	p = g_strconcat(path, "/.efs", NULL);
	if ((efs->fd = open (p, pflags|O_RDWR, 0644)) == -1) {
		g_free (p);
		close (efs->fd);
		return NULL;
	}
	g_free (p);

	/* fixme: no lock support at the moment */

	/*
	if (fcntl (efs->fd, F_SETLK, &fl) == -1) { 
	        close (efs->fd); 
		return NULL; 
	}
	*/

	dir = g_malloc0 (sizeof(FSYSDir));
	((EFSDir *)dir)->efs = efs;
	((EFSDir *)dir)->mode = EFS_DIR;
	dir->path = strdup (path);
	dir->d = d;
	return (EFSDir *)dir;
}

static gint
fsys_commit (EFS *efs)
{
	return 0;
}

static gint
fsys_close(EFS *efs)
{
	return 0;
}

static EFSStat*
fsys_stat (EFS *efs)
{
	static EFSStat stat;
	/* struct statfs buf;  Fixme: call statfs? */ 

	if (stat.drivername) g_free (stat.drivername);
	stat.drivername = strdup (efs->driver->drivername);
	stat.blocksize = efs->driver->blocksize;
	stat.blocks = 0;
	stat.free = 0;
	stat.inodes = 0;
	stat.namelen = MAXNAMLEN;
	stat.version = 0;
	return &stat;
}

