/*
 * a simple cache for blocks 
 * (fully associative with LRU replacement)
 *
 * Author:
 *   Dietmar Maurer (dm@vlsivie.tuwien.ac.at)
 *
 *
 */

#include "vefs.h"

static guint32 cache_access_time = 0;

void
efs_cache_flush (EFS *efs)
{
	gint i,j;

	for (j=0;j<2;j++) { /* 2 runs */
		for (i=0;i<EFS_CACHE_SIZE;i++) {
			if (efs->cache[i].dirty) {
				efs_unmap(efs, &efs->cache[i]);
				efs->cache[i].dirty = FALSE;
			}
		}
	}
}

void
efs_cache_touch (EFSCacheEntry *ce, gboolean dirty)
{
	cache_access_time++;

	ce->at = cache_access_time;
	if (dirty) ce->dirty = dirty;
}

EFSCacheEntry *
efs_cache_map (EFS *efs, guint32 block, guint32 ref_block,
	       guint32 ref_pos, gboolean noread)
{
	gint i, b;

	b = -1;
	for (i=0;i<EFS_CACHE_SIZE;i++) {
		if (efs->cache[i].block == block) {
			efs->cache[i].at = ++cache_access_time;
			efs->cache[i].ref_block = ref_block;
			efs->cache[i].ref_pos = ref_pos;
			return &efs->cache[i];
		}
		if (efs->cache[i].lock) continue;
		if (b<0) b=i;
		if (efs->cache[i].at<efs->cache[b].at) b = i;
	}

	if (b<0) {
		printf("EFS: internal error (cache look)\n");
	}

	if (efs->cache[b].dirty) { 
		efs_unmap(efs, &efs->cache[b]);
		efs->cache[b].dirty = FALSE;
	}
	
	efs->cache[b].at = ++cache_access_time;
	efs->cache[b].block = block;
	efs->cache[b].ref_block = ref_block;
	efs->cache[b].ref_pos = ref_pos;

	if (!noread) {
		efs_map(efs, &efs->cache[b], block);
		efs->cache[b].dirty = FALSE;
	} else {
		efs->cache[b].dirty = TRUE;
	}

	return &efs->cache[b];
}
