/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
#ifndef _BONOBO_UI_HANDLER_H_
#define _BONOBO_UI_HANDLER_H_

#include <bonobo/bonobo-object.h>
#include <gtk/gtkwidget.h>
#include <glib.h>
#include <gtk/gtkmenushell.h>
#include <gtk/gtkcheckmenuitem.h>
#include <gtk/gtkaccelgroup.h>
#include <libgnomeui/gnome-app.h>
#include <libgnomeui/gnome-app-helper.h>

#define BONOBO_UI_HANDLER_TYPE        (bonobo_ui_handler_get_type ())
#define BONOBO_UI_HANDLER(o)          (GTK_CHECK_CAST ((o), BONOBO_UI_HANDLER_TYPE, BonoboUIHandler))
#define BONOBO_UI_HANDLER_CLASS(k)    (GTK_CHECK_CLASS_CAST((k), BONOBO_UI_HANDLER_TYPE, BonoboUIHandlerClass))
#define BONOBO_IS_UI_HANDLER(o)       (GTK_CHECK_TYPE ((o), BONOBO_UI_HANDLER_TYPE))
#define BONOBO_IS_UI_HANDLER_CLASS(k) (GTK_CHECK_CLASS_TYPE ((k), BONOBO_UI_HANDLER_TYPE))

/*
 * Forward declarations.
 */
typedef struct _BonoboUIHandler BonoboUIHandler;
typedef struct _BonoboUIHandlerPrivate BonoboUIHandlerPrivate;
typedef struct _BonoboUIHandlerTopLevelData BonoboUIHandlerTopLevelData;
typedef struct _BonoboUIHandlerMenuItem BonoboUIHandlerMenuItem;
typedef struct _BonoboUIHandlerToolbarItem BonoboUIHandlerToolbarItem;

/*
 * The order of the arguments to this function might seem a bit
 * confusing; the closure (user_data), typically passed as the final
 * argument to a callback, is followed by a path parameter.  This is
 * to provide compatibility with the GnomeUIInfo (gnome-app-helper)
 * callback routines, whose arguments are (GtkWidget *menu_item, void
 * *user_data).
 */
typedef void (*BonoboUIHandlerCallback) (BonoboUIHandler *uih, void *user_data, const char *path);

/*
 * The BonoboUIHandler object.
 */
struct _BonoboUIHandler {
	BonoboObject			 base;

	/*
	 * If this UIHandler is for an object which is embedded in a
	 * container, then this field points to the top-level
	 * container's Bonobo::UIHandler CORBA interface.  The
	 * top-level container (the container which is not itself a
	 * containee) manages the actual menu and toolbar item
	 * GtkWidgets.
	 */
	Bonobo_UIHandler		 top_level_uih;

	/*
	 * The callback data for the menu items.
	 */
	GHashTable			*path_to_menu_callback;

	/*
	 * The callback data for the toolbar items.
	 */
	GHashTable			*path_to_toolbar_callback;
	GHashTable			*path_to_toolbar_toolbar;
	
	/*
	 * The top-level BonoboUIHandler must manage a lot of extra
	 * data (e.g. the actual menu/toolbar widgets, an internal
	 * representation of every menu/toolbar item, etc.).  This
	 * information is stored here.
	 */
	BonoboUIHandlerTopLevelData	*top;

	BonoboUIHandlerPrivate *priv;
};

typedef struct {
	BonoboObjectClass parent_class;

	/*
	 * Signals.
	 */
	void (*menu_item_activated)	(BonoboUIHandler *uih, char *path, void *item_data);
	void (*menu_item_removed)	(BonoboUIHandler *uih, char *path, void *item_data);
	void (*menu_item_overridden)	(BonoboUIHandler *uih, char *path, void *item_data);
	void (*menu_item_reinstated)	(BonoboUIHandler *uih, char *path, void *item_data);

	void (*toolbar_item_activated)	(BonoboUIHandler *uih, char *path, void *item_data);
	void (*toolbar_item_removed)	(BonoboUIHandler *uih, char *path, void *item_data);
	void (*toolbar_item_overridden)	(BonoboUIHandler *uih, char *path, void *item_data);
	void (*toolbar_item_reinstated)	(BonoboUIHandler *uih, char *path, void *item_data);
} BonoboUIHandlerClass;

typedef enum {
	BONOBO_UI_HANDLER_PIXMAP_NONE,
	BONOBO_UI_HANDLER_PIXMAP_STOCK,
	BONOBO_UI_HANDLER_PIXMAP_FILENAME,
	BONOBO_UI_HANDLER_PIXMAP_XPM_DATA,
	BONOBO_UI_HANDLER_PIXMAP_PIXBUF_DATA
} BonoboUIHandlerPixmapType;

typedef enum {
	BONOBO_UI_HANDLER_MENU_END,
	BONOBO_UI_HANDLER_MENU_ITEM,
	BONOBO_UI_HANDLER_MENU_SUBTREE,
	BONOBO_UI_HANDLER_MENU_RADIOITEM,
	BONOBO_UI_HANDLER_MENU_RADIOGROUP,
	BONOBO_UI_HANDLER_MENU_TOGGLEITEM,
	BONOBO_UI_HANDLER_MENU_SEPARATOR,
	BONOBO_UI_HANDLER_MENU_PLACEHOLDER
} BonoboUIHandlerMenuItemType;

/*
 *  A hack to allow placeholders to be put into a gnome-app-helper
 * structure, so that they can be used trivialy.
 */
#define BONOBO_APP_UI_PLACEHOLDER (GNOME_APP_UI_SUBTREE_STOCK + 0x100)
#define BONOBOUIINFO_PLACEHOLDER(label) \
	{ BONOBO_APP_UI_PLACEHOLDER, label, NULL, NULL, NULL, NULL, \
		GNOME_APP_PIXMAP_NONE, NULL, 0, (GdkModifierType) 0, NULL }

struct _BonoboUIHandlerMenuItem {
	char			        *path;

	BonoboUIHandlerMenuItemType	 type;
	char			        *label;
	char			        *hint;

	int				 pos;

	/*
	 * If this item is a subtree, then this field can point to a
	 * NULL-terminated array of BonoboUIHandlerMenuItems in the
	 * subtree.  If this item is a radio item, then this list
	 * contains the items in the radio group.
	 */
	BonoboUIHandlerMenuItem		*children;

	BonoboUIHandlerPixmapType	 pixmap_type;
	gpointer			 pixmap_data;

	guint				 accelerator_key;
	GdkModifierType			 ac_mods;

	/*
	 * The callback function and closure.
	 */
	BonoboUIHandlerCallback	         callback;
	gpointer			 callback_data;
	GDestroyNotify                   callback_data_destroy_notify;
};

typedef enum {
	BONOBO_UI_HANDLER_TOOLBAR_END,
	BONOBO_UI_HANDLER_TOOLBAR_ITEM,
	BONOBO_UI_HANDLER_TOOLBAR_RADIOITEM,
	BONOBO_UI_HANDLER_TOOLBAR_RADIOGROUP,
	BONOBO_UI_HANDLER_TOOLBAR_TOGGLEITEM,
	BONOBO_UI_HANDLER_TOOLBAR_SEPARATOR,
	BONOBO_UI_HANDLER_TOOLBAR_CONTROL
} BonoboUIHandlerToolbarItemType;

struct _BonoboUIHandlerToolbarItem {
	char				*path;

	BonoboUIHandlerToolbarItemType	 type;

	char				*label;
	char				*hint;

	int				 pos;

	Bonobo_Control			 control;

	BonoboUIHandlerToolbarItem	*children;

	BonoboUIHandlerPixmapType	 pixmap_type;
	gpointer			 pixmap_data;

	guint				 accelerator_key;
	GdkModifierType			 ac_mods;

	/*
	 * The callback function and closure.
	 */
	BonoboUIHandlerCallback	         callback;
	gpointer			 callback_data;
	GDestroyNotify                   callback_data_destroy_notify;
};

/*
 * The basic functions for managing the BonoboUIHandler object.
 */
GtkType			 bonobo_ui_handler_get_type			(void);
BonoboUIHandler		*bonobo_ui_handler_construct			(BonoboUIHandler *ui_handler,
									 Bonobo_UIHandler corba_uihandler);
BonoboUIHandler		*bonobo_ui_handler_new				(void);
void			 bonobo_ui_handler_set_container			(BonoboUIHandler *uih,
									 Bonobo_UIHandler container);
void			 bonobo_ui_handler_unset_container		(BonoboUIHandler *uih);
void			 bonobo_ui_handler_add_containee			(BonoboUIHandler *uih,
									 Bonobo_UIHandler containee);
void			 bonobo_ui_handler_remove_containee		(BonoboUIHandler *uih,
									 Bonobo_UIHandler containee);
void			 bonobo_ui_handler_set_accelgroup		(BonoboUIHandler *uih,
									 GtkAccelGroup *accelgroup);
GtkAccelGroup		*bonobo_ui_handler_get_accelgroup		(BonoboUIHandler *uih);

/*
 * This path-building routine will be used for both toolbar and menu
 * item paths.
 */
char			*bonobo_ui_handler_build_path			(const char *base, ...);
char			*bonobo_ui_handler_build_path_v			(const char *base, va_list path_components);

/*
 * Menus.
 */

/* Toplevel menu routines. */
void			 bonobo_ui_handler_set_app			(BonoboUIHandler *uih, GnomeApp *app);
GnomeApp                *bonobo_ui_handler_get_app                      (BonoboUIHandler *uih);
void			 bonobo_ui_handler_set_statusbar			(BonoboUIHandler *uih, GtkWidget *statusbar);
GtkWidget		*bonobo_ui_handler_get_statusbar			(BonoboUIHandler *uih);

void			 bonobo_ui_handler_set_menubar			(BonoboUIHandler *uih, GtkWidget *menubar);
GtkWidget		*bonobo_ui_handler_get_menubar			(BonoboUIHandler *uih);

void			 bonobo_ui_handler_create_menubar		(BonoboUIHandler *uih);
void			 bonobo_ui_handler_create_popup_menu		(BonoboUIHandler *uih);
void			 bonobo_ui_handler_do_popup_menu			(BonoboUIHandler *uih);
void			 bonobo_ui_handler_set_toolbar			(BonoboUIHandler *uih, const char *name,
									 GtkWidget *toolbar);



/* Menu routines everyone can use. */
void			 bonobo_ui_handler_menu_new			(BonoboUIHandler *uih, const char *path,
									 BonoboUIHandlerMenuItemType type,
									 const char *label, const char *hint,
									 int pos, BonoboUIHandlerPixmapType pixmap_type,
									 gpointer pixmap_data,
									 guint accelerator_key, GdkModifierType ac_mods,
									 BonoboUIHandlerCallback callback,
									 gpointer callback_data);
void			 bonobo_ui_handler_menu_new_item		(BonoboUIHandler *uih, const char *path,
									 const char *label, const char *hint,
									 int pos, BonoboUIHandlerPixmapType pixmap_type,
									 gpointer pixmap_data,
									 guint accelerator_key, GdkModifierType ac_mods,
									 BonoboUIHandlerCallback callback,
									 gpointer callback_data);
void			 bonobo_ui_handler_menu_new_subtree		(BonoboUIHandler *uih, const char *path,
									 const char *label, const char *hint, int pos,
									 BonoboUIHandlerPixmapType pixmap_type,
									 gpointer pixmap_data, guint accelerator_key,
									 GdkModifierType ac_mods);
void			 bonobo_ui_handler_menu_new_separator		(BonoboUIHandler *uih, const char *path, int pos);
void			 bonobo_ui_handler_menu_new_placeholder		(BonoboUIHandler *uih, const char *path);
void			 bonobo_ui_handler_menu_new_radiogroup		(BonoboUIHandler *uih, const char *path);
void			 bonobo_ui_handler_menu_new_radioitem		(BonoboUIHandler *uih, const char *path,
									 const char *label, const char *hint, int pos,
									 guint accelerator_key, GdkModifierType ac_mods,
									 BonoboUIHandlerCallback callback,
									 gpointer callback_data);
void			 bonobo_ui_handler_menu_new_toggleitem		(BonoboUIHandler *uih, const char *path,
									 const char *label, const char *hint, int pos,
									 guint accelerator_key, GdkModifierType ac_mods,
									 BonoboUIHandlerCallback callback,
									 gpointer callback_data);
void			 bonobo_ui_handler_menu_add_one			(BonoboUIHandler *uih, const char *parent_path,
									 BonoboUIHandlerMenuItem *item);
void			 bonobo_ui_handler_menu_add_list			(BonoboUIHandler *uih, const char *parent_path,
									 BonoboUIHandlerMenuItem *array);
void			 bonobo_ui_handler_menu_add_tree			(BonoboUIHandler *uih, const char *parent_path,
									 BonoboUIHandlerMenuItem *tree);
void			 bonobo_ui_handler_menu_remove			(BonoboUIHandler *uih, const char *path);
BonoboUIHandlerMenuItem	*bonobo_ui_handler_menu_fetch_one		(BonoboUIHandler *uih, const char *path);
BonoboUIHandlerMenuItem	*bonobo_ui_handler_menu_fetch_list		(BonoboUIHandler *uih, const char *path);
BonoboUIHandlerMenuItem	*bonobo_ui_handler_menu_fetch_tree		(BonoboUIHandler *uih, const char *path);

gboolean                 bonobo_ui_handler_menu_path_exists             (BonoboUIHandler *uih, const char *path);
void			 bonobo_ui_handler_menu_free_one			(BonoboUIHandlerMenuItem *item);
void			 bonobo_ui_handler_menu_free_list		(BonoboUIHandlerMenuItem *item);
void			 bonobo_ui_handler_menu_free_tree		(BonoboUIHandlerMenuItem *item);


GList			*bonobo_ui_handler_menu_fetch_by_callback	(BonoboUIHandler *uih,
									 BonoboUIHandlerCallback callback);
GList			*bonobo_ui_handler_menu_fetch_by_callback_data	(BonoboUIHandler *uih, gpointer callback_data);
GList			*bonobo_ui_handler_menu_get_child_paths		(BonoboUIHandler *uih, const char *parent_path);

BonoboUIHandlerMenuItem	*bonobo_ui_handler_menu_parse_uiinfo_one		(GnomeUIInfo *uii);
BonoboUIHandlerMenuItem	*bonobo_ui_handler_menu_parse_uiinfo_list	(GnomeUIInfo *uii);
BonoboUIHandlerMenuItem	*bonobo_ui_handler_menu_parse_uiinfo_tree	(GnomeUIInfo *uii);

BonoboUIHandlerMenuItem	*bonobo_ui_handler_menu_parse_uiinfo_one_with_data	(GnomeUIInfo *uii, void *data);
BonoboUIHandlerMenuItem	*bonobo_ui_handler_menu_parse_uiinfo_list_with_data	(GnomeUIInfo *uii, void *data);
BonoboUIHandlerMenuItem	*bonobo_ui_handler_menu_parse_uiinfo_tree_with_data	(GnomeUIInfo *uii, void *data);

int			 bonobo_ui_handler_menu_get_pos			(BonoboUIHandler *uih, const char *path);

void			 bonobo_ui_handler_menu_set_sensitivity		(BonoboUIHandler *uih, const char *path,
									 gboolean sensitive);
gboolean		 bonobo_ui_handler_menu_get_sensitivity		(BonoboUIHandler *uih, const char *path);

void			 bonobo_ui_handler_menu_set_label		(BonoboUIHandler *uih, const char *path,
									 const gchar *label);
gchar			*bonobo_ui_handler_menu_get_label		(BonoboUIHandler *uih, const char *path);

void			 bonobo_ui_handler_menu_set_hint			(BonoboUIHandler *uih, const char *path,
									 const gchar *hint);
gchar			*bonobo_ui_handler_menu_get_hint			(BonoboUIHandler *uih, const char *path);

void			 bonobo_ui_handler_menu_set_pixmap		(BonoboUIHandler *uih, const char *path,
									 BonoboUIHandlerPixmapType type, gpointer data);
void			 bonobo_ui_handler_menu_get_pixmap		(BonoboUIHandler *uih, const char *path,
									 BonoboUIHandlerPixmapType *type, gpointer *data);

void			 bonobo_ui_handler_menu_set_accel		(BonoboUIHandler *uih, const char *path,
									 guint accelerator_key, GdkModifierType ac_mods);
void			 bonobo_ui_handler_menu_get_accel		(BonoboUIHandler *uih, const char *path,
									 guint *accelerator_key, GdkModifierType *ac_mods);

void			 bonobo_ui_handler_menu_set_callback		(BonoboUIHandler *uih, const char *path,
									 BonoboUIHandlerCallback callback,
									 gpointer callback_data,
									 GDestroyNotify callback_data_destroy_notify);
void			 bonobo_ui_handler_menu_get_callback		(BonoboUIHandler *uih, const char *path,
									 BonoboUIHandlerCallback *callback,
									 gpointer *callback_data,
									 GDestroyNotify *callback_data_destroy_notify);
void			 bonobo_ui_handler_menu_remove_callback_no_notify (BonoboUIHandler *uih, const char *path);

void			 bonobo_ui_handler_menu_set_toggle_state		(BonoboUIHandler *uih, const char *path,
									 gboolean state);
gboolean		 bonobo_ui_handler_menu_get_toggle_state		(BonoboUIHandler *uih, const char *path);

void			 bonobo_ui_handler_menu_set_radio_state		(BonoboUIHandler *uih, const char *path,
									 gboolean state);
gboolean		 bonobo_ui_handler_menu_get_radio_state		(BonoboUIHandler *uih, const char *path);

char			*bonobo_ui_handler_menu_get_radio_group_selection(BonoboUIHandler *uih, const char *rg_path);

/*
 * The Toolbar manipulation routines.
 *
 * The name of the toolbar is the first element in the toolbar path.
 * For example:
 *		"/Common/Save"
 *		"/Graphics Tools/Erase"
 * 
 * Where both "Common" and "Graphics Tools" are the names of 
 * toolbars.
 * 
 */

void				 bonobo_ui_handler_create_toolbar	(BonoboUIHandler *uih, const char *name);
void				 bonobo_ui_handler_remove_toolbar	(BonoboUIHandler *uih, const char *name);
GList				*bonobo_ui_handler_get_toolbar_list	(BonoboUIHandler *uih);


void				 bonobo_ui_handler_toolbar_new		(BonoboUIHandler *uih, const char *path,
									 BonoboUIHandlerToolbarItemType type,
									 const char *label, const char *hint,
									 int pos, const Bonobo_Control control,
									 BonoboUIHandlerPixmapType pixmap_type,
									 gpointer pixmap_data, guint accelerator_key,
									 GdkModifierType ac_mods,
									 BonoboUIHandlerCallback callback,
									 gpointer callback_data);
void				 bonobo_ui_handler_toolbar_new_control	(BonoboUIHandler *uih, const char *path,
									 int pos, Bonobo_Control control);
void				 bonobo_ui_handler_toolbar_new_item	(BonoboUIHandler *uih, const char *path,
									 const char *label, const char *hint, int pos,
									 BonoboUIHandlerPixmapType pixmap_type,
									 gpointer pixmap_data,
									 guint accelerator_key, GdkModifierType ac_mods,
									 BonoboUIHandlerCallback callback,
									 gpointer callback_data);
void				 bonobo_ui_handler_toolbar_new_separator	(BonoboUIHandler *uih, const char *path, int pos);
void				 bonobo_ui_handler_toolbar_new_radiogroup(BonoboUIHandler *uih, const char *path);
void				 bonobo_ui_handler_toolbar_new_radioitem	(BonoboUIHandler *uih, const char *path,
									 const char *label, const char *hint, int pos,
									 BonoboUIHandlerPixmapType pixmap_type,
									 gpointer pixmap_data,
									 guint accelerator_key, GdkModifierType ac_mods,
									 BonoboUIHandlerCallback callback,
									 gpointer callback_data);
void				 bonobo_ui_handler_toolbar_new_toggleitem(BonoboUIHandler *uih, const char *path,
									 const char *label, const char *hint, int pos,
									 BonoboUIHandlerPixmapType pixmap_type,
									 gpointer pixmap_data,
									 guint accelerator_key, GdkModifierType ac_mods,
									 BonoboUIHandlerCallback callback,
									 gpointer callback_data);
void				 bonobo_ui_handler_toolbar_add_one	(BonoboUIHandler *uih, const char *parent_path,
									 BonoboUIHandlerToolbarItem *item);
void				 bonobo_ui_handler_toolbar_add_list	(BonoboUIHandler *uih, const char *parent_path,
									 BonoboUIHandlerToolbarItem *item);
void				 bonobo_ui_handler_toolbar_add_tree	(BonoboUIHandler *uih, const char *parent_path,
									 BonoboUIHandlerToolbarItem *item);
void				 bonobo_ui_handler_toolbar_remove	(BonoboUIHandler *uih, const char *path);
BonoboUIHandlerToolbarItem	*bonobo_ui_handler_toolbar_fetch_one	(BonoboUIHandler *uih, const char *path);
BonoboUIHandlerToolbarItem	*bonobo_ui_handler_toolbar_fetch_list	(BonoboUIHandler *uih, const char *path);
BonoboUIHandlerToolbarItem	*bonobo_ui_handler_toolbar_fetch_tree	(BonoboUIHandler *uih, const char *path);
GList				*bonobo_ui_handler_toolbar_fetch_by_callback (BonoboUIHandler *uih,
									     BonoboUIHandlerCallback callback);
GList				*bonobo_ui_handler_toolbar_fetch_by_callback_data (BonoboUIHandler *uih,
										  gpointer callback_data);
GList				*bonobo_ui_handler_toolbar_get_child_paths (BonoboUIHandler *uih, const char *path);

BonoboUIHandlerToolbarItem	*bonobo_ui_handler_toolbar_parse_uiinfo_one	(GnomeUIInfo *uii);
BonoboUIHandlerToolbarItem	*bonobo_ui_handler_toolbar_parse_uiinfo_list	(GnomeUIInfo *uii);
BonoboUIHandlerToolbarItem	*bonobo_ui_handler_toolbar_parse_uiinfo_tree	(GnomeUIInfo *uii);

BonoboUIHandlerToolbarItem	*bonobo_ui_handler_toolbar_parse_uiinfo_one_with_data (GnomeUIInfo *uii, void *data);
BonoboUIHandlerToolbarItem	*bonobo_ui_handler_toolbar_parse_uiinfo_list_with_data (GnomeUIInfo *uii, void *data);
BonoboUIHandlerToolbarItem	*bonobo_ui_handler_toolbar_parse_uiinfo_tree_with_data (GnomeUIInfo *uii, void *data);

void			         bonobo_ui_handler_toolbar_free_one	        (BonoboUIHandlerToolbarItem *item);
void			         bonobo_ui_handler_toolbar_free_list		(BonoboUIHandlerToolbarItem *item);
void			         bonobo_ui_handler_toolbar_free_tree		(BonoboUIHandlerToolbarItem *item);

int				 bonobo_ui_handler_toolbar_item_get_pos	(BonoboUIHandler *uih, const char *path);
void				 bonobo_ui_handler_toolbar_item_set_pos	(BonoboUIHandler *uih, const char *path,
									 int pos);

void				 bonobo_ui_handler_toolbar_item_set_sensitivity (BonoboUIHandler *uih, const char *path,
										gboolean sensitive);
gboolean			 bonobo_ui_handler_toolbar_item_get_sensitivity (BonoboUIHandler *uih, const char *path);

void				 bonobo_ui_handler_toolbar_item_set_label	(BonoboUIHandler *uih, const char *path,
										 gchar *label);
gchar				*bonobo_ui_handler_toolbar_item_get_label	(BonoboUIHandler *uih, const char *path);

void				 bonobo_ui_handler_toolbar_item_set_hint	(BonoboUIHandler *uih, const char *path,
									 gchar *hint);
gchar				*bonobo_ui_handler_toolbar_item_get_hint	(BonoboUIHandler *uih, const char *path);

void				 bonobo_ui_handler_toolbar_item_set_pixmap	(BonoboUIHandler *uih, const char *path,
										 BonoboUIHandlerPixmapType type, gpointer data);
void				 bonobo_ui_handler_toolbar_item_get_pixmap	(BonoboUIHandler *uih, const char *path,
										 BonoboUIHandlerPixmapType *type, gpointer *data);

void				 bonobo_ui_handler_toolbar_item_set_accel	(BonoboUIHandler *uih, const char *path,
										 guint accelerator_key, GdkModifierType ac_mods);
void				 bonobo_ui_handler_toolbar_item_get_accel	(BonoboUIHandler *uih, const char *path,
										 guint *aaccelerator_key, GdkModifierType *ac_mods);

void				 bonobo_ui_handler_toolbar_item_set_callback	(BonoboUIHandler *uih, const char *path,
										 BonoboUIHandlerCallback callback,
										 gpointer callback_data,
										 GDestroyNotify callback_data_destroy_notify);

void				 bonobo_ui_handler_toolbar_item_get_callback	(BonoboUIHandler *uih, const char *path,
										 BonoboUIHandlerCallback *callback,
										 gpointer *callback_data,
										 GDestroyNotify *callback_data_destroy_notify);
void			         bonobo_ui_handler_toolbar_item_remove_callback_no_notify (BonoboUIHandler *uih, const char *path);

void				 bonobo_ui_handler_toolbar_item_toggle_set_state (BonoboUIHandler *uih, const char *path, gboolean state);
gboolean			 bonobo_ui_handler_toolbar_item_toggle_get_state (BonoboUIHandler *uih, const char *path);

gboolean			 bonobo_ui_handler_toolbar_item_radio_get_state  (BonoboUIHandler *uih, const char *path);
void				 bonobo_ui_handler_toolbar_item_radio_set_state  (BonoboUIHandler *uih, const char *path, gboolean state);

void                             bonobo_ui_handler_toolbar_set_orientation (BonoboUIHandler *uih, const char *path,
										GtkOrientation orientation);
GtkOrientation                   bonobo_ui_handler_toolbar_get_orientation (BonoboUIHandler *uih, const char *path);


gboolean  bonobo_ui_handler_dock_add            (BonoboUIHandler       *uih,
						 const char            *name,
						 Bonobo_Control         control,
						 GnomeDockItemBehavior  behavior,
						 GnomeDockPlacement     placement,
						 gint                   band_num,
						 gint                   band_position,
						 gint                   offset);
gboolean  bonobo_ui_handler_dock_remove         (BonoboUIHandler       *uih,
						 const char            *name);
gboolean  bonobo_ui_handler_dock_set_sensitive  (BonoboUIHandler       *uih,
						 const char            *name,
						 gboolean               sensitivity);
gboolean  bonobo_ui_handler_dock_get_sensitive  (BonoboUIHandler       *uih,
						 const char            *name);

POA_Bonobo_UIHandler__epv *bonobo_ui_handler_get_epv (void);

#endif /* _BONOBO_UI_HANDLER_H_ */
