#ifndef __BONOBO_UIH_PRIVATE_H__
#define __BONOBO_UIH_PRIVATE_H__

#ifndef BONOBO_UI_HANDLER_COMPILATION
#error "bonobo-uih-private.h: Which part of the word \"private\" do you not understand?"
#endif

/*
 * Signals.
 */
enum {
	MENU_ITEM_ACTIVATED,
	MENU_ITEM_REMOVED,
	MENU_ITEM_OVERRIDDEN,
	MENU_ITEM_REINSTATED,

	TOOLBAR_ITEM_ACTIVATED,
	TOOLBAR_ITEM_REMOVED,
	TOOLBAR_ITEM_OVERRIDDEN,
	TOOLBAR_ITEM_REINSTATED,

	LAST_SIGNAL
};

extern guint bonobo_ui_handler_signals [LAST_SIGNAL];

/*
 * Internal data structure definitions.
 */

/*
 * The data which a top-level UIHandler server must maintain.
 */
struct _BonoboUIHandlerTopLevelData {
	/*
	 * These hash tables are used to maintain an internal
	 * representation of the menu and toolbar trees.  They store
	 * internal data structures which you shouldn't muck with.
	 */
	GHashTable			*path_to_menu_item;

	GHashTable			*path_to_toolbar_item;
	GHashTable			*name_to_toolbar;

	GHashTable                      *name_to_dock;

	/*
	 * Some application-global widget data.
	 */
	GnomeApp			*app;
	GtkAccelGroup			*accelgroup;
	GtkWidget			*statusbar;
	GtkWidget			*menubar;
	GtkWidget			*common_toolbar;
	GHashTable			*toolbars;

	/*
	 * This hash table maps menu item paths to the actual
	 * GtkMenuItem widgets.
	 */
	GHashTable			*path_to_menu_widget;

	/*
	 * This hash table maps subtree paths to the GtkMenuShell
	 * widget.
	 */
	GHashTable			*path_to_menu_shell;

	/* FIXME: Comments */
	GHashTable			*name_to_toolbar_widget;
	GHashTable			*path_to_toolbar_item_widget;

	/*
	 * If this UIHandler is for a top-level application which is
	 * acting as a container for one or more embedded objects,
	 * then this list contains the interfaces for the
	 * BonoboUIHandlers for the embedded objects.
	 */
	GList				*containee_uihs;
};

typedef struct _DockInternal {
	char             *name;
	Bonobo_UIHandler  containee;
} DockInternal;

/*
 * This structure is used to maintain an internal representation of a
 * menu item.
 */
typedef struct _MenuItemInternal {

	/*
	 * The BonoboUIHandler.
	 */
	BonoboUIHandler *uih;

	/*
	 * A copy of the BonoboUIHandlerMenuItem for this toolbar item.
	 */
	BonoboUIHandlerMenuItem *item;

	/*
	 * If this item is a subtree or a radio group, this list
	 * contains the item's children.  It is a list of path
	 * strings.  This list is kept in order of the position of the
	 * menu items in the subtree.
	 */
	GList *children;

	/*
	 * The UIHandler CORBA interface for the containee which owns
	 * this particular menu item.
	 */
	Bonobo_UIHandler uih_corba;

	/*
	 * If this item is a radio group, then this list points to the
	 * GtkRadioMenuItem widgets for the members of the group.
	 */
	GSList *radio_items;

	/*
	 * The sensitivity of the menu item (whether its grayed out or
	 * not).
	 */
	gboolean sensitive;

	/*
	 * If this is a toggle item or a radio item, whether this item
	 * is selected or not.
	 */
	gboolean active;
} MenuItemInternal;

/*
 * This structure is used to hold local callback data for a menu item.
 */
typedef struct {

	/*
	 * A list of child paths, if appropriate.  
	 */
	GList				*children;

	BonoboUIHandlerCallbackFunc	 callback;
	gpointer			 callback_data;
} MenuItemLocalInternal;

/*
 * This structure is used to maintain an internal representation of a
 * toolbar item.
 */
/*
 * Forward declarations.
 */

typedef struct _ToolbarItemInternal         ToolbarItemInternal;
typedef struct _ToolbarToolbarInternal      ToolbarToolbarInternal;
typedef struct _ToolbarItemLocalInternal    ToolbarItemLocalInternal;
typedef struct _ToolbarToolbarLocalInternal ToolbarToolbarLocalInternal;

struct _ToolbarItemInternal {
	/*
	 * The BonoboUIHandler.
	 */
	BonoboUIHandler *uih;

	/*
	 * A copy of the BonoboUIHandlerToolbarItem for this toolbar item.
	 */
	BonoboUIHandlerToolbarItem *item;

	/*
	 * The UIHandler CORBA interface for the containee which owns
	 * this particular menu item.
	 */
	Bonobo_UIHandler uih_corba;

	/*
	 * In the world of toolbars, only radio groups can have
	 * children.
	 */
	GList *children;

	gboolean sensitive;
};

/*
 * The internal data for a toolbar.
 */
struct _ToolbarToolbarInternal {

	/*
	 * This toolbar's name. e.g. "Common"
	 * The path for a toolbar item will be something like "/Common/Help"
	 */
	char			 *name;

	/*
	 * A list of paths for the items in this toolbar.
	 */
	GList			 *children;

	/*
	 * The owner for this toolbar.
	 */
	Bonobo_UIHandler		 uih_corba;

	GtkOrientation		 orientation;
	GtkToolbarStyle		 style;
	GtkToolbarSpaceStyle	 space_style;
	int			 space_size;
	GtkReliefStyle		 relief;
};

struct _ToolbarItemLocalInternal {
	BonoboUIHandlerCallbackFunc callback;
	gpointer	           callback_data;
};

struct _ToolbarToolbarLocalInternal {
	GList		*children;
};

typedef struct {
	CORBA_char       *label, *hint;
	CORBA_long        accelerator_key, ac_mods, pos;
	CORBA_boolean     toggle_state, sensitive, active;
} UIRemoteAttributeData;

typedef struct {
	Bonobo_UIHandler_ToolbarOrientation orientation;
	Bonobo_UIHandler_ToolbarStyle       style;
	Bonobo_UIHandler_ToolbarSpaceStyle  space_style;
	Bonobo_UIHandler_ReliefStyle        relief_style;
	CORBA_long                         space_size;
	CORBA_boolean                      sensitive;
} ToolbarRemoteAttributeData;


gchar    ** bonobo_ui_handler_path_tokenize (const char *path);
void                         bonobo_ui_handler_remote_attribute_data_free             (UIRemoteAttributeData         *attrs);
gboolean                     bonobo_ui_handler_toplevel_check_toplevel                (BonoboUIHandler               *uih);
void                         bonobo_ui_handler_toplevel_add_containee                 (BonoboUIHandler               *uih,
										       Bonobo_UIHandler               containee);
void                         bonobo_ui_handler_pixmap_free_data                       (BonoboUIHandlerPixmapType      pixmap_type,
										       gpointer                       pixmap_info);
gpointer                     bonobo_ui_handler_pixmap_copy_data                       (BonoboUIHandlerPixmapType      pixmap_type,
										       const gconstpointer            pixmap_info);
Bonobo_UIHandler_iobuf      *bonobo_ui_handler_pixmap_data_to_corba                   (BonoboUIHandlerPixmapType      type,
										       gpointer                       data);
Bonobo_UIHandler_PixmapType  bonobo_ui_handler_pixmap_corba_to_type                   (Bonobo_UIHandler_PixmapType    type);
Bonobo_UIHandler_PixmapType  bonobo_ui_handler_pixmap_type_to_corba                   (BonoboUIHandlerPixmapType      type);
gpointer                     bonobo_ui_handler_pixmap_corba_to_data                   (Bonobo_UIHandler_PixmapType    corba_pixmap_type,
										       const Bonobo_UIHandler_iobuf  *corba_pixmap_data);
void                         bonobo_ui_handler_local_do_path                          (const char                    *parent_path,
										       const char                    *item_label,
										       char                         **item_path);
gboolean                     bonobo_ui_handler_toplevel_check_toplevel                (BonoboUIHandler               *uih);
gchar                       *bonobo_ui_handler_path_get_parent                        (const char                    *path);
GtkWidget                   *bonobo_ui_handler_toplevel_create_pixmap                 (GtkWidget                     *window,
										       BonoboUIHandlerPixmapType      pixmap_type,
										       gpointer                       pixmap_info);
BonoboUIHandlerPixmapType    bonobo_ui_handler_uiinfo_pixmap_type_to_uih              (GnomeUIPixmapType              ui_type);
void                         bonobo_ui_handler_menu_toplevel_remove_item_internal     (BonoboUIHandler               *uih,
										       MenuItemInternal              *internal,
										       gboolean                       replace);
void                         bonobo_ui_handler_toolbar_toplevel_remove_item_internal  (BonoboUIHandler               *uih,
										       ToolbarItemInternal           *internal);

/*
 * Menu CORBA method implementations.
 */
void  impl_Bonobo_UIHandler_menu_activated               (PortableServer_Servant                      servant,
							  const CORBA_char                           *path,
							  CORBA_Environment                          *ev);
void  impl_Bonobo_UIHandler_menu_overridden              (PortableServer_Servant                      servant,
							  const CORBA_char                           *path,
							  CORBA_Environment                          *ev);
void  impl_Bonobo_UIHandler_menu_create                  (PortableServer_Servant                      servant,
							  const Bonobo_UIHandler                      containee_uih,
							  const CORBA_char                           *path,
							  Bonobo_UIHandler_MenuType                   menu_type,
							  const CORBA_char                           *label,
							  const CORBA_char                           *hint,
							  CORBA_long                                  pos,
							  const Bonobo_UIHandler_PixmapType           pixmap_type,
							  const Bonobo_UIHandler_iobuf               *pixmap_data,
							  CORBA_unsigned_long                         accelerator_key,
							  CORBA_long                                  modifier,
							  CORBA_Environment                          *ev);
void  impl_Bonobo_UIHandler_menu_removed                 (PortableServer_Servant                      servant,
							  const CORBA_char                           *path,
							  CORBA_Environment                          *ev);
void  impl_Bonobo_UIHandler_menu_reinstated              (PortableServer_Servant                      servant,
							  const CORBA_char                           *path,
							  CORBA_Environment                          *ev);
void  impl_Bonobo_UIHandler_menu_remove                  (PortableServer_Servant                      servant,
							  Bonobo_UIHandler                            containee_uih,
							  const CORBA_char                           *path,
							  CORBA_Environment                          *ev);
void  impl_Bonobo_UIHandler_menu_fetch                   (PortableServer_Servant                      servant,
							  const CORBA_char                           *path,
							  Bonobo_UIHandler_MenuType                  *type,
							  CORBA_char                                **label,
							  CORBA_char                                **hint,
							  CORBA_long                                 *pos,
							  Bonobo_UIHandler_PixmapType                *pixmap_type,
							  Bonobo_UIHandler_iobuf                    **pixmap_data,
							  CORBA_unsigned_long                        *accelerator_key,
							  CORBA_long                                 *modifier,
							  CORBA_Environment                          *ev);
void  impl_Bonobo_UIHandler_menu_get_children            (PortableServer_Servant                      servant,
							  const CORBA_char                           *parent_path,
							  Bonobo_UIHandler_StringSeq                **child_paths,
							  CORBA_Environment                          *ev);
void  impl_Bonobo_UIHandler_menu_set_data                (PortableServer_Servant                      servant,
							  Bonobo_UIHandler                            containee_uih,
							  const CORBA_char                           *path,
							  Bonobo_UIHandler_PixmapType                 corba_pixmap_type,
							  const Bonobo_UIHandler_iobuf               *corba_pixmap_data,
							  CORBA_Environment                          *ev);
void  impl_Bonobo_UIHandler_menu_get_data                (PortableServer_Servant                      servant,
							  Bonobo_UIHandler                            containee_uih,
							  const CORBA_char                           *path,
							  Bonobo_UIHandler_PixmapType                *corba_pixmap_type,
							  Bonobo_UIHandler_iobuf                    **corba_pixmap_data,
							  CORBA_Environment                          *ev);
void  impl_Bonobo_UIHandler_menu_set_attributes          (PortableServer_Servant                      servant,
							  const Bonobo_UIHandler                      containee_uih,
							  const CORBA_char                           *path,
							  CORBA_boolean                               sensitive,
							  CORBA_long                                  pos,
							  const CORBA_char                           *label,
							  const CORBA_char                           *hint,
							  CORBA_long                                  accelerator_key,
							  CORBA_long                                  ac_mods,
							  CORBA_boolean                               toggle_state,
							  CORBA_Environment                          *ev);
void  impl_Bonobo_UIHandler_menu_get_attributes          (PortableServer_Servant                      servant,
							  const Bonobo_UIHandler                      containee_uih,
							  const CORBA_char                           *path,
							  CORBA_boolean                              *sensitive,
							  CORBA_long                                 *pos,
							  CORBA_char                                **label,
							  CORBA_char                                **hint,
							  CORBA_long                                 *accelerator_key,
							  CORBA_long                                 *ac_mods,
							  CORBA_boolean                              *toggle_state,
							  CORBA_Environment                          *ev);


/*
 * Toolbar CORBA method implementations.
 */
void  impl_Bonobo_UIHandler_toolbar_create               (PortableServer_Servant                      servant,
							  const Bonobo_UIHandler                      containee,
							  const CORBA_char                           *name,
							  CORBA_Environment                          *ev);
void  impl_Bonobo_UIHandler_toolbar_remove               (PortableServer_Servant                      servant,
							  Bonobo_UIHandler                            containee,
							  const CORBA_char                           *name,
							  CORBA_Environment                          *ev);
void  impl_Bonobo_UIHandler_toolbar_overridden           (PortableServer_Servant                      servant,
							  const CORBA_char                           *path,
							  CORBA_Environment                          *ev);
void  impl_Bonobo_UIHandler_toolbar_activated            (PortableServer_Servant                      servant,
							  const CORBA_char                           *path,
							  CORBA_Environment                          *ev);
void  impl_Bonobo_UIHandler_toolbar_create_item          (PortableServer_Servant                      servant,
							  const Bonobo_UIHandler                      containee_uih,
							  const CORBA_char                           *path,
							  Bonobo_UIHandler_ToolbarType                toolbar_type,
							  const CORBA_char                           *label,
							  const CORBA_char                           *hint,
							  CORBA_long                                  pos,
							  const Bonobo_Control                        control,
							  Bonobo_UIHandler_PixmapType                 pixmap_type,
							  const Bonobo_UIHandler_iobuf               *pixmap_data,
							  CORBA_unsigned_long                         accelerator_key,
							  CORBA_long                                  modifier,
							  CORBA_Environment                          *ev);
void  impl_Bonobo_UIHandler_toolbar_reinstated           (PortableServer_Servant                      servant,
							  const CORBA_char                           *path,
							  CORBA_Environment                          *ev);
void  impl_Bonobo_UIHandler_toolbar_removed              (PortableServer_Servant                      servant,
							  const CORBA_char                           *path,
							  CORBA_Environment                          *ev);
void  impl_Bonobo_UIHandler_toolbar_remove_item          (PortableServer_Servant                      servant,
							  Bonobo_UIHandler                            containee_uih,
							  const CORBA_char                           *path,
							  CORBA_Environment                          *ev);
void  impl_Bonobo_UIHandler_toolbar_item_get_attributes  (PortableServer_Servant                      servant,
							  const Bonobo_UIHandler                      containee,
							  const CORBA_char                           *path,
							  CORBA_boolean                              *sensitive,
							  CORBA_boolean                              *active,
							  CORBA_long                                 *pos,
							  CORBA_char                                **label,
							  CORBA_char                                **hint,
							  CORBA_long                                 *accelerator_key,
							  CORBA_long                                 *ac_mods,
							  CORBA_boolean                              *toggle_state,
							  CORBA_Environment                          *ev);
void  impl_Bonobo_UIHandler_toolbar_item_set_attributes  (PortableServer_Servant                      servant,
							  const Bonobo_UIHandler                      containee,
							  const CORBA_char                           *path,
							  CORBA_boolean                               sensitive,
							  CORBA_boolean                               active,
							  CORBA_long                                  pos,
							  const CORBA_char                           *label,
							  const CORBA_char                           *hint,
							  CORBA_long                                  accelerator_key,
							  CORBA_long                                  ac_mods,
							  CORBA_boolean                               toggle_state,
							  CORBA_Environment                          *ev);
void  impl_Bonobo_UIHandler_toolbar_item_set_data        (PortableServer_Servant                      servant,
							  Bonobo_UIHandler                            containee_uih,
							  const CORBA_char                           *path,
							  Bonobo_UIHandler_PixmapType                 corba_pixmap_type,
							  const Bonobo_UIHandler_iobuf               *corba_pixmap_data,
							  CORBA_Environment                          *ev);
void  impl_Bonobo_UIHandler_toolbar_item_get_data        (PortableServer_Servant                      servant,
							  Bonobo_UIHandler                            containee_uih,
							  const CORBA_char                           *path,
							  Bonobo_UIHandler_PixmapType                *corba_pixmap_type,
							  Bonobo_UIHandler_iobuf                    **corba_pixmap_data,
							  CORBA_Environment                          *ev);
void  impl_Bonobo_UIHandler_toolbar_set_attributes       (PortableServer_Servant                      servant,
							  const Bonobo_UIHandler                      containee,
							  const CORBA_char                           *name,
							  const Bonobo_UIHandler_ToolbarOrientation   orientation,
							  const Bonobo_UIHandler_ToolbarStyle         style,
							  const Bonobo_UIHandler_ToolbarSpaceStyle    space_style,
							  const Bonobo_UIHandler_ReliefStyle          relief_style,
							  const CORBA_long                            space_size,
							  const CORBA_boolean                         sensitive,
							  CORBA_Environment                          *ev);
void  impl_Bonobo_UIHandler_toolbar_get_attributes       (PortableServer_Servant                      servant,
							  const Bonobo_UIHandler                      containee,
							  const CORBA_char                           *path,
							  Bonobo_UIHandler_ToolbarOrientation        *orientation,
							  Bonobo_UIHandler_ToolbarStyle              *style,
							  Bonobo_UIHandler_ToolbarSpaceStyle         *space_style,
							  Bonobo_UIHandler_ReliefStyle               *relief_style,
							  CORBA_long                                 *space_size,
							  CORBA_boolean                              *sensitive,
							  CORBA_Environment                          *ev);

gboolean bonobo_ui_handler_toplevel_dock_remove (BonoboUIHandler        *uih,
						 const Bonobo_UIHandler  containee,
						 const char             *name);

/*
 * Dock CORBA method implementations.
 */
CORBA_boolean  impl_Bonobo_UIHandler_dock_add            (PortableServer_Servant                servant,
							  const Bonobo_UIHandler                containee,
							  const CORBA_char                     *name,
							  const Bonobo_Control                  control,
							  const CORBA_long                      corba_behavior,
							  const Bonobo_UIHandler_DockPlacement  corba_placement,
							  const CORBA_long                      band_num,
							  const CORBA_long                      band_position,
							  const CORBA_long                      offset,
							  CORBA_Environment                    *ev);
CORBA_boolean  impl_Bonobo_UIHandler_dock_remove         (PortableServer_Servant                servant,
							  const Bonobo_UIHandler                containee,
							  const CORBA_char                     *name,
							  CORBA_Environment                    *ev);;
CORBA_boolean  impl_Bonobo_UIHandler_dock_set_sensitive  (PortableServer_Servant                servant,
							  const Bonobo_UIHandler                containee,
							  const CORBA_char                     *name,
							  const CORBA_boolean                   sensitivity,
							  CORBA_Environment                    *ev);
CORBA_boolean  impl_Bonobo_UIHandler_dock_get_sensitive  (PortableServer_Servant                servant,
							  const Bonobo_UIHandler                containee,
							  const CORBA_char                     *name,
							  CORBA_Environment                    *ev);


/*
 * CORBA does not distinguish betwen a zero-length string and a NULL
 * char pointer; everything is a zero-length string to it.  These
 * macros translate between NULL pointers and zero-length strings.
 */
#define CORBIFY_STRING(s)   ((s) == NULL ? "" : (s))
#define UNCORBIFY_STRING(s) ((strlen (s) == 0) ? NULL : (s))

#define COPY_STRING(s)      (s == NULL ? NULL : g_strdup (s))

#endif /* ! __BONOBO_UIH_PRIVATE_H__ */

