/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 c-set-style: linux -*- */

#include "bonobo-object-directory.h"
#include <libgnorba/gnorba.h>

CORBA_ORB
od_get_orb                     (void)
{
	return gnome_CORBA_ORB();
}

static gboolean
stringlist_contains (gchar **list, const gchar *word)
{
	int i = 0;
	
	if (list == NULL)
                return FALSE;
	
	while (list[i] != NULL) {
		if (strcmp (list[i], word) == 0) {
			return TRUE;
		}
		i++;
	}
	return FALSE;
}

GList *
od_get_server_list (const gchar **required_ids)
{
        GList *retval = NULL;
        GoadServerList *goad_list;
        guint i;
        guint n_required = 0;
        const gchar** iter;

        iter = required_ids;
        while (*iter) {
                ++n_required;
                
                ++iter;
        }
        
        goad_list = goad_server_list_get ();

        i = 0;

        while (goad_list && goad_list->list &&
	       goad_list->list [i].repo_id != NULL) {
                guint num = 0, j = 0;
		
		for (j = 0; j < n_required; j++) {
			if (stringlist_contains (goad_list->list [i].repo_id,
                                                 required_ids [j])) {
				num++;
			}
		}

		if (num == n_required) {  /* We have a match! */
                        ODServerInfo *info;

                        info = od_server_info_new (goad_list->list [i].server_id,
						   goad_list->list [i].description,
						   NULL);
                        retval = g_list_prepend (retval, info);
		}

                ++i;
        }

        retval = g_list_reverse (retval);

        return retval;
}

CORBA_Object
od_server_activate_with_id     (const gchar       *iid,
				gint               flags,
                                CORBA_Environment *ev)
{
        return goad_server_activate_with_id(NULL, iid, flags, NULL);
}

ODRegistrationResult
od_server_register             (CORBA_Object       objref,
                                const gchar       *iid)
{
        gint result;
        CORBA_Environment ev;

        CORBA_exception_init(&ev);
        
        result = goad_server_register(NULL, objref, iid, "server", &ev);

        CORBA_exception_free(&ev);

        switch (result) {
        case 0:
                return OD_REG_SUCCESS;
                break;

        case -2:
                return OD_REG_ALREADY_ACTIVE;
                break;

        default:
                return OD_REG_ERROR;
                break;
        }
}

ODRegistrationResult
od_server_unregister           (CORBA_Object       objref,
                                const gchar       *iid)
{
        gint result;
        CORBA_Environment ev;

        CORBA_exception_init(&ev);
        
        result = goad_server_unregister(NULL, iid, "server", &ev);

        CORBA_exception_free(&ev);
        
        if (result < 0)
                return OD_REG_ERROR;
        else
                return OD_REG_SUCCESS;
}

void
od_assert_using_goad (void)
{
        return;
}

void
od_assert_using_oaf  (void)
{
        g_warning("Your Bonobo library is compiled to use GOAD (from gnome-libs 1.0).");
	g_error("This program requires a Bonobo compiled to use OAF instead.");
        exit(1);
}

CORBA_Object
od_name_service_get (CORBA_Environment *ev)
{
	return gnome_name_service_get ();
}
