/*
 * Author:
 *   Dietmar Maurer (dietmar@maurer-it.com)
 *
 * Copyright 1999 Maurer IT Systemlsungen (http://www.maurer-it.com)
 */

#ifndef _GSHELL_H_
#define _GSHELL_H_

#include <config.h>
#include <gnome.h>
#include <bonobo.h>

typedef struct {
	BonoboUIHandler  *uih;
	GtkWidget	*app;
	GtkWidget	*vbox;
	BonoboViewFrame *active_view_frame;
	GList           *view_list;
} Frame;

typedef struct {
	BonoboClientSite   *client_site;
	BonoboObjectClient *server;
	gchar *name;
	gint menu_id;
} Buffer;

typedef struct {
	BonoboContainer  *container;
	GList *frame_list;
	GList *buffer_list;
	GtkFileSelection *fs;
} Application;

extern Application app;

void file_menu_kill_cb          (BonoboUIHandler *uih, void *data, char *path);
void view_menu_new_window_cb    (BonoboUIHandler *uih, void *data, char *path);
void view_menu_delete_window_cb (BonoboUIHandler *uih, void *data, char *path);
void view_menu_split_window_cb  (BonoboUIHandler *uih, void *data, char *path);
void view_menu_one_window_cb    (BonoboUIHandler *uih, void *data, char *path);
void file_menu_exit_cb          (BonoboUIHandler *uih, void *data, char *path);
void edit_menu_preferences_cb   (BonoboUIHandler *uih, void *data, char *path);
void help_menu_about_cb         (BonoboUIHandler *uih, void *data, char *path);
void help_menu_help_gnome_cb    (BonoboUIHandler *uih, void *data, char *path);

Frame          *get_active_frame           (GtkWidget *widget);
BonoboViewFrame *get_active_view_frame      (Frame *frame);
Buffer         *buffer_create              (const char *component_goad_id);
gint            view_remove                (Frame *frame, 
					    BonoboViewFrame *view_frame);
void            buffer_add_view            (Buffer *buffer, 
					    Frame *frame, 
					    gint pos);
gboolean        bonobo_object_has_interface (BonoboObject *obj, 
					    char *interface);
void            set_buffer_cb              (BonoboUIHandler *uih, 
					    void *buffer,  
					    const char *path);

void            open_files                 (Frame *frame,
                                            int argc, char **argv);

void            file_open                  (Frame *frame, char *name);



#endif
